// device/vr/public/mojom/xr_hand_tracking_data.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_XR_HAND_TRACKING_DATA_MOJOM_H_
#define DEVICE_VR_PUBLIC_MOJOM_XR_HAND_TRACKING_DATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-features.h"  // IWYU pragma: export
#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-shared.h"  // IWYU pragma: export
#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/mojom/transform.mojom.h"
#include <string>
#include <vector>




#include "base/component_export.h"




namespace device::mojom {









class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRHandJointData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHandJointData, T>::value>;
  using DataView = XRHandJointDataDataView;
  using Data_ = internal::XRHandJointData_Data;

  template <typename... Args>
  static XRHandJointDataPtr New(Args&&... args) {
    return XRHandJointDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHandJointDataPtr From(const U& u) {
    return mojo::TypeConverter<XRHandJointDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHandJointData>::Convert(*this);
  }


  XRHandJointData();

  XRHandJointData(
      XRHandJoint joint,
      const std::optional<::gfx::Transform>& mojo_from_joint,
      float radius);


  ~XRHandJointData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHandJointDataPtr>
  XRHandJointDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHandJointData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRHandJointData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRHandJointData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHandJointData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHandJointData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHandJointData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHandJointData_UnserializedMessageContext<
            UserType, XRHandJointData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRHandJointData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRHandJointData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHandJointData_UnserializedMessageContext<
            UserType, XRHandJointData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHandJointData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRHandJoint joint;
  
  std::optional<::gfx::Transform> mojo_from_joint;
  
  float radius;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHandJointData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHandJointData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHandJointData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHandJointData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRHandTrackingData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHandTrackingData, T>::value>;
  using DataView = XRHandTrackingDataDataView;
  using Data_ = internal::XRHandTrackingData_Data;

  template <typename... Args>
  static XRHandTrackingDataPtr New(Args&&... args) {
    return XRHandTrackingDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHandTrackingDataPtr From(const U& u) {
    return mojo::TypeConverter<XRHandTrackingDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHandTrackingData>::Convert(*this);
  }


  XRHandTrackingData();

  explicit XRHandTrackingData(
      std::vector<XRHandJointDataPtr> hand_joint_data);

XRHandTrackingData(const XRHandTrackingData&) = delete;
XRHandTrackingData& operator=(const XRHandTrackingData&) = delete;

  ~XRHandTrackingData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHandTrackingDataPtr>
  XRHandTrackingDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHandTrackingData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRHandTrackingData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRHandTrackingData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHandTrackingData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHandTrackingData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHandTrackingData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHandTrackingData_UnserializedMessageContext<
            UserType, XRHandTrackingData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRHandTrackingData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRHandTrackingData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHandTrackingData_UnserializedMessageContext<
            UserType, XRHandTrackingData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHandTrackingData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<XRHandJointDataPtr> hand_joint_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHandTrackingData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHandTrackingData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHandTrackingData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHandTrackingData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
XRHandJointDataPtr XRHandJointData::Clone() const {
  return New(
      mojo::Clone(joint),
      mojo::Clone(mojo_from_joint),
      mojo::Clone(radius)
  );
}

template <typename T, XRHandJointData::EnableIfSame<T>*>
bool XRHandJointData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->joint, other_struct.joint))
    return false;
  if (!mojo::Equals(this->mojo_from_joint, other_struct.mojo_from_joint))
    return false;
  if (!mojo::Equals(this->radius, other_struct.radius))
    return false;
  return true;
}

template <typename T, XRHandJointData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.joint < rhs.joint)
    return true;
  if (rhs.joint < lhs.joint)
    return false;
  if (lhs.mojo_from_joint < rhs.mojo_from_joint)
    return true;
  if (rhs.mojo_from_joint < lhs.mojo_from_joint)
    return false;
  if (lhs.radius < rhs.radius)
    return true;
  if (rhs.radius < lhs.radius)
    return false;
  return false;
}
template <typename StructPtrType>
XRHandTrackingDataPtr XRHandTrackingData::Clone() const {
  return New(
      mojo::Clone(hand_joint_data)
  );
}

template <typename T, XRHandTrackingData::EnableIfSame<T>*>
bool XRHandTrackingData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->hand_joint_data, other_struct.hand_joint_data))
    return false;
  return true;
}

template <typename T, XRHandTrackingData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.hand_joint_data < rhs.hand_joint_data)
    return true;
  if (rhs.hand_joint_data < lhs.hand_joint_data)
    return false;
  return false;
}


}  // device::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRHandJointData::DataView,
                                         ::device::mojom::XRHandJointDataPtr> {
  static bool IsNull(const ::device::mojom::XRHandJointDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRHandJointDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRHandJointData::joint) joint(
      const ::device::mojom::XRHandJointDataPtr& input) {
    return input->joint;
  }

  static const decltype(::device::mojom::XRHandJointData::mojo_from_joint)& mojo_from_joint(
      const ::device::mojom::XRHandJointDataPtr& input) {
    return input->mojo_from_joint;
  }

  static decltype(::device::mojom::XRHandJointData::radius) radius(
      const ::device::mojom::XRHandJointDataPtr& input) {
    return input->radius;
  }

  static bool Read(::device::mojom::XRHandJointData::DataView input, ::device::mojom::XRHandJointDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRHandTrackingData::DataView,
                                         ::device::mojom::XRHandTrackingDataPtr> {
  static bool IsNull(const ::device::mojom::XRHandTrackingDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRHandTrackingDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::XRHandTrackingData::hand_joint_data)& hand_joint_data(
      const ::device::mojom::XRHandTrackingDataPtr& input) {
    return input->hand_joint_data;
  }

  static bool Read(::device::mojom::XRHandTrackingData::DataView input, ::device::mojom::XRHandTrackingDataPtr* output);
};

}  // namespace mojo

#endif  // DEVICE_VR_PUBLIC_MOJOM_XR_HAND_TRACKING_DATA_MOJOM_H_