// device/vr/public/mojom/vr_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_TEST_UTILS_H_
#define DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_TEST_UTILS_H_

#include "device/vr/public/mojom/vr_service.mojom.h"
#include "base/component_export.h"


namespace device::mojom {


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRServiceInterceptorForTesting : public VRService {
  virtual VRService* GetForwardingInterface() = 0;
  void SetClient(::mojo::PendingRemote<VRServiceClient> client) override;
  void RequestSession(::device::mojom::XRSessionOptionsPtr options, RequestSessionCallback callback) override;
  void SupportsSession(::device::mojom::XRSessionOptionsPtr options, SupportsSessionCallback callback) override;
  void ExitPresent(ExitPresentCallback callback) override;
  void SetFramesThrottled(bool throttled) override;
  void MakeXrCompatible(MakeXrCompatibleCallback callback) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRServiceAsyncWaiter {
 public:
  explicit VRServiceAsyncWaiter(VRService* proxy);

  VRServiceAsyncWaiter(const VRServiceAsyncWaiter&) = delete;
  VRServiceAsyncWaiter& operator=(const VRServiceAsyncWaiter&) = delete;

  ~VRServiceAsyncWaiter();
  void RequestSession(
      ::device::mojom::XRSessionOptionsPtr options, RequestSessionResultPtr* out_result);
  RequestSessionResultPtr RequestSession(::device::mojom::XRSessionOptionsPtr options);
  void SupportsSession(
      ::device::mojom::XRSessionOptionsPtr options, bool* out_supports_session);
  bool SupportsSession(::device::mojom::XRSessionOptionsPtr options);
  void ExitPresent(
      );
  
  void MakeXrCompatible(
      XrCompatibleResult* out_xr_compatible_result);
  XrCompatibleResult MakeXrCompatible();

 private:
  VRService* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSessionMetricsRecorderInterceptorForTesting : public XRSessionMetricsRecorder {
  virtual XRSessionMetricsRecorder* GetForwardingInterface() = 0;
  void ReportFeatureUsed(::device::mojom::XRSessionFeature feature) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSessionMetricsRecorderAsyncWaiter {
 public:
  explicit XRSessionMetricsRecorderAsyncWaiter(XRSessionMetricsRecorder* proxy);

  XRSessionMetricsRecorderAsyncWaiter(const XRSessionMetricsRecorderAsyncWaiter&) = delete;
  XRSessionMetricsRecorderAsyncWaiter& operator=(const XRSessionMetricsRecorderAsyncWaiter&) = delete;

  ~XRSessionMetricsRecorderAsyncWaiter();

 private:
  XRSessionMetricsRecorder* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRServiceClientInterceptorForTesting : public VRServiceClient {
  virtual VRServiceClient* GetForwardingInterface() = 0;
  void OnDeviceChanged() override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRServiceClientAsyncWaiter {
 public:
  explicit VRServiceClientAsyncWaiter(VRServiceClient* proxy);

  VRServiceClientAsyncWaiter(const VRServiceClientAsyncWaiter&) = delete;
  VRServiceClientAsyncWaiter& operator=(const VRServiceClientAsyncWaiter&) = delete;

  ~VRServiceClientAsyncWaiter();

 private:
  VRServiceClient* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XREnvironmentIntegrationProviderInterceptorForTesting : public XREnvironmentIntegrationProvider {
  virtual XREnvironmentIntegrationProvider* GetForwardingInterface() = 0;
  void SubscribeToHitTest(XRNativeOriginInformationPtr native_origin_information, const std::vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestCallback callback) override;
  void SubscribeToHitTestForTransientInput(const std::string& profile_name, const std::vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestForTransientInputCallback callback) override;
  void UnsubscribeFromHitTest(const ::device::HitTestSubscriptionId& subscription_id) override;
  void CreateAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, const std::optional<::device::PlaneId>& plane_id, CreateAnchorCallback callback) override;
  void DetachAnchor(const ::device::AnchorId& anchor_id) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XREnvironmentIntegrationProviderAsyncWaiter {
 public:
  explicit XREnvironmentIntegrationProviderAsyncWaiter(XREnvironmentIntegrationProvider* proxy);

  XREnvironmentIntegrationProviderAsyncWaiter(const XREnvironmentIntegrationProviderAsyncWaiter&) = delete;
  XREnvironmentIntegrationProviderAsyncWaiter& operator=(const XREnvironmentIntegrationProviderAsyncWaiter&) = delete;

  ~XREnvironmentIntegrationProviderAsyncWaiter();
  void SubscribeToHitTest(
      XRNativeOriginInformationPtr native_origin_information, const std::vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, std::optional<::device::HitTestSubscriptionId>* out_subscription_id);
  std::optional<::device::HitTestSubscriptionId> SubscribeToHitTest(XRNativeOriginInformationPtr native_origin_information, const std::vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray);
  void SubscribeToHitTestForTransientInput(
      const std::string& profile_name, const std::vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, std::optional<::device::HitTestSubscriptionId>* out_subscription_id);
  std::optional<::device::HitTestSubscriptionId> SubscribeToHitTestForTransientInput(const std::string& profile_name, const std::vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray);
  void CreateAnchor(
      XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, const std::optional<::device::PlaneId>& plane_id, std::optional<::device::AnchorId>* out_anchor_id);
  std::optional<::device::AnchorId> CreateAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, const std::optional<::device::PlaneId>& plane_id);

 private:
  XREnvironmentIntegrationProvider* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRFrameDataProviderInterceptorForTesting : public XRFrameDataProvider {
  virtual XRFrameDataProvider* GetForwardingInterface() = 0;
  void GetFrameData(XRFrameDataRequestOptionsPtr options, GetFrameDataCallback callback) override;
  void GetEnvironmentIntegrationProvider(::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> environment_provider) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRFrameDataProviderAsyncWaiter {
 public:
  explicit XRFrameDataProviderAsyncWaiter(XRFrameDataProvider* proxy);

  XRFrameDataProviderAsyncWaiter(const XRFrameDataProviderAsyncWaiter&) = delete;
  XRFrameDataProviderAsyncWaiter& operator=(const XRFrameDataProviderAsyncWaiter&) = delete;

  ~XRFrameDataProviderAsyncWaiter();
  void GetFrameData(
      XRFrameDataRequestOptionsPtr options, XRFrameDataPtr* out_frame_data);
  XRFrameDataPtr GetFrameData(XRFrameDataRequestOptionsPtr options);

 private:
  XRFrameDataProvider* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationProviderInterceptorForTesting : public XRPresentationProvider {
  virtual XRPresentationProvider* GetForwardingInterface() = 0;
  void UpdateLayerBounds(int16_t frame_id, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, const ::gfx::Size& source_size) override;
  void SubmitFrameMissing(int16_t frame_id, const ::gpu::SyncToken& sync_token) override;
  void SubmitFrame(int16_t frame_id, const ::gpu::MailboxHolder& mailbox_holder, ::base::TimeDelta time_waited) override;
  void SubmitFrameDrawnIntoTexture(int16_t frameId, const ::gpu::SyncToken& sync_token, ::base::TimeDelta time_waited) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationProviderAsyncWaiter {
 public:
  explicit XRPresentationProviderAsyncWaiter(XRPresentationProvider* proxy);

  XRPresentationProviderAsyncWaiter(const XRPresentationProviderAsyncWaiter&) = delete;
  XRPresentationProviderAsyncWaiter& operator=(const XRPresentationProviderAsyncWaiter&) = delete;

  ~XRPresentationProviderAsyncWaiter();

 private:
  XRPresentationProvider* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationClientInterceptorForTesting : public XRPresentationClient {
  virtual XRPresentationClient* GetForwardingInterface() = 0;
  void OnSubmitFrameTransferred(bool success) override;
  void OnSubmitFrameRendered() override;
  void OnSubmitFrameGpuFence(::gfx::GpuFenceHandle gpu_fence_handle) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationClientAsyncWaiter {
 public:
  explicit XRPresentationClientAsyncWaiter(XRPresentationClient* proxy);

  XRPresentationClientAsyncWaiter(const XRPresentationClientAsyncWaiter&) = delete;
  XRPresentationClientAsyncWaiter& operator=(const XRPresentationClientAsyncWaiter&) = delete;

  ~XRPresentationClientAsyncWaiter();

 private:
  XRPresentationClient* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSessionClientInterceptorForTesting : public XRSessionClient {
  virtual XRSessionClient* GetForwardingInterface() = 0;
  void OnExitPresent() override;
  void OnVisibilityStateChanged(XRVisibilityState visibility_state) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSessionClientAsyncWaiter {
 public:
  explicit XRSessionClientAsyncWaiter(XRSessionClient* proxy);

  XRSessionClientAsyncWaiter(const XRSessionClientAsyncWaiter&) = delete;
  XRSessionClientAsyncWaiter& operator=(const XRSessionClientAsyncWaiter&) = delete;

  ~XRSessionClientAsyncWaiter();

 private:
  XRSessionClient* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) WebXrInternalsRendererListenerInterceptorForTesting : public WebXrInternalsRendererListener {
  virtual WebXrInternalsRendererListener* GetForwardingInterface() = 0;
  void OnFrameData(::device::mojom::XrFrameStatisticsPtr xrframe_statistics) override;
  void OnConsoleLog(::device::mojom::XrLogMessagePtr xrlogging_statistics) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) WebXrInternalsRendererListenerAsyncWaiter {
 public:
  explicit WebXrInternalsRendererListenerAsyncWaiter(WebXrInternalsRendererListener* proxy);

  WebXrInternalsRendererListenerAsyncWaiter(const WebXrInternalsRendererListenerAsyncWaiter&) = delete;
  WebXrInternalsRendererListenerAsyncWaiter& operator=(const WebXrInternalsRendererListenerAsyncWaiter&) = delete;

  ~WebXrInternalsRendererListenerAsyncWaiter();

 private:
  WebXrInternalsRendererListener* const proxy_;
};




}  // device::mojom

#endif  // DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_TEST_UTILS_H_