// device/vr/public/mojom/vr_service.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_PARAMS_DATA_H_
#define DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace device::mojom {
namespace internal {
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) VRService_SetClient_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data client;

 private:
  friend class mojo::internal::MessageFragment<VRService_SetClient_Params_Data>;

  VRService_SetClient_Params_Data();
  ~VRService_SetClient_Params_Data() = delete;
};
static_assert(sizeof(VRService_SetClient_Params_Data) == 16,
              "Bad sizeof(VRService_SetClient_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) VRService_RequestSession_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::device::mojom::internal::XRSessionOptions_Data> options;

 private:
  friend class mojo::internal::MessageFragment<VRService_RequestSession_Params_Data>;

  VRService_RequestSession_Params_Data();
  ~VRService_RequestSession_Params_Data() = delete;
};
static_assert(sizeof(VRService_RequestSession_Params_Data) == 16,
              "Bad sizeof(VRService_RequestSession_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) VRService_RequestSession_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::RequestSessionResult_Data result;

 private:
  friend class mojo::internal::MessageFragment<VRService_RequestSession_ResponseParams_Data>;

  VRService_RequestSession_ResponseParams_Data();
  ~VRService_RequestSession_ResponseParams_Data() = delete;
};
static_assert(sizeof(VRService_RequestSession_ResponseParams_Data) == 24,
              "Bad sizeof(VRService_RequestSession_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) VRService_SupportsSession_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::device::mojom::internal::XRSessionOptions_Data> options;

 private:
  friend class mojo::internal::MessageFragment<VRService_SupportsSession_Params_Data>;

  VRService_SupportsSession_Params_Data();
  ~VRService_SupportsSession_Params_Data() = delete;
};
static_assert(sizeof(VRService_SupportsSession_Params_Data) == 16,
              "Bad sizeof(VRService_SupportsSession_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) VRService_SupportsSession_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t supports_session : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<VRService_SupportsSession_ResponseParams_Data>;

  VRService_SupportsSession_ResponseParams_Data();
  ~VRService_SupportsSession_ResponseParams_Data() = delete;
};
static_assert(sizeof(VRService_SupportsSession_ResponseParams_Data) == 16,
              "Bad sizeof(VRService_SupportsSession_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) VRService_ExitPresent_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<VRService_ExitPresent_Params_Data>;

  VRService_ExitPresent_Params_Data();
  ~VRService_ExitPresent_Params_Data() = delete;
};
static_assert(sizeof(VRService_ExitPresent_Params_Data) == 8,
              "Bad sizeof(VRService_ExitPresent_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) VRService_ExitPresent_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<VRService_ExitPresent_ResponseParams_Data>;

  VRService_ExitPresent_ResponseParams_Data();
  ~VRService_ExitPresent_ResponseParams_Data() = delete;
};
static_assert(sizeof(VRService_ExitPresent_ResponseParams_Data) == 8,
              "Bad sizeof(VRService_ExitPresent_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) VRService_SetFramesThrottled_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t throttled : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<VRService_SetFramesThrottled_Params_Data>;

  VRService_SetFramesThrottled_Params_Data();
  ~VRService_SetFramesThrottled_Params_Data() = delete;
};
static_assert(sizeof(VRService_SetFramesThrottled_Params_Data) == 16,
              "Bad sizeof(VRService_SetFramesThrottled_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) VRService_MakeXrCompatible_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<VRService_MakeXrCompatible_Params_Data>;

  VRService_MakeXrCompatible_Params_Data();
  ~VRService_MakeXrCompatible_Params_Data() = delete;
};
static_assert(sizeof(VRService_MakeXrCompatible_Params_Data) == 8,
              "Bad sizeof(VRService_MakeXrCompatible_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) VRService_MakeXrCompatible_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t xr_compatible_result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<VRService_MakeXrCompatible_ResponseParams_Data>;

  VRService_MakeXrCompatible_ResponseParams_Data();
  ~VRService_MakeXrCompatible_ResponseParams_Data() = delete;
};
static_assert(sizeof(VRService_MakeXrCompatible_ResponseParams_Data) == 16,
              "Bad sizeof(VRService_MakeXrCompatible_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t feature;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data>;

  XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data();
  ~XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data() = delete;
};
static_assert(sizeof(XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data) == 16,
              "Bad sizeof(XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) VRServiceClient_OnDeviceChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<VRServiceClient_OnDeviceChanged_Params_Data>;

  VRServiceClient_OnDeviceChanged_Params_Data();
  ~VRServiceClient_OnDeviceChanged_Params_Data() = delete;
};
static_assert(sizeof(VRServiceClient_OnDeviceChanged_Params_Data) == 8,
              "Bad sizeof(VRServiceClient_OnDeviceChanged_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::XRNativeOriginInformation_Data native_origin_information;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> entity_types;
  mojo::internal::Pointer<internal::XRRay_Data> ray;

 private:
  friend class mojo::internal::MessageFragment<XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data>;

  XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data();
  ~XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data() = delete;
};
static_assert(sizeof(XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data) == 40,
              "Bad sizeof(XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::HitTestSubscriptionId_Data> subscription_id;

 private:
  friend class mojo::internal::MessageFragment<XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data>;

  XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data();
  ~XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data() = delete;
};
static_assert(sizeof(XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data) == 16,
              "Bad sizeof(XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> profile_name;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> entity_types;
  mojo::internal::Pointer<internal::XRRay_Data> ray;

 private:
  friend class mojo::internal::MessageFragment<XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data>;

  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data();
  ~XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data() = delete;
};
static_assert(sizeof(XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data) == 32,
              "Bad sizeof(XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::HitTestSubscriptionId_Data> subscription_id;

 private:
  friend class mojo::internal::MessageFragment<XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data>;

  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data();
  ~XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data() = delete;
};
static_assert(sizeof(XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data) == 16,
              "Bad sizeof(XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::HitTestSubscriptionId_Data> subscription_id;

 private:
  friend class mojo::internal::MessageFragment<XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data>;

  XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data();
  ~XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data() = delete;
};
static_assert(sizeof(XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data) == 16,
              "Bad sizeof(XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XREnvironmentIntegrationProvider_CreateAnchor_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::XRNativeOriginInformation_Data native_origin_information;
  mojo::internal::Pointer<internal::Pose_Data> native_origin_from_anchor;
  mojo::internal::Pointer<internal::PlaneId_Data> plane_id;

 private:
  friend class mojo::internal::MessageFragment<XREnvironmentIntegrationProvider_CreateAnchor_Params_Data>;

  XREnvironmentIntegrationProvider_CreateAnchor_Params_Data();
  ~XREnvironmentIntegrationProvider_CreateAnchor_Params_Data() = delete;
};
static_assert(sizeof(XREnvironmentIntegrationProvider_CreateAnchor_Params_Data) == 40,
              "Bad sizeof(XREnvironmentIntegrationProvider_CreateAnchor_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::AnchorId_Data> anchor_id;

 private:
  friend class mojo::internal::MessageFragment<XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data>;

  XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data();
  ~XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data() = delete;
};
static_assert(sizeof(XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data) == 16,
              "Bad sizeof(XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XREnvironmentIntegrationProvider_DetachAnchor_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::AnchorId_Data> anchor_id;

 private:
  friend class mojo::internal::MessageFragment<XREnvironmentIntegrationProvider_DetachAnchor_Params_Data>;

  XREnvironmentIntegrationProvider_DetachAnchor_Params_Data();
  ~XREnvironmentIntegrationProvider_DetachAnchor_Params_Data() = delete;
};
static_assert(sizeof(XREnvironmentIntegrationProvider_DetachAnchor_Params_Data) == 16,
              "Bad sizeof(XREnvironmentIntegrationProvider_DetachAnchor_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XRFrameDataProvider_GetFrameData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::XRFrameDataRequestOptions_Data> options;

 private:
  friend class mojo::internal::MessageFragment<XRFrameDataProvider_GetFrameData_Params_Data>;

  XRFrameDataProvider_GetFrameData_Params_Data();
  ~XRFrameDataProvider_GetFrameData_Params_Data() = delete;
};
static_assert(sizeof(XRFrameDataProvider_GetFrameData_Params_Data) == 16,
              "Bad sizeof(XRFrameDataProvider_GetFrameData_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XRFrameDataProvider_GetFrameData_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::XRFrameData_Data> frame_data;

 private:
  friend class mojo::internal::MessageFragment<XRFrameDataProvider_GetFrameData_ResponseParams_Data>;

  XRFrameDataProvider_GetFrameData_ResponseParams_Data();
  ~XRFrameDataProvider_GetFrameData_ResponseParams_Data() = delete;
};
static_assert(sizeof(XRFrameDataProvider_GetFrameData_ResponseParams_Data) == 16,
              "Bad sizeof(XRFrameDataProvider_GetFrameData_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedEndpointHandle_Data environment_provider;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data>;

  XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data();
  ~XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data() = delete;
};
static_assert(sizeof(XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data) == 16,
              "Bad sizeof(XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XRPresentationProvider_UpdateLayerBounds_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int16_t frame_id;
  uint8_t pad0_[6];
  mojo::internal::Pointer<::gfx::mojom::internal::RectF_Data> left_bounds;
  mojo::internal::Pointer<::gfx::mojom::internal::RectF_Data> right_bounds;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> source_size;

 private:
  friend class mojo::internal::MessageFragment<XRPresentationProvider_UpdateLayerBounds_Params_Data>;

  XRPresentationProvider_UpdateLayerBounds_Params_Data();
  ~XRPresentationProvider_UpdateLayerBounds_Params_Data() = delete;
};
static_assert(sizeof(XRPresentationProvider_UpdateLayerBounds_Params_Data) == 40,
              "Bad sizeof(XRPresentationProvider_UpdateLayerBounds_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XRPresentationProvider_SubmitFrameMissing_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int16_t frame_id;
  uint8_t pad0_[6];
  mojo::internal::Pointer<::gpu::mojom::internal::SyncToken_Data> sync_token;

 private:
  friend class mojo::internal::MessageFragment<XRPresentationProvider_SubmitFrameMissing_Params_Data>;

  XRPresentationProvider_SubmitFrameMissing_Params_Data();
  ~XRPresentationProvider_SubmitFrameMissing_Params_Data() = delete;
};
static_assert(sizeof(XRPresentationProvider_SubmitFrameMissing_Params_Data) == 24,
              "Bad sizeof(XRPresentationProvider_SubmitFrameMissing_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XRPresentationProvider_SubmitFrame_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int16_t frame_id;
  uint8_t pad0_[6];
  mojo::internal::Pointer<::gpu::mojom::internal::MailboxHolder_Data> mailbox_holder;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> time_waited;

 private:
  friend class mojo::internal::MessageFragment<XRPresentationProvider_SubmitFrame_Params_Data>;

  XRPresentationProvider_SubmitFrame_Params_Data();
  ~XRPresentationProvider_SubmitFrame_Params_Data() = delete;
};
static_assert(sizeof(XRPresentationProvider_SubmitFrame_Params_Data) == 32,
              "Bad sizeof(XRPresentationProvider_SubmitFrame_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int16_t frameId;
  uint8_t pad0_[6];
  mojo::internal::Pointer<::gpu::mojom::internal::SyncToken_Data> sync_token;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> time_waited;

 private:
  friend class mojo::internal::MessageFragment<XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data>;

  XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data();
  ~XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data() = delete;
};
static_assert(sizeof(XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data) == 32,
              "Bad sizeof(XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XRPresentationClient_OnSubmitFrameTransferred_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<XRPresentationClient_OnSubmitFrameTransferred_Params_Data>;

  XRPresentationClient_OnSubmitFrameTransferred_Params_Data();
  ~XRPresentationClient_OnSubmitFrameTransferred_Params_Data() = delete;
};
static_assert(sizeof(XRPresentationClient_OnSubmitFrameTransferred_Params_Data) == 16,
              "Bad sizeof(XRPresentationClient_OnSubmitFrameTransferred_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XRPresentationClient_OnSubmitFrameRendered_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<XRPresentationClient_OnSubmitFrameRendered_Params_Data>;

  XRPresentationClient_OnSubmitFrameRendered_Params_Data();
  ~XRPresentationClient_OnSubmitFrameRendered_Params_Data() = delete;
};
static_assert(sizeof(XRPresentationClient_OnSubmitFrameRendered_Params_Data) == 8,
              "Bad sizeof(XRPresentationClient_OnSubmitFrameRendered_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XRPresentationClient_OnSubmitFrameGpuFence_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::GpuFenceHandle_Data> gpu_fence_handle;

 private:
  friend class mojo::internal::MessageFragment<XRPresentationClient_OnSubmitFrameGpuFence_Params_Data>;

  XRPresentationClient_OnSubmitFrameGpuFence_Params_Data();
  ~XRPresentationClient_OnSubmitFrameGpuFence_Params_Data() = delete;
};
static_assert(sizeof(XRPresentationClient_OnSubmitFrameGpuFence_Params_Data) == 16,
              "Bad sizeof(XRPresentationClient_OnSubmitFrameGpuFence_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XRSessionClient_OnExitPresent_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<XRSessionClient_OnExitPresent_Params_Data>;

  XRSessionClient_OnExitPresent_Params_Data();
  ~XRSessionClient_OnExitPresent_Params_Data() = delete;
};
static_assert(sizeof(XRSessionClient_OnExitPresent_Params_Data) == 8,
              "Bad sizeof(XRSessionClient_OnExitPresent_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) XRSessionClient_OnVisibilityStateChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t visibility_state;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<XRSessionClient_OnVisibilityStateChanged_Params_Data>;

  XRSessionClient_OnVisibilityStateChanged_Params_Data();
  ~XRSessionClient_OnVisibilityStateChanged_Params_Data() = delete;
};
static_assert(sizeof(XRSessionClient_OnVisibilityStateChanged_Params_Data) == 16,
              "Bad sizeof(XRSessionClient_OnVisibilityStateChanged_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) WebXrInternalsRendererListener_OnFrameData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::device::mojom::internal::XrFrameStatistics_Data> xrframe_statistics;

 private:
  friend class mojo::internal::MessageFragment<WebXrInternalsRendererListener_OnFrameData_Params_Data>;

  WebXrInternalsRendererListener_OnFrameData_Params_Data();
  ~WebXrInternalsRendererListener_OnFrameData_Params_Data() = delete;
};
static_assert(sizeof(WebXrInternalsRendererListener_OnFrameData_Params_Data) == 16,
              "Bad sizeof(WebXrInternalsRendererListener_OnFrameData_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) WebXrInternalsRendererListener_OnConsoleLog_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::device::mojom::internal::XrLogMessage_Data> xrlogging_statistics;

 private:
  friend class mojo::internal::MessageFragment<WebXrInternalsRendererListener_OnConsoleLog_Params_Data>;

  WebXrInternalsRendererListener_OnConsoleLog_Params_Data();
  ~WebXrInternalsRendererListener_OnConsoleLog_Params_Data() = delete;
};
static_assert(sizeof(WebXrInternalsRendererListener_OnConsoleLog_Params_Data) == 16,
              "Bad sizeof(WebXrInternalsRendererListener_OnConsoleLog_Params_Data)");

}  // namespace internal


class VRService_SetClient_ParamsDataView {
 public:
  VRService_SetClient_ParamsDataView() = default;

  VRService_SetClient_ParamsDataView(
      internal::VRService_SetClient_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::VRServiceClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::VRService_SetClient_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VRService_RequestSession_ParamsDataView {
 public:
  VRService_RequestSession_ParamsDataView() = default;

  VRService_RequestSession_ParamsDataView(
      internal::VRService_RequestSession_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOptionsDataView(
      ::device::mojom::XRSessionOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::device::mojom::XRSessionOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::VRService_RequestSession_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VRService_RequestSession_ResponseParamsDataView {
 public:
  VRService_RequestSession_ResponseParamsDataView() = default;

  VRService_RequestSession_ResponseParamsDataView(
      internal::VRService_RequestSession_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      RequestSessionResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::device::mojom::RequestSessionResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::VRService_RequestSession_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VRService_SupportsSession_ParamsDataView {
 public:
  VRService_SupportsSession_ParamsDataView() = default;

  VRService_SupportsSession_ParamsDataView(
      internal::VRService_SupportsSession_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOptionsDataView(
      ::device::mojom::XRSessionOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::device::mojom::XRSessionOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::VRService_SupportsSession_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VRService_SupportsSession_ResponseParamsDataView {
 public:
  VRService_SupportsSession_ResponseParamsDataView() = default;

  VRService_SupportsSession_ResponseParamsDataView(
      internal::VRService_SupportsSession_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool supports_session() const {
    return data_->supports_session;
  }
 private:
  internal::VRService_SupportsSession_ResponseParams_Data* data_ = nullptr;
};


class VRService_ExitPresent_ParamsDataView {
 public:
  VRService_ExitPresent_ParamsDataView() = default;

  VRService_ExitPresent_ParamsDataView(
      internal::VRService_ExitPresent_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VRService_ExitPresent_Params_Data* data_ = nullptr;
};


class VRService_ExitPresent_ResponseParamsDataView {
 public:
  VRService_ExitPresent_ResponseParamsDataView() = default;

  VRService_ExitPresent_ResponseParamsDataView(
      internal::VRService_ExitPresent_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VRService_ExitPresent_ResponseParams_Data* data_ = nullptr;
};


class VRService_SetFramesThrottled_ParamsDataView {
 public:
  VRService_SetFramesThrottled_ParamsDataView() = default;

  VRService_SetFramesThrottled_ParamsDataView(
      internal::VRService_SetFramesThrottled_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool throttled() const {
    return data_->throttled;
  }
 private:
  internal::VRService_SetFramesThrottled_Params_Data* data_ = nullptr;
};


class VRService_MakeXrCompatible_ParamsDataView {
 public:
  VRService_MakeXrCompatible_ParamsDataView() = default;

  VRService_MakeXrCompatible_ParamsDataView(
      internal::VRService_MakeXrCompatible_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VRService_MakeXrCompatible_Params_Data* data_ = nullptr;
};


class VRService_MakeXrCompatible_ResponseParamsDataView {
 public:
  VRService_MakeXrCompatible_ResponseParamsDataView() = default;

  VRService_MakeXrCompatible_ResponseParamsDataView(
      internal::VRService_MakeXrCompatible_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadXrCompatibleResult(UserType* output) const {
    auto data_value = data_->xr_compatible_result;
    return mojo::internal::Deserialize<::device::mojom::XrCompatibleResult>(
        data_value, output);
  }
  XrCompatibleResult xr_compatible_result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XrCompatibleResult>(data_->xr_compatible_result));
  }
 private:
  internal::VRService_MakeXrCompatible_ResponseParams_Data* data_ = nullptr;
};


class XRSessionMetricsRecorder_ReportFeatureUsed_ParamsDataView {
 public:
  XRSessionMetricsRecorder_ReportFeatureUsed_ParamsDataView() = default;

  XRSessionMetricsRecorder_ReportFeatureUsed_ParamsDataView(
      internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadFeature(UserType* output) const {
    auto data_value = data_->feature;
    return mojo::internal::Deserialize<::device::mojom::XRSessionFeature>(
        data_value, output);
  }
  ::device::mojom::XRSessionFeature feature() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRSessionFeature>(data_->feature));
  }
 private:
  internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data* data_ = nullptr;
};


class VRServiceClient_OnDeviceChanged_ParamsDataView {
 public:
  VRServiceClient_OnDeviceChanged_ParamsDataView() = default;

  VRServiceClient_OnDeviceChanged_ParamsDataView(
      internal::VRServiceClient_OnDeviceChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VRServiceClient_OnDeviceChanged_Params_Data* data_ = nullptr;
};


class XREnvironmentIntegrationProvider_SubscribeToHitTest_ParamsDataView {
 public:
  XREnvironmentIntegrationProvider_SubscribeToHitTest_ParamsDataView() = default;

  XREnvironmentIntegrationProvider_SubscribeToHitTest_ParamsDataView(
      internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNativeOriginInformationDataView(
      XRNativeOriginInformationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNativeOriginInformation(UserType* output) {
    
    auto* pointer = !data_->native_origin_information.is_null() ? &data_->native_origin_information : nullptr;
    return mojo::internal::Deserialize<::device::mojom::XRNativeOriginInformationDataView>(
        pointer, output, message_);
  }
  inline void GetEntityTypesDataView(
      mojo::ArrayDataView<EntityTypeForHitTest>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEntityTypes(UserType* output) {
    
    auto* pointer = data_->entity_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::EntityTypeForHitTest>>(
        pointer, output, message_);
  }
  inline void GetRayDataView(
      XRRayDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRay(UserType* output) {
    
    auto* pointer = data_->ray.Get();
    return mojo::internal::Deserialize<::device::mojom::XRRayDataView>(
        pointer, output, message_);
  }
 private:
  internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParamsDataView {
 public:
  XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParamsDataView() = default;

  XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParamsDataView(
      internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSubscriptionIdDataView(
      HitTestSubscriptionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubscriptionId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::HitTestSubscriptionIdDataView, UserType>(),
    "Attempting to read the optional `subscription_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubscriptionId` instead "
    "of `ReadSubscriptionId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subscription_id.Get();
    return mojo::internal::Deserialize<::device::mojom::HitTestSubscriptionIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ParamsDataView {
 public:
  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ParamsDataView() = default;

  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ParamsDataView(
      internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProfileNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProfileName(UserType* output) {
    
    auto* pointer = data_->profile_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEntityTypesDataView(
      mojo::ArrayDataView<EntityTypeForHitTest>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEntityTypes(UserType* output) {
    
    auto* pointer = data_->entity_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::EntityTypeForHitTest>>(
        pointer, output, message_);
  }
  inline void GetRayDataView(
      XRRayDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRay(UserType* output) {
    
    auto* pointer = data_->ray.Get();
    return mojo::internal::Deserialize<::device::mojom::XRRayDataView>(
        pointer, output, message_);
  }
 private:
  internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParamsDataView {
 public:
  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParamsDataView() = default;

  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParamsDataView(
      internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSubscriptionIdDataView(
      HitTestSubscriptionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubscriptionId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::HitTestSubscriptionIdDataView, UserType>(),
    "Attempting to read the optional `subscription_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubscriptionId` instead "
    "of `ReadSubscriptionId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subscription_id.Get();
    return mojo::internal::Deserialize<::device::mojom::HitTestSubscriptionIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_ParamsDataView {
 public:
  XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_ParamsDataView() = default;

  XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_ParamsDataView(
      internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSubscriptionIdDataView(
      HitTestSubscriptionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubscriptionId(UserType* output) {
    
    auto* pointer = data_->subscription_id.Get();
    return mojo::internal::Deserialize<::device::mojom::HitTestSubscriptionIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XREnvironmentIntegrationProvider_CreateAnchor_ParamsDataView {
 public:
  XREnvironmentIntegrationProvider_CreateAnchor_ParamsDataView() = default;

  XREnvironmentIntegrationProvider_CreateAnchor_ParamsDataView(
      internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNativeOriginInformationDataView(
      XRNativeOriginInformationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNativeOriginInformation(UserType* output) {
    
    auto* pointer = !data_->native_origin_information.is_null() ? &data_->native_origin_information : nullptr;
    return mojo::internal::Deserialize<::device::mojom::XRNativeOriginInformationDataView>(
        pointer, output, message_);
  }
  inline void GetNativeOriginFromAnchorDataView(
      PoseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNativeOriginFromAnchor(UserType* output) {
    
    auto* pointer = data_->native_origin_from_anchor.Get();
    return mojo::internal::Deserialize<::device::mojom::PoseDataView>(
        pointer, output, message_);
  }
  inline void GetPlaneIdDataView(
      PlaneIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlaneId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::PlaneIdDataView, UserType>(),
    "Attempting to read the optional `plane_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPlaneId` instead "
    "of `ReadPlaneId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->plane_id.Get();
    return mojo::internal::Deserialize<::device::mojom::PlaneIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XREnvironmentIntegrationProvider_CreateAnchor_ResponseParamsDataView {
 public:
  XREnvironmentIntegrationProvider_CreateAnchor_ResponseParamsDataView() = default;

  XREnvironmentIntegrationProvider_CreateAnchor_ResponseParamsDataView(
      internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAnchorIdDataView(
      AnchorIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnchorId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::AnchorIdDataView, UserType>(),
    "Attempting to read the optional `anchor_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnchorId` instead "
    "of `ReadAnchorId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->anchor_id.Get();
    return mojo::internal::Deserialize<::device::mojom::AnchorIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XREnvironmentIntegrationProvider_DetachAnchor_ParamsDataView {
 public:
  XREnvironmentIntegrationProvider_DetachAnchor_ParamsDataView() = default;

  XREnvironmentIntegrationProvider_DetachAnchor_ParamsDataView(
      internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAnchorIdDataView(
      AnchorIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnchorId(UserType* output) {
    
    auto* pointer = data_->anchor_id.Get();
    return mojo::internal::Deserialize<::device::mojom::AnchorIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRFrameDataProvider_GetFrameData_ParamsDataView {
 public:
  XRFrameDataProvider_GetFrameData_ParamsDataView() = default;

  XRFrameDataProvider_GetFrameData_ParamsDataView(
      internal::XRFrameDataProvider_GetFrameData_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOptionsDataView(
      XRFrameDataRequestOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRFrameDataRequestOptionsDataView, UserType>(),
    "Attempting to read the optional `options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOptions` instead "
    "of `ReadOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::device::mojom::XRFrameDataRequestOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRFrameDataProvider_GetFrameData_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRFrameDataProvider_GetFrameData_ResponseParamsDataView {
 public:
  XRFrameDataProvider_GetFrameData_ResponseParamsDataView() = default;

  XRFrameDataProvider_GetFrameData_ResponseParamsDataView(
      internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameDataDataView(
      XRFrameDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRFrameDataDataView, UserType>(),
    "Attempting to read the optional `frame_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameData` instead "
    "of `ReadFrameData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRFrameDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRFrameDataProvider_GetEnvironmentIntegrationProvider_ParamsDataView {
 public:
  XRFrameDataProvider_GetEnvironmentIntegrationProvider_ParamsDataView() = default;

  XRFrameDataProvider_GetEnvironmentIntegrationProvider_ParamsDataView(
      internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeEnvironmentProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::device::mojom::XREnvironmentIntegrationProviderAssociatedRequestDataView>(
            &data_->environment_provider, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRPresentationProvider_UpdateLayerBounds_ParamsDataView {
 public:
  XRPresentationProvider_UpdateLayerBounds_ParamsDataView() = default;

  XRPresentationProvider_UpdateLayerBounds_ParamsDataView(
      internal::XRPresentationProvider_UpdateLayerBounds_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int16_t frame_id() const {
    return data_->frame_id;
  }
  inline void GetLeftBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLeftBounds(UserType* output) {
    
    auto* pointer = data_->left_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetRightBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRightBounds(UserType* output) {
    
    auto* pointer = data_->right_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetSourceSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceSize(UserType* output) {
    
    auto* pointer = data_->source_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRPresentationProvider_UpdateLayerBounds_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRPresentationProvider_SubmitFrameMissing_ParamsDataView {
 public:
  XRPresentationProvider_SubmitFrameMissing_ParamsDataView() = default;

  XRPresentationProvider_SubmitFrameMissing_ParamsDataView(
      internal::XRPresentationProvider_SubmitFrameMissing_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int16_t frame_id() const {
    return data_->frame_id;
  }
  inline void GetSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncToken(UserType* output) {
    
    auto* pointer = data_->sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRPresentationProvider_SubmitFrameMissing_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRPresentationProvider_SubmitFrame_ParamsDataView {
 public:
  XRPresentationProvider_SubmitFrame_ParamsDataView() = default;

  XRPresentationProvider_SubmitFrame_ParamsDataView(
      internal::XRPresentationProvider_SubmitFrame_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int16_t frame_id() const {
    return data_->frame_id;
  }
  inline void GetMailboxHolderDataView(
      ::gpu::mojom::MailboxHolderDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailboxHolder(UserType* output) {
    
    auto* pointer = data_->mailbox_holder.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxHolderDataView>(
        pointer, output, message_);
  }
  inline void GetTimeWaitedDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeWaited(UserType* output) {
    
    auto* pointer = data_->time_waited.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRPresentationProvider_SubmitFrame_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRPresentationProvider_SubmitFrameDrawnIntoTexture_ParamsDataView {
 public:
  XRPresentationProvider_SubmitFrameDrawnIntoTexture_ParamsDataView() = default;

  XRPresentationProvider_SubmitFrameDrawnIntoTexture_ParamsDataView(
      internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int16_t frameId() const {
    return data_->frameId;
  }
  inline void GetSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncToken(UserType* output) {
    
    auto* pointer = data_->sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  inline void GetTimeWaitedDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeWaited(UserType* output) {
    
    auto* pointer = data_->time_waited.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRPresentationClient_OnSubmitFrameTransferred_ParamsDataView {
 public:
  XRPresentationClient_OnSubmitFrameTransferred_ParamsDataView() = default;

  XRPresentationClient_OnSubmitFrameTransferred_ParamsDataView(
      internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data* data_ = nullptr;
};


class XRPresentationClient_OnSubmitFrameRendered_ParamsDataView {
 public:
  XRPresentationClient_OnSubmitFrameRendered_ParamsDataView() = default;

  XRPresentationClient_OnSubmitFrameRendered_ParamsDataView(
      internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data* data_ = nullptr;
};


class XRPresentationClient_OnSubmitFrameGpuFence_ParamsDataView {
 public:
  XRPresentationClient_OnSubmitFrameGpuFence_ParamsDataView() = default;

  XRPresentationClient_OnSubmitFrameGpuFence_ParamsDataView(
      internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGpuFenceHandleDataView(
      ::gfx::mojom::GpuFenceHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGpuFenceHandle(UserType* output) {
    
    auto* pointer = data_->gpu_fence_handle.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuFenceHandleDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRSessionClient_OnExitPresent_ParamsDataView {
 public:
  XRSessionClient_OnExitPresent_ParamsDataView() = default;

  XRSessionClient_OnExitPresent_ParamsDataView(
      internal::XRSessionClient_OnExitPresent_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::XRSessionClient_OnExitPresent_Params_Data* data_ = nullptr;
};


class XRSessionClient_OnVisibilityStateChanged_ParamsDataView {
 public:
  XRSessionClient_OnVisibilityStateChanged_ParamsDataView() = default;

  XRSessionClient_OnVisibilityStateChanged_ParamsDataView(
      internal::XRSessionClient_OnVisibilityStateChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadVisibilityState(UserType* output) const {
    auto data_value = data_->visibility_state;
    return mojo::internal::Deserialize<::device::mojom::XRVisibilityState>(
        data_value, output);
  }
  XRVisibilityState visibility_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRVisibilityState>(data_->visibility_state));
  }
 private:
  internal::XRSessionClient_OnVisibilityStateChanged_Params_Data* data_ = nullptr;
};


class WebXrInternalsRendererListener_OnFrameData_ParamsDataView {
 public:
  WebXrInternalsRendererListener_OnFrameData_ParamsDataView() = default;

  WebXrInternalsRendererListener_OnFrameData_ParamsDataView(
      internal::WebXrInternalsRendererListener_OnFrameData_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetXrframeStatisticsDataView(
      ::device::mojom::XrFrameStatisticsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadXrframeStatistics(UserType* output) {
    
    auto* pointer = data_->xrframe_statistics.Get();
    return mojo::internal::Deserialize<::device::mojom::XrFrameStatisticsDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebXrInternalsRendererListener_OnFrameData_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebXrInternalsRendererListener_OnConsoleLog_ParamsDataView {
 public:
  WebXrInternalsRendererListener_OnConsoleLog_ParamsDataView() = default;

  WebXrInternalsRendererListener_OnConsoleLog_ParamsDataView(
      internal::WebXrInternalsRendererListener_OnConsoleLog_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetXrloggingStatisticsDataView(
      ::device::mojom::XrLogMessageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadXrloggingStatistics(UserType* output) {
    
    auto* pointer = data_->xrlogging_statistics.Get();
    return mojo::internal::Deserialize<::device::mojom::XrLogMessageDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebXrInternalsRendererListener_OnConsoleLog_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



inline void VRService_RequestSession_ParamsDataView::GetOptionsDataView(
    ::device::mojom::XRSessionOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = ::device::mojom::XRSessionOptionsDataView(pointer, message_);
}


inline void VRService_RequestSession_ResponseParamsDataView::GetResultDataView(
    RequestSessionResultDataView* output) {
  auto pointer = &data_->result;
  *output = RequestSessionResultDataView(pointer, message_);
}


inline void VRService_SupportsSession_ParamsDataView::GetOptionsDataView(
    ::device::mojom::XRSessionOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = ::device::mojom::XRSessionOptionsDataView(pointer, message_);
}


















inline void XREnvironmentIntegrationProvider_SubscribeToHitTest_ParamsDataView::GetNativeOriginInformationDataView(
    XRNativeOriginInformationDataView* output) {
  auto pointer = &data_->native_origin_information;
  *output = XRNativeOriginInformationDataView(pointer, message_);
}
inline void XREnvironmentIntegrationProvider_SubscribeToHitTest_ParamsDataView::GetEntityTypesDataView(
    mojo::ArrayDataView<EntityTypeForHitTest>* output) {
  auto pointer = data_->entity_types.Get();
  *output = mojo::ArrayDataView<EntityTypeForHitTest>(pointer, message_);
}
inline void XREnvironmentIntegrationProvider_SubscribeToHitTest_ParamsDataView::GetRayDataView(
    XRRayDataView* output) {
  auto pointer = data_->ray.Get();
  *output = XRRayDataView(pointer, message_);
}


inline void XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParamsDataView::GetSubscriptionIdDataView(
    HitTestSubscriptionIdDataView* output) {
  auto pointer = data_->subscription_id.Get();
  *output = HitTestSubscriptionIdDataView(pointer, message_);
}


inline void XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ParamsDataView::GetProfileNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->profile_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ParamsDataView::GetEntityTypesDataView(
    mojo::ArrayDataView<EntityTypeForHitTest>* output) {
  auto pointer = data_->entity_types.Get();
  *output = mojo::ArrayDataView<EntityTypeForHitTest>(pointer, message_);
}
inline void XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ParamsDataView::GetRayDataView(
    XRRayDataView* output) {
  auto pointer = data_->ray.Get();
  *output = XRRayDataView(pointer, message_);
}


inline void XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParamsDataView::GetSubscriptionIdDataView(
    HitTestSubscriptionIdDataView* output) {
  auto pointer = data_->subscription_id.Get();
  *output = HitTestSubscriptionIdDataView(pointer, message_);
}


inline void XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_ParamsDataView::GetSubscriptionIdDataView(
    HitTestSubscriptionIdDataView* output) {
  auto pointer = data_->subscription_id.Get();
  *output = HitTestSubscriptionIdDataView(pointer, message_);
}


inline void XREnvironmentIntegrationProvider_CreateAnchor_ParamsDataView::GetNativeOriginInformationDataView(
    XRNativeOriginInformationDataView* output) {
  auto pointer = &data_->native_origin_information;
  *output = XRNativeOriginInformationDataView(pointer, message_);
}
inline void XREnvironmentIntegrationProvider_CreateAnchor_ParamsDataView::GetNativeOriginFromAnchorDataView(
    PoseDataView* output) {
  auto pointer = data_->native_origin_from_anchor.Get();
  *output = PoseDataView(pointer, message_);
}
inline void XREnvironmentIntegrationProvider_CreateAnchor_ParamsDataView::GetPlaneIdDataView(
    PlaneIdDataView* output) {
  auto pointer = data_->plane_id.Get();
  *output = PlaneIdDataView(pointer, message_);
}


inline void XREnvironmentIntegrationProvider_CreateAnchor_ResponseParamsDataView::GetAnchorIdDataView(
    AnchorIdDataView* output) {
  auto pointer = data_->anchor_id.Get();
  *output = AnchorIdDataView(pointer, message_);
}


inline void XREnvironmentIntegrationProvider_DetachAnchor_ParamsDataView::GetAnchorIdDataView(
    AnchorIdDataView* output) {
  auto pointer = data_->anchor_id.Get();
  *output = AnchorIdDataView(pointer, message_);
}


inline void XRFrameDataProvider_GetFrameData_ParamsDataView::GetOptionsDataView(
    XRFrameDataRequestOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = XRFrameDataRequestOptionsDataView(pointer, message_);
}


inline void XRFrameDataProvider_GetFrameData_ResponseParamsDataView::GetFrameDataDataView(
    XRFrameDataDataView* output) {
  auto pointer = data_->frame_data.Get();
  *output = XRFrameDataDataView(pointer, message_);
}




inline void XRPresentationProvider_UpdateLayerBounds_ParamsDataView::GetLeftBoundsDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->left_bounds.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void XRPresentationProvider_UpdateLayerBounds_ParamsDataView::GetRightBoundsDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->right_bounds.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void XRPresentationProvider_UpdateLayerBounds_ParamsDataView::GetSourceSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->source_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void XRPresentationProvider_SubmitFrameMissing_ParamsDataView::GetSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}


inline void XRPresentationProvider_SubmitFrame_ParamsDataView::GetMailboxHolderDataView(
    ::gpu::mojom::MailboxHolderDataView* output) {
  auto pointer = data_->mailbox_holder.Get();
  *output = ::gpu::mojom::MailboxHolderDataView(pointer, message_);
}
inline void XRPresentationProvider_SubmitFrame_ParamsDataView::GetTimeWaitedDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->time_waited.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void XRPresentationProvider_SubmitFrameDrawnIntoTexture_ParamsDataView::GetSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}
inline void XRPresentationProvider_SubmitFrameDrawnIntoTexture_ParamsDataView::GetTimeWaitedDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->time_waited.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}






inline void XRPresentationClient_OnSubmitFrameGpuFence_ParamsDataView::GetGpuFenceHandleDataView(
    ::gfx::mojom::GpuFenceHandleDataView* output) {
  auto pointer = data_->gpu_fence_handle.Get();
  *output = ::gfx::mojom::GpuFenceHandleDataView(pointer, message_);
}






inline void WebXrInternalsRendererListener_OnFrameData_ParamsDataView::GetXrframeStatisticsDataView(
    ::device::mojom::XrFrameStatisticsDataView* output) {
  auto pointer = data_->xrframe_statistics.Get();
  *output = ::device::mojom::XrFrameStatisticsDataView(pointer, message_);
}


inline void WebXrInternalsRendererListener_OnConsoleLog_ParamsDataView::GetXrloggingStatisticsDataView(
    ::device::mojom::XrLogMessageDataView* output) {
  auto pointer = data_->xrlogging_statistics.Get();
  *output = ::device::mojom::XrLogMessageDataView(pointer, message_);
}



}  // device::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_PARAMS_DATA_H_