// device/vr/public/mojom/isolated_xr_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_TEST_UTILS_H_
#define DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_TEST_UTILS_H_

#include "device/vr/public/mojom/isolated_xr_service.mojom.h"
#include "base/component_export.h"


namespace device::mojom {


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRSessionControllerInterceptorForTesting : public XRSessionController {
  virtual XRSessionController* GetForwardingInterface() = 0;
  void SetFrameDataRestricted(bool restricted) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRSessionControllerAsyncWaiter {
 public:
  explicit XRSessionControllerAsyncWaiter(XRSessionController* proxy);

  XRSessionControllerAsyncWaiter(const XRSessionControllerAsyncWaiter&) = delete;
  XRSessionControllerAsyncWaiter& operator=(const XRSessionControllerAsyncWaiter&) = delete;

  ~XRSessionControllerAsyncWaiter();

 private:
  XRSessionController* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeEventListenerInterceptorForTesting : public XRRuntimeEventListener {
  virtual XRRuntimeEventListener* GetForwardingInterface() = 0;
  void OnVisibilityStateChanged(::device::mojom::XRVisibilityState visibility_state) override;
  void OnExitPresent() override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeEventListenerAsyncWaiter {
 public:
  explicit XRRuntimeEventListenerAsyncWaiter(XRRuntimeEventListener* proxy);

  XRRuntimeEventListenerAsyncWaiter(const XRRuntimeEventListenerAsyncWaiter&) = delete;
  XRRuntimeEventListenerAsyncWaiter& operator=(const XRRuntimeEventListenerAsyncWaiter&) = delete;

  ~XRRuntimeEventListenerAsyncWaiter();

 private:
  XRRuntimeEventListener* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeInterceptorForTesting : public XRRuntime {
  virtual XRRuntime* GetForwardingInterface() = 0;
  void RequestSession(XRRuntimeSessionOptionsPtr options, RequestSessionCallback callback) override;
  void ShutdownSession(ShutdownSessionCallback callback) override;
  void ListenToDeviceChanges(::mojo::PendingAssociatedRemote<XRRuntimeEventListener> listener) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeAsyncWaiter {
 public:
  explicit XRRuntimeAsyncWaiter(XRRuntime* proxy);

  XRRuntimeAsyncWaiter(const XRRuntimeAsyncWaiter&) = delete;
  XRRuntimeAsyncWaiter& operator=(const XRRuntimeAsyncWaiter&) = delete;

  ~XRRuntimeAsyncWaiter();
  void RequestSession(
      XRRuntimeSessionOptionsPtr options, XRRuntimeSessionResultPtr* out_session);
  XRRuntimeSessionResultPtr RequestSession(XRRuntimeSessionOptionsPtr options);
  void ShutdownSession(
      );
  

 private:
  XRRuntime* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) ImmersiveOverlayInterceptorForTesting : public ImmersiveOverlay {
  virtual ImmersiveOverlay* GetForwardingInterface() = 0;
  void RequestNextOverlayPose(RequestNextOverlayPoseCallback callback) override;
  void SubmitOverlayTexture(int16_t frame_id, ::gfx::GpuMemoryBufferHandle texture, const ::gpu::SyncToken& sync_token, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, SubmitOverlayTextureCallback callback) override;
  void SetOverlayAndWebXRVisibility(bool overlay_visible, bool webxr_visible) override;
  void RequestNotificationOnWebXrSubmitted(RequestNotificationOnWebXrSubmittedCallback callback) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) ImmersiveOverlayAsyncWaiter {
 public:
  explicit ImmersiveOverlayAsyncWaiter(ImmersiveOverlay* proxy);

  ImmersiveOverlayAsyncWaiter(const ImmersiveOverlayAsyncWaiter&) = delete;
  ImmersiveOverlayAsyncWaiter& operator=(const ImmersiveOverlayAsyncWaiter&) = delete;

  ~ImmersiveOverlayAsyncWaiter();
  void RequestNextOverlayPose(
      ::device::mojom::XRRenderInfoPtr* out_render_info);
  ::device::mojom::XRRenderInfoPtr RequestNextOverlayPose();
  void SubmitOverlayTexture(
      int16_t frame_id, ::gfx::GpuMemoryBufferHandle texture, const ::gpu::SyncToken& sync_token, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, bool* out_success);
  bool SubmitOverlayTexture(int16_t frame_id, ::gfx::GpuMemoryBufferHandle texture, const ::gpu::SyncToken& sync_token, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds);
  void RequestNotificationOnWebXrSubmitted(
      );
  

 private:
  ImmersiveOverlay* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) IsolatedXRRuntimeProviderClientInterceptorForTesting : public IsolatedXRRuntimeProviderClient {
  virtual IsolatedXRRuntimeProviderClient* GetForwardingInterface() = 0;
  void OnDeviceAdded(::mojo::PendingRemote<XRRuntime> runtime, XRDeviceDataPtr device_data, ::device::mojom::XRDeviceId device_id) override;
  void OnDeviceRemoved(::device::mojom::XRDeviceId device_index) override;
  void OnDevicesEnumerated() override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) IsolatedXRRuntimeProviderClientAsyncWaiter {
 public:
  explicit IsolatedXRRuntimeProviderClientAsyncWaiter(IsolatedXRRuntimeProviderClient* proxy);

  IsolatedXRRuntimeProviderClientAsyncWaiter(const IsolatedXRRuntimeProviderClientAsyncWaiter&) = delete;
  IsolatedXRRuntimeProviderClientAsyncWaiter& operator=(const IsolatedXRRuntimeProviderClientAsyncWaiter&) = delete;

  ~IsolatedXRRuntimeProviderClientAsyncWaiter();

 private:
  IsolatedXRRuntimeProviderClient* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) IsolatedXRRuntimeProviderInterceptorForTesting : public IsolatedXRRuntimeProvider {
  virtual IsolatedXRRuntimeProvider* GetForwardingInterface() = 0;
  void RequestDevices(::mojo::PendingRemote<IsolatedXRRuntimeProviderClient> client) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) IsolatedXRRuntimeProviderAsyncWaiter {
 public:
  explicit IsolatedXRRuntimeProviderAsyncWaiter(IsolatedXRRuntimeProvider* proxy);

  IsolatedXRRuntimeProviderAsyncWaiter(const IsolatedXRRuntimeProviderAsyncWaiter&) = delete;
  IsolatedXRRuntimeProviderAsyncWaiter& operator=(const IsolatedXRRuntimeProviderAsyncWaiter&) = delete;

  ~IsolatedXRRuntimeProviderAsyncWaiter();

 private:
  IsolatedXRRuntimeProvider* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRDeviceServiceInterceptorForTesting : public XRDeviceService {
  virtual XRDeviceService* GetForwardingInterface() = 0;
  void BindRuntimeProvider(::mojo::PendingReceiver<IsolatedXRRuntimeProvider> receiver, ::mojo::PendingRemote<XRDeviceServiceHost> host) override;
  void BindTestHook(::mojo::PendingReceiver<::device_test::mojom::XRServiceTestHook> receiver) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRDeviceServiceAsyncWaiter {
 public:
  explicit XRDeviceServiceAsyncWaiter(XRDeviceService* proxy);

  XRDeviceServiceAsyncWaiter(const XRDeviceServiceAsyncWaiter&) = delete;
  XRDeviceServiceAsyncWaiter& operator=(const XRDeviceServiceAsyncWaiter&) = delete;

  ~XRDeviceServiceAsyncWaiter();

 private:
  XRDeviceService* const proxy_;
};


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRDeviceServiceHostInterceptorForTesting : public XRDeviceServiceHost {
  virtual XRDeviceServiceHost* GetForwardingInterface() = 0;
  void BindGpu(::mojo::PendingReceiver<::viz::mojom::Gpu> receiver) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRDeviceServiceHostAsyncWaiter {
 public:
  explicit XRDeviceServiceHostAsyncWaiter(XRDeviceServiceHost* proxy);

  XRDeviceServiceHostAsyncWaiter(const XRDeviceServiceHostAsyncWaiter&) = delete;
  XRDeviceServiceHostAsyncWaiter& operator=(const XRDeviceServiceHostAsyncWaiter&) = delete;

  ~XRDeviceServiceHostAsyncWaiter();

 private:
  XRDeviceServiceHost* const proxy_;
};




}  // device::mojom

#endif  // DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_TEST_UTILS_H_