// device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-params-data.h"
namespace bluetooth {
namespace mojom {

NOINLINE static const char* CentralStateToStringHelper(CentralState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CentralState::ABSENT:
      return "ABSENT";
    case CentralState::POWERED_ON:
      return "POWERED_ON";
    case CentralState::POWERED_OFF:
      return "POWERED_OFF";
    default:
      return nullptr;
  }
}

std::string CentralStateToString(CentralState value) {
  const char *str = CentralStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CentralState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CentralState value) {
  return os << CentralStateToString(value);
}

NOINLINE static const char* WriteTypeToStringHelper(WriteType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WriteType::kNone:
      return "kNone";
    case WriteType::kWriteDefaultDeprecated:
      return "kWriteDefaultDeprecated";
    case WriteType::kWriteWithResponse:
      return "kWriteWithResponse";
    case WriteType::kWriteWithoutResponse:
      return "kWriteWithoutResponse";
    default:
      return nullptr;
  }
}

std::string WriteTypeToString(WriteType value) {
  const char *str = WriteTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WriteType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WriteType value) {
  return os << WriteTypeToString(value);
}

NOINLINE static const char* GATTOperationTypeToStringHelper(GATTOperationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GATTOperationType::kConnect:
      return "kConnect";
    case GATTOperationType::kDiscovery:
      return "kDiscovery";
    default:
      return nullptr;
  }
}

std::string GATTOperationTypeToString(GATTOperationType value) {
  const char *str = GATTOperationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GATTOperationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GATTOperationType value) {
  return os << GATTOperationTypeToString(value);
}

NOINLINE static const char* CharacteristicOperationTypeToStringHelper(CharacteristicOperationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CharacteristicOperationType::kRead:
      return "kRead";
    case CharacteristicOperationType::kWrite:
      return "kWrite";
    case CharacteristicOperationType::kSubscribeToNotifications:
      return "kSubscribeToNotifications";
    case CharacteristicOperationType::kUnsubscribeFromNotifications:
      return "kUnsubscribeFromNotifications";
    default:
      return nullptr;
  }
}

std::string CharacteristicOperationTypeToString(CharacteristicOperationType value) {
  const char *str = CharacteristicOperationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CharacteristicOperationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CharacteristicOperationType value) {
  return os << CharacteristicOperationTypeToString(value);
}

NOINLINE static const char* DescriptorOperationTypeToStringHelper(DescriptorOperationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DescriptorOperationType::kRead:
      return "kRead";
    case DescriptorOperationType::kWrite:
      return "kWrite";
    default:
      return nullptr;
  }
}

std::string DescriptorOperationTypeToString(DescriptorOperationType value) {
  const char *str = DescriptorOperationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DescriptorOperationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DescriptorOperationType value) {
  return os << DescriptorOperationTypeToString(value);
}

namespace internal {


// static
bool Appearance_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Appearance_Data* object =
      static_cast<const Appearance_Data*>(data);

  return true;
}

Appearance_Data::Appearance_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Power_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Power_Data* object =
      static_cast<const Power_Data*>(data);

  return true;
}

Power_Data::Power_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceDataMap_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceDataMap_Data* object =
      static_cast<const ServiceDataMap_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->service_data, validation_context,
                                         &service_data_validate_params)) {
    return false;
  }

  return true;
}

ServiceDataMap_Data::ServiceDataMap_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScanRecord_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScanRecord_Data* object =
      static_cast<const ScanRecord_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& uuids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->uuids, validation_context,
                                         &uuids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->appearance, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->appearance, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tx_power, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tx_power, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& manufacturer_data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->manufacturer_data, validation_context,
                                         &manufacturer_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->service_data, validation_context))
    return false;

  return true;
}

ScanRecord_Data::ScanRecord_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScanResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScanResult_Data* object =
      static_cast<const ScanResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_address, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& device_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->device_address, validation_context,
                                         &device_address_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scan_record, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scan_record, validation_context))
    return false;

  return true;
}

ScanResult_Data::ScanResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CharacteristicProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CharacteristicProperties_Data* object =
      static_cast<const CharacteristicProperties_Data*>(data);

  return true;
}

CharacteristicProperties_Data::CharacteristicProperties_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeBluetooth_SetLESupported_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeBluetooth_SetLESupported_Params_Data* object =
      static_cast<const FakeBluetooth_SetLESupported_Params_Data*>(data);

  return true;
}

FakeBluetooth_SetLESupported_Params_Data::FakeBluetooth_SetLESupported_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeBluetooth_SetLESupported_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeBluetooth_SetLESupported_ResponseParams_Data* object =
      static_cast<const FakeBluetooth_SetLESupported_ResponseParams_Data*>(data);

  return true;
}

FakeBluetooth_SetLESupported_ResponseParams_Data::FakeBluetooth_SetLESupported_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeBluetooth_SimulateCentral_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeBluetooth_SimulateCentral_Params_Data* object =
      static_cast<const FakeBluetooth_SimulateCentral_Params_Data*>(data);


  if (!::bluetooth::mojom::internal::CentralState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

FakeBluetooth_SimulateCentral_Params_Data::FakeBluetooth_SimulateCentral_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeBluetooth_SimulateCentral_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeBluetooth_SimulateCentral_ResponseParams_Data* object =
      static_cast<const FakeBluetooth_SimulateCentral_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->fake_central, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->fake_central,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FakeBluetooth_SimulateCentral_ResponseParams_Data::FakeBluetooth_SimulateCentral_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeBluetooth_AllResponsesConsumed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeBluetooth_AllResponsesConsumed_Params_Data* object =
      static_cast<const FakeBluetooth_AllResponsesConsumed_Params_Data*>(data);

  return true;
}

FakeBluetooth_AllResponsesConsumed_Params_Data::FakeBluetooth_AllResponsesConsumed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeBluetooth_AllResponsesConsumed_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeBluetooth_AllResponsesConsumed_ResponseParams_Data* object =
      static_cast<const FakeBluetooth_AllResponsesConsumed_ResponseParams_Data*>(data);

  return true;
}

FakeBluetooth_AllResponsesConsumed_ResponseParams_Data::FakeBluetooth_AllResponsesConsumed_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulatePreconnectedPeripheral_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulatePreconnectedPeripheral_Params_Data* object =
      static_cast<const FakeCentral_SimulatePreconnectedPeripheral_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->address, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->address, validation_context,
                                         &address_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->manufacturer_data, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& manufacturer_data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->manufacturer_data, validation_context,
                                         &manufacturer_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->known_service_uuids, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& known_service_uuids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->known_service_uuids, validation_context,
                                         &known_service_uuids_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SimulatePreconnectedPeripheral_Params_Data::FakeCentral_SimulatePreconnectedPeripheral_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulatePreconnectedPeripheral_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulatePreconnectedPeripheral_ResponseParams_Data* object =
      static_cast<const FakeCentral_SimulatePreconnectedPeripheral_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SimulatePreconnectedPeripheral_ResponseParams_Data::FakeCentral_SimulatePreconnectedPeripheral_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulateAdvertisementReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulateAdvertisementReceived_Params_Data* object =
      static_cast<const FakeCentral_SimulateAdvertisementReceived_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

FakeCentral_SimulateAdvertisementReceived_Params_Data::FakeCentral_SimulateAdvertisementReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulateAdvertisementReceived_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulateAdvertisementReceived_ResponseParams_Data* object =
      static_cast<const FakeCentral_SimulateAdvertisementReceived_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SimulateAdvertisementReceived_ResponseParams_Data::FakeCentral_SimulateAdvertisementReceived_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetState_Params_Data* object =
      static_cast<const FakeCentral_SetState_Params_Data*>(data);


  if (!::bluetooth::mojom::internal::CentralState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

FakeCentral_SetState_Params_Data::FakeCentral_SetState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetState_ResponseParams_Data* object =
      static_cast<const FakeCentral_SetState_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SetState_ResponseParams_Data::FakeCentral_SetState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextGATTConnectionResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextGATTConnectionResponse_Params_Data* object =
      static_cast<const FakeCentral_SetNextGATTConnectionResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->address, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->address, validation_context,
                                         &address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SetNextGATTConnectionResponse_Params_Data::FakeCentral_SetNextGATTConnectionResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextGATTConnectionResponse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextGATTConnectionResponse_ResponseParams_Data* object =
      static_cast<const FakeCentral_SetNextGATTConnectionResponse_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SetNextGATTConnectionResponse_ResponseParams_Data::FakeCentral_SetNextGATTConnectionResponse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextGATTDiscoveryResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextGATTDiscoveryResponse_Params_Data* object =
      static_cast<const FakeCentral_SetNextGATTDiscoveryResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->address, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->address, validation_context,
                                         &address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SetNextGATTDiscoveryResponse_Params_Data::FakeCentral_SetNextGATTDiscoveryResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextGATTDiscoveryResponse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextGATTDiscoveryResponse_ResponseParams_Data* object =
      static_cast<const FakeCentral_SetNextGATTDiscoveryResponse_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SetNextGATTDiscoveryResponse_ResponseParams_Data::FakeCentral_SetNextGATTDiscoveryResponse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulateGATTOperationResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulateGATTOperationResponse_Params_Data* object =
      static_cast<const FakeCentral_SimulateGATTOperationResponse_Params_Data*>(data);


  if (!::bluetooth::mojom::internal::GATTOperationType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->address, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->address, validation_context,
                                         &address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SimulateGATTOperationResponse_Params_Data::FakeCentral_SimulateGATTOperationResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulateGATTOperationResponse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulateGATTOperationResponse_ResponseParams_Data* object =
      static_cast<const FakeCentral_SimulateGATTOperationResponse_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SimulateGATTOperationResponse_ResponseParams_Data::FakeCentral_SimulateGATTOperationResponse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulateGATTDisconnection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulateGATTDisconnection_Params_Data* object =
      static_cast<const FakeCentral_SimulateGATTDisconnection_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->address, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->address, validation_context,
                                         &address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SimulateGATTDisconnection_Params_Data::FakeCentral_SimulateGATTDisconnection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulateGATTDisconnection_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulateGATTDisconnection_ResponseParams_Data* object =
      static_cast<const FakeCentral_SimulateGATTDisconnection_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SimulateGATTDisconnection_ResponseParams_Data::FakeCentral_SimulateGATTDisconnection_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulateGATTServicesChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulateGATTServicesChanged_Params_Data* object =
      static_cast<const FakeCentral_SimulateGATTServicesChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->address, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->address, validation_context,
                                         &address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SimulateGATTServicesChanged_Params_Data::FakeCentral_SimulateGATTServicesChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulateGATTServicesChanged_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulateGATTServicesChanged_ResponseParams_Data* object =
      static_cast<const FakeCentral_SimulateGATTServicesChanged_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SimulateGATTServicesChanged_ResponseParams_Data::FakeCentral_SimulateGATTServicesChanged_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulateCharacteristicOperationResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulateCharacteristicOperationResponse_Params_Data* object =
      static_cast<const FakeCentral_SimulateCharacteristicOperationResponse_Params_Data*>(data);


  if (!::bluetooth::mojom::internal::CharacteristicOperationType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SimulateCharacteristicOperationResponse_Params_Data::FakeCentral_SimulateCharacteristicOperationResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulateCharacteristicOperationResponse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulateCharacteristicOperationResponse_ResponseParams_Data* object =
      static_cast<const FakeCentral_SimulateCharacteristicOperationResponse_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SimulateCharacteristicOperationResponse_ResponseParams_Data::FakeCentral_SimulateCharacteristicOperationResponse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulateDescriptorOperationResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulateDescriptorOperationResponse_Params_Data* object =
      static_cast<const FakeCentral_SimulateDescriptorOperationResponse_Params_Data*>(data);


  if (!::bluetooth::mojom::internal::DescriptorOperationType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& descriptor_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptor_id, validation_context,
                                         &descriptor_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SimulateDescriptorOperationResponse_Params_Data::FakeCentral_SimulateDescriptorOperationResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SimulateDescriptorOperationResponse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SimulateDescriptorOperationResponse_ResponseParams_Data* object =
      static_cast<const FakeCentral_SimulateDescriptorOperationResponse_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SimulateDescriptorOperationResponse_ResponseParams_Data::FakeCentral_SimulateDescriptorOperationResponse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_AddFakeService_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_AddFakeService_Params_Data* object =
      static_cast<const FakeCentral_AddFakeService_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_uuid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->service_uuid, validation_context))
    return false;

  return true;
}

FakeCentral_AddFakeService_Params_Data::FakeCentral_AddFakeService_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_AddFakeService_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_AddFakeService_ResponseParams_Data* object =
      static_cast<const FakeCentral_AddFakeService_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_AddFakeService_ResponseParams_Data::FakeCentral_AddFakeService_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_RemoveFakeService_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_RemoveFakeService_Params_Data* object =
      static_cast<const FakeCentral_RemoveFakeService_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_RemoveFakeService_Params_Data::FakeCentral_RemoveFakeService_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_RemoveFakeService_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_RemoveFakeService_ResponseParams_Data* object =
      static_cast<const FakeCentral_RemoveFakeService_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_RemoveFakeService_ResponseParams_Data::FakeCentral_RemoveFakeService_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_AddFakeCharacteristic_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_AddFakeCharacteristic_Params_Data* object =
      static_cast<const FakeCentral_AddFakeCharacteristic_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->characteristic_uuid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->properties, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->properties, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_AddFakeCharacteristic_Params_Data::FakeCentral_AddFakeCharacteristic_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_AddFakeCharacteristic_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_AddFakeCharacteristic_ResponseParams_Data* object =
      static_cast<const FakeCentral_AddFakeCharacteristic_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_AddFakeCharacteristic_ResponseParams_Data::FakeCentral_AddFakeCharacteristic_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_RemoveFakeCharacteristic_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_RemoveFakeCharacteristic_Params_Data* object =
      static_cast<const FakeCentral_RemoveFakeCharacteristic_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->identifier, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& identifier_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->identifier, validation_context,
                                         &identifier_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_RemoveFakeCharacteristic_Params_Data::FakeCentral_RemoveFakeCharacteristic_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_RemoveFakeCharacteristic_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_RemoveFakeCharacteristic_ResponseParams_Data* object =
      static_cast<const FakeCentral_RemoveFakeCharacteristic_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_RemoveFakeCharacteristic_ResponseParams_Data::FakeCentral_RemoveFakeCharacteristic_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_AddFakeDescriptor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_AddFakeDescriptor_Params_Data* object =
      static_cast<const FakeCentral_AddFakeDescriptor_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor_uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->descriptor_uuid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_AddFakeDescriptor_Params_Data::FakeCentral_AddFakeDescriptor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_AddFakeDescriptor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_AddFakeDescriptor_ResponseParams_Data* object =
      static_cast<const FakeCentral_AddFakeDescriptor_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& descriptor_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptor_id, validation_context,
                                         &descriptor_id_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_AddFakeDescriptor_ResponseParams_Data::FakeCentral_AddFakeDescriptor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_RemoveFakeDescriptor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_RemoveFakeDescriptor_Params_Data* object =
      static_cast<const FakeCentral_RemoveFakeDescriptor_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& descriptor_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptor_id, validation_context,
                                         &descriptor_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_RemoveFakeDescriptor_Params_Data::FakeCentral_RemoveFakeDescriptor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_RemoveFakeDescriptor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_RemoveFakeDescriptor_ResponseParams_Data* object =
      static_cast<const FakeCentral_RemoveFakeDescriptor_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_RemoveFakeDescriptor_ResponseParams_Data::FakeCentral_RemoveFakeDescriptor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextReadCharacteristicResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextReadCharacteristicResponse_Params_Data* object =
      static_cast<const FakeCentral_SetNextReadCharacteristicResponse_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SetNextReadCharacteristicResponse_Params_Data::FakeCentral_SetNextReadCharacteristicResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextReadCharacteristicResponse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextReadCharacteristicResponse_ResponseParams_Data* object =
      static_cast<const FakeCentral_SetNextReadCharacteristicResponse_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SetNextReadCharacteristicResponse_ResponseParams_Data::FakeCentral_SetNextReadCharacteristicResponse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextWriteCharacteristicResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextWriteCharacteristicResponse_Params_Data* object =
      static_cast<const FakeCentral_SetNextWriteCharacteristicResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SetNextWriteCharacteristicResponse_Params_Data::FakeCentral_SetNextWriteCharacteristicResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextWriteCharacteristicResponse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextWriteCharacteristicResponse_ResponseParams_Data* object =
      static_cast<const FakeCentral_SetNextWriteCharacteristicResponse_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SetNextWriteCharacteristicResponse_ResponseParams_Data::FakeCentral_SetNextWriteCharacteristicResponse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextSubscribeToNotificationsResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextSubscribeToNotificationsResponse_Params_Data* object =
      static_cast<const FakeCentral_SetNextSubscribeToNotificationsResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SetNextSubscribeToNotificationsResponse_Params_Data::FakeCentral_SetNextSubscribeToNotificationsResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextSubscribeToNotificationsResponse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextSubscribeToNotificationsResponse_ResponseParams_Data* object =
      static_cast<const FakeCentral_SetNextSubscribeToNotificationsResponse_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SetNextSubscribeToNotificationsResponse_ResponseParams_Data::FakeCentral_SetNextSubscribeToNotificationsResponse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextUnsubscribeFromNotificationsResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextUnsubscribeFromNotificationsResponse_Params_Data* object =
      static_cast<const FakeCentral_SetNextUnsubscribeFromNotificationsResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SetNextUnsubscribeFromNotificationsResponse_Params_Data::FakeCentral_SetNextUnsubscribeFromNotificationsResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ResponseParams_Data* object =
      static_cast<const FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ResponseParams_Data::FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_IsNotifying_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_IsNotifying_Params_Data* object =
      static_cast<const FakeCentral_IsNotifying_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_IsNotifying_Params_Data::FakeCentral_IsNotifying_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_IsNotifying_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_IsNotifying_ResponseParams_Data* object =
      static_cast<const FakeCentral_IsNotifying_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_IsNotifying_ResponseParams_Data::FakeCentral_IsNotifying_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_GetLastWrittenCharacteristicValue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_GetLastWrittenCharacteristicValue_Params_Data* object =
      static_cast<const FakeCentral_GetLastWrittenCharacteristicValue_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_GetLastWrittenCharacteristicValue_Params_Data::FakeCentral_GetLastWrittenCharacteristicValue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_GetLastWrittenCharacteristicValue_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_GetLastWrittenCharacteristicValue_ResponseParams_Data* object =
      static_cast<const FakeCentral_GetLastWrittenCharacteristicValue_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }


  if (!::bluetooth::mojom::internal::WriteType_Data
        ::Validate(object->write_type, validation_context))
    return false;

  return true;
}

FakeCentral_GetLastWrittenCharacteristicValue_ResponseParams_Data::FakeCentral_GetLastWrittenCharacteristicValue_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextReadDescriptorResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextReadDescriptorResponse_Params_Data* object =
      static_cast<const FakeCentral_SetNextReadDescriptorResponse_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& descriptor_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptor_id, validation_context,
                                         &descriptor_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SetNextReadDescriptorResponse_Params_Data::FakeCentral_SetNextReadDescriptorResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextReadDescriptorResponse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextReadDescriptorResponse_ResponseParams_Data* object =
      static_cast<const FakeCentral_SetNextReadDescriptorResponse_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SetNextReadDescriptorResponse_ResponseParams_Data::FakeCentral_SetNextReadDescriptorResponse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextWriteDescriptorResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextWriteDescriptorResponse_Params_Data* object =
      static_cast<const FakeCentral_SetNextWriteDescriptorResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& descriptor_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptor_id, validation_context,
                                         &descriptor_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_SetNextWriteDescriptorResponse_Params_Data::FakeCentral_SetNextWriteDescriptorResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetNextWriteDescriptorResponse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetNextWriteDescriptorResponse_ResponseParams_Data* object =
      static_cast<const FakeCentral_SetNextWriteDescriptorResponse_ResponseParams_Data*>(data);

  return true;
}

FakeCentral_SetNextWriteDescriptorResponse_ResponseParams_Data::FakeCentral_SetNextWriteDescriptorResponse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_GetLastWrittenDescriptorValue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_GetLastWrittenDescriptorValue_Params_Data* object =
      static_cast<const FakeCentral_GetLastWrittenDescriptorValue_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& descriptor_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptor_id, validation_context,
                                         &descriptor_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_id, validation_context,
                                         &service_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_GetLastWrittenDescriptorValue_Params_Data::FakeCentral_GetLastWrittenDescriptorValue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_GetLastWrittenDescriptorValue_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_GetLastWrittenDescriptorValue_ResponseParams_Data* object =
      static_cast<const FakeCentral_GetLastWrittenDescriptorValue_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

FakeCentral_GetLastWrittenDescriptorValue_ResponseParams_Data::FakeCentral_GetLastWrittenDescriptorValue_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentral_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentral_SetClient_Params_Data* object =
      static_cast<const FakeCentral_SetClient_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FakeCentral_SetClient_Params_Data::FakeCentral_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentralClient_DispatchGATTOperationEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentralClient_DispatchGATTOperationEvent_Params_Data* object =
      static_cast<const FakeCentralClient_DispatchGATTOperationEvent_Params_Data*>(data);


  if (!::bluetooth::mojom::internal::GATTOperationType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->peripheral_address, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& peripheral_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->peripheral_address, validation_context,
                                         &peripheral_address_validate_params)) {
    return false;
  }

  return true;
}

FakeCentralClient_DispatchGATTOperationEvent_Params_Data::FakeCentralClient_DispatchGATTOperationEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentralClient_DispatchCharacteristicOperationEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentralClient_DispatchCharacteristicOperationEvent_Params_Data* object =
      static_cast<const FakeCentralClient_DispatchCharacteristicOperationEvent_Params_Data*>(data);


  if (!::bluetooth::mojom::internal::CharacteristicOperationType_Data
        ::Validate(object->type, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }


  if (!::bluetooth::mojom::internal::WriteType_Data
        ::Validate(object->write_type_$value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_id, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_id, validation_context,
                                         &characteristic_id_validate_params)) {
    return false;
  }

  return true;
}

FakeCentralClient_DispatchCharacteristicOperationEvent_Params_Data::FakeCentralClient_DispatchCharacteristicOperationEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FakeCentralClient_DispatchDescriptorOperationEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FakeCentralClient_DispatchDescriptorOperationEvent_Params_Data* object =
      static_cast<const FakeCentralClient_DispatchDescriptorOperationEvent_Params_Data*>(data);


  if (!::bluetooth::mojom::internal::DescriptorOperationType_Data
        ::Validate(object->type, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& descriptor_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptor_id, validation_context,
                                         &descriptor_id_validate_params)) {
    return false;
  }

  return true;
}

FakeCentralClient_DispatchDescriptorOperationEvent_Params_Data::FakeCentralClient_DispatchDescriptorOperationEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace bluetooth

namespace perfetto {

// static
void TraceFormatTraits<::bluetooth::mojom::CentralState>::WriteIntoTrace(
   perfetto::TracedValue context, ::bluetooth::mojom::CentralState value) {
  return std::move(context).WriteString(::bluetooth::mojom::CentralStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::bluetooth::mojom::WriteType>::WriteIntoTrace(
   perfetto::TracedValue context, ::bluetooth::mojom::WriteType value) {
  return std::move(context).WriteString(::bluetooth::mojom::WriteTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::bluetooth::mojom::GATTOperationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::bluetooth::mojom::GATTOperationType value) {
  return std::move(context).WriteString(::bluetooth::mojom::GATTOperationTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::bluetooth::mojom::CharacteristicOperationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::bluetooth::mojom::CharacteristicOperationType value) {
  return std::move(context).WriteString(::bluetooth::mojom::CharacteristicOperationTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::bluetooth::mojom::DescriptorOperationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::bluetooth::mojom::DescriptorOperationType value) {
  return std::move(context).WriteString(::bluetooth::mojom::DescriptorOperationTypeToString(value));
}

} // namespace perfetto