// device/bluetooth/public/mojom/adapter.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "device/bluetooth/public/mojom/adapter.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/bluetooth/public/mojom/adapter.mojom-params-data.h"
#include "device/bluetooth/public/mojom/adapter.mojom-shared-message-ids.h"

#include "device/bluetooth/public/mojom/adapter.mojom-import-headers.h"
#include "device/bluetooth/public/mojom/adapter.mojom-test-utils.h"


namespace bluetooth::mojom {
ConnectToServiceResult::ConnectToServiceResult()
    : socket(),
      receive_stream(),
      send_stream() {}

ConnectToServiceResult::ConnectToServiceResult(
    ::mojo::PendingRemote<Socket> socket_in,
    ::mojo::ScopedDataPipeConsumerHandle receive_stream_in,
    ::mojo::ScopedDataPipeProducerHandle send_stream_in)
    : socket(std::move(socket_in)),
      receive_stream(std::move(receive_stream_in)),
      send_stream(std::move(send_stream_in)) {}

ConnectToServiceResult::~ConnectToServiceResult() = default;

void ConnectToServiceResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "socket"), this->socket,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<Socket>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_stream"), this->receive_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedDataPipeConsumerHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_stream"), this->send_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedDataPipeProducerHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ConnectToServiceResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AcceptConnectionResult::AcceptConnectionResult()
    : device(),
      socket(),
      receive_stream(),
      send_stream() {}

AcceptConnectionResult::AcceptConnectionResult(
    ::bluetooth::mojom::DeviceInfoPtr device_in,
    ::mojo::PendingRemote<Socket> socket_in,
    ::mojo::ScopedDataPipeConsumerHandle receive_stream_in,
    ::mojo::ScopedDataPipeProducerHandle send_stream_in)
    : device(std::move(device_in)),
      socket(std::move(socket_in)),
      receive_stream(std::move(receive_stream_in)),
      send_stream(std::move(send_stream_in)) {}

AcceptConnectionResult::~AcceptConnectionResult() = default;

void AcceptConnectionResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device"), this->device,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::bluetooth::mojom::DeviceInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "socket"), this->socket,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<Socket>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_stream"), this->receive_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedDataPipeConsumerHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_stream"), this->send_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedDataPipeProducerHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AcceptConnectionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AdapterInfo::AdapterInfo()
    : address(),
      name(),
      system_name(),
      floss(),
      extended_advertisement_support(),
      initialized(),
      present(),
      powered(),
      discoverable(),
      discovering() {}

AdapterInfo::AdapterInfo(
    const std::string& address_in,
    const std::string& name_in,
    const std::string& system_name_in,
    bool floss_in,
    bool extended_advertisement_support_in,
    bool initialized_in,
    bool present_in,
    bool powered_in,
    bool discoverable_in,
    bool discovering_in)
    : address(std::move(address_in)),
      name(std::move(name_in)),
      system_name(std::move(system_name_in)),
      floss(std::move(floss_in)),
      extended_advertisement_support(std::move(extended_advertisement_support_in)),
      initialized(std::move(initialized_in)),
      present(std::move(present_in)),
      powered(std::move(powered_in)),
      discoverable(std::move(discoverable_in)),
      discovering(std::move(discovering_in)) {}

AdapterInfo::~AdapterInfo() = default;
size_t AdapterInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->address);
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->system_name);
  seed = mojo::internal::Hash(seed, this->floss);
  seed = mojo::internal::Hash(seed, this->extended_advertisement_support);
  seed = mojo::internal::Hash(seed, this->initialized);
  seed = mojo::internal::Hash(seed, this->present);
  seed = mojo::internal::Hash(seed, this->powered);
  seed = mojo::internal::Hash(seed, this->discoverable);
  seed = mojo::internal::Hash(seed, this->discovering);
  return seed;
}

void AdapterInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "address"), this->address,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "system_name"), this->system_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "floss"), this->floss,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extended_advertisement_support"), this->extended_advertisement_support,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initialized"), this->initialized,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "present"), this->present,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "powered"), this->powered,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discoverable"), this->discoverable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discovering"), this->discovering,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AdapterInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LocalCharacteristicReadResultPtr
LocalCharacteristicReadResult::NewErrorCode(
    ::device::BluetoothGattService::GattErrorCode value) {
  return LocalCharacteristicReadResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorCode)>,
      std::move(value));
}

LocalCharacteristicReadResultPtr
LocalCharacteristicReadResult::NewData(
    std::vector<uint8_t> value) {
  return LocalCharacteristicReadResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kData)>,
      std::move(value));
}

LocalCharacteristicReadResult::LocalCharacteristicReadResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
    ::device::BluetoothGattService::GattErrorCode value)
    : tag_(Tag::kErrorCode),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorCode)>,
            std::move(value)) {}

LocalCharacteristicReadResult::LocalCharacteristicReadResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
    std::vector<uint8_t> value)
    : tag_(Tag::kData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kData)>,
            std::move(value)) {}
LocalCharacteristicReadResult::~LocalCharacteristicReadResult() {
  DestroyActive();
}

void LocalCharacteristicReadResult::set_error_code(::device::BluetoothGattService::GattErrorCode error_code) {
  if (tag_ != Tag::kErrorCode) {
    DestroyActive();
    tag_ = Tag::kErrorCode;
  }
  data_.error_code = error_code;
}

void LocalCharacteristicReadResult::set_data(std::vector<uint8_t> data) {
  if (tag_ == Tag::kData) {
    data_.data = std::move(data);
  } else {
    DestroyActive();
    tag_ = Tag::kData;
    new (&data_.data) std::vector<uint8_t>(
        std::move(data));
  }
}


LocalCharacteristicReadResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
    ::device::BluetoothGattService::GattErrorCode value)
    : error_code(std::move(value)) {}

LocalCharacteristicReadResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
    std::vector<uint8_t> value)
    : data(std::move(value)) {}

void LocalCharacteristicReadResult::DestroyActive() {
  switch (tag_) {

    case Tag::kErrorCode:
      std::destroy_at(&data_.error_code);
      break;
    case Tag::kData:
      std::destroy_at(&data_.data);
      break;
  }
}

bool LocalCharacteristicReadResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

Advertisement::IPCStableHashFunction Advertisement::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Advertisement>(message.name())) {
    case messages::Advertisement::kUnregister: {
      return &Advertisement::Unregister_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Advertisement::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Advertisement>(message.name())) {
      case messages::Advertisement::kUnregister:
            return "Receive bluetooth::mojom::Advertisement::Unregister";
    }
  } else {
    switch (static_cast<messages::Advertisement>(message.name())) {
      case messages::Advertisement::kUnregister:
            return "Receive reply bluetooth::mojom::Advertisement::Unregister";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Advertisement::Unregister_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91103209;  // IPCStableHash for bluetooth::mojom::Advertisement::Unregister
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool Advertisement::Unregister() {
  NOTREACHED();
}
class Advertisement_Unregister_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Advertisement_Unregister_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  Advertisement_Unregister_HandleSyncResponse(const Advertisement_Unregister_HandleSyncResponse&) = delete;
  Advertisement_Unregister_HandleSyncResponse& operator=(const Advertisement_Unregister_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class Advertisement_Unregister_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Advertisement_Unregister_ForwardToCallback(
      Advertisement::UnregisterCallback callback
      ) : callback_(std::move(callback)) {
  }

  Advertisement_Unregister_ForwardToCallback(const Advertisement_Unregister_ForwardToCallback&) = delete;
  Advertisement_Unregister_ForwardToCallback& operator=(const Advertisement_Unregister_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Advertisement::UnregisterCallback callback_;
};

AdvertisementProxy::AdvertisementProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool AdvertisementProxy::Unregister(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call bluetooth::mojom::Advertisement::Unregister (sync)");
#else
  TRACE_EVENT0("mojom", "Advertisement::Unregister");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Advertisement::kUnregister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Advertisement_Unregister_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Advertisement::Name_);
  message.set_method_name("Unregister");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Advertisement_Unregister_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "Advertisement::Unregister");
#endif
  return result;
}

void AdvertisementProxy::Unregister(
    UnregisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::Advertisement::Unregister");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Advertisement::kUnregister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Advertisement_Unregister_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Advertisement::Name_);
  message.set_method_name("Unregister");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Advertisement_Unregister_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Advertisement_Unregister_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Advertisement::UnregisterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Advertisement_Unregister_ProxyToResponder> proxy(
        new Advertisement_Unregister_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Advertisement_Unregister_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Advertisement_Unregister_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Advertisement_Unregister_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Advertisement::UnregisterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Advertisement_Unregister_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Advertisement_Unregister_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Advertisement_Unregister_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Advertisement.0
  bool success = true;
  Advertisement_Unregister_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Advertisement::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Advertisement_Unregister_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply bluetooth::mojom::Advertisement::Unregister");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Advertisement::kUnregister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Advertisement_Unregister_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Advertisement::Name_);
  message.set_method_name("Unregister");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Advertisement_Unregister_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Advertisement_Unregister_ResponseParams_Data* params =
      reinterpret_cast<internal::Advertisement_Unregister_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Advertisement.0
  bool success = true;
  Advertisement_Unregister_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Advertisement::Name_, 0, true);
    return false;
  }
  *result_ = true;
  return true;
}

// static
bool AdvertisementStubDispatch::Accept(
    Advertisement* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Advertisement>(message->header()->name)) {
    case messages::Advertisement::kUnregister: {
      break;
    }
  }
  return false;
}

// static
bool AdvertisementStubDispatch::AcceptWithResponder(
    Advertisement* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Advertisement>(message->header()->name)) {
    case messages::Advertisement::kUnregister: {
      internal::Advertisement_Unregister_Params_Data* params =
          reinterpret_cast<
              internal::Advertisement_Unregister_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Advertisement.0
      bool success = true;
      Advertisement_Unregister_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Advertisement::Name_, 0, false);
        return false;
      }
      auto callback =
          Advertisement_Unregister_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unregister(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAdvertisementValidationInfo[] = {
    { &internal::Advertisement_Unregister_Params_Data::Validate,
     &internal::Advertisement_Unregister_ResponseParams_Data::Validate},
};

bool AdvertisementRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::bluetooth::mojom::Advertisement::Name_,
    kAdvertisementValidationInfo);
}

bool AdvertisementResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::bluetooth::mojom::Advertisement::Name_,
    kAdvertisementValidationInfo);
}
// The declaration includes the definition on other builds.

DiscoverySession::IPCStableHashFunction DiscoverySession::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DiscoverySession>(message.name())) {
    case messages::DiscoverySession::kIsActive: {
      return &DiscoverySession::IsActive_Sym::IPCStableHash;
    }
    case messages::DiscoverySession::kStop: {
      return &DiscoverySession::Stop_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DiscoverySession::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DiscoverySession>(message.name())) {
      case messages::DiscoverySession::kIsActive:
            return "Receive bluetooth::mojom::DiscoverySession::IsActive";
      case messages::DiscoverySession::kStop:
            return "Receive bluetooth::mojom::DiscoverySession::Stop";
    }
  } else {
    switch (static_cast<messages::DiscoverySession>(message.name())) {
      case messages::DiscoverySession::kIsActive:
            return "Receive reply bluetooth::mojom::DiscoverySession::IsActive";
      case messages::DiscoverySession::kStop:
            return "Receive reply bluetooth::mojom::DiscoverySession::Stop";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DiscoverySession::IsActive_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5bccaf85;  // IPCStableHash for bluetooth::mojom::DiscoverySession::IsActive
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DiscoverySession::Stop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe6b8ab93;  // IPCStableHash for bluetooth::mojom::DiscoverySession::Stop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool DiscoverySession::IsActive(bool* out_active) {
  NOTREACHED();
}
bool DiscoverySession::Stop(bool* out_success) {
  NOTREACHED();
}
class DiscoverySession_IsActive_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  DiscoverySession_IsActive_HandleSyncResponse(
      bool* result, bool* out_active)
      : result_(result), out_active_(out_active) {
    DCHECK(!*result_);
  }

  DiscoverySession_IsActive_HandleSyncResponse(const DiscoverySession_IsActive_HandleSyncResponse&) = delete;
  DiscoverySession_IsActive_HandleSyncResponse& operator=(const DiscoverySession_IsActive_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_active_;};

class DiscoverySession_IsActive_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DiscoverySession_IsActive_ForwardToCallback(
      DiscoverySession::IsActiveCallback callback
      ) : callback_(std::move(callback)) {
  }

  DiscoverySession_IsActive_ForwardToCallback(const DiscoverySession_IsActive_ForwardToCallback&) = delete;
  DiscoverySession_IsActive_ForwardToCallback& operator=(const DiscoverySession_IsActive_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DiscoverySession::IsActiveCallback callback_;
};
class DiscoverySession_Stop_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  DiscoverySession_Stop_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }

  DiscoverySession_Stop_HandleSyncResponse(const DiscoverySession_Stop_HandleSyncResponse&) = delete;
  DiscoverySession_Stop_HandleSyncResponse& operator=(const DiscoverySession_Stop_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;};

class DiscoverySession_Stop_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DiscoverySession_Stop_ForwardToCallback(
      DiscoverySession::StopCallback callback
      ) : callback_(std::move(callback)) {
  }

  DiscoverySession_Stop_ForwardToCallback(const DiscoverySession_Stop_ForwardToCallback&) = delete;
  DiscoverySession_Stop_ForwardToCallback& operator=(const DiscoverySession_Stop_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DiscoverySession::StopCallback callback_;
};

DiscoverySessionProxy::DiscoverySessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool DiscoverySessionProxy::IsActive(
    bool* out_param_active) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call bluetooth::mojom::DiscoverySession::IsActive (sync)");
#else
  TRACE_EVENT0("mojom", "DiscoverySession::IsActive");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DiscoverySession::kIsActive), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::DiscoverySession_IsActive_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DiscoverySession::Name_);
  message.set_method_name("IsActive");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DiscoverySession_IsActive_HandleSyncResponse(
          &result, out_param_active));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "DiscoverySession::IsActive", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active"), out_param_active,
                        "<value of type bool>");
   });
#endif
  return result;
}

void DiscoverySessionProxy::IsActive(
    IsActiveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::DiscoverySession::IsActive");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DiscoverySession::kIsActive), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::DiscoverySession_IsActive_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DiscoverySession::Name_);
  message.set_method_name("IsActive");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DiscoverySession_IsActive_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DiscoverySessionProxy::Stop(
    bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call bluetooth::mojom::DiscoverySession::Stop (sync)");
#else
  TRACE_EVENT0("mojom", "DiscoverySession::Stop");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DiscoverySession::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::DiscoverySession_Stop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DiscoverySession::Name_);
  message.set_method_name("Stop");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DiscoverySession_Stop_HandleSyncResponse(
          &result, out_param_success));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "DiscoverySession::Stop", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void DiscoverySessionProxy::Stop(
    StopCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::DiscoverySession::Stop");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DiscoverySession::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::DiscoverySession_Stop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DiscoverySession::Name_);
  message.set_method_name("Stop");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DiscoverySession_Stop_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class DiscoverySession_IsActive_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DiscoverySession::IsActiveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DiscoverySession_IsActive_ProxyToResponder> proxy(
        new DiscoverySession_IsActive_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DiscoverySession_IsActive_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DiscoverySession_IsActive_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DiscoverySession_IsActive_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DiscoverySession::IsActiveCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_active);
};

bool DiscoverySession_IsActive_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DiscoverySession_IsActive_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DiscoverySession_IsActive_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DiscoverySession.0
  bool success = true;
  bool p_active{};
  DiscoverySession_IsActive_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_active = input_data_view.active();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DiscoverySession::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_active));
  }
  return true;
}

void DiscoverySession_IsActive_ProxyToResponder::Run(
    bool in_active) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::DiscoverySession::IsActive", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active"), in_active,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DiscoverySession::kIsActive), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::DiscoverySession_IsActive_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->active = in_active;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DiscoverySession::Name_);
  message.set_method_name("IsActive");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool DiscoverySession_IsActive_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DiscoverySession_IsActive_ResponseParams_Data* params =
      reinterpret_cast<internal::DiscoverySession_IsActive_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for DiscoverySession.0
  bool success = true;
  bool p_active{};
  DiscoverySession_IsActive_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_active = input_data_view.active();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DiscoverySession::Name_, 0, true);
    return false;
  }
  *out_active_ = std::move(p_active);
  *result_ = true;
  return true;
}
class DiscoverySession_Stop_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DiscoverySession::StopCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DiscoverySession_Stop_ProxyToResponder> proxy(
        new DiscoverySession_Stop_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DiscoverySession_Stop_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DiscoverySession_Stop_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DiscoverySession_Stop_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DiscoverySession::StopCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool DiscoverySession_Stop_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DiscoverySession_Stop_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DiscoverySession_Stop_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DiscoverySession.1
  bool success = true;
  bool p_success{};
  DiscoverySession_Stop_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DiscoverySession::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void DiscoverySession_Stop_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::DiscoverySession::Stop", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DiscoverySession::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::DiscoverySession_Stop_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DiscoverySession::Name_);
  message.set_method_name("Stop");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool DiscoverySession_Stop_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DiscoverySession_Stop_ResponseParams_Data* params =
      reinterpret_cast<internal::DiscoverySession_Stop_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for DiscoverySession.1
  bool success = true;
  bool p_success{};
  DiscoverySession_Stop_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DiscoverySession::Name_, 1, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}

// static
bool DiscoverySessionStubDispatch::Accept(
    DiscoverySession* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DiscoverySession>(message->header()->name)) {
    case messages::DiscoverySession::kIsActive: {
      break;
    }
    case messages::DiscoverySession::kStop: {
      break;
    }
  }
  return false;
}

// static
bool DiscoverySessionStubDispatch::AcceptWithResponder(
    DiscoverySession* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DiscoverySession>(message->header()->name)) {
    case messages::DiscoverySession::kIsActive: {
      internal::DiscoverySession_IsActive_Params_Data* params =
          reinterpret_cast<
              internal::DiscoverySession_IsActive_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DiscoverySession.0
      bool success = true;
      DiscoverySession_IsActive_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DiscoverySession::Name_, 0, false);
        return false;
      }
      auto callback =
          DiscoverySession_IsActive_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsActive(std::move(callback));
      return true;
    }
    case messages::DiscoverySession::kStop: {
      internal::DiscoverySession_Stop_Params_Data* params =
          reinterpret_cast<
              internal::DiscoverySession_Stop_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DiscoverySession.1
      bool success = true;
      DiscoverySession_Stop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DiscoverySession::Name_, 1, false);
        return false;
      }
      auto callback =
          DiscoverySession_Stop_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDiscoverySessionValidationInfo[] = {
    { &internal::DiscoverySession_IsActive_Params_Data::Validate,
     &internal::DiscoverySession_IsActive_ResponseParams_Data::Validate},
    { &internal::DiscoverySession_Stop_Params_Data::Validate,
     &internal::DiscoverySession_Stop_ResponseParams_Data::Validate},
};

bool DiscoverySessionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::bluetooth::mojom::DiscoverySession::Name_,
    kDiscoverySessionValidationInfo);
}

bool DiscoverySessionResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::bluetooth::mojom::DiscoverySession::Name_,
    kDiscoverySessionValidationInfo);
}
// The declaration includes the definition on other builds.

Socket::IPCStableHashFunction Socket::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Socket>(message.name())) {
    case messages::Socket::kDisconnect: {
      return &Socket::Disconnect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Socket::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Socket>(message.name())) {
      case messages::Socket::kDisconnect:
            return "Receive bluetooth::mojom::Socket::Disconnect";
    }
  } else {
    switch (static_cast<messages::Socket>(message.name())) {
      case messages::Socket::kDisconnect:
            return "Receive reply bluetooth::mojom::Socket::Disconnect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Socket::Disconnect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2751c52a;  // IPCStableHash for bluetooth::mojom::Socket::Disconnect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool Socket::Disconnect() {
  NOTREACHED();
}
class Socket_Disconnect_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Socket_Disconnect_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  Socket_Disconnect_HandleSyncResponse(const Socket_Disconnect_HandleSyncResponse&) = delete;
  Socket_Disconnect_HandleSyncResponse& operator=(const Socket_Disconnect_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class Socket_Disconnect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Socket_Disconnect_ForwardToCallback(
      Socket::DisconnectCallback callback
      ) : callback_(std::move(callback)) {
  }

  Socket_Disconnect_ForwardToCallback(const Socket_Disconnect_ForwardToCallback&) = delete;
  Socket_Disconnect_ForwardToCallback& operator=(const Socket_Disconnect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Socket::DisconnectCallback callback_;
};

SocketProxy::SocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool SocketProxy::Disconnect(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call bluetooth::mojom::Socket::Disconnect (sync)");
#else
  TRACE_EVENT0("mojom", "Socket::Disconnect");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Socket::kDisconnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Socket_Disconnect_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Socket::Name_);
  message.set_method_name("Disconnect");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Socket_Disconnect_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "Socket::Disconnect");
#endif
  return result;
}

void SocketProxy::Disconnect(
    DisconnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::Socket::Disconnect");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Socket::kDisconnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Socket_Disconnect_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Socket::Name_);
  message.set_method_name("Disconnect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Socket_Disconnect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Socket_Disconnect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Socket::DisconnectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Socket_Disconnect_ProxyToResponder> proxy(
        new Socket_Disconnect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Socket_Disconnect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Socket_Disconnect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Socket_Disconnect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Socket::DisconnectCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Socket_Disconnect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Socket_Disconnect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Socket_Disconnect_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Socket.0
  bool success = true;
  Socket_Disconnect_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Socket::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Socket_Disconnect_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply bluetooth::mojom::Socket::Disconnect");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Socket::kDisconnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Socket_Disconnect_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Socket::Name_);
  message.set_method_name("Disconnect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Socket_Disconnect_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Socket_Disconnect_ResponseParams_Data* params =
      reinterpret_cast<internal::Socket_Disconnect_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Socket.0
  bool success = true;
  Socket_Disconnect_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Socket::Name_, 0, true);
    return false;
  }
  *result_ = true;
  return true;
}

// static
bool SocketStubDispatch::Accept(
    Socket* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Socket>(message->header()->name)) {
    case messages::Socket::kDisconnect: {
      break;
    }
  }
  return false;
}

// static
bool SocketStubDispatch::AcceptWithResponder(
    Socket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Socket>(message->header()->name)) {
    case messages::Socket::kDisconnect: {
      internal::Socket_Disconnect_Params_Data* params =
          reinterpret_cast<
              internal::Socket_Disconnect_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Socket.0
      bool success = true;
      Socket_Disconnect_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Socket::Name_, 0, false);
        return false;
      }
      auto callback =
          Socket_Disconnect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Disconnect(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSocketValidationInfo[] = {
    { &internal::Socket_Disconnect_Params_Data::Validate,
     &internal::Socket_Disconnect_ResponseParams_Data::Validate},
};

bool SocketRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::bluetooth::mojom::Socket::Name_,
    kSocketValidationInfo);
}

bool SocketResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::bluetooth::mojom::Socket::Name_,
    kSocketValidationInfo);
}
// The declaration includes the definition on other builds.

ServerSocket::IPCStableHashFunction ServerSocket::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServerSocket>(message.name())) {
    case messages::ServerSocket::kAccept: {
      return &ServerSocket::Accept_Sym::IPCStableHash;
    }
    case messages::ServerSocket::kDisconnect: {
      return &ServerSocket::Disconnect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServerSocket::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServerSocket>(message.name())) {
      case messages::ServerSocket::kAccept:
            return "Receive bluetooth::mojom::ServerSocket::Accept";
      case messages::ServerSocket::kDisconnect:
            return "Receive bluetooth::mojom::ServerSocket::Disconnect";
    }
  } else {
    switch (static_cast<messages::ServerSocket>(message.name())) {
      case messages::ServerSocket::kAccept:
            return "Receive reply bluetooth::mojom::ServerSocket::Accept";
      case messages::ServerSocket::kDisconnect:
            return "Receive reply bluetooth::mojom::ServerSocket::Disconnect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServerSocket::Accept_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54beb429;  // IPCStableHash for bluetooth::mojom::ServerSocket::Accept
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServerSocket::Disconnect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a9ddae8;  // IPCStableHash for bluetooth::mojom::ServerSocket::Disconnect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool ServerSocket::Accept(AcceptConnectionResultPtr* out_result) {
  NOTREACHED();
}
bool ServerSocket::Disconnect() {
  NOTREACHED();
}
class ServerSocket_Accept_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ServerSocket_Accept_HandleSyncResponse(
      bool* result, AcceptConnectionResultPtr* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  ServerSocket_Accept_HandleSyncResponse(const ServerSocket_Accept_HandleSyncResponse&) = delete;
  ServerSocket_Accept_HandleSyncResponse& operator=(const ServerSocket_Accept_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  AcceptConnectionResultPtr* out_result_;};

class ServerSocket_Accept_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServerSocket_Accept_ForwardToCallback(
      ServerSocket::AcceptCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServerSocket_Accept_ForwardToCallback(const ServerSocket_Accept_ForwardToCallback&) = delete;
  ServerSocket_Accept_ForwardToCallback& operator=(const ServerSocket_Accept_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServerSocket::AcceptCallback callback_;
};
class ServerSocket_Disconnect_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ServerSocket_Disconnect_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  ServerSocket_Disconnect_HandleSyncResponse(const ServerSocket_Disconnect_HandleSyncResponse&) = delete;
  ServerSocket_Disconnect_HandleSyncResponse& operator=(const ServerSocket_Disconnect_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class ServerSocket_Disconnect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServerSocket_Disconnect_ForwardToCallback(
      ServerSocket::DisconnectCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServerSocket_Disconnect_ForwardToCallback(const ServerSocket_Disconnect_ForwardToCallback&) = delete;
  ServerSocket_Disconnect_ForwardToCallback& operator=(const ServerSocket_Disconnect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServerSocket::DisconnectCallback callback_;
};

ServerSocketProxy::ServerSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool ServerSocketProxy::Accept(
    AcceptConnectionResultPtr* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call bluetooth::mojom::ServerSocket::Accept (sync)");
#else
  TRACE_EVENT0("mojom", "ServerSocket::Accept");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServerSocket::kAccept), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::ServerSocket_Accept_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServerSocket::Name_);
  message.set_method_name("Accept");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServerSocket_Accept_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "ServerSocket::Accept", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type AcceptConnectionResultPtr>");
   });
#endif
  return result;
}

void ServerSocketProxy::Accept(
    AcceptCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::ServerSocket::Accept");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServerSocket::kAccept), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::ServerSocket_Accept_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServerSocket::Name_);
  message.set_method_name("Accept");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServerSocket_Accept_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool ServerSocketProxy::Disconnect(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call bluetooth::mojom::ServerSocket::Disconnect (sync)");
#else
  TRACE_EVENT0("mojom", "ServerSocket::Disconnect");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServerSocket::kDisconnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::ServerSocket_Disconnect_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServerSocket::Name_);
  message.set_method_name("Disconnect");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServerSocket_Disconnect_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "ServerSocket::Disconnect");
#endif
  return result;
}

void ServerSocketProxy::Disconnect(
    DisconnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::ServerSocket::Disconnect");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServerSocket::kDisconnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::ServerSocket_Disconnect_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServerSocket::Name_);
  message.set_method_name("Disconnect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServerSocket_Disconnect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ServerSocket_Accept_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServerSocket::AcceptCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServerSocket_Accept_ProxyToResponder> proxy(
        new ServerSocket_Accept_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServerSocket_Accept_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServerSocket_Accept_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServerSocket_Accept_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServerSocket::AcceptCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      AcceptConnectionResultPtr in_result);
};

bool ServerSocket_Accept_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServerSocket_Accept_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServerSocket_Accept_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServerSocket.0
  bool success = true;
  AcceptConnectionResultPtr p_result{};
  ServerSocket_Accept_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServerSocket::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ServerSocket_Accept_ProxyToResponder::Run(
    AcceptConnectionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::ServerSocket::Accept", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type AcceptConnectionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServerSocket::kAccept), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::ServerSocket_Accept_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::AcceptConnectionResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServerSocket::Name_);
  message.set_method_name("Accept");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ServerSocket_Accept_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServerSocket_Accept_ResponseParams_Data* params =
      reinterpret_cast<internal::ServerSocket_Accept_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for ServerSocket.0
  bool success = true;
  AcceptConnectionResultPtr p_result{};
  ServerSocket_Accept_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServerSocket::Name_, 0, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class ServerSocket_Disconnect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServerSocket::DisconnectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServerSocket_Disconnect_ProxyToResponder> proxy(
        new ServerSocket_Disconnect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServerSocket_Disconnect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServerSocket_Disconnect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServerSocket_Disconnect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServerSocket::DisconnectCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool ServerSocket_Disconnect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServerSocket_Disconnect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServerSocket_Disconnect_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServerSocket.1
  bool success = true;
  ServerSocket_Disconnect_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServerSocket::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void ServerSocket_Disconnect_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply bluetooth::mojom::ServerSocket::Disconnect");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServerSocket::kDisconnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::ServerSocket_Disconnect_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServerSocket::Name_);
  message.set_method_name("Disconnect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ServerSocket_Disconnect_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServerSocket_Disconnect_ResponseParams_Data* params =
      reinterpret_cast<internal::ServerSocket_Disconnect_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for ServerSocket.1
  bool success = true;
  ServerSocket_Disconnect_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServerSocket::Name_, 1, true);
    return false;
  }
  *result_ = true;
  return true;
}

// static
bool ServerSocketStubDispatch::Accept(
    ServerSocket* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServerSocket>(message->header()->name)) {
    case messages::ServerSocket::kAccept: {
      break;
    }
    case messages::ServerSocket::kDisconnect: {
      break;
    }
  }
  return false;
}

// static
bool ServerSocketStubDispatch::AcceptWithResponder(
    ServerSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServerSocket>(message->header()->name)) {
    case messages::ServerSocket::kAccept: {
      internal::ServerSocket_Accept_Params_Data* params =
          reinterpret_cast<
              internal::ServerSocket_Accept_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServerSocket.0
      bool success = true;
      ServerSocket_Accept_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServerSocket::Name_, 0, false);
        return false;
      }
      auto callback =
          ServerSocket_Accept_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Accept(std::move(callback));
      return true;
    }
    case messages::ServerSocket::kDisconnect: {
      internal::ServerSocket_Disconnect_Params_Data* params =
          reinterpret_cast<
              internal::ServerSocket_Disconnect_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServerSocket.1
      bool success = true;
      ServerSocket_Disconnect_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServerSocket::Name_, 1, false);
        return false;
      }
      auto callback =
          ServerSocket_Disconnect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Disconnect(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServerSocketValidationInfo[] = {
    { &internal::ServerSocket_Accept_Params_Data::Validate,
     &internal::ServerSocket_Accept_ResponseParams_Data::Validate},
    { &internal::ServerSocket_Disconnect_Params_Data::Validate,
     &internal::ServerSocket_Disconnect_ResponseParams_Data::Validate},
};

bool ServerSocketRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::bluetooth::mojom::ServerSocket::Name_,
    kServerSocketValidationInfo);
}

bool ServerSocketResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::bluetooth::mojom::ServerSocket::Name_,
    kServerSocketValidationInfo);
}
// The declaration includes the definition on other builds.

GattService::IPCStableHashFunction GattService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GattService>(message.name())) {
    case messages::GattService::kCreateCharacteristic: {
      return &GattService::CreateCharacteristic_Sym::IPCStableHash;
    }
    case messages::GattService::kRegister: {
      return &GattService::Register_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GattService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GattService>(message.name())) {
      case messages::GattService::kCreateCharacteristic:
            return "Receive bluetooth::mojom::GattService::CreateCharacteristic";
      case messages::GattService::kRegister:
            return "Receive bluetooth::mojom::GattService::Register";
    }
  } else {
    switch (static_cast<messages::GattService>(message.name())) {
      case messages::GattService::kCreateCharacteristic:
            return "Receive reply bluetooth::mojom::GattService::CreateCharacteristic";
      case messages::GattService::kRegister:
            return "Receive reply bluetooth::mojom::GattService::Register";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GattService::CreateCharacteristic_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x883c7568;  // IPCStableHash for bluetooth::mojom::GattService::CreateCharacteristic
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GattService::Register_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5117fea1;  // IPCStableHash for bluetooth::mojom::GattService::Register
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool GattService::CreateCharacteristic(const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothGattCharacteristic::Permissions& permissions, const ::device::BluetoothGattCharacteristic::Properties& properties, bool* out_success) {
  NOTREACHED();
}
class GattService_CreateCharacteristic_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GattService_CreateCharacteristic_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }

  GattService_CreateCharacteristic_HandleSyncResponse(const GattService_CreateCharacteristic_HandleSyncResponse&) = delete;
  GattService_CreateCharacteristic_HandleSyncResponse& operator=(const GattService_CreateCharacteristic_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;};

class GattService_CreateCharacteristic_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GattService_CreateCharacteristic_ForwardToCallback(
      GattService::CreateCharacteristicCallback callback
      ) : callback_(std::move(callback)) {
  }

  GattService_CreateCharacteristic_ForwardToCallback(const GattService_CreateCharacteristic_ForwardToCallback&) = delete;
  GattService_CreateCharacteristic_ForwardToCallback& operator=(const GattService_CreateCharacteristic_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GattService::CreateCharacteristicCallback callback_;
};

class GattService_Register_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GattService_Register_ForwardToCallback(
      GattService::RegisterCallback callback
      ) : callback_(std::move(callback)) {
  }

  GattService_Register_ForwardToCallback(const GattService_Register_ForwardToCallback&) = delete;
  GattService_Register_ForwardToCallback& operator=(const GattService_Register_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GattService::RegisterCallback callback_;
};

GattServiceProxy::GattServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool GattServiceProxy::CreateCharacteristic(
    const ::device::BluetoothUUID& param_characteristic_uuid, const ::device::BluetoothGattCharacteristic::Permissions& param_permissions, const ::device::BluetoothGattCharacteristic::Properties& param_properties, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call bluetooth::mojom::GattService::CreateCharacteristic (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_uuid"), param_characteristic_uuid,
                        "<value of type const ::device::BluetoothUUID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permissions"), param_permissions,
                        "<value of type const ::device::BluetoothGattCharacteristic::Permissions&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("properties"), param_properties,
                        "<value of type const ::device::BluetoothGattCharacteristic::Properties&>");
   });
#else
  TRACE_EVENT0("mojom", "GattService::CreateCharacteristic");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GattService::kCreateCharacteristic), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::GattService_CreateCharacteristic_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_uuid)::BaseType> characteristic_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    param_characteristic_uuid,
    characteristic_uuid_fragment);

  params->characteristic_uuid.Set(
      characteristic_uuid_fragment.is_null() ? nullptr : characteristic_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_uuid in GattService.CreateCharacteristic request");
  mojo::internal::MessageFragment<
      typename decltype(params->permissions)::BaseType> permissions_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::GattCharacteristicPermissionsDataView>(
    param_permissions,
    permissions_fragment);

  params->permissions.Set(
      permissions_fragment.is_null() ? nullptr : permissions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->permissions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null permissions in GattService.CreateCharacteristic request");
  mojo::internal::MessageFragment<
      typename decltype(params->properties)::BaseType> properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::GattCharacteristicPropertiesDataView>(
    param_properties,
    properties_fragment);

  params->properties.Set(
      properties_fragment.is_null() ? nullptr : properties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->properties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null properties in GattService.CreateCharacteristic request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GattService::Name_);
  message.set_method_name("CreateCharacteristic");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GattService_CreateCharacteristic_HandleSyncResponse(
          &result, out_param_success));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "GattService::CreateCharacteristic", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void GattServiceProxy::CreateCharacteristic(
    const ::device::BluetoothUUID& in_characteristic_uuid, const ::device::BluetoothGattCharacteristic::Permissions& in_permissions, const ::device::BluetoothGattCharacteristic::Properties& in_properties, CreateCharacteristicCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::GattService::CreateCharacteristic", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_uuid"), in_characteristic_uuid,
                        "<value of type const ::device::BluetoothUUID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permissions"), in_permissions,
                        "<value of type const ::device::BluetoothGattCharacteristic::Permissions&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("properties"), in_properties,
                        "<value of type const ::device::BluetoothGattCharacteristic::Properties&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GattService::kCreateCharacteristic), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::GattService_CreateCharacteristic_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_uuid)::BaseType> characteristic_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    in_characteristic_uuid,
    characteristic_uuid_fragment);

  params->characteristic_uuid.Set(
      characteristic_uuid_fragment.is_null() ? nullptr : characteristic_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_uuid in GattService.CreateCharacteristic request");
  mojo::internal::MessageFragment<
      typename decltype(params->permissions)::BaseType> permissions_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::GattCharacteristicPermissionsDataView>(
    in_permissions,
    permissions_fragment);

  params->permissions.Set(
      permissions_fragment.is_null() ? nullptr : permissions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->permissions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null permissions in GattService.CreateCharacteristic request");
  mojo::internal::MessageFragment<
      typename decltype(params->properties)::BaseType> properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::GattCharacteristicPropertiesDataView>(
    in_properties,
    properties_fragment);

  params->properties.Set(
      properties_fragment.is_null() ? nullptr : properties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->properties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null properties in GattService.CreateCharacteristic request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GattService::Name_);
  message.set_method_name("CreateCharacteristic");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GattService_CreateCharacteristic_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GattServiceProxy::Register(
    RegisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::GattService::Register");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GattService::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::GattService_Register_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GattService::Name_);
  message.set_method_name("Register");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GattService_Register_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class GattService_CreateCharacteristic_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GattService::CreateCharacteristicCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GattService_CreateCharacteristic_ProxyToResponder> proxy(
        new GattService_CreateCharacteristic_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GattService_CreateCharacteristic_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GattService_CreateCharacteristic_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GattService_CreateCharacteristic_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GattService::CreateCharacteristicCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool GattService_CreateCharacteristic_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GattService_CreateCharacteristic_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GattService_CreateCharacteristic_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GattService.0
  bool success = true;
  bool p_success{};
  GattService_CreateCharacteristic_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GattService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void GattService_CreateCharacteristic_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::GattService::CreateCharacteristic", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GattService::kCreateCharacteristic), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::GattService_CreateCharacteristic_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GattService::Name_);
  message.set_method_name("CreateCharacteristic");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GattService_CreateCharacteristic_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GattService_CreateCharacteristic_ResponseParams_Data* params =
      reinterpret_cast<internal::GattService_CreateCharacteristic_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for GattService.0
  bool success = true;
  bool p_success{};
  GattService_CreateCharacteristic_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GattService::Name_, 0, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}
class GattService_Register_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GattService::RegisterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GattService_Register_ProxyToResponder> proxy(
        new GattService_Register_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GattService_Register_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GattService_Register_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GattService_Register_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GattService::RegisterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::device::BluetoothGattService::GattErrorCode> in_error_code);
};

bool GattService_Register_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GattService_Register_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GattService_Register_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GattService.1
  bool success = true;
  std::optional<::device::BluetoothGattService::GattErrorCode> p_error_code{};
  GattService_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code)) {
    success = false;
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GattService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_code));
  }
  return true;
}

void GattService_Register_ProxyToResponder::Run(
    std::optional<::device::BluetoothGattService::GattErrorCode> in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::GattService::Register", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type std::optional<::device::BluetoothGattService::GattErrorCode>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GattService::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::GattService_Register_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->error_code_$flag = in_error_code.has_value();
  if (in_error_code.has_value()) {
    
    mojo::internal::Serialize<::bluetooth::mojom::GattServiceErrorCode>(
      in_error_code.value(),
      &params->error_code_$value);
  } else {
    params->error_code_$value =
        static_cast<int32_t>(::bluetooth::mojom::GattServiceErrorCode::kMinValue);
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GattService::Name_);
  message.set_method_name("Register");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GattServiceStubDispatch::Accept(
    GattService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GattService>(message->header()->name)) {
    case messages::GattService::kCreateCharacteristic: {
      break;
    }
    case messages::GattService::kRegister: {
      break;
    }
  }
  return false;
}

// static
bool GattServiceStubDispatch::AcceptWithResponder(
    GattService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GattService>(message->header()->name)) {
    case messages::GattService::kCreateCharacteristic: {
      internal::GattService_CreateCharacteristic_Params_Data* params =
          reinterpret_cast<
              internal::GattService_CreateCharacteristic_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GattService.0
      bool success = true;
      ::device::BluetoothUUID p_characteristic_uuid{};
      ::device::BluetoothGattCharacteristic::Permissions p_permissions{};
      ::device::BluetoothGattCharacteristic::Properties p_properties{};
      GattService_CreateCharacteristic_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCharacteristicUuid(&p_characteristic_uuid))
        success = false;
      if (success && !input_data_view.ReadPermissions(&p_permissions))
        success = false;
      if (success && !input_data_view.ReadProperties(&p_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GattService::Name_, 0, false);
        return false;
      }
      auto callback =
          GattService_CreateCharacteristic_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCharacteristic(        
        std::move(p_characteristic_uuid), 
        std::move(p_permissions), 
        std::move(p_properties), std::move(callback));
      return true;
    }
    case messages::GattService::kRegister: {
      internal::GattService_Register_Params_Data* params =
          reinterpret_cast<
              internal::GattService_Register_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GattService.1
      bool success = true;
      GattService_Register_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GattService::Name_, 1, false);
        return false;
      }
      auto callback =
          GattService_Register_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Register(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kGattServiceValidationInfo[] = {
    { &internal::GattService_CreateCharacteristic_Params_Data::Validate,
     &internal::GattService_CreateCharacteristic_ResponseParams_Data::Validate},
    { &internal::GattService_Register_Params_Data::Validate,
     &internal::GattService_Register_ResponseParams_Data::Validate},
};

bool GattServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::bluetooth::mojom::GattService::Name_,
    kGattServiceValidationInfo);
}

bool GattServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::bluetooth::mojom::GattService::Name_,
    kGattServiceValidationInfo);
}
// The declaration includes the definition on other builds.

GattServiceObserver::IPCStableHashFunction GattServiceObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GattServiceObserver>(message.name())) {
    case messages::GattServiceObserver::kOnLocalCharacteristicRead: {
      return &GattServiceObserver::OnLocalCharacteristicRead_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GattServiceObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GattServiceObserver>(message.name())) {
      case messages::GattServiceObserver::kOnLocalCharacteristicRead:
            return "Receive bluetooth::mojom::GattServiceObserver::OnLocalCharacteristicRead";
    }
  } else {
    switch (static_cast<messages::GattServiceObserver>(message.name())) {
      case messages::GattServiceObserver::kOnLocalCharacteristicRead:
            return "Receive reply bluetooth::mojom::GattServiceObserver::OnLocalCharacteristicRead";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GattServiceObserver::OnLocalCharacteristicRead_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf057de45;  // IPCStableHash for bluetooth::mojom::GattServiceObserver::OnLocalCharacteristicRead
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class GattServiceObserver_OnLocalCharacteristicRead_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GattServiceObserver_OnLocalCharacteristicRead_ForwardToCallback(
      GattServiceObserver::OnLocalCharacteristicReadCallback callback
      ) : callback_(std::move(callback)) {
  }

  GattServiceObserver_OnLocalCharacteristicRead_ForwardToCallback(const GattServiceObserver_OnLocalCharacteristicRead_ForwardToCallback&) = delete;
  GattServiceObserver_OnLocalCharacteristicRead_ForwardToCallback& operator=(const GattServiceObserver_OnLocalCharacteristicRead_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GattServiceObserver::OnLocalCharacteristicReadCallback callback_;
};

GattServiceObserverProxy::GattServiceObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GattServiceObserverProxy::OnLocalCharacteristicRead(
    ::bluetooth::mojom::DeviceInfoPtr in_remote_device, const ::device::BluetoothUUID& in_characteristic_uuid, const ::device::BluetoothUUID& in_service_uuid, uint32_t in_offset, OnLocalCharacteristicReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::GattServiceObserver::OnLocalCharacteristicRead", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_device"), in_remote_device,
                        "<value of type ::bluetooth::mojom::DeviceInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_uuid"), in_characteristic_uuid,
                        "<value of type const ::device::BluetoothUUID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_uuid"), in_service_uuid,
                        "<value of type const ::device::BluetoothUUID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GattServiceObserver::kOnLocalCharacteristicRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::GattServiceObserver_OnLocalCharacteristicRead_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->remote_device)::BaseType> remote_device_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::DeviceInfoDataView>(
    in_remote_device,
    remote_device_fragment);

  params->remote_device.Set(
      remote_device_fragment.is_null() ? nullptr : remote_device_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->remote_device.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null remote_device in GattServiceObserver.OnLocalCharacteristicRead request");
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_uuid)::BaseType> characteristic_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    in_characteristic_uuid,
    characteristic_uuid_fragment);

  params->characteristic_uuid.Set(
      characteristic_uuid_fragment.is_null() ? nullptr : characteristic_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_uuid in GattServiceObserver.OnLocalCharacteristicRead request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_uuid)::BaseType> service_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    in_service_uuid,
    service_uuid_fragment);

  params->service_uuid.Set(
      service_uuid_fragment.is_null() ? nullptr : service_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_uuid in GattServiceObserver.OnLocalCharacteristicRead request");

  params->offset = in_offset;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GattServiceObserver::Name_);
  message.set_method_name("OnLocalCharacteristicRead");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GattServiceObserver_OnLocalCharacteristicRead_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class GattServiceObserver_OnLocalCharacteristicRead_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GattServiceObserver::OnLocalCharacteristicReadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GattServiceObserver_OnLocalCharacteristicRead_ProxyToResponder> proxy(
        new GattServiceObserver_OnLocalCharacteristicRead_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GattServiceObserver_OnLocalCharacteristicRead_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GattServiceObserver_OnLocalCharacteristicRead_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GattServiceObserver_OnLocalCharacteristicRead_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GattServiceObserver::OnLocalCharacteristicReadCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      LocalCharacteristicReadResultPtr in_read_result);
};

bool GattServiceObserver_OnLocalCharacteristicRead_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GattServiceObserver.0
  bool success = true;
  LocalCharacteristicReadResultPtr p_read_result{};
  GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadReadResult(&p_read_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GattServiceObserver::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_read_result));
  }
  return true;
}

void GattServiceObserver_OnLocalCharacteristicRead_ProxyToResponder::Run(
    LocalCharacteristicReadResultPtr in_read_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::GattServiceObserver::OnLocalCharacteristicRead", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("read_result"), in_read_result,
                        "<value of type LocalCharacteristicReadResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GattServiceObserver::kOnLocalCharacteristicRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->read_result)>
      read_result_fragment(params.message());
  read_result_fragment.Claim(&params->read_result);
  
  mojo::internal::Serialize<::bluetooth::mojom::LocalCharacteristicReadResultDataView>(
    in_read_result,
    read_result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->read_result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null read_result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GattServiceObserver::Name_);
  message.set_method_name("OnLocalCharacteristicRead");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GattServiceObserverStubDispatch::Accept(
    GattServiceObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GattServiceObserver>(message->header()->name)) {
    case messages::GattServiceObserver::kOnLocalCharacteristicRead: {
      break;
    }
  }
  return false;
}

// static
bool GattServiceObserverStubDispatch::AcceptWithResponder(
    GattServiceObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GattServiceObserver>(message->header()->name)) {
    case messages::GattServiceObserver::kOnLocalCharacteristicRead: {
      internal::GattServiceObserver_OnLocalCharacteristicRead_Params_Data* params =
          reinterpret_cast<
              internal::GattServiceObserver_OnLocalCharacteristicRead_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GattServiceObserver.0
      bool success = true;
      ::bluetooth::mojom::DeviceInfoPtr p_remote_device{};
      ::device::BluetoothUUID p_characteristic_uuid{};
      ::device::BluetoothUUID p_service_uuid{};
      uint32_t p_offset{};
      GattServiceObserver_OnLocalCharacteristicRead_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRemoteDevice(&p_remote_device))
        success = false;
      if (success && !input_data_view.ReadCharacteristicUuid(&p_characteristic_uuid))
        success = false;
      if (success && !input_data_view.ReadServiceUuid(&p_service_uuid))
        success = false;
      if (success)
        p_offset = input_data_view.offset();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GattServiceObserver::Name_, 0, false);
        return false;
      }
      auto callback =
          GattServiceObserver_OnLocalCharacteristicRead_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLocalCharacteristicRead(        
        std::move(p_remote_device), 
        std::move(p_characteristic_uuid), 
        std::move(p_service_uuid), 
        std::move(p_offset), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kGattServiceObserverValidationInfo[] = {
    { &internal::GattServiceObserver_OnLocalCharacteristicRead_Params_Data::Validate,
     &internal::GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data::Validate},
};

bool GattServiceObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::bluetooth::mojom::GattServiceObserver::Name_,
    kGattServiceObserverValidationInfo);
}

bool GattServiceObserverResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::bluetooth::mojom::GattServiceObserver::Name_,
    kGattServiceObserverValidationInfo);
}
// The declaration includes the definition on other builds.

Adapter::IPCStableHashFunction Adapter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Adapter>(message.name())) {
    case messages::Adapter::kConnectToDevice: {
      return &Adapter::ConnectToDevice_Sym::IPCStableHash;
    }
    case messages::Adapter::kGetDevices: {
      return &Adapter::GetDevices_Sym::IPCStableHash;
    }
    case messages::Adapter::kGetInfo: {
      return &Adapter::GetInfo_Sym::IPCStableHash;
    }
    case messages::Adapter::kAddObserver: {
      return &Adapter::AddObserver_Sym::IPCStableHash;
    }
    case messages::Adapter::kRegisterAdvertisement: {
      return &Adapter::RegisterAdvertisement_Sym::IPCStableHash;
    }
    case messages::Adapter::kSetDiscoverable: {
      return &Adapter::SetDiscoverable_Sym::IPCStableHash;
    }
    case messages::Adapter::kSetName: {
      return &Adapter::SetName_Sym::IPCStableHash;
    }
    case messages::Adapter::kStartDiscoverySession: {
      return &Adapter::StartDiscoverySession_Sym::IPCStableHash;
    }
    case messages::Adapter::kConnectToServiceInsecurely: {
      return &Adapter::ConnectToServiceInsecurely_Sym::IPCStableHash;
    }
    case messages::Adapter::kCreateRfcommServiceInsecurely: {
      return &Adapter::CreateRfcommServiceInsecurely_Sym::IPCStableHash;
    }
    case messages::Adapter::kCreateLocalGattService: {
      return &Adapter::CreateLocalGattService_Sym::IPCStableHash;
    }
    case messages::Adapter::kIsLeScatternetDualRoleSupported: {
      return &Adapter::IsLeScatternetDualRoleSupported_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Adapter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Adapter>(message.name())) {
      case messages::Adapter::kConnectToDevice:
            return "Receive bluetooth::mojom::Adapter::ConnectToDevice";
      case messages::Adapter::kGetDevices:
            return "Receive bluetooth::mojom::Adapter::GetDevices";
      case messages::Adapter::kGetInfo:
            return "Receive bluetooth::mojom::Adapter::GetInfo";
      case messages::Adapter::kAddObserver:
            return "Receive bluetooth::mojom::Adapter::AddObserver";
      case messages::Adapter::kRegisterAdvertisement:
            return "Receive bluetooth::mojom::Adapter::RegisterAdvertisement";
      case messages::Adapter::kSetDiscoverable:
            return "Receive bluetooth::mojom::Adapter::SetDiscoverable";
      case messages::Adapter::kSetName:
            return "Receive bluetooth::mojom::Adapter::SetName";
      case messages::Adapter::kStartDiscoverySession:
            return "Receive bluetooth::mojom::Adapter::StartDiscoverySession";
      case messages::Adapter::kConnectToServiceInsecurely:
            return "Receive bluetooth::mojom::Adapter::ConnectToServiceInsecurely";
      case messages::Adapter::kCreateRfcommServiceInsecurely:
            return "Receive bluetooth::mojom::Adapter::CreateRfcommServiceInsecurely";
      case messages::Adapter::kCreateLocalGattService:
            return "Receive bluetooth::mojom::Adapter::CreateLocalGattService";
      case messages::Adapter::kIsLeScatternetDualRoleSupported:
            return "Receive bluetooth::mojom::Adapter::IsLeScatternetDualRoleSupported";
    }
  } else {
    switch (static_cast<messages::Adapter>(message.name())) {
      case messages::Adapter::kConnectToDevice:
            return "Receive reply bluetooth::mojom::Adapter::ConnectToDevice";
      case messages::Adapter::kGetDevices:
            return "Receive reply bluetooth::mojom::Adapter::GetDevices";
      case messages::Adapter::kGetInfo:
            return "Receive reply bluetooth::mojom::Adapter::GetInfo";
      case messages::Adapter::kAddObserver:
            return "Receive reply bluetooth::mojom::Adapter::AddObserver";
      case messages::Adapter::kRegisterAdvertisement:
            return "Receive reply bluetooth::mojom::Adapter::RegisterAdvertisement";
      case messages::Adapter::kSetDiscoverable:
            return "Receive reply bluetooth::mojom::Adapter::SetDiscoverable";
      case messages::Adapter::kSetName:
            return "Receive reply bluetooth::mojom::Adapter::SetName";
      case messages::Adapter::kStartDiscoverySession:
            return "Receive reply bluetooth::mojom::Adapter::StartDiscoverySession";
      case messages::Adapter::kConnectToServiceInsecurely:
            return "Receive reply bluetooth::mojom::Adapter::ConnectToServiceInsecurely";
      case messages::Adapter::kCreateRfcommServiceInsecurely:
            return "Receive reply bluetooth::mojom::Adapter::CreateRfcommServiceInsecurely";
      case messages::Adapter::kCreateLocalGattService:
            return "Receive reply bluetooth::mojom::Adapter::CreateLocalGattService";
      case messages::Adapter::kIsLeScatternetDualRoleSupported:
            return "Receive reply bluetooth::mojom::Adapter::IsLeScatternetDualRoleSupported";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Adapter::ConnectToDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf43b9462;  // IPCStableHash for bluetooth::mojom::Adapter::ConnectToDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Adapter::GetDevices_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6ed7566e;  // IPCStableHash for bluetooth::mojom::Adapter::GetDevices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Adapter::GetInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe1d01ef3;  // IPCStableHash for bluetooth::mojom::Adapter::GetInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Adapter::AddObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0bfbbbab;  // IPCStableHash for bluetooth::mojom::Adapter::AddObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Adapter::RegisterAdvertisement_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5ee1a9e4;  // IPCStableHash for bluetooth::mojom::Adapter::RegisterAdvertisement
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Adapter::SetDiscoverable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x80da1737;  // IPCStableHash for bluetooth::mojom::Adapter::SetDiscoverable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Adapter::SetName_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x02f4b6e4;  // IPCStableHash for bluetooth::mojom::Adapter::SetName
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Adapter::StartDiscoverySession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b8c72bf;  // IPCStableHash for bluetooth::mojom::Adapter::StartDiscoverySession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Adapter::ConnectToServiceInsecurely_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa67fab39;  // IPCStableHash for bluetooth::mojom::Adapter::ConnectToServiceInsecurely
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Adapter::CreateRfcommServiceInsecurely_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25978803;  // IPCStableHash for bluetooth::mojom::Adapter::CreateRfcommServiceInsecurely
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Adapter::CreateLocalGattService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbf3ce9b0;  // IPCStableHash for bluetooth::mojom::Adapter::CreateLocalGattService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Adapter::IsLeScatternetDualRoleSupported_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25a21c8b;  // IPCStableHash for bluetooth::mojom::Adapter::IsLeScatternetDualRoleSupported
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool Adapter::GetInfo(AdapterInfoPtr* out_info) {
  NOTREACHED();
}
bool Adapter::AddObserver(::mojo::PendingRemote<AdapterObserver> observer) {
  NOTREACHED();
}
bool Adapter::RegisterAdvertisement(const ::device::BluetoothUUID& service_id, const std::vector<uint8_t>& service_data, bool use_scan_response, bool connectable, ::mojo::PendingRemote<Advertisement>* out_advertisement) {
  NOTREACHED();
}
bool Adapter::SetDiscoverable(bool discoverable, bool* out_success) {
  NOTREACHED();
}
bool Adapter::SetName(const std::string& name, bool* out_success) {
  NOTREACHED();
}
bool Adapter::StartDiscoverySession(const std::string& client_name, ::mojo::PendingRemote<DiscoverySession>* out_session) {
  NOTREACHED();
}
bool Adapter::ConnectToServiceInsecurely(const std::string& address, const ::device::BluetoothUUID& service_uuid, bool should_unbond_on_error, ConnectToServiceResultPtr* out_result) {
  NOTREACHED();
}
bool Adapter::CreateRfcommServiceInsecurely(const std::string& service_name, const ::device::BluetoothUUID& service_uuid, ::mojo::PendingRemote<ServerSocket>* out_server_socket) {
  NOTREACHED();
}
bool Adapter::CreateLocalGattService(const ::device::BluetoothUUID& service_id, ::mojo::PendingRemote<GattServiceObserver> observer, ::mojo::PendingRemote<GattService>* out_gatt_service) {
  NOTREACHED();
}
bool Adapter::IsLeScatternetDualRoleSupported(bool* out_is_supported) {
  NOTREACHED();
}

class Adapter_ConnectToDevice_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Adapter_ConnectToDevice_ForwardToCallback(
      Adapter::ConnectToDeviceCallback callback
      ) : callback_(std::move(callback)) {
  }

  Adapter_ConnectToDevice_ForwardToCallback(const Adapter_ConnectToDevice_ForwardToCallback&) = delete;
  Adapter_ConnectToDevice_ForwardToCallback& operator=(const Adapter_ConnectToDevice_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Adapter::ConnectToDeviceCallback callback_;
};

class Adapter_GetDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Adapter_GetDevices_ForwardToCallback(
      Adapter::GetDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  Adapter_GetDevices_ForwardToCallback(const Adapter_GetDevices_ForwardToCallback&) = delete;
  Adapter_GetDevices_ForwardToCallback& operator=(const Adapter_GetDevices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Adapter::GetDevicesCallback callback_;
};
class Adapter_GetInfo_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Adapter_GetInfo_HandleSyncResponse(
      bool* result, AdapterInfoPtr* out_info)
      : result_(result), out_info_(out_info) {
    DCHECK(!*result_);
  }

  Adapter_GetInfo_HandleSyncResponse(const Adapter_GetInfo_HandleSyncResponse&) = delete;
  Adapter_GetInfo_HandleSyncResponse& operator=(const Adapter_GetInfo_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  AdapterInfoPtr* out_info_;};

class Adapter_GetInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Adapter_GetInfo_ForwardToCallback(
      Adapter::GetInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  Adapter_GetInfo_ForwardToCallback(const Adapter_GetInfo_ForwardToCallback&) = delete;
  Adapter_GetInfo_ForwardToCallback& operator=(const Adapter_GetInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Adapter::GetInfoCallback callback_;
};
class Adapter_AddObserver_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Adapter_AddObserver_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  Adapter_AddObserver_HandleSyncResponse(const Adapter_AddObserver_HandleSyncResponse&) = delete;
  Adapter_AddObserver_HandleSyncResponse& operator=(const Adapter_AddObserver_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class Adapter_AddObserver_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Adapter_AddObserver_ForwardToCallback(
      Adapter::AddObserverCallback callback
      ) : callback_(std::move(callback)) {
  }

  Adapter_AddObserver_ForwardToCallback(const Adapter_AddObserver_ForwardToCallback&) = delete;
  Adapter_AddObserver_ForwardToCallback& operator=(const Adapter_AddObserver_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Adapter::AddObserverCallback callback_;
};
class Adapter_RegisterAdvertisement_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Adapter_RegisterAdvertisement_HandleSyncResponse(
      bool* result, ::mojo::PendingRemote<Advertisement>* out_advertisement)
      : result_(result), out_advertisement_(out_advertisement) {
    DCHECK(!*result_);
  }

  Adapter_RegisterAdvertisement_HandleSyncResponse(const Adapter_RegisterAdvertisement_HandleSyncResponse&) = delete;
  Adapter_RegisterAdvertisement_HandleSyncResponse& operator=(const Adapter_RegisterAdvertisement_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::mojo::PendingRemote<Advertisement>* out_advertisement_;};

class Adapter_RegisterAdvertisement_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Adapter_RegisterAdvertisement_ForwardToCallback(
      Adapter::RegisterAdvertisementCallback callback
      ) : callback_(std::move(callback)) {
  }

  Adapter_RegisterAdvertisement_ForwardToCallback(const Adapter_RegisterAdvertisement_ForwardToCallback&) = delete;
  Adapter_RegisterAdvertisement_ForwardToCallback& operator=(const Adapter_RegisterAdvertisement_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Adapter::RegisterAdvertisementCallback callback_;
};
class Adapter_SetDiscoverable_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Adapter_SetDiscoverable_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }

  Adapter_SetDiscoverable_HandleSyncResponse(const Adapter_SetDiscoverable_HandleSyncResponse&) = delete;
  Adapter_SetDiscoverable_HandleSyncResponse& operator=(const Adapter_SetDiscoverable_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;};

class Adapter_SetDiscoverable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Adapter_SetDiscoverable_ForwardToCallback(
      Adapter::SetDiscoverableCallback callback
      ) : callback_(std::move(callback)) {
  }

  Adapter_SetDiscoverable_ForwardToCallback(const Adapter_SetDiscoverable_ForwardToCallback&) = delete;
  Adapter_SetDiscoverable_ForwardToCallback& operator=(const Adapter_SetDiscoverable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Adapter::SetDiscoverableCallback callback_;
};
class Adapter_SetName_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Adapter_SetName_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }

  Adapter_SetName_HandleSyncResponse(const Adapter_SetName_HandleSyncResponse&) = delete;
  Adapter_SetName_HandleSyncResponse& operator=(const Adapter_SetName_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;};

class Adapter_SetName_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Adapter_SetName_ForwardToCallback(
      Adapter::SetNameCallback callback
      ) : callback_(std::move(callback)) {
  }

  Adapter_SetName_ForwardToCallback(const Adapter_SetName_ForwardToCallback&) = delete;
  Adapter_SetName_ForwardToCallback& operator=(const Adapter_SetName_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Adapter::SetNameCallback callback_;
};
class Adapter_StartDiscoverySession_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Adapter_StartDiscoverySession_HandleSyncResponse(
      bool* result, ::mojo::PendingRemote<DiscoverySession>* out_session)
      : result_(result), out_session_(out_session) {
    DCHECK(!*result_);
  }

  Adapter_StartDiscoverySession_HandleSyncResponse(const Adapter_StartDiscoverySession_HandleSyncResponse&) = delete;
  Adapter_StartDiscoverySession_HandleSyncResponse& operator=(const Adapter_StartDiscoverySession_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::mojo::PendingRemote<DiscoverySession>* out_session_;};

class Adapter_StartDiscoverySession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Adapter_StartDiscoverySession_ForwardToCallback(
      Adapter::StartDiscoverySessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  Adapter_StartDiscoverySession_ForwardToCallback(const Adapter_StartDiscoverySession_ForwardToCallback&) = delete;
  Adapter_StartDiscoverySession_ForwardToCallback& operator=(const Adapter_StartDiscoverySession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Adapter::StartDiscoverySessionCallback callback_;
};
class Adapter_ConnectToServiceInsecurely_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Adapter_ConnectToServiceInsecurely_HandleSyncResponse(
      bool* result, ConnectToServiceResultPtr* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  Adapter_ConnectToServiceInsecurely_HandleSyncResponse(const Adapter_ConnectToServiceInsecurely_HandleSyncResponse&) = delete;
  Adapter_ConnectToServiceInsecurely_HandleSyncResponse& operator=(const Adapter_ConnectToServiceInsecurely_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ConnectToServiceResultPtr* out_result_;};

class Adapter_ConnectToServiceInsecurely_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Adapter_ConnectToServiceInsecurely_ForwardToCallback(
      Adapter::ConnectToServiceInsecurelyCallback callback
      ) : callback_(std::move(callback)) {
  }

  Adapter_ConnectToServiceInsecurely_ForwardToCallback(const Adapter_ConnectToServiceInsecurely_ForwardToCallback&) = delete;
  Adapter_ConnectToServiceInsecurely_ForwardToCallback& operator=(const Adapter_ConnectToServiceInsecurely_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Adapter::ConnectToServiceInsecurelyCallback callback_;
};
class Adapter_CreateRfcommServiceInsecurely_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Adapter_CreateRfcommServiceInsecurely_HandleSyncResponse(
      bool* result, ::mojo::PendingRemote<ServerSocket>* out_server_socket)
      : result_(result), out_server_socket_(out_server_socket) {
    DCHECK(!*result_);
  }

  Adapter_CreateRfcommServiceInsecurely_HandleSyncResponse(const Adapter_CreateRfcommServiceInsecurely_HandleSyncResponse&) = delete;
  Adapter_CreateRfcommServiceInsecurely_HandleSyncResponse& operator=(const Adapter_CreateRfcommServiceInsecurely_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::mojo::PendingRemote<ServerSocket>* out_server_socket_;};

class Adapter_CreateRfcommServiceInsecurely_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Adapter_CreateRfcommServiceInsecurely_ForwardToCallback(
      Adapter::CreateRfcommServiceInsecurelyCallback callback
      ) : callback_(std::move(callback)) {
  }

  Adapter_CreateRfcommServiceInsecurely_ForwardToCallback(const Adapter_CreateRfcommServiceInsecurely_ForwardToCallback&) = delete;
  Adapter_CreateRfcommServiceInsecurely_ForwardToCallback& operator=(const Adapter_CreateRfcommServiceInsecurely_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Adapter::CreateRfcommServiceInsecurelyCallback callback_;
};
class Adapter_CreateLocalGattService_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Adapter_CreateLocalGattService_HandleSyncResponse(
      bool* result, ::mojo::PendingRemote<GattService>* out_gatt_service)
      : result_(result), out_gatt_service_(out_gatt_service) {
    DCHECK(!*result_);
  }

  Adapter_CreateLocalGattService_HandleSyncResponse(const Adapter_CreateLocalGattService_HandleSyncResponse&) = delete;
  Adapter_CreateLocalGattService_HandleSyncResponse& operator=(const Adapter_CreateLocalGattService_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::mojo::PendingRemote<GattService>* out_gatt_service_;};

class Adapter_CreateLocalGattService_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Adapter_CreateLocalGattService_ForwardToCallback(
      Adapter::CreateLocalGattServiceCallback callback
      ) : callback_(std::move(callback)) {
  }

  Adapter_CreateLocalGattService_ForwardToCallback(const Adapter_CreateLocalGattService_ForwardToCallback&) = delete;
  Adapter_CreateLocalGattService_ForwardToCallback& operator=(const Adapter_CreateLocalGattService_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Adapter::CreateLocalGattServiceCallback callback_;
};
class Adapter_IsLeScatternetDualRoleSupported_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Adapter_IsLeScatternetDualRoleSupported_HandleSyncResponse(
      bool* result, bool* out_is_supported)
      : result_(result), out_is_supported_(out_is_supported) {
    DCHECK(!*result_);
  }

  Adapter_IsLeScatternetDualRoleSupported_HandleSyncResponse(const Adapter_IsLeScatternetDualRoleSupported_HandleSyncResponse&) = delete;
  Adapter_IsLeScatternetDualRoleSupported_HandleSyncResponse& operator=(const Adapter_IsLeScatternetDualRoleSupported_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_is_supported_;};

class Adapter_IsLeScatternetDualRoleSupported_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Adapter_IsLeScatternetDualRoleSupported_ForwardToCallback(
      Adapter::IsLeScatternetDualRoleSupportedCallback callback
      ) : callback_(std::move(callback)) {
  }

  Adapter_IsLeScatternetDualRoleSupported_ForwardToCallback(const Adapter_IsLeScatternetDualRoleSupported_ForwardToCallback&) = delete;
  Adapter_IsLeScatternetDualRoleSupported_ForwardToCallback& operator=(const Adapter_IsLeScatternetDualRoleSupported_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Adapter::IsLeScatternetDualRoleSupportedCallback callback_;
};

AdapterProxy::AdapterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AdapterProxy::ConnectToDevice(
    const std::string& in_address, ConnectToDeviceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Adapter::ConnectToDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address"), in_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kConnectToDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_ConnectToDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->address)::BaseType> address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_address,
    address_fragment);

  params->address.Set(
      address_fragment.is_null() ? nullptr : address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null address in Adapter.ConnectToDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("ConnectToDevice");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_ConnectToDevice_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AdapterProxy::GetDevices(
    GetDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::Adapter::GetDevices");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_GetDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("GetDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_GetDevices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool AdapterProxy::GetInfo(
    AdapterInfoPtr* out_param_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call bluetooth::mojom::Adapter::GetInfo (sync)");
#else
  TRACE_EVENT0("mojom", "Adapter::GetInfo");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kGetInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_GetInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("GetInfo");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_GetInfo_HandleSyncResponse(
          &result, out_param_info));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Adapter::GetInfo", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), out_param_info,
                        "<value of type AdapterInfoPtr>");
   });
#endif
  return result;
}

void AdapterProxy::GetInfo(
    GetInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::Adapter::GetInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kGetInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_GetInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("GetInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_GetInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool AdapterProxy::AddObserver(
    ::mojo::PendingRemote<AdapterObserver> param_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call bluetooth::mojom::Adapter::AddObserver (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), param_observer,
                        "<value of type ::mojo::PendingRemote<AdapterObserver>>");
   });
#else
  TRACE_EVENT0("mojom", "Adapter::AddObserver");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kAddObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_AddObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::AdapterObserverInterfaceBase>>(
    param_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in Adapter.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("AddObserver");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_AddObserver_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "Adapter::AddObserver");
#endif
  return result;
}

void AdapterProxy::AddObserver(
    ::mojo::PendingRemote<AdapterObserver> in_observer, AddObserverCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Adapter::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<AdapterObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kAddObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_AddObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::AdapterObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in Adapter.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("AddObserver");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_AddObserver_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool AdapterProxy::RegisterAdvertisement(
    const ::device::BluetoothUUID& param_service_id, const std::vector<uint8_t>& param_service_data, bool param_use_scan_response, bool param_connectable, ::mojo::PendingRemote<Advertisement>* out_param_advertisement) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call bluetooth::mojom::Adapter::RegisterAdvertisement (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), param_service_id,
                        "<value of type const ::device::BluetoothUUID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_data"), param_service_data,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("use_scan_response"), param_use_scan_response,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connectable"), param_connectable,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "Adapter::RegisterAdvertisement");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kRegisterAdvertisement), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_RegisterAdvertisement_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    param_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in Adapter.RegisterAdvertisement request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_data)::BaseType>
      service_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& service_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    param_service_data,
    service_data_fragment,
    &service_data_validate_params);

  params->service_data.Set(
      service_data_fragment.is_null() ? nullptr : service_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_data in Adapter.RegisterAdvertisement request");

  params->use_scan_response = param_use_scan_response;

  params->connectable = param_connectable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("RegisterAdvertisement");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_RegisterAdvertisement_HandleSyncResponse(
          &result, out_param_advertisement));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Adapter::RegisterAdvertisement", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("advertisement"), out_param_advertisement,
                        "<value of type ::mojo::PendingRemote<Advertisement>>");
   });
#endif
  return result;
}

void AdapterProxy::RegisterAdvertisement(
    const ::device::BluetoothUUID& in_service_id, const std::vector<uint8_t>& in_service_data, bool in_use_scan_response, bool in_connectable, RegisterAdvertisementCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Adapter::RegisterAdvertisement", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const ::device::BluetoothUUID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_data"), in_service_data,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("use_scan_response"), in_use_scan_response,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connectable"), in_connectable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kRegisterAdvertisement), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_RegisterAdvertisement_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in Adapter.RegisterAdvertisement request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_data)::BaseType>
      service_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& service_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_service_data,
    service_data_fragment,
    &service_data_validate_params);

  params->service_data.Set(
      service_data_fragment.is_null() ? nullptr : service_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_data in Adapter.RegisterAdvertisement request");

  params->use_scan_response = in_use_scan_response;

  params->connectable = in_connectable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("RegisterAdvertisement");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_RegisterAdvertisement_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool AdapterProxy::SetDiscoverable(
    bool param_discoverable, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call bluetooth::mojom::Adapter::SetDiscoverable (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("discoverable"), param_discoverable,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "Adapter::SetDiscoverable");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kSetDiscoverable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_SetDiscoverable_Params_Data> params(
          message);
  params.Allocate();

  params->discoverable = param_discoverable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("SetDiscoverable");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_SetDiscoverable_HandleSyncResponse(
          &result, out_param_success));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Adapter::SetDiscoverable", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void AdapterProxy::SetDiscoverable(
    bool in_discoverable, SetDiscoverableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Adapter::SetDiscoverable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("discoverable"), in_discoverable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kSetDiscoverable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_SetDiscoverable_Params_Data> params(
          message);
  params.Allocate();

  params->discoverable = in_discoverable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("SetDiscoverable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_SetDiscoverable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool AdapterProxy::SetName(
    const std::string& param_name, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call bluetooth::mojom::Adapter::SetName (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), param_name,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "Adapter::SetName");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kSetName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_SetName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in Adapter.SetName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("SetName");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_SetName_HandleSyncResponse(
          &result, out_param_success));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Adapter::SetName", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void AdapterProxy::SetName(
    const std::string& in_name, SetNameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Adapter::SetName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kSetName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_SetName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in Adapter.SetName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("SetName");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_SetName_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool AdapterProxy::StartDiscoverySession(
    const std::string& param_client_name, ::mojo::PendingRemote<DiscoverySession>* out_param_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call bluetooth::mojom::Adapter::StartDiscoverySession (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_name"), param_client_name,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "Adapter::StartDiscoverySession");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kStartDiscoverySession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_StartDiscoverySession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_name)::BaseType> client_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_client_name,
    client_name_fragment);

  params->client_name.Set(
      client_name_fragment.is_null() ? nullptr : client_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_name in Adapter.StartDiscoverySession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("StartDiscoverySession");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_StartDiscoverySession_HandleSyncResponse(
          &result, out_param_session));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Adapter::StartDiscoverySession", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), out_param_session,
                        "<value of type ::mojo::PendingRemote<DiscoverySession>>");
   });
#endif
  return result;
}

void AdapterProxy::StartDiscoverySession(
    const std::string& in_client_name, StartDiscoverySessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Adapter::StartDiscoverySession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_name"), in_client_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kStartDiscoverySession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_StartDiscoverySession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_name)::BaseType> client_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_client_name,
    client_name_fragment);

  params->client_name.Set(
      client_name_fragment.is_null() ? nullptr : client_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_name in Adapter.StartDiscoverySession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("StartDiscoverySession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_StartDiscoverySession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool AdapterProxy::ConnectToServiceInsecurely(
    const std::string& param_address, const ::device::BluetoothUUID& param_service_uuid, bool param_should_unbond_on_error, ConnectToServiceResultPtr* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call bluetooth::mojom::Adapter::ConnectToServiceInsecurely (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address"), param_address,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_uuid"), param_service_uuid,
                        "<value of type const ::device::BluetoothUUID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_unbond_on_error"), param_should_unbond_on_error,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "Adapter::ConnectToServiceInsecurely");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kConnectToServiceInsecurely), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_ConnectToServiceInsecurely_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->address)::BaseType> address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_address,
    address_fragment);

  params->address.Set(
      address_fragment.is_null() ? nullptr : address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null address in Adapter.ConnectToServiceInsecurely request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_uuid)::BaseType> service_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    param_service_uuid,
    service_uuid_fragment);

  params->service_uuid.Set(
      service_uuid_fragment.is_null() ? nullptr : service_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_uuid in Adapter.ConnectToServiceInsecurely request");

  params->should_unbond_on_error = param_should_unbond_on_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("ConnectToServiceInsecurely");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_ConnectToServiceInsecurely_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Adapter::ConnectToServiceInsecurely", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type ConnectToServiceResultPtr>");
   });
#endif
  return result;
}

void AdapterProxy::ConnectToServiceInsecurely(
    const std::string& in_address, const ::device::BluetoothUUID& in_service_uuid, bool in_should_unbond_on_error, ConnectToServiceInsecurelyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Adapter::ConnectToServiceInsecurely", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address"), in_address,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_uuid"), in_service_uuid,
                        "<value of type const ::device::BluetoothUUID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_unbond_on_error"), in_should_unbond_on_error,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kConnectToServiceInsecurely), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_ConnectToServiceInsecurely_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->address)::BaseType> address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_address,
    address_fragment);

  params->address.Set(
      address_fragment.is_null() ? nullptr : address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null address in Adapter.ConnectToServiceInsecurely request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_uuid)::BaseType> service_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    in_service_uuid,
    service_uuid_fragment);

  params->service_uuid.Set(
      service_uuid_fragment.is_null() ? nullptr : service_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_uuid in Adapter.ConnectToServiceInsecurely request");

  params->should_unbond_on_error = in_should_unbond_on_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("ConnectToServiceInsecurely");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_ConnectToServiceInsecurely_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool AdapterProxy::CreateRfcommServiceInsecurely(
    const std::string& param_service_name, const ::device::BluetoothUUID& param_service_uuid, ::mojo::PendingRemote<ServerSocket>* out_param_server_socket) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call bluetooth::mojom::Adapter::CreateRfcommServiceInsecurely (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_name"), param_service_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_uuid"), param_service_uuid,
                        "<value of type const ::device::BluetoothUUID&>");
   });
#else
  TRACE_EVENT0("mojom", "Adapter::CreateRfcommServiceInsecurely");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kCreateRfcommServiceInsecurely), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_CreateRfcommServiceInsecurely_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_name)::BaseType> service_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_service_name,
    service_name_fragment);

  params->service_name.Set(
      service_name_fragment.is_null() ? nullptr : service_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_name in Adapter.CreateRfcommServiceInsecurely request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_uuid)::BaseType> service_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    param_service_uuid,
    service_uuid_fragment);

  params->service_uuid.Set(
      service_uuid_fragment.is_null() ? nullptr : service_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_uuid in Adapter.CreateRfcommServiceInsecurely request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("CreateRfcommServiceInsecurely");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_CreateRfcommServiceInsecurely_HandleSyncResponse(
          &result, out_param_server_socket));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Adapter::CreateRfcommServiceInsecurely", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("server_socket"), out_param_server_socket,
                        "<value of type ::mojo::PendingRemote<ServerSocket>>");
   });
#endif
  return result;
}

void AdapterProxy::CreateRfcommServiceInsecurely(
    const std::string& in_service_name, const ::device::BluetoothUUID& in_service_uuid, CreateRfcommServiceInsecurelyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Adapter::CreateRfcommServiceInsecurely", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_name"), in_service_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_uuid"), in_service_uuid,
                        "<value of type const ::device::BluetoothUUID&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kCreateRfcommServiceInsecurely), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_CreateRfcommServiceInsecurely_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_name)::BaseType> service_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_name,
    service_name_fragment);

  params->service_name.Set(
      service_name_fragment.is_null() ? nullptr : service_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_name in Adapter.CreateRfcommServiceInsecurely request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_uuid)::BaseType> service_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    in_service_uuid,
    service_uuid_fragment);

  params->service_uuid.Set(
      service_uuid_fragment.is_null() ? nullptr : service_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_uuid in Adapter.CreateRfcommServiceInsecurely request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("CreateRfcommServiceInsecurely");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_CreateRfcommServiceInsecurely_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool AdapterProxy::CreateLocalGattService(
    const ::device::BluetoothUUID& param_service_id, ::mojo::PendingRemote<GattServiceObserver> param_observer, ::mojo::PendingRemote<GattService>* out_param_gatt_service) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call bluetooth::mojom::Adapter::CreateLocalGattService (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), param_service_id,
                        "<value of type const ::device::BluetoothUUID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), param_observer,
                        "<value of type ::mojo::PendingRemote<GattServiceObserver>>");
   });
#else
  TRACE_EVENT0("mojom", "Adapter::CreateLocalGattService");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kCreateLocalGattService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_CreateLocalGattService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    param_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in Adapter.CreateLocalGattService request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::GattServiceObserverInterfaceBase>>(
    param_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in Adapter.CreateLocalGattService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("CreateLocalGattService");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_CreateLocalGattService_HandleSyncResponse(
          &result, out_param_gatt_service));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Adapter::CreateLocalGattService", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gatt_service"), out_param_gatt_service,
                        "<value of type ::mojo::PendingRemote<GattService>>");
   });
#endif
  return result;
}

void AdapterProxy::CreateLocalGattService(
    const ::device::BluetoothUUID& in_service_id, ::mojo::PendingRemote<GattServiceObserver> in_observer, CreateLocalGattServiceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Adapter::CreateLocalGattService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const ::device::BluetoothUUID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<GattServiceObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kCreateLocalGattService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_CreateLocalGattService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in Adapter.CreateLocalGattService request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::GattServiceObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in Adapter.CreateLocalGattService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("CreateLocalGattService");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_CreateLocalGattService_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool AdapterProxy::IsLeScatternetDualRoleSupported(
    bool* out_param_is_supported) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call bluetooth::mojom::Adapter::IsLeScatternetDualRoleSupported (sync)");
#else
  TRACE_EVENT0("mojom", "Adapter::IsLeScatternetDualRoleSupported");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kIsLeScatternetDualRoleSupported), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_IsLeScatternetDualRoleSupported_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("IsLeScatternetDualRoleSupported");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_IsLeScatternetDualRoleSupported_HandleSyncResponse(
          &result, out_param_is_supported));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Adapter::IsLeScatternetDualRoleSupported", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_supported"), out_param_is_supported,
                        "<value of type bool>");
   });
#endif
  return result;
}

void AdapterProxy::IsLeScatternetDualRoleSupported(
    IsLeScatternetDualRoleSupportedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::Adapter::IsLeScatternetDualRoleSupported");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kIsLeScatternetDualRoleSupported), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_IsLeScatternetDualRoleSupported_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("IsLeScatternetDualRoleSupported");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Adapter_IsLeScatternetDualRoleSupported_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Adapter_ConnectToDevice_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Adapter::ConnectToDeviceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Adapter_ConnectToDevice_ProxyToResponder> proxy(
        new Adapter_ConnectToDevice_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Adapter_ConnectToDevice_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Adapter_ConnectToDevice_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Adapter_ConnectToDevice_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Adapter::ConnectToDeviceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ConnectResult in_result, ::mojo::PendingRemote<::bluetooth::mojom::Device> in_device);
};

bool Adapter_ConnectToDevice_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_ConnectToDevice_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Adapter_ConnectToDevice_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Adapter.0
  bool success = true;
  ConnectResult p_result{};
  ::mojo::PendingRemote<::bluetooth::mojom::Device> p_device{};
  Adapter_ConnectToDevice_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_device =
        input_data_view.TakeDevice<decltype(p_device)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_device));
  }
  return true;
}

void Adapter_ConnectToDevice_ProxyToResponder::Run(
    ConnectResult in_result, ::mojo::PendingRemote<::bluetooth::mojom::Device> in_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Adapter::ConnectToDevice", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ConnectResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type ::mojo::PendingRemote<::bluetooth::mojom::Device>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kConnectToDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_ConnectToDevice_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::ConnectResult>(
    in_result,
    &params->result);

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::DeviceInterfaceBase>>(
    in_device,
    &params->device,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("ConnectToDevice");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Adapter_GetDevices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Adapter::GetDevicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Adapter_GetDevices_ProxyToResponder> proxy(
        new Adapter_GetDevices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Adapter_GetDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Adapter_GetDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Adapter_GetDevices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Adapter::GetDevicesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::bluetooth::mojom::DeviceInfoPtr> in_devices);
};

bool Adapter_GetDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_GetDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Adapter_GetDevices_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Adapter.1
  bool success = true;
  std::vector<::bluetooth::mojom::DeviceInfoPtr> p_devices{};
  Adapter_GetDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDevices(&p_devices))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_devices));
  }
  return true;
}

void Adapter_GetDevices_ProxyToResponder::Run(
    std::vector<::bluetooth::mojom::DeviceInfoPtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Adapter::GetDevices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices,
                        "<value of type std::vector<::bluetooth::mojom::DeviceInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_GetDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::DeviceInfoDataView>>(
    in_devices,
    devices_fragment,
    &devices_validate_params);

  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devices.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devices in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("GetDevices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Adapter_GetInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Adapter::GetInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Adapter_GetInfo_ProxyToResponder> proxy(
        new Adapter_GetInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Adapter_GetInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Adapter_GetInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Adapter_GetInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Adapter::GetInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      AdapterInfoPtr in_info);
};

bool Adapter_GetInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_GetInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Adapter_GetInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Adapter.2
  bool success = true;
  AdapterInfoPtr p_info{};
  Adapter_GetInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void Adapter_GetInfo_ProxyToResponder::Run(
    AdapterInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Adapter::GetInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type AdapterInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kGetInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_GetInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::AdapterInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("GetInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Adapter_GetInfo_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_GetInfo_ResponseParams_Data* params =
      reinterpret_cast<internal::Adapter_GetInfo_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Adapter.2
  bool success = true;
  AdapterInfoPtr p_info{};
  Adapter_GetInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 2, true);
    return false;
  }
  *out_info_ = std::move(p_info);
  *result_ = true;
  return true;
}
class Adapter_AddObserver_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Adapter::AddObserverCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Adapter_AddObserver_ProxyToResponder> proxy(
        new Adapter_AddObserver_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Adapter_AddObserver_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Adapter_AddObserver_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Adapter_AddObserver_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Adapter::AddObserverCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Adapter_AddObserver_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_AddObserver_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Adapter_AddObserver_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Adapter.3
  bool success = true;
  Adapter_AddObserver_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Adapter_AddObserver_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply bluetooth::mojom::Adapter::AddObserver");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kAddObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_AddObserver_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("AddObserver");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Adapter_AddObserver_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_AddObserver_ResponseParams_Data* params =
      reinterpret_cast<internal::Adapter_AddObserver_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Adapter.3
  bool success = true;
  Adapter_AddObserver_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 3, true);
    return false;
  }
  *result_ = true;
  return true;
}
class Adapter_RegisterAdvertisement_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Adapter::RegisterAdvertisementCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Adapter_RegisterAdvertisement_ProxyToResponder> proxy(
        new Adapter_RegisterAdvertisement_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Adapter_RegisterAdvertisement_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Adapter_RegisterAdvertisement_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Adapter_RegisterAdvertisement_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Adapter::RegisterAdvertisementCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<Advertisement> in_advertisement);
};

bool Adapter_RegisterAdvertisement_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_RegisterAdvertisement_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Adapter_RegisterAdvertisement_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Adapter.4
  bool success = true;
  ::mojo::PendingRemote<Advertisement> p_advertisement{};
  Adapter_RegisterAdvertisement_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_advertisement =
        input_data_view.TakeAdvertisement<decltype(p_advertisement)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_advertisement));
  }
  return true;
}

void Adapter_RegisterAdvertisement_ProxyToResponder::Run(
    ::mojo::PendingRemote<Advertisement> in_advertisement) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Adapter::RegisterAdvertisement", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("advertisement"), in_advertisement,
                        "<value of type ::mojo::PendingRemote<Advertisement>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kRegisterAdvertisement), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_RegisterAdvertisement_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::AdvertisementInterfaceBase>>(
    in_advertisement,
    &params->advertisement,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("RegisterAdvertisement");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Adapter_RegisterAdvertisement_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_RegisterAdvertisement_ResponseParams_Data* params =
      reinterpret_cast<internal::Adapter_RegisterAdvertisement_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Adapter.4
  bool success = true;
  ::mojo::PendingRemote<Advertisement> p_advertisement{};
  Adapter_RegisterAdvertisement_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_advertisement =
        input_data_view.TakeAdvertisement<decltype(p_advertisement)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 4, true);
    return false;
  }
  *out_advertisement_ = std::move(p_advertisement);
  *result_ = true;
  return true;
}
class Adapter_SetDiscoverable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Adapter::SetDiscoverableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Adapter_SetDiscoverable_ProxyToResponder> proxy(
        new Adapter_SetDiscoverable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Adapter_SetDiscoverable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Adapter_SetDiscoverable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Adapter_SetDiscoverable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Adapter::SetDiscoverableCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Adapter_SetDiscoverable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_SetDiscoverable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Adapter_SetDiscoverable_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Adapter.5
  bool success = true;
  bool p_success{};
  Adapter_SetDiscoverable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void Adapter_SetDiscoverable_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Adapter::SetDiscoverable", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kSetDiscoverable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_SetDiscoverable_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("SetDiscoverable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Adapter_SetDiscoverable_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_SetDiscoverable_ResponseParams_Data* params =
      reinterpret_cast<internal::Adapter_SetDiscoverable_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Adapter.5
  bool success = true;
  bool p_success{};
  Adapter_SetDiscoverable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 5, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}
class Adapter_SetName_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Adapter::SetNameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Adapter_SetName_ProxyToResponder> proxy(
        new Adapter_SetName_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Adapter_SetName_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Adapter_SetName_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Adapter_SetName_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Adapter::SetNameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Adapter_SetName_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_SetName_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Adapter_SetName_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Adapter.6
  bool success = true;
  bool p_success{};
  Adapter_SetName_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void Adapter_SetName_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Adapter::SetName", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kSetName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_SetName_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("SetName");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Adapter_SetName_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_SetName_ResponseParams_Data* params =
      reinterpret_cast<internal::Adapter_SetName_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Adapter.6
  bool success = true;
  bool p_success{};
  Adapter_SetName_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 6, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}
class Adapter_StartDiscoverySession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Adapter::StartDiscoverySessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Adapter_StartDiscoverySession_ProxyToResponder> proxy(
        new Adapter_StartDiscoverySession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Adapter_StartDiscoverySession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Adapter_StartDiscoverySession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Adapter_StartDiscoverySession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Adapter::StartDiscoverySessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<DiscoverySession> in_session);
};

bool Adapter_StartDiscoverySession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_StartDiscoverySession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Adapter_StartDiscoverySession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Adapter.7
  bool success = true;
  ::mojo::PendingRemote<DiscoverySession> p_session{};
  Adapter_StartDiscoverySession_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_session =
        input_data_view.TakeSession<decltype(p_session)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_session));
  }
  return true;
}

void Adapter_StartDiscoverySession_ProxyToResponder::Run(
    ::mojo::PendingRemote<DiscoverySession> in_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Adapter::StartDiscoverySession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::mojo::PendingRemote<DiscoverySession>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kStartDiscoverySession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_StartDiscoverySession_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::DiscoverySessionInterfaceBase>>(
    in_session,
    &params->session,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("StartDiscoverySession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Adapter_StartDiscoverySession_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_StartDiscoverySession_ResponseParams_Data* params =
      reinterpret_cast<internal::Adapter_StartDiscoverySession_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Adapter.7
  bool success = true;
  ::mojo::PendingRemote<DiscoverySession> p_session{};
  Adapter_StartDiscoverySession_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_session =
        input_data_view.TakeSession<decltype(p_session)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 7, true);
    return false;
  }
  *out_session_ = std::move(p_session);
  *result_ = true;
  return true;
}
class Adapter_ConnectToServiceInsecurely_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Adapter::ConnectToServiceInsecurelyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Adapter_ConnectToServiceInsecurely_ProxyToResponder> proxy(
        new Adapter_ConnectToServiceInsecurely_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Adapter_ConnectToServiceInsecurely_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Adapter_ConnectToServiceInsecurely_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Adapter_ConnectToServiceInsecurely_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Adapter::ConnectToServiceInsecurelyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ConnectToServiceResultPtr in_result);
};

bool Adapter_ConnectToServiceInsecurely_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_ConnectToServiceInsecurely_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Adapter_ConnectToServiceInsecurely_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Adapter.8
  bool success = true;
  ConnectToServiceResultPtr p_result{};
  Adapter_ConnectToServiceInsecurely_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Adapter_ConnectToServiceInsecurely_ProxyToResponder::Run(
    ConnectToServiceResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Adapter::ConnectToServiceInsecurely", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ConnectToServiceResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kConnectToServiceInsecurely), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_ConnectToServiceInsecurely_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::ConnectToServiceResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("ConnectToServiceInsecurely");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Adapter_ConnectToServiceInsecurely_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_ConnectToServiceInsecurely_ResponseParams_Data* params =
      reinterpret_cast<internal::Adapter_ConnectToServiceInsecurely_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Adapter.8
  bool success = true;
  ConnectToServiceResultPtr p_result{};
  Adapter_ConnectToServiceInsecurely_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 8, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class Adapter_CreateRfcommServiceInsecurely_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Adapter::CreateRfcommServiceInsecurelyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Adapter_CreateRfcommServiceInsecurely_ProxyToResponder> proxy(
        new Adapter_CreateRfcommServiceInsecurely_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Adapter_CreateRfcommServiceInsecurely_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Adapter_CreateRfcommServiceInsecurely_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Adapter_CreateRfcommServiceInsecurely_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Adapter::CreateRfcommServiceInsecurelyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<ServerSocket> in_server_socket);
};

bool Adapter_CreateRfcommServiceInsecurely_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Adapter.9
  bool success = true;
  ::mojo::PendingRemote<ServerSocket> p_server_socket{};
  Adapter_CreateRfcommServiceInsecurely_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_server_socket =
        input_data_view.TakeServerSocket<decltype(p_server_socket)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_server_socket));
  }
  return true;
}

void Adapter_CreateRfcommServiceInsecurely_ProxyToResponder::Run(
    ::mojo::PendingRemote<ServerSocket> in_server_socket) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Adapter::CreateRfcommServiceInsecurely", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("server_socket"), in_server_socket,
                        "<value of type ::mojo::PendingRemote<ServerSocket>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kCreateRfcommServiceInsecurely), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::ServerSocketInterfaceBase>>(
    in_server_socket,
    &params->server_socket,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("CreateRfcommServiceInsecurely");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Adapter_CreateRfcommServiceInsecurely_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data* params =
      reinterpret_cast<internal::Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Adapter.9
  bool success = true;
  ::mojo::PendingRemote<ServerSocket> p_server_socket{};
  Adapter_CreateRfcommServiceInsecurely_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_server_socket =
        input_data_view.TakeServerSocket<decltype(p_server_socket)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 9, true);
    return false;
  }
  *out_server_socket_ = std::move(p_server_socket);
  *result_ = true;
  return true;
}
class Adapter_CreateLocalGattService_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Adapter::CreateLocalGattServiceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Adapter_CreateLocalGattService_ProxyToResponder> proxy(
        new Adapter_CreateLocalGattService_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Adapter_CreateLocalGattService_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Adapter_CreateLocalGattService_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Adapter_CreateLocalGattService_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Adapter::CreateLocalGattServiceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<GattService> in_gatt_service);
};

bool Adapter_CreateLocalGattService_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_CreateLocalGattService_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Adapter_CreateLocalGattService_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Adapter.10
  bool success = true;
  ::mojo::PendingRemote<GattService> p_gatt_service{};
  Adapter_CreateLocalGattService_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_gatt_service =
        input_data_view.TakeGattService<decltype(p_gatt_service)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_gatt_service));
  }
  return true;
}

void Adapter_CreateLocalGattService_ProxyToResponder::Run(
    ::mojo::PendingRemote<GattService> in_gatt_service) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Adapter::CreateLocalGattService", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gatt_service"), in_gatt_service,
                        "<value of type ::mojo::PendingRemote<GattService>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kCreateLocalGattService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_CreateLocalGattService_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::GattServiceInterfaceBase>>(
    in_gatt_service,
    &params->gatt_service,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->gatt_service)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid gatt_service in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("CreateLocalGattService");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Adapter_CreateLocalGattService_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_CreateLocalGattService_ResponseParams_Data* params =
      reinterpret_cast<internal::Adapter_CreateLocalGattService_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Adapter.10
  bool success = true;
  ::mojo::PendingRemote<GattService> p_gatt_service{};
  Adapter_CreateLocalGattService_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_gatt_service =
        input_data_view.TakeGattService<decltype(p_gatt_service)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 10, true);
    return false;
  }
  *out_gatt_service_ = std::move(p_gatt_service);
  *result_ = true;
  return true;
}
class Adapter_IsLeScatternetDualRoleSupported_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Adapter::IsLeScatternetDualRoleSupportedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Adapter_IsLeScatternetDualRoleSupported_ProxyToResponder> proxy(
        new Adapter_IsLeScatternetDualRoleSupported_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Adapter_IsLeScatternetDualRoleSupported_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Adapter_IsLeScatternetDualRoleSupported_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Adapter_IsLeScatternetDualRoleSupported_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Adapter::IsLeScatternetDualRoleSupportedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_supported);
};

bool Adapter_IsLeScatternetDualRoleSupported_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Adapter.11
  bool success = true;
  bool p_is_supported{};
  Adapter_IsLeScatternetDualRoleSupported_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_supported = input_data_view.is_supported();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_supported));
  }
  return true;
}

void Adapter_IsLeScatternetDualRoleSupported_ProxyToResponder::Run(
    bool in_is_supported) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Adapter::IsLeScatternetDualRoleSupported", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_supported"), in_is_supported,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Adapter::kIsLeScatternetDualRoleSupported), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_supported = in_is_supported;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Adapter::Name_);
  message.set_method_name("IsLeScatternetDualRoleSupported");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Adapter_IsLeScatternetDualRoleSupported_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data* params =
      reinterpret_cast<internal::Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Adapter.11
  bool success = true;
  bool p_is_supported{};
  Adapter_IsLeScatternetDualRoleSupported_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_supported = input_data_view.is_supported();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Adapter::Name_, 11, true);
    return false;
  }
  *out_is_supported_ = std::move(p_is_supported);
  *result_ = true;
  return true;
}

// static
bool AdapterStubDispatch::Accept(
    Adapter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Adapter>(message->header()->name)) {
    case messages::Adapter::kConnectToDevice: {
      break;
    }
    case messages::Adapter::kGetDevices: {
      break;
    }
    case messages::Adapter::kGetInfo: {
      break;
    }
    case messages::Adapter::kAddObserver: {
      break;
    }
    case messages::Adapter::kRegisterAdvertisement: {
      break;
    }
    case messages::Adapter::kSetDiscoverable: {
      break;
    }
    case messages::Adapter::kSetName: {
      break;
    }
    case messages::Adapter::kStartDiscoverySession: {
      break;
    }
    case messages::Adapter::kConnectToServiceInsecurely: {
      break;
    }
    case messages::Adapter::kCreateRfcommServiceInsecurely: {
      break;
    }
    case messages::Adapter::kCreateLocalGattService: {
      break;
    }
    case messages::Adapter::kIsLeScatternetDualRoleSupported: {
      break;
    }
  }
  return false;
}

// static
bool AdapterStubDispatch::AcceptWithResponder(
    Adapter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Adapter>(message->header()->name)) {
    case messages::Adapter::kConnectToDevice: {
      internal::Adapter_ConnectToDevice_Params_Data* params =
          reinterpret_cast<
              internal::Adapter_ConnectToDevice_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Adapter.0
      bool success = true;
      std::string p_address{};
      Adapter_ConnectToDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddress(&p_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Adapter::Name_, 0, false);
        return false;
      }
      auto callback =
          Adapter_ConnectToDevice_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToDevice(        
        std::move(p_address), std::move(callback));
      return true;
    }
    case messages::Adapter::kGetDevices: {
      internal::Adapter_GetDevices_Params_Data* params =
          reinterpret_cast<
              internal::Adapter_GetDevices_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Adapter.1
      bool success = true;
      Adapter_GetDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Adapter::Name_, 1, false);
        return false;
      }
      auto callback =
          Adapter_GetDevices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevices(std::move(callback));
      return true;
    }
    case messages::Adapter::kGetInfo: {
      internal::Adapter_GetInfo_Params_Data* params =
          reinterpret_cast<
              internal::Adapter_GetInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Adapter.2
      bool success = true;
      Adapter_GetInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Adapter::Name_, 2, false);
        return false;
      }
      auto callback =
          Adapter_GetInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInfo(std::move(callback));
      return true;
    }
    case messages::Adapter::kAddObserver: {
      internal::Adapter_AddObserver_Params_Data* params =
          reinterpret_cast<
              internal::Adapter_AddObserver_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Adapter.3
      bool success = true;
      ::mojo::PendingRemote<AdapterObserver> p_observer{};
      Adapter_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Adapter::Name_, 3, false);
        return false;
      }
      auto callback =
          Adapter_AddObserver_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(        
        std::move(p_observer), std::move(callback));
      return true;
    }
    case messages::Adapter::kRegisterAdvertisement: {
      internal::Adapter_RegisterAdvertisement_Params_Data* params =
          reinterpret_cast<
              internal::Adapter_RegisterAdvertisement_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Adapter.4
      bool success = true;
      ::device::BluetoothUUID p_service_id{};
      std::vector<uint8_t> p_service_data{};
      bool p_use_scan_response{};
      bool p_connectable{};
      Adapter_RegisterAdvertisement_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadServiceData(&p_service_data))
        success = false;
      if (success)
        p_use_scan_response = input_data_view.use_scan_response();
      if (success)
        p_connectable = input_data_view.connectable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Adapter::Name_, 4, false);
        return false;
      }
      auto callback =
          Adapter_RegisterAdvertisement_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterAdvertisement(        
        std::move(p_service_id), 
        std::move(p_service_data), 
        std::move(p_use_scan_response), 
        std::move(p_connectable), std::move(callback));
      return true;
    }
    case messages::Adapter::kSetDiscoverable: {
      internal::Adapter_SetDiscoverable_Params_Data* params =
          reinterpret_cast<
              internal::Adapter_SetDiscoverable_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Adapter.5
      bool success = true;
      bool p_discoverable{};
      Adapter_SetDiscoverable_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_discoverable = input_data_view.discoverable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Adapter::Name_, 5, false);
        return false;
      }
      auto callback =
          Adapter_SetDiscoverable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDiscoverable(        
        std::move(p_discoverable), std::move(callback));
      return true;
    }
    case messages::Adapter::kSetName: {
      internal::Adapter_SetName_Params_Data* params =
          reinterpret_cast<
              internal::Adapter_SetName_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Adapter.6
      bool success = true;
      std::string p_name{};
      Adapter_SetName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Adapter::Name_, 6, false);
        return false;
      }
      auto callback =
          Adapter_SetName_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetName(        
        std::move(p_name), std::move(callback));
      return true;
    }
    case messages::Adapter::kStartDiscoverySession: {
      internal::Adapter_StartDiscoverySession_Params_Data* params =
          reinterpret_cast<
              internal::Adapter_StartDiscoverySession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Adapter.7
      bool success = true;
      std::string p_client_name{};
      Adapter_StartDiscoverySession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientName(&p_client_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Adapter::Name_, 7, false);
        return false;
      }
      auto callback =
          Adapter_StartDiscoverySession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDiscoverySession(        
        std::move(p_client_name), std::move(callback));
      return true;
    }
    case messages::Adapter::kConnectToServiceInsecurely: {
      internal::Adapter_ConnectToServiceInsecurely_Params_Data* params =
          reinterpret_cast<
              internal::Adapter_ConnectToServiceInsecurely_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Adapter.8
      bool success = true;
      std::string p_address{};
      ::device::BluetoothUUID p_service_uuid{};
      bool p_should_unbond_on_error{};
      Adapter_ConnectToServiceInsecurely_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddress(&p_address))
        success = false;
      if (success && !input_data_view.ReadServiceUuid(&p_service_uuid))
        success = false;
      if (success)
        p_should_unbond_on_error = input_data_view.should_unbond_on_error();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Adapter::Name_, 8, false);
        return false;
      }
      auto callback =
          Adapter_ConnectToServiceInsecurely_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToServiceInsecurely(        
        std::move(p_address), 
        std::move(p_service_uuid), 
        std::move(p_should_unbond_on_error), std::move(callback));
      return true;
    }
    case messages::Adapter::kCreateRfcommServiceInsecurely: {
      internal::Adapter_CreateRfcommServiceInsecurely_Params_Data* params =
          reinterpret_cast<
              internal::Adapter_CreateRfcommServiceInsecurely_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Adapter.9
      bool success = true;
      std::string p_service_name{};
      ::device::BluetoothUUID p_service_uuid{};
      Adapter_CreateRfcommServiceInsecurely_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceName(&p_service_name))
        success = false;
      if (success && !input_data_view.ReadServiceUuid(&p_service_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Adapter::Name_, 9, false);
        return false;
      }
      auto callback =
          Adapter_CreateRfcommServiceInsecurely_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateRfcommServiceInsecurely(        
        std::move(p_service_name), 
        std::move(p_service_uuid), std::move(callback));
      return true;
    }
    case messages::Adapter::kCreateLocalGattService: {
      internal::Adapter_CreateLocalGattService_Params_Data* params =
          reinterpret_cast<
              internal::Adapter_CreateLocalGattService_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Adapter.10
      bool success = true;
      ::device::BluetoothUUID p_service_id{};
      ::mojo::PendingRemote<GattServiceObserver> p_observer{};
      Adapter_CreateLocalGattService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Adapter::Name_, 10, false);
        return false;
      }
      auto callback =
          Adapter_CreateLocalGattService_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateLocalGattService(        
        std::move(p_service_id), 
        std::move(p_observer), std::move(callback));
      return true;
    }
    case messages::Adapter::kIsLeScatternetDualRoleSupported: {
      internal::Adapter_IsLeScatternetDualRoleSupported_Params_Data* params =
          reinterpret_cast<
              internal::Adapter_IsLeScatternetDualRoleSupported_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Adapter.11
      bool success = true;
      Adapter_IsLeScatternetDualRoleSupported_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Adapter::Name_, 11, false);
        return false;
      }
      auto callback =
          Adapter_IsLeScatternetDualRoleSupported_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsLeScatternetDualRoleSupported(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAdapterValidationInfo[] = {
    { &internal::Adapter_ConnectToDevice_Params_Data::Validate,
     &internal::Adapter_ConnectToDevice_ResponseParams_Data::Validate},
    { &internal::Adapter_GetDevices_Params_Data::Validate,
     &internal::Adapter_GetDevices_ResponseParams_Data::Validate},
    { &internal::Adapter_GetInfo_Params_Data::Validate,
     &internal::Adapter_GetInfo_ResponseParams_Data::Validate},
    { &internal::Adapter_AddObserver_Params_Data::Validate,
     &internal::Adapter_AddObserver_ResponseParams_Data::Validate},
    { &internal::Adapter_RegisterAdvertisement_Params_Data::Validate,
     &internal::Adapter_RegisterAdvertisement_ResponseParams_Data::Validate},
    { &internal::Adapter_SetDiscoverable_Params_Data::Validate,
     &internal::Adapter_SetDiscoverable_ResponseParams_Data::Validate},
    { &internal::Adapter_SetName_Params_Data::Validate,
     &internal::Adapter_SetName_ResponseParams_Data::Validate},
    { &internal::Adapter_StartDiscoverySession_Params_Data::Validate,
     &internal::Adapter_StartDiscoverySession_ResponseParams_Data::Validate},
    { &internal::Adapter_ConnectToServiceInsecurely_Params_Data::Validate,
     &internal::Adapter_ConnectToServiceInsecurely_ResponseParams_Data::Validate},
    { &internal::Adapter_CreateRfcommServiceInsecurely_Params_Data::Validate,
     &internal::Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data::Validate},
    { &internal::Adapter_CreateLocalGattService_Params_Data::Validate,
     &internal::Adapter_CreateLocalGattService_ResponseParams_Data::Validate},
    { &internal::Adapter_IsLeScatternetDualRoleSupported_Params_Data::Validate,
     &internal::Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data::Validate},
};

bool AdapterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::bluetooth::mojom::Adapter::Name_,
    kAdapterValidationInfo);
}

bool AdapterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::bluetooth::mojom::Adapter::Name_,
    kAdapterValidationInfo);
}
// The declaration includes the definition on other builds.

AdapterObserver::IPCStableHashFunction AdapterObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AdapterObserver>(message.name())) {
    case messages::AdapterObserver::kPresentChanged: {
      return &AdapterObserver::PresentChanged_Sym::IPCStableHash;
    }
    case messages::AdapterObserver::kPoweredChanged: {
      return &AdapterObserver::PoweredChanged_Sym::IPCStableHash;
    }
    case messages::AdapterObserver::kDiscoverableChanged: {
      return &AdapterObserver::DiscoverableChanged_Sym::IPCStableHash;
    }
    case messages::AdapterObserver::kDiscoveringChanged: {
      return &AdapterObserver::DiscoveringChanged_Sym::IPCStableHash;
    }
    case messages::AdapterObserver::kDeviceAdded: {
      return &AdapterObserver::DeviceAdded_Sym::IPCStableHash;
    }
    case messages::AdapterObserver::kDeviceChanged: {
      return &AdapterObserver::DeviceChanged_Sym::IPCStableHash;
    }
    case messages::AdapterObserver::kDeviceRemoved: {
      return &AdapterObserver::DeviceRemoved_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AdapterObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AdapterObserver>(message.name())) {
      case messages::AdapterObserver::kPresentChanged:
            return "Receive bluetooth::mojom::AdapterObserver::PresentChanged";
      case messages::AdapterObserver::kPoweredChanged:
            return "Receive bluetooth::mojom::AdapterObserver::PoweredChanged";
      case messages::AdapterObserver::kDiscoverableChanged:
            return "Receive bluetooth::mojom::AdapterObserver::DiscoverableChanged";
      case messages::AdapterObserver::kDiscoveringChanged:
            return "Receive bluetooth::mojom::AdapterObserver::DiscoveringChanged";
      case messages::AdapterObserver::kDeviceAdded:
            return "Receive bluetooth::mojom::AdapterObserver::DeviceAdded";
      case messages::AdapterObserver::kDeviceChanged:
            return "Receive bluetooth::mojom::AdapterObserver::DeviceChanged";
      case messages::AdapterObserver::kDeviceRemoved:
            return "Receive bluetooth::mojom::AdapterObserver::DeviceRemoved";
    }
  } else {
    switch (static_cast<messages::AdapterObserver>(message.name())) {
      case messages::AdapterObserver::kPresentChanged:
            return "Receive reply bluetooth::mojom::AdapterObserver::PresentChanged";
      case messages::AdapterObserver::kPoweredChanged:
            return "Receive reply bluetooth::mojom::AdapterObserver::PoweredChanged";
      case messages::AdapterObserver::kDiscoverableChanged:
            return "Receive reply bluetooth::mojom::AdapterObserver::DiscoverableChanged";
      case messages::AdapterObserver::kDiscoveringChanged:
            return "Receive reply bluetooth::mojom::AdapterObserver::DiscoveringChanged";
      case messages::AdapterObserver::kDeviceAdded:
            return "Receive reply bluetooth::mojom::AdapterObserver::DeviceAdded";
      case messages::AdapterObserver::kDeviceChanged:
            return "Receive reply bluetooth::mojom::AdapterObserver::DeviceChanged";
      case messages::AdapterObserver::kDeviceRemoved:
            return "Receive reply bluetooth::mojom::AdapterObserver::DeviceRemoved";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AdapterObserver::PresentChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb5d850fd;  // IPCStableHash for bluetooth::mojom::AdapterObserver::PresentChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdapterObserver::PoweredChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x97552744;  // IPCStableHash for bluetooth::mojom::AdapterObserver::PoweredChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdapterObserver::DiscoverableChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb80fdf85;  // IPCStableHash for bluetooth::mojom::AdapterObserver::DiscoverableChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdapterObserver::DiscoveringChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2b942d16;  // IPCStableHash for bluetooth::mojom::AdapterObserver::DiscoveringChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdapterObserver::DeviceAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb0256eea;  // IPCStableHash for bluetooth::mojom::AdapterObserver::DeviceAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdapterObserver::DeviceChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xef02b3a8;  // IPCStableHash for bluetooth::mojom::AdapterObserver::DeviceChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdapterObserver::DeviceRemoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x355ecbfe;  // IPCStableHash for bluetooth::mojom::AdapterObserver::DeviceRemoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AdapterObserverProxy::AdapterObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AdapterObserverProxy::PresentChanged(
    bool in_present) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::AdapterObserver::PresentChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("present"), in_present,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdapterObserver::kPresentChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::AdapterObserver_PresentChanged_Params_Data> params(
          message);
  params.Allocate();

  params->present = in_present;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdapterObserver::Name_);
  message.set_method_name("PresentChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AdapterObserverProxy::PoweredChanged(
    bool in_powered) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::AdapterObserver::PoweredChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("powered"), in_powered,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdapterObserver::kPoweredChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::AdapterObserver_PoweredChanged_Params_Data> params(
          message);
  params.Allocate();

  params->powered = in_powered;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdapterObserver::Name_);
  message.set_method_name("PoweredChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AdapterObserverProxy::DiscoverableChanged(
    bool in_discoverable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::AdapterObserver::DiscoverableChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("discoverable"), in_discoverable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdapterObserver::kDiscoverableChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::AdapterObserver_DiscoverableChanged_Params_Data> params(
          message);
  params.Allocate();

  params->discoverable = in_discoverable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdapterObserver::Name_);
  message.set_method_name("DiscoverableChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AdapterObserverProxy::DiscoveringChanged(
    bool in_discovering) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::AdapterObserver::DiscoveringChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("discovering"), in_discovering,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdapterObserver::kDiscoveringChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::AdapterObserver_DiscoveringChanged_Params_Data> params(
          message);
  params.Allocate();

  params->discovering = in_discovering;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdapterObserver::Name_);
  message.set_method_name("DiscoveringChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AdapterObserverProxy::DeviceAdded(
    ::bluetooth::mojom::DeviceInfoPtr in_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::AdapterObserver::DeviceAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type ::bluetooth::mojom::DeviceInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdapterObserver::kDeviceAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::AdapterObserver_DeviceAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::DeviceInfoDataView>(
    in_device,
    device_fragment);

  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device in AdapterObserver.DeviceAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdapterObserver::Name_);
  message.set_method_name("DeviceAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AdapterObserverProxy::DeviceChanged(
    ::bluetooth::mojom::DeviceInfoPtr in_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::AdapterObserver::DeviceChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type ::bluetooth::mojom::DeviceInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdapterObserver::kDeviceChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::AdapterObserver_DeviceChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::DeviceInfoDataView>(
    in_device,
    device_fragment);

  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device in AdapterObserver.DeviceChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdapterObserver::Name_);
  message.set_method_name("DeviceChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AdapterObserverProxy::DeviceRemoved(
    ::bluetooth::mojom::DeviceInfoPtr in_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::AdapterObserver::DeviceRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type ::bluetooth::mojom::DeviceInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdapterObserver::kDeviceRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::AdapterObserver_DeviceRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::DeviceInfoDataView>(
    in_device,
    device_fragment);

  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device in AdapterObserver.DeviceRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdapterObserver::Name_);
  message.set_method_name("DeviceRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AdapterObserverStubDispatch::Accept(
    AdapterObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AdapterObserver>(message->header()->name)) {
    case messages::AdapterObserver::kPresentChanged: {
      DCHECK(message->is_serialized());
      internal::AdapterObserver_PresentChanged_Params_Data* params =
          reinterpret_cast<internal::AdapterObserver_PresentChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AdapterObserver.0
      bool success = true;
      bool p_present{};
      AdapterObserver_PresentChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_present = input_data_view.present();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdapterObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PresentChanged(        
        std::move(p_present));
      return true;
    }
    case messages::AdapterObserver::kPoweredChanged: {
      DCHECK(message->is_serialized());
      internal::AdapterObserver_PoweredChanged_Params_Data* params =
          reinterpret_cast<internal::AdapterObserver_PoweredChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AdapterObserver.1
      bool success = true;
      bool p_powered{};
      AdapterObserver_PoweredChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_powered = input_data_view.powered();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdapterObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PoweredChanged(        
        std::move(p_powered));
      return true;
    }
    case messages::AdapterObserver::kDiscoverableChanged: {
      DCHECK(message->is_serialized());
      internal::AdapterObserver_DiscoverableChanged_Params_Data* params =
          reinterpret_cast<internal::AdapterObserver_DiscoverableChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AdapterObserver.2
      bool success = true;
      bool p_discoverable{};
      AdapterObserver_DiscoverableChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_discoverable = input_data_view.discoverable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdapterObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DiscoverableChanged(        
        std::move(p_discoverable));
      return true;
    }
    case messages::AdapterObserver::kDiscoveringChanged: {
      DCHECK(message->is_serialized());
      internal::AdapterObserver_DiscoveringChanged_Params_Data* params =
          reinterpret_cast<internal::AdapterObserver_DiscoveringChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AdapterObserver.3
      bool success = true;
      bool p_discovering{};
      AdapterObserver_DiscoveringChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_discovering = input_data_view.discovering();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdapterObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DiscoveringChanged(        
        std::move(p_discovering));
      return true;
    }
    case messages::AdapterObserver::kDeviceAdded: {
      DCHECK(message->is_serialized());
      internal::AdapterObserver_DeviceAdded_Params_Data* params =
          reinterpret_cast<internal::AdapterObserver_DeviceAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AdapterObserver.4
      bool success = true;
      ::bluetooth::mojom::DeviceInfoPtr p_device{};
      AdapterObserver_DeviceAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevice(&p_device))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdapterObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeviceAdded(        
        std::move(p_device));
      return true;
    }
    case messages::AdapterObserver::kDeviceChanged: {
      DCHECK(message->is_serialized());
      internal::AdapterObserver_DeviceChanged_Params_Data* params =
          reinterpret_cast<internal::AdapterObserver_DeviceChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AdapterObserver.5
      bool success = true;
      ::bluetooth::mojom::DeviceInfoPtr p_device{};
      AdapterObserver_DeviceChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevice(&p_device))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdapterObserver::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeviceChanged(        
        std::move(p_device));
      return true;
    }
    case messages::AdapterObserver::kDeviceRemoved: {
      DCHECK(message->is_serialized());
      internal::AdapterObserver_DeviceRemoved_Params_Data* params =
          reinterpret_cast<internal::AdapterObserver_DeviceRemoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AdapterObserver.6
      bool success = true;
      ::bluetooth::mojom::DeviceInfoPtr p_device{};
      AdapterObserver_DeviceRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevice(&p_device))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdapterObserver::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeviceRemoved(        
        std::move(p_device));
      return true;
    }
  }
  return false;
}

// static
bool AdapterObserverStubDispatch::AcceptWithResponder(
    AdapterObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AdapterObserver>(message->header()->name)) {
    case messages::AdapterObserver::kPresentChanged: {
      break;
    }
    case messages::AdapterObserver::kPoweredChanged: {
      break;
    }
    case messages::AdapterObserver::kDiscoverableChanged: {
      break;
    }
    case messages::AdapterObserver::kDiscoveringChanged: {
      break;
    }
    case messages::AdapterObserver::kDeviceAdded: {
      break;
    }
    case messages::AdapterObserver::kDeviceChanged: {
      break;
    }
    case messages::AdapterObserver::kDeviceRemoved: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAdapterObserverValidationInfo[] = {
    { &internal::AdapterObserver_PresentChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AdapterObserver_PoweredChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AdapterObserver_DiscoverableChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AdapterObserver_DiscoveringChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AdapterObserver_DeviceAdded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AdapterObserver_DeviceChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AdapterObserver_DeviceRemoved_Params_Data::Validate,
     nullptr /* no response */},
};

bool AdapterObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::bluetooth::mojom::AdapterObserver::Name_,
    kAdapterObserverValidationInfo);
}



}  // bluetooth::mojom


namespace mojo {


// static
bool StructTraits<::bluetooth::mojom::ConnectToServiceResult::DataView, ::bluetooth::mojom::ConnectToServiceResultPtr>::Read(
    ::bluetooth::mojom::ConnectToServiceResult::DataView input,
    ::bluetooth::mojom::ConnectToServiceResultPtr* output) {
  bool success = true;
  ::bluetooth::mojom::ConnectToServiceResultPtr result(::bluetooth::mojom::ConnectToServiceResult::New());
  
      if (success) {
        result->socket =
            input.TakeSocket<decltype(result->socket)>();
      }
      if (success)
        result->receive_stream = input.TakeReceiveStream();
      if (success)
        result->send_stream = input.TakeSendStream();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::bluetooth::mojom::AcceptConnectionResult::DataView, ::bluetooth::mojom::AcceptConnectionResultPtr>::Read(
    ::bluetooth::mojom::AcceptConnectionResult::DataView input,
    ::bluetooth::mojom::AcceptConnectionResultPtr* output) {
  bool success = true;
  ::bluetooth::mojom::AcceptConnectionResultPtr result(::bluetooth::mojom::AcceptConnectionResult::New());
  
      if (success && !input.ReadDevice(&result->device))
        success = false;
      if (success) {
        result->socket =
            input.TakeSocket<decltype(result->socket)>();
      }
      if (success)
        result->receive_stream = input.TakeReceiveStream();
      if (success)
        result->send_stream = input.TakeSendStream();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::bluetooth::mojom::AdapterInfo::DataView, ::bluetooth::mojom::AdapterInfoPtr>::Read(
    ::bluetooth::mojom::AdapterInfo::DataView input,
    ::bluetooth::mojom::AdapterInfoPtr* output) {
  bool success = true;
  ::bluetooth::mojom::AdapterInfoPtr result(::bluetooth::mojom::AdapterInfo::New());
  
      if (success && !input.ReadAddress(&result->address))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadSystemName(&result->system_name))
        success = false;
      if (success)
        result->floss = input.floss();
      if (success)
        result->extended_advertisement_support = input.extended_advertisement_support();
      if (success)
        result->initialized = input.initialized();
      if (success)
        result->present = input.present();
      if (success)
        result->powered = input.powered();
      if (success)
        result->discoverable = input.discoverable();
      if (success)
        result->discovering = input.discovering();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::bluetooth::mojom::LocalCharacteristicReadResult::DataView, ::bluetooth::mojom::LocalCharacteristicReadResultPtr>::Read(
    ::bluetooth::mojom::LocalCharacteristicReadResult::DataView input,
    ::bluetooth::mojom::LocalCharacteristicReadResultPtr* output) {
  using UnionType = ::bluetooth::mojom::LocalCharacteristicReadResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kErrorCode: {
      ::device::BluetoothGattService::GattErrorCode result_error_code;
      if (!input.ReadErrorCode(&result_error_code))
        return false;

      *output = UnionType::NewErrorCode(result_error_code);
      break;
    }
    case Tag::kData: {
      std::vector<uint8_t> result_data{};
      if (!input.ReadData(&result_data))
        return false;

      *output = UnionType::NewData(
          std::move(result_data));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace bluetooth::mojom {


void AdvertisementInterceptorForTesting::Unregister(UnregisterCallback callback) {
  GetForwardingInterface()->Unregister(std::move(callback));
}
AdvertisementAsyncWaiter::AdvertisementAsyncWaiter(
    Advertisement* proxy) : proxy_(proxy) {}

AdvertisementAsyncWaiter::~AdvertisementAsyncWaiter() = default;


void AdvertisementAsyncWaiter::Unregister(
    ) {
  base::RunLoop loop;
  proxy_->Unregister(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void DiscoverySessionInterceptorForTesting::IsActive(IsActiveCallback callback) {
  GetForwardingInterface()->IsActive(std::move(callback));
}
void DiscoverySessionInterceptorForTesting::Stop(StopCallback callback) {
  GetForwardingInterface()->Stop(std::move(callback));
}
DiscoverySessionAsyncWaiter::DiscoverySessionAsyncWaiter(
    DiscoverySession* proxy) : proxy_(proxy) {}

DiscoverySessionAsyncWaiter::~DiscoverySessionAsyncWaiter() = default;


void DiscoverySessionAsyncWaiter::IsActive(
    bool* out_active) {
  base::RunLoop loop;
  proxy_->IsActive(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_active
,
             bool active) {*out_active = std::move(active);
            loop->Quit();
          },
          &loop,
          out_active));
  loop.Run();
}

bool DiscoverySessionAsyncWaiter::IsActive(
    ) {
  bool async_wait_result;
  IsActive(&async_wait_result);
  return async_wait_result;
}

void DiscoverySessionAsyncWaiter::Stop(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->Stop(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool DiscoverySessionAsyncWaiter::Stop(
    ) {
  bool async_wait_result;
  Stop(&async_wait_result);
  return async_wait_result;
}




void SocketInterceptorForTesting::Disconnect(DisconnectCallback callback) {
  GetForwardingInterface()->Disconnect(std::move(callback));
}
SocketAsyncWaiter::SocketAsyncWaiter(
    Socket* proxy) : proxy_(proxy) {}

SocketAsyncWaiter::~SocketAsyncWaiter() = default;


void SocketAsyncWaiter::Disconnect(
    ) {
  base::RunLoop loop;
  proxy_->Disconnect(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void ServerSocketInterceptorForTesting::Accept(AcceptCallback callback) {
  GetForwardingInterface()->Accept(std::move(callback));
}
void ServerSocketInterceptorForTesting::Disconnect(DisconnectCallback callback) {
  GetForwardingInterface()->Disconnect(std::move(callback));
}
ServerSocketAsyncWaiter::ServerSocketAsyncWaiter(
    ServerSocket* proxy) : proxy_(proxy) {}

ServerSocketAsyncWaiter::~ServerSocketAsyncWaiter() = default;


void ServerSocketAsyncWaiter::Accept(
    AcceptConnectionResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Accept(
      base::BindOnce(
          [](base::RunLoop* loop,
             AcceptConnectionResultPtr* out_result
,
             AcceptConnectionResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

AcceptConnectionResultPtr ServerSocketAsyncWaiter::Accept(
    ) {
  AcceptConnectionResultPtr async_wait_result;
  Accept(&async_wait_result);
  return async_wait_result;
}

void ServerSocketAsyncWaiter::Disconnect(
    ) {
  base::RunLoop loop;
  proxy_->Disconnect(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void GattServiceInterceptorForTesting::CreateCharacteristic(const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothGattCharacteristic::Permissions& permissions, const ::device::BluetoothGattCharacteristic::Properties& properties, CreateCharacteristicCallback callback) {
  GetForwardingInterface()->CreateCharacteristic(
    std::move(characteristic_uuid)
    , 
    std::move(permissions)
    , 
    std::move(properties)
    , std::move(callback));
}
void GattServiceInterceptorForTesting::Register(RegisterCallback callback) {
  GetForwardingInterface()->Register(std::move(callback));
}
GattServiceAsyncWaiter::GattServiceAsyncWaiter(
    GattService* proxy) : proxy_(proxy) {}

GattServiceAsyncWaiter::~GattServiceAsyncWaiter() = default;


void GattServiceAsyncWaiter::CreateCharacteristic(
    const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothGattCharacteristic::Permissions& permissions, const ::device::BluetoothGattCharacteristic::Properties& properties, bool* out_success) {
  base::RunLoop loop;
  proxy_->CreateCharacteristic(
      std::move(characteristic_uuid),
      std::move(permissions),
      std::move(properties),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool GattServiceAsyncWaiter::CreateCharacteristic(
    const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothGattCharacteristic::Permissions& permissions, const ::device::BluetoothGattCharacteristic::Properties& properties) {
  bool async_wait_result;
  CreateCharacteristic(std::move(characteristic_uuid),std::move(permissions),std::move(properties),&async_wait_result);
  return async_wait_result;
}

void GattServiceAsyncWaiter::Register(
    std::optional<::device::BluetoothGattService::GattErrorCode>* out_error_code) {
  base::RunLoop loop;
  proxy_->Register(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::device::BluetoothGattService::GattErrorCode>* out_error_code
,
             std::optional<::device::BluetoothGattService::GattErrorCode> error_code) {*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_error_code));
  loop.Run();
}

std::optional<::device::BluetoothGattService::GattErrorCode> GattServiceAsyncWaiter::Register(
    ) {
  std::optional<::device::BluetoothGattService::GattErrorCode> async_wait_result;
  Register(&async_wait_result);
  return async_wait_result;
}




void GattServiceObserverInterceptorForTesting::OnLocalCharacteristicRead(::bluetooth::mojom::DeviceInfoPtr remote_device, const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothUUID& service_uuid, uint32_t offset, OnLocalCharacteristicReadCallback callback) {
  GetForwardingInterface()->OnLocalCharacteristicRead(
    std::move(remote_device)
    , 
    std::move(characteristic_uuid)
    , 
    std::move(service_uuid)
    , 
    std::move(offset)
    , std::move(callback));
}
GattServiceObserverAsyncWaiter::GattServiceObserverAsyncWaiter(
    GattServiceObserver* proxy) : proxy_(proxy) {}

GattServiceObserverAsyncWaiter::~GattServiceObserverAsyncWaiter() = default;


void GattServiceObserverAsyncWaiter::OnLocalCharacteristicRead(
    ::bluetooth::mojom::DeviceInfoPtr remote_device, const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothUUID& service_uuid, uint32_t offset, LocalCharacteristicReadResultPtr* out_read_result) {
  base::RunLoop loop;
  proxy_->OnLocalCharacteristicRead(
      std::move(remote_device),
      std::move(characteristic_uuid),
      std::move(service_uuid),
      std::move(offset),
      base::BindOnce(
          [](base::RunLoop* loop,
             LocalCharacteristicReadResultPtr* out_read_result
,
             LocalCharacteristicReadResultPtr read_result) {*out_read_result = std::move(read_result);
            loop->Quit();
          },
          &loop,
          out_read_result));
  loop.Run();
}

LocalCharacteristicReadResultPtr GattServiceObserverAsyncWaiter::OnLocalCharacteristicRead(
    ::bluetooth::mojom::DeviceInfoPtr remote_device, const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothUUID& service_uuid, uint32_t offset) {
  LocalCharacteristicReadResultPtr async_wait_result;
  OnLocalCharacteristicRead(std::move(remote_device),std::move(characteristic_uuid),std::move(service_uuid),std::move(offset),&async_wait_result);
  return async_wait_result;
}




void AdapterInterceptorForTesting::ConnectToDevice(const std::string& address, ConnectToDeviceCallback callback) {
  GetForwardingInterface()->ConnectToDevice(
    std::move(address)
    , std::move(callback));
}
void AdapterInterceptorForTesting::GetDevices(GetDevicesCallback callback) {
  GetForwardingInterface()->GetDevices(std::move(callback));
}
void AdapterInterceptorForTesting::GetInfo(GetInfoCallback callback) {
  GetForwardingInterface()->GetInfo(std::move(callback));
}
void AdapterInterceptorForTesting::AddObserver(::mojo::PendingRemote<AdapterObserver> observer, AddObserverCallback callback) {
  GetForwardingInterface()->AddObserver(
    std::move(observer)
    , std::move(callback));
}
void AdapterInterceptorForTesting::RegisterAdvertisement(const ::device::BluetoothUUID& service_id, const std::vector<uint8_t>& service_data, bool use_scan_response, bool connectable, RegisterAdvertisementCallback callback) {
  GetForwardingInterface()->RegisterAdvertisement(
    std::move(service_id)
    , 
    std::move(service_data)
    , 
    std::move(use_scan_response)
    , 
    std::move(connectable)
    , std::move(callback));
}
void AdapterInterceptorForTesting::SetDiscoverable(bool discoverable, SetDiscoverableCallback callback) {
  GetForwardingInterface()->SetDiscoverable(
    std::move(discoverable)
    , std::move(callback));
}
void AdapterInterceptorForTesting::SetName(const std::string& name, SetNameCallback callback) {
  GetForwardingInterface()->SetName(
    std::move(name)
    , std::move(callback));
}
void AdapterInterceptorForTesting::StartDiscoverySession(const std::string& client_name, StartDiscoverySessionCallback callback) {
  GetForwardingInterface()->StartDiscoverySession(
    std::move(client_name)
    , std::move(callback));
}
void AdapterInterceptorForTesting::ConnectToServiceInsecurely(const std::string& address, const ::device::BluetoothUUID& service_uuid, bool should_unbond_on_error, ConnectToServiceInsecurelyCallback callback) {
  GetForwardingInterface()->ConnectToServiceInsecurely(
    std::move(address)
    , 
    std::move(service_uuid)
    , 
    std::move(should_unbond_on_error)
    , std::move(callback));
}
void AdapterInterceptorForTesting::CreateRfcommServiceInsecurely(const std::string& service_name, const ::device::BluetoothUUID& service_uuid, CreateRfcommServiceInsecurelyCallback callback) {
  GetForwardingInterface()->CreateRfcommServiceInsecurely(
    std::move(service_name)
    , 
    std::move(service_uuid)
    , std::move(callback));
}
void AdapterInterceptorForTesting::CreateLocalGattService(const ::device::BluetoothUUID& service_id, ::mojo::PendingRemote<GattServiceObserver> observer, CreateLocalGattServiceCallback callback) {
  GetForwardingInterface()->CreateLocalGattService(
    std::move(service_id)
    , 
    std::move(observer)
    , std::move(callback));
}
void AdapterInterceptorForTesting::IsLeScatternetDualRoleSupported(IsLeScatternetDualRoleSupportedCallback callback) {
  GetForwardingInterface()->IsLeScatternetDualRoleSupported(std::move(callback));
}
AdapterAsyncWaiter::AdapterAsyncWaiter(
    Adapter* proxy) : proxy_(proxy) {}

AdapterAsyncWaiter::~AdapterAsyncWaiter() = default;


void AdapterAsyncWaiter::ConnectToDevice(
    const std::string& address, ConnectResult* out_result, ::mojo::PendingRemote<::bluetooth::mojom::Device>* out_device) {
  base::RunLoop loop;
  proxy_->ConnectToDevice(
      std::move(address),
      base::BindOnce(
          [](base::RunLoop* loop,
             ConnectResult* out_result
,
             ::mojo::PendingRemote<::bluetooth::mojom::Device>* out_device
,
             ConnectResult result,
             ::mojo::PendingRemote<::bluetooth::mojom::Device> device) {*out_result = std::move(result);*out_device = std::move(device);
            loop->Quit();
          },
          &loop,
          out_result,
          out_device));
  loop.Run();
}



void AdapterAsyncWaiter::GetDevices(
    std::vector<::bluetooth::mojom::DeviceInfoPtr>* out_devices) {
  base::RunLoop loop;
  proxy_->GetDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::bluetooth::mojom::DeviceInfoPtr>* out_devices
,
             std::vector<::bluetooth::mojom::DeviceInfoPtr> devices) {*out_devices = std::move(devices);
            loop->Quit();
          },
          &loop,
          out_devices));
  loop.Run();
}

std::vector<::bluetooth::mojom::DeviceInfoPtr> AdapterAsyncWaiter::GetDevices(
    ) {
  std::vector<::bluetooth::mojom::DeviceInfoPtr> async_wait_result;
  GetDevices(&async_wait_result);
  return async_wait_result;
}

void AdapterAsyncWaiter::GetInfo(
    AdapterInfoPtr* out_info) {
  base::RunLoop loop;
  proxy_->GetInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             AdapterInfoPtr* out_info
,
             AdapterInfoPtr info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

AdapterInfoPtr AdapterAsyncWaiter::GetInfo(
    ) {
  AdapterInfoPtr async_wait_result;
  GetInfo(&async_wait_result);
  return async_wait_result;
}

void AdapterAsyncWaiter::AddObserver(
    ::mojo::PendingRemote<AdapterObserver> observer) {
  base::RunLoop loop;
  proxy_->AddObserver(
      std::move(observer),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void AdapterAsyncWaiter::RegisterAdvertisement(
    const ::device::BluetoothUUID& service_id, const std::vector<uint8_t>& service_data, bool use_scan_response, bool connectable, ::mojo::PendingRemote<Advertisement>* out_advertisement) {
  base::RunLoop loop;
  proxy_->RegisterAdvertisement(
      std::move(service_id),
      std::move(service_data),
      std::move(use_scan_response),
      std::move(connectable),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<Advertisement>* out_advertisement
,
             ::mojo::PendingRemote<Advertisement> advertisement) {*out_advertisement = std::move(advertisement);
            loop->Quit();
          },
          &loop,
          out_advertisement));
  loop.Run();
}

::mojo::PendingRemote<Advertisement> AdapterAsyncWaiter::RegisterAdvertisement(
    const ::device::BluetoothUUID& service_id, const std::vector<uint8_t>& service_data, bool use_scan_response, bool connectable) {
  ::mojo::PendingRemote<Advertisement> async_wait_result;
  RegisterAdvertisement(std::move(service_id),std::move(service_data),std::move(use_scan_response),std::move(connectable),&async_wait_result);
  return async_wait_result;
}

void AdapterAsyncWaiter::SetDiscoverable(
    bool discoverable, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetDiscoverable(
      std::move(discoverable),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool AdapterAsyncWaiter::SetDiscoverable(
    bool discoverable) {
  bool async_wait_result;
  SetDiscoverable(std::move(discoverable),&async_wait_result);
  return async_wait_result;
}

void AdapterAsyncWaiter::SetName(
    const std::string& name, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetName(
      std::move(name),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool AdapterAsyncWaiter::SetName(
    const std::string& name) {
  bool async_wait_result;
  SetName(std::move(name),&async_wait_result);
  return async_wait_result;
}

void AdapterAsyncWaiter::StartDiscoverySession(
    const std::string& client_name, ::mojo::PendingRemote<DiscoverySession>* out_session) {
  base::RunLoop loop;
  proxy_->StartDiscoverySession(
      std::move(client_name),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<DiscoverySession>* out_session
,
             ::mojo::PendingRemote<DiscoverySession> session) {*out_session = std::move(session);
            loop->Quit();
          },
          &loop,
          out_session));
  loop.Run();
}

::mojo::PendingRemote<DiscoverySession> AdapterAsyncWaiter::StartDiscoverySession(
    const std::string& client_name) {
  ::mojo::PendingRemote<DiscoverySession> async_wait_result;
  StartDiscoverySession(std::move(client_name),&async_wait_result);
  return async_wait_result;
}

void AdapterAsyncWaiter::ConnectToServiceInsecurely(
    const std::string& address, const ::device::BluetoothUUID& service_uuid, bool should_unbond_on_error, ConnectToServiceResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->ConnectToServiceInsecurely(
      std::move(address),
      std::move(service_uuid),
      std::move(should_unbond_on_error),
      base::BindOnce(
          [](base::RunLoop* loop,
             ConnectToServiceResultPtr* out_result
,
             ConnectToServiceResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ConnectToServiceResultPtr AdapterAsyncWaiter::ConnectToServiceInsecurely(
    const std::string& address, const ::device::BluetoothUUID& service_uuid, bool should_unbond_on_error) {
  ConnectToServiceResultPtr async_wait_result;
  ConnectToServiceInsecurely(std::move(address),std::move(service_uuid),std::move(should_unbond_on_error),&async_wait_result);
  return async_wait_result;
}

void AdapterAsyncWaiter::CreateRfcommServiceInsecurely(
    const std::string& service_name, const ::device::BluetoothUUID& service_uuid, ::mojo::PendingRemote<ServerSocket>* out_server_socket) {
  base::RunLoop loop;
  proxy_->CreateRfcommServiceInsecurely(
      std::move(service_name),
      std::move(service_uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<ServerSocket>* out_server_socket
,
             ::mojo::PendingRemote<ServerSocket> server_socket) {*out_server_socket = std::move(server_socket);
            loop->Quit();
          },
          &loop,
          out_server_socket));
  loop.Run();
}

::mojo::PendingRemote<ServerSocket> AdapterAsyncWaiter::CreateRfcommServiceInsecurely(
    const std::string& service_name, const ::device::BluetoothUUID& service_uuid) {
  ::mojo::PendingRemote<ServerSocket> async_wait_result;
  CreateRfcommServiceInsecurely(std::move(service_name),std::move(service_uuid),&async_wait_result);
  return async_wait_result;
}

void AdapterAsyncWaiter::CreateLocalGattService(
    const ::device::BluetoothUUID& service_id, ::mojo::PendingRemote<GattServiceObserver> observer, ::mojo::PendingRemote<GattService>* out_gatt_service) {
  base::RunLoop loop;
  proxy_->CreateLocalGattService(
      std::move(service_id),
      std::move(observer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<GattService>* out_gatt_service
,
             ::mojo::PendingRemote<GattService> gatt_service) {*out_gatt_service = std::move(gatt_service);
            loop->Quit();
          },
          &loop,
          out_gatt_service));
  loop.Run();
}

::mojo::PendingRemote<GattService> AdapterAsyncWaiter::CreateLocalGattService(
    const ::device::BluetoothUUID& service_id, ::mojo::PendingRemote<GattServiceObserver> observer) {
  ::mojo::PendingRemote<GattService> async_wait_result;
  CreateLocalGattService(std::move(service_id),std::move(observer),&async_wait_result);
  return async_wait_result;
}

void AdapterAsyncWaiter::IsLeScatternetDualRoleSupported(
    bool* out_is_supported) {
  base::RunLoop loop;
  proxy_->IsLeScatternetDualRoleSupported(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_supported
,
             bool is_supported) {*out_is_supported = std::move(is_supported);
            loop->Quit();
          },
          &loop,
          out_is_supported));
  loop.Run();
}

bool AdapterAsyncWaiter::IsLeScatternetDualRoleSupported(
    ) {
  bool async_wait_result;
  IsLeScatternetDualRoleSupported(&async_wait_result);
  return async_wait_result;
}




void AdapterObserverInterceptorForTesting::PresentChanged(bool present) {
  GetForwardingInterface()->PresentChanged(
    std::move(present)
    );
}
void AdapterObserverInterceptorForTesting::PoweredChanged(bool powered) {
  GetForwardingInterface()->PoweredChanged(
    std::move(powered)
    );
}
void AdapterObserverInterceptorForTesting::DiscoverableChanged(bool discoverable) {
  GetForwardingInterface()->DiscoverableChanged(
    std::move(discoverable)
    );
}
void AdapterObserverInterceptorForTesting::DiscoveringChanged(bool discovering) {
  GetForwardingInterface()->DiscoveringChanged(
    std::move(discovering)
    );
}
void AdapterObserverInterceptorForTesting::DeviceAdded(::bluetooth::mojom::DeviceInfoPtr device) {
  GetForwardingInterface()->DeviceAdded(
    std::move(device)
    );
}
void AdapterObserverInterceptorForTesting::DeviceChanged(::bluetooth::mojom::DeviceInfoPtr device) {
  GetForwardingInterface()->DeviceChanged(
    std::move(device)
    );
}
void AdapterObserverInterceptorForTesting::DeviceRemoved(::bluetooth::mojom::DeviceInfoPtr device) {
  GetForwardingInterface()->DeviceRemoved(
    std::move(device)
    );
}
AdapterObserverAsyncWaiter::AdapterObserverAsyncWaiter(
    AdapterObserver* proxy) : proxy_(proxy) {}

AdapterObserverAsyncWaiter::~AdapterObserverAsyncWaiter() = default;







}  // bluetooth::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif