// device/bluetooth/public/mojom/adapter.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_TEST_UTILS_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_TEST_UTILS_H_

#include "device/bluetooth/public/mojom/adapter.mojom.h"


namespace bluetooth::mojom {


class  AdvertisementInterceptorForTesting : public Advertisement {
  virtual Advertisement* GetForwardingInterface() = 0;
  void Unregister(UnregisterCallback callback) override;
};
class  AdvertisementAsyncWaiter {
 public:
  explicit AdvertisementAsyncWaiter(Advertisement* proxy);

  AdvertisementAsyncWaiter(const AdvertisementAsyncWaiter&) = delete;
  AdvertisementAsyncWaiter& operator=(const AdvertisementAsyncWaiter&) = delete;

  ~AdvertisementAsyncWaiter();
  void Unregister(
      );
  

 private:
  Advertisement* const proxy_;
};


class  DiscoverySessionInterceptorForTesting : public DiscoverySession {
  virtual DiscoverySession* GetForwardingInterface() = 0;
  void IsActive(IsActiveCallback callback) override;
  void Stop(StopCallback callback) override;
};
class  DiscoverySessionAsyncWaiter {
 public:
  explicit DiscoverySessionAsyncWaiter(DiscoverySession* proxy);

  DiscoverySessionAsyncWaiter(const DiscoverySessionAsyncWaiter&) = delete;
  DiscoverySessionAsyncWaiter& operator=(const DiscoverySessionAsyncWaiter&) = delete;

  ~DiscoverySessionAsyncWaiter();
  void IsActive(
      bool* out_active);
  bool IsActive();
  void Stop(
      bool* out_success);
  bool Stop();

 private:
  DiscoverySession* const proxy_;
};


class  SocketInterceptorForTesting : public Socket {
  virtual Socket* GetForwardingInterface() = 0;
  void Disconnect(DisconnectCallback callback) override;
};
class  SocketAsyncWaiter {
 public:
  explicit SocketAsyncWaiter(Socket* proxy);

  SocketAsyncWaiter(const SocketAsyncWaiter&) = delete;
  SocketAsyncWaiter& operator=(const SocketAsyncWaiter&) = delete;

  ~SocketAsyncWaiter();
  void Disconnect(
      );
  

 private:
  Socket* const proxy_;
};


class  ServerSocketInterceptorForTesting : public ServerSocket {
  virtual ServerSocket* GetForwardingInterface() = 0;
  void Accept(AcceptCallback callback) override;
  void Disconnect(DisconnectCallback callback) override;
};
class  ServerSocketAsyncWaiter {
 public:
  explicit ServerSocketAsyncWaiter(ServerSocket* proxy);

  ServerSocketAsyncWaiter(const ServerSocketAsyncWaiter&) = delete;
  ServerSocketAsyncWaiter& operator=(const ServerSocketAsyncWaiter&) = delete;

  ~ServerSocketAsyncWaiter();
  void Accept(
      AcceptConnectionResultPtr* out_result);
  AcceptConnectionResultPtr Accept();
  void Disconnect(
      );
  

 private:
  ServerSocket* const proxy_;
};


class  GattServiceInterceptorForTesting : public GattService {
  virtual GattService* GetForwardingInterface() = 0;
  void CreateCharacteristic(const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothGattCharacteristic::Permissions& permissions, const ::device::BluetoothGattCharacteristic::Properties& properties, CreateCharacteristicCallback callback) override;
  void Register(RegisterCallback callback) override;
};
class  GattServiceAsyncWaiter {
 public:
  explicit GattServiceAsyncWaiter(GattService* proxy);

  GattServiceAsyncWaiter(const GattServiceAsyncWaiter&) = delete;
  GattServiceAsyncWaiter& operator=(const GattServiceAsyncWaiter&) = delete;

  ~GattServiceAsyncWaiter();
  void CreateCharacteristic(
      const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothGattCharacteristic::Permissions& permissions, const ::device::BluetoothGattCharacteristic::Properties& properties, bool* out_success);
  bool CreateCharacteristic(const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothGattCharacteristic::Permissions& permissions, const ::device::BluetoothGattCharacteristic::Properties& properties);
  void Register(
      std::optional<::device::BluetoothGattService::GattErrorCode>* out_error_code);
  std::optional<::device::BluetoothGattService::GattErrorCode> Register();

 private:
  GattService* const proxy_;
};


class  GattServiceObserverInterceptorForTesting : public GattServiceObserver {
  virtual GattServiceObserver* GetForwardingInterface() = 0;
  void OnLocalCharacteristicRead(::bluetooth::mojom::DeviceInfoPtr remote_device, const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothUUID& service_uuid, uint32_t offset, OnLocalCharacteristicReadCallback callback) override;
};
class  GattServiceObserverAsyncWaiter {
 public:
  explicit GattServiceObserverAsyncWaiter(GattServiceObserver* proxy);

  GattServiceObserverAsyncWaiter(const GattServiceObserverAsyncWaiter&) = delete;
  GattServiceObserverAsyncWaiter& operator=(const GattServiceObserverAsyncWaiter&) = delete;

  ~GattServiceObserverAsyncWaiter();
  void OnLocalCharacteristicRead(
      ::bluetooth::mojom::DeviceInfoPtr remote_device, const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothUUID& service_uuid, uint32_t offset, LocalCharacteristicReadResultPtr* out_read_result);
  LocalCharacteristicReadResultPtr OnLocalCharacteristicRead(::bluetooth::mojom::DeviceInfoPtr remote_device, const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothUUID& service_uuid, uint32_t offset);

 private:
  GattServiceObserver* const proxy_;
};


class  AdapterInterceptorForTesting : public Adapter {
  virtual Adapter* GetForwardingInterface() = 0;
  void ConnectToDevice(const std::string& address, ConnectToDeviceCallback callback) override;
  void GetDevices(GetDevicesCallback callback) override;
  void GetInfo(GetInfoCallback callback) override;
  void AddObserver(::mojo::PendingRemote<AdapterObserver> observer, AddObserverCallback callback) override;
  void RegisterAdvertisement(const ::device::BluetoothUUID& service_id, const std::vector<uint8_t>& service_data, bool use_scan_response, bool connectable, RegisterAdvertisementCallback callback) override;
  void SetDiscoverable(bool discoverable, SetDiscoverableCallback callback) override;
  void SetName(const std::string& name, SetNameCallback callback) override;
  void StartDiscoverySession(const std::string& client_name, StartDiscoverySessionCallback callback) override;
  void ConnectToServiceInsecurely(const std::string& address, const ::device::BluetoothUUID& service_uuid, bool should_unbond_on_error, ConnectToServiceInsecurelyCallback callback) override;
  void CreateRfcommServiceInsecurely(const std::string& service_name, const ::device::BluetoothUUID& service_uuid, CreateRfcommServiceInsecurelyCallback callback) override;
  void CreateLocalGattService(const ::device::BluetoothUUID& service_id, ::mojo::PendingRemote<GattServiceObserver> observer, CreateLocalGattServiceCallback callback) override;
  void IsLeScatternetDualRoleSupported(IsLeScatternetDualRoleSupportedCallback callback) override;
};
class  AdapterAsyncWaiter {
 public:
  explicit AdapterAsyncWaiter(Adapter* proxy);

  AdapterAsyncWaiter(const AdapterAsyncWaiter&) = delete;
  AdapterAsyncWaiter& operator=(const AdapterAsyncWaiter&) = delete;

  ~AdapterAsyncWaiter();
  void ConnectToDevice(
      const std::string& address, ConnectResult* out_result, ::mojo::PendingRemote<::bluetooth::mojom::Device>* out_device);
  
  void GetDevices(
      std::vector<::bluetooth::mojom::DeviceInfoPtr>* out_devices);
  std::vector<::bluetooth::mojom::DeviceInfoPtr> GetDevices();
  void GetInfo(
      AdapterInfoPtr* out_info);
  AdapterInfoPtr GetInfo();
  void AddObserver(
      ::mojo::PendingRemote<AdapterObserver> observer);
  
  void RegisterAdvertisement(
      const ::device::BluetoothUUID& service_id, const std::vector<uint8_t>& service_data, bool use_scan_response, bool connectable, ::mojo::PendingRemote<Advertisement>* out_advertisement);
  ::mojo::PendingRemote<Advertisement> RegisterAdvertisement(const ::device::BluetoothUUID& service_id, const std::vector<uint8_t>& service_data, bool use_scan_response, bool connectable);
  void SetDiscoverable(
      bool discoverable, bool* out_success);
  bool SetDiscoverable(bool discoverable);
  void SetName(
      const std::string& name, bool* out_success);
  bool SetName(const std::string& name);
  void StartDiscoverySession(
      const std::string& client_name, ::mojo::PendingRemote<DiscoverySession>* out_session);
  ::mojo::PendingRemote<DiscoverySession> StartDiscoverySession(const std::string& client_name);
  void ConnectToServiceInsecurely(
      const std::string& address, const ::device::BluetoothUUID& service_uuid, bool should_unbond_on_error, ConnectToServiceResultPtr* out_result);
  ConnectToServiceResultPtr ConnectToServiceInsecurely(const std::string& address, const ::device::BluetoothUUID& service_uuid, bool should_unbond_on_error);
  void CreateRfcommServiceInsecurely(
      const std::string& service_name, const ::device::BluetoothUUID& service_uuid, ::mojo::PendingRemote<ServerSocket>* out_server_socket);
  ::mojo::PendingRemote<ServerSocket> CreateRfcommServiceInsecurely(const std::string& service_name, const ::device::BluetoothUUID& service_uuid);
  void CreateLocalGattService(
      const ::device::BluetoothUUID& service_id, ::mojo::PendingRemote<GattServiceObserver> observer, ::mojo::PendingRemote<GattService>* out_gatt_service);
  ::mojo::PendingRemote<GattService> CreateLocalGattService(const ::device::BluetoothUUID& service_id, ::mojo::PendingRemote<GattServiceObserver> observer);
  void IsLeScatternetDualRoleSupported(
      bool* out_is_supported);
  bool IsLeScatternetDualRoleSupported();

 private:
  Adapter* const proxy_;
};


class  AdapterObserverInterceptorForTesting : public AdapterObserver {
  virtual AdapterObserver* GetForwardingInterface() = 0;
  void PresentChanged(bool present) override;
  void PoweredChanged(bool powered) override;
  void DiscoverableChanged(bool discoverable) override;
  void DiscoveringChanged(bool discovering) override;
  void DeviceAdded(::bluetooth::mojom::DeviceInfoPtr device) override;
  void DeviceChanged(::bluetooth::mojom::DeviceInfoPtr device) override;
  void DeviceRemoved(::bluetooth::mojom::DeviceInfoPtr device) override;
};
class  AdapterObserverAsyncWaiter {
 public:
  explicit AdapterObserverAsyncWaiter(AdapterObserver* proxy);

  AdapterObserverAsyncWaiter(const AdapterObserverAsyncWaiter&) = delete;
  AdapterObserverAsyncWaiter& operator=(const AdapterObserverAsyncWaiter&) = delete;

  ~AdapterObserverAsyncWaiter();

 private:
  AdapterObserver* const proxy_;
};




}  // bluetooth::mojom

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_TEST_UTILS_H_