// device/bluetooth/public/mojom/adapter.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_SEND_VALIDATION_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_SEND_VALIDATION_H_

#include "device/bluetooth/public/mojom/adapter.mojom-shared-internal.h"
#include "device/bluetooth/public/mojom/device.mojom-shared.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared.h"
#include "device/bluetooth/public/mojom/gatt_characteristic_permissions.mojom-shared.h"
#include "device/bluetooth/public/mojom/gatt_characteristic_properties.mojom-shared.h"
#include "device/bluetooth/public/mojom/gatt_service_error_code.mojom-shared.h"

#include "device/bluetooth/public/mojom/adapter.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::bluetooth::mojom::ConnectResult, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::bluetooth::mojom::ConnectToServiceResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::ConnectToServiceResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::ConnectToServiceResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::socket(input)) in_socket = Traits::socket(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::SocketInterfaceBase>>(
        in_socket,
        &fragment->socket,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->socket)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid socket in ConnectToServiceResult struct");

      decltype(Traits::receive_stream(input)) in_receive_stream = Traits::receive_stream(input);

      
      mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
        in_receive_stream,
        &fragment->receive_stream,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->receive_stream)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid receive_stream in ConnectToServiceResult struct");

      decltype(Traits::send_stream(input)) in_send_stream = Traits::send_stream(input);

      
      mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
        in_send_stream,
        &fragment->send_stream,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->send_stream)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid send_stream in ConnectToServiceResult struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::bluetooth::mojom::AcceptConnectionResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::AcceptConnectionResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::AcceptConnectionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::device(input)) in_device = Traits::device(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->device)::BaseType> device_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::bluetooth::mojom::DeviceInfoDataView, send_validation>(
        in_device,
        device_fragment);

      fragment->device.Set(
          device_fragment.is_null() ? nullptr : device_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->device.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device in AcceptConnectionResult struct");

      decltype(Traits::socket(input)) in_socket = Traits::socket(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::SocketInterfaceBase>>(
        in_socket,
        &fragment->socket,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->socket)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid socket in AcceptConnectionResult struct");

      decltype(Traits::receive_stream(input)) in_receive_stream = Traits::receive_stream(input);

      
      mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
        in_receive_stream,
        &fragment->receive_stream,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->receive_stream)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid receive_stream in AcceptConnectionResult struct");

      decltype(Traits::send_stream(input)) in_send_stream = Traits::send_stream(input);

      
      mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
        in_send_stream,
        &fragment->send_stream,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->send_stream)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid send_stream in AcceptConnectionResult struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::bluetooth::mojom::AdapterInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::AdapterInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::AdapterInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::address(input)) in_address = Traits::address(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->address)::BaseType> address_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_address,
        address_fragment);

      fragment->address.Set(
          address_fragment.is_null() ? nullptr : address_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->address.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null address in AdapterInfo struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in AdapterInfo struct");

      decltype(Traits::system_name(input)) in_system_name = Traits::system_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->system_name)::BaseType> system_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_system_name,
        system_name_fragment);

      fragment->system_name.Set(
          system_name_fragment.is_null() ? nullptr : system_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->system_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null system_name in AdapterInfo struct");

      fragment->floss = Traits::floss(input);

      fragment->extended_advertisement_support = Traits::extended_advertisement_support(input);

      fragment->initialized = Traits::initialized(input);

      fragment->present = Traits::present(input);

      fragment->powered = Traits::powered(input);

      fragment->discoverable = Traits::discoverable(input);

      fragment->discovering = Traits::discovering(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::bluetooth::mojom::LocalCharacteristicReadResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::bluetooth::mojom::LocalCharacteristicReadResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::bluetooth::mojom::internal::LocalCharacteristicReadResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::bluetooth::mojom::LocalCharacteristicReadResultDataView::Tag::kErrorCode: {
    decltype(Traits::error_code(input))
    in_error_code = Traits::error_code(input);
        
mojo::internal::Serialize<::bluetooth::mojom::GattServiceErrorCode, send_validation>(
  in_error_code,
  &fragment->data.f_error_code);
    break;
  }
  case ::bluetooth::mojom::LocalCharacteristicReadResultDataView::Tag::kData: {
    decltype(Traits::data(input))
    in_data = Traits::data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_data)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
  in_data,
  value_fragment,
  &data_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null data in LocalCharacteristicReadResult union");
    fragment->data.f_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_SEND_VALIDATION_H_