// content/services/auction_worklet/public/mojom/seller_worklet.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-features.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-shared.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-forward.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-forward.h"
#include "content/services/auction_worklet/public/mojom/real_time_reporting.mojom-forward.h"
#include "content/services/auction_worklet/public/mojom/reject_reason.mojom-forward.h"
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom-forward.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-forward.h"
#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace auction_worklet::mojom {

class ScoreAdClientProxy;

template <typename ImplRefTraits>
class ScoreAdClientStub;

class ScoreAdClientRequestValidator;


class CONTENT_EXPORT ScoreAdClient
    : public ScoreAdClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "auction_worklet.mojom.ScoreAdClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ScoreAdClientInterfaceBase;
  using Proxy_ = ScoreAdClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ScoreAdClientStub<ImplRefTraits>;

  using RequestValidator_ = ScoreAdClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnScoreAdCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnScoreAdComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ScoreAdClient() = default;

  virtual void OnScoreAdComplete(double score, ::auction_worklet::mojom::RejectReason reject_reason, ComponentAuctionModifiedBidParamsPtr component_auction_modified_bid_params, std::optional<double> bid_in_seller_currency, std::optional<uint32_t> scoring_signals_data_version, const std::optional<::GURL>& debug_loss_report_url, const std::optional<::GURL>& debug_win_report_url, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> pa_requests, std::vector<::auction_worklet::mojom::RealTimeReportingContributionPtr> real_time_contributions, SellerTimingMetricsPtr score_ad_timing_metrics, ScoreAdDependencyLatenciesPtr score_ad_dependency_latencies, const std::vector<std::string>& errors) = 0;
};

class SellerWorkletProxy;

template <typename ImplRefTraits>
class SellerWorkletStub;

class SellerWorkletRequestValidator;
class SellerWorkletResponseValidator;


class CONTENT_EXPORT SellerWorklet
    : public SellerWorkletInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "auction_worklet.mojom.SellerWorklet";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SellerWorkletInterfaceBase;
  using Proxy_ = SellerWorkletProxy;

  template <typename ImplRefTraits>
  using Stub_ = SellerWorkletStub<ImplRefTraits>;

  using RequestValidator_ = SellerWorkletRequestValidator;
  using ResponseValidator_ = SellerWorkletResponseValidator;
  enum MethodMinVersions : uint32_t {
    kScoreAdMinVersion = 0,
    kSendPendingSignalsRequestsMinVersion = 0,
    kReportResultMinVersion = 0,
    kConnectDevToolsAgentMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ScoreAd_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendPendingSignalsRequests_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConnectDevToolsAgent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SellerWorklet() = default;

  virtual void ScoreAd(const std::string& ad_metadata_json, double bid, const std::optional<::blink::AdCurrency>& bid_currency, const ::blink::AuctionConfig::NonSharedParams& auction_ad_config_non_shared_params, ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr key_value_signals_cache_key, CreativeInfoWithoutOwnerPtr ad, std::vector<CreativeInfoWithoutOwnerPtr> ad_components, const std::optional<::GURL>& direct_from_seller_seller_signals, const std::optional<std::string>& direct_from_seller_seller_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot, ComponentAuctionOtherSellerPtr browser_signals_other_seller, const std::optional<::blink::AdCurrency>& component_expect_bid_currency, const ::url::Origin& browser_signal_interest_group_owner, const std::optional<std::string>& browser_signal_selected_buyer_and_seller_reporting_id, const std::optional<std::string>& browser_signal_buyer_and_seller_reporting_id, uint32_t browser_signal_bidding_duration_msecs, bool browser_signal_for_debugging_only_in_cooldown_or_lockout, bool browser_signal_for_debugging_only_sampling, std::optional<::base::TimeDelta> seller_timeout, uint64_t group_by_origin_id, bool allow_group_by_origin_mode, uint64_t trace_id, const ::url::Origin& bidder_joining_origin, ::mojo::PendingRemote<ScoreAdClient> score_ad_client) = 0;

  virtual void SendPendingSignalsRequests() = 0;

  using ReportResultCallback = base::OnceCallback<void(const std::optional<std::string>&, const std::optional<::GURL>&, const base::flat_map<std::string, ::GURL>&, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr>, SellerTimingMetricsPtr, const std::vector<std::string>&)>;
  using ReportResultMojoCallback = base::OnceCallback<void(const std::optional<std::string>&, const std::optional<::GURL>&, const base::flat_map<std::string, ::GURL>&, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr>, SellerTimingMetricsPtr, const std::vector<std::string>&)>;

  virtual void ReportResult(const ::blink::AuctionConfig::NonSharedParams& auction_ad_config_non_shared_params, const std::optional<::GURL>& direct_from_seller_seller_signals, const std::optional<std::string>& direct_from_seller_seller_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot, ComponentAuctionOtherSellerPtr browser_signals_other_seller, const ::url::Origin& browser_signal_interest_group_owner, const std::optional<std::string>& browser_signal_buyer_and_seller_reporting_id, const std::optional<std::string>& browser_signal_selected_buyer_and_seller_reporting_id, const ::GURL& browser_signal_render_url, double browser_signal_bid, const std::optional<::blink::AdCurrency>& browser_signal_bid_currency, double browser_signal_desirability, double browser_signal_highest_scoring_other_bid, const std::optional<::blink::AdCurrency>& browser_signal_highest_scoring_other_bid_currency, ComponentAuctionReportResultParamsPtr browser_signals_component_auction_report_result_params, std::optional<uint32_t> scoring_signals_data_version, uint64_t trace_id, ReportResultCallback callback) = 0;

  virtual void ConnectDevToolsAgent(::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> agent, uint32_t thread_index) = 0;
};



class CONTENT_EXPORT ScoreAdClientProxy
    : public ScoreAdClient {
 public:
  using InterfaceType = ScoreAdClient;

  explicit ScoreAdClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnScoreAdComplete(double score, ::auction_worklet::mojom::RejectReason reject_reason, ComponentAuctionModifiedBidParamsPtr component_auction_modified_bid_params, std::optional<double> bid_in_seller_currency, std::optional<uint32_t> scoring_signals_data_version, const std::optional<::GURL>& debug_loss_report_url, const std::optional<::GURL>& debug_win_report_url, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> pa_requests, std::vector<::auction_worklet::mojom::RealTimeReportingContributionPtr> real_time_contributions, SellerTimingMetricsPtr score_ad_timing_metrics, ScoreAdDependencyLatenciesPtr score_ad_dependency_latencies, const std::vector<std::string>& errors) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT SellerWorkletProxy
    : public SellerWorklet {
 public:
  using InterfaceType = SellerWorklet;

  explicit SellerWorkletProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ScoreAd(const std::string& ad_metadata_json, double bid, const std::optional<::blink::AdCurrency>& bid_currency, const ::blink::AuctionConfig::NonSharedParams& auction_ad_config_non_shared_params, ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr key_value_signals_cache_key, CreativeInfoWithoutOwnerPtr ad, std::vector<CreativeInfoWithoutOwnerPtr> ad_components, const std::optional<::GURL>& direct_from_seller_seller_signals, const std::optional<std::string>& direct_from_seller_seller_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot, ComponentAuctionOtherSellerPtr browser_signals_other_seller, const std::optional<::blink::AdCurrency>& component_expect_bid_currency, const ::url::Origin& browser_signal_interest_group_owner, const std::optional<std::string>& browser_signal_selected_buyer_and_seller_reporting_id, const std::optional<std::string>& browser_signal_buyer_and_seller_reporting_id, uint32_t browser_signal_bidding_duration_msecs, bool browser_signal_for_debugging_only_in_cooldown_or_lockout, bool browser_signal_for_debugging_only_sampling, std::optional<::base::TimeDelta> seller_timeout, uint64_t group_by_origin_id, bool allow_group_by_origin_mode, uint64_t trace_id, const ::url::Origin& bidder_joining_origin, ::mojo::PendingRemote<ScoreAdClient> score_ad_client) final;
  
  void SendPendingSignalsRequests() final;
  
  void ReportResult(const ::blink::AuctionConfig::NonSharedParams& auction_ad_config_non_shared_params, const std::optional<::GURL>& direct_from_seller_seller_signals, const std::optional<std::string>& direct_from_seller_seller_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot, ComponentAuctionOtherSellerPtr browser_signals_other_seller, const ::url::Origin& browser_signal_interest_group_owner, const std::optional<std::string>& browser_signal_buyer_and_seller_reporting_id, const std::optional<std::string>& browser_signal_selected_buyer_and_seller_reporting_id, const ::GURL& browser_signal_render_url, double browser_signal_bid, const std::optional<::blink::AdCurrency>& browser_signal_bid_currency, double browser_signal_desirability, double browser_signal_highest_scoring_other_bid, const std::optional<::blink::AdCurrency>& browser_signal_highest_scoring_other_bid_currency, ComponentAuctionReportResultParamsPtr browser_signals_component_auction_report_result_params, std::optional<uint32_t> scoring_signals_data_version, uint64_t trace_id, ReportResultCallback callback) final;
  
  void ConnectDevToolsAgent(::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> agent, uint32_t thread_index) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT ScoreAdClientStubDispatch {
 public:
  static bool Accept(ScoreAdClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ScoreAdClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ScoreAdClient>>
class ScoreAdClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ScoreAdClientStub() = default;
  ~ScoreAdClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScoreAdClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScoreAdClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT SellerWorkletStubDispatch {
 public:
  static bool Accept(SellerWorklet* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SellerWorklet* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SellerWorklet>>
class SellerWorkletStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SellerWorkletStub() = default;
  ~SellerWorkletStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SellerWorkletStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SellerWorkletStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT ScoreAdClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT SellerWorkletRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT SellerWorkletResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class CONTENT_EXPORT ComponentAuctionReportResultParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ComponentAuctionReportResultParams, T>::value>;
  using DataView = ComponentAuctionReportResultParamsDataView;
  using Data_ = internal::ComponentAuctionReportResultParams_Data;

  template <typename... Args>
  static ComponentAuctionReportResultParamsPtr New(Args&&... args) {
    return ComponentAuctionReportResultParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ComponentAuctionReportResultParamsPtr From(const U& u) {
    return mojo::TypeConverter<ComponentAuctionReportResultParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ComponentAuctionReportResultParams>::Convert(*this);
  }


  ComponentAuctionReportResultParams();

  ComponentAuctionReportResultParams(
      const std::string& top_level_seller_signals,
      std::optional<double> modified_bid);


  ~ComponentAuctionReportResultParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ComponentAuctionReportResultParamsPtr>
  ComponentAuctionReportResultParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ComponentAuctionReportResultParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ComponentAuctionReportResultParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ComponentAuctionReportResultParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ComponentAuctionReportResultParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ComponentAuctionReportResultParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ComponentAuctionReportResultParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ComponentAuctionReportResultParams_UnserializedMessageContext<
            UserType, ComponentAuctionReportResultParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ComponentAuctionReportResultParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ComponentAuctionReportResultParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ComponentAuctionReportResultParams_UnserializedMessageContext<
            UserType, ComponentAuctionReportResultParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ComponentAuctionReportResultParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string top_level_seller_signals;
  
  std::optional<double> modified_bid;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ComponentAuctionReportResultParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ComponentAuctionReportResultParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ComponentAuctionReportResultParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ComponentAuctionReportResultParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class CONTENT_EXPORT ComponentAuctionOtherSeller {
 public:
  using DataView = ComponentAuctionOtherSellerDataView;
  using Data_ = internal::ComponentAuctionOtherSeller_Data;
  using Tag = Data_::ComponentAuctionOtherSeller_Tag;

  template <typename... Args>
  static ComponentAuctionOtherSellerPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |top_level_seller|.
  static ComponentAuctionOtherSellerPtr NewTopLevelSeller(
      const ::url::Origin& value);
  // Construct an instance holding |component_seller|.
  static ComponentAuctionOtherSellerPtr NewComponentSeller(
      const ::url::Origin& value);

  template <typename U>
  static ComponentAuctionOtherSellerPtr From(const U& u) {
    return mojo::TypeConverter<ComponentAuctionOtherSellerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ComponentAuctionOtherSeller>::Convert(*this);
  }
  ~ComponentAuctionOtherSeller();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ComponentAuctionOtherSeller(const ComponentAuctionOtherSeller& other) = delete;
  ComponentAuctionOtherSeller& operator=(const ComponentAuctionOtherSeller& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ComponentAuctionOtherSellerPtr>
  ComponentAuctionOtherSellerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ComponentAuctionOtherSeller>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ComponentAuctionOtherSeller>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_top_level_seller() const { return tag_ == Tag::kTopLevelSeller; }
  const ::url::Origin& get_top_level_seller() const {
    CHECK(tag_ == Tag::kTopLevelSeller);
    return data_.top_level_seller;
  }
  ::url::Origin& get_top_level_seller() {
    CHECK(tag_ == Tag::kTopLevelSeller);
    return data_.top_level_seller;
  }
  void set_top_level_seller(const ::url::Origin& top_level_seller);

  bool is_component_seller() const { return tag_ == Tag::kComponentSeller; }
  const ::url::Origin& get_component_seller() const {
    CHECK(tag_ == Tag::kComponentSeller);
    return data_.component_seller;
  }
  ::url::Origin& get_component_seller() {
    CHECK(tag_ == Tag::kComponentSeller);
    return data_.component_seller;
  }
  void set_component_seller(const ::url::Origin& component_seller);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ComponentAuctionOtherSeller::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ComponentAuctionOtherSeller::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTopLevelSeller)>,
        const ::url::Origin& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kComponentSeller)>,
        const ::url::Origin& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::url::Origin top_level_seller;
    ::url::Origin component_seller;
  };

  ComponentAuctionOtherSeller(
      std::in_place_index_t<static_cast<size_t>(Tag::kTopLevelSeller)>,
      const ::url::Origin& value);
  ComponentAuctionOtherSeller(
      std::in_place_index_t<static_cast<size_t>(Tag::kComponentSeller)>,
      const ::url::Origin& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class CONTENT_EXPORT ComponentAuctionModifiedBidParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ComponentAuctionModifiedBidParams, T>::value>;
  using DataView = ComponentAuctionModifiedBidParamsDataView;
  using Data_ = internal::ComponentAuctionModifiedBidParams_Data;

  template <typename... Args>
  static ComponentAuctionModifiedBidParamsPtr New(Args&&... args) {
    return ComponentAuctionModifiedBidParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ComponentAuctionModifiedBidParamsPtr From(const U& u) {
    return mojo::TypeConverter<ComponentAuctionModifiedBidParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ComponentAuctionModifiedBidParams>::Convert(*this);
  }


  ComponentAuctionModifiedBidParams();

  ComponentAuctionModifiedBidParams(
      const std::string& ad,
      std::optional<double> bid,
      const std::optional<::blink::AdCurrency>& bid_currency);


  ~ComponentAuctionModifiedBidParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ComponentAuctionModifiedBidParamsPtr>
  ComponentAuctionModifiedBidParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ComponentAuctionModifiedBidParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ComponentAuctionModifiedBidParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ComponentAuctionModifiedBidParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ComponentAuctionModifiedBidParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ComponentAuctionModifiedBidParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ComponentAuctionModifiedBidParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ComponentAuctionModifiedBidParams_UnserializedMessageContext<
            UserType, ComponentAuctionModifiedBidParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ComponentAuctionModifiedBidParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ComponentAuctionModifiedBidParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ComponentAuctionModifiedBidParams_UnserializedMessageContext<
            UserType, ComponentAuctionModifiedBidParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ComponentAuctionModifiedBidParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string ad;
  
  std::optional<double> bid;
  
  std::optional<::blink::AdCurrency> bid_currency;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ComponentAuctionModifiedBidParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ComponentAuctionModifiedBidParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ComponentAuctionModifiedBidParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ComponentAuctionModifiedBidParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class CONTENT_EXPORT ScoreAdDependencyLatencies {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScoreAdDependencyLatencies, T>::value>;
  using DataView = ScoreAdDependencyLatenciesDataView;
  using Data_ = internal::ScoreAdDependencyLatencies_Data;

  template <typename... Args>
  static ScoreAdDependencyLatenciesPtr New(Args&&... args) {
    return ScoreAdDependencyLatenciesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScoreAdDependencyLatenciesPtr From(const U& u) {
    return mojo::TypeConverter<ScoreAdDependencyLatenciesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScoreAdDependencyLatencies>::Convert(*this);
  }


  ScoreAdDependencyLatencies();

  ScoreAdDependencyLatencies(
      std::optional<::base::TimeDelta> code_ready_latency,
      std::optional<::base::TimeDelta> direct_from_seller_signals_latency,
      std::optional<::base::TimeDelta> trusted_scoring_signals_latency,
      ::base::TimeTicks deps_wait_start_time,
      ::base::TimeTicks score_ad_start_time,
      ::base::TimeTicks score_ad_finish_time);


  ~ScoreAdDependencyLatencies();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScoreAdDependencyLatenciesPtr>
  ScoreAdDependencyLatenciesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScoreAdDependencyLatencies::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScoreAdDependencyLatencies::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScoreAdDependencyLatencies::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScoreAdDependencyLatencies::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScoreAdDependencyLatencies::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScoreAdDependencyLatencies::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScoreAdDependencyLatencies_UnserializedMessageContext<
            UserType, ScoreAdDependencyLatencies::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScoreAdDependencyLatencies::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScoreAdDependencyLatencies::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScoreAdDependencyLatencies_UnserializedMessageContext<
            UserType, ScoreAdDependencyLatencies::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScoreAdDependencyLatencies::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeDelta> code_ready_latency;
  
  std::optional<::base::TimeDelta> direct_from_seller_signals_latency;
  
  std::optional<::base::TimeDelta> trusted_scoring_signals_latency;
  
  ::base::TimeTicks deps_wait_start_time;
  
  ::base::TimeTicks score_ad_start_time;
  
  ::base::TimeTicks score_ad_finish_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScoreAdDependencyLatencies::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScoreAdDependencyLatencies::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScoreAdDependencyLatencies::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScoreAdDependencyLatencies::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT SellerTimingMetrics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SellerTimingMetrics, T>::value>;
  using DataView = SellerTimingMetricsDataView;
  using Data_ = internal::SellerTimingMetrics_Data;

  template <typename... Args>
  static SellerTimingMetricsPtr New(Args&&... args) {
    return SellerTimingMetricsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SellerTimingMetricsPtr From(const U& u) {
    return mojo::TypeConverter<SellerTimingMetricsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SellerTimingMetrics>::Convert(*this);
  }


  SellerTimingMetrics();

  SellerTimingMetrics(
      std::optional<::base::TimeDelta> js_fetch_latency,
      ::base::TimeDelta script_latency,
      bool script_timed_out);


  ~SellerTimingMetrics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SellerTimingMetricsPtr>
  SellerTimingMetricsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SellerTimingMetrics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SellerTimingMetrics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SellerTimingMetrics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SellerTimingMetrics::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SellerTimingMetrics::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SellerTimingMetrics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SellerTimingMetrics_UnserializedMessageContext<
            UserType, SellerTimingMetrics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SellerTimingMetrics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SellerTimingMetrics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SellerTimingMetrics_UnserializedMessageContext<
            UserType, SellerTimingMetrics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SellerTimingMetrics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeDelta> js_fetch_latency;
  
  ::base::TimeDelta script_latency;
  
  bool script_timed_out;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SellerTimingMetrics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SellerTimingMetrics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SellerTimingMetrics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SellerTimingMetrics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CreativeInfoWithoutOwner {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreativeInfoWithoutOwner, T>::value>;
  using DataView = CreativeInfoWithoutOwnerDataView;
  using Data_ = internal::CreativeInfoWithoutOwner_Data;

  template <typename... Args>
  static CreativeInfoWithoutOwnerPtr New(Args&&... args) {
    return CreativeInfoWithoutOwnerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreativeInfoWithoutOwnerPtr From(const U& u) {
    return mojo::TypeConverter<CreativeInfoWithoutOwnerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreativeInfoWithoutOwner>::Convert(*this);
  }


  CreativeInfoWithoutOwner();

  CreativeInfoWithoutOwner(
      const ::blink::AdDescriptor& ad_descriptor,
      const std::optional<std::string>& creative_scanning_metadata);


  ~CreativeInfoWithoutOwner();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreativeInfoWithoutOwnerPtr>
  CreativeInfoWithoutOwnerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreativeInfoWithoutOwner::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreativeInfoWithoutOwner::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreativeInfoWithoutOwner::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreativeInfoWithoutOwner::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreativeInfoWithoutOwner::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreativeInfoWithoutOwner::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreativeInfoWithoutOwner_UnserializedMessageContext<
            UserType, CreativeInfoWithoutOwner::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreativeInfoWithoutOwner::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreativeInfoWithoutOwner::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreativeInfoWithoutOwner_UnserializedMessageContext<
            UserType, CreativeInfoWithoutOwner::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreativeInfoWithoutOwner::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::AdDescriptor ad_descriptor;
  
  std::optional<std::string> creative_scanning_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreativeInfoWithoutOwner::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreativeInfoWithoutOwner::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreativeInfoWithoutOwner::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreativeInfoWithoutOwner::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ComponentAuctionOtherSellerPtr ComponentAuctionOtherSeller::Clone() const {
  switch (tag_) {
    case Tag::kTopLevelSeller:
      return NewTopLevelSeller(
          mojo::Clone(data_.top_level_seller));
    case Tag::kComponentSeller:
      return NewComponentSeller(
          mojo::Clone(data_.component_seller));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ComponentAuctionOtherSeller>::value>::type*>
bool ComponentAuctionOtherSeller::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTopLevelSeller:
      return mojo::Equals(data_.top_level_seller, other.data_.top_level_seller);
    case Tag::kComponentSeller:
      return mojo::Equals(data_.component_seller, other.data_.component_seller);
  }

  return false;
}
template <typename StructPtrType>
ComponentAuctionModifiedBidParamsPtr ComponentAuctionModifiedBidParams::Clone() const {
  return New(
      mojo::Clone(ad),
      mojo::Clone(bid),
      mojo::Clone(bid_currency)
  );
}

template <typename T, ComponentAuctionModifiedBidParams::EnableIfSame<T>*>
bool ComponentAuctionModifiedBidParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ad, other_struct.ad))
    return false;
  if (!mojo::Equals(this->bid, other_struct.bid))
    return false;
  if (!mojo::Equals(this->bid_currency, other_struct.bid_currency))
    return false;
  return true;
}

template <typename T, ComponentAuctionModifiedBidParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ad < rhs.ad)
    return true;
  if (rhs.ad < lhs.ad)
    return false;
  if (lhs.bid < rhs.bid)
    return true;
  if (rhs.bid < lhs.bid)
    return false;
  if (lhs.bid_currency < rhs.bid_currency)
    return true;
  if (rhs.bid_currency < lhs.bid_currency)
    return false;
  return false;
}
template <typename StructPtrType>
ComponentAuctionReportResultParamsPtr ComponentAuctionReportResultParams::Clone() const {
  return New(
      mojo::Clone(top_level_seller_signals),
      mojo::Clone(modified_bid)
  );
}

template <typename T, ComponentAuctionReportResultParams::EnableIfSame<T>*>
bool ComponentAuctionReportResultParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top_level_seller_signals, other_struct.top_level_seller_signals))
    return false;
  if (!mojo::Equals(this->modified_bid, other_struct.modified_bid))
    return false;
  return true;
}

template <typename T, ComponentAuctionReportResultParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.top_level_seller_signals < rhs.top_level_seller_signals)
    return true;
  if (rhs.top_level_seller_signals < lhs.top_level_seller_signals)
    return false;
  if (lhs.modified_bid < rhs.modified_bid)
    return true;
  if (rhs.modified_bid < lhs.modified_bid)
    return false;
  return false;
}
template <typename StructPtrType>
ScoreAdDependencyLatenciesPtr ScoreAdDependencyLatencies::Clone() const {
  return New(
      mojo::Clone(code_ready_latency),
      mojo::Clone(direct_from_seller_signals_latency),
      mojo::Clone(trusted_scoring_signals_latency),
      mojo::Clone(deps_wait_start_time),
      mojo::Clone(score_ad_start_time),
      mojo::Clone(score_ad_finish_time)
  );
}

template <typename T, ScoreAdDependencyLatencies::EnableIfSame<T>*>
bool ScoreAdDependencyLatencies::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code_ready_latency, other_struct.code_ready_latency))
    return false;
  if (!mojo::Equals(this->direct_from_seller_signals_latency, other_struct.direct_from_seller_signals_latency))
    return false;
  if (!mojo::Equals(this->trusted_scoring_signals_latency, other_struct.trusted_scoring_signals_latency))
    return false;
  if (!mojo::Equals(this->deps_wait_start_time, other_struct.deps_wait_start_time))
    return false;
  if (!mojo::Equals(this->score_ad_start_time, other_struct.score_ad_start_time))
    return false;
  if (!mojo::Equals(this->score_ad_finish_time, other_struct.score_ad_finish_time))
    return false;
  return true;
}

template <typename T, ScoreAdDependencyLatencies::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.code_ready_latency < rhs.code_ready_latency)
    return true;
  if (rhs.code_ready_latency < lhs.code_ready_latency)
    return false;
  if (lhs.direct_from_seller_signals_latency < rhs.direct_from_seller_signals_latency)
    return true;
  if (rhs.direct_from_seller_signals_latency < lhs.direct_from_seller_signals_latency)
    return false;
  if (lhs.trusted_scoring_signals_latency < rhs.trusted_scoring_signals_latency)
    return true;
  if (rhs.trusted_scoring_signals_latency < lhs.trusted_scoring_signals_latency)
    return false;
  if (lhs.deps_wait_start_time < rhs.deps_wait_start_time)
    return true;
  if (rhs.deps_wait_start_time < lhs.deps_wait_start_time)
    return false;
  if (lhs.score_ad_start_time < rhs.score_ad_start_time)
    return true;
  if (rhs.score_ad_start_time < lhs.score_ad_start_time)
    return false;
  if (lhs.score_ad_finish_time < rhs.score_ad_finish_time)
    return true;
  if (rhs.score_ad_finish_time < lhs.score_ad_finish_time)
    return false;
  return false;
}
template <typename StructPtrType>
SellerTimingMetricsPtr SellerTimingMetrics::Clone() const {
  return New(
      mojo::Clone(js_fetch_latency),
      mojo::Clone(script_latency),
      mojo::Clone(script_timed_out)
  );
}

template <typename T, SellerTimingMetrics::EnableIfSame<T>*>
bool SellerTimingMetrics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->js_fetch_latency, other_struct.js_fetch_latency))
    return false;
  if (!mojo::Equals(this->script_latency, other_struct.script_latency))
    return false;
  if (!mojo::Equals(this->script_timed_out, other_struct.script_timed_out))
    return false;
  return true;
}

template <typename T, SellerTimingMetrics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.js_fetch_latency < rhs.js_fetch_latency)
    return true;
  if (rhs.js_fetch_latency < lhs.js_fetch_latency)
    return false;
  if (lhs.script_latency < rhs.script_latency)
    return true;
  if (rhs.script_latency < lhs.script_latency)
    return false;
  if (lhs.script_timed_out < rhs.script_timed_out)
    return true;
  if (rhs.script_timed_out < lhs.script_timed_out)
    return false;
  return false;
}
template <typename StructPtrType>
CreativeInfoWithoutOwnerPtr CreativeInfoWithoutOwner::Clone() const {
  return New(
      mojo::Clone(ad_descriptor),
      mojo::Clone(creative_scanning_metadata)
  );
}

template <typename T, CreativeInfoWithoutOwner::EnableIfSame<T>*>
bool CreativeInfoWithoutOwner::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ad_descriptor, other_struct.ad_descriptor))
    return false;
  if (!mojo::Equals(this->creative_scanning_metadata, other_struct.creative_scanning_metadata))
    return false;
  return true;
}

template <typename T, CreativeInfoWithoutOwner::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ad_descriptor < rhs.ad_descriptor)
    return true;
  if (rhs.ad_descriptor < lhs.ad_descriptor)
    return false;
  if (lhs.creative_scanning_metadata < rhs.creative_scanning_metadata)
    return true;
  if (rhs.creative_scanning_metadata < lhs.creative_scanning_metadata)
    return false;
  return false;
}


}  // auction_worklet::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::ComponentAuctionModifiedBidParams::DataView,
                                         ::auction_worklet::mojom::ComponentAuctionModifiedBidParamsPtr> {
  static bool IsNull(const ::auction_worklet::mojom::ComponentAuctionModifiedBidParamsPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::ComponentAuctionModifiedBidParamsPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::ComponentAuctionModifiedBidParams::ad)& ad(
      const ::auction_worklet::mojom::ComponentAuctionModifiedBidParamsPtr& input) {
    return input->ad;
  }

  static decltype(::auction_worklet::mojom::ComponentAuctionModifiedBidParams::bid) bid(
      const ::auction_worklet::mojom::ComponentAuctionModifiedBidParamsPtr& input) {
    return input->bid;
  }

  static const decltype(::auction_worklet::mojom::ComponentAuctionModifiedBidParams::bid_currency)& bid_currency(
      const ::auction_worklet::mojom::ComponentAuctionModifiedBidParamsPtr& input) {
    return input->bid_currency;
  }

  static bool Read(::auction_worklet::mojom::ComponentAuctionModifiedBidParams::DataView input, ::auction_worklet::mojom::ComponentAuctionModifiedBidParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::ComponentAuctionReportResultParams::DataView,
                                         ::auction_worklet::mojom::ComponentAuctionReportResultParamsPtr> {
  static bool IsNull(const ::auction_worklet::mojom::ComponentAuctionReportResultParamsPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::ComponentAuctionReportResultParamsPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::ComponentAuctionReportResultParams::top_level_seller_signals)& top_level_seller_signals(
      const ::auction_worklet::mojom::ComponentAuctionReportResultParamsPtr& input) {
    return input->top_level_seller_signals;
  }

  static decltype(::auction_worklet::mojom::ComponentAuctionReportResultParams::modified_bid) modified_bid(
      const ::auction_worklet::mojom::ComponentAuctionReportResultParamsPtr& input) {
    return input->modified_bid;
  }

  static bool Read(::auction_worklet::mojom::ComponentAuctionReportResultParams::DataView input, ::auction_worklet::mojom::ComponentAuctionReportResultParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::ScoreAdDependencyLatencies::DataView,
                                         ::auction_worklet::mojom::ScoreAdDependencyLatenciesPtr> {
  static bool IsNull(const ::auction_worklet::mojom::ScoreAdDependencyLatenciesPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::ScoreAdDependencyLatenciesPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::ScoreAdDependencyLatencies::code_ready_latency)& code_ready_latency(
      const ::auction_worklet::mojom::ScoreAdDependencyLatenciesPtr& input) {
    return input->code_ready_latency;
  }

  static const decltype(::auction_worklet::mojom::ScoreAdDependencyLatencies::direct_from_seller_signals_latency)& direct_from_seller_signals_latency(
      const ::auction_worklet::mojom::ScoreAdDependencyLatenciesPtr& input) {
    return input->direct_from_seller_signals_latency;
  }

  static const decltype(::auction_worklet::mojom::ScoreAdDependencyLatencies::trusted_scoring_signals_latency)& trusted_scoring_signals_latency(
      const ::auction_worklet::mojom::ScoreAdDependencyLatenciesPtr& input) {
    return input->trusted_scoring_signals_latency;
  }

  static const decltype(::auction_worklet::mojom::ScoreAdDependencyLatencies::deps_wait_start_time)& deps_wait_start_time(
      const ::auction_worklet::mojom::ScoreAdDependencyLatenciesPtr& input) {
    return input->deps_wait_start_time;
  }

  static const decltype(::auction_worklet::mojom::ScoreAdDependencyLatencies::score_ad_start_time)& score_ad_start_time(
      const ::auction_worklet::mojom::ScoreAdDependencyLatenciesPtr& input) {
    return input->score_ad_start_time;
  }

  static const decltype(::auction_worklet::mojom::ScoreAdDependencyLatencies::score_ad_finish_time)& score_ad_finish_time(
      const ::auction_worklet::mojom::ScoreAdDependencyLatenciesPtr& input) {
    return input->score_ad_finish_time;
  }

  static bool Read(::auction_worklet::mojom::ScoreAdDependencyLatencies::DataView input, ::auction_worklet::mojom::ScoreAdDependencyLatenciesPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::SellerTimingMetrics::DataView,
                                         ::auction_worklet::mojom::SellerTimingMetricsPtr> {
  static bool IsNull(const ::auction_worklet::mojom::SellerTimingMetricsPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::SellerTimingMetricsPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::SellerTimingMetrics::js_fetch_latency)& js_fetch_latency(
      const ::auction_worklet::mojom::SellerTimingMetricsPtr& input) {
    return input->js_fetch_latency;
  }

  static const decltype(::auction_worklet::mojom::SellerTimingMetrics::script_latency)& script_latency(
      const ::auction_worklet::mojom::SellerTimingMetricsPtr& input) {
    return input->script_latency;
  }

  static decltype(::auction_worklet::mojom::SellerTimingMetrics::script_timed_out) script_timed_out(
      const ::auction_worklet::mojom::SellerTimingMetricsPtr& input) {
    return input->script_timed_out;
  }

  static bool Read(::auction_worklet::mojom::SellerTimingMetrics::DataView input, ::auction_worklet::mojom::SellerTimingMetricsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::CreativeInfoWithoutOwner::DataView,
                                         ::auction_worklet::mojom::CreativeInfoWithoutOwnerPtr> {
  static bool IsNull(const ::auction_worklet::mojom::CreativeInfoWithoutOwnerPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::CreativeInfoWithoutOwnerPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::CreativeInfoWithoutOwner::ad_descriptor)& ad_descriptor(
      const ::auction_worklet::mojom::CreativeInfoWithoutOwnerPtr& input) {
    return input->ad_descriptor;
  }

  static const decltype(::auction_worklet::mojom::CreativeInfoWithoutOwner::creative_scanning_metadata)& creative_scanning_metadata(
      const ::auction_worklet::mojom::CreativeInfoWithoutOwnerPtr& input) {
    return input->creative_scanning_metadata;
  }

  static bool Read(::auction_worklet::mojom::CreativeInfoWithoutOwner::DataView input, ::auction_worklet::mojom::CreativeInfoWithoutOwnerPtr* output);
};


template <>
struct CONTENT_EXPORT UnionTraits<::auction_worklet::mojom::ComponentAuctionOtherSeller::DataView,
                                        ::auction_worklet::mojom::ComponentAuctionOtherSellerPtr> {
  static bool IsNull(const ::auction_worklet::mojom::ComponentAuctionOtherSellerPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::ComponentAuctionOtherSellerPtr* output) { output->reset(); }

  static ::auction_worklet::mojom::ComponentAuctionOtherSeller::Tag GetTag(const ::auction_worklet::mojom::ComponentAuctionOtherSellerPtr& input) {
    return input->which();
  }

  static const ::url::Origin& top_level_seller(const ::auction_worklet::mojom::ComponentAuctionOtherSellerPtr& input) {
    return input->get_top_level_seller();
  }

  static const ::url::Origin& component_seller(const ::auction_worklet::mojom::ComponentAuctionOtherSellerPtr& input) {
    return input->get_component_seller();
  }

  static bool Read(::auction_worklet::mojom::ComponentAuctionOtherSeller::DataView input, ::auction_worklet::mojom::ComponentAuctionOtherSellerPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_H_