// content/services/auction_worklet/public/mojom/in_progress_auction_download.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_IN_PROGRESS_AUCTION_DOWNLOAD_MOJOM_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_IN_PROGRESS_AUCTION_DOWNLOAD_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/in_progress_auction_download.mojom-features.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/in_progress_auction_download.mojom-shared.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/in_progress_auction_download.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_loader.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace auction_worklet::mojom {








class CONTENT_EXPORT InProgressAuctionDownload {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InProgressAuctionDownload, T>::value>;
  using DataView = InProgressAuctionDownloadDataView;
  using Data_ = internal::InProgressAuctionDownload_Data;

  template <typename... Args>
  static InProgressAuctionDownloadPtr New(Args&&... args) {
    return InProgressAuctionDownloadPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InProgressAuctionDownloadPtr From(const U& u) {
    return mojo::TypeConverter<InProgressAuctionDownloadPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InProgressAuctionDownload>::Convert(*this);
  }


  InProgressAuctionDownload();

  InProgressAuctionDownload(
      const ::GURL& url,
      ::network::mojom::URLLoaderClientEndpointsPtr endpoints,
      const std::string& devtools_request_id);

InProgressAuctionDownload(const InProgressAuctionDownload&) = delete;
InProgressAuctionDownload& operator=(const InProgressAuctionDownload&) = delete;

  ~InProgressAuctionDownload();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InProgressAuctionDownloadPtr>
  InProgressAuctionDownloadPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InProgressAuctionDownload::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InProgressAuctionDownload::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InProgressAuctionDownload::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InProgressAuctionDownload::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InProgressAuctionDownload_UnserializedMessageContext<
            UserType, InProgressAuctionDownload::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InProgressAuctionDownload::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InProgressAuctionDownload::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InProgressAuctionDownload_UnserializedMessageContext<
            UserType, InProgressAuctionDownload::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InProgressAuctionDownload::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  ::network::mojom::URLLoaderClientEndpointsPtr endpoints;
  
  std::string devtools_request_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InProgressAuctionDownload::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InProgressAuctionDownload::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InProgressAuctionDownload::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InProgressAuctionDownload::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
InProgressAuctionDownloadPtr InProgressAuctionDownload::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(endpoints),
      mojo::Clone(devtools_request_id)
  );
}

template <typename T, InProgressAuctionDownload::EnableIfSame<T>*>
bool InProgressAuctionDownload::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->endpoints, other_struct.endpoints))
    return false;
  if (!mojo::Equals(this->devtools_request_id, other_struct.devtools_request_id))
    return false;
  return true;
}

template <typename T, InProgressAuctionDownload::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.endpoints < rhs.endpoints)
    return true;
  if (rhs.endpoints < lhs.endpoints)
    return false;
  if (lhs.devtools_request_id < rhs.devtools_request_id)
    return true;
  if (rhs.devtools_request_id < lhs.devtools_request_id)
    return false;
  return false;
}


}  // auction_worklet::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::InProgressAuctionDownload::DataView,
                                         ::auction_worklet::mojom::InProgressAuctionDownloadPtr> {
  static bool IsNull(const ::auction_worklet::mojom::InProgressAuctionDownloadPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::InProgressAuctionDownloadPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::InProgressAuctionDownload::url)& url(
      const ::auction_worklet::mojom::InProgressAuctionDownloadPtr& input) {
    return input->url;
  }

  static  decltype(::auction_worklet::mojom::InProgressAuctionDownload::endpoints)& endpoints(
       ::auction_worklet::mojom::InProgressAuctionDownloadPtr& input) {
    return input->endpoints;
  }

  static const decltype(::auction_worklet::mojom::InProgressAuctionDownload::devtools_request_id)& devtools_request_id(
      const ::auction_worklet::mojom::InProgressAuctionDownloadPtr& input) {
    return input->devtools_request_id;
  }

  static bool Read(::auction_worklet::mojom::InProgressAuctionDownload::DataView input, ::auction_worklet::mojom::InProgressAuctionDownloadPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_IN_PROGRESS_AUCTION_DOWNLOAD_MOJOM_H_