// content/services/auction_worklet/public/mojom/bidder_worklet.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-params-data.h"
#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared-message-ids.h"

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-import-headers.h"
#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-test-utils.h"


namespace auction_worklet::mojom {
KAnonKey::KAnonKey()
    : data() {}

KAnonKey::KAnonKey(
    const std::string& data_in)
    : data(std::move(data_in)) {}

KAnonKey::~KAnonKey() = default;
size_t KAnonKey::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->data);
  return seed;
}

void KAnonKey::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool KAnonKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BidderWorkletNonSharedParams::BidderWorkletNonSharedParams()
    : name(),
      trusted_bidding_signals_slot_size_mode(),
      enable_bidding_signals_prioritization(),
      priority_vector(),
      execution_mode(),
      update_url(),
      trusted_bidding_signals_keys(),
      max_trusted_bidding_signals_url_length(),
      user_bidding_signals(),
      ads(),
      ad_components(),
      kanon_keys() {}

BidderWorkletNonSharedParams::BidderWorkletNonSharedParams(
    const std::string& name_in,
    ::blink::mojom::InterestGroup::TrustedBiddingSignalsSlotSizeMode trusted_bidding_signals_slot_size_mode_in,
    bool enable_bidding_signals_prioritization_in,
    const std::optional<base::flat_map<std::string, double>>& priority_vector_in,
    ::blink::mojom::InterestGroup::ExecutionMode execution_mode_in,
    const std::optional<::GURL>& update_url_in,
    std::optional<std::vector<std::string>> trusted_bidding_signals_keys_in,
    int32_t max_trusted_bidding_signals_url_length_in,
    const std::optional<std::string>& user_bidding_signals_in,
    std::optional<std::vector<::blink::InterestGroup::Ad>> ads_in,
    std::optional<std::vector<::blink::InterestGroup::Ad>> ad_components_in,
    std::vector<KAnonKeyPtr> kanon_keys_in)
    : name(std::move(name_in)),
      trusted_bidding_signals_slot_size_mode(std::move(trusted_bidding_signals_slot_size_mode_in)),
      enable_bidding_signals_prioritization(std::move(enable_bidding_signals_prioritization_in)),
      priority_vector(std::move(priority_vector_in)),
      execution_mode(std::move(execution_mode_in)),
      update_url(std::move(update_url_in)),
      trusted_bidding_signals_keys(std::move(trusted_bidding_signals_keys_in)),
      max_trusted_bidding_signals_url_length(std::move(max_trusted_bidding_signals_url_length_in)),
      user_bidding_signals(std::move(user_bidding_signals_in)),
      ads(std::move(ads_in)),
      ad_components(std::move(ad_components_in)),
      kanon_keys(std::move(kanon_keys_in)) {}

BidderWorkletNonSharedParams::~BidderWorkletNonSharedParams() = default;

void BidderWorkletNonSharedParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_bidding_signals_slot_size_mode"), this->trusted_bidding_signals_slot_size_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::InterestGroup::TrustedBiddingSignalsSlotSizeMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_bidding_signals_prioritization"), this->enable_bidding_signals_prioritization,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority_vector"), this->priority_vector,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<std::string, double>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "execution_mode"), this->execution_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::InterestGroup::ExecutionMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_url"), this->update_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_bidding_signals_keys"), this->trusted_bidding_signals_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_trusted_bidding_signals_url_length"), this->max_trusted_bidding_signals_url_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_bidding_signals"), this->user_bidding_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ads"), this->ads,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::blink::InterestGroup::Ad>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad_components"), this->ad_components,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::blink::InterestGroup::Ad>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "kanon_keys"), this->kanon_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<KAnonKeyPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BidderWorkletNonSharedParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BidderWorkletBid::BidderWorkletBid()
    : bid_role(),
      ad(),
      bid(),
      bid_currency(),
      ad_cost(),
      ad_descriptor(),
      selected_buyer_and_seller_reporting_id(),
      ad_component_descriptors(),
      modeling_signals(),
      aggregate_win_signals(),
      bid_duration() {}

BidderWorkletBid::BidderWorkletBid(
    BidRole bid_role_in,
    const std::string& ad_in,
    double bid_in,
    const std::optional<::blink::AdCurrency>& bid_currency_in,
    std::optional<double> ad_cost_in,
    const ::blink::AdDescriptor& ad_descriptor_in,
    const std::optional<std::string>& selected_buyer_and_seller_reporting_id_in,
    std::optional<std::vector<::blink::AdDescriptor>> ad_component_descriptors_in,
    std::optional<uint16_t> modeling_signals_in,
    const std::optional<std::string>& aggregate_win_signals_in,
    ::base::TimeDelta bid_duration_in)
    : bid_role(std::move(bid_role_in)),
      ad(std::move(ad_in)),
      bid(std::move(bid_in)),
      bid_currency(std::move(bid_currency_in)),
      ad_cost(std::move(ad_cost_in)),
      ad_descriptor(std::move(ad_descriptor_in)),
      selected_buyer_and_seller_reporting_id(std::move(selected_buyer_and_seller_reporting_id_in)),
      ad_component_descriptors(std::move(ad_component_descriptors_in)),
      modeling_signals(std::move(modeling_signals_in)),
      aggregate_win_signals(std::move(aggregate_win_signals_in)),
      bid_duration(std::move(bid_duration_in)) {}

BidderWorkletBid::~BidderWorkletBid() = default;

void BidderWorkletBid::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bid_role"), this->bid_role,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BidRole>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad"), this->ad,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bid"), this->bid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bid_currency"), this->bid_currency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::AdCurrency>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad_cost"), this->ad_cost,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<double>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad_descriptor"), this->ad_descriptor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::AdDescriptor&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_buyer_and_seller_reporting_id"), this->selected_buyer_and_seller_reporting_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad_component_descriptors"), this->ad_component_descriptors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::blink::AdDescriptor>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modeling_signals"), this->modeling_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint16_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregate_win_signals"), this->aggregate_win_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bid_duration"), this->bid_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BidderWorkletBid::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrioritySignalsDouble::PrioritySignalsDouble()
    : value() {}

PrioritySignalsDouble::PrioritySignalsDouble(
    double value_in)
    : value(std::move(value_in)) {}

PrioritySignalsDouble::~PrioritySignalsDouble() = default;
size_t PrioritySignalsDouble::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void PrioritySignalsDouble::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrioritySignalsDouble::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GenerateBidDependencyLatencies::GenerateBidDependencyLatencies()
    : code_ready_latency(),
      config_promises_latency(),
      direct_from_seller_signals_latency(),
      trusted_bidding_signals_latency(),
      deps_wait_start_time(),
      generate_bid_start_time(),
      generate_bid_finish_time() {}

GenerateBidDependencyLatencies::GenerateBidDependencyLatencies(
    std::optional<::base::TimeDelta> code_ready_latency_in,
    std::optional<::base::TimeDelta> config_promises_latency_in,
    std::optional<::base::TimeDelta> direct_from_seller_signals_latency_in,
    std::optional<::base::TimeDelta> trusted_bidding_signals_latency_in,
    ::base::TimeTicks deps_wait_start_time_in,
    ::base::TimeTicks generate_bid_start_time_in,
    ::base::TimeTicks generate_bid_finish_time_in)
    : code_ready_latency(std::move(code_ready_latency_in)),
      config_promises_latency(std::move(config_promises_latency_in)),
      direct_from_seller_signals_latency(std::move(direct_from_seller_signals_latency_in)),
      trusted_bidding_signals_latency(std::move(trusted_bidding_signals_latency_in)),
      deps_wait_start_time(std::move(deps_wait_start_time_in)),
      generate_bid_start_time(std::move(generate_bid_start_time_in)),
      generate_bid_finish_time(std::move(generate_bid_finish_time_in)) {}

GenerateBidDependencyLatencies::~GenerateBidDependencyLatencies() = default;

void GenerateBidDependencyLatencies::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code_ready_latency"), this->code_ready_latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "config_promises_latency"), this->config_promises_latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direct_from_seller_signals_latency"), this->direct_from_seller_signals_latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_bidding_signals_latency"), this->trusted_bidding_signals_latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deps_wait_start_time"), this->deps_wait_start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "generate_bid_start_time"), this->generate_bid_start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "generate_bid_finish_time"), this->generate_bid_finish_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GenerateBidDependencyLatencies::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BidderTimingMetrics::BidderTimingMetrics()
    : js_fetch_latency(),
      wasm_fetch_latency(),
      script_latency(),
      script_timed_out() {}

BidderTimingMetrics::BidderTimingMetrics(
    std::optional<::base::TimeDelta> js_fetch_latency_in,
    std::optional<::base::TimeDelta> wasm_fetch_latency_in,
    ::base::TimeDelta script_latency_in,
    bool script_timed_out_in)
    : js_fetch_latency(std::move(js_fetch_latency_in)),
      wasm_fetch_latency(std::move(wasm_fetch_latency_in)),
      script_latency(std::move(script_latency_in)),
      script_timed_out(std::move(script_timed_out_in)) {}

BidderTimingMetrics::~BidderTimingMetrics() = default;

void BidderTimingMetrics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "js_fetch_latency"), this->js_fetch_latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wasm_fetch_latency"), this->wasm_fetch_latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_latency"), this->script_latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_timed_out"), this->script_timed_out,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BidderTimingMetrics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrivateModelTrainingRequestData::PrivateModelTrainingRequestData()
    : payload(),
      payload_length(),
      aggregation_coordinator_origin(),
      destination() {}

PrivateModelTrainingRequestData::PrivateModelTrainingRequestData(
    ::mojo_base::BigBuffer payload_in,
    uint32_t payload_length_in,
    const ::GURL& aggregation_coordinator_origin_in,
    const ::GURL& destination_in)
    : payload(std::move(payload_in)),
      payload_length(std::move(payload_length_in)),
      aggregation_coordinator_origin(std::move(aggregation_coordinator_origin_in)),
      destination(std::move(destination_in)) {}

PrivateModelTrainingRequestData::~PrivateModelTrainingRequestData() = default;

void PrivateModelTrainingRequestData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payload"), this->payload,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::BigBuffer>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payload_length"), this->payload_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregation_coordinator_origin"), this->aggregation_coordinator_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destination"), this->destination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrivateModelTrainingRequestData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

GenerateBidClient::IPCStableHashFunction GenerateBidClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GenerateBidClient>(message.name())) {
    case messages::GenerateBidClient::kOnBiddingSignalsReceived: {
      return &GenerateBidClient::OnBiddingSignalsReceived_Sym::IPCStableHash;
    }
    case messages::GenerateBidClient::kOnGenerateBidComplete: {
      return &GenerateBidClient::OnGenerateBidComplete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GenerateBidClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GenerateBidClient>(message.name())) {
      case messages::GenerateBidClient::kOnBiddingSignalsReceived:
            return "Receive auction_worklet::mojom::GenerateBidClient::OnBiddingSignalsReceived";
      case messages::GenerateBidClient::kOnGenerateBidComplete:
            return "Receive auction_worklet::mojom::GenerateBidClient::OnGenerateBidComplete";
    }
  } else {
    switch (static_cast<messages::GenerateBidClient>(message.name())) {
      case messages::GenerateBidClient::kOnBiddingSignalsReceived:
            return "Receive reply auction_worklet::mojom::GenerateBidClient::OnBiddingSignalsReceived";
      case messages::GenerateBidClient::kOnGenerateBidComplete:
            return "Receive reply auction_worklet::mojom::GenerateBidClient::OnGenerateBidComplete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GenerateBidClient::OnBiddingSignalsReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd2ee4a73;  // IPCStableHash for auction_worklet::mojom::GenerateBidClient::OnBiddingSignalsReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GenerateBidClient::OnGenerateBidComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8c703ef1;  // IPCStableHash for auction_worklet::mojom::GenerateBidClient::OnGenerateBidComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class GenerateBidClient_OnBiddingSignalsReceived_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GenerateBidClient_OnBiddingSignalsReceived_ForwardToCallback(
      GenerateBidClient::OnBiddingSignalsReceivedCallback callback
      ) : callback_(std::move(callback)) {
  }

  GenerateBidClient_OnBiddingSignalsReceived_ForwardToCallback(const GenerateBidClient_OnBiddingSignalsReceived_ForwardToCallback&) = delete;
  GenerateBidClient_OnBiddingSignalsReceived_ForwardToCallback& operator=(const GenerateBidClient_OnBiddingSignalsReceived_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GenerateBidClient::OnBiddingSignalsReceivedCallback callback_;
};

GenerateBidClientProxy::GenerateBidClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GenerateBidClientProxy::OnBiddingSignalsReceived(
    const base::flat_map<std::string, double>& in_priority_vector, ::base::TimeDelta in_trusted_signals_fetch_latency, std::optional<::base::TimeDelta> in_update_if_older_than, OnBiddingSignalsReceivedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::GenerateBidClient::OnBiddingSignalsReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority_vector"), in_priority_vector,
                        "<value of type const base::flat_map<std::string, double>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trusted_signals_fetch_latency"), in_trusted_signals_fetch_latency,
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_if_older_than"), in_update_if_older_than,
                        "<value of type std::optional<::base::TimeDelta>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GenerateBidClient::kOnBiddingSignalsReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::GenerateBidClient_OnBiddingSignalsReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->priority_vector)::BaseType>
      priority_vector_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& priority_vector_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, double>>(
    in_priority_vector,
    priority_vector_fragment,
    &priority_vector_validate_params);

  params->priority_vector.Set(
      priority_vector_fragment.is_null() ? nullptr : priority_vector_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->priority_vector.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null priority_vector in GenerateBidClient.OnBiddingSignalsReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->trusted_signals_fetch_latency)::BaseType> trusted_signals_fetch_latency_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_trusted_signals_fetch_latency,
    trusted_signals_fetch_latency_fragment);

  params->trusted_signals_fetch_latency.Set(
      trusted_signals_fetch_latency_fragment.is_null() ? nullptr : trusted_signals_fetch_latency_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->trusted_signals_fetch_latency.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null trusted_signals_fetch_latency in GenerateBidClient.OnBiddingSignalsReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->update_if_older_than)::BaseType> update_if_older_than_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_update_if_older_than,
    update_if_older_than_fragment);

  params->update_if_older_than.Set(
      update_if_older_than_fragment.is_null() ? nullptr : update_if_older_than_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GenerateBidClient::Name_);
  message.set_method_name("OnBiddingSignalsReceived");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GenerateBidClient_OnBiddingSignalsReceived_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GenerateBidClientProxy::OnGenerateBidComplete(
    std::vector<BidderWorkletBidPtr> in_bids, std::optional<uint32_t> in_bidding_signals_data_version, const std::optional<::GURL>& in_debug_loss_report_url, const std::optional<::GURL>& in_debug_win_report_url, std::optional<double> in_set_priority, base::flat_map<std::string, PrioritySignalsDoublePtr> in_update_priority_signals_overrides, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> in_pa_requests, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> in_non_kanon_pa_requests, std::vector<::auction_worklet::mojom::RealTimeReportingContributionPtr> in_real_time_contributions, BidderTimingMetricsPtr in_generate_bid_timing_metrics, GenerateBidDependencyLatenciesPtr in_generate_bid_dependency_latencies, ::auction_worklet::mojom::RejectReason in_reject_reason, const std::vector<std::string>& in_errors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::GenerateBidClient::OnGenerateBidComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bids"), in_bids,
                        "<value of type std::vector<BidderWorkletBidPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bidding_signals_data_version"), in_bidding_signals_data_version,
                        "<value of type std::optional<uint32_t>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("debug_loss_report_url"), in_debug_loss_report_url,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("debug_win_report_url"), in_debug_win_report_url,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set_priority"), in_set_priority,
                        "<value of type std::optional<double>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_priority_signals_overrides"), in_update_priority_signals_overrides,
                        "<value of type base::flat_map<std::string, PrioritySignalsDoublePtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pa_requests"), in_pa_requests,
                        "<value of type std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("non_kanon_pa_requests"), in_non_kanon_pa_requests,
                        "<value of type std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("real_time_contributions"), in_real_time_contributions,
                        "<value of type std::vector<::auction_worklet::mojom::RealTimeReportingContributionPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("generate_bid_timing_metrics"), in_generate_bid_timing_metrics,
                        "<value of type BidderTimingMetricsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("generate_bid_dependency_latencies"), in_generate_bid_dependency_latencies,
                        "<value of type GenerateBidDependencyLatenciesPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reject_reason"), in_reject_reason,
                        "<value of type ::auction_worklet::mojom::RejectReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("errors"), in_errors,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GenerateBidClient::kOnGenerateBidComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::GenerateBidClient_OnGenerateBidComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bids)::BaseType>
      bids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::auction_worklet::mojom::BidderWorkletBidDataView>>(
    in_bids,
    bids_fragment,
    &bids_validate_params);

  params->bids.Set(
      bids_fragment.is_null() ? nullptr : bids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bids in GenerateBidClient.OnGenerateBidComplete request");
  params->bidding_signals_data_version_$flag = in_bidding_signals_data_version.has_value();
  if (in_bidding_signals_data_version.has_value()) {
    params->bidding_signals_data_version_$value = in_bidding_signals_data_version.value();
  }
  mojo::internal::MessageFragment<
      typename decltype(params->debug_loss_report_url)::BaseType> debug_loss_report_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_debug_loss_report_url,
    debug_loss_report_url_fragment);

  params->debug_loss_report_url.Set(
      debug_loss_report_url_fragment.is_null() ? nullptr : debug_loss_report_url_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->debug_win_report_url)::BaseType> debug_win_report_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_debug_win_report_url,
    debug_win_report_url_fragment);

  params->debug_win_report_url.Set(
      debug_win_report_url_fragment.is_null() ? nullptr : debug_win_report_url_fragment.data());
  params->set_priority_$flag = in_set_priority.has_value();
  if (in_set_priority.has_value()) {
    params->set_priority_$value = in_set_priority.value();
  }
  mojo::internal::MessageFragment<
      typename decltype(params->update_priority_signals_overrides)::BaseType>
      update_priority_signals_overrides_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& update_priority_signals_overrides_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, true, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::auction_worklet::mojom::PrioritySignalsDoubleDataView>>(
    in_update_priority_signals_overrides,
    update_priority_signals_overrides_fragment,
    &update_priority_signals_overrides_validate_params);

  params->update_priority_signals_overrides.Set(
      update_priority_signals_overrides_fragment.is_null() ? nullptr : update_priority_signals_overrides_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->update_priority_signals_overrides.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null update_priority_signals_overrides in GenerateBidClient.OnGenerateBidComplete request");
  mojo::internal::MessageFragment<
      typename decltype(params->pa_requests)::BaseType>
      pa_requests_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& pa_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>>(
    in_pa_requests,
    pa_requests_fragment,
    &pa_requests_validate_params);

  params->pa_requests.Set(
      pa_requests_fragment.is_null() ? nullptr : pa_requests_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pa_requests.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pa_requests in GenerateBidClient.OnGenerateBidComplete request");
  mojo::internal::MessageFragment<
      typename decltype(params->non_kanon_pa_requests)::BaseType>
      non_kanon_pa_requests_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& non_kanon_pa_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>>(
    in_non_kanon_pa_requests,
    non_kanon_pa_requests_fragment,
    &non_kanon_pa_requests_validate_params);

  params->non_kanon_pa_requests.Set(
      non_kanon_pa_requests_fragment.is_null() ? nullptr : non_kanon_pa_requests_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->non_kanon_pa_requests.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null non_kanon_pa_requests in GenerateBidClient.OnGenerateBidComplete request");
  mojo::internal::MessageFragment<
      typename decltype(params->real_time_contributions)::BaseType>
      real_time_contributions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& real_time_contributions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::auction_worklet::mojom::RealTimeReportingContributionDataView>>(
    in_real_time_contributions,
    real_time_contributions_fragment,
    &real_time_contributions_validate_params);

  params->real_time_contributions.Set(
      real_time_contributions_fragment.is_null() ? nullptr : real_time_contributions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->real_time_contributions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null real_time_contributions in GenerateBidClient.OnGenerateBidComplete request");
  mojo::internal::MessageFragment<
      typename decltype(params->generate_bid_timing_metrics)::BaseType> generate_bid_timing_metrics_fragment(
          params.message());
  
  mojo::internal::Serialize<::auction_worklet::mojom::BidderTimingMetricsDataView>(
    in_generate_bid_timing_metrics,
    generate_bid_timing_metrics_fragment);

  params->generate_bid_timing_metrics.Set(
      generate_bid_timing_metrics_fragment.is_null() ? nullptr : generate_bid_timing_metrics_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->generate_bid_timing_metrics.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null generate_bid_timing_metrics in GenerateBidClient.OnGenerateBidComplete request");
  mojo::internal::MessageFragment<
      typename decltype(params->generate_bid_dependency_latencies)::BaseType> generate_bid_dependency_latencies_fragment(
          params.message());
  
  mojo::internal::Serialize<::auction_worklet::mojom::GenerateBidDependencyLatenciesDataView>(
    in_generate_bid_dependency_latencies,
    generate_bid_dependency_latencies_fragment);

  params->generate_bid_dependency_latencies.Set(
      generate_bid_dependency_latencies_fragment.is_null() ? nullptr : generate_bid_dependency_latencies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->generate_bid_dependency_latencies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null generate_bid_dependency_latencies in GenerateBidClient.OnGenerateBidComplete request");

  
  mojo::internal::Serialize<::auction_worklet::mojom::RejectReason>(
    in_reject_reason,
    &params->reject_reason);
  mojo::internal::MessageFragment<
      typename decltype(params->errors)::BaseType>
      errors_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& errors_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_errors,
    errors_fragment,
    &errors_validate_params);

  params->errors.Set(
      errors_fragment.is_null() ? nullptr : errors_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->errors.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null errors in GenerateBidClient.OnGenerateBidComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GenerateBidClient::Name_);
  message.set_method_name("OnGenerateBidComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class GenerateBidClient_OnBiddingSignalsReceived_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GenerateBidClient::OnBiddingSignalsReceivedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GenerateBidClient_OnBiddingSignalsReceived_ProxyToResponder> proxy(
        new GenerateBidClient_OnBiddingSignalsReceived_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GenerateBidClient_OnBiddingSignalsReceived_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GenerateBidClient_OnBiddingSignalsReceived_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GenerateBidClient_OnBiddingSignalsReceived_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GenerateBidClient::OnBiddingSignalsReceivedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool GenerateBidClient_OnBiddingSignalsReceived_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GenerateBidClient.0
  bool success = true;
  GenerateBidClient_OnBiddingSignalsReceived_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GenerateBidClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void GenerateBidClient_OnBiddingSignalsReceived_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply auction_worklet::mojom::GenerateBidClient::OnBiddingSignalsReceived");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GenerateBidClient::kOnBiddingSignalsReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GenerateBidClient::Name_);
  message.set_method_name("OnBiddingSignalsReceived");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GenerateBidClientStubDispatch::Accept(
    GenerateBidClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GenerateBidClient>(message->header()->name)) {
    case messages::GenerateBidClient::kOnBiddingSignalsReceived: {
      break;
    }
    case messages::GenerateBidClient::kOnGenerateBidComplete: {
      DCHECK(message->is_serialized());
      internal::GenerateBidClient_OnGenerateBidComplete_Params_Data* params =
          reinterpret_cast<internal::GenerateBidClient_OnGenerateBidComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GenerateBidClient.1
      bool success = true;
      std::vector<BidderWorkletBidPtr> p_bids{};
      std::optional<uint32_t> p_bidding_signals_data_version{};
      std::optional<::GURL> p_debug_loss_report_url{};
      std::optional<::GURL> p_debug_win_report_url{};
      std::optional<double> p_set_priority{};
      base::flat_map<std::string, PrioritySignalsDoublePtr> p_update_priority_signals_overrides{};
      std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> p_pa_requests{};
      std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> p_non_kanon_pa_requests{};
      std::vector<::auction_worklet::mojom::RealTimeReportingContributionPtr> p_real_time_contributions{};
      BidderTimingMetricsPtr p_generate_bid_timing_metrics{};
      GenerateBidDependencyLatenciesPtr p_generate_bid_dependency_latencies{};
      ::auction_worklet::mojom::RejectReason p_reject_reason{};
      std::vector<std::string> p_errors{};
      GenerateBidClient_OnGenerateBidComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBids(&p_bids))
        success = false;
      if (success) {
        p_bidding_signals_data_version = input_data_view.bidding_signals_data_version();
      }
      if (success && !input_data_view.ReadDebugLossReportUrl(&p_debug_loss_report_url))
        success = false;
      if (success && !input_data_view.ReadDebugWinReportUrl(&p_debug_win_report_url))
        success = false;
      if (success) {
        p_set_priority = input_data_view.set_priority();
      }
      if (success && !input_data_view.ReadUpdatePrioritySignalsOverrides(&p_update_priority_signals_overrides))
        success = false;
      if (success && !input_data_view.ReadPaRequests(&p_pa_requests))
        success = false;
      if (success && !input_data_view.ReadNonKanonPaRequests(&p_non_kanon_pa_requests))
        success = false;
      if (success && !input_data_view.ReadRealTimeContributions(&p_real_time_contributions))
        success = false;
      if (success && !input_data_view.ReadGenerateBidTimingMetrics(&p_generate_bid_timing_metrics))
        success = false;
      if (success && !input_data_view.ReadGenerateBidDependencyLatencies(&p_generate_bid_dependency_latencies))
        success = false;
      if (success && !input_data_view.ReadRejectReason(&p_reject_reason))
        success = false;
      if (success && !input_data_view.ReadErrors(&p_errors))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GenerateBidClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnGenerateBidComplete(        
        std::move(p_bids), 
        std::move(p_bidding_signals_data_version), 
        std::move(p_debug_loss_report_url), 
        std::move(p_debug_win_report_url), 
        std::move(p_set_priority), 
        std::move(p_update_priority_signals_overrides), 
        std::move(p_pa_requests), 
        std::move(p_non_kanon_pa_requests), 
        std::move(p_real_time_contributions), 
        std::move(p_generate_bid_timing_metrics), 
        std::move(p_generate_bid_dependency_latencies), 
        std::move(p_reject_reason), 
        std::move(p_errors));
      return true;
    }
  }
  return false;
}

// static
bool GenerateBidClientStubDispatch::AcceptWithResponder(
    GenerateBidClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GenerateBidClient>(message->header()->name)) {
    case messages::GenerateBidClient::kOnBiddingSignalsReceived: {
      internal::GenerateBidClient_OnBiddingSignalsReceived_Params_Data* params =
          reinterpret_cast<
              internal::GenerateBidClient_OnBiddingSignalsReceived_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GenerateBidClient.0
      bool success = true;
      base::flat_map<std::string, double> p_priority_vector{};
      ::base::TimeDelta p_trusted_signals_fetch_latency{};
      std::optional<::base::TimeDelta> p_update_if_older_than{};
      GenerateBidClient_OnBiddingSignalsReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPriorityVector(&p_priority_vector))
        success = false;
      if (success && !input_data_view.ReadTrustedSignalsFetchLatency(&p_trusted_signals_fetch_latency))
        success = false;
      if (success && !input_data_view.ReadUpdateIfOlderThan(&p_update_if_older_than))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GenerateBidClient::Name_, 0, false);
        return false;
      }
      auto callback =
          GenerateBidClient_OnBiddingSignalsReceived_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBiddingSignalsReceived(        
        std::move(p_priority_vector), 
        std::move(p_trusted_signals_fetch_latency), 
        std::move(p_update_if_older_than), std::move(callback));
      return true;
    }
    case messages::GenerateBidClient::kOnGenerateBidComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kGenerateBidClientValidationInfo[] = {
    { &internal::GenerateBidClient_OnBiddingSignalsReceived_Params_Data::Validate,
     &internal::GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data::Validate},
    { &internal::GenerateBidClient_OnGenerateBidComplete_Params_Data::Validate,
     nullptr /* no response */},
};

bool GenerateBidClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::auction_worklet::mojom::GenerateBidClient::Name_,
    kGenerateBidClientValidationInfo);
}

bool GenerateBidClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::auction_worklet::mojom::GenerateBidClient::Name_,
    kGenerateBidClientValidationInfo);
}
// The declaration includes the definition on other builds.

GenerateBidFinalizer::IPCStableHashFunction GenerateBidFinalizer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GenerateBidFinalizer>(message.name())) {
    case messages::GenerateBidFinalizer::kFinishGenerateBid: {
      return &GenerateBidFinalizer::FinishGenerateBid_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GenerateBidFinalizer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GenerateBidFinalizer>(message.name())) {
      case messages::GenerateBidFinalizer::kFinishGenerateBid:
            return "Receive auction_worklet::mojom::GenerateBidFinalizer::FinishGenerateBid";
    }
  } else {
    switch (static_cast<messages::GenerateBidFinalizer>(message.name())) {
      case messages::GenerateBidFinalizer::kFinishGenerateBid:
            return "Receive reply auction_worklet::mojom::GenerateBidFinalizer::FinishGenerateBid";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GenerateBidFinalizer::FinishGenerateBid_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3b8815b5;  // IPCStableHash for auction_worklet::mojom::GenerateBidFinalizer::FinishGenerateBid
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

GenerateBidFinalizerProxy::GenerateBidFinalizerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GenerateBidFinalizerProxy::FinishGenerateBid(
    const std::optional<std::string>& in_auction_signals_json, const std::optional<std::string>& in_per_buyer_signals_json, std::optional<::base::TimeDelta> in_per_buyer_timeout, const std::optional<::blink::AdCurrency>& in_expected_buyer_currency, const std::optional<::GURL>& in_direct_from_seller_per_buyer_signals, const std::optional<std::string>& in_direct_from_seller_per_buyer_signals_header_ad_slot, const std::optional<::GURL>& in_direct_from_seller_auction_signals, const std::optional<std::string>& in_direct_from_seller_auction_signals_header_ad_slot) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::GenerateBidFinalizer::FinishGenerateBid", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction_signals_json"), in_auction_signals_json,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("per_buyer_signals_json"), in_per_buyer_signals_json,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("per_buyer_timeout"), in_per_buyer_timeout,
                        "<value of type std::optional<::base::TimeDelta>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expected_buyer_currency"), in_expected_buyer_currency,
                        "<value of type const std::optional<::blink::AdCurrency>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_per_buyer_signals"), in_direct_from_seller_per_buyer_signals,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_per_buyer_signals_header_ad_slot"), in_direct_from_seller_per_buyer_signals_header_ad_slot,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_auction_signals"), in_direct_from_seller_auction_signals,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_auction_signals_header_ad_slot"), in_direct_from_seller_auction_signals_header_ad_slot,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GenerateBidFinalizer::kFinishGenerateBid), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::GenerateBidFinalizer_FinishGenerateBid_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->auction_signals_json)::BaseType> auction_signals_json_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_auction_signals_json,
    auction_signals_json_fragment);

  params->auction_signals_json.Set(
      auction_signals_json_fragment.is_null() ? nullptr : auction_signals_json_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->per_buyer_signals_json)::BaseType> per_buyer_signals_json_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_per_buyer_signals_json,
    per_buyer_signals_json_fragment);

  params->per_buyer_signals_json.Set(
      per_buyer_signals_json_fragment.is_null() ? nullptr : per_buyer_signals_json_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->per_buyer_timeout)::BaseType> per_buyer_timeout_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_per_buyer_timeout,
    per_buyer_timeout_fragment);

  params->per_buyer_timeout.Set(
      per_buyer_timeout_fragment.is_null() ? nullptr : per_buyer_timeout_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->expected_buyer_currency)::BaseType> expected_buyer_currency_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AdCurrencyDataView>(
    in_expected_buyer_currency,
    expected_buyer_currency_fragment);

  params->expected_buyer_currency.Set(
      expected_buyer_currency_fragment.is_null() ? nullptr : expected_buyer_currency_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_per_buyer_signals)::BaseType> direct_from_seller_per_buyer_signals_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_direct_from_seller_per_buyer_signals,
    direct_from_seller_per_buyer_signals_fragment);

  params->direct_from_seller_per_buyer_signals.Set(
      direct_from_seller_per_buyer_signals_fragment.is_null() ? nullptr : direct_from_seller_per_buyer_signals_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_per_buyer_signals_header_ad_slot)::BaseType> direct_from_seller_per_buyer_signals_header_ad_slot_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_direct_from_seller_per_buyer_signals_header_ad_slot,
    direct_from_seller_per_buyer_signals_header_ad_slot_fragment);

  params->direct_from_seller_per_buyer_signals_header_ad_slot.Set(
      direct_from_seller_per_buyer_signals_header_ad_slot_fragment.is_null() ? nullptr : direct_from_seller_per_buyer_signals_header_ad_slot_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_auction_signals)::BaseType> direct_from_seller_auction_signals_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_direct_from_seller_auction_signals,
    direct_from_seller_auction_signals_fragment);

  params->direct_from_seller_auction_signals.Set(
      direct_from_seller_auction_signals_fragment.is_null() ? nullptr : direct_from_seller_auction_signals_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_auction_signals_header_ad_slot)::BaseType> direct_from_seller_auction_signals_header_ad_slot_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_direct_from_seller_auction_signals_header_ad_slot,
    direct_from_seller_auction_signals_header_ad_slot_fragment);

  params->direct_from_seller_auction_signals_header_ad_slot.Set(
      direct_from_seller_auction_signals_header_ad_slot_fragment.is_null() ? nullptr : direct_from_seller_auction_signals_header_ad_slot_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GenerateBidFinalizer::Name_);
  message.set_method_name("FinishGenerateBid");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool GenerateBidFinalizerStubDispatch::Accept(
    GenerateBidFinalizer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GenerateBidFinalizer>(message->header()->name)) {
    case messages::GenerateBidFinalizer::kFinishGenerateBid: {
      DCHECK(message->is_serialized());
      internal::GenerateBidFinalizer_FinishGenerateBid_Params_Data* params =
          reinterpret_cast<internal::GenerateBidFinalizer_FinishGenerateBid_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GenerateBidFinalizer.0
      bool success = true;
      std::optional<std::string> p_auction_signals_json{};
      std::optional<std::string> p_per_buyer_signals_json{};
      std::optional<::base::TimeDelta> p_per_buyer_timeout{};
      std::optional<::blink::AdCurrency> p_expected_buyer_currency{};
      std::optional<::GURL> p_direct_from_seller_per_buyer_signals{};
      std::optional<std::string> p_direct_from_seller_per_buyer_signals_header_ad_slot{};
      std::optional<::GURL> p_direct_from_seller_auction_signals{};
      std::optional<std::string> p_direct_from_seller_auction_signals_header_ad_slot{};
      GenerateBidFinalizer_FinishGenerateBid_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAuctionSignalsJson(&p_auction_signals_json))
        success = false;
      if (success && !input_data_view.ReadPerBuyerSignalsJson(&p_per_buyer_signals_json))
        success = false;
      if (success && !input_data_view.ReadPerBuyerTimeout(&p_per_buyer_timeout))
        success = false;
      if (success && !input_data_view.ReadExpectedBuyerCurrency(&p_expected_buyer_currency))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerPerBuyerSignals(&p_direct_from_seller_per_buyer_signals))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerPerBuyerSignalsHeaderAdSlot(&p_direct_from_seller_per_buyer_signals_header_ad_slot))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerAuctionSignals(&p_direct_from_seller_auction_signals))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerAuctionSignalsHeaderAdSlot(&p_direct_from_seller_auction_signals_header_ad_slot))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GenerateBidFinalizer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FinishGenerateBid(        
        std::move(p_auction_signals_json), 
        std::move(p_per_buyer_signals_json), 
        std::move(p_per_buyer_timeout), 
        std::move(p_expected_buyer_currency), 
        std::move(p_direct_from_seller_per_buyer_signals), 
        std::move(p_direct_from_seller_per_buyer_signals_header_ad_slot), 
        std::move(p_direct_from_seller_auction_signals), 
        std::move(p_direct_from_seller_auction_signals_header_ad_slot));
      return true;
    }
  }
  return false;
}

// static
bool GenerateBidFinalizerStubDispatch::AcceptWithResponder(
    GenerateBidFinalizer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GenerateBidFinalizer>(message->header()->name)) {
    case messages::GenerateBidFinalizer::kFinishGenerateBid: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kGenerateBidFinalizerValidationInfo[] = {
    { &internal::GenerateBidFinalizer_FinishGenerateBid_Params_Data::Validate,
     nullptr /* no response */},
};

bool GenerateBidFinalizerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::auction_worklet::mojom::GenerateBidFinalizer::Name_,
    kGenerateBidFinalizerValidationInfo);
}

// The declaration includes the definition on other builds.

BidderWorklet::IPCStableHashFunction BidderWorklet::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BidderWorklet>(message.name())) {
    case messages::BidderWorklet::kBeginGenerateBid: {
      return &BidderWorklet::BeginGenerateBid_Sym::IPCStableHash;
    }
    case messages::BidderWorklet::kSendPendingSignalsRequests: {
      return &BidderWorklet::SendPendingSignalsRequests_Sym::IPCStableHash;
    }
    case messages::BidderWorklet::kReportWin: {
      return &BidderWorklet::ReportWin_Sym::IPCStableHash;
    }
    case messages::BidderWorklet::kConnectDevToolsAgent: {
      return &BidderWorklet::ConnectDevToolsAgent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BidderWorklet::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BidderWorklet>(message.name())) {
      case messages::BidderWorklet::kBeginGenerateBid:
            return "Receive auction_worklet::mojom::BidderWorklet::BeginGenerateBid";
      case messages::BidderWorklet::kSendPendingSignalsRequests:
            return "Receive auction_worklet::mojom::BidderWorklet::SendPendingSignalsRequests";
      case messages::BidderWorklet::kReportWin:
            return "Receive auction_worklet::mojom::BidderWorklet::ReportWin";
      case messages::BidderWorklet::kConnectDevToolsAgent:
            return "Receive auction_worklet::mojom::BidderWorklet::ConnectDevToolsAgent";
    }
  } else {
    switch (static_cast<messages::BidderWorklet>(message.name())) {
      case messages::BidderWorklet::kBeginGenerateBid:
            return "Receive reply auction_worklet::mojom::BidderWorklet::BeginGenerateBid";
      case messages::BidderWorklet::kSendPendingSignalsRequests:
            return "Receive reply auction_worklet::mojom::BidderWorklet::SendPendingSignalsRequests";
      case messages::BidderWorklet::kReportWin:
            return "Receive reply auction_worklet::mojom::BidderWorklet::ReportWin";
      case messages::BidderWorklet::kConnectDevToolsAgent:
            return "Receive reply auction_worklet::mojom::BidderWorklet::ConnectDevToolsAgent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BidderWorklet::BeginGenerateBid_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5a25fc1b;  // IPCStableHash for auction_worklet::mojom::BidderWorklet::BeginGenerateBid
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BidderWorklet::SendPendingSignalsRequests_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x107b2300;  // IPCStableHash for auction_worklet::mojom::BidderWorklet::SendPendingSignalsRequests
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BidderWorklet::ReportWin_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf08c1533;  // IPCStableHash for auction_worklet::mojom::BidderWorklet::ReportWin
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BidderWorklet::ConnectDevToolsAgent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5e130643;  // IPCStableHash for auction_worklet::mojom::BidderWorklet::ConnectDevToolsAgent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BidderWorklet_ReportWin_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BidderWorklet_ReportWin_ForwardToCallback(
      BidderWorklet::ReportWinCallback callback
      ) : callback_(std::move(callback)) {
  }

  BidderWorklet_ReportWin_ForwardToCallback(const BidderWorklet_ReportWin_ForwardToCallback&) = delete;
  BidderWorklet_ReportWin_ForwardToCallback& operator=(const BidderWorklet_ReportWin_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BidderWorklet::ReportWinCallback callback_;
};

BidderWorkletProxy::BidderWorkletProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BidderWorkletProxy::BeginGenerateBid(
    BidderWorkletNonSharedParamsPtr in_bidder_worklet_non_shared_params, ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr in_key_value_signals_cache_key, KAnonymityBidMode in_kanon_mode, const ::url::Origin& in_interest_group_join_origin, const std::optional<::GURL>& in_direct_from_seller_per_buyer_signals, const std::optional<::GURL>& in_direct_from_seller_auction_signals, const ::url::Origin& in_browser_signal_seller_origin, const std::optional<::url::Origin>& in_browser_signal_top_level_seller_origin, ::base::TimeDelta in_browser_signal_recency, bool in_browser_signal_for_debugging_only_sampling, ::blink::mojom::BiddingBrowserSignalsPtr in_bidding_browser_signals, ::base::Time in_auction_start_time, const std::optional<::blink::AdSize>& in_requested_ad_size, uint16_t in_multi_bid_limit, uint64_t in_group_by_origin_id, uint64_t in_trace_id, ::mojo::PendingAssociatedRemote<GenerateBidClient> in_generate_bid_client, ::mojo::PendingAssociatedReceiver<GenerateBidFinalizer> in_bid_finalizer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::BidderWorklet::BeginGenerateBid", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bidder_worklet_non_shared_params"), in_bidder_worklet_non_shared_params,
                        "<value of type BidderWorkletNonSharedParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_value_signals_cache_key"), in_key_value_signals_cache_key,
                        "<value of type ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("kanon_mode"), in_kanon_mode,
                        "<value of type KAnonymityBidMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interest_group_join_origin"), in_interest_group_join_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_per_buyer_signals"), in_direct_from_seller_per_buyer_signals,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_auction_signals"), in_direct_from_seller_auction_signals,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_seller_origin"), in_browser_signal_seller_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_top_level_seller_origin"), in_browser_signal_top_level_seller_origin,
                        "<value of type const std::optional<::url::Origin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_recency"), in_browser_signal_recency,
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_for_debugging_only_sampling"), in_browser_signal_for_debugging_only_sampling,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bidding_browser_signals"), in_bidding_browser_signals,
                        "<value of type ::blink::mojom::BiddingBrowserSignalsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction_start_time"), in_auction_start_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_ad_size"), in_requested_ad_size,
                        "<value of type const std::optional<::blink::AdSize>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("multi_bid_limit"), in_multi_bid_limit,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_by_origin_id"), in_group_by_origin_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("generate_bid_client"), in_generate_bid_client,
                        "<value of type ::mojo::PendingAssociatedRemote<GenerateBidClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bid_finalizer"), in_bid_finalizer,
                        "<value of type ::mojo::PendingAssociatedReceiver<GenerateBidFinalizer>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BidderWorklet::kBeginGenerateBid), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::BidderWorklet_BeginGenerateBid_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bidder_worklet_non_shared_params)::BaseType> bidder_worklet_non_shared_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::auction_worklet::mojom::BidderWorkletNonSharedParamsDataView>(
    in_bidder_worklet_non_shared_params,
    bidder_worklet_non_shared_params_fragment);

  params->bidder_worklet_non_shared_params.Set(
      bidder_worklet_non_shared_params_fragment.is_null() ? nullptr : bidder_worklet_non_shared_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bidder_worklet_non_shared_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bidder_worklet_non_shared_params in BidderWorklet.BeginGenerateBid request");
  mojo::internal::MessageFragment<
      typename decltype(params->key_value_signals_cache_key)::BaseType> key_value_signals_cache_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::auction_worklet::mojom::TrustedSignalsCacheKeyDataView>(
    in_key_value_signals_cache_key,
    key_value_signals_cache_key_fragment);

  params->key_value_signals_cache_key.Set(
      key_value_signals_cache_key_fragment.is_null() ? nullptr : key_value_signals_cache_key_fragment.data());

  
  mojo::internal::Serialize<::auction_worklet::mojom::KAnonymityBidMode>(
    in_kanon_mode,
    &params->kanon_mode);
  mojo::internal::MessageFragment<
      typename decltype(params->interest_group_join_origin)::BaseType> interest_group_join_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_interest_group_join_origin,
    interest_group_join_origin_fragment);

  params->interest_group_join_origin.Set(
      interest_group_join_origin_fragment.is_null() ? nullptr : interest_group_join_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->interest_group_join_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null interest_group_join_origin in BidderWorklet.BeginGenerateBid request");
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_per_buyer_signals)::BaseType> direct_from_seller_per_buyer_signals_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_direct_from_seller_per_buyer_signals,
    direct_from_seller_per_buyer_signals_fragment);

  params->direct_from_seller_per_buyer_signals.Set(
      direct_from_seller_per_buyer_signals_fragment.is_null() ? nullptr : direct_from_seller_per_buyer_signals_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_auction_signals)::BaseType> direct_from_seller_auction_signals_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_direct_from_seller_auction_signals,
    direct_from_seller_auction_signals_fragment);

  params->direct_from_seller_auction_signals.Set(
      direct_from_seller_auction_signals_fragment.is_null() ? nullptr : direct_from_seller_auction_signals_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_seller_origin)::BaseType> browser_signal_seller_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_browser_signal_seller_origin,
    browser_signal_seller_origin_fragment);

  params->browser_signal_seller_origin.Set(
      browser_signal_seller_origin_fragment.is_null() ? nullptr : browser_signal_seller_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->browser_signal_seller_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null browser_signal_seller_origin in BidderWorklet.BeginGenerateBid request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_top_level_seller_origin)::BaseType> browser_signal_top_level_seller_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_browser_signal_top_level_seller_origin,
    browser_signal_top_level_seller_origin_fragment);

  params->browser_signal_top_level_seller_origin.Set(
      browser_signal_top_level_seller_origin_fragment.is_null() ? nullptr : browser_signal_top_level_seller_origin_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_recency)::BaseType> browser_signal_recency_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_browser_signal_recency,
    browser_signal_recency_fragment);

  params->browser_signal_recency.Set(
      browser_signal_recency_fragment.is_null() ? nullptr : browser_signal_recency_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->browser_signal_recency.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null browser_signal_recency in BidderWorklet.BeginGenerateBid request");

  params->browser_signal_for_debugging_only_sampling = in_browser_signal_for_debugging_only_sampling;
  mojo::internal::MessageFragment<
      typename decltype(params->bidding_browser_signals)::BaseType> bidding_browser_signals_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::BiddingBrowserSignalsDataView>(
    in_bidding_browser_signals,
    bidding_browser_signals_fragment);

  params->bidding_browser_signals.Set(
      bidding_browser_signals_fragment.is_null() ? nullptr : bidding_browser_signals_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bidding_browser_signals.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bidding_browser_signals in BidderWorklet.BeginGenerateBid request");
  mojo::internal::MessageFragment<
      typename decltype(params->auction_start_time)::BaseType> auction_start_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_auction_start_time,
    auction_start_time_fragment);

  params->auction_start_time.Set(
      auction_start_time_fragment.is_null() ? nullptr : auction_start_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auction_start_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auction_start_time in BidderWorklet.BeginGenerateBid request");
  mojo::internal::MessageFragment<
      typename decltype(params->requested_ad_size)::BaseType> requested_ad_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AdSizeDataView>(
    in_requested_ad_size,
    requested_ad_size_fragment);

  params->requested_ad_size.Set(
      requested_ad_size_fragment.is_null() ? nullptr : requested_ad_size_fragment.data());

  params->multi_bid_limit = in_multi_bid_limit;

  params->group_by_origin_id = in_group_by_origin_id;

  params->trace_id = in_trace_id;

  
  mojo::internal::Serialize<::auction_worklet::mojom::GenerateBidClientAssociatedPtrInfoDataView>(
    in_generate_bid_client,
    &params->generate_bid_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->generate_bid_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid generate_bid_client in BidderWorklet.BeginGenerateBid request");

  
  mojo::internal::Serialize<::auction_worklet::mojom::GenerateBidFinalizerAssociatedRequestDataView>(
    in_bid_finalizer,
    &params->bid_finalizer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->bid_finalizer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid bid_finalizer in BidderWorklet.BeginGenerateBid request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BidderWorklet::Name_);
  message.set_method_name("BeginGenerateBid");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BidderWorkletProxy::SendPendingSignalsRequests(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send auction_worklet::mojom::BidderWorklet::SendPendingSignalsRequests");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BidderWorklet::kSendPendingSignalsRequests), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::BidderWorklet_SendPendingSignalsRequests_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BidderWorklet::Name_);
  message.set_method_name("SendPendingSignalsRequests");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BidderWorkletProxy::ReportWin(
    bool in_is_for_additional_bid, const std::optional<std::string>& in_interest_group_name_reporting_id, const std::optional<std::string>& in_buyer_reporting_id, const std::optional<std::string>& in_buyer_and_seller_reporting_id, const std::optional<std::string>& in_selected_buyer_and_seller_reporting_id, const std::optional<std::string>& in_auction_signals_json, const std::optional<std::string>& in_per_buyer_signals_json, const std::optional<::GURL>& in_direct_from_seller_per_buyer_signals, const std::optional<std::string>& in_direct_from_seller_per_buyer_signals_header_ad_slot, const std::optional<::GURL>& in_direct_from_seller_auction_signals, const std::optional<std::string>& in_direct_from_seller_auction_signals_header_ad_slot, const std::string& in_seller_signals_json, KAnonymityStatus in_kanon_status, const ::GURL& in_browser_signal_render_url, double in_browser_signal_bid, const std::optional<::blink::AdCurrency>& in_browser_signal_bid_currency, double in_browser_signal_highest_scoring_other_bid, const std::optional<::blink::AdCurrency>& in_browser_signal_highest_scoring_other_bid_currency, bool in_browser_signal_made_highest_scoring_other_bid, std::optional<double> in_browser_signal_ad_cost, std::optional<uint16_t> in_browser_signal_modeling_signals, uint8_t in_browser_signal_join_count, uint8_t in_browser_signal_recency, const ::url::Origin& in_browser_signal_seller_origin, const std::optional<::url::Origin>& in_browser_signal_top_level_seller_origin, std::optional<::base::TimeDelta> in_browser_signal_reporting_timeout, std::optional<uint32_t> in_bidding_signals_data_version, const std::optional<std::string>& in_aggregate_win_signals, uint64_t in_trace_id, ReportWinCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::BidderWorklet::ReportWin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_for_additional_bid"), in_is_for_additional_bid,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interest_group_name_reporting_id"), in_interest_group_name_reporting_id,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buyer_reporting_id"), in_buyer_reporting_id,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buyer_and_seller_reporting_id"), in_buyer_and_seller_reporting_id,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selected_buyer_and_seller_reporting_id"), in_selected_buyer_and_seller_reporting_id,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction_signals_json"), in_auction_signals_json,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("per_buyer_signals_json"), in_per_buyer_signals_json,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_per_buyer_signals"), in_direct_from_seller_per_buyer_signals,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_per_buyer_signals_header_ad_slot"), in_direct_from_seller_per_buyer_signals_header_ad_slot,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_auction_signals"), in_direct_from_seller_auction_signals,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_auction_signals_header_ad_slot"), in_direct_from_seller_auction_signals_header_ad_slot,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seller_signals_json"), in_seller_signals_json,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("kanon_status"), in_kanon_status,
                        "<value of type KAnonymityStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_render_url"), in_browser_signal_render_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_bid"), in_browser_signal_bid,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_bid_currency"), in_browser_signal_bid_currency,
                        "<value of type const std::optional<::blink::AdCurrency>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_highest_scoring_other_bid"), in_browser_signal_highest_scoring_other_bid,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_highest_scoring_other_bid_currency"), in_browser_signal_highest_scoring_other_bid_currency,
                        "<value of type const std::optional<::blink::AdCurrency>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_made_highest_scoring_other_bid"), in_browser_signal_made_highest_scoring_other_bid,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_ad_cost"), in_browser_signal_ad_cost,
                        "<value of type std::optional<double>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_modeling_signals"), in_browser_signal_modeling_signals,
                        "<value of type std::optional<uint16_t>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_join_count"), in_browser_signal_join_count,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_recency"), in_browser_signal_recency,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_seller_origin"), in_browser_signal_seller_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_top_level_seller_origin"), in_browser_signal_top_level_seller_origin,
                        "<value of type const std::optional<::url::Origin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_reporting_timeout"), in_browser_signal_reporting_timeout,
                        "<value of type std::optional<::base::TimeDelta>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bidding_signals_data_version"), in_bidding_signals_data_version,
                        "<value of type std::optional<uint32_t>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("aggregate_win_signals"), in_aggregate_win_signals,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BidderWorklet::kReportWin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::BidderWorklet_ReportWin_Params_Data> params(
          message);
  params.Allocate();

  params->is_for_additional_bid = in_is_for_additional_bid;
  mojo::internal::MessageFragment<
      typename decltype(params->interest_group_name_reporting_id)::BaseType> interest_group_name_reporting_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_interest_group_name_reporting_id,
    interest_group_name_reporting_id_fragment);

  params->interest_group_name_reporting_id.Set(
      interest_group_name_reporting_id_fragment.is_null() ? nullptr : interest_group_name_reporting_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->buyer_reporting_id)::BaseType> buyer_reporting_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_buyer_reporting_id,
    buyer_reporting_id_fragment);

  params->buyer_reporting_id.Set(
      buyer_reporting_id_fragment.is_null() ? nullptr : buyer_reporting_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->buyer_and_seller_reporting_id)::BaseType> buyer_and_seller_reporting_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_buyer_and_seller_reporting_id,
    buyer_and_seller_reporting_id_fragment);

  params->buyer_and_seller_reporting_id.Set(
      buyer_and_seller_reporting_id_fragment.is_null() ? nullptr : buyer_and_seller_reporting_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->selected_buyer_and_seller_reporting_id)::BaseType> selected_buyer_and_seller_reporting_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_selected_buyer_and_seller_reporting_id,
    selected_buyer_and_seller_reporting_id_fragment);

  params->selected_buyer_and_seller_reporting_id.Set(
      selected_buyer_and_seller_reporting_id_fragment.is_null() ? nullptr : selected_buyer_and_seller_reporting_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->auction_signals_json)::BaseType> auction_signals_json_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_auction_signals_json,
    auction_signals_json_fragment);

  params->auction_signals_json.Set(
      auction_signals_json_fragment.is_null() ? nullptr : auction_signals_json_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->per_buyer_signals_json)::BaseType> per_buyer_signals_json_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_per_buyer_signals_json,
    per_buyer_signals_json_fragment);

  params->per_buyer_signals_json.Set(
      per_buyer_signals_json_fragment.is_null() ? nullptr : per_buyer_signals_json_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_per_buyer_signals)::BaseType> direct_from_seller_per_buyer_signals_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_direct_from_seller_per_buyer_signals,
    direct_from_seller_per_buyer_signals_fragment);

  params->direct_from_seller_per_buyer_signals.Set(
      direct_from_seller_per_buyer_signals_fragment.is_null() ? nullptr : direct_from_seller_per_buyer_signals_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_per_buyer_signals_header_ad_slot)::BaseType> direct_from_seller_per_buyer_signals_header_ad_slot_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_direct_from_seller_per_buyer_signals_header_ad_slot,
    direct_from_seller_per_buyer_signals_header_ad_slot_fragment);

  params->direct_from_seller_per_buyer_signals_header_ad_slot.Set(
      direct_from_seller_per_buyer_signals_header_ad_slot_fragment.is_null() ? nullptr : direct_from_seller_per_buyer_signals_header_ad_slot_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_auction_signals)::BaseType> direct_from_seller_auction_signals_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_direct_from_seller_auction_signals,
    direct_from_seller_auction_signals_fragment);

  params->direct_from_seller_auction_signals.Set(
      direct_from_seller_auction_signals_fragment.is_null() ? nullptr : direct_from_seller_auction_signals_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_auction_signals_header_ad_slot)::BaseType> direct_from_seller_auction_signals_header_ad_slot_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_direct_from_seller_auction_signals_header_ad_slot,
    direct_from_seller_auction_signals_header_ad_slot_fragment);

  params->direct_from_seller_auction_signals_header_ad_slot.Set(
      direct_from_seller_auction_signals_header_ad_slot_fragment.is_null() ? nullptr : direct_from_seller_auction_signals_header_ad_slot_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->seller_signals_json)::BaseType> seller_signals_json_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_seller_signals_json,
    seller_signals_json_fragment);

  params->seller_signals_json.Set(
      seller_signals_json_fragment.is_null() ? nullptr : seller_signals_json_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->seller_signals_json.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null seller_signals_json in BidderWorklet.ReportWin request");

  
  mojo::internal::Serialize<::auction_worklet::mojom::KAnonymityStatus>(
    in_kanon_status,
    &params->kanon_status);
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_render_url)::BaseType> browser_signal_render_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_browser_signal_render_url,
    browser_signal_render_url_fragment);

  params->browser_signal_render_url.Set(
      browser_signal_render_url_fragment.is_null() ? nullptr : browser_signal_render_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->browser_signal_render_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null browser_signal_render_url in BidderWorklet.ReportWin request");

  params->browser_signal_bid = in_browser_signal_bid;
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_bid_currency)::BaseType> browser_signal_bid_currency_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AdCurrencyDataView>(
    in_browser_signal_bid_currency,
    browser_signal_bid_currency_fragment);

  params->browser_signal_bid_currency.Set(
      browser_signal_bid_currency_fragment.is_null() ? nullptr : browser_signal_bid_currency_fragment.data());

  params->browser_signal_highest_scoring_other_bid = in_browser_signal_highest_scoring_other_bid;
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_highest_scoring_other_bid_currency)::BaseType> browser_signal_highest_scoring_other_bid_currency_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AdCurrencyDataView>(
    in_browser_signal_highest_scoring_other_bid_currency,
    browser_signal_highest_scoring_other_bid_currency_fragment);

  params->browser_signal_highest_scoring_other_bid_currency.Set(
      browser_signal_highest_scoring_other_bid_currency_fragment.is_null() ? nullptr : browser_signal_highest_scoring_other_bid_currency_fragment.data());

  params->browser_signal_made_highest_scoring_other_bid = in_browser_signal_made_highest_scoring_other_bid;
  params->browser_signal_ad_cost_$flag = in_browser_signal_ad_cost.has_value();
  if (in_browser_signal_ad_cost.has_value()) {
    params->browser_signal_ad_cost_$value = in_browser_signal_ad_cost.value();
  }
  params->browser_signal_modeling_signals_$flag = in_browser_signal_modeling_signals.has_value();
  if (in_browser_signal_modeling_signals.has_value()) {
    params->browser_signal_modeling_signals_$value = in_browser_signal_modeling_signals.value();
  }

  params->browser_signal_join_count = in_browser_signal_join_count;

  params->browser_signal_recency = in_browser_signal_recency;
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_seller_origin)::BaseType> browser_signal_seller_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_browser_signal_seller_origin,
    browser_signal_seller_origin_fragment);

  params->browser_signal_seller_origin.Set(
      browser_signal_seller_origin_fragment.is_null() ? nullptr : browser_signal_seller_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->browser_signal_seller_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null browser_signal_seller_origin in BidderWorklet.ReportWin request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_top_level_seller_origin)::BaseType> browser_signal_top_level_seller_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_browser_signal_top_level_seller_origin,
    browser_signal_top_level_seller_origin_fragment);

  params->browser_signal_top_level_seller_origin.Set(
      browser_signal_top_level_seller_origin_fragment.is_null() ? nullptr : browser_signal_top_level_seller_origin_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_reporting_timeout)::BaseType> browser_signal_reporting_timeout_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_browser_signal_reporting_timeout,
    browser_signal_reporting_timeout_fragment);

  params->browser_signal_reporting_timeout.Set(
      browser_signal_reporting_timeout_fragment.is_null() ? nullptr : browser_signal_reporting_timeout_fragment.data());
  params->bidding_signals_data_version_$flag = in_bidding_signals_data_version.has_value();
  if (in_bidding_signals_data_version.has_value()) {
    params->bidding_signals_data_version_$value = in_bidding_signals_data_version.value();
  }
  mojo::internal::MessageFragment<
      typename decltype(params->aggregate_win_signals)::BaseType> aggregate_win_signals_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_aggregate_win_signals,
    aggregate_win_signals_fragment);

  params->aggregate_win_signals.Set(
      aggregate_win_signals_fragment.is_null() ? nullptr : aggregate_win_signals_fragment.data());

  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BidderWorklet::Name_);
  message.set_method_name("ReportWin");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BidderWorklet_ReportWin_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BidderWorkletProxy::ConnectDevToolsAgent(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> in_agent, uint32_t in_thread_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::BidderWorklet::ConnectDevToolsAgent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent"), in_agent,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("thread_index"), in_thread_index,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BidderWorklet::kConnectDevToolsAgent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::BidderWorklet_ConnectDevToolsAgent_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::DevToolsAgentAssociatedRequestDataView>(
    in_agent,
    &params->agent,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->agent)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid agent in BidderWorklet.ConnectDevToolsAgent request");

  params->thread_index = in_thread_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BidderWorklet::Name_);
  message.set_method_name("ConnectDevToolsAgent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class BidderWorklet_ReportWin_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BidderWorklet::ReportWinCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BidderWorklet_ReportWin_ProxyToResponder> proxy(
        new BidderWorklet_ReportWin_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BidderWorklet_ReportWin_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BidderWorklet_ReportWin_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BidderWorklet_ReportWin_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BidderWorklet::ReportWinCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::GURL>& in_report_url, const base::flat_map<std::string, ::GURL>& in_ad_beacon_map, const base::flat_map<std::string, std::string>& in_ad_macro_map, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> in_pa_requests, PrivateModelTrainingRequestDataPtr in_pmt_request_data, BidderTimingMetricsPtr in_timing_metrics, const std::vector<std::string>& in_errors);
};

bool BidderWorklet_ReportWin_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BidderWorklet_ReportWin_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BidderWorklet_ReportWin_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BidderWorklet.2
  bool success = true;
  std::optional<::GURL> p_report_url{};
  base::flat_map<std::string, ::GURL> p_ad_beacon_map{};
  base::flat_map<std::string, std::string> p_ad_macro_map{};
  std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> p_pa_requests{};
  PrivateModelTrainingRequestDataPtr p_pmt_request_data{};
  BidderTimingMetricsPtr p_timing_metrics{};
  std::vector<std::string> p_errors{};
  BidderWorklet_ReportWin_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadReportUrl(&p_report_url))
    success = false;
  if (success && !input_data_view.ReadAdBeaconMap(&p_ad_beacon_map))
    success = false;
  if (success && !input_data_view.ReadAdMacroMap(&p_ad_macro_map))
    success = false;
  if (success && !input_data_view.ReadPaRequests(&p_pa_requests))
    success = false;
  if (success && !input_data_view.ReadPmtRequestData(&p_pmt_request_data))
    success = false;
  if (success && !input_data_view.ReadTimingMetrics(&p_timing_metrics))
    success = false;
  if (success && !input_data_view.ReadErrors(&p_errors))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BidderWorklet::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_report_url), 
std::move(p_ad_beacon_map), 
std::move(p_ad_macro_map), 
std::move(p_pa_requests), 
std::move(p_pmt_request_data), 
std::move(p_timing_metrics), 
std::move(p_errors));
  }
  return true;
}

void BidderWorklet_ReportWin_ProxyToResponder::Run(
    const std::optional<::GURL>& in_report_url, const base::flat_map<std::string, ::GURL>& in_ad_beacon_map, const base::flat_map<std::string, std::string>& in_ad_macro_map, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> in_pa_requests, PrivateModelTrainingRequestDataPtr in_pmt_request_data, BidderTimingMetricsPtr in_timing_metrics, const std::vector<std::string>& in_errors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply auction_worklet::mojom::BidderWorklet::ReportWin", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_url"), in_report_url,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ad_beacon_map"), in_ad_beacon_map,
                        "<value of type const base::flat_map<std::string, ::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ad_macro_map"), in_ad_macro_map,
                        "<value of type const base::flat_map<std::string, std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pa_requests"), in_pa_requests,
                        "<value of type std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pmt_request_data"), in_pmt_request_data,
                        "<value of type PrivateModelTrainingRequestDataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timing_metrics"), in_timing_metrics,
                        "<value of type BidderTimingMetricsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("errors"), in_errors,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BidderWorklet::kReportWin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::BidderWorklet_ReportWin_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->report_url)::BaseType> report_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_report_url,
    report_url_fragment);

  params->report_url.Set(
      report_url_fragment.is_null() ? nullptr : report_url_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->ad_beacon_map)::BaseType>
      ad_beacon_map_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ad_beacon_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>>(
    in_ad_beacon_map,
    ad_beacon_map_fragment,
    &ad_beacon_map_validate_params);

  params->ad_beacon_map.Set(
      ad_beacon_map_fragment.is_null() ? nullptr : ad_beacon_map_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ad_beacon_map.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ad_beacon_map in ");
  mojo::internal::MessageFragment<
      typename decltype(params->ad_macro_map)::BaseType>
      ad_macro_map_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ad_macro_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
    in_ad_macro_map,
    ad_macro_map_fragment,
    &ad_macro_map_validate_params);

  params->ad_macro_map.Set(
      ad_macro_map_fragment.is_null() ? nullptr : ad_macro_map_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ad_macro_map.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ad_macro_map in ");
  mojo::internal::MessageFragment<
      typename decltype(params->pa_requests)::BaseType>
      pa_requests_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& pa_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>>(
    in_pa_requests,
    pa_requests_fragment,
    &pa_requests_validate_params);

  params->pa_requests.Set(
      pa_requests_fragment.is_null() ? nullptr : pa_requests_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pa_requests.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pa_requests in ");
  mojo::internal::MessageFragment<
      typename decltype(params->pmt_request_data)::BaseType> pmt_request_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::auction_worklet::mojom::PrivateModelTrainingRequestDataDataView>(
    in_pmt_request_data,
    pmt_request_data_fragment);

  params->pmt_request_data.Set(
      pmt_request_data_fragment.is_null() ? nullptr : pmt_request_data_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->timing_metrics)::BaseType> timing_metrics_fragment(
          params.message());
  
  mojo::internal::Serialize<::auction_worklet::mojom::BidderTimingMetricsDataView>(
    in_timing_metrics,
    timing_metrics_fragment);

  params->timing_metrics.Set(
      timing_metrics_fragment.is_null() ? nullptr : timing_metrics_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timing_metrics.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timing_metrics in ");
  mojo::internal::MessageFragment<
      typename decltype(params->errors)::BaseType>
      errors_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& errors_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_errors,
    errors_fragment,
    &errors_validate_params);

  params->errors.Set(
      errors_fragment.is_null() ? nullptr : errors_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->errors.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null errors in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BidderWorklet::Name_);
  message.set_method_name("ReportWin");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BidderWorkletStubDispatch::Accept(
    BidderWorklet* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BidderWorklet>(message->header()->name)) {
    case messages::BidderWorklet::kBeginGenerateBid: {
      DCHECK(message->is_serialized());
      internal::BidderWorklet_BeginGenerateBid_Params_Data* params =
          reinterpret_cast<internal::BidderWorklet_BeginGenerateBid_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BidderWorklet.0
      bool success = true;
      BidderWorkletNonSharedParamsPtr p_bidder_worklet_non_shared_params{};
      ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr p_key_value_signals_cache_key{};
      KAnonymityBidMode p_kanon_mode{};
      ::url::Origin p_interest_group_join_origin{};
      std::optional<::GURL> p_direct_from_seller_per_buyer_signals{};
      std::optional<::GURL> p_direct_from_seller_auction_signals{};
      ::url::Origin p_browser_signal_seller_origin{};
      std::optional<::url::Origin> p_browser_signal_top_level_seller_origin{};
      ::base::TimeDelta p_browser_signal_recency{};
      bool p_browser_signal_for_debugging_only_sampling{};
      ::blink::mojom::BiddingBrowserSignalsPtr p_bidding_browser_signals{};
      ::base::Time p_auction_start_time{};
      std::optional<::blink::AdSize> p_requested_ad_size{};
      uint16_t p_multi_bid_limit{};
      uint64_t p_group_by_origin_id{};
      uint64_t p_trace_id{};
      ::mojo::PendingAssociatedRemote<GenerateBidClient> p_generate_bid_client{};
      ::mojo::PendingAssociatedReceiver<GenerateBidFinalizer> p_bid_finalizer{};
      BidderWorklet_BeginGenerateBid_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBidderWorkletNonSharedParams(&p_bidder_worklet_non_shared_params))
        success = false;
      if (success && !input_data_view.ReadKeyValueSignalsCacheKey(&p_key_value_signals_cache_key))
        success = false;
      if (success && !input_data_view.ReadKanonMode(&p_kanon_mode))
        success = false;
      if (success && !input_data_view.ReadInterestGroupJoinOrigin(&p_interest_group_join_origin))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerPerBuyerSignals(&p_direct_from_seller_per_buyer_signals))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerAuctionSignals(&p_direct_from_seller_auction_signals))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalSellerOrigin(&p_browser_signal_seller_origin))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalTopLevelSellerOrigin(&p_browser_signal_top_level_seller_origin))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalRecency(&p_browser_signal_recency))
        success = false;
      if (success)
        p_browser_signal_for_debugging_only_sampling = input_data_view.browser_signal_for_debugging_only_sampling();
      if (success && !input_data_view.ReadBiddingBrowserSignals(&p_bidding_browser_signals))
        success = false;
      if (success && !input_data_view.ReadAuctionStartTime(&p_auction_start_time))
        success = false;
      if (success && !input_data_view.ReadRequestedAdSize(&p_requested_ad_size))
        success = false;
      if (success)
        p_multi_bid_limit = input_data_view.multi_bid_limit();
      if (success)
        p_group_by_origin_id = input_data_view.group_by_origin_id();
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (success) {
        p_generate_bid_client =
            input_data_view.TakeGenerateBidClient<decltype(p_generate_bid_client)>();
      }
      if (success) {
        p_bid_finalizer =
            input_data_view.TakeBidFinalizer<decltype(p_bid_finalizer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BidderWorklet::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginGenerateBid(        
        std::move(p_bidder_worklet_non_shared_params), 
        std::move(p_key_value_signals_cache_key), 
        std::move(p_kanon_mode), 
        std::move(p_interest_group_join_origin), 
        std::move(p_direct_from_seller_per_buyer_signals), 
        std::move(p_direct_from_seller_auction_signals), 
        std::move(p_browser_signal_seller_origin), 
        std::move(p_browser_signal_top_level_seller_origin), 
        std::move(p_browser_signal_recency), 
        std::move(p_browser_signal_for_debugging_only_sampling), 
        std::move(p_bidding_browser_signals), 
        std::move(p_auction_start_time), 
        std::move(p_requested_ad_size), 
        std::move(p_multi_bid_limit), 
        std::move(p_group_by_origin_id), 
        std::move(p_trace_id), 
        std::move(p_generate_bid_client), 
        std::move(p_bid_finalizer));
      return true;
    }
    case messages::BidderWorklet::kSendPendingSignalsRequests: {
      DCHECK(message->is_serialized());
      internal::BidderWorklet_SendPendingSignalsRequests_Params_Data* params =
          reinterpret_cast<internal::BidderWorklet_SendPendingSignalsRequests_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BidderWorklet.1
      bool success = true;
      BidderWorklet_SendPendingSignalsRequests_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BidderWorklet::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendPendingSignalsRequests(        );
      return true;
    }
    case messages::BidderWorklet::kReportWin: {
      break;
    }
    case messages::BidderWorklet::kConnectDevToolsAgent: {
      DCHECK(message->is_serialized());
      internal::BidderWorklet_ConnectDevToolsAgent_Params_Data* params =
          reinterpret_cast<internal::BidderWorklet_ConnectDevToolsAgent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BidderWorklet.3
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> p_agent{};
      uint32_t p_thread_index{};
      BidderWorklet_ConnectDevToolsAgent_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (success)
        p_thread_index = input_data_view.thread_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BidderWorklet::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectDevToolsAgent(        
        std::move(p_agent), 
        std::move(p_thread_index));
      return true;
    }
  }
  return false;
}

// static
bool BidderWorkletStubDispatch::AcceptWithResponder(
    BidderWorklet* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BidderWorklet>(message->header()->name)) {
    case messages::BidderWorklet::kBeginGenerateBid: {
      break;
    }
    case messages::BidderWorklet::kSendPendingSignalsRequests: {
      break;
    }
    case messages::BidderWorklet::kReportWin: {
      internal::BidderWorklet_ReportWin_Params_Data* params =
          reinterpret_cast<
              internal::BidderWorklet_ReportWin_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BidderWorklet.2
      bool success = true;
      bool p_is_for_additional_bid{};
      std::optional<std::string> p_interest_group_name_reporting_id{};
      std::optional<std::string> p_buyer_reporting_id{};
      std::optional<std::string> p_buyer_and_seller_reporting_id{};
      std::optional<std::string> p_selected_buyer_and_seller_reporting_id{};
      std::optional<std::string> p_auction_signals_json{};
      std::optional<std::string> p_per_buyer_signals_json{};
      std::optional<::GURL> p_direct_from_seller_per_buyer_signals{};
      std::optional<std::string> p_direct_from_seller_per_buyer_signals_header_ad_slot{};
      std::optional<::GURL> p_direct_from_seller_auction_signals{};
      std::optional<std::string> p_direct_from_seller_auction_signals_header_ad_slot{};
      std::string p_seller_signals_json{};
      KAnonymityStatus p_kanon_status{};
      ::GURL p_browser_signal_render_url{};
      double p_browser_signal_bid{};
      std::optional<::blink::AdCurrency> p_browser_signal_bid_currency{};
      double p_browser_signal_highest_scoring_other_bid{};
      std::optional<::blink::AdCurrency> p_browser_signal_highest_scoring_other_bid_currency{};
      bool p_browser_signal_made_highest_scoring_other_bid{};
      std::optional<double> p_browser_signal_ad_cost{};
      std::optional<uint16_t> p_browser_signal_modeling_signals{};
      uint8_t p_browser_signal_join_count{};
      uint8_t p_browser_signal_recency{};
      ::url::Origin p_browser_signal_seller_origin{};
      std::optional<::url::Origin> p_browser_signal_top_level_seller_origin{};
      std::optional<::base::TimeDelta> p_browser_signal_reporting_timeout{};
      std::optional<uint32_t> p_bidding_signals_data_version{};
      std::optional<std::string> p_aggregate_win_signals{};
      uint64_t p_trace_id{};
      BidderWorklet_ReportWin_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_for_additional_bid = input_data_view.is_for_additional_bid();
      if (success && !input_data_view.ReadInterestGroupNameReportingId(&p_interest_group_name_reporting_id))
        success = false;
      if (success && !input_data_view.ReadBuyerReportingId(&p_buyer_reporting_id))
        success = false;
      if (success && !input_data_view.ReadBuyerAndSellerReportingId(&p_buyer_and_seller_reporting_id))
        success = false;
      if (success && !input_data_view.ReadSelectedBuyerAndSellerReportingId(&p_selected_buyer_and_seller_reporting_id))
        success = false;
      if (success && !input_data_view.ReadAuctionSignalsJson(&p_auction_signals_json))
        success = false;
      if (success && !input_data_view.ReadPerBuyerSignalsJson(&p_per_buyer_signals_json))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerPerBuyerSignals(&p_direct_from_seller_per_buyer_signals))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerPerBuyerSignalsHeaderAdSlot(&p_direct_from_seller_per_buyer_signals_header_ad_slot))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerAuctionSignals(&p_direct_from_seller_auction_signals))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerAuctionSignalsHeaderAdSlot(&p_direct_from_seller_auction_signals_header_ad_slot))
        success = false;
      if (success && !input_data_view.ReadSellerSignalsJson(&p_seller_signals_json))
        success = false;
      if (success && !input_data_view.ReadKanonStatus(&p_kanon_status))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalRenderUrl(&p_browser_signal_render_url))
        success = false;
      if (success)
        p_browser_signal_bid = input_data_view.browser_signal_bid();
      if (success && !input_data_view.ReadBrowserSignalBidCurrency(&p_browser_signal_bid_currency))
        success = false;
      if (success)
        p_browser_signal_highest_scoring_other_bid = input_data_view.browser_signal_highest_scoring_other_bid();
      if (success && !input_data_view.ReadBrowserSignalHighestScoringOtherBidCurrency(&p_browser_signal_highest_scoring_other_bid_currency))
        success = false;
      if (success)
        p_browser_signal_made_highest_scoring_other_bid = input_data_view.browser_signal_made_highest_scoring_other_bid();
      if (success) {
        p_browser_signal_ad_cost = input_data_view.browser_signal_ad_cost();
      }
      if (success) {
        p_browser_signal_modeling_signals = input_data_view.browser_signal_modeling_signals();
      }
      if (success)
        p_browser_signal_join_count = input_data_view.browser_signal_join_count();
      if (success)
        p_browser_signal_recency = input_data_view.browser_signal_recency();
      if (success && !input_data_view.ReadBrowserSignalSellerOrigin(&p_browser_signal_seller_origin))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalTopLevelSellerOrigin(&p_browser_signal_top_level_seller_origin))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalReportingTimeout(&p_browser_signal_reporting_timeout))
        success = false;
      if (success) {
        p_bidding_signals_data_version = input_data_view.bidding_signals_data_version();
      }
      if (success && !input_data_view.ReadAggregateWinSignals(&p_aggregate_win_signals))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BidderWorklet::Name_, 2, false);
        return false;
      }
      auto callback =
          BidderWorklet_ReportWin_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportWin(        
        std::move(p_is_for_additional_bid), 
        std::move(p_interest_group_name_reporting_id), 
        std::move(p_buyer_reporting_id), 
        std::move(p_buyer_and_seller_reporting_id), 
        std::move(p_selected_buyer_and_seller_reporting_id), 
        std::move(p_auction_signals_json), 
        std::move(p_per_buyer_signals_json), 
        std::move(p_direct_from_seller_per_buyer_signals), 
        std::move(p_direct_from_seller_per_buyer_signals_header_ad_slot), 
        std::move(p_direct_from_seller_auction_signals), 
        std::move(p_direct_from_seller_auction_signals_header_ad_slot), 
        std::move(p_seller_signals_json), 
        std::move(p_kanon_status), 
        std::move(p_browser_signal_render_url), 
        std::move(p_browser_signal_bid), 
        std::move(p_browser_signal_bid_currency), 
        std::move(p_browser_signal_highest_scoring_other_bid), 
        std::move(p_browser_signal_highest_scoring_other_bid_currency), 
        std::move(p_browser_signal_made_highest_scoring_other_bid), 
        std::move(p_browser_signal_ad_cost), 
        std::move(p_browser_signal_modeling_signals), 
        std::move(p_browser_signal_join_count), 
        std::move(p_browser_signal_recency), 
        std::move(p_browser_signal_seller_origin), 
        std::move(p_browser_signal_top_level_seller_origin), 
        std::move(p_browser_signal_reporting_timeout), 
        std::move(p_bidding_signals_data_version), 
        std::move(p_aggregate_win_signals), 
        std::move(p_trace_id), std::move(callback));
      return true;
    }
    case messages::BidderWorklet::kConnectDevToolsAgent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBidderWorkletValidationInfo[] = {
    { &internal::BidderWorklet_BeginGenerateBid_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BidderWorklet_SendPendingSignalsRequests_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BidderWorklet_ReportWin_Params_Data::Validate,
     &internal::BidderWorklet_ReportWin_ResponseParams_Data::Validate},
    { &internal::BidderWorklet_ConnectDevToolsAgent_Params_Data::Validate,
     nullptr /* no response */},
};

bool BidderWorkletRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::auction_worklet::mojom::BidderWorklet::Name_,
    kBidderWorkletValidationInfo);
}

bool BidderWorkletResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::auction_worklet::mojom::BidderWorklet::Name_,
    kBidderWorkletValidationInfo);
}


}  // auction_worklet::mojom


namespace mojo {


// static
bool StructTraits<::auction_worklet::mojom::KAnonKey::DataView, ::auction_worklet::mojom::KAnonKeyPtr>::Read(
    ::auction_worklet::mojom::KAnonKey::DataView input,
    ::auction_worklet::mojom::KAnonKeyPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::KAnonKeyPtr result(::auction_worklet::mojom::KAnonKey::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::BidderWorkletNonSharedParams::DataView, ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr>::Read(
    ::auction_worklet::mojom::BidderWorkletNonSharedParams::DataView input,
    ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr result(::auction_worklet::mojom::BidderWorkletNonSharedParams::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadTrustedBiddingSignalsSlotSizeMode(&result->trusted_bidding_signals_slot_size_mode))
        success = false;
      if (success)
        result->enable_bidding_signals_prioritization = input.enable_bidding_signals_prioritization();
      if (success && !input.ReadPriorityVector(&result->priority_vector))
        success = false;
      if (success && !input.ReadExecutionMode(&result->execution_mode))
        success = false;
      if (success && !input.ReadUpdateUrl(&result->update_url))
        success = false;
      if (success && !input.ReadTrustedBiddingSignalsKeys(&result->trusted_bidding_signals_keys))
        success = false;
      if (success)
        result->max_trusted_bidding_signals_url_length = input.max_trusted_bidding_signals_url_length();
      if (success && !input.ReadUserBiddingSignals(&result->user_bidding_signals))
        success = false;
      if (success && !input.ReadAds(&result->ads))
        success = false;
      if (success && !input.ReadAdComponents(&result->ad_components))
        success = false;
      if (success && !input.ReadKanonKeys(&result->kanon_keys))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::BidderWorkletBid::DataView, ::auction_worklet::mojom::BidderWorkletBidPtr>::Read(
    ::auction_worklet::mojom::BidderWorkletBid::DataView input,
    ::auction_worklet::mojom::BidderWorkletBidPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::BidderWorkletBidPtr result(::auction_worklet::mojom::BidderWorkletBid::New());
  
      if (success && !input.ReadBidRole(&result->bid_role))
        success = false;
      if (success && !input.ReadAd(&result->ad))
        success = false;
      if (success)
        result->bid = input.bid();
      if (success && !input.ReadBidCurrency(&result->bid_currency))
        success = false;
      if (success) {
        result->ad_cost = input.ad_cost();
      }
      if (success && !input.ReadAdDescriptor(&result->ad_descriptor))
        success = false;
      if (success && !input.ReadSelectedBuyerAndSellerReportingId(&result->selected_buyer_and_seller_reporting_id))
        success = false;
      if (success && !input.ReadAdComponentDescriptors(&result->ad_component_descriptors))
        success = false;
      if (success) {
        result->modeling_signals = input.modeling_signals();
      }
      if (success && !input.ReadAggregateWinSignals(&result->aggregate_win_signals))
        success = false;
      if (success && !input.ReadBidDuration(&result->bid_duration))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::PrioritySignalsDouble::DataView, ::auction_worklet::mojom::PrioritySignalsDoublePtr>::Read(
    ::auction_worklet::mojom::PrioritySignalsDouble::DataView input,
    ::auction_worklet::mojom::PrioritySignalsDoublePtr* output) {
  bool success = true;
  ::auction_worklet::mojom::PrioritySignalsDoublePtr result(::auction_worklet::mojom::PrioritySignalsDouble::New());
  
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::GenerateBidDependencyLatencies::DataView, ::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr>::Read(
    ::auction_worklet::mojom::GenerateBidDependencyLatencies::DataView input,
    ::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr result(::auction_worklet::mojom::GenerateBidDependencyLatencies::New());
  
      if (success && !input.ReadCodeReadyLatency(&result->code_ready_latency))
        success = false;
      if (success && !input.ReadConfigPromisesLatency(&result->config_promises_latency))
        success = false;
      if (success && !input.ReadDirectFromSellerSignalsLatency(&result->direct_from_seller_signals_latency))
        success = false;
      if (success && !input.ReadTrustedBiddingSignalsLatency(&result->trusted_bidding_signals_latency))
        success = false;
      if (success && !input.ReadDepsWaitStartTime(&result->deps_wait_start_time))
        success = false;
      if (success && !input.ReadGenerateBidStartTime(&result->generate_bid_start_time))
        success = false;
      if (success && !input.ReadGenerateBidFinishTime(&result->generate_bid_finish_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::BidderTimingMetrics::DataView, ::auction_worklet::mojom::BidderTimingMetricsPtr>::Read(
    ::auction_worklet::mojom::BidderTimingMetrics::DataView input,
    ::auction_worklet::mojom::BidderTimingMetricsPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::BidderTimingMetricsPtr result(::auction_worklet::mojom::BidderTimingMetrics::New());
  
      if (success && !input.ReadJsFetchLatency(&result->js_fetch_latency))
        success = false;
      if (success && !input.ReadWasmFetchLatency(&result->wasm_fetch_latency))
        success = false;
      if (success && !input.ReadScriptLatency(&result->script_latency))
        success = false;
      if (success)
        result->script_timed_out = input.script_timed_out();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::PrivateModelTrainingRequestData::DataView, ::auction_worklet::mojom::PrivateModelTrainingRequestDataPtr>::Read(
    ::auction_worklet::mojom::PrivateModelTrainingRequestData::DataView input,
    ::auction_worklet::mojom::PrivateModelTrainingRequestDataPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::PrivateModelTrainingRequestDataPtr result(::auction_worklet::mojom::PrivateModelTrainingRequestData::New());
  
      if (success && !input.ReadPayload(&result->payload))
        success = false;
      if (success)
        result->payload_length = input.payload_length();
      if (success && !input.ReadAggregationCoordinatorOrigin(&result->aggregation_coordinator_origin))
        success = false;
      if (success && !input.ReadDestination(&result->destination))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace auction_worklet::mojom {


void GenerateBidClientInterceptorForTesting::OnBiddingSignalsReceived(const base::flat_map<std::string, double>& priority_vector, ::base::TimeDelta trusted_signals_fetch_latency, std::optional<::base::TimeDelta> update_if_older_than, OnBiddingSignalsReceivedCallback callback) {
  GetForwardingInterface()->OnBiddingSignalsReceived(
    std::move(priority_vector)
    , 
    std::move(trusted_signals_fetch_latency)
    , 
    std::move(update_if_older_than)
    , std::move(callback));
}
void GenerateBidClientInterceptorForTesting::OnGenerateBidComplete(std::vector<BidderWorkletBidPtr> bids, std::optional<uint32_t> bidding_signals_data_version, const std::optional<::GURL>& debug_loss_report_url, const std::optional<::GURL>& debug_win_report_url, std::optional<double> set_priority, base::flat_map<std::string, PrioritySignalsDoublePtr> update_priority_signals_overrides, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> pa_requests, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> non_kanon_pa_requests, std::vector<::auction_worklet::mojom::RealTimeReportingContributionPtr> real_time_contributions, BidderTimingMetricsPtr generate_bid_timing_metrics, GenerateBidDependencyLatenciesPtr generate_bid_dependency_latencies, ::auction_worklet::mojom::RejectReason reject_reason, const std::vector<std::string>& errors) {
  GetForwardingInterface()->OnGenerateBidComplete(
    std::move(bids)
    , 
    std::move(bidding_signals_data_version)
    , 
    std::move(debug_loss_report_url)
    , 
    std::move(debug_win_report_url)
    , 
    std::move(set_priority)
    , 
    std::move(update_priority_signals_overrides)
    , 
    std::move(pa_requests)
    , 
    std::move(non_kanon_pa_requests)
    , 
    std::move(real_time_contributions)
    , 
    std::move(generate_bid_timing_metrics)
    , 
    std::move(generate_bid_dependency_latencies)
    , 
    std::move(reject_reason)
    , 
    std::move(errors)
    );
}
GenerateBidClientAsyncWaiter::GenerateBidClientAsyncWaiter(
    GenerateBidClient* proxy) : proxy_(proxy) {}

GenerateBidClientAsyncWaiter::~GenerateBidClientAsyncWaiter() = default;


void GenerateBidClientAsyncWaiter::OnBiddingSignalsReceived(
    const base::flat_map<std::string, double>& priority_vector, ::base::TimeDelta trusted_signals_fetch_latency, std::optional<::base::TimeDelta> update_if_older_than) {
  base::RunLoop loop;
  proxy_->OnBiddingSignalsReceived(
      std::move(priority_vector),
      std::move(trusted_signals_fetch_latency),
      std::move(update_if_older_than),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void GenerateBidFinalizerInterceptorForTesting::FinishGenerateBid(const std::optional<std::string>& auction_signals_json, const std::optional<std::string>& per_buyer_signals_json, std::optional<::base::TimeDelta> per_buyer_timeout, const std::optional<::blink::AdCurrency>& expected_buyer_currency, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<std::string>& direct_from_seller_per_buyer_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot) {
  GetForwardingInterface()->FinishGenerateBid(
    std::move(auction_signals_json)
    , 
    std::move(per_buyer_signals_json)
    , 
    std::move(per_buyer_timeout)
    , 
    std::move(expected_buyer_currency)
    , 
    std::move(direct_from_seller_per_buyer_signals)
    , 
    std::move(direct_from_seller_per_buyer_signals_header_ad_slot)
    , 
    std::move(direct_from_seller_auction_signals)
    , 
    std::move(direct_from_seller_auction_signals_header_ad_slot)
    );
}
GenerateBidFinalizerAsyncWaiter::GenerateBidFinalizerAsyncWaiter(
    GenerateBidFinalizer* proxy) : proxy_(proxy) {}

GenerateBidFinalizerAsyncWaiter::~GenerateBidFinalizerAsyncWaiter() = default;





void BidderWorkletInterceptorForTesting::BeginGenerateBid(BidderWorkletNonSharedParamsPtr bidder_worklet_non_shared_params, ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr key_value_signals_cache_key, KAnonymityBidMode kanon_mode, const ::url::Origin& interest_group_join_origin, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<::GURL>& direct_from_seller_auction_signals, const ::url::Origin& browser_signal_seller_origin, const std::optional<::url::Origin>& browser_signal_top_level_seller_origin, ::base::TimeDelta browser_signal_recency, bool browser_signal_for_debugging_only_sampling, ::blink::mojom::BiddingBrowserSignalsPtr bidding_browser_signals, ::base::Time auction_start_time, const std::optional<::blink::AdSize>& requested_ad_size, uint16_t multi_bid_limit, uint64_t group_by_origin_id, uint64_t trace_id, ::mojo::PendingAssociatedRemote<GenerateBidClient> generate_bid_client, ::mojo::PendingAssociatedReceiver<GenerateBidFinalizer> bid_finalizer) {
  GetForwardingInterface()->BeginGenerateBid(
    std::move(bidder_worklet_non_shared_params)
    , 
    std::move(key_value_signals_cache_key)
    , 
    std::move(kanon_mode)
    , 
    std::move(interest_group_join_origin)
    , 
    std::move(direct_from_seller_per_buyer_signals)
    , 
    std::move(direct_from_seller_auction_signals)
    , 
    std::move(browser_signal_seller_origin)
    , 
    std::move(browser_signal_top_level_seller_origin)
    , 
    std::move(browser_signal_recency)
    , 
    std::move(browser_signal_for_debugging_only_sampling)
    , 
    std::move(bidding_browser_signals)
    , 
    std::move(auction_start_time)
    , 
    std::move(requested_ad_size)
    , 
    std::move(multi_bid_limit)
    , 
    std::move(group_by_origin_id)
    , 
    std::move(trace_id)
    , 
    std::move(generate_bid_client)
    , 
    std::move(bid_finalizer)
    );
}
void BidderWorkletInterceptorForTesting::SendPendingSignalsRequests() {
  GetForwardingInterface()->SendPendingSignalsRequests();
}
void BidderWorkletInterceptorForTesting::ReportWin(bool is_for_additional_bid, const std::optional<std::string>& interest_group_name_reporting_id, const std::optional<std::string>& buyer_reporting_id, const std::optional<std::string>& buyer_and_seller_reporting_id, const std::optional<std::string>& selected_buyer_and_seller_reporting_id, const std::optional<std::string>& auction_signals_json, const std::optional<std::string>& per_buyer_signals_json, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<std::string>& direct_from_seller_per_buyer_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot, const std::string& seller_signals_json, KAnonymityStatus kanon_status, const ::GURL& browser_signal_render_url, double browser_signal_bid, const std::optional<::blink::AdCurrency>& browser_signal_bid_currency, double browser_signal_highest_scoring_other_bid, const std::optional<::blink::AdCurrency>& browser_signal_highest_scoring_other_bid_currency, bool browser_signal_made_highest_scoring_other_bid, std::optional<double> browser_signal_ad_cost, std::optional<uint16_t> browser_signal_modeling_signals, uint8_t browser_signal_join_count, uint8_t browser_signal_recency, const ::url::Origin& browser_signal_seller_origin, const std::optional<::url::Origin>& browser_signal_top_level_seller_origin, std::optional<::base::TimeDelta> browser_signal_reporting_timeout, std::optional<uint32_t> bidding_signals_data_version, const std::optional<std::string>& aggregate_win_signals, uint64_t trace_id, ReportWinCallback callback) {
  GetForwardingInterface()->ReportWin(
    std::move(is_for_additional_bid)
    , 
    std::move(interest_group_name_reporting_id)
    , 
    std::move(buyer_reporting_id)
    , 
    std::move(buyer_and_seller_reporting_id)
    , 
    std::move(selected_buyer_and_seller_reporting_id)
    , 
    std::move(auction_signals_json)
    , 
    std::move(per_buyer_signals_json)
    , 
    std::move(direct_from_seller_per_buyer_signals)
    , 
    std::move(direct_from_seller_per_buyer_signals_header_ad_slot)
    , 
    std::move(direct_from_seller_auction_signals)
    , 
    std::move(direct_from_seller_auction_signals_header_ad_slot)
    , 
    std::move(seller_signals_json)
    , 
    std::move(kanon_status)
    , 
    std::move(browser_signal_render_url)
    , 
    std::move(browser_signal_bid)
    , 
    std::move(browser_signal_bid_currency)
    , 
    std::move(browser_signal_highest_scoring_other_bid)
    , 
    std::move(browser_signal_highest_scoring_other_bid_currency)
    , 
    std::move(browser_signal_made_highest_scoring_other_bid)
    , 
    std::move(browser_signal_ad_cost)
    , 
    std::move(browser_signal_modeling_signals)
    , 
    std::move(browser_signal_join_count)
    , 
    std::move(browser_signal_recency)
    , 
    std::move(browser_signal_seller_origin)
    , 
    std::move(browser_signal_top_level_seller_origin)
    , 
    std::move(browser_signal_reporting_timeout)
    , 
    std::move(bidding_signals_data_version)
    , 
    std::move(aggregate_win_signals)
    , 
    std::move(trace_id)
    , std::move(callback));
}
void BidderWorkletInterceptorForTesting::ConnectDevToolsAgent(::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> agent, uint32_t thread_index) {
  GetForwardingInterface()->ConnectDevToolsAgent(
    std::move(agent)
    , 
    std::move(thread_index)
    );
}
BidderWorkletAsyncWaiter::BidderWorkletAsyncWaiter(
    BidderWorklet* proxy) : proxy_(proxy) {}

BidderWorkletAsyncWaiter::~BidderWorkletAsyncWaiter() = default;


void BidderWorkletAsyncWaiter::ReportWin(
    bool is_for_additional_bid, const std::optional<std::string>& interest_group_name_reporting_id, const std::optional<std::string>& buyer_reporting_id, const std::optional<std::string>& buyer_and_seller_reporting_id, const std::optional<std::string>& selected_buyer_and_seller_reporting_id, const std::optional<std::string>& auction_signals_json, const std::optional<std::string>& per_buyer_signals_json, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<std::string>& direct_from_seller_per_buyer_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot, const std::string& seller_signals_json, KAnonymityStatus kanon_status, const ::GURL& browser_signal_render_url, double browser_signal_bid, const std::optional<::blink::AdCurrency>& browser_signal_bid_currency, double browser_signal_highest_scoring_other_bid, const std::optional<::blink::AdCurrency>& browser_signal_highest_scoring_other_bid_currency, bool browser_signal_made_highest_scoring_other_bid, std::optional<double> browser_signal_ad_cost, std::optional<uint16_t> browser_signal_modeling_signals, uint8_t browser_signal_join_count, uint8_t browser_signal_recency, const ::url::Origin& browser_signal_seller_origin, const std::optional<::url::Origin>& browser_signal_top_level_seller_origin, std::optional<::base::TimeDelta> browser_signal_reporting_timeout, std::optional<uint32_t> bidding_signals_data_version, const std::optional<std::string>& aggregate_win_signals, uint64_t trace_id, std::optional<::GURL>* out_report_url, base::flat_map<std::string, ::GURL>* out_ad_beacon_map, base::flat_map<std::string, std::string>* out_ad_macro_map, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr>* out_pa_requests, PrivateModelTrainingRequestDataPtr* out_pmt_request_data, BidderTimingMetricsPtr* out_timing_metrics, std::vector<std::string>* out_errors) {
  base::RunLoop loop;
  proxy_->ReportWin(
      std::move(is_for_additional_bid),
      std::move(interest_group_name_reporting_id),
      std::move(buyer_reporting_id),
      std::move(buyer_and_seller_reporting_id),
      std::move(selected_buyer_and_seller_reporting_id),
      std::move(auction_signals_json),
      std::move(per_buyer_signals_json),
      std::move(direct_from_seller_per_buyer_signals),
      std::move(direct_from_seller_per_buyer_signals_header_ad_slot),
      std::move(direct_from_seller_auction_signals),
      std::move(direct_from_seller_auction_signals_header_ad_slot),
      std::move(seller_signals_json),
      std::move(kanon_status),
      std::move(browser_signal_render_url),
      std::move(browser_signal_bid),
      std::move(browser_signal_bid_currency),
      std::move(browser_signal_highest_scoring_other_bid),
      std::move(browser_signal_highest_scoring_other_bid_currency),
      std::move(browser_signal_made_highest_scoring_other_bid),
      std::move(browser_signal_ad_cost),
      std::move(browser_signal_modeling_signals),
      std::move(browser_signal_join_count),
      std::move(browser_signal_recency),
      std::move(browser_signal_seller_origin),
      std::move(browser_signal_top_level_seller_origin),
      std::move(browser_signal_reporting_timeout),
      std::move(bidding_signals_data_version),
      std::move(aggregate_win_signals),
      std::move(trace_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::GURL>* out_report_url
,
             base::flat_map<std::string, ::GURL>* out_ad_beacon_map
,
             base::flat_map<std::string, std::string>* out_ad_macro_map
,
             std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr>* out_pa_requests
,
             PrivateModelTrainingRequestDataPtr* out_pmt_request_data
,
             BidderTimingMetricsPtr* out_timing_metrics
,
             std::vector<std::string>* out_errors
,
             const std::optional<::GURL>& report_url,
             const base::flat_map<std::string, ::GURL>& ad_beacon_map,
             const base::flat_map<std::string, std::string>& ad_macro_map,
             std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> pa_requests,
             PrivateModelTrainingRequestDataPtr pmt_request_data,
             BidderTimingMetricsPtr timing_metrics,
             const std::vector<std::string>& errors) {*out_report_url = std::move(report_url);*out_ad_beacon_map = std::move(ad_beacon_map);*out_ad_macro_map = std::move(ad_macro_map);*out_pa_requests = std::move(pa_requests);*out_pmt_request_data = std::move(pmt_request_data);*out_timing_metrics = std::move(timing_metrics);*out_errors = std::move(errors);
            loop->Quit();
          },
          &loop,
          out_report_url,
          out_ad_beacon_map,
          out_ad_macro_map,
          out_pa_requests,
          out_pmt_request_data,
          out_timing_metrics,
          out_errors));
  loop.Run();
}








}  // auction_worklet::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif