// content/services/auction_worklet/public/mojom/bidder_worklet.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_TEST_UTILS_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_TEST_UTILS_H_

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom.h"
#include "content/common/content_export.h"


namespace auction_worklet::mojom {


class CONTENT_EXPORT GenerateBidClientInterceptorForTesting : public GenerateBidClient {
  virtual GenerateBidClient* GetForwardingInterface() = 0;
  void OnBiddingSignalsReceived(const base::flat_map<std::string, double>& priority_vector, ::base::TimeDelta trusted_signals_fetch_latency, std::optional<::base::TimeDelta> update_if_older_than, OnBiddingSignalsReceivedCallback callback) override;
  void OnGenerateBidComplete(std::vector<BidderWorkletBidPtr> bids, std::optional<uint32_t> bidding_signals_data_version, const std::optional<::GURL>& debug_loss_report_url, const std::optional<::GURL>& debug_win_report_url, std::optional<double> set_priority, base::flat_map<std::string, PrioritySignalsDoublePtr> update_priority_signals_overrides, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> pa_requests, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> non_kanon_pa_requests, std::vector<::auction_worklet::mojom::RealTimeReportingContributionPtr> real_time_contributions, BidderTimingMetricsPtr generate_bid_timing_metrics, GenerateBidDependencyLatenciesPtr generate_bid_dependency_latencies, ::auction_worklet::mojom::RejectReason reject_reason, const std::vector<std::string>& errors) override;
};
class CONTENT_EXPORT GenerateBidClientAsyncWaiter {
 public:
  explicit GenerateBidClientAsyncWaiter(GenerateBidClient* proxy);

  GenerateBidClientAsyncWaiter(const GenerateBidClientAsyncWaiter&) = delete;
  GenerateBidClientAsyncWaiter& operator=(const GenerateBidClientAsyncWaiter&) = delete;

  ~GenerateBidClientAsyncWaiter();
  void OnBiddingSignalsReceived(
      const base::flat_map<std::string, double>& priority_vector, ::base::TimeDelta trusted_signals_fetch_latency, std::optional<::base::TimeDelta> update_if_older_than);
  

 private:
  GenerateBidClient* const proxy_;
};


class CONTENT_EXPORT GenerateBidFinalizerInterceptorForTesting : public GenerateBidFinalizer {
  virtual GenerateBidFinalizer* GetForwardingInterface() = 0;
  void FinishGenerateBid(const std::optional<std::string>& auction_signals_json, const std::optional<std::string>& per_buyer_signals_json, std::optional<::base::TimeDelta> per_buyer_timeout, const std::optional<::blink::AdCurrency>& expected_buyer_currency, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<std::string>& direct_from_seller_per_buyer_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot) override;
};
class CONTENT_EXPORT GenerateBidFinalizerAsyncWaiter {
 public:
  explicit GenerateBidFinalizerAsyncWaiter(GenerateBidFinalizer* proxy);

  GenerateBidFinalizerAsyncWaiter(const GenerateBidFinalizerAsyncWaiter&) = delete;
  GenerateBidFinalizerAsyncWaiter& operator=(const GenerateBidFinalizerAsyncWaiter&) = delete;

  ~GenerateBidFinalizerAsyncWaiter();

 private:
  GenerateBidFinalizer* const proxy_;
};


class CONTENT_EXPORT BidderWorkletInterceptorForTesting : public BidderWorklet {
  virtual BidderWorklet* GetForwardingInterface() = 0;
  void BeginGenerateBid(BidderWorkletNonSharedParamsPtr bidder_worklet_non_shared_params, ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr key_value_signals_cache_key, KAnonymityBidMode kanon_mode, const ::url::Origin& interest_group_join_origin, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<::GURL>& direct_from_seller_auction_signals, const ::url::Origin& browser_signal_seller_origin, const std::optional<::url::Origin>& browser_signal_top_level_seller_origin, ::base::TimeDelta browser_signal_recency, bool browser_signal_for_debugging_only_sampling, ::blink::mojom::BiddingBrowserSignalsPtr bidding_browser_signals, ::base::Time auction_start_time, const std::optional<::blink::AdSize>& requested_ad_size, uint16_t multi_bid_limit, uint64_t group_by_origin_id, uint64_t trace_id, ::mojo::PendingAssociatedRemote<GenerateBidClient> generate_bid_client, ::mojo::PendingAssociatedReceiver<GenerateBidFinalizer> bid_finalizer) override;
  void SendPendingSignalsRequests() override;
  void ReportWin(bool is_for_additional_bid, const std::optional<std::string>& interest_group_name_reporting_id, const std::optional<std::string>& buyer_reporting_id, const std::optional<std::string>& buyer_and_seller_reporting_id, const std::optional<std::string>& selected_buyer_and_seller_reporting_id, const std::optional<std::string>& auction_signals_json, const std::optional<std::string>& per_buyer_signals_json, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<std::string>& direct_from_seller_per_buyer_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot, const std::string& seller_signals_json, KAnonymityStatus kanon_status, const ::GURL& browser_signal_render_url, double browser_signal_bid, const std::optional<::blink::AdCurrency>& browser_signal_bid_currency, double browser_signal_highest_scoring_other_bid, const std::optional<::blink::AdCurrency>& browser_signal_highest_scoring_other_bid_currency, bool browser_signal_made_highest_scoring_other_bid, std::optional<double> browser_signal_ad_cost, std::optional<uint16_t> browser_signal_modeling_signals, uint8_t browser_signal_join_count, uint8_t browser_signal_recency, const ::url::Origin& browser_signal_seller_origin, const std::optional<::url::Origin>& browser_signal_top_level_seller_origin, std::optional<::base::TimeDelta> browser_signal_reporting_timeout, std::optional<uint32_t> bidding_signals_data_version, const std::optional<std::string>& aggregate_win_signals, uint64_t trace_id, ReportWinCallback callback) override;
  void ConnectDevToolsAgent(::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> agent, uint32_t thread_index) override;
};
class CONTENT_EXPORT BidderWorkletAsyncWaiter {
 public:
  explicit BidderWorkletAsyncWaiter(BidderWorklet* proxy);

  BidderWorkletAsyncWaiter(const BidderWorkletAsyncWaiter&) = delete;
  BidderWorkletAsyncWaiter& operator=(const BidderWorkletAsyncWaiter&) = delete;

  ~BidderWorkletAsyncWaiter();
  void ReportWin(
      bool is_for_additional_bid, const std::optional<std::string>& interest_group_name_reporting_id, const std::optional<std::string>& buyer_reporting_id, const std::optional<std::string>& buyer_and_seller_reporting_id, const std::optional<std::string>& selected_buyer_and_seller_reporting_id, const std::optional<std::string>& auction_signals_json, const std::optional<std::string>& per_buyer_signals_json, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<std::string>& direct_from_seller_per_buyer_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot, const std::string& seller_signals_json, KAnonymityStatus kanon_status, const ::GURL& browser_signal_render_url, double browser_signal_bid, const std::optional<::blink::AdCurrency>& browser_signal_bid_currency, double browser_signal_highest_scoring_other_bid, const std::optional<::blink::AdCurrency>& browser_signal_highest_scoring_other_bid_currency, bool browser_signal_made_highest_scoring_other_bid, std::optional<double> browser_signal_ad_cost, std::optional<uint16_t> browser_signal_modeling_signals, uint8_t browser_signal_join_count, uint8_t browser_signal_recency, const ::url::Origin& browser_signal_seller_origin, const std::optional<::url::Origin>& browser_signal_top_level_seller_origin, std::optional<::base::TimeDelta> browser_signal_reporting_timeout, std::optional<uint32_t> bidding_signals_data_version, const std::optional<std::string>& aggregate_win_signals, uint64_t trace_id, std::optional<::GURL>* out_report_url, base::flat_map<std::string, ::GURL>* out_ad_beacon_map, base::flat_map<std::string, std::string>* out_ad_macro_map, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr>* out_pa_requests, PrivateModelTrainingRequestDataPtr* out_pmt_request_data, BidderTimingMetricsPtr* out_timing_metrics, std::vector<std::string>* out_errors);
  

 private:
  BidderWorklet* const proxy_;
};




}  // auction_worklet::mojom

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_TEST_UTILS_H_