// content/public/common/resource_usage_reporter.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/public/common/resource_usage_reporter.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/public/common/resource_usage_reporter.mojom-params-data.h"
#include "content/public/common/resource_usage_reporter.mojom-shared-message-ids.h"

#include "content/public/common/resource_usage_reporter.mojom-import-headers.h"
#include "content/public/common/resource_usage_reporter.mojom-test-utils.h"


namespace content::mojom {
ResourceTypeStat::ResourceTypeStat()
    : count(0ULL),
      size(0ULL),
      live_size(0ULL),
      decoded_size(0ULL) {}

ResourceTypeStat::ResourceTypeStat(
    uint64_t count_in,
    uint64_t size_in,
    uint64_t live_size_in,
    uint64_t decoded_size_in)
    : count(std::move(count_in)),
      size(std::move(size_in)),
      live_size(std::move(live_size_in)),
      decoded_size(std::move(decoded_size_in)) {}

ResourceTypeStat::~ResourceTypeStat() = default;
size_t ResourceTypeStat::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->count);
  seed = mojo::internal::Hash(seed, this->size);
  seed = mojo::internal::Hash(seed, this->live_size);
  seed = mojo::internal::Hash(seed, this->decoded_size);
  return seed;
}

void ResourceTypeStat::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "count"), this->count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "live_size"), this->live_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decoded_size"), this->decoded_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResourceTypeStat::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResourceTypeStats::ResourceTypeStats()
    : images(),
      css_style_sheets(),
      scripts(),
      xsl_style_sheets(),
      fonts(),
      other() {}

ResourceTypeStats::ResourceTypeStats(
    ResourceTypeStatPtr images_in,
    ResourceTypeStatPtr css_style_sheets_in,
    ResourceTypeStatPtr scripts_in,
    ResourceTypeStatPtr xsl_style_sheets_in,
    ResourceTypeStatPtr fonts_in,
    ResourceTypeStatPtr other_in)
    : images(std::move(images_in)),
      css_style_sheets(std::move(css_style_sheets_in)),
      scripts(std::move(scripts_in)),
      xsl_style_sheets(std::move(xsl_style_sheets_in)),
      fonts(std::move(fonts_in)),
      other(std::move(other_in)) {}

ResourceTypeStats::~ResourceTypeStats() = default;
size_t ResourceTypeStats::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->images);
  seed = mojo::internal::Hash(seed, this->css_style_sheets);
  seed = mojo::internal::Hash(seed, this->scripts);
  seed = mojo::internal::Hash(seed, this->xsl_style_sheets);
  seed = mojo::internal::Hash(seed, this->fonts);
  seed = mojo::internal::Hash(seed, this->other);
  return seed;
}

void ResourceTypeStats::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "images"), this->images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResourceTypeStatPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "css_style_sheets"), this->css_style_sheets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResourceTypeStatPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scripts"), this->scripts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResourceTypeStatPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "xsl_style_sheets"), this->xsl_style_sheets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResourceTypeStatPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fonts"), this->fonts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResourceTypeStatPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "other"), this->other,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResourceTypeStatPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResourceTypeStats::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResourceUsageData::ResourceUsageData()
    : reports_v8_stats(false),
      v8_bytes_allocated(0ULL),
      v8_bytes_used(0ULL),
      web_cache_stats() {}

ResourceUsageData::ResourceUsageData(
    bool reports_v8_stats_in,
    uint64_t v8_bytes_allocated_in,
    uint64_t v8_bytes_used_in,
    ResourceTypeStatsPtr web_cache_stats_in)
    : reports_v8_stats(std::move(reports_v8_stats_in)),
      v8_bytes_allocated(std::move(v8_bytes_allocated_in)),
      v8_bytes_used(std::move(v8_bytes_used_in)),
      web_cache_stats(std::move(web_cache_stats_in)) {}

ResourceUsageData::~ResourceUsageData() = default;

void ResourceUsageData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reports_v8_stats"), this->reports_v8_stats,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "v8_bytes_allocated"), this->v8_bytes_allocated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "v8_bytes_used"), this->v8_bytes_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_cache_stats"), this->web_cache_stats,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResourceTypeStatsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResourceUsageData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ResourceUsageReporter::IPCStableHashFunction ResourceUsageReporter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ResourceUsageReporter>(message.name())) {
    case messages::ResourceUsageReporter::kGetUsageData: {
      return &ResourceUsageReporter::GetUsageData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ResourceUsageReporter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ResourceUsageReporter>(message.name())) {
      case messages::ResourceUsageReporter::kGetUsageData:
            return "Receive content::mojom::ResourceUsageReporter::GetUsageData";
    }
  } else {
    switch (static_cast<messages::ResourceUsageReporter>(message.name())) {
      case messages::ResourceUsageReporter::kGetUsageData:
            return "Receive reply content::mojom::ResourceUsageReporter::GetUsageData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ResourceUsageReporter::GetUsageData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x46dec7a4;  // IPCStableHash for content::mojom::ResourceUsageReporter::GetUsageData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ResourceUsageReporter_GetUsageData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ResourceUsageReporter_GetUsageData_ForwardToCallback(
      ResourceUsageReporter::GetUsageDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  ResourceUsageReporter_GetUsageData_ForwardToCallback(const ResourceUsageReporter_GetUsageData_ForwardToCallback&) = delete;
  ResourceUsageReporter_GetUsageData_ForwardToCallback& operator=(const ResourceUsageReporter_GetUsageData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ResourceUsageReporter::GetUsageDataCallback callback_;
};

ResourceUsageReporterProxy::ResourceUsageReporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ResourceUsageReporterProxy::GetUsageData(
    GetUsageDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::ResourceUsageReporter::GetUsageData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ResourceUsageReporter::kGetUsageData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ResourceUsageReporter_GetUsageData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceUsageReporter::Name_);
  message.set_method_name("GetUsageData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ResourceUsageReporter_GetUsageData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ResourceUsageReporter_GetUsageData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ResourceUsageReporter::GetUsageDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ResourceUsageReporter_GetUsageData_ProxyToResponder> proxy(
        new ResourceUsageReporter_GetUsageData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ResourceUsageReporter_GetUsageData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ResourceUsageReporter_GetUsageData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ResourceUsageReporter_GetUsageData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ResourceUsageReporter::GetUsageDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ResourceUsageDataPtr in_data);
};

bool ResourceUsageReporter_GetUsageData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ResourceUsageReporter_GetUsageData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ResourceUsageReporter_GetUsageData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ResourceUsageReporter.0
  bool success = true;
  ResourceUsageDataPtr p_data{};
  ResourceUsageReporter_GetUsageData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ResourceUsageReporter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void ResourceUsageReporter_GetUsageData_ProxyToResponder::Run(
    ResourceUsageDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply content::mojom::ResourceUsageReporter::GetUsageData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ResourceUsageDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ResourceUsageReporter::kGetUsageData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ResourceUsageReporter_GetUsageData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::ResourceUsageDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceUsageReporter::Name_);
  message.set_method_name("GetUsageData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ResourceUsageReporterStubDispatch::Accept(
    ResourceUsageReporter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ResourceUsageReporter>(message->header()->name)) {
    case messages::ResourceUsageReporter::kGetUsageData: {
      break;
    }
  }
  return false;
}

// static
bool ResourceUsageReporterStubDispatch::AcceptWithResponder(
    ResourceUsageReporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ResourceUsageReporter>(message->header()->name)) {
    case messages::ResourceUsageReporter::kGetUsageData: {
      internal::ResourceUsageReporter_GetUsageData_Params_Data* params =
          reinterpret_cast<
              internal::ResourceUsageReporter_GetUsageData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ResourceUsageReporter.0
      bool success = true;
      ResourceUsageReporter_GetUsageData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceUsageReporter::Name_, 0, false);
        return false;
      }
      auto callback =
          ResourceUsageReporter_GetUsageData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUsageData(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kResourceUsageReporterValidationInfo[] = {
    { &internal::ResourceUsageReporter_GetUsageData_Params_Data::Validate,
     &internal::ResourceUsageReporter_GetUsageData_ResponseParams_Data::Validate},
};

bool ResourceUsageReporterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::content::mojom::ResourceUsageReporter::Name_,
    kResourceUsageReporterValidationInfo);
}

bool ResourceUsageReporterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::content::mojom::ResourceUsageReporter::Name_,
    kResourceUsageReporterValidationInfo);
}


}  // content::mojom


namespace mojo {


// static
bool StructTraits<::content::mojom::ResourceTypeStat::DataView, ::content::mojom::ResourceTypeStatPtr>::Read(
    ::content::mojom::ResourceTypeStat::DataView input,
    ::content::mojom::ResourceTypeStatPtr* output) {
  bool success = true;
  ::content::mojom::ResourceTypeStatPtr result(::content::mojom::ResourceTypeStat::New());
  
      if (success)
        result->count = input.count();
      if (success)
        result->size = input.size();
      if (success)
        result->live_size = input.live_size();
      if (success)
        result->decoded_size = input.decoded_size();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::ResourceTypeStats::DataView, ::content::mojom::ResourceTypeStatsPtr>::Read(
    ::content::mojom::ResourceTypeStats::DataView input,
    ::content::mojom::ResourceTypeStatsPtr* output) {
  bool success = true;
  ::content::mojom::ResourceTypeStatsPtr result(::content::mojom::ResourceTypeStats::New());
  
      if (success && !input.ReadImages(&result->images))
        success = false;
      if (success && !input.ReadCssStyleSheets(&result->css_style_sheets))
        success = false;
      if (success && !input.ReadScripts(&result->scripts))
        success = false;
      if (success && !input.ReadXslStyleSheets(&result->xsl_style_sheets))
        success = false;
      if (success && !input.ReadFonts(&result->fonts))
        success = false;
      if (success && !input.ReadOther(&result->other))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::ResourceUsageData::DataView, ::content::mojom::ResourceUsageDataPtr>::Read(
    ::content::mojom::ResourceUsageData::DataView input,
    ::content::mojom::ResourceUsageDataPtr* output) {
  bool success = true;
  ::content::mojom::ResourceUsageDataPtr result(::content::mojom::ResourceUsageData::New());
  
      if (success)
        result->reports_v8_stats = input.reports_v8_stats();
      if (success)
        result->v8_bytes_allocated = input.v8_bytes_allocated();
      if (success)
        result->v8_bytes_used = input.v8_bytes_used();
      if (success && !input.ReadWebCacheStats(&result->web_cache_stats))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void ResourceUsageReporterInterceptorForTesting::GetUsageData(GetUsageDataCallback callback) {
  GetForwardingInterface()->GetUsageData(std::move(callback));
}
ResourceUsageReporterAsyncWaiter::ResourceUsageReporterAsyncWaiter(
    ResourceUsageReporter* proxy) : proxy_(proxy) {}

ResourceUsageReporterAsyncWaiter::~ResourceUsageReporterAsyncWaiter() = default;


void ResourceUsageReporterAsyncWaiter::GetUsageData(
    ResourceUsageDataPtr* out_data) {
  base::RunLoop loop;
  proxy_->GetUsageData(
      base::BindOnce(
          [](base::RunLoop* loop,
             ResourceUsageDataPtr* out_data
,
             ResourceUsageDataPtr data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

ResourceUsageDataPtr ResourceUsageReporterAsyncWaiter::GetUsageData(
    ) {
  ResourceUsageDataPtr async_wait_result;
  GetUsageData(&async_wait_result);
  return async_wait_result;
}






}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif