// content/common/renderer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDERER_MOJOM_H_
#define CONTENT_COMMON_RENDERER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/renderer.mojom-features.h"  // IWYU pragma: export
#include "content/common/renderer.mojom-shared.h"  // IWYU pragma: export
#include "content/common/renderer.mojom-forward.h"  // IWYU pragma: export
#include "content/common/agent_scheduling_group.mojom-forward.h"
#include "content/common/native_types.mojom.h"
#include "ipc/ipc.mojom-forward.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom-forward.h"
#include "mojo/public/mojom/base/process_priority.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/network_types.mojom.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom-forward.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trials_settings.mojom-forward.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "content/common/content_export.h"




namespace content::mojom {

class RendererProxy;

template <typename ImplRefTraits>
class RendererStub;

class RendererRequestValidator;
class RendererResponseValidator;


class CONTENT_EXPORT Renderer
    : public RendererInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.Renderer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererInterfaceBase;
  using Proxy_ = RendererProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererStub<ImplRefTraits>;

  using RequestValidator_ = RendererRequestValidator;
  using ResponseValidator_ = RendererResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateAgentSchedulingGroupMinVersion = 0,
    kCreateAssociatedAgentSchedulingGroupMinVersion = 0,
    kTransferSharedLastForegroundTimeMinVersion = 0,
    kOnNetworkConnectionChangedMinVersion = 0,
    kOnNetworkQualityChangedMinVersion = 0,
    kSetWebKitSharedTimersSuspendedMinVersion = 0,
    kUpdateScrollbarThemeMinVersion = 0,
    kOnSystemColorsChangedMinVersion = 0,
    kUpdateSystemColorInfoMinVersion = 0,
    kPurgePluginListCacheMinVersion = 0,
    kPurgeResourceCacheMinVersion = 0,
    kSetProcessStateMinVersion = 0,
    kSetIsLockedToSiteMinVersion = 0,
    kSetIsCrossOriginIsolatedMinVersion = 0,
    kSetIsWebSecurityDisabledMinVersion = 0,
    kSetIsIsolatedContextMinVersion = 0,
    kSetWebUIResourceUrlToCodeCacheMapMinVersion = 0,
    kInitializeRendererMinVersion = 0,
    kSetUserAgentMinVersion = 0,
    kPingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateAgentSchedulingGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateAssociatedAgentSchedulingGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TransferSharedLastForegroundTime_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNetworkConnectionChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNetworkQualityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWebKitSharedTimersSuspended_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateScrollbarTheme_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSystemColorsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateSystemColorInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PurgePluginListCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PurgeResourceCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetProcessState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsLockedToSite_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsCrossOriginIsolated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsWebSecurityDisabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsIsolatedContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWebUIResourceUrlToCodeCacheMap_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InitializeRenderer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUserAgent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Ping_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Renderer() = default;

  virtual void CreateAgentSchedulingGroup(::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap> bootstrap) = 0;

  virtual void CreateAssociatedAgentSchedulingGroup(::mojo::PendingAssociatedReceiver<::content::mojom::AgentSchedulingGroup> agent_scheduling_group) = 0;

  virtual void TransferSharedLastForegroundTime(::base::ReadOnlySharedMemoryRegion last_foreground_time_region) = 0;

  virtual void OnNetworkConnectionChanged(::net::NetworkChangeNotifier::ConnectionType connection_type, double max_bandwidth_mbps) = 0;

  virtual void OnNetworkQualityChanged(::net::EffectiveConnectionType effective_connection_type, ::base::TimeDelta http_rtt, ::base::TimeDelta transport_rtt, double bandwidth_kbps) = 0;

  virtual void SetWebKitSharedTimersSuspended(bool suspend) = 0;

  virtual void UpdateScrollbarTheme(UpdateScrollbarThemeParamsPtr params) = 0;

  virtual void OnSystemColorsChanged(int32_t aqua_color_variant) = 0;

  virtual void UpdateSystemColorInfo(UpdateSystemColorInfoParamsPtr params) = 0;

  virtual void PurgePluginListCache(bool reload_pages) = 0;

  using PurgeResourceCacheCallback = base::OnceCallback<void()>;
  using PurgeResourceCacheMojoCallback = base::OnceCallback<void()>;

  virtual void PurgeResourceCache(PurgeResourceCacheCallback callback) = 0;

  virtual void SetProcessState(::base::Process::Priority process_priority, RenderProcessVisibleState visible_state) = 0;

  virtual void SetIsLockedToSite() = 0;

  virtual void SetIsCrossOriginIsolated(bool value) = 0;

  virtual void SetIsWebSecurityDisabled(bool value) = 0;

  virtual void SetIsIsolatedContext(bool value) = 0;

  virtual void SetWebUIResourceUrlToCodeCacheMap(const base::flat_map<::GURL, int32_t>& resource_map) = 0;

  virtual void InitializeRenderer(const std::string& user_agent, const ::blink::UserAgentMetadata& metadata, const std::vector<std::string>& cors_exempt_header_list, ::blink::mojom::OriginTrialsSettingsPtr origin_trials_settings, uint64_t trace_id) = 0;

  virtual void SetUserAgent(const std::string& user_agent) = 0;

  using PingCallback = base::OnceCallback<void()>;
  using PingMojoCallback = base::OnceCallback<void()>;

  virtual void Ping(PingCallback callback) = 0;
};



class CONTENT_EXPORT RendererProxy
    : public Renderer {
 public:
  using InterfaceType = Renderer;

  explicit RendererProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateAgentSchedulingGroup(::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap> bootstrap) final;
  
  void CreateAssociatedAgentSchedulingGroup(::mojo::PendingAssociatedReceiver<::content::mojom::AgentSchedulingGroup> agent_scheduling_group) final;
  
  void TransferSharedLastForegroundTime(::base::ReadOnlySharedMemoryRegion last_foreground_time_region) final;
  
  void OnNetworkConnectionChanged(::net::NetworkChangeNotifier::ConnectionType connection_type, double max_bandwidth_mbps) final;
  
  void OnNetworkQualityChanged(::net::EffectiveConnectionType effective_connection_type, ::base::TimeDelta http_rtt, ::base::TimeDelta transport_rtt, double bandwidth_kbps) final;
  
  void SetWebKitSharedTimersSuspended(bool suspend) final;
  
  void UpdateScrollbarTheme(UpdateScrollbarThemeParamsPtr params) final;
  
  void OnSystemColorsChanged(int32_t aqua_color_variant) final;
  
  void UpdateSystemColorInfo(UpdateSystemColorInfoParamsPtr params) final;
  
  void PurgePluginListCache(bool reload_pages) final;
  
  void PurgeResourceCache(PurgeResourceCacheCallback callback) final;
  
  void SetProcessState(::base::Process::Priority process_priority, RenderProcessVisibleState visible_state) final;
  
  void SetIsLockedToSite() final;
  
  void SetIsCrossOriginIsolated(bool value) final;
  
  void SetIsWebSecurityDisabled(bool value) final;
  
  void SetIsIsolatedContext(bool value) final;
  
  void SetWebUIResourceUrlToCodeCacheMap(const base::flat_map<::GURL, int32_t>& resource_map) final;
  
  void InitializeRenderer(const std::string& user_agent, const ::blink::UserAgentMetadata& metadata, const std::vector<std::string>& cors_exempt_header_list, ::blink::mojom::OriginTrialsSettingsPtr origin_trials_settings, uint64_t trace_id) final;
  
  void SetUserAgent(const std::string& user_agent) final;
  
  void Ping(PingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT RendererStubDispatch {
 public:
  static bool Accept(Renderer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Renderer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Renderer>>
class RendererStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererStub() = default;
  ~RendererStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT RendererRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT RendererResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class CONTENT_EXPORT UpdateSystemColorInfoParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UpdateSystemColorInfoParams, T>::value>;
  using DataView = UpdateSystemColorInfoParamsDataView;
  using Data_ = internal::UpdateSystemColorInfoParams_Data;

  template <typename... Args>
  static UpdateSystemColorInfoParamsPtr New(Args&&... args) {
    return UpdateSystemColorInfoParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UpdateSystemColorInfoParamsPtr From(const U& u) {
    return mojo::TypeConverter<UpdateSystemColorInfoParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UpdateSystemColorInfoParams>::Convert(*this);
  }


  UpdateSystemColorInfoParams();

  explicit UpdateSystemColorInfoParams(
      std::optional<uint32_t> accent_color);


  ~UpdateSystemColorInfoParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UpdateSystemColorInfoParamsPtr>
  UpdateSystemColorInfoParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UpdateSystemColorInfoParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UpdateSystemColorInfoParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UpdateSystemColorInfoParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UpdateSystemColorInfoParams_UnserializedMessageContext<
            UserType, UpdateSystemColorInfoParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UpdateSystemColorInfoParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UpdateSystemColorInfoParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UpdateSystemColorInfoParams_UnserializedMessageContext<
            UserType, UpdateSystemColorInfoParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UpdateSystemColorInfoParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<uint32_t> accent_color;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class CONTENT_EXPORT UpdateScrollbarThemeParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UpdateScrollbarThemeParams, T>::value>;
  using DataView = UpdateScrollbarThemeParamsDataView;
  using Data_ = internal::UpdateScrollbarThemeParams_Data;

  template <typename... Args>
  static UpdateScrollbarThemeParamsPtr New(Args&&... args) {
    return UpdateScrollbarThemeParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UpdateScrollbarThemeParamsPtr From(const U& u) {
    return mojo::TypeConverter<UpdateScrollbarThemeParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UpdateScrollbarThemeParams>::Convert(*this);
  }


  UpdateScrollbarThemeParams();

  UpdateScrollbarThemeParams(
      bool has_initial_button_delay,
      float initial_button_delay,
      bool has_autoscroll_button_delay,
      float autoscroll_button_delay,
      bool jump_on_track_click,
      ::blink::ScrollerStyle preferred_scroller_style,
      bool redraw,
      bool scroll_view_rubber_banding);


  ~UpdateScrollbarThemeParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UpdateScrollbarThemeParamsPtr>
  UpdateScrollbarThemeParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UpdateScrollbarThemeParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UpdateScrollbarThemeParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UpdateScrollbarThemeParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UpdateScrollbarThemeParams_UnserializedMessageContext<
            UserType, UpdateScrollbarThemeParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UpdateScrollbarThemeParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UpdateScrollbarThemeParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UpdateScrollbarThemeParams_UnserializedMessageContext<
            UserType, UpdateScrollbarThemeParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UpdateScrollbarThemeParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool has_initial_button_delay;
  
  float initial_button_delay;
  
  bool has_autoscroll_button_delay;
  
  float autoscroll_button_delay;
  
  bool jump_on_track_click;
  
  ::blink::ScrollerStyle preferred_scroller_style;
  
  bool redraw;
  
  bool scroll_view_rubber_banding;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
UpdateScrollbarThemeParamsPtr UpdateScrollbarThemeParams::Clone() const {
  return New(
      mojo::Clone(has_initial_button_delay),
      mojo::Clone(initial_button_delay),
      mojo::Clone(has_autoscroll_button_delay),
      mojo::Clone(autoscroll_button_delay),
      mojo::Clone(jump_on_track_click),
      mojo::Clone(preferred_scroller_style),
      mojo::Clone(redraw),
      mojo::Clone(scroll_view_rubber_banding)
  );
}

template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>*>
bool UpdateScrollbarThemeParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_initial_button_delay, other_struct.has_initial_button_delay))
    return false;
  if (!mojo::Equals(this->initial_button_delay, other_struct.initial_button_delay))
    return false;
  if (!mojo::Equals(this->has_autoscroll_button_delay, other_struct.has_autoscroll_button_delay))
    return false;
  if (!mojo::Equals(this->autoscroll_button_delay, other_struct.autoscroll_button_delay))
    return false;
  if (!mojo::Equals(this->jump_on_track_click, other_struct.jump_on_track_click))
    return false;
  if (!mojo::Equals(this->preferred_scroller_style, other_struct.preferred_scroller_style))
    return false;
  if (!mojo::Equals(this->redraw, other_struct.redraw))
    return false;
  if (!mojo::Equals(this->scroll_view_rubber_banding, other_struct.scroll_view_rubber_banding))
    return false;
  return true;
}

template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.has_initial_button_delay < rhs.has_initial_button_delay)
    return true;
  if (rhs.has_initial_button_delay < lhs.has_initial_button_delay)
    return false;
  if (lhs.initial_button_delay < rhs.initial_button_delay)
    return true;
  if (rhs.initial_button_delay < lhs.initial_button_delay)
    return false;
  if (lhs.has_autoscroll_button_delay < rhs.has_autoscroll_button_delay)
    return true;
  if (rhs.has_autoscroll_button_delay < lhs.has_autoscroll_button_delay)
    return false;
  if (lhs.autoscroll_button_delay < rhs.autoscroll_button_delay)
    return true;
  if (rhs.autoscroll_button_delay < lhs.autoscroll_button_delay)
    return false;
  if (lhs.jump_on_track_click < rhs.jump_on_track_click)
    return true;
  if (rhs.jump_on_track_click < lhs.jump_on_track_click)
    return false;
  if (lhs.preferred_scroller_style < rhs.preferred_scroller_style)
    return true;
  if (rhs.preferred_scroller_style < lhs.preferred_scroller_style)
    return false;
  if (lhs.redraw < rhs.redraw)
    return true;
  if (rhs.redraw < lhs.redraw)
    return false;
  if (lhs.scroll_view_rubber_banding < rhs.scroll_view_rubber_banding)
    return true;
  if (rhs.scroll_view_rubber_banding < lhs.scroll_view_rubber_banding)
    return false;
  return false;
}
template <typename StructPtrType>
UpdateSystemColorInfoParamsPtr UpdateSystemColorInfoParams::Clone() const {
  return New(
      mojo::Clone(accent_color)
  );
}

template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>*>
bool UpdateSystemColorInfoParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->accent_color, other_struct.accent_color))
    return false;
  return true;
}

template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.accent_color < rhs.accent_color)
    return true;
  if (rhs.accent_color < lhs.accent_color)
    return false;
  return false;
}


}  // content::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::UpdateScrollbarThemeParams::DataView,
                                         ::content::mojom::UpdateScrollbarThemeParamsPtr> {
  static bool IsNull(const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::UpdateScrollbarThemeParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::has_initial_button_delay) has_initial_button_delay(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->has_initial_button_delay;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::initial_button_delay) initial_button_delay(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->initial_button_delay;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::has_autoscroll_button_delay) has_autoscroll_button_delay(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->has_autoscroll_button_delay;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::autoscroll_button_delay) autoscroll_button_delay(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->autoscroll_button_delay;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::jump_on_track_click) jump_on_track_click(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->jump_on_track_click;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::preferred_scroller_style) preferred_scroller_style(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->preferred_scroller_style;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::redraw) redraw(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->redraw;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::scroll_view_rubber_banding) scroll_view_rubber_banding(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->scroll_view_rubber_banding;
  }

  static bool Read(::content::mojom::UpdateScrollbarThemeParams::DataView input, ::content::mojom::UpdateScrollbarThemeParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::UpdateSystemColorInfoParams::DataView,
                                         ::content::mojom::UpdateSystemColorInfoParamsPtr> {
  static bool IsNull(const ::content::mojom::UpdateSystemColorInfoParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::UpdateSystemColorInfoParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::UpdateSystemColorInfoParams::accent_color) accent_color(
      const ::content::mojom::UpdateSystemColorInfoParamsPtr& input) {
    return input->accent_color;
  }

  static bool Read(::content::mojom::UpdateSystemColorInfoParams::DataView input, ::content::mojom::UpdateSystemColorInfoParamsPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_RENDERER_MOJOM_H_