// content/common/render_message_filter.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_SEND_VALIDATION_H_
#define CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_SEND_VALIDATION_H_

#include "content/common/render_message_filter.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"

#include "content/common/render_message_filter.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::FrameRoutingInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::FrameRoutingInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::FrameRoutingInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->routing_id = Traits::routing_id(input);

      decltype(Traits::frame_token(input)) in_frame_token = Traits::frame_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_token)::BaseType> frame_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView, send_validation>(
        in_frame_token,
        frame_token_fragment);

      fragment->frame_token.Set(
          frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_token in FrameRoutingInfo struct");

      decltype(Traits::devtools_frame_token(input)) in_devtools_frame_token = Traits::devtools_frame_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->devtools_frame_token)::BaseType> devtools_frame_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_devtools_frame_token,
        devtools_frame_token_fragment);

      fragment->devtools_frame_token.Set(
          devtools_frame_token_fragment.is_null() ? nullptr : devtools_frame_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->devtools_frame_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null devtools_frame_token in FrameRoutingInfo struct");

      decltype(Traits::document_token(input)) in_document_token = Traits::document_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->document_token)::BaseType> document_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::DocumentTokenDataView, send_validation>(
        in_document_token,
        document_token_fragment);

      fragment->document_token.Set(
          document_token_fragment.is_null() ? nullptr : document_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->document_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null document_token in FrameRoutingInfo struct");
  }
};

}  // namespace mojo::internal

#endif  // CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_SEND_VALIDATION_H_