// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{$}from"chrome://resources/js/util.js";import*as SDPUtils from"./sdp_utils.js";const MAX_NUMBER_OF_STATE_CHANGES_DISPLAYED=10;const MAX_NUMBER_OF_EXPANDED_MEDIASECTIONS=10;class PeerConnectionUpdateEntry{constructor(pid,lid,type,value){this.pid=pid;this.lid=lid;this.type=type;this.value=value}}export class PeerConnectionUpdateTable{constructor(){this.UPDATE_LOG_ID_SUFFIX_="-update-log";this.UPDATE_LOG_CONTAINER_CLASS_="update-log-container";this.UPDATE_LOG_TABLE_CLASS="update-log-table"}addPeerConnectionUpdate(peerConnectionElement,update){const tableElement=this.ensureUpdateContainer_(peerConnectionElement);const row=document.createElement("tr");tableElement.firstChild.appendChild(row);const time=new Date(parseFloat(update.time));const timeItem=document.createElement("td");timeItem.textContent=time.toLocaleString();row.appendChild(timeItem);let type=update.type;if(update.value.length===0){const typeItem=document.createElement("td");typeItem.textContent=type;row.appendChild(typeItem);return}if(update.type==="icecandidate"||update.type==="addIceCandidate"){const parts=JSON.parse(update.value);type+='(sdpMid="'+parts.sdpMid+'", '+"sdpMLineIndex="+parts.sdpMLineIndex;if(parts.candidate){const candidateParts=parts.candidate.split(" ");if(candidateParts&&candidateParts[7]){type+=", type: "+candidateParts[7]}if(parts[3]){type+=", "+parts[3]}if(parts[4]){type+=", "+parts[4]}}type+=")"}else if(update.type==="createOfferOnSuccess"||update.type==="createAnswerOnSuccess"){this.setLastOfferAnswer_(tableElement,update)}else if(update.type==="setLocalDescription"){const lastOfferAnswer=this.getLastOfferAnswer_(tableElement);if(update.value.startsWith("type: rollback")){this.setLastOfferAnswer_(tableElement,{value:undefined})}else if(lastOfferAnswer&&update.value!==lastOfferAnswer){type+=" (munged)"}}else if(update.type==="setConfiguration"){peerConnectionElement.firstChild.children[2].textContent=update.value}else if(["transceiverAdded","transceiverModified"].includes(update.type)){const data=JSON.parse(update.value);type+="(index="+data.transceiverIndex+", kind="+data.kind+")"}else if(["iceconnectionstatechange","connectionstatechange","signalingstatechange"].includes(update.type)){const fieldName={iceconnectionstatechange:"iceconnectionstate",connectionstatechange:"connectionstate",signalingstatechange:"signalingstate"}[update.type];const el=peerConnectionElement.getElementsByClassName(fieldName)[0];const numberOfEvents=el.textContent.split(" => ").length;if(numberOfEvents<MAX_NUMBER_OF_STATE_CHANGES_DISPLAYED){el.textContent+=" => "+update.value}else if(numberOfEvents>=MAX_NUMBER_OF_STATE_CHANGES_DISPLAYED){el.textContent+=" => ..."}}const summaryItem=$("summary-template").content.cloneNode(true);const summary=summaryItem.querySelector("summary");summary.textContent=type;row.appendChild(summaryItem);const valueContainer=document.createElement("pre");const details=row.cells[1].childNodes[0];details.appendChild(valueContainer);if(update.type==="iceconnectionstatechange"&&update.value==='"failed"'||update.type==="connectionstatechange"&&update.value==='"failed"'||update.type.indexOf("OnFailure")!==-1||update.type==="addIceCandidateFailed"){valueContainer.parentElement.classList.add("update-log-failure")}if(update.value.startsWith('{"type":')){const{type:type,sdp:sdp}=JSON.parse(update.value);if(type==="rollback"){summary.textContent+=' (type: "rollback")'}else{const copyBtn=document.createElement("button");copyBtn.textContent="Copy description to clipboard";copyBtn.onclick=()=>{navigator.clipboard.writeText(JSON.stringify({type:type,sdp:sdp}))};valueContainer.appendChild(copyBtn);let lastSections;const lastOfferAnswer=this.getLastOfferAnswer_(tableElement);if(update.type==="setLocalDescription"&&lastOfferAnswer&&lastOfferAnswer!==update.value){lastSections=SDPUtils.splitSections(lastOfferAnswer.substring(6).split(", sdp: ")[1])}const sections=SDPUtils.splitSections(sdp);summary.textContent+=' (type: "'+type+'", '+sections.length+" sections)";sections.forEach(((section,index)=>{const lines=SDPUtils.splitLines(section);const mid=lines.filter((line=>line.startsWith("a=mid:"))).map((line=>line.substring(6)))[0];const direction=SDPUtils.getDirection(section,sections[0]);const sectionDetails=document.createElement("details");const rejected=index!==0&&SDPUtils.parseMLine(lines[0]).port===0;sectionDetails.open=sections.length<=MAX_NUMBER_OF_EXPANDED_MEDIASECTIONS&&direction!=="inactive"&&!rejected;sectionDetails.textContent=lines.slice(1).join("\n");const sectionSummary=document.createElement("summary");sectionSummary.textContent=lines[0].trim()+" ("+(lines.length-1)+" more lines)"+(section.startsWith("m=")?" direction="+direction:"")+(mid?" mid="+mid:"");if(lastSections&&lastSections[index]!==sections[index]){sectionDetails.open=true;sectionSummary.textContent+=" munged";sectionSummary.style.backgroundColor="#FBCEB1";const lastLines=SDPUtils.splitLines(lastSections[index]);for(let i=0;i<lines.length&&i<lastLines.length;i++){if(lines[i]!==lastLines[i]){sectionSummary.title="First different line: "+lines[i];break}}}sectionDetails.appendChild(sectionSummary);valueContainer.appendChild(sectionDetails)}))}}else if(["icecandidate","addIceCandidate","transceiverAdded","transceiverModified"].includes(update.type)){const parts=JSON.parse(update.value);valueContainer.textContent=JSON.stringify(parts,null," ")}else{valueContainer.textContent=update.value}}ensureUpdateContainer_(peerConnectionElement){const tableId=peerConnectionElement.id+this.UPDATE_LOG_ID_SUFFIX_;let tableElement=document.getElementById(tableId);if(!tableElement){const tableContainer=document.createElement("div");tableContainer.className=this.UPDATE_LOG_CONTAINER_CLASS_;peerConnectionElement.appendChild(tableContainer);tableElement=document.createElement("table");tableElement.className=this.UPDATE_LOG_TABLE_CLASS;tableElement.id=tableId;tableElement.border=1;tableContainer.appendChild(tableElement);tableElement.appendChild($("time-event-template").content.cloneNode(true))}return tableElement}setLastOfferAnswer_(tableElement,update){tableElement["data-lastofferanswer"]=update.value}getLastOfferAnswer_(tableElement){return tableElement["data-lastofferanswer"]}}