// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{sendWithPromise}from"chrome://resources/js/cr.js";import{getRequiredElement}from"chrome://resources/js/util.js";let fetchDiffScheduler=null;const expandedEntries=new Set;let inMonitoringMode=false;function includeSubprocessMetrics(){const checkbox=getRequiredElement("subprocess_checkbox");return checkbox.checked}function sendRequest(handlerName){return sendWithPromise(handlerName,getQuery(),includeSubprocessMetrics())}function requestHistograms(){sendRequest("requestHistograms").then(addHistograms)}function clearHistograms(){getRequiredElement("histograms").innerHTML=window.trustedTypes.emptyHTML}function disableSubprocessCheckbox(){const subprocessCheckbox=getRequiredElement("subprocess_checkbox");subprocessCheckbox.disabled=true;subprocessCheckbox.title="Checkbox is disabled in Monitoring Mode. "+"To enable, switch to Histogram Mode first."}function enableSubprocessCheckbox(){const subprocessCheckbox=getRequiredElement("subprocess_checkbox");subprocessCheckbox.disabled=false;subprocessCheckbox.removeAttribute("title")}function startMonitoring(){const stopButton=getRequiredElement("stop");stopButton.disabled=false;stopButton.textContent="Stop";disableSubprocessCheckbox();clearHistograms();sendRequest("startMonitoring").then(fetchDiff)}function fetchDiff(){fetchDiffScheduler=setTimeout((function(){sendRequest("fetchDiff").then(addHistograms).then(fetchDiff)}),1e3)}function getQuery(){if(document.location.hash){return document.location.hash.substring(1)}else if(document.location.pathname){return document.location.pathname.substring(1)}return""}function enableMonitoring(){inMonitoringMode=true;getRequiredElement("accumulating_section").style.display="none";getRequiredElement("monitoring_section").style.display="block";expandedEntries.clear();startMonitoring()}function disableMonitoring(){inMonitoringMode=false;if(fetchDiffScheduler){clearTimeout(fetchDiffScheduler);fetchDiffScheduler=null}getRequiredElement("accumulating_section").style.display="block";getRequiredElement("monitoring_section").style.display="none";clearHistograms();enableSubprocessCheckbox();expandedEntries.clear();requestHistograms()}function stopMonitoring(){if(fetchDiffScheduler){clearTimeout(fetchDiffScheduler);fetchDiffScheduler=null}const stopButton=getRequiredElement("stop");stopButton.disabled=true;stopButton.textContent="Stopped"}export function monitoringStopped(){return inMonitoringMode&&!fetchDiffScheduler}function onHistogramHeaderClick(event){const headerElement=event.currentTarget;const name=headerElement.getAttribute("histogram-name");assert(name);const shouldExpand=!expandedEntries.has(name);if(shouldExpand){expandedEntries.add(name)}else{expandedEntries.delete(name)}setExpanded(headerElement.parentElement,shouldExpand)}function setExpanded(histogramNode,expanded){const body=histogramNode.querySelector(".histogram-body");const expand=histogramNode.querySelector(".expand");const collapse=histogramNode.querySelector(".collapse");assert(body&&expand&&collapse);body.style.display=expanded?"block":"none";expand.style.display=expanded?"none":"inline";collapse.style.display=expanded?"inline":"none"}function addHistograms(histograms){clearHistograms();for(const histogram of histograms){const{name:name,header:header,body:body}=histogram;const template=document.body.querySelector("#histogram-template");assert(template);const clone=template.content.cloneNode(true);const headerNode=clone.querySelector(".histogram-header");assert(headerNode);headerNode.setAttribute("histogram-name",name);headerNode.onclick=onHistogramHeaderClick;clone.querySelector(".histogram-header-text").textContent=header;const link=clone.querySelector(".histogram-header-link");assert(link);link.href="/#"+name;link.onclick=e=>e.stopPropagation();clone.querySelector("p").textContent=body;if(!inMonitoringMode){expandedEntries.add(name)}setExpanded(clone,expandedEntries.has(name));getRequiredElement("histograms").appendChild(clone)}getRequiredElement("histograms").dispatchEvent(new CustomEvent("histograms-updated-for-test"))}export function generateHistogramsAsText(){return getRequiredElement("histograms").innerText}function downloadHistograms(){const text=generateHistogramsAsText();if(text){const file=new Blob([text],{type:"text/plain"});const a=document.createElement("a");a.href=URL.createObjectURL(file);a.download="histograms.txt";a.click()}}function handleHashChange(){if(!inMonitoringMode){requestHistograms()}}document.addEventListener("DOMContentLoaded",(function(){getRequiredElement("refresh").onclick=requestHistograms;getRequiredElement("download").onclick=downloadHistograms;getRequiredElement("enable_monitoring").onclick=enableMonitoring;getRequiredElement("disable_monitoring").onclick=disableMonitoring;getRequiredElement("stop").onclick=stopMonitoring;getRequiredElement("subprocess_checkbox").onclick=requestHistograms;requestHistograms()}));window.onhashchange=handleHashChange;