// content/browser/private_aggregation/private_aggregation_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/browser/private_aggregation/private_aggregation_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/browser/private_aggregation/private_aggregation_internals.mojom-params-data.h"
#include "content/browser/private_aggregation/private_aggregation_internals.mojom-shared-message-ids.h"

#include "content/browser/private_aggregation/private_aggregation_internals.mojom-import-headers.h"
#include "content/browser/private_aggregation/private_aggregation_internals.mojom-test-utils.h"


namespace private_aggregation_internals::mojom {
AggregatableReportRequestID::AggregatableReportRequestID()
    : value() {}

AggregatableReportRequestID::AggregatableReportRequestID(
    int64_t value_in)
    : value(std::move(value_in)) {}

AggregatableReportRequestID::~AggregatableReportRequestID() = default;

void AggregatableReportRequestID::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatableReportRequestID::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregatableHistogramContribution::AggregatableHistogramContribution()
    : bucket(),
      value() {}

AggregatableHistogramContribution::AggregatableHistogramContribution(
    const ::absl::uint128& bucket_in,
    int32_t value_in)
    : bucket(std::move(bucket_in)),
      value(std::move(value_in)) {}

AggregatableHistogramContribution::~AggregatableHistogramContribution() = default;

void AggregatableHistogramContribution::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bucket"), this->bucket,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::absl::uint128&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatableHistogramContribution::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIAggregatableReport::WebUIAggregatableReport()
    : id(),
      report_time(),
      api_identifier(),
      api_version(),
      report_url(),
      contributions(),
      status(),
      report_body() {}

WebUIAggregatableReport::WebUIAggregatableReport(
    const std::optional<::content::AggregatableReportRequestStorageId>& id_in,
    double report_time_in,
    const std::string& api_identifier_in,
    const std::string& api_version_in,
    const ::GURL& report_url_in,
    std::vector<AggregatableHistogramContributionPtr> contributions_in,
    ReportStatus status_in,
    const std::string& report_body_in)
    : id(std::move(id_in)),
      report_time(std::move(report_time_in)),
      api_identifier(std::move(api_identifier_in)),
      api_version(std::move(api_version_in)),
      report_url(std::move(report_url_in)),
      contributions(std::move(contributions_in)),
      status(std::move(status_in)),
      report_body(std::move(report_body_in)) {}

WebUIAggregatableReport::~WebUIAggregatableReport() = default;

void WebUIAggregatableReport::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::content::AggregatableReportRequestStorageId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_time"), this->report_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "api_identifier"), this->api_identifier,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "api_version"), this->api_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_url"), this->report_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contributions"), this->contributions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AggregatableHistogramContributionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ReportStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_body"), this->report_body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUIAggregatableReport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

Observer::IPCStableHashFunction Observer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Observer>(message.name())) {
    case messages::Observer::kOnRequestStorageModified: {
      return &Observer::OnRequestStorageModified_Sym::IPCStableHash;
    }
    case messages::Observer::kOnReportHandled: {
      return &Observer::OnReportHandled_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Observer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Observer>(message.name())) {
      case messages::Observer::kOnRequestStorageModified:
            return "Receive private_aggregation_internals::mojom::Observer::OnRequestStorageModified";
      case messages::Observer::kOnReportHandled:
            return "Receive private_aggregation_internals::mojom::Observer::OnReportHandled";
    }
  } else {
    switch (static_cast<messages::Observer>(message.name())) {
      case messages::Observer::kOnRequestStorageModified:
            return "Receive reply private_aggregation_internals::mojom::Observer::OnRequestStorageModified";
      case messages::Observer::kOnReportHandled:
            return "Receive reply private_aggregation_internals::mojom::Observer::OnReportHandled";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Observer::OnRequestStorageModified_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00fc44d7;  // IPCStableHash for private_aggregation_internals::mojom::Observer::OnRequestStorageModified
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Observer::OnReportHandled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d81dafb;  // IPCStableHash for private_aggregation_internals::mojom::Observer::OnReportHandled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ObserverProxy::ObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ObserverProxy::OnRequestStorageModified(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send private_aggregation_internals::mojom::Observer::OnRequestStorageModified");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Observer::kOnRequestStorageModified), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::private_aggregation_internals::mojom::internal::Observer_OnRequestStorageModified_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Observer::Name_);
  message.set_method_name("OnRequestStorageModified");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ObserverProxy::OnReportHandled(
    WebUIAggregatableReportPtr in_report) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send private_aggregation_internals::mojom::Observer::OnReportHandled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report"), in_report,
                        "<value of type WebUIAggregatableReportPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Observer::kOnReportHandled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::private_aggregation_internals::mojom::internal::Observer_OnReportHandled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->report)::BaseType> report_fragment(
          params.message());
  
  mojo::internal::Serialize<::private_aggregation_internals::mojom::WebUIAggregatableReportDataView>(
    in_report,
    report_fragment);

  params->report.Set(
      report_fragment.is_null() ? nullptr : report_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->report.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null report in Observer.OnReportHandled request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Observer::Name_);
  message.set_method_name("OnReportHandled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ObserverStubDispatch::Accept(
    Observer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Observer>(message->header()->name)) {
    case messages::Observer::kOnRequestStorageModified: {
      DCHECK(message->is_serialized());
      internal::Observer_OnRequestStorageModified_Params_Data* params =
          reinterpret_cast<internal::Observer_OnRequestStorageModified_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Observer.0
      bool success = true;
      Observer_OnRequestStorageModified_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Observer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRequestStorageModified(        );
      return true;
    }
    case messages::Observer::kOnReportHandled: {
      DCHECK(message->is_serialized());
      internal::Observer_OnReportHandled_Params_Data* params =
          reinterpret_cast<internal::Observer_OnReportHandled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Observer.1
      bool success = true;
      WebUIAggregatableReportPtr p_report{};
      Observer_OnReportHandled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReport(&p_report))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Observer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReportHandled(        
        std::move(p_report));
      return true;
    }
  }
  return false;
}

// static
bool ObserverStubDispatch::AcceptWithResponder(
    Observer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Observer>(message->header()->name)) {
    case messages::Observer::kOnRequestStorageModified: {
      break;
    }
    case messages::Observer::kOnReportHandled: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kObserverValidationInfo[] = {
    { &internal::Observer_OnRequestStorageModified_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Observer_OnReportHandled_Params_Data::Validate,
     nullptr /* no response */},
};

bool ObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::private_aggregation_internals::mojom::Observer::Name_,
    kObserverValidationInfo);
}

// The declaration includes the definition on other builds.

Handler::IPCStableHashFunction Handler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Handler>(message.name())) {
    case messages::Handler::kGetReports: {
      return &Handler::GetReports_Sym::IPCStableHash;
    }
    case messages::Handler::kSendReports: {
      return &Handler::SendReports_Sym::IPCStableHash;
    }
    case messages::Handler::kClearStorage: {
      return &Handler::ClearStorage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Handler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Handler>(message.name())) {
      case messages::Handler::kGetReports:
            return "Receive private_aggregation_internals::mojom::Handler::GetReports";
      case messages::Handler::kSendReports:
            return "Receive private_aggregation_internals::mojom::Handler::SendReports";
      case messages::Handler::kClearStorage:
            return "Receive private_aggregation_internals::mojom::Handler::ClearStorage";
    }
  } else {
    switch (static_cast<messages::Handler>(message.name())) {
      case messages::Handler::kGetReports:
            return "Receive reply private_aggregation_internals::mojom::Handler::GetReports";
      case messages::Handler::kSendReports:
            return "Receive reply private_aggregation_internals::mojom::Handler::SendReports";
      case messages::Handler::kClearStorage:
            return "Receive reply private_aggregation_internals::mojom::Handler::ClearStorage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Handler::GetReports_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x825b57ff;  // IPCStableHash for private_aggregation_internals::mojom::Handler::GetReports
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Handler::SendReports_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6630139d;  // IPCStableHash for private_aggregation_internals::mojom::Handler::SendReports
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Handler::ClearStorage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9e883620;  // IPCStableHash for private_aggregation_internals::mojom::Handler::ClearStorage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Handler_GetReports_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Handler_GetReports_ForwardToCallback(
      Handler::GetReportsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Handler_GetReports_ForwardToCallback(const Handler_GetReports_ForwardToCallback&) = delete;
  Handler_GetReports_ForwardToCallback& operator=(const Handler_GetReports_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Handler::GetReportsCallback callback_;
};

class Handler_SendReports_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Handler_SendReports_ForwardToCallback(
      Handler::SendReportsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Handler_SendReports_ForwardToCallback(const Handler_SendReports_ForwardToCallback&) = delete;
  Handler_SendReports_ForwardToCallback& operator=(const Handler_SendReports_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Handler::SendReportsCallback callback_;
};

class Handler_ClearStorage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Handler_ClearStorage_ForwardToCallback(
      Handler::ClearStorageCallback callback
      ) : callback_(std::move(callback)) {
  }

  Handler_ClearStorage_ForwardToCallback(const Handler_ClearStorage_ForwardToCallback&) = delete;
  Handler_ClearStorage_ForwardToCallback& operator=(const Handler_ClearStorage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Handler::ClearStorageCallback callback_;
};

HandlerProxy::HandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HandlerProxy::GetReports(
    GetReportsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send private_aggregation_internals::mojom::Handler::GetReports");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Handler::kGetReports), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::private_aggregation_internals::mojom::internal::Handler_GetReports_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Handler::Name_);
  message.set_method_name("GetReports");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Handler_GetReports_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HandlerProxy::SendReports(
    const std::vector<::content::AggregatableReportRequestStorageId>& in_ids, SendReportsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send private_aggregation_internals::mojom::Handler::SendReports", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ids"), in_ids,
                        "<value of type const std::vector<::content::AggregatableReportRequestStorageId>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Handler::kSendReports), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::private_aggregation_internals::mojom::internal::Handler_SendReports_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ids)::BaseType>
      ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView>>(
    in_ids,
    ids_fragment,
    &ids_validate_params);

  params->ids.Set(
      ids_fragment.is_null() ? nullptr : ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ids in Handler.SendReports request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Handler::Name_);
  message.set_method_name("SendReports");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Handler_SendReports_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HandlerProxy::ClearStorage(
    ClearStorageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send private_aggregation_internals::mojom::Handler::ClearStorage");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Handler::kClearStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::private_aggregation_internals::mojom::internal::Handler_ClearStorage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Handler::Name_);
  message.set_method_name("ClearStorage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Handler_ClearStorage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Handler_GetReports_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Handler::GetReportsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Handler_GetReports_ProxyToResponder> proxy(
        new Handler_GetReports_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Handler_GetReports_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Handler_GetReports_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Handler_GetReports_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Handler::GetReportsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<WebUIAggregatableReportPtr> in_reports);
};

bool Handler_GetReports_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Handler_GetReports_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Handler_GetReports_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Handler.0
  bool success = true;
  std::vector<WebUIAggregatableReportPtr> p_reports{};
  Handler_GetReports_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadReports(&p_reports))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Handler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_reports));
  }
  return true;
}

void Handler_GetReports_ProxyToResponder::Run(
    std::vector<WebUIAggregatableReportPtr> in_reports) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply private_aggregation_internals::mojom::Handler::GetReports", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reports"), in_reports,
                        "<value of type std::vector<WebUIAggregatableReportPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Handler::kGetReports), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::private_aggregation_internals::mojom::internal::Handler_GetReports_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reports)::BaseType>
      reports_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& reports_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::private_aggregation_internals::mojom::WebUIAggregatableReportDataView>>(
    in_reports,
    reports_fragment,
    &reports_validate_params);

  params->reports.Set(
      reports_fragment.is_null() ? nullptr : reports_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reports.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reports in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Handler::Name_);
  message.set_method_name("GetReports");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Handler_SendReports_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Handler::SendReportsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Handler_SendReports_ProxyToResponder> proxy(
        new Handler_SendReports_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Handler_SendReports_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Handler_SendReports_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Handler_SendReports_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Handler::SendReportsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Handler_SendReports_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Handler_SendReports_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Handler_SendReports_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Handler.1
  bool success = true;
  Handler_SendReports_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Handler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Handler_SendReports_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply private_aggregation_internals::mojom::Handler::SendReports");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Handler::kSendReports), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::private_aggregation_internals::mojom::internal::Handler_SendReports_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Handler::Name_);
  message.set_method_name("SendReports");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Handler_ClearStorage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Handler::ClearStorageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Handler_ClearStorage_ProxyToResponder> proxy(
        new Handler_ClearStorage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Handler_ClearStorage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Handler_ClearStorage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Handler_ClearStorage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Handler::ClearStorageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Handler_ClearStorage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Handler_ClearStorage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Handler_ClearStorage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Handler.2
  bool success = true;
  Handler_ClearStorage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Handler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Handler_ClearStorage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply private_aggregation_internals::mojom::Handler::ClearStorage");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Handler::kClearStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::private_aggregation_internals::mojom::internal::Handler_ClearStorage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Handler::Name_);
  message.set_method_name("ClearStorage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HandlerStubDispatch::Accept(
    Handler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Handler>(message->header()->name)) {
    case messages::Handler::kGetReports: {
      break;
    }
    case messages::Handler::kSendReports: {
      break;
    }
    case messages::Handler::kClearStorage: {
      break;
    }
  }
  return false;
}

// static
bool HandlerStubDispatch::AcceptWithResponder(
    Handler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Handler>(message->header()->name)) {
    case messages::Handler::kGetReports: {
      internal::Handler_GetReports_Params_Data* params =
          reinterpret_cast<
              internal::Handler_GetReports_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Handler.0
      bool success = true;
      Handler_GetReports_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Handler::Name_, 0, false);
        return false;
      }
      auto callback =
          Handler_GetReports_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetReports(std::move(callback));
      return true;
    }
    case messages::Handler::kSendReports: {
      internal::Handler_SendReports_Params_Data* params =
          reinterpret_cast<
              internal::Handler_SendReports_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Handler.1
      bool success = true;
      std::vector<::content::AggregatableReportRequestStorageId> p_ids{};
      Handler_SendReports_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIds(&p_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Handler::Name_, 1, false);
        return false;
      }
      auto callback =
          Handler_SendReports_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendReports(        
        std::move(p_ids), std::move(callback));
      return true;
    }
    case messages::Handler::kClearStorage: {
      internal::Handler_ClearStorage_Params_Data* params =
          reinterpret_cast<
              internal::Handler_ClearStorage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Handler.2
      bool success = true;
      Handler_ClearStorage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Handler::Name_, 2, false);
        return false;
      }
      auto callback =
          Handler_ClearStorage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearStorage(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHandlerValidationInfo[] = {
    { &internal::Handler_GetReports_Params_Data::Validate,
     &internal::Handler_GetReports_ResponseParams_Data::Validate},
    { &internal::Handler_SendReports_Params_Data::Validate,
     &internal::Handler_SendReports_ResponseParams_Data::Validate},
    { &internal::Handler_ClearStorage_Params_Data::Validate,
     &internal::Handler_ClearStorage_ResponseParams_Data::Validate},
};

bool HandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::private_aggregation_internals::mojom::Handler::Name_,
    kHandlerValidationInfo);
}

bool HandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::private_aggregation_internals::mojom::Handler::Name_,
    kHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Factory::IPCStableHashFunction Factory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Factory>(message.name())) {
    case messages::Factory::kCreate: {
      return &Factory::Create_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Factory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Factory>(message.name())) {
      case messages::Factory::kCreate:
            return "Receive private_aggregation_internals::mojom::Factory::Create";
    }
  } else {
    switch (static_cast<messages::Factory>(message.name())) {
      case messages::Factory::kCreate:
            return "Receive reply private_aggregation_internals::mojom::Factory::Create";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Factory::Create_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd821372b;  // IPCStableHash for private_aggregation_internals::mojom::Factory::Create
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FactoryProxy::FactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FactoryProxy::Create(
    ::mojo::PendingRemote<Observer> in_observer, ::mojo::PendingReceiver<Handler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send private_aggregation_internals::mojom::Factory::Create", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<Observer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<Handler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Factory::kCreate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::private_aggregation_internals::mojom::internal::Factory_Create_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::private_aggregation_internals::mojom::ObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in Factory.Create request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::private_aggregation_internals::mojom::HandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in Factory.Create request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Factory::Name_);
  message.set_method_name("Create");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FactoryStubDispatch::Accept(
    Factory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Factory>(message->header()->name)) {
    case messages::Factory::kCreate: {
      DCHECK(message->is_serialized());
      internal::Factory_Create_Params_Data* params =
          reinterpret_cast<internal::Factory_Create_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Factory.0
      bool success = true;
      ::mojo::PendingRemote<Observer> p_observer{};
      ::mojo::PendingReceiver<Handler> p_handler{};
      Factory_Create_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Factory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Create(        
        std::move(p_observer), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool FactoryStubDispatch::AcceptWithResponder(
    Factory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Factory>(message->header()->name)) {
    case messages::Factory::kCreate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFactoryValidationInfo[] = {
    { &internal::Factory_Create_Params_Data::Validate,
     nullptr /* no response */},
};

bool FactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::private_aggregation_internals::mojom::Factory::Name_,
    kFactoryValidationInfo);
}



}  // private_aggregation_internals::mojom


namespace mojo {


// static
bool StructTraits<::private_aggregation_internals::mojom::AggregatableReportRequestID::DataView, ::private_aggregation_internals::mojom::AggregatableReportRequestIDPtr>::Read(
    ::private_aggregation_internals::mojom::AggregatableReportRequestID::DataView input,
    ::private_aggregation_internals::mojom::AggregatableReportRequestIDPtr* output) {
  bool success = true;
  ::private_aggregation_internals::mojom::AggregatableReportRequestIDPtr result(::private_aggregation_internals::mojom::AggregatableReportRequestID::New());
  
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::private_aggregation_internals::mojom::AggregatableHistogramContribution::DataView, ::private_aggregation_internals::mojom::AggregatableHistogramContributionPtr>::Read(
    ::private_aggregation_internals::mojom::AggregatableHistogramContribution::DataView input,
    ::private_aggregation_internals::mojom::AggregatableHistogramContributionPtr* output) {
  bool success = true;
  ::private_aggregation_internals::mojom::AggregatableHistogramContributionPtr result(::private_aggregation_internals::mojom::AggregatableHistogramContribution::New());
  
      if (success && !input.ReadBucket(&result->bucket))
        success = false;
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::private_aggregation_internals::mojom::WebUIAggregatableReport::DataView, ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr>::Read(
    ::private_aggregation_internals::mojom::WebUIAggregatableReport::DataView input,
    ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr* output) {
  bool success = true;
  ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr result(::private_aggregation_internals::mojom::WebUIAggregatableReport::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success)
        result->report_time = input.report_time();
      if (success && !input.ReadApiIdentifier(&result->api_identifier))
        success = false;
      if (success && !input.ReadApiVersion(&result->api_version))
        success = false;
      if (success && !input.ReadReportUrl(&result->report_url))
        success = false;
      if (success && !input.ReadContributions(&result->contributions))
        success = false;
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success && !input.ReadReportBody(&result->report_body))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace private_aggregation_internals::mojom {


void ObserverInterceptorForTesting::OnRequestStorageModified() {
  GetForwardingInterface()->OnRequestStorageModified();
}
void ObserverInterceptorForTesting::OnReportHandled(WebUIAggregatableReportPtr report) {
  GetForwardingInterface()->OnReportHandled(
    std::move(report)
    );
}
ObserverAsyncWaiter::ObserverAsyncWaiter(
    Observer* proxy) : proxy_(proxy) {}

ObserverAsyncWaiter::~ObserverAsyncWaiter() = default;





void HandlerInterceptorForTesting::GetReports(GetReportsCallback callback) {
  GetForwardingInterface()->GetReports(std::move(callback));
}
void HandlerInterceptorForTesting::SendReports(const std::vector<::content::AggregatableReportRequestStorageId>& ids, SendReportsCallback callback) {
  GetForwardingInterface()->SendReports(
    std::move(ids)
    , std::move(callback));
}
void HandlerInterceptorForTesting::ClearStorage(ClearStorageCallback callback) {
  GetForwardingInterface()->ClearStorage(std::move(callback));
}
HandlerAsyncWaiter::HandlerAsyncWaiter(
    Handler* proxy) : proxy_(proxy) {}

HandlerAsyncWaiter::~HandlerAsyncWaiter() = default;


void HandlerAsyncWaiter::GetReports(
    std::vector<WebUIAggregatableReportPtr>* out_reports) {
  base::RunLoop loop;
  proxy_->GetReports(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<WebUIAggregatableReportPtr>* out_reports
,
             std::vector<WebUIAggregatableReportPtr> reports) {*out_reports = std::move(reports);
            loop->Quit();
          },
          &loop,
          out_reports));
  loop.Run();
}

std::vector<WebUIAggregatableReportPtr> HandlerAsyncWaiter::GetReports(
    ) {
  std::vector<WebUIAggregatableReportPtr> async_wait_result;
  GetReports(&async_wait_result);
  return async_wait_result;
}

void HandlerAsyncWaiter::SendReports(
    const std::vector<::content::AggregatableReportRequestStorageId>& ids) {
  base::RunLoop loop;
  proxy_->SendReports(
      std::move(ids),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void HandlerAsyncWaiter::ClearStorage(
    ) {
  base::RunLoop loop;
  proxy_->ClearStorage(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void FactoryInterceptorForTesting::Create(::mojo::PendingRemote<Observer> observer, ::mojo::PendingReceiver<Handler> handler) {
  GetForwardingInterface()->Create(
    std::move(observer)
    , 
    std::move(handler)
    );
}
FactoryAsyncWaiter::FactoryAsyncWaiter(
    Factory* proxy) : proxy_(proxy) {}

FactoryAsyncWaiter::~FactoryAsyncWaiter() = default;







}  // private_aggregation_internals::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif