// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/devtools/protocol/page.h"

#include "content/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace content {
namespace protocol {
namespace Page {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Page";
const char Metainfo::commandPrefix[] = "Page.";
const char Metainfo::version[] = "1.3";


namespace TransitionTypeEnum {
const char Link[] = "link";
const char Typed[] = "typed";
const char Address_bar[] = "address_bar";
const char Auto_bookmark[] = "auto_bookmark";
const char Auto_subframe[] = "auto_subframe";
const char Manual_subframe[] = "manual_subframe";
const char Generated[] = "generated";
const char Auto_toplevel[] = "auto_toplevel";
const char Form_submit[] = "form_submit";
const char Reload[] = "reload";
const char Keyword[] = "keyword";
const char Keyword_generated[] = "keyword_generated";
const char Other[] = "other";
} // namespace TransitionTypeEnum


CRDTP_BEGIN_DESERIALIZER(NavigationEntry)
    CRDTP_DESERIALIZE_FIELD("id", m_id),
    CRDTP_DESERIALIZE_FIELD("title", m_title),
    CRDTP_DESERIALIZE_FIELD("transitionType", m_transitionType),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
    CRDTP_DESERIALIZE_FIELD("userTypedURL", m_userTypedURL),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(NavigationEntry)
    CRDTP_SERIALIZE_FIELD("id", m_id);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("userTypedURL", m_userTypedURL);
    CRDTP_SERIALIZE_FIELD("title", m_title);
    CRDTP_SERIALIZE_FIELD("transitionType", m_transitionType);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ScreencastFrameMetadata)
    CRDTP_DESERIALIZE_FIELD("deviceHeight", m_deviceHeight),
    CRDTP_DESERIALIZE_FIELD("deviceWidth", m_deviceWidth),
    CRDTP_DESERIALIZE_FIELD("offsetTop", m_offsetTop),
    CRDTP_DESERIALIZE_FIELD("pageScaleFactor", m_pageScaleFactor),
    CRDTP_DESERIALIZE_FIELD("scrollOffsetX", m_scrollOffsetX),
    CRDTP_DESERIALIZE_FIELD("scrollOffsetY", m_scrollOffsetY),
    CRDTP_DESERIALIZE_FIELD_OPT("timestamp", m_timestamp),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ScreencastFrameMetadata)
    CRDTP_SERIALIZE_FIELD("offsetTop", m_offsetTop);
    CRDTP_SERIALIZE_FIELD("pageScaleFactor", m_pageScaleFactor);
    CRDTP_SERIALIZE_FIELD("deviceWidth", m_deviceWidth);
    CRDTP_SERIALIZE_FIELD("deviceHeight", m_deviceHeight);
    CRDTP_SERIALIZE_FIELD("scrollOffsetX", m_scrollOffsetX);
    CRDTP_SERIALIZE_FIELD("scrollOffsetY", m_scrollOffsetY);
    CRDTP_SERIALIZE_FIELD("timestamp", m_timestamp);
CRDTP_END_SERIALIZER();


namespace DialogTypeEnum {
const char Alert[] = "alert";
const char Confirm[] = "confirm";
const char Prompt[] = "prompt";
const char Beforeunload[] = "beforeunload";
} // namespace DialogTypeEnum


CRDTP_BEGIN_DESERIALIZER(AppManifestError)
    CRDTP_DESERIALIZE_FIELD("column", m_column),
    CRDTP_DESERIALIZE_FIELD("critical", m_critical),
    CRDTP_DESERIALIZE_FIELD("line", m_line),
    CRDTP_DESERIALIZE_FIELD("message", m_message),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AppManifestError)
    CRDTP_SERIALIZE_FIELD("message", m_message);
    CRDTP_SERIALIZE_FIELD("critical", m_critical);
    CRDTP_SERIALIZE_FIELD("line", m_line);
    CRDTP_SERIALIZE_FIELD("column", m_column);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AppManifestParsedProperties)
    CRDTP_DESERIALIZE_FIELD("scope", m_scope),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AppManifestParsedProperties)
    CRDTP_SERIALIZE_FIELD("scope", m_scope);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Viewport)
    CRDTP_DESERIALIZE_FIELD("height", m_height),
    CRDTP_DESERIALIZE_FIELD("scale", m_scale),
    CRDTP_DESERIALIZE_FIELD("width", m_width),
    CRDTP_DESERIALIZE_FIELD("x", m_x),
    CRDTP_DESERIALIZE_FIELD("y", m_y),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Viewport)
    CRDTP_SERIALIZE_FIELD("x", m_x);
    CRDTP_SERIALIZE_FIELD("y", m_y);
    CRDTP_SERIALIZE_FIELD("width", m_width);
    CRDTP_SERIALIZE_FIELD("height", m_height);
    CRDTP_SERIALIZE_FIELD("scale", m_scale);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(InstallabilityErrorArgument)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(InstallabilityErrorArgument)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(InstallabilityError)
    CRDTP_DESERIALIZE_FIELD("errorArguments", m_errorArguments),
    CRDTP_DESERIALIZE_FIELD("errorId", m_errorId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(InstallabilityError)
    CRDTP_SERIALIZE_FIELD("errorId", m_errorId);
    CRDTP_SERIALIZE_FIELD("errorArguments", m_errorArguments);
CRDTP_END_SERIALIZER();


namespace ReferrerPolicyEnum {
const char NoReferrer[] = "noReferrer";
const char NoReferrerWhenDowngrade[] = "noReferrerWhenDowngrade";
const char Origin[] = "origin";
const char OriginWhenCrossOrigin[] = "originWhenCrossOrigin";
const char SameOrigin[] = "sameOrigin";
const char StrictOrigin[] = "strictOrigin";
const char StrictOriginWhenCrossOrigin[] = "strictOriginWhenCrossOrigin";
const char UnsafeUrl[] = "unsafeUrl";
} // namespace ReferrerPolicyEnum


CRDTP_BEGIN_DESERIALIZER(FileFilter)
    CRDTP_DESERIALIZE_FIELD_OPT("accepts", m_accepts),
    CRDTP_DESERIALIZE_FIELD_OPT("name", m_name),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FileFilter)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("accepts", m_accepts);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FileHandler)
    CRDTP_DESERIALIZE_FIELD_OPT("accepts", m_accepts),
    CRDTP_DESERIALIZE_FIELD("action", m_action),
    CRDTP_DESERIALIZE_FIELD_OPT("icons", m_icons),
    CRDTP_DESERIALIZE_FIELD("launchType", m_launchType),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FileHandler)
    CRDTP_SERIALIZE_FIELD("action", m_action);
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("icons", m_icons);
    CRDTP_SERIALIZE_FIELD("accepts", m_accepts);
    CRDTP_SERIALIZE_FIELD("launchType", m_launchType);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ImageResource)
    CRDTP_DESERIALIZE_FIELD_OPT("sizes", m_sizes),
    CRDTP_DESERIALIZE_FIELD_OPT("type", m_type),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ImageResource)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("sizes", m_sizes);
    CRDTP_SERIALIZE_FIELD("type", m_type);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(LaunchHandler)
    CRDTP_DESERIALIZE_FIELD("clientMode", m_clientMode),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(LaunchHandler)
    CRDTP_SERIALIZE_FIELD("clientMode", m_clientMode);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ProtocolHandler)
    CRDTP_DESERIALIZE_FIELD("protocol", m_protocol),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ProtocolHandler)
    CRDTP_SERIALIZE_FIELD("protocol", m_protocol);
    CRDTP_SERIALIZE_FIELD("url", m_url);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(RelatedApplication)
    CRDTP_DESERIALIZE_FIELD_OPT("id", m_id),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(RelatedApplication)
    CRDTP_SERIALIZE_FIELD("id", m_id);
    CRDTP_SERIALIZE_FIELD("url", m_url);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ScopeExtension)
    CRDTP_DESERIALIZE_FIELD("hasOriginWildcard", m_hasOriginWildcard),
    CRDTP_DESERIALIZE_FIELD("origin", m_origin),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ScopeExtension)
    CRDTP_SERIALIZE_FIELD("origin", m_origin);
    CRDTP_SERIALIZE_FIELD("hasOriginWildcard", m_hasOriginWildcard);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Screenshot)
    CRDTP_DESERIALIZE_FIELD("formFactor", m_formFactor),
    CRDTP_DESERIALIZE_FIELD("image", m_image),
    CRDTP_DESERIALIZE_FIELD_OPT("label", m_label),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Screenshot)
    CRDTP_SERIALIZE_FIELD("image", m_image);
    CRDTP_SERIALIZE_FIELD("formFactor", m_formFactor);
    CRDTP_SERIALIZE_FIELD("label", m_label);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ShareTarget)
    CRDTP_DESERIALIZE_FIELD("action", m_action),
    CRDTP_DESERIALIZE_FIELD("enctype", m_enctype),
    CRDTP_DESERIALIZE_FIELD_OPT("files", m_files),
    CRDTP_DESERIALIZE_FIELD("method", m_method),
    CRDTP_DESERIALIZE_FIELD_OPT("text", m_text),
    CRDTP_DESERIALIZE_FIELD_OPT("title", m_title),
    CRDTP_DESERIALIZE_FIELD_OPT("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ShareTarget)
    CRDTP_SERIALIZE_FIELD("action", m_action);
    CRDTP_SERIALIZE_FIELD("method", m_method);
    CRDTP_SERIALIZE_FIELD("enctype", m_enctype);
    CRDTP_SERIALIZE_FIELD("title", m_title);
    CRDTP_SERIALIZE_FIELD("text", m_text);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("files", m_files);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Shortcut)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Shortcut)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("url", m_url);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(WebAppManifest)
    CRDTP_DESERIALIZE_FIELD_OPT("backgroundColor", m_backgroundColor),
    CRDTP_DESERIALIZE_FIELD_OPT("description", m_description),
    CRDTP_DESERIALIZE_FIELD_OPT("dir", m_dir),
    CRDTP_DESERIALIZE_FIELD_OPT("display", m_display),
    CRDTP_DESERIALIZE_FIELD_OPT("displayOverrides", m_displayOverrides),
    CRDTP_DESERIALIZE_FIELD_OPT("fileHandlers", m_fileHandlers),
    CRDTP_DESERIALIZE_FIELD_OPT("icons", m_icons),
    CRDTP_DESERIALIZE_FIELD_OPT("id", m_id),
    CRDTP_DESERIALIZE_FIELD_OPT("lang", m_lang),
    CRDTP_DESERIALIZE_FIELD_OPT("launchHandler", m_launchHandler),
    CRDTP_DESERIALIZE_FIELD_OPT("name", m_name),
    CRDTP_DESERIALIZE_FIELD_OPT("orientation", m_orientation),
    CRDTP_DESERIALIZE_FIELD_OPT("preferRelatedApplications", m_preferRelatedApplications),
    CRDTP_DESERIALIZE_FIELD_OPT("protocolHandlers", m_protocolHandlers),
    CRDTP_DESERIALIZE_FIELD_OPT("relatedApplications", m_relatedApplications),
    CRDTP_DESERIALIZE_FIELD_OPT("scope", m_scope),
    CRDTP_DESERIALIZE_FIELD_OPT("scopeExtensions", m_scopeExtensions),
    CRDTP_DESERIALIZE_FIELD_OPT("screenshots", m_screenshots),
    CRDTP_DESERIALIZE_FIELD_OPT("shareTarget", m_shareTarget),
    CRDTP_DESERIALIZE_FIELD_OPT("shortName", m_shortName),
    CRDTP_DESERIALIZE_FIELD_OPT("shortcuts", m_shortcuts),
    CRDTP_DESERIALIZE_FIELD_OPT("startUrl", m_startUrl),
    CRDTP_DESERIALIZE_FIELD_OPT("themeColor", m_themeColor),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(WebAppManifest)
    CRDTP_SERIALIZE_FIELD("backgroundColor", m_backgroundColor);
    CRDTP_SERIALIZE_FIELD("description", m_description);
    CRDTP_SERIALIZE_FIELD("dir", m_dir);
    CRDTP_SERIALIZE_FIELD("display", m_display);
    CRDTP_SERIALIZE_FIELD("displayOverrides", m_displayOverrides);
    CRDTP_SERIALIZE_FIELD("fileHandlers", m_fileHandlers);
    CRDTP_SERIALIZE_FIELD("icons", m_icons);
    CRDTP_SERIALIZE_FIELD("id", m_id);
    CRDTP_SERIALIZE_FIELD("lang", m_lang);
    CRDTP_SERIALIZE_FIELD("launchHandler", m_launchHandler);
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("orientation", m_orientation);
    CRDTP_SERIALIZE_FIELD("preferRelatedApplications", m_preferRelatedApplications);
    CRDTP_SERIALIZE_FIELD("protocolHandlers", m_protocolHandlers);
    CRDTP_SERIALIZE_FIELD("relatedApplications", m_relatedApplications);
    CRDTP_SERIALIZE_FIELD("scope", m_scope);
    CRDTP_SERIALIZE_FIELD("scopeExtensions", m_scopeExtensions);
    CRDTP_SERIALIZE_FIELD("screenshots", m_screenshots);
    CRDTP_SERIALIZE_FIELD("shareTarget", m_shareTarget);
    CRDTP_SERIALIZE_FIELD("shortName", m_shortName);
    CRDTP_SERIALIZE_FIELD("shortcuts", m_shortcuts);
    CRDTP_SERIALIZE_FIELD("startUrl", m_startUrl);
    CRDTP_SERIALIZE_FIELD("themeColor", m_themeColor);
CRDTP_END_SERIALIZER();


namespace BackForwardCacheNotRestoredReasonEnum {
const char NotPrimaryMainFrame[] = "NotPrimaryMainFrame";
const char BackForwardCacheDisabled[] = "BackForwardCacheDisabled";
const char RelatedActiveContentsExist[] = "RelatedActiveContentsExist";
const char HTTPStatusNotOK[] = "HTTPStatusNotOK";
const char SchemeNotHTTPOrHTTPS[] = "SchemeNotHTTPOrHTTPS";
const char Loading[] = "Loading";
const char WasGrantedMediaAccess[] = "WasGrantedMediaAccess";
const char DisableForRenderFrameHostCalled[] = "DisableForRenderFrameHostCalled";
const char DomainNotAllowed[] = "DomainNotAllowed";
const char HTTPMethodNotGET[] = "HTTPMethodNotGET";
const char SubframeIsNavigating[] = "SubframeIsNavigating";
const char Timeout[] = "Timeout";
const char CacheLimit[] = "CacheLimit";
const char JavaScriptExecution[] = "JavaScriptExecution";
const char RendererProcessKilled[] = "RendererProcessKilled";
const char RendererProcessCrashed[] = "RendererProcessCrashed";
const char SchedulerTrackedFeatureUsed[] = "SchedulerTrackedFeatureUsed";
const char ConflictingBrowsingInstance[] = "ConflictingBrowsingInstance";
const char CacheFlushed[] = "CacheFlushed";
const char ServiceWorkerVersionActivation[] = "ServiceWorkerVersionActivation";
const char SessionRestored[] = "SessionRestored";
const char ServiceWorkerPostMessage[] = "ServiceWorkerPostMessage";
const char EnteredBackForwardCacheBeforeServiceWorkerHostAdded[] = "EnteredBackForwardCacheBeforeServiceWorkerHostAdded";
const char RenderFrameHostReused_SameSite[] = "RenderFrameHostReused_SameSite";
const char RenderFrameHostReused_CrossSite[] = "RenderFrameHostReused_CrossSite";
const char ServiceWorkerClaim[] = "ServiceWorkerClaim";
const char IgnoreEventAndEvict[] = "IgnoreEventAndEvict";
const char HaveInnerContents[] = "HaveInnerContents";
const char TimeoutPuttingInCache[] = "TimeoutPuttingInCache";
const char BackForwardCacheDisabledByLowMemory[] = "BackForwardCacheDisabledByLowMemory";
const char BackForwardCacheDisabledByCommandLine[] = "BackForwardCacheDisabledByCommandLine";
const char NetworkRequestDatapipeDrainedAsBytesConsumer[] = "NetworkRequestDatapipeDrainedAsBytesConsumer";
const char NetworkRequestRedirected[] = "NetworkRequestRedirected";
const char NetworkRequestTimeout[] = "NetworkRequestTimeout";
const char NetworkExceedsBufferLimit[] = "NetworkExceedsBufferLimit";
const char NavigationCancelledWhileRestoring[] = "NavigationCancelledWhileRestoring";
const char NotMostRecentNavigationEntry[] = "NotMostRecentNavigationEntry";
const char BackForwardCacheDisabledForPrerender[] = "BackForwardCacheDisabledForPrerender";
const char UserAgentOverrideDiffers[] = "UserAgentOverrideDiffers";
const char ForegroundCacheLimit[] = "ForegroundCacheLimit";
const char BrowsingInstanceNotSwapped[] = "BrowsingInstanceNotSwapped";
const char BackForwardCacheDisabledForDelegate[] = "BackForwardCacheDisabledForDelegate";
const char UnloadHandlerExistsInMainFrame[] = "UnloadHandlerExistsInMainFrame";
const char UnloadHandlerExistsInSubFrame[] = "UnloadHandlerExistsInSubFrame";
const char ServiceWorkerUnregistration[] = "ServiceWorkerUnregistration";
const char CacheControlNoStore[] = "CacheControlNoStore";
const char CacheControlNoStoreCookieModified[] = "CacheControlNoStoreCookieModified";
const char CacheControlNoStoreHTTPOnlyCookieModified[] = "CacheControlNoStoreHTTPOnlyCookieModified";
const char NoResponseHead[] = "NoResponseHead";
const char Unknown[] = "Unknown";
const char ActivationNavigationsDisallowedForBug1234857[] = "ActivationNavigationsDisallowedForBug1234857";
const char ErrorDocument[] = "ErrorDocument";
const char FencedFramesEmbedder[] = "FencedFramesEmbedder";
const char CookieDisabled[] = "CookieDisabled";
const char HTTPAuthRequired[] = "HTTPAuthRequired";
const char CookieFlushed[] = "CookieFlushed";
const char BroadcastChannelOnMessage[] = "BroadcastChannelOnMessage";
const char WebViewSettingsChanged[] = "WebViewSettingsChanged";
const char WebViewJavaScriptObjectChanged[] = "WebViewJavaScriptObjectChanged";
const char WebViewMessageListenerInjected[] = "WebViewMessageListenerInjected";
const char WebViewSafeBrowsingAllowlistChanged[] = "WebViewSafeBrowsingAllowlistChanged";
const char WebViewDocumentStartJavascriptChanged[] = "WebViewDocumentStartJavascriptChanged";
const char WebSocket[] = "WebSocket";
const char WebTransport[] = "WebTransport";
const char WebRTC[] = "WebRTC";
const char MainResourceHasCacheControlNoStore[] = "MainResourceHasCacheControlNoStore";
const char MainResourceHasCacheControlNoCache[] = "MainResourceHasCacheControlNoCache";
const char SubresourceHasCacheControlNoStore[] = "SubresourceHasCacheControlNoStore";
const char SubresourceHasCacheControlNoCache[] = "SubresourceHasCacheControlNoCache";
const char ContainsPlugins[] = "ContainsPlugins";
const char DocumentLoaded[] = "DocumentLoaded";
const char OutstandingNetworkRequestOthers[] = "OutstandingNetworkRequestOthers";
const char RequestedMIDIPermission[] = "RequestedMIDIPermission";
const char RequestedAudioCapturePermission[] = "RequestedAudioCapturePermission";
const char RequestedVideoCapturePermission[] = "RequestedVideoCapturePermission";
const char RequestedBackForwardCacheBlockedSensors[] = "RequestedBackForwardCacheBlockedSensors";
const char RequestedBackgroundWorkPermission[] = "RequestedBackgroundWorkPermission";
const char BroadcastChannel[] = "BroadcastChannel";
const char WebXR[] = "WebXR";
const char SharedWorker[] = "SharedWorker";
const char SharedWorkerMessage[] = "SharedWorkerMessage";
const char SharedWorkerWithNoActiveClient[] = "SharedWorkerWithNoActiveClient";
const char WebLocks[] = "WebLocks";
const char WebHID[] = "WebHID";
const char WebBluetooth[] = "WebBluetooth";
const char WebShare[] = "WebShare";
const char RequestedStorageAccessGrant[] = "RequestedStorageAccessGrant";
const char WebNfc[] = "WebNfc";
const char OutstandingNetworkRequestFetch[] = "OutstandingNetworkRequestFetch";
const char OutstandingNetworkRequestXHR[] = "OutstandingNetworkRequestXHR";
const char AppBanner[] = "AppBanner";
const char Printing[] = "Printing";
const char WebDatabase[] = "WebDatabase";
const char PictureInPicture[] = "PictureInPicture";
const char SpeechRecognizer[] = "SpeechRecognizer";
const char IdleManager[] = "IdleManager";
const char PaymentManager[] = "PaymentManager";
const char SpeechSynthesis[] = "SpeechSynthesis";
const char KeyboardLock[] = "KeyboardLock";
const char WebOTPService[] = "WebOTPService";
const char OutstandingNetworkRequestDirectSocket[] = "OutstandingNetworkRequestDirectSocket";
const char InjectedJavascript[] = "InjectedJavascript";
const char InjectedStyleSheet[] = "InjectedStyleSheet";
const char KeepaliveRequest[] = "KeepaliveRequest";
const char IndexedDBEvent[] = "IndexedDBEvent";
const char Dummy[] = "Dummy";
const char JsNetworkRequestReceivedCacheControlNoStoreResource[] = "JsNetworkRequestReceivedCacheControlNoStoreResource";
const char WebRTCUsedWithCCNS[] = "WebRTCUsedWithCCNS";
const char WebTransportUsedWithCCNS[] = "WebTransportUsedWithCCNS";
const char WebSocketUsedWithCCNS[] = "WebSocketUsedWithCCNS";
const char SmartCard[] = "SmartCard";
const char LiveMediaStreamTrack[] = "LiveMediaStreamTrack";
const char UnloadHandler[] = "UnloadHandler";
const char ParserAborted[] = "ParserAborted";
const char ContentSecurityHandler[] = "ContentSecurityHandler";
const char ContentWebAuthenticationAPI[] = "ContentWebAuthenticationAPI";
const char ContentFileChooser[] = "ContentFileChooser";
const char ContentSerial[] = "ContentSerial";
const char ContentFileSystemAccess[] = "ContentFileSystemAccess";
const char ContentMediaDevicesDispatcherHost[] = "ContentMediaDevicesDispatcherHost";
const char ContentWebBluetooth[] = "ContentWebBluetooth";
const char ContentWebUSB[] = "ContentWebUSB";
const char ContentMediaSessionService[] = "ContentMediaSessionService";
const char ContentScreenReader[] = "ContentScreenReader";
const char ContentDiscarded[] = "ContentDiscarded";
const char EmbedderPopupBlockerTabHelper[] = "EmbedderPopupBlockerTabHelper";
const char EmbedderSafeBrowsingTriggeredPopupBlocker[] = "EmbedderSafeBrowsingTriggeredPopupBlocker";
const char EmbedderSafeBrowsingThreatDetails[] = "EmbedderSafeBrowsingThreatDetails";
const char EmbedderAppBannerManager[] = "EmbedderAppBannerManager";
const char EmbedderDomDistillerViewerSource[] = "EmbedderDomDistillerViewerSource";
const char EmbedderDomDistillerSelfDeletingRequestDelegate[] = "EmbedderDomDistillerSelfDeletingRequestDelegate";
const char EmbedderOomInterventionTabHelper[] = "EmbedderOomInterventionTabHelper";
const char EmbedderOfflinePage[] = "EmbedderOfflinePage";
const char EmbedderChromePasswordManagerClientBindCredentialManager[] = "EmbedderChromePasswordManagerClientBindCredentialManager";
const char EmbedderPermissionRequestManager[] = "EmbedderPermissionRequestManager";
const char EmbedderModalDialog[] = "EmbedderModalDialog";
const char EmbedderExtensions[] = "EmbedderExtensions";
const char EmbedderExtensionMessaging[] = "EmbedderExtensionMessaging";
const char EmbedderExtensionMessagingForOpenPort[] = "EmbedderExtensionMessagingForOpenPort";
const char EmbedderExtensionSentMessageToCachedFrame[] = "EmbedderExtensionSentMessageToCachedFrame";
const char RequestedByWebViewClient[] = "RequestedByWebViewClient";
const char PostMessageByWebViewClient[] = "PostMessageByWebViewClient";
const char CacheControlNoStoreDeviceBoundSessionTerminated[] = "CacheControlNoStoreDeviceBoundSessionTerminated";
const char CacheLimitPrunedOnModerateMemoryPressure[] = "CacheLimitPrunedOnModerateMemoryPressure";
const char CacheLimitPrunedOnCriticalMemoryPressure[] = "CacheLimitPrunedOnCriticalMemoryPressure";
} // namespace BackForwardCacheNotRestoredReasonEnum


namespace BackForwardCacheNotRestoredReasonTypeEnum {
const char SupportPending[] = "SupportPending";
const char PageSupportNeeded[] = "PageSupportNeeded";
const char Circumstantial[] = "Circumstantial";
} // namespace BackForwardCacheNotRestoredReasonTypeEnum


CRDTP_BEGIN_DESERIALIZER(BackForwardCacheBlockingDetails)
    CRDTP_DESERIALIZE_FIELD("columnNumber", m_columnNumber),
    CRDTP_DESERIALIZE_FIELD_OPT("function", m_function),
    CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
    CRDTP_DESERIALIZE_FIELD_OPT("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BackForwardCacheBlockingDetails)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("function", m_function);
    CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(BackForwardCacheNotRestoredExplanation)
    CRDTP_DESERIALIZE_FIELD_OPT("context", m_context),
    CRDTP_DESERIALIZE_FIELD_OPT("details", m_details),
    CRDTP_DESERIALIZE_FIELD("reason", m_reason),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BackForwardCacheNotRestoredExplanation)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("reason", m_reason);
    CRDTP_SERIALIZE_FIELD("context", m_context);
    CRDTP_SERIALIZE_FIELD("details", m_details);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(BackForwardCacheNotRestoredExplanationTree)
    CRDTP_DESERIALIZE_FIELD("children", m_children),
    CRDTP_DESERIALIZE_FIELD("explanations", m_explanations),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BackForwardCacheNotRestoredExplanationTree)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("explanations", m_explanations);
    CRDTP_SERIALIZE_FIELD("children", m_children);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


namespace CaptureScreenshot {
namespace FormatEnum {
const char* Jpeg = "jpeg";
const char* Png = "png";
const char* Webp = "webp";
} // namespace FormatEnum
} // namespace CaptureScreenshot

namespace CaptureSnapshot {
namespace FormatEnum {
const char* Mhtml = "mhtml";
} // namespace FormatEnum
} // namespace CaptureSnapshot

namespace PrintToPDF {
namespace TransferModeEnum {
const char* ReturnAsBase64 = "ReturnAsBase64";
const char* ReturnAsStream = "ReturnAsStream";
} // namespace TransferModeEnum
} // namespace PrintToPDF

namespace SetDownloadBehavior {
namespace BehaviorEnum {
const char* Deny = "deny";
const char* Allow = "allow";
const char* Default = "default";
} // namespace BehaviorEnum
} // namespace SetDownloadBehavior

namespace SetTouchEmulationEnabled {
namespace ConfigurationEnum {
const char* Mobile = "mobile";
const char* Desktop = "desktop";
} // namespace ConfigurationEnum
} // namespace SetTouchEmulationEnabled

namespace StartScreencast {
namespace FormatEnum {
const char* Jpeg = "jpeg";
const char* Png = "png";
} // namespace FormatEnum
} // namespace StartScreencast

namespace SetWebLifecycleState {
namespace StateEnum {
const char* Frozen = "frozen";
const char* Active = "active";
} // namespace StateEnum
} // namespace SetWebLifecycleState

namespace SetSPCTransactionMode {
namespace ModeEnum {
const char* None = "none";
const char* AutoAccept = "autoAccept";
const char* AutoChooseToAuthAnotherWay = "autoChooseToAuthAnotherWay";
const char* AutoReject = "autoReject";
const char* AutoOptOut = "autoOptOut";
} // namespace ModeEnum
} // namespace SetSPCTransactionMode

namespace SetRPHRegistrationMode {
namespace ModeEnum {
const char* None = "none";
const char* AutoAccept = "autoAccept";
const char* AutoReject = "autoReject";
} // namespace ModeEnum
} // namespace SetRPHRegistrationMode

namespace FileChooserOpened {
namespace ModeEnum {
const char* SelectSingle = "selectSingle";
const char* SelectMultiple = "selectMultiple";
} // namespace ModeEnum
} // namespace FileChooserOpened

namespace FrameDetached {
namespace ReasonEnum {
const char* Remove = "remove";
const char* Swap = "swap";
} // namespace ReasonEnum
} // namespace FrameDetached

namespace FrameStartedNavigating {
namespace NavigationTypeEnum {
const char* Reload = "reload";
const char* ReloadBypassingCache = "reloadBypassingCache";
const char* Restore = "restore";
const char* RestoreWithPost = "restoreWithPost";
const char* HistorySameDocument = "historySameDocument";
const char* HistoryDifferentDocument = "historyDifferentDocument";
const char* SameDocument = "sameDocument";
const char* DifferentDocument = "differentDocument";
} // namespace NavigationTypeEnum
} // namespace FrameStartedNavigating

namespace DownloadProgress {
namespace StateEnum {
const char* InProgress = "inProgress";
const char* Completed = "completed";
const char* Canceled = "canceled";
} // namespace StateEnum
} // namespace DownloadProgress

namespace NavigatedWithinDocument {
namespace NavigationTypeEnum {
const char* Fragment = "fragment";
const char* HistoryApi = "historyApi";
const char* Other = "other";
} // namespace NavigationTypeEnum
} // namespace NavigatedWithinDocument

// ------------- Frontend notifications.

void Frontend::FrameDetached(const String& frameId, const String& reason)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("reason"), reason);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.frameDetached", serializer.Finish()));
}

void Frontend::FrameStartedNavigating(const String& frameId, const String& url, const String& loaderId, const String& navigationType)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("loaderId"), loaderId);
    serializer.AddField(crdtp::MakeSpan("navigationType"), navigationType);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.frameStartedNavigating", serializer.Finish()));
}

void Frontend::FrameStartedLoading(const String& frameId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.frameStartedLoading", serializer.Finish()));
}

void Frontend::FrameStoppedLoading(const String& frameId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.frameStoppedLoading", serializer.Finish()));
}

void Frontend::DownloadWillBegin(const String& frameId, const String& guid, const String& url, const String& suggestedFilename)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("guid"), guid);
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("suggestedFilename"), suggestedFilename);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.downloadWillBegin", serializer.Finish()));
}

void Frontend::DownloadProgress(const String& guid, double totalBytes, double receivedBytes, const String& state)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("guid"), guid);
    serializer.AddField(crdtp::MakeSpan("totalBytes"), totalBytes);
    serializer.AddField(crdtp::MakeSpan("receivedBytes"), receivedBytes);
    serializer.AddField(crdtp::MakeSpan("state"), state);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.downloadProgress", serializer.Finish()));
}

void Frontend::InterstitialHidden()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.interstitialHidden"));
}

void Frontend::InterstitialShown()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.interstitialShown"));
}

void Frontend::JavascriptDialogClosed(const String& frameId, bool result, const String& userInput)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("result"), result);
    serializer.AddField(crdtp::MakeSpan("userInput"), userInput);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.javascriptDialogClosed", serializer.Finish()));
}

void Frontend::JavascriptDialogOpening(const String& url, const String& frameId, const String& message, const String& type, bool hasBrowserHandler, std::optional<String> defaultPrompt)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("message"), message);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("hasBrowserHandler"), hasBrowserHandler);
    serializer.AddField(crdtp::MakeSpan("defaultPrompt"), defaultPrompt);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.javascriptDialogOpening", serializer.Finish()));
}

void Frontend::BackForwardCacheNotUsed(const String& loaderId, const String& frameId, std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> notRestoredExplanations, std::unique_ptr<protocol::Page::BackForwardCacheNotRestoredExplanationTree> notRestoredExplanationsTree)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("loaderId"), loaderId);
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("notRestoredExplanations"), notRestoredExplanations);
    serializer.AddField(crdtp::MakeSpan("notRestoredExplanationsTree"), notRestoredExplanationsTree);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.backForwardCacheNotUsed", serializer.Finish()));
}

void Frontend::ScreencastFrame(const Binary& data, std::unique_ptr<protocol::Page::ScreencastFrameMetadata> metadata, int sessionId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("data"), data);
    serializer.AddField(crdtp::MakeSpan("metadata"), metadata);
    serializer.AddField(crdtp::MakeSpan("sessionId"), sessionId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.screencastFrame", serializer.Finish()));
}

void Frontend::ScreencastVisibilityChanged(bool visible)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("visible"), visible);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.screencastVisibilityChanged", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void bringToFront(const crdtp::Dispatchable& dispatchable);
    void captureScreenshot(const crdtp::Dispatchable& dispatchable);
    void captureSnapshot(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void getAppManifest(const crdtp::Dispatchable& dispatchable);
    void getInstallabilityErrors(const crdtp::Dispatchable& dispatchable);
    void getManifestIcons(const crdtp::Dispatchable& dispatchable);
    void getAppId(const crdtp::Dispatchable& dispatchable);
    void getNavigationHistory(const crdtp::Dispatchable& dispatchable);
    void resetNavigationHistory(const crdtp::Dispatchable& dispatchable);
    void handleJavaScriptDialog(const crdtp::Dispatchable& dispatchable);
    void navigate(const crdtp::Dispatchable& dispatchable);
    void navigateToHistoryEntry(const crdtp::Dispatchable& dispatchable);
    void reload(const crdtp::Dispatchable& dispatchable);
    void screencastFrameAck(const crdtp::Dispatchable& dispatchable);
    void setBypassCSP(const crdtp::Dispatchable& dispatchable);
    void setDownloadBehavior(const crdtp::Dispatchable& dispatchable);
    void startScreencast(const crdtp::Dispatchable& dispatchable);
    void stopLoading(const crdtp::Dispatchable& dispatchable);
    void crash(const crdtp::Dispatchable& dispatchable);
    void close(const crdtp::Dispatchable& dispatchable);
    void setWebLifecycleState(const crdtp::Dispatchable& dispatchable);
    void stopScreencast(const crdtp::Dispatchable& dispatchable);
    void addCompilationCache(const crdtp::Dispatchable& dispatchable);
    void setPrerenderingAllowed(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("addCompilationCache"),
          &DomainDispatcherImpl::addCompilationCache
    },
    {
          crdtp::SpanFrom("bringToFront"),
          &DomainDispatcherImpl::bringToFront
    },
    {
          crdtp::SpanFrom("captureScreenshot"),
          &DomainDispatcherImpl::captureScreenshot
    },
    {
          crdtp::SpanFrom("captureSnapshot"),
          &DomainDispatcherImpl::captureSnapshot
    },
    {
          crdtp::SpanFrom("close"),
          &DomainDispatcherImpl::close
    },
    {
          crdtp::SpanFrom("crash"),
          &DomainDispatcherImpl::crash
    },
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("getAppId"),
          &DomainDispatcherImpl::getAppId
    },
    {
          crdtp::SpanFrom("getAppManifest"),
          &DomainDispatcherImpl::getAppManifest
    },
    {
          crdtp::SpanFrom("getInstallabilityErrors"),
          &DomainDispatcherImpl::getInstallabilityErrors
    },
    {
          crdtp::SpanFrom("getManifestIcons"),
          &DomainDispatcherImpl::getManifestIcons
    },
    {
          crdtp::SpanFrom("getNavigationHistory"),
          &DomainDispatcherImpl::getNavigationHistory
    },
    {
          crdtp::SpanFrom("handleJavaScriptDialog"),
          &DomainDispatcherImpl::handleJavaScriptDialog
    },
    {
          crdtp::SpanFrom("navigate"),
          &DomainDispatcherImpl::navigate
    },
    {
          crdtp::SpanFrom("navigateToHistoryEntry"),
          &DomainDispatcherImpl::navigateToHistoryEntry
    },
    {
          crdtp::SpanFrom("reload"),
          &DomainDispatcherImpl::reload
    },
    {
          crdtp::SpanFrom("resetNavigationHistory"),
          &DomainDispatcherImpl::resetNavigationHistory
    },
    {
          crdtp::SpanFrom("screencastFrameAck"),
          &DomainDispatcherImpl::screencastFrameAck
    },
    {
          crdtp::SpanFrom("setBypassCSP"),
          &DomainDispatcherImpl::setBypassCSP
    },
    {
          crdtp::SpanFrom("setDownloadBehavior"),
          &DomainDispatcherImpl::setDownloadBehavior
    },
    {
          crdtp::SpanFrom("setPrerenderingAllowed"),
          &DomainDispatcherImpl::setPrerenderingAllowed
    },
    {
          crdtp::SpanFrom("setWebLifecycleState"),
          &DomainDispatcherImpl::setWebLifecycleState
    },
    {
          crdtp::SpanFrom("startScreencast"),
          &DomainDispatcherImpl::startScreencast
    },
    {
          crdtp::SpanFrom("stopLoading"),
          &DomainDispatcherImpl::stopLoading
    },
    {
          crdtp::SpanFrom("stopScreencast"),
          &DomainDispatcherImpl::stopScreencast
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::bringToFront(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->BringToFront();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.bringToFront"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class CaptureScreenshotCallbackImpl : public Backend::CaptureScreenshotCallback, public DomainDispatcher::Callback {
public:
    CaptureScreenshotCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.captureScreenshot"), message) { }

    void sendSuccess(const Binary& data) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("data"), data);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct captureScreenshotParams : public crdtp::DeserializableProtocolObject<captureScreenshotParams> {
    std::optional<String> format;
    std::optional<int> quality;
    std::unique_ptr<protocol::Page::Viewport> clip;
    std::optional<bool> fromSurface;
    std::optional<bool> captureBeyondViewport;
    std::optional<bool> optimizeForSpeed;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(captureScreenshotParams)
    CRDTP_DESERIALIZE_FIELD_OPT("captureBeyondViewport", captureBeyondViewport),
    CRDTP_DESERIALIZE_FIELD_OPT("clip", clip),
    CRDTP_DESERIALIZE_FIELD_OPT("format", format),
    CRDTP_DESERIALIZE_FIELD_OPT("fromSurface", fromSurface),
    CRDTP_DESERIALIZE_FIELD_OPT("optimizeForSpeed", optimizeForSpeed),
    CRDTP_DESERIALIZE_FIELD_OPT("quality", quality),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::captureScreenshot(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    captureScreenshotParams params;
    if (!captureScreenshotParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->CaptureScreenshot(std::move(params.format), std::move(params.quality), std::move(params.clip), std::move(params.fromSurface), std::move(params.captureBeyondViewport), std::move(params.optimizeForSpeed), std::make_unique<CaptureScreenshotCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class CaptureSnapshotCallbackImpl : public Backend::CaptureSnapshotCallback, public DomainDispatcher::Callback {
public:
    CaptureSnapshotCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.captureSnapshot"), message) { }

    void sendSuccess(const String& data) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("data"), data);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct captureSnapshotParams : public crdtp::DeserializableProtocolObject<captureSnapshotParams> {
    std::optional<String> format;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(captureSnapshotParams)
    CRDTP_DESERIALIZE_FIELD_OPT("format", format),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::captureSnapshot(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    captureSnapshotParams params;
    if (!captureSnapshotParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->CaptureSnapshot(std::move(params.format), std::make_unique<CaptureSnapshotCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct enableParams : public crdtp::DeserializableProtocolObject<enableParams> {
    std::optional<bool> enableFileChooserOpenedEvent;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(enableParams)
    CRDTP_DESERIALIZE_FIELD_OPT("enableFileChooserOpenedEvent", enableFileChooserOpenedEvent),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    enableParams params;
    if (!enableParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Enable(std::move(params.enableFileChooserOpenedEvent));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class GetAppManifestCallbackImpl : public Backend::GetAppManifestCallback, public DomainDispatcher::Callback {
public:
    GetAppManifestCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.getAppManifest"), message) { }

    void sendSuccess(const String& url, std::unique_ptr<protocol::Array<protocol::Page::AppManifestError>> errors, std::optional<String> data, std::unique_ptr<protocol::Page::AppManifestParsedProperties> parsed, std::unique_ptr<protocol::Page::WebAppManifest> manifest) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("url"), url);
        serializer.AddField(crdtp::MakeSpan("errors"), errors);
        serializer.AddField(crdtp::MakeSpan("data"), data);
        serializer.AddField(crdtp::MakeSpan("parsed"), parsed);
        serializer.AddField(crdtp::MakeSpan("manifest"), manifest);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct getAppManifestParams : public crdtp::DeserializableProtocolObject<getAppManifestParams> {
    std::optional<String> manifestId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getAppManifestParams)
    CRDTP_DESERIALIZE_FIELD_OPT("manifestId", manifestId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getAppManifest(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getAppManifestParams params;
    if (!getAppManifestParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->GetAppManifest(std::move(params.manifestId), std::make_unique<GetAppManifestCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class GetInstallabilityErrorsCallbackImpl : public Backend::GetInstallabilityErrorsCallback, public DomainDispatcher::Callback {
public:
    GetInstallabilityErrorsCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.getInstallabilityErrors"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Array<protocol::Page::InstallabilityError>> installabilityErrors) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("installabilityErrors"), installabilityErrors);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::getInstallabilityErrors(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    m_backend->GetInstallabilityErrors(std::make_unique<GetInstallabilityErrorsCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class GetManifestIconsCallbackImpl : public Backend::GetManifestIconsCallback, public DomainDispatcher::Callback {
public:
    GetManifestIconsCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.getManifestIcons"), message) { }

    void sendSuccess(std::optional<Binary> primaryIcon) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("primaryIcon"), primaryIcon);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::getManifestIcons(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    m_backend->GetManifestIcons(std::make_unique<GetManifestIconsCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class GetAppIdCallbackImpl : public Backend::GetAppIdCallback, public DomainDispatcher::Callback {
public:
    GetAppIdCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.getAppId"), message) { }

    void sendSuccess(std::optional<String> appId, std::optional<String> recommendedId) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("appId"), appId);
        serializer.AddField(crdtp::MakeSpan("recommendedId"), recommendedId);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::getAppId(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    m_backend->GetAppId(std::make_unique<GetAppIdCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {


}  // namespace

void DomainDispatcherImpl::getNavigationHistory(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    int out_currentIndex;
    std::unique_ptr<protocol::Array<protocol::Page::NavigationEntry>> out_entries;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->GetNavigationHistory(&out_currentIndex, &out_entries);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.getNavigationHistory"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("currentIndex"), out_currentIndex);
          serializer.AddField(crdtp::MakeSpan("entries"), out_entries);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::resetNavigationHistory(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->ResetNavigationHistory();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.resetNavigationHistory"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct handleJavaScriptDialogParams : public crdtp::DeserializableProtocolObject<handleJavaScriptDialogParams> {
    bool accept;
    std::optional<String> promptText;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(handleJavaScriptDialogParams)
    CRDTP_DESERIALIZE_FIELD("accept", accept),
    CRDTP_DESERIALIZE_FIELD_OPT("promptText", promptText),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::handleJavaScriptDialog(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    handleJavaScriptDialogParams params;
    if (!handleJavaScriptDialogParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->HandleJavaScriptDialog(params.accept, std::move(params.promptText));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.handleJavaScriptDialog"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class NavigateCallbackImpl : public Backend::NavigateCallback, public DomainDispatcher::Callback {
public:
    NavigateCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.navigate"), message) { }

    void sendSuccess(const String& frameId, std::optional<String> loaderId, std::optional<String> errorText, std::optional<bool> isDownload) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
        serializer.AddField(crdtp::MakeSpan("loaderId"), loaderId);
        serializer.AddField(crdtp::MakeSpan("errorText"), errorText);
        serializer.AddField(crdtp::MakeSpan("isDownload"), isDownload);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct navigateParams : public crdtp::DeserializableProtocolObject<navigateParams> {
    String url;
    std::optional<String> referrer;
    std::optional<String> transitionType;
    std::optional<String> frameId;
    std::optional<String> referrerPolicy;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(navigateParams)
    CRDTP_DESERIALIZE_FIELD_OPT("frameId", frameId),
    CRDTP_DESERIALIZE_FIELD_OPT("referrer", referrer),
    CRDTP_DESERIALIZE_FIELD_OPT("referrerPolicy", referrerPolicy),
    CRDTP_DESERIALIZE_FIELD_OPT("transitionType", transitionType),
    CRDTP_DESERIALIZE_FIELD("url", url),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::navigate(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    navigateParams params;
    if (!navigateParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->Navigate(params.url, std::move(params.referrer), std::move(params.transitionType), std::move(params.frameId), std::move(params.referrerPolicy), std::make_unique<NavigateCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct navigateToHistoryEntryParams : public crdtp::DeserializableProtocolObject<navigateToHistoryEntryParams> {
    int entryId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(navigateToHistoryEntryParams)
    CRDTP_DESERIALIZE_FIELD("entryId", entryId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::navigateToHistoryEntry(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    navigateToHistoryEntryParams params;
    if (!navigateToHistoryEntryParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->NavigateToHistoryEntry(params.entryId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.navigateToHistoryEntry"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class ReloadCallbackImpl : public Backend::ReloadCallback, public DomainDispatcher::Callback {
public:
    ReloadCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.reload"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct reloadParams : public crdtp::DeserializableProtocolObject<reloadParams> {
    std::optional<bool> ignoreCache;
    std::optional<String> scriptToEvaluateOnLoad;
    std::optional<String> loaderId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(reloadParams)
    CRDTP_DESERIALIZE_FIELD_OPT("ignoreCache", ignoreCache),
    CRDTP_DESERIALIZE_FIELD_OPT("loaderId", loaderId),
    CRDTP_DESERIALIZE_FIELD_OPT("scriptToEvaluateOnLoad", scriptToEvaluateOnLoad),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::reload(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    reloadParams params;
    if (!reloadParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->Reload(std::move(params.ignoreCache), std::move(params.scriptToEvaluateOnLoad), std::move(params.loaderId), std::make_unique<ReloadCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct screencastFrameAckParams : public crdtp::DeserializableProtocolObject<screencastFrameAckParams> {
    int sessionId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(screencastFrameAckParams)
    CRDTP_DESERIALIZE_FIELD("sessionId", sessionId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::screencastFrameAck(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    screencastFrameAckParams params;
    if (!screencastFrameAckParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->ScreencastFrameAck(params.sessionId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.screencastFrameAck"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setBypassCSPParams : public crdtp::DeserializableProtocolObject<setBypassCSPParams> {
    bool enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setBypassCSPParams)
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setBypassCSP(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setBypassCSPParams params;
    if (!setBypassCSPParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetBypassCSP(params.enabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.setBypassCSP"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setDownloadBehaviorParams : public crdtp::DeserializableProtocolObject<setDownloadBehaviorParams> {
    String behavior;
    std::optional<String> downloadPath;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setDownloadBehaviorParams)
    CRDTP_DESERIALIZE_FIELD("behavior", behavior),
    CRDTP_DESERIALIZE_FIELD_OPT("downloadPath", downloadPath),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setDownloadBehavior(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setDownloadBehaviorParams params;
    if (!setDownloadBehaviorParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetDownloadBehavior(params.behavior, std::move(params.downloadPath));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.setDownloadBehavior"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct startScreencastParams : public crdtp::DeserializableProtocolObject<startScreencastParams> {
    std::optional<String> format;
    std::optional<int> quality;
    std::optional<int> maxWidth;
    std::optional<int> maxHeight;
    std::optional<int> everyNthFrame;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(startScreencastParams)
    CRDTP_DESERIALIZE_FIELD_OPT("everyNthFrame", everyNthFrame),
    CRDTP_DESERIALIZE_FIELD_OPT("format", format),
    CRDTP_DESERIALIZE_FIELD_OPT("maxHeight", maxHeight),
    CRDTP_DESERIALIZE_FIELD_OPT("maxWidth", maxWidth),
    CRDTP_DESERIALIZE_FIELD_OPT("quality", quality),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::startScreencast(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    startScreencastParams params;
    if (!startScreencastParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->StartScreencast(std::move(params.format), std::move(params.quality), std::move(params.maxWidth), std::move(params.maxHeight), std::move(params.everyNthFrame));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.startScreencast"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::stopLoading(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->StopLoading();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.stopLoading"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::crash(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Crash();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.crash"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::close(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Close();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.close"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setWebLifecycleStateParams : public crdtp::DeserializableProtocolObject<setWebLifecycleStateParams> {
    String state;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setWebLifecycleStateParams)
    CRDTP_DESERIALIZE_FIELD("state", state),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setWebLifecycleState(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setWebLifecycleStateParams params;
    if (!setWebLifecycleStateParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetWebLifecycleState(params.state);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.setWebLifecycleState"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::stopScreencast(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->StopScreencast();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.stopScreencast"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct addCompilationCacheParams : public crdtp::DeserializableProtocolObject<addCompilationCacheParams> {
    String url;
    Binary data;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(addCompilationCacheParams)
    CRDTP_DESERIALIZE_FIELD("data", data),
    CRDTP_DESERIALIZE_FIELD("url", url),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::addCompilationCache(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    addCompilationCacheParams params;
    if (!addCompilationCacheParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->AddCompilationCache(params.url, params.data);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.addCompilationCache"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setPrerenderingAllowedParams : public crdtp::DeserializableProtocolObject<setPrerenderingAllowedParams> {
    bool isAllowed;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setPrerenderingAllowedParams)
    CRDTP_DESERIALIZE_FIELD("isAllowed", isAllowed),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setPrerenderingAllowed(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setPrerenderingAllowedParams params;
    if (!setPrerenderingAllowedParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetPrerenderingAllowed(params.isAllowed);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.setPrerenderingAllowed"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
          { crdtp::SpanFrom("Page.clearDeviceMetricsOverride"), crdtp::SpanFrom("Emulation.clearDeviceMetricsOverride") },
          { crdtp::SpanFrom("Page.clearDeviceOrientationOverride"), crdtp::SpanFrom("DeviceOrientation.clearDeviceOrientationOverride") },
          { crdtp::SpanFrom("Page.clearGeolocationOverride"), crdtp::SpanFrom("Emulation.clearGeolocationOverride") },
          { crdtp::SpanFrom("Page.deleteCookie"), crdtp::SpanFrom("Network.deleteCookie") },
          { crdtp::SpanFrom("Page.setDeviceMetricsOverride"), crdtp::SpanFrom("Emulation.setDeviceMetricsOverride") },
          { crdtp::SpanFrom("Page.setDeviceOrientationOverride"), crdtp::SpanFrom("DeviceOrientation.setDeviceOrientationOverride") },
          { crdtp::SpanFrom("Page.setGeolocationOverride"), crdtp::SpanFrom("Emulation.setGeolocationOverride") },
          { crdtp::SpanFrom("Page.setTouchEmulationEnabled"), crdtp::SpanFrom("Emulation.setTouchEmulationEnabled") },
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Page"), SortedRedirects(), std::move(dispatcher));
}

} // Page
} // namespace content
} // namespace protocol
