// components/webapps/common/web_page_metadata_agent.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/webapps/common/web_page_metadata_agent.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/webapps/common/web_page_metadata_agent.mojom-params-data.h"
#include "components/webapps/common/web_page_metadata_agent.mojom-shared-message-ids.h"

#include "components/webapps/common/web_page_metadata_agent.mojom-import-headers.h"
#include "components/webapps/common/web_page_metadata_agent.mojom-test-utils.h"


namespace webapps::mojom {
// The declaration includes the definition on other builds.

WebPageMetadataAgent::IPCStableHashFunction WebPageMetadataAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebPageMetadataAgent>(message.name())) {
    case messages::WebPageMetadataAgent::kGetWebPageMetadata: {
      return &WebPageMetadataAgent::GetWebPageMetadata_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebPageMetadataAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebPageMetadataAgent>(message.name())) {
      case messages::WebPageMetadataAgent::kGetWebPageMetadata:
            return "Receive webapps::mojom::WebPageMetadataAgent::GetWebPageMetadata";
    }
  } else {
    switch (static_cast<messages::WebPageMetadataAgent>(message.name())) {
      case messages::WebPageMetadataAgent::kGetWebPageMetadata:
            return "Receive reply webapps::mojom::WebPageMetadataAgent::GetWebPageMetadata";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebPageMetadataAgent::GetWebPageMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe0f9e12c;  // IPCStableHash for webapps::mojom::WebPageMetadataAgent::GetWebPageMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebPageMetadataAgent_GetWebPageMetadata_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebPageMetadataAgent_GetWebPageMetadata_ForwardToCallback(
      WebPageMetadataAgent::GetWebPageMetadataCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebPageMetadataAgent_GetWebPageMetadata_ForwardToCallback(const WebPageMetadataAgent_GetWebPageMetadata_ForwardToCallback&) = delete;
  WebPageMetadataAgent_GetWebPageMetadata_ForwardToCallback& operator=(const WebPageMetadataAgent_GetWebPageMetadata_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebPageMetadataAgent::GetWebPageMetadataCallback callback_;
};

WebPageMetadataAgentProxy::WebPageMetadataAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebPageMetadataAgentProxy::GetWebPageMetadata(
    GetWebPageMetadataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webapps::mojom::WebPageMetadataAgent::GetWebPageMetadata");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebPageMetadataAgent::kGetWebPageMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webapps::mojom::internal::WebPageMetadataAgent_GetWebPageMetadata_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebPageMetadataAgent::Name_);
  message.set_method_name("GetWebPageMetadata");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebPageMetadataAgent_GetWebPageMetadata_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebPageMetadataAgent_GetWebPageMetadata_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebPageMetadataAgent::GetWebPageMetadataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebPageMetadataAgent_GetWebPageMetadata_ProxyToResponder> proxy(
        new WebPageMetadataAgent_GetWebPageMetadata_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebPageMetadataAgent_GetWebPageMetadata_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebPageMetadataAgent_GetWebPageMetadata_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebPageMetadataAgent_GetWebPageMetadata_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebPageMetadataAgent::GetWebPageMetadataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::webapps::mojom::WebPageMetadataPtr in_web_page_metadata);
};

bool WebPageMetadataAgent_GetWebPageMetadata_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebPageMetadataAgent_GetWebPageMetadata_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebPageMetadataAgent_GetWebPageMetadata_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebPageMetadataAgent.0
  bool success = true;
  ::webapps::mojom::WebPageMetadataPtr p_web_page_metadata{};
  WebPageMetadataAgent_GetWebPageMetadata_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadWebPageMetadata(&p_web_page_metadata))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebPageMetadataAgent::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_web_page_metadata));
  }
  return true;
}

void WebPageMetadataAgent_GetWebPageMetadata_ProxyToResponder::Run(
    ::webapps::mojom::WebPageMetadataPtr in_web_page_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webapps::mojom::WebPageMetadataAgent::GetWebPageMetadata", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("web_page_metadata"), in_web_page_metadata,
                        "<value of type ::webapps::mojom::WebPageMetadataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebPageMetadataAgent::kGetWebPageMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webapps::mojom::internal::WebPageMetadataAgent_GetWebPageMetadata_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->web_page_metadata)::BaseType> web_page_metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::webapps::mojom::WebPageMetadataDataView>(
    in_web_page_metadata,
    web_page_metadata_fragment);

  params->web_page_metadata.Set(
      web_page_metadata_fragment.is_null() ? nullptr : web_page_metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->web_page_metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null web_page_metadata in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebPageMetadataAgent::Name_);
  message.set_method_name("GetWebPageMetadata");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebPageMetadataAgentStubDispatch::Accept(
    WebPageMetadataAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebPageMetadataAgent>(message->header()->name)) {
    case messages::WebPageMetadataAgent::kGetWebPageMetadata: {
      break;
    }
  }
  return false;
}

// static
bool WebPageMetadataAgentStubDispatch::AcceptWithResponder(
    WebPageMetadataAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebPageMetadataAgent>(message->header()->name)) {
    case messages::WebPageMetadataAgent::kGetWebPageMetadata: {
      internal::WebPageMetadataAgent_GetWebPageMetadata_Params_Data* params =
          reinterpret_cast<
              internal::WebPageMetadataAgent_GetWebPageMetadata_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebPageMetadataAgent.0
      bool success = true;
      WebPageMetadataAgent_GetWebPageMetadata_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebPageMetadataAgent::Name_, 0, false);
        return false;
      }
      auto callback =
          WebPageMetadataAgent_GetWebPageMetadata_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWebPageMetadata(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebPageMetadataAgentValidationInfo[] = {
    { &internal::WebPageMetadataAgent_GetWebPageMetadata_Params_Data::Validate,
     &internal::WebPageMetadataAgent_GetWebPageMetadata_ResponseParams_Data::Validate},
};

bool WebPageMetadataAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::webapps::mojom::WebPageMetadataAgent::Name_,
    kWebPageMetadataAgentValidationInfo);
}

bool WebPageMetadataAgentResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::webapps::mojom::WebPageMetadataAgent::Name_,
    kWebPageMetadataAgentValidationInfo);
}


}  // webapps::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace webapps::mojom {


void WebPageMetadataAgentInterceptorForTesting::GetWebPageMetadata(GetWebPageMetadataCallback callback) {
  GetForwardingInterface()->GetWebPageMetadata(std::move(callback));
}
WebPageMetadataAgentAsyncWaiter::WebPageMetadataAgentAsyncWaiter(
    WebPageMetadataAgent* proxy) : proxy_(proxy) {}

WebPageMetadataAgentAsyncWaiter::~WebPageMetadataAgentAsyncWaiter() = default;


void WebPageMetadataAgentAsyncWaiter::GetWebPageMetadata(
    ::webapps::mojom::WebPageMetadataPtr* out_web_page_metadata) {
  base::RunLoop loop;
  proxy_->GetWebPageMetadata(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::webapps::mojom::WebPageMetadataPtr* out_web_page_metadata
,
             ::webapps::mojom::WebPageMetadataPtr web_page_metadata) {*out_web_page_metadata = std::move(web_page_metadata);
            loop->Quit();
          },
          &loop,
          out_web_page_metadata));
  loop.Run();
}

::webapps::mojom::WebPageMetadataPtr WebPageMetadataAgentAsyncWaiter::GetWebPageMetadata(
    ) {
  ::webapps::mojom::WebPageMetadataPtr async_wait_result;
  GetWebPageMetadata(&async_wait_result);
  return async_wait_result;
}






}  // webapps::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif