// components/web_package/mojom/web_bundle_parser.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/web_package/mojom/web_bundle_parser.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/web_package/mojom/web_bundle_parser.mojom-params-data.h"
#include "components/web_package/mojom/web_bundle_parser.mojom-shared-message-ids.h"

#include "components/web_package/mojom/web_bundle_parser.mojom-import-headers.h"
#include "components/web_package/mojom/web_bundle_parser.mojom-test-utils.h"


namespace web_package::mojom {
BundleIntegrityBlockParseError::BundleIntegrityBlockParseError()
    : type(),
      message() {}

BundleIntegrityBlockParseError::BundleIntegrityBlockParseError(
    BundleParseErrorType type_in,
    const std::string& message_in)
    : type(std::move(type_in)),
      message(std::move(message_in)) {}

BundleIntegrityBlockParseError::~BundleIntegrityBlockParseError() = default;
size_t BundleIntegrityBlockParseError::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->type);
  seed = mojo::internal::Hash(seed, this->message);
  return seed;
}

void BundleIntegrityBlockParseError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BundleParseErrorType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundleIntegrityBlockParseError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundleMetadataParseError::BundleMetadataParseError()
    : type(),
      message() {}

BundleMetadataParseError::BundleMetadataParseError(
    BundleParseErrorType type_in,
    const std::string& message_in)
    : type(std::move(type_in)),
      message(std::move(message_in)) {}

BundleMetadataParseError::~BundleMetadataParseError() = default;
size_t BundleMetadataParseError::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->type);
  seed = mojo::internal::Hash(seed, this->message);
  return seed;
}

void BundleMetadataParseError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BundleParseErrorType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundleMetadataParseError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundleResponseParseError::BundleResponseParseError()
    : type(),
      message() {}

BundleResponseParseError::BundleResponseParseError(
    BundleParseErrorType type_in,
    const std::string& message_in)
    : type(std::move(type_in)),
      message(std::move(message_in)) {}

BundleResponseParseError::~BundleResponseParseError() = default;
size_t BundleResponseParseError::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->type);
  seed = mojo::internal::Hash(seed, this->message);
  return seed;
}

void BundleResponseParseError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BundleParseErrorType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundleResponseParseError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundleIntegrityBlockAttributes::BundleIntegrityBlockAttributes()
    : web_bundle_id(),
      cbor() {}

BundleIntegrityBlockAttributes::BundleIntegrityBlockAttributes(
    const std::string& web_bundle_id_in,
    std::vector<uint8_t> cbor_in)
    : web_bundle_id(std::move(web_bundle_id_in)),
      cbor(std::move(cbor_in)) {}

BundleIntegrityBlockAttributes::~BundleIntegrityBlockAttributes() = default;

void BundleIntegrityBlockAttributes::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_bundle_id"), this->web_bundle_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cbor"), this->cbor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundleIntegrityBlockAttributes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundleIntegrityBlock::BundleIntegrityBlock()
    : size(),
      signature_stack(),
      attributes(mojo::internal::DefaultConstructTag()) {}

BundleIntegrityBlock::BundleIntegrityBlock(
    uint64_t size_in,
    std::vector<BundleIntegrityBlockSignatureStackEntryPtr> signature_stack_in,
    const ::web_package::IntegrityBlockAttributes& attributes_in)
    : size(std::move(size_in)),
      signature_stack(std::move(signature_stack_in)),
      attributes(std::move(attributes_in)) {}

BundleIntegrityBlock::~BundleIntegrityBlock() = default;

void BundleIntegrityBlock::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signature_stack"), this->signature_stack,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<BundleIntegrityBlockSignatureStackEntryPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attributes"), this->attributes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::web_package::IntegrityBlockAttributes&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundleIntegrityBlock::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Ed25519PublicKey::Ed25519PublicKey()
    : bytes() {}

Ed25519PublicKey::Ed25519PublicKey(
    std::vector<uint8_t> bytes_in)
    : bytes(std::move(bytes_in)) {}

Ed25519PublicKey::~Ed25519PublicKey() = default;

void Ed25519PublicKey::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bytes"), this->bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Ed25519PublicKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Ed25519Signature::Ed25519Signature()
    : bytes() {}

Ed25519Signature::Ed25519Signature(
    std::vector<uint8_t> bytes_in)
    : bytes(std::move(bytes_in)) {}

Ed25519Signature::~Ed25519Signature() = default;

void Ed25519Signature::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bytes"), this->bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Ed25519Signature::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SignatureInfoEd25519::SignatureInfoEd25519()
    : public_key(mojo::internal::DefaultConstructTag()),
      signature(mojo::internal::DefaultConstructTag()) {}

SignatureInfoEd25519::SignatureInfoEd25519(
    const ::web_package::Ed25519PublicKey& public_key_in,
    const ::web_package::Ed25519Signature& signature_in)
    : public_key(std::move(public_key_in)),
      signature(std::move(signature_in)) {}

SignatureInfoEd25519::~SignatureInfoEd25519() = default;

void SignatureInfoEd25519::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "public_key"), this->public_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::web_package::Ed25519PublicKey&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signature"), this->signature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::web_package::Ed25519Signature&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SignatureInfoEd25519::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EcdsaP256PublicKey::EcdsaP256PublicKey()
    : bytes() {}

EcdsaP256PublicKey::EcdsaP256PublicKey(
    std::vector<uint8_t> bytes_in)
    : bytes(std::move(bytes_in)) {}

EcdsaP256PublicKey::~EcdsaP256PublicKey() = default;

void EcdsaP256PublicKey::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bytes"), this->bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EcdsaP256PublicKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EcdsaP256SHA256Signature::EcdsaP256SHA256Signature()
    : bytes() {}

EcdsaP256SHA256Signature::EcdsaP256SHA256Signature(
    std::vector<uint8_t> bytes_in)
    : bytes(std::move(bytes_in)) {}

EcdsaP256SHA256Signature::~EcdsaP256SHA256Signature() = default;

void EcdsaP256SHA256Signature::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bytes"), this->bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EcdsaP256SHA256Signature::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SignatureInfoEcdsaP256SHA256::SignatureInfoEcdsaP256SHA256()
    : public_key(mojo::internal::DefaultConstructTag()),
      signature(mojo::internal::DefaultConstructTag()) {}

SignatureInfoEcdsaP256SHA256::SignatureInfoEcdsaP256SHA256(
    const ::web_package::EcdsaP256PublicKey& public_key_in,
    const ::web_package::EcdsaP256SHA256Signature& signature_in)
    : public_key(std::move(public_key_in)),
      signature(std::move(signature_in)) {}

SignatureInfoEcdsaP256SHA256::~SignatureInfoEcdsaP256SHA256() = default;

void SignatureInfoEcdsaP256SHA256::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "public_key"), this->public_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::web_package::EcdsaP256PublicKey&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signature"), this->signature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::web_package::EcdsaP256SHA256Signature&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SignatureInfoEcdsaP256SHA256::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SignatureInfoUnknown::SignatureInfoUnknown() {}

SignatureInfoUnknown::~SignatureInfoUnknown() = default;
size_t SignatureInfoUnknown::Hash(size_t seed) const {
  return seed;
}

void SignatureInfoUnknown::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool SignatureInfoUnknown::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundleIntegrityBlockSignatureStackEntry::BundleIntegrityBlockSignatureStackEntry()
    : attributes_cbor(),
      signature_info() {}

BundleIntegrityBlockSignatureStackEntry::BundleIntegrityBlockSignatureStackEntry(
    std::vector<uint8_t> attributes_cbor_in,
    SignatureInfoPtr signature_info_in)
    : attributes_cbor(std::move(attributes_cbor_in)),
      signature_info(std::move(signature_info_in)) {}

BundleIntegrityBlockSignatureStackEntry::~BundleIntegrityBlockSignatureStackEntry() = default;

void BundleIntegrityBlockSignatureStackEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attributes_cbor"), this->attributes_cbor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signature_info"), this->signature_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SignatureInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundleIntegrityBlockSignatureStackEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundleMetadata::BundleMetadata()
    : version(),
      primary_url(),
      requests() {}

BundleMetadata::BundleMetadata(
    BundleFormatVersion version_in,
    const std::optional<::GURL>& primary_url_in,
    base::flat_map<::GURL, BundleResponseLocationPtr> requests_in)
    : version(std::move(version_in)),
      primary_url(std::move(primary_url_in)),
      requests(std::move(requests_in)) {}

BundleMetadata::~BundleMetadata() = default;

void BundleMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BundleFormatVersion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_url"), this->primary_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requests"), this->requests,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<::GURL, BundleResponseLocationPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundleMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundleResponseLocation::BundleResponseLocation()
    : offset(),
      length() {}

BundleResponseLocation::BundleResponseLocation(
    uint64_t offset_in,
    uint64_t length_in)
    : offset(std::move(offset_in)),
      length(std::move(length_in)) {}

BundleResponseLocation::~BundleResponseLocation() = default;
size_t BundleResponseLocation::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->offset);
  seed = mojo::internal::Hash(seed, this->length);
  return seed;
}

void BundleResponseLocation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "length"), this->length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundleResponseLocation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundleResponse::BundleResponse()
    : response_code(),
      response_headers(),
      payload_offset(),
      payload_length() {}

BundleResponse::BundleResponse(
    int32_t response_code_in,
    const base::flat_map<std::string, std::string>& response_headers_in,
    uint64_t payload_offset_in,
    uint64_t payload_length_in)
    : response_code(std::move(response_code_in)),
      response_headers(std::move(response_headers_in)),
      payload_offset(std::move(payload_offset_in)),
      payload_length(std::move(payload_length_in)) {}

BundleResponse::~BundleResponse() = default;

void BundleResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_code"), this->response_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_headers"), this->response_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payload_offset"), this->payload_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payload_length"), this->payload_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundleResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SignatureInfoPtr
SignatureInfo::NewUnknown(
    SignatureInfoUnknownPtr value) {
  return SignatureInfoPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUnknown)>,
      std::move(value));
}

SignatureInfoPtr
SignatureInfo::NewEd25519(
    SignatureInfoEd25519Ptr value) {
  return SignatureInfoPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kEd25519)>,
      std::move(value));
}

SignatureInfoPtr
SignatureInfo::NewEcdsaP256Sha256(
    SignatureInfoEcdsaP256SHA256Ptr value) {
  return SignatureInfoPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kEcdsaP256Sha256)>,
      std::move(value));
}

SignatureInfo::SignatureInfo(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnknown)>,
    SignatureInfoUnknownPtr value)
    : tag_(Tag::kUnknown),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUnknown)>,
            std::move(value)) {}

SignatureInfo::SignatureInfo(
    std::in_place_index_t<static_cast<size_t>(Tag::kEd25519)>,
    SignatureInfoEd25519Ptr value)
    : tag_(Tag::kEd25519),
      data_(std::in_place_index<static_cast<size_t>(Tag::kEd25519)>,
            std::move(value)) {}

SignatureInfo::SignatureInfo(
    std::in_place_index_t<static_cast<size_t>(Tag::kEcdsaP256Sha256)>,
    SignatureInfoEcdsaP256SHA256Ptr value)
    : tag_(Tag::kEcdsaP256Sha256),
      data_(std::in_place_index<static_cast<size_t>(Tag::kEcdsaP256Sha256)>,
            std::move(value)) {}
SignatureInfo::~SignatureInfo() {
  DestroyActive();
}

void SignatureInfo::set_unknown(SignatureInfoUnknownPtr unknown) {
  if (tag_ == Tag::kUnknown) {
    data_.unknown = std::move(unknown);
  } else {
    DestroyActive();
    tag_ = Tag::kUnknown;
    new (&data_.unknown) SignatureInfoUnknownPtr(
        std::move(unknown));
  }
}

void SignatureInfo::set_ed25519(SignatureInfoEd25519Ptr ed25519) {
  if (tag_ == Tag::kEd25519) {
    data_.ed25519 = std::move(ed25519);
  } else {
    DestroyActive();
    tag_ = Tag::kEd25519;
    new (&data_.ed25519) SignatureInfoEd25519Ptr(
        std::move(ed25519));
  }
}

void SignatureInfo::set_ecdsa_p256_sha256(SignatureInfoEcdsaP256SHA256Ptr ecdsa_p256_sha256) {
  if (tag_ == Tag::kEcdsaP256Sha256) {
    data_.ecdsa_p256_sha256 = std::move(ecdsa_p256_sha256);
  } else {
    DestroyActive();
    tag_ = Tag::kEcdsaP256Sha256;
    new (&data_.ecdsa_p256_sha256) SignatureInfoEcdsaP256SHA256Ptr(
        std::move(ecdsa_p256_sha256));
  }
}


SignatureInfo::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnknown)>,
    SignatureInfoUnknownPtr value)
    : unknown(std::move(value)) {}

SignatureInfo::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kEd25519)>,
    SignatureInfoEd25519Ptr value)
    : ed25519(std::move(value)) {}

SignatureInfo::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kEcdsaP256Sha256)>,
    SignatureInfoEcdsaP256SHA256Ptr value)
    : ecdsa_p256_sha256(std::move(value)) {}

void SignatureInfo::DestroyActive() {
  switch (tag_) {

    case Tag::kUnknown:
      std::destroy_at(&data_.unknown);
      break;
    case Tag::kEd25519:
      std::destroy_at(&data_.ed25519);
      break;
    case Tag::kEcdsaP256Sha256:
      std::destroy_at(&data_.ecdsa_p256_sha256);
      break;
  }
}

bool SignatureInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

WebBundleParserFactory::IPCStableHashFunction WebBundleParserFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebBundleParserFactory>(message.name())) {
    case messages::WebBundleParserFactory::kGetParserForDataSource: {
      return &WebBundleParserFactory::GetParserForDataSource_Sym::IPCStableHash;
    }
    case messages::WebBundleParserFactory::kBindFileDataSource: {
      return &WebBundleParserFactory::BindFileDataSource_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebBundleParserFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebBundleParserFactory>(message.name())) {
      case messages::WebBundleParserFactory::kGetParserForDataSource:
            return "Receive web_package::mojom::WebBundleParserFactory::GetParserForDataSource";
      case messages::WebBundleParserFactory::kBindFileDataSource:
            return "Receive web_package::mojom::WebBundleParserFactory::BindFileDataSource";
    }
  } else {
    switch (static_cast<messages::WebBundleParserFactory>(message.name())) {
      case messages::WebBundleParserFactory::kGetParserForDataSource:
            return "Receive reply web_package::mojom::WebBundleParserFactory::GetParserForDataSource";
      case messages::WebBundleParserFactory::kBindFileDataSource:
            return "Receive reply web_package::mojom::WebBundleParserFactory::BindFileDataSource";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebBundleParserFactory::GetParserForDataSource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc76c1335;  // IPCStableHash for web_package::mojom::WebBundleParserFactory::GetParserForDataSource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBundleParserFactory::BindFileDataSource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7aa4dd4c;  // IPCStableHash for web_package::mojom::WebBundleParserFactory::BindFileDataSource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebBundleParserFactoryProxy::WebBundleParserFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebBundleParserFactoryProxy::GetParserForDataSource(
    ::mojo::PendingReceiver<WebBundleParser> in_receiver, const std::optional<::GURL>& in_base_url, ::mojo::PendingRemote<BundleDataSource> in_data_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send web_package::mojom::WebBundleParserFactory::GetParserForDataSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<WebBundleParser>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("base_url"), in_base_url,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_source"), in_data_source,
                        "<value of type ::mojo::PendingRemote<BundleDataSource>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBundleParserFactory::kGetParserForDataSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParserFactory_GetParserForDataSource_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::web_package::mojom::WebBundleParserInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in WebBundleParserFactory.GetParserForDataSource request");
  mojo::internal::MessageFragment<
      typename decltype(params->base_url)::BaseType> base_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_base_url,
    base_url_fragment);

  params->base_url.Set(
      base_url_fragment.is_null() ? nullptr : base_url_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::web_package::mojom::BundleDataSourceInterfaceBase>>(
    in_data_source,
    &params->data_source,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->data_source)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid data_source in WebBundleParserFactory.GetParserForDataSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParserFactory::Name_);
  message.set_method_name("GetParserForDataSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebBundleParserFactoryProxy::BindFileDataSource(
    ::mojo::PendingReceiver<BundleDataSource> in_data_source, ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send web_package::mojom::WebBundleParserFactory::BindFileDataSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_source"), in_data_source,
                        "<value of type ::mojo::PendingReceiver<BundleDataSource>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBundleParserFactory::kBindFileDataSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParserFactory_BindFileDataSource_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::web_package::mojom::BundleDataSourceInterfaceBase>>(
    in_data_source,
    &params->data_source,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->data_source)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid data_source in WebBundleParserFactory.BindFileDataSource request");
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_file,
    file_fragment);

  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file in WebBundleParserFactory.BindFileDataSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParserFactory::Name_);
  message.set_method_name("BindFileDataSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebBundleParserFactoryStubDispatch::Accept(
    WebBundleParserFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebBundleParserFactory>(message->header()->name)) {
    case messages::WebBundleParserFactory::kGetParserForDataSource: {
      DCHECK(message->is_serialized());
      internal::WebBundleParserFactory_GetParserForDataSource_Params_Data* params =
          reinterpret_cast<internal::WebBundleParserFactory_GetParserForDataSource_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebBundleParserFactory.0
      bool success = true;
      ::mojo::PendingReceiver<WebBundleParser> p_receiver{};
      std::optional<::GURL> p_base_url{};
      ::mojo::PendingRemote<BundleDataSource> p_data_source{};
      WebBundleParserFactory_GetParserForDataSource_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadBaseUrl(&p_base_url))
        success = false;
      if (success) {
        p_data_source =
            input_data_view.TakeDataSource<decltype(p_data_source)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleParserFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetParserForDataSource(        
        std::move(p_receiver), 
        std::move(p_base_url), 
        std::move(p_data_source));
      return true;
    }
    case messages::WebBundleParserFactory::kBindFileDataSource: {
      DCHECK(message->is_serialized());
      internal::WebBundleParserFactory_BindFileDataSource_Params_Data* params =
          reinterpret_cast<internal::WebBundleParserFactory_BindFileDataSource_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebBundleParserFactory.1
      bool success = true;
      ::mojo::PendingReceiver<BundleDataSource> p_data_source{};
      ::base::File p_file{};
      WebBundleParserFactory_BindFileDataSource_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_data_source =
            input_data_view.TakeDataSource<decltype(p_data_source)>();
      }
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleParserFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindFileDataSource(        
        std::move(p_data_source), 
        std::move(p_file));
      return true;
    }
  }
  return false;
}

// static
bool WebBundleParserFactoryStubDispatch::AcceptWithResponder(
    WebBundleParserFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebBundleParserFactory>(message->header()->name)) {
    case messages::WebBundleParserFactory::kGetParserForDataSource: {
      break;
    }
    case messages::WebBundleParserFactory::kBindFileDataSource: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebBundleParserFactoryValidationInfo[] = {
    { &internal::WebBundleParserFactory_GetParserForDataSource_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebBundleParserFactory_BindFileDataSource_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebBundleParserFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::web_package::mojom::WebBundleParserFactory::Name_,
    kWebBundleParserFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

WebBundleParser::IPCStableHashFunction WebBundleParser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebBundleParser>(message.name())) {
    case messages::WebBundleParser::kParseIntegrityBlock: {
      return &WebBundleParser::ParseIntegrityBlock_Sym::IPCStableHash;
    }
    case messages::WebBundleParser::kParseMetadata: {
      return &WebBundleParser::ParseMetadata_Sym::IPCStableHash;
    }
    case messages::WebBundleParser::kParseResponse: {
      return &WebBundleParser::ParseResponse_Sym::IPCStableHash;
    }
    case messages::WebBundleParser::kClose: {
      return &WebBundleParser::Close_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebBundleParser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebBundleParser>(message.name())) {
      case messages::WebBundleParser::kParseIntegrityBlock:
            return "Receive web_package::mojom::WebBundleParser::ParseIntegrityBlock";
      case messages::WebBundleParser::kParseMetadata:
            return "Receive web_package::mojom::WebBundleParser::ParseMetadata";
      case messages::WebBundleParser::kParseResponse:
            return "Receive web_package::mojom::WebBundleParser::ParseResponse";
      case messages::WebBundleParser::kClose:
            return "Receive web_package::mojom::WebBundleParser::Close";
    }
  } else {
    switch (static_cast<messages::WebBundleParser>(message.name())) {
      case messages::WebBundleParser::kParseIntegrityBlock:
            return "Receive reply web_package::mojom::WebBundleParser::ParseIntegrityBlock";
      case messages::WebBundleParser::kParseMetadata:
            return "Receive reply web_package::mojom::WebBundleParser::ParseMetadata";
      case messages::WebBundleParser::kParseResponse:
            return "Receive reply web_package::mojom::WebBundleParser::ParseResponse";
      case messages::WebBundleParser::kClose:
            return "Receive reply web_package::mojom::WebBundleParser::Close";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebBundleParser::ParseIntegrityBlock_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x944556a4;  // IPCStableHash for web_package::mojom::WebBundleParser::ParseIntegrityBlock
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBundleParser::ParseMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x84645625;  // IPCStableHash for web_package::mojom::WebBundleParser::ParseMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBundleParser::ParseResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe2bbc2a8;  // IPCStableHash for web_package::mojom::WebBundleParser::ParseResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBundleParser::Close_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb8cdd50;  // IPCStableHash for web_package::mojom::WebBundleParser::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebBundleParser_ParseIntegrityBlock_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBundleParser_ParseIntegrityBlock_ForwardToCallback(
      WebBundleParser::ParseIntegrityBlockCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBundleParser_ParseIntegrityBlock_ForwardToCallback(const WebBundleParser_ParseIntegrityBlock_ForwardToCallback&) = delete;
  WebBundleParser_ParseIntegrityBlock_ForwardToCallback& operator=(const WebBundleParser_ParseIntegrityBlock_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBundleParser::ParseIntegrityBlockCallback callback_;
};

class WebBundleParser_ParseMetadata_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBundleParser_ParseMetadata_ForwardToCallback(
      WebBundleParser::ParseMetadataCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBundleParser_ParseMetadata_ForwardToCallback(const WebBundleParser_ParseMetadata_ForwardToCallback&) = delete;
  WebBundleParser_ParseMetadata_ForwardToCallback& operator=(const WebBundleParser_ParseMetadata_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBundleParser::ParseMetadataCallback callback_;
};

class WebBundleParser_ParseResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBundleParser_ParseResponse_ForwardToCallback(
      WebBundleParser::ParseResponseCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBundleParser_ParseResponse_ForwardToCallback(const WebBundleParser_ParseResponse_ForwardToCallback&) = delete;
  WebBundleParser_ParseResponse_ForwardToCallback& operator=(const WebBundleParser_ParseResponse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBundleParser::ParseResponseCallback callback_;
};

class WebBundleParser_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBundleParser_Close_ForwardToCallback(
      WebBundleParser::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBundleParser_Close_ForwardToCallback(const WebBundleParser_Close_ForwardToCallback&) = delete;
  WebBundleParser_Close_ForwardToCallback& operator=(const WebBundleParser_Close_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBundleParser::CloseCallback callback_;
};

WebBundleParserProxy::WebBundleParserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebBundleParserProxy::ParseIntegrityBlock(
    ParseIntegrityBlockCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send web_package::mojom::WebBundleParser::ParseIntegrityBlock");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBundleParser::kParseIntegrityBlock), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParser_ParseIntegrityBlock_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParser::Name_);
  message.set_method_name("ParseIntegrityBlock");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBundleParser_ParseIntegrityBlock_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBundleParserProxy::ParseMetadata(
    std::optional<uint64_t> in_offset, ParseMetadataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send web_package::mojom::WebBundleParser::ParseMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type std::optional<uint64_t>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBundleParser::kParseMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParser_ParseMetadata_Params_Data> params(
          message);
  params.Allocate();
  params->offset_$flag = in_offset.has_value();
  if (in_offset.has_value()) {
    params->offset_$value = in_offset.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParser::Name_);
  message.set_method_name("ParseMetadata");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBundleParser_ParseMetadata_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBundleParserProxy::ParseResponse(
    uint64_t in_response_offset, uint64_t in_response_length, ParseResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send web_package::mojom::WebBundleParser::ParseResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_offset"), in_response_offset,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_length"), in_response_length,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBundleParser::kParseResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParser_ParseResponse_Params_Data> params(
          message);
  params.Allocate();

  params->response_offset = in_response_offset;

  params->response_length = in_response_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParser::Name_);
  message.set_method_name("ParseResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBundleParser_ParseResponse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBundleParserProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send web_package::mojom::WebBundleParser::Close");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBundleParser::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParser_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParser::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBundleParser_Close_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebBundleParser_ParseIntegrityBlock_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBundleParser::ParseIntegrityBlockCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBundleParser_ParseIntegrityBlock_ProxyToResponder> proxy(
        new WebBundleParser_ParseIntegrityBlock_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBundleParser_ParseIntegrityBlock_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBundleParser_ParseIntegrityBlock_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBundleParser_ParseIntegrityBlock_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBundleParser::ParseIntegrityBlockCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      BundleIntegrityBlockPtr in_Result, BundleIntegrityBlockParseErrorPtr in_error);
};

bool WebBundleParser_ParseIntegrityBlock_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBundleParser_ParseIntegrityBlock_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBundleParser_ParseIntegrityBlock_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBundleParser.0
  bool success = true;
  BundleIntegrityBlockPtr p_Result{};
  BundleIntegrityBlockParseErrorPtr p_error{};
  WebBundleParser_ParseIntegrityBlock_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_Result))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBundleParser::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_Result), 
std::move(p_error));
  }
  return true;
}

void WebBundleParser_ParseIntegrityBlock_ProxyToResponder::Run(
    BundleIntegrityBlockPtr in_Result, BundleIntegrityBlockParseErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply web_package::mojom::WebBundleParser::ParseIntegrityBlock", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("Result"), in_Result,
                        "<value of type BundleIntegrityBlockPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type BundleIntegrityBlockParseErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBundleParser::kParseIntegrityBlock), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParser_ParseIntegrityBlock_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->Result)::BaseType> Result_fragment(
          params.message());
  
  mojo::internal::Serialize<::web_package::mojom::BundleIntegrityBlockDataView>(
    in_Result,
    Result_fragment);

  params->Result.Set(
      Result_fragment.is_null() ? nullptr : Result_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::web_package::mojom::BundleIntegrityBlockParseErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParser::Name_);
  message.set_method_name("ParseIntegrityBlock");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBundleParser_ParseMetadata_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBundleParser::ParseMetadataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBundleParser_ParseMetadata_ProxyToResponder> proxy(
        new WebBundleParser_ParseMetadata_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBundleParser_ParseMetadata_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBundleParser_ParseMetadata_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBundleParser_ParseMetadata_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBundleParser::ParseMetadataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      BundleMetadataPtr in_Result, BundleMetadataParseErrorPtr in_error);
};

bool WebBundleParser_ParseMetadata_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBundleParser_ParseMetadata_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBundleParser_ParseMetadata_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBundleParser.1
  bool success = true;
  BundleMetadataPtr p_Result{};
  BundleMetadataParseErrorPtr p_error{};
  WebBundleParser_ParseMetadata_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_Result))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBundleParser::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_Result), 
std::move(p_error));
  }
  return true;
}

void WebBundleParser_ParseMetadata_ProxyToResponder::Run(
    BundleMetadataPtr in_Result, BundleMetadataParseErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply web_package::mojom::WebBundleParser::ParseMetadata", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("Result"), in_Result,
                        "<value of type BundleMetadataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type BundleMetadataParseErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBundleParser::kParseMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParser_ParseMetadata_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->Result)::BaseType> Result_fragment(
          params.message());
  
  mojo::internal::Serialize<::web_package::mojom::BundleMetadataDataView>(
    in_Result,
    Result_fragment);

  params->Result.Set(
      Result_fragment.is_null() ? nullptr : Result_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::web_package::mojom::BundleMetadataParseErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParser::Name_);
  message.set_method_name("ParseMetadata");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBundleParser_ParseResponse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBundleParser::ParseResponseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBundleParser_ParseResponse_ProxyToResponder> proxy(
        new WebBundleParser_ParseResponse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBundleParser_ParseResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBundleParser_ParseResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBundleParser_ParseResponse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBundleParser::ParseResponseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      BundleResponsePtr in_Result, BundleResponseParseErrorPtr in_error);
};

bool WebBundleParser_ParseResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBundleParser_ParseResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBundleParser_ParseResponse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBundleParser.2
  bool success = true;
  BundleResponsePtr p_Result{};
  BundleResponseParseErrorPtr p_error{};
  WebBundleParser_ParseResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_Result))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBundleParser::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_Result), 
std::move(p_error));
  }
  return true;
}

void WebBundleParser_ParseResponse_ProxyToResponder::Run(
    BundleResponsePtr in_Result, BundleResponseParseErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply web_package::mojom::WebBundleParser::ParseResponse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("Result"), in_Result,
                        "<value of type BundleResponsePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type BundleResponseParseErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBundleParser::kParseResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParser_ParseResponse_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->Result)::BaseType> Result_fragment(
          params.message());
  
  mojo::internal::Serialize<::web_package::mojom::BundleResponseDataView>(
    in_Result,
    Result_fragment);

  params->Result.Set(
      Result_fragment.is_null() ? nullptr : Result_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::web_package::mojom::BundleResponseParseErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParser::Name_);
  message.set_method_name("ParseResponse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBundleParser_Close_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBundleParser::CloseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBundleParser_Close_ProxyToResponder> proxy(
        new WebBundleParser_Close_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBundleParser_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBundleParser_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBundleParser_Close_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBundleParser::CloseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebBundleParser_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBundleParser_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBundleParser_Close_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBundleParser.3
  bool success = true;
  WebBundleParser_Close_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBundleParser::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebBundleParser_Close_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply web_package::mojom::WebBundleParser::Close");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBundleParser::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParser_Close_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParser::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebBundleParserStubDispatch::Accept(
    WebBundleParser* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebBundleParser>(message->header()->name)) {
    case messages::WebBundleParser::kParseIntegrityBlock: {
      break;
    }
    case messages::WebBundleParser::kParseMetadata: {
      break;
    }
    case messages::WebBundleParser::kParseResponse: {
      break;
    }
    case messages::WebBundleParser::kClose: {
      break;
    }
  }
  return false;
}

// static
bool WebBundleParserStubDispatch::AcceptWithResponder(
    WebBundleParser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebBundleParser>(message->header()->name)) {
    case messages::WebBundleParser::kParseIntegrityBlock: {
      internal::WebBundleParser_ParseIntegrityBlock_Params_Data* params =
          reinterpret_cast<
              internal::WebBundleParser_ParseIntegrityBlock_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBundleParser.0
      bool success = true;
      WebBundleParser_ParseIntegrityBlock_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleParser::Name_, 0, false);
        return false;
      }
      auto callback =
          WebBundleParser_ParseIntegrityBlock_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseIntegrityBlock(std::move(callback));
      return true;
    }
    case messages::WebBundleParser::kParseMetadata: {
      internal::WebBundleParser_ParseMetadata_Params_Data* params =
          reinterpret_cast<
              internal::WebBundleParser_ParseMetadata_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBundleParser.1
      bool success = true;
      std::optional<uint64_t> p_offset{};
      WebBundleParser_ParseMetadata_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_offset = input_data_view.offset();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleParser::Name_, 1, false);
        return false;
      }
      auto callback =
          WebBundleParser_ParseMetadata_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseMetadata(        
        std::move(p_offset), std::move(callback));
      return true;
    }
    case messages::WebBundleParser::kParseResponse: {
      internal::WebBundleParser_ParseResponse_Params_Data* params =
          reinterpret_cast<
              internal::WebBundleParser_ParseResponse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBundleParser.2
      bool success = true;
      uint64_t p_response_offset{};
      uint64_t p_response_length{};
      WebBundleParser_ParseResponse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_response_offset = input_data_view.response_offset();
      if (success)
        p_response_length = input_data_view.response_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleParser::Name_, 2, false);
        return false;
      }
      auto callback =
          WebBundleParser_ParseResponse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseResponse(        
        std::move(p_response_offset), 
        std::move(p_response_length), std::move(callback));
      return true;
    }
    case messages::WebBundleParser::kClose: {
      internal::WebBundleParser_Close_Params_Data* params =
          reinterpret_cast<
              internal::WebBundleParser_Close_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBundleParser.3
      bool success = true;
      WebBundleParser_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleParser::Name_, 3, false);
        return false;
      }
      auto callback =
          WebBundleParser_Close_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebBundleParserValidationInfo[] = {
    { &internal::WebBundleParser_ParseIntegrityBlock_Params_Data::Validate,
     &internal::WebBundleParser_ParseIntegrityBlock_ResponseParams_Data::Validate},
    { &internal::WebBundleParser_ParseMetadata_Params_Data::Validate,
     &internal::WebBundleParser_ParseMetadata_ResponseParams_Data::Validate},
    { &internal::WebBundleParser_ParseResponse_Params_Data::Validate,
     &internal::WebBundleParser_ParseResponse_ResponseParams_Data::Validate},
    { &internal::WebBundleParser_Close_Params_Data::Validate,
     &internal::WebBundleParser_Close_ResponseParams_Data::Validate},
};

bool WebBundleParserRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::web_package::mojom::WebBundleParser::Name_,
    kWebBundleParserValidationInfo);
}

bool WebBundleParserResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::web_package::mojom::WebBundleParser::Name_,
    kWebBundleParserValidationInfo);
}
// The declaration includes the definition on other builds.

BundleDataSource::IPCStableHashFunction BundleDataSource::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BundleDataSource>(message.name())) {
    case messages::BundleDataSource::kRead: {
      return &BundleDataSource::Read_Sym::IPCStableHash;
    }
    case messages::BundleDataSource::kLength: {
      return &BundleDataSource::Length_Sym::IPCStableHash;
    }
    case messages::BundleDataSource::kIsRandomAccessContext: {
      return &BundleDataSource::IsRandomAccessContext_Sym::IPCStableHash;
    }
    case messages::BundleDataSource::kClose: {
      return &BundleDataSource::Close_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BundleDataSource::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BundleDataSource>(message.name())) {
      case messages::BundleDataSource::kRead:
            return "Receive web_package::mojom::BundleDataSource::Read";
      case messages::BundleDataSource::kLength:
            return "Receive web_package::mojom::BundleDataSource::Length";
      case messages::BundleDataSource::kIsRandomAccessContext:
            return "Receive web_package::mojom::BundleDataSource::IsRandomAccessContext";
      case messages::BundleDataSource::kClose:
            return "Receive web_package::mojom::BundleDataSource::Close";
    }
  } else {
    switch (static_cast<messages::BundleDataSource>(message.name())) {
      case messages::BundleDataSource::kRead:
            return "Receive reply web_package::mojom::BundleDataSource::Read";
      case messages::BundleDataSource::kLength:
            return "Receive reply web_package::mojom::BundleDataSource::Length";
      case messages::BundleDataSource::kIsRandomAccessContext:
            return "Receive reply web_package::mojom::BundleDataSource::IsRandomAccessContext";
      case messages::BundleDataSource::kClose:
            return "Receive reply web_package::mojom::BundleDataSource::Close";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BundleDataSource::Read_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5110eefe;  // IPCStableHash for web_package::mojom::BundleDataSource::Read
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BundleDataSource::Length_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xafe896ac;  // IPCStableHash for web_package::mojom::BundleDataSource::Length
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BundleDataSource::IsRandomAccessContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4a33b6f9;  // IPCStableHash for web_package::mojom::BundleDataSource::IsRandomAccessContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BundleDataSource::Close_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfd07b763;  // IPCStableHash for web_package::mojom::BundleDataSource::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BundleDataSource_Read_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BundleDataSource_Read_ForwardToCallback(
      BundleDataSource::ReadCallback callback
      ) : callback_(std::move(callback)) {
  }

  BundleDataSource_Read_ForwardToCallback(const BundleDataSource_Read_ForwardToCallback&) = delete;
  BundleDataSource_Read_ForwardToCallback& operator=(const BundleDataSource_Read_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BundleDataSource::ReadCallback callback_;
};

class BundleDataSource_Length_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BundleDataSource_Length_ForwardToCallback(
      BundleDataSource::LengthCallback callback
      ) : callback_(std::move(callback)) {
  }

  BundleDataSource_Length_ForwardToCallback(const BundleDataSource_Length_ForwardToCallback&) = delete;
  BundleDataSource_Length_ForwardToCallback& operator=(const BundleDataSource_Length_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BundleDataSource::LengthCallback callback_;
};

class BundleDataSource_IsRandomAccessContext_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BundleDataSource_IsRandomAccessContext_ForwardToCallback(
      BundleDataSource::IsRandomAccessContextCallback callback
      ) : callback_(std::move(callback)) {
  }

  BundleDataSource_IsRandomAccessContext_ForwardToCallback(const BundleDataSource_IsRandomAccessContext_ForwardToCallback&) = delete;
  BundleDataSource_IsRandomAccessContext_ForwardToCallback& operator=(const BundleDataSource_IsRandomAccessContext_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BundleDataSource::IsRandomAccessContextCallback callback_;
};

class BundleDataSource_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BundleDataSource_Close_ForwardToCallback(
      BundleDataSource::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }

  BundleDataSource_Close_ForwardToCallback(const BundleDataSource_Close_ForwardToCallback&) = delete;
  BundleDataSource_Close_ForwardToCallback& operator=(const BundleDataSource_Close_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BundleDataSource::CloseCallback callback_;
};

BundleDataSourceProxy::BundleDataSourceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BundleDataSourceProxy::Read(
    uint64_t in_offset, uint64_t in_length, ReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send web_package::mojom::BundleDataSource::Read", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BundleDataSource::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::BundleDataSource_Read_Params_Data> params(
          message);
  params.Allocate();

  params->offset = in_offset;

  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BundleDataSource::Name_);
  message.set_method_name("Read");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BundleDataSource_Read_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BundleDataSourceProxy::Length(
    LengthCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send web_package::mojom::BundleDataSource::Length");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BundleDataSource::kLength), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::BundleDataSource_Length_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BundleDataSource::Name_);
  message.set_method_name("Length");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BundleDataSource_Length_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BundleDataSourceProxy::IsRandomAccessContext(
    IsRandomAccessContextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send web_package::mojom::BundleDataSource::IsRandomAccessContext");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BundleDataSource::kIsRandomAccessContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::BundleDataSource_IsRandomAccessContext_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BundleDataSource::Name_);
  message.set_method_name("IsRandomAccessContext");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BundleDataSource_IsRandomAccessContext_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BundleDataSourceProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send web_package::mojom::BundleDataSource::Close");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BundleDataSource::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::BundleDataSource_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BundleDataSource::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BundleDataSource_Close_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BundleDataSource_Read_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BundleDataSource::ReadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BundleDataSource_Read_ProxyToResponder> proxy(
        new BundleDataSource_Read_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BundleDataSource_Read_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BundleDataSource_Read_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BundleDataSource_Read_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BundleDataSource::ReadCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::vector<uint8_t>>& in_buffer);
};

bool BundleDataSource_Read_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BundleDataSource_Read_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BundleDataSource_Read_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BundleDataSource.0
  bool success = true;
  std::optional<std::vector<uint8_t>> p_buffer{};
  BundleDataSource_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBuffer(&p_buffer))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BundleDataSource::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_buffer));
  }
  return true;
}

void BundleDataSource_Read_ProxyToResponder::Run(
    const std::optional<std::vector<uint8_t>>& in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply web_package::mojom::BundleDataSource::Read", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type const std::optional<std::vector<uint8_t>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BundleDataSource::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::BundleDataSource_Read_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType>
      buffer_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& buffer_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_buffer,
    buffer_fragment,
    &buffer_validate_params);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BundleDataSource::Name_);
  message.set_method_name("Read");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BundleDataSource_Length_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BundleDataSource::LengthCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BundleDataSource_Length_ProxyToResponder> proxy(
        new BundleDataSource_Length_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BundleDataSource_Length_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BundleDataSource_Length_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BundleDataSource_Length_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BundleDataSource::LengthCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_length);
};

bool BundleDataSource_Length_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BundleDataSource_Length_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BundleDataSource_Length_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BundleDataSource.1
  bool success = true;
  int64_t p_length{};
  BundleDataSource_Length_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_length = input_data_view.length();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BundleDataSource::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_length));
  }
  return true;
}

void BundleDataSource_Length_ProxyToResponder::Run(
    int64_t in_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply web_package::mojom::BundleDataSource::Length", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BundleDataSource::kLength), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::BundleDataSource_Length_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BundleDataSource::Name_);
  message.set_method_name("Length");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BundleDataSource_IsRandomAccessContext_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BundleDataSource::IsRandomAccessContextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BundleDataSource_IsRandomAccessContext_ProxyToResponder> proxy(
        new BundleDataSource_IsRandomAccessContext_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BundleDataSource_IsRandomAccessContext_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BundleDataSource_IsRandomAccessContext_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BundleDataSource_IsRandomAccessContext_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BundleDataSource::IsRandomAccessContextCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_random_access);
};

bool BundleDataSource_IsRandomAccessContext_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BundleDataSource_IsRandomAccessContext_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BundleDataSource_IsRandomAccessContext_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BundleDataSource.2
  bool success = true;
  bool p_is_random_access{};
  BundleDataSource_IsRandomAccessContext_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_random_access = input_data_view.is_random_access();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BundleDataSource::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_random_access));
  }
  return true;
}

void BundleDataSource_IsRandomAccessContext_ProxyToResponder::Run(
    bool in_is_random_access) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply web_package::mojom::BundleDataSource::IsRandomAccessContext", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_random_access"), in_is_random_access,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BundleDataSource::kIsRandomAccessContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::BundleDataSource_IsRandomAccessContext_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_random_access = in_is_random_access;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BundleDataSource::Name_);
  message.set_method_name("IsRandomAccessContext");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BundleDataSource_Close_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BundleDataSource::CloseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BundleDataSource_Close_ProxyToResponder> proxy(
        new BundleDataSource_Close_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BundleDataSource_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BundleDataSource_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BundleDataSource_Close_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BundleDataSource::CloseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool BundleDataSource_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BundleDataSource_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BundleDataSource_Close_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BundleDataSource.3
  bool success = true;
  BundleDataSource_Close_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BundleDataSource::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void BundleDataSource_Close_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply web_package::mojom::BundleDataSource::Close");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BundleDataSource::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::BundleDataSource_Close_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BundleDataSource::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BundleDataSourceStubDispatch::Accept(
    BundleDataSource* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BundleDataSource>(message->header()->name)) {
    case messages::BundleDataSource::kRead: {
      break;
    }
    case messages::BundleDataSource::kLength: {
      break;
    }
    case messages::BundleDataSource::kIsRandomAccessContext: {
      break;
    }
    case messages::BundleDataSource::kClose: {
      break;
    }
  }
  return false;
}

// static
bool BundleDataSourceStubDispatch::AcceptWithResponder(
    BundleDataSource* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BundleDataSource>(message->header()->name)) {
    case messages::BundleDataSource::kRead: {
      internal::BundleDataSource_Read_Params_Data* params =
          reinterpret_cast<
              internal::BundleDataSource_Read_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BundleDataSource.0
      bool success = true;
      uint64_t p_offset{};
      uint64_t p_length{};
      BundleDataSource_Read_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_length = input_data_view.length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BundleDataSource::Name_, 0, false);
        return false;
      }
      auto callback =
          BundleDataSource_Read_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Read(        
        std::move(p_offset), 
        std::move(p_length), std::move(callback));
      return true;
    }
    case messages::BundleDataSource::kLength: {
      internal::BundleDataSource_Length_Params_Data* params =
          reinterpret_cast<
              internal::BundleDataSource_Length_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BundleDataSource.1
      bool success = true;
      BundleDataSource_Length_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BundleDataSource::Name_, 1, false);
        return false;
      }
      auto callback =
          BundleDataSource_Length_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Length(std::move(callback));
      return true;
    }
    case messages::BundleDataSource::kIsRandomAccessContext: {
      internal::BundleDataSource_IsRandomAccessContext_Params_Data* params =
          reinterpret_cast<
              internal::BundleDataSource_IsRandomAccessContext_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BundleDataSource.2
      bool success = true;
      BundleDataSource_IsRandomAccessContext_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BundleDataSource::Name_, 2, false);
        return false;
      }
      auto callback =
          BundleDataSource_IsRandomAccessContext_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsRandomAccessContext(std::move(callback));
      return true;
    }
    case messages::BundleDataSource::kClose: {
      internal::BundleDataSource_Close_Params_Data* params =
          reinterpret_cast<
              internal::BundleDataSource_Close_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BundleDataSource.3
      bool success = true;
      BundleDataSource_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BundleDataSource::Name_, 3, false);
        return false;
      }
      auto callback =
          BundleDataSource_Close_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBundleDataSourceValidationInfo[] = {
    { &internal::BundleDataSource_Read_Params_Data::Validate,
     &internal::BundleDataSource_Read_ResponseParams_Data::Validate},
    { &internal::BundleDataSource_Length_Params_Data::Validate,
     &internal::BundleDataSource_Length_ResponseParams_Data::Validate},
    { &internal::BundleDataSource_IsRandomAccessContext_Params_Data::Validate,
     &internal::BundleDataSource_IsRandomAccessContext_ResponseParams_Data::Validate},
    { &internal::BundleDataSource_Close_Params_Data::Validate,
     &internal::BundleDataSource_Close_ResponseParams_Data::Validate},
};

bool BundleDataSourceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::web_package::mojom::BundleDataSource::Name_,
    kBundleDataSourceValidationInfo);
}

bool BundleDataSourceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::web_package::mojom::BundleDataSource::Name_,
    kBundleDataSourceValidationInfo);
}


}  // web_package::mojom


namespace mojo {


// static
bool StructTraits<::web_package::mojom::BundleIntegrityBlockParseError::DataView, ::web_package::mojom::BundleIntegrityBlockParseErrorPtr>::Read(
    ::web_package::mojom::BundleIntegrityBlockParseError::DataView input,
    ::web_package::mojom::BundleIntegrityBlockParseErrorPtr* output) {
  bool success = true;
  ::web_package::mojom::BundleIntegrityBlockParseErrorPtr result(::web_package::mojom::BundleIntegrityBlockParseError::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::BundleMetadataParseError::DataView, ::web_package::mojom::BundleMetadataParseErrorPtr>::Read(
    ::web_package::mojom::BundleMetadataParseError::DataView input,
    ::web_package::mojom::BundleMetadataParseErrorPtr* output) {
  bool success = true;
  ::web_package::mojom::BundleMetadataParseErrorPtr result(::web_package::mojom::BundleMetadataParseError::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::BundleResponseParseError::DataView, ::web_package::mojom::BundleResponseParseErrorPtr>::Read(
    ::web_package::mojom::BundleResponseParseError::DataView input,
    ::web_package::mojom::BundleResponseParseErrorPtr* output) {
  bool success = true;
  ::web_package::mojom::BundleResponseParseErrorPtr result(::web_package::mojom::BundleResponseParseError::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::BundleIntegrityBlockAttributes::DataView, ::web_package::mojom::BundleIntegrityBlockAttributesPtr>::Read(
    ::web_package::mojom::BundleIntegrityBlockAttributes::DataView input,
    ::web_package::mojom::BundleIntegrityBlockAttributesPtr* output) {
  bool success = true;
  ::web_package::mojom::BundleIntegrityBlockAttributesPtr result(::web_package::mojom::BundleIntegrityBlockAttributes::New());
  
      if (success && !input.ReadWebBundleId(&result->web_bundle_id))
        success = false;
      if (success && !input.ReadCbor(&result->cbor))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::BundleIntegrityBlock::DataView, ::web_package::mojom::BundleIntegrityBlockPtr>::Read(
    ::web_package::mojom::BundleIntegrityBlock::DataView input,
    ::web_package::mojom::BundleIntegrityBlockPtr* output) {
  bool success = true;
  ::web_package::mojom::BundleIntegrityBlockPtr result(::web_package::mojom::BundleIntegrityBlock::New());
  
      if (success)
        result->size = input.size();
      if (success && !input.ReadSignatureStack(&result->signature_stack))
        success = false;
      if (success && !input.ReadAttributes(&result->attributes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::Ed25519PublicKey::DataView, ::web_package::mojom::Ed25519PublicKeyPtr>::Read(
    ::web_package::mojom::Ed25519PublicKey::DataView input,
    ::web_package::mojom::Ed25519PublicKeyPtr* output) {
  bool success = true;
  ::web_package::mojom::Ed25519PublicKeyPtr result(::web_package::mojom::Ed25519PublicKey::New());
  
      if (success && !input.ReadBytes(&result->bytes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::Ed25519Signature::DataView, ::web_package::mojom::Ed25519SignaturePtr>::Read(
    ::web_package::mojom::Ed25519Signature::DataView input,
    ::web_package::mojom::Ed25519SignaturePtr* output) {
  bool success = true;
  ::web_package::mojom::Ed25519SignaturePtr result(::web_package::mojom::Ed25519Signature::New());
  
      if (success && !input.ReadBytes(&result->bytes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::SignatureInfoEd25519::DataView, ::web_package::mojom::SignatureInfoEd25519Ptr>::Read(
    ::web_package::mojom::SignatureInfoEd25519::DataView input,
    ::web_package::mojom::SignatureInfoEd25519Ptr* output) {
  bool success = true;
  ::web_package::mojom::SignatureInfoEd25519Ptr result(::web_package::mojom::SignatureInfoEd25519::New());
  
      if (success && !input.ReadPublicKey(&result->public_key))
        success = false;
      if (success && !input.ReadSignature(&result->signature))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::EcdsaP256PublicKey::DataView, ::web_package::mojom::EcdsaP256PublicKeyPtr>::Read(
    ::web_package::mojom::EcdsaP256PublicKey::DataView input,
    ::web_package::mojom::EcdsaP256PublicKeyPtr* output) {
  bool success = true;
  ::web_package::mojom::EcdsaP256PublicKeyPtr result(::web_package::mojom::EcdsaP256PublicKey::New());
  
      if (success && !input.ReadBytes(&result->bytes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::EcdsaP256SHA256Signature::DataView, ::web_package::mojom::EcdsaP256SHA256SignaturePtr>::Read(
    ::web_package::mojom::EcdsaP256SHA256Signature::DataView input,
    ::web_package::mojom::EcdsaP256SHA256SignaturePtr* output) {
  bool success = true;
  ::web_package::mojom::EcdsaP256SHA256SignaturePtr result(::web_package::mojom::EcdsaP256SHA256Signature::New());
  
      if (success && !input.ReadBytes(&result->bytes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::SignatureInfoEcdsaP256SHA256::DataView, ::web_package::mojom::SignatureInfoEcdsaP256SHA256Ptr>::Read(
    ::web_package::mojom::SignatureInfoEcdsaP256SHA256::DataView input,
    ::web_package::mojom::SignatureInfoEcdsaP256SHA256Ptr* output) {
  bool success = true;
  ::web_package::mojom::SignatureInfoEcdsaP256SHA256Ptr result(::web_package::mojom::SignatureInfoEcdsaP256SHA256::New());
  
      if (success && !input.ReadPublicKey(&result->public_key))
        success = false;
      if (success && !input.ReadSignature(&result->signature))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::SignatureInfoUnknown::DataView, ::web_package::mojom::SignatureInfoUnknownPtr>::Read(
    ::web_package::mojom::SignatureInfoUnknown::DataView input,
    ::web_package::mojom::SignatureInfoUnknownPtr* output) {
  bool success = true;
  ::web_package::mojom::SignatureInfoUnknownPtr result(::web_package::mojom::SignatureInfoUnknown::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::BundleIntegrityBlockSignatureStackEntry::DataView, ::web_package::mojom::BundleIntegrityBlockSignatureStackEntryPtr>::Read(
    ::web_package::mojom::BundleIntegrityBlockSignatureStackEntry::DataView input,
    ::web_package::mojom::BundleIntegrityBlockSignatureStackEntryPtr* output) {
  bool success = true;
  ::web_package::mojom::BundleIntegrityBlockSignatureStackEntryPtr result(::web_package::mojom::BundleIntegrityBlockSignatureStackEntry::New());
  
      if (success && !input.ReadAttributesCbor(&result->attributes_cbor))
        success = false;
      if (success && !input.ReadSignatureInfo(&result->signature_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::BundleMetadata::DataView, ::web_package::mojom::BundleMetadataPtr>::Read(
    ::web_package::mojom::BundleMetadata::DataView input,
    ::web_package::mojom::BundleMetadataPtr* output) {
  bool success = true;
  ::web_package::mojom::BundleMetadataPtr result(::web_package::mojom::BundleMetadata::New());
  
      if (success && !input.ReadVersion(&result->version))
        success = false;
      if (success && !input.ReadPrimaryUrl(&result->primary_url))
        success = false;
      if (success && !input.ReadRequests(&result->requests))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::BundleResponseLocation::DataView, ::web_package::mojom::BundleResponseLocationPtr>::Read(
    ::web_package::mojom::BundleResponseLocation::DataView input,
    ::web_package::mojom::BundleResponseLocationPtr* output) {
  bool success = true;
  ::web_package::mojom::BundleResponseLocationPtr result(::web_package::mojom::BundleResponseLocation::New());
  
      if (success)
        result->offset = input.offset();
      if (success)
        result->length = input.length();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::BundleResponse::DataView, ::web_package::mojom::BundleResponsePtr>::Read(
    ::web_package::mojom::BundleResponse::DataView input,
    ::web_package::mojom::BundleResponsePtr* output) {
  bool success = true;
  ::web_package::mojom::BundleResponsePtr result(::web_package::mojom::BundleResponse::New());
  
      if (success)
        result->response_code = input.response_code();
      if (success && !input.ReadResponseHeaders(&result->response_headers))
        success = false;
      if (success)
        result->payload_offset = input.payload_offset();
      if (success)
        result->payload_length = input.payload_length();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::web_package::mojom::SignatureInfo::DataView, ::web_package::mojom::SignatureInfoPtr>::Read(
    ::web_package::mojom::SignatureInfo::DataView input,
    ::web_package::mojom::SignatureInfoPtr* output) {
  using UnionType = ::web_package::mojom::SignatureInfo;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kUnknown: {
      ::web_package::mojom::SignatureInfoUnknownPtr result_unknown{};
      if (!input.ReadUnknown(&result_unknown))
        return false;

      *output = UnionType::NewUnknown(
          std::move(result_unknown));
      break;
    }
    case Tag::kEd25519: {
      ::web_package::mojom::SignatureInfoEd25519Ptr result_ed25519{};
      if (!input.ReadEd25519(&result_ed25519))
        return false;

      *output = UnionType::NewEd25519(
          std::move(result_ed25519));
      break;
    }
    case Tag::kEcdsaP256Sha256: {
      ::web_package::mojom::SignatureInfoEcdsaP256SHA256Ptr result_ecdsa_p256_sha256{};
      if (!input.ReadEcdsaP256Sha256(&result_ecdsa_p256_sha256))
        return false;

      *output = UnionType::NewEcdsaP256Sha256(
          std::move(result_ecdsa_p256_sha256));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace web_package::mojom {


void WebBundleParserFactoryInterceptorForTesting::GetParserForDataSource(::mojo::PendingReceiver<WebBundleParser> receiver, const std::optional<::GURL>& base_url, ::mojo::PendingRemote<BundleDataSource> data_source) {
  GetForwardingInterface()->GetParserForDataSource(
    std::move(receiver)
    , 
    std::move(base_url)
    , 
    std::move(data_source)
    );
}
void WebBundleParserFactoryInterceptorForTesting::BindFileDataSource(::mojo::PendingReceiver<BundleDataSource> data_source, ::base::File file) {
  GetForwardingInterface()->BindFileDataSource(
    std::move(data_source)
    , 
    std::move(file)
    );
}
WebBundleParserFactoryAsyncWaiter::WebBundleParserFactoryAsyncWaiter(
    WebBundleParserFactory* proxy) : proxy_(proxy) {}

WebBundleParserFactoryAsyncWaiter::~WebBundleParserFactoryAsyncWaiter() = default;





void WebBundleParserInterceptorForTesting::ParseIntegrityBlock(ParseIntegrityBlockCallback callback) {
  GetForwardingInterface()->ParseIntegrityBlock(std::move(callback));
}
void WebBundleParserInterceptorForTesting::ParseMetadata(std::optional<uint64_t> offset, ParseMetadataCallback callback) {
  GetForwardingInterface()->ParseMetadata(
    std::move(offset)
    , std::move(callback));
}
void WebBundleParserInterceptorForTesting::ParseResponse(uint64_t response_offset, uint64_t response_length, ParseResponseCallback callback) {
  GetForwardingInterface()->ParseResponse(
    std::move(response_offset)
    , 
    std::move(response_length)
    , std::move(callback));
}
void WebBundleParserInterceptorForTesting::Close(CloseCallback callback) {
  GetForwardingInterface()->Close(std::move(callback));
}
WebBundleParserAsyncWaiter::WebBundleParserAsyncWaiter(
    WebBundleParser* proxy) : proxy_(proxy) {}

WebBundleParserAsyncWaiter::~WebBundleParserAsyncWaiter() = default;


void WebBundleParserAsyncWaiter::ParseIntegrityBlock(
    BundleIntegrityBlockPtr* out_Result, BundleIntegrityBlockParseErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->ParseIntegrityBlock(
      base::BindOnce(
          [](base::RunLoop* loop,
             BundleIntegrityBlockPtr* out_Result
,
             BundleIntegrityBlockParseErrorPtr* out_error
,
             BundleIntegrityBlockPtr Result,
             BundleIntegrityBlockParseErrorPtr error) {*out_Result = std::move(Result);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_Result,
          out_error));
  loop.Run();
}



void WebBundleParserAsyncWaiter::ParseMetadata(
    std::optional<uint64_t> offset, BundleMetadataPtr* out_Result, BundleMetadataParseErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->ParseMetadata(
      std::move(offset),
      base::BindOnce(
          [](base::RunLoop* loop,
             BundleMetadataPtr* out_Result
,
             BundleMetadataParseErrorPtr* out_error
,
             BundleMetadataPtr Result,
             BundleMetadataParseErrorPtr error) {*out_Result = std::move(Result);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_Result,
          out_error));
  loop.Run();
}



void WebBundleParserAsyncWaiter::ParseResponse(
    uint64_t response_offset, uint64_t response_length, BundleResponsePtr* out_Result, BundleResponseParseErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->ParseResponse(
      std::move(response_offset),
      std::move(response_length),
      base::BindOnce(
          [](base::RunLoop* loop,
             BundleResponsePtr* out_Result
,
             BundleResponseParseErrorPtr* out_error
,
             BundleResponsePtr Result,
             BundleResponseParseErrorPtr error) {*out_Result = std::move(Result);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_Result,
          out_error));
  loop.Run();
}



void WebBundleParserAsyncWaiter::Close(
    ) {
  base::RunLoop loop;
  proxy_->Close(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void BundleDataSourceInterceptorForTesting::Read(uint64_t offset, uint64_t length, ReadCallback callback) {
  GetForwardingInterface()->Read(
    std::move(offset)
    , 
    std::move(length)
    , std::move(callback));
}
void BundleDataSourceInterceptorForTesting::Length(LengthCallback callback) {
  GetForwardingInterface()->Length(std::move(callback));
}
void BundleDataSourceInterceptorForTesting::IsRandomAccessContext(IsRandomAccessContextCallback callback) {
  GetForwardingInterface()->IsRandomAccessContext(std::move(callback));
}
void BundleDataSourceInterceptorForTesting::Close(CloseCallback callback) {
  GetForwardingInterface()->Close(std::move(callback));
}
BundleDataSourceAsyncWaiter::BundleDataSourceAsyncWaiter(
    BundleDataSource* proxy) : proxy_(proxy) {}

BundleDataSourceAsyncWaiter::~BundleDataSourceAsyncWaiter() = default;


void BundleDataSourceAsyncWaiter::Read(
    uint64_t offset, uint64_t length, std::optional<std::vector<uint8_t>>* out_buffer) {
  base::RunLoop loop;
  proxy_->Read(
      std::move(offset),
      std::move(length),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::vector<uint8_t>>* out_buffer
,
             const std::optional<std::vector<uint8_t>>& buffer) {*out_buffer = std::move(buffer);
            loop->Quit();
          },
          &loop,
          out_buffer));
  loop.Run();
}

std::optional<std::vector<uint8_t>> BundleDataSourceAsyncWaiter::Read(
    uint64_t offset, uint64_t length) {
  std::optional<std::vector<uint8_t>> async_wait_result;
  Read(std::move(offset),std::move(length),&async_wait_result);
  return async_wait_result;
}

void BundleDataSourceAsyncWaiter::Length(
    int64_t* out_length) {
  base::RunLoop loop;
  proxy_->Length(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_length
,
             int64_t length) {*out_length = std::move(length);
            loop->Quit();
          },
          &loop,
          out_length));
  loop.Run();
}

int64_t BundleDataSourceAsyncWaiter::Length(
    ) {
  int64_t async_wait_result;
  Length(&async_wait_result);
  return async_wait_result;
}

void BundleDataSourceAsyncWaiter::IsRandomAccessContext(
    bool* out_is_random_access) {
  base::RunLoop loop;
  proxy_->IsRandomAccessContext(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_random_access
,
             bool is_random_access) {*out_is_random_access = std::move(is_random_access);
            loop->Quit();
          },
          &loop,
          out_is_random_access));
  loop.Run();
}

bool BundleDataSourceAsyncWaiter::IsRandomAccessContext(
    ) {
  bool async_wait_result;
  IsRandomAccessContext(&async_wait_result);
  return async_wait_result;
}

void BundleDataSourceAsyncWaiter::Close(
    ) {
  base::RunLoop loop;
  proxy_->Close(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // web_package::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif