// components/wallet/content/common/mojom/image_extractor.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/wallet/content/common/mojom/image_extractor.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/wallet/content/common/mojom/image_extractor.mojom-params-data.h"
#include "components/wallet/content/common/mojom/image_extractor.mojom-shared-message-ids.h"

#include "components/wallet/content/common/mojom/image_extractor.mojom-import-headers.h"
#include "components/wallet/content/common/mojom/image_extractor.mojom-test-utils.h"


namespace wallet::mojom {
// The declaration includes the definition on other builds.

ImageExtractor::IPCStableHashFunction ImageExtractor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ImageExtractor>(message.name())) {
    case messages::ImageExtractor::kExtractImages: {
      return &ImageExtractor::ExtractImages_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ImageExtractor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ImageExtractor>(message.name())) {
      case messages::ImageExtractor::kExtractImages:
            return "Receive wallet::mojom::ImageExtractor::ExtractImages";
    }
  } else {
    switch (static_cast<messages::ImageExtractor>(message.name())) {
      case messages::ImageExtractor::kExtractImages:
            return "Receive reply wallet::mojom::ImageExtractor::ExtractImages";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ImageExtractor::ExtractImages_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7a4673fe;  // IPCStableHash for wallet::mojom::ImageExtractor::ExtractImages
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ImageExtractor_ExtractImages_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImageExtractor_ExtractImages_ForwardToCallback(
      ImageExtractor::ExtractImagesCallback callback
      ) : callback_(std::move(callback)) {
  }

  ImageExtractor_ExtractImages_ForwardToCallback(const ImageExtractor_ExtractImages_ForwardToCallback&) = delete;
  ImageExtractor_ExtractImages_ForwardToCallback& operator=(const ImageExtractor_ExtractImages_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ImageExtractor::ExtractImagesCallback callback_;
};

ImageExtractorProxy::ImageExtractorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ImageExtractorProxy::ExtractImages(
    ExtractImagesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send wallet::mojom::ImageExtractor::ExtractImages");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageExtractor::kExtractImages), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::wallet::mojom::internal::ImageExtractor_ExtractImages_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageExtractor::Name_);
  message.set_method_name("ExtractImages");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImageExtractor_ExtractImages_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ImageExtractor_ExtractImages_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ImageExtractor::ExtractImagesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ImageExtractor_ExtractImages_ProxyToResponder> proxy(
        new ImageExtractor_ExtractImages_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ImageExtractor_ExtractImages_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImageExtractor_ExtractImages_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ImageExtractor_ExtractImages_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ImageExtractor::ExtractImagesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::SkBitmap>& in_images);
};

bool ImageExtractor_ExtractImages_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ImageExtractor_ExtractImages_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImageExtractor_ExtractImages_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ImageExtractor.0
  bool success = true;
  std::vector<::SkBitmap> p_images{};
  ImageExtractor_ExtractImages_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadImages(&p_images))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImageExtractor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_images));
  }
  return true;
}

void ImageExtractor_ExtractImages_ProxyToResponder::Run(
    const std::vector<::SkBitmap>& in_images) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply wallet::mojom::ImageExtractor::ExtractImages", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("images"), in_images,
                        "<value of type const std::vector<::SkBitmap>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageExtractor::kExtractImages), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::wallet::mojom::internal::ImageExtractor_ExtractImages_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->images)::BaseType>
      images_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& images_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::skia::mojom::BitmapWithArbitraryBppDataView>>(
    in_images,
    images_fragment,
    &images_validate_params);

  params->images.Set(
      images_fragment.is_null() ? nullptr : images_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->images.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null images in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageExtractor::Name_);
  message.set_method_name("ExtractImages");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ImageExtractorStubDispatch::Accept(
    ImageExtractor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ImageExtractor>(message->header()->name)) {
    case messages::ImageExtractor::kExtractImages: {
      break;
    }
  }
  return false;
}

// static
bool ImageExtractorStubDispatch::AcceptWithResponder(
    ImageExtractor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ImageExtractor>(message->header()->name)) {
    case messages::ImageExtractor::kExtractImages: {
      internal::ImageExtractor_ExtractImages_Params_Data* params =
          reinterpret_cast<
              internal::ImageExtractor_ExtractImages_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ImageExtractor.0
      bool success = true;
      ImageExtractor_ExtractImages_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImageExtractor::Name_, 0, false);
        return false;
      }
      auto callback =
          ImageExtractor_ExtractImages_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractImages(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kImageExtractorValidationInfo[] = {
    { &internal::ImageExtractor_ExtractImages_Params_Data::Validate,
     &internal::ImageExtractor_ExtractImages_ResponseParams_Data::Validate},
};

bool ImageExtractorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::wallet::mojom::ImageExtractor::Name_,
    kImageExtractorValidationInfo);
}

bool ImageExtractorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::wallet::mojom::ImageExtractor::Name_,
    kImageExtractorValidationInfo);
}


}  // wallet::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace wallet::mojom {


void ImageExtractorInterceptorForTesting::ExtractImages(ExtractImagesCallback callback) {
  GetForwardingInterface()->ExtractImages(std::move(callback));
}
ImageExtractorAsyncWaiter::ImageExtractorAsyncWaiter(
    ImageExtractor* proxy) : proxy_(proxy) {}

ImageExtractorAsyncWaiter::~ImageExtractorAsyncWaiter() = default;


void ImageExtractorAsyncWaiter::ExtractImages(
    std::vector<::SkBitmap>* out_images) {
  base::RunLoop loop;
  proxy_->ExtractImages(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::SkBitmap>* out_images
,
             const std::vector<::SkBitmap>& images) {*out_images = std::move(images);
            loop->Quit();
          },
          &loop,
          out_images));
  loop.Run();
}

std::vector<::SkBitmap> ImageExtractorAsyncWaiter::ExtractImages(
    ) {
  std::vector<::SkBitmap> async_wait_result;
  ExtractImages(&async_wait_result);
  return async_wait_result;
}






}  // wallet::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif