// components/user_data_importer/mojom/bookmark_html_parser.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/user_data_importer/mojom/bookmark_html_parser.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/user_data_importer/mojom/bookmark_html_parser.mojom-params-data.h"
#include "components/user_data_importer/mojom/bookmark_html_parser.mojom-shared-message-ids.h"

#include "components/user_data_importer/mojom/bookmark_html_parser.mojom-import-headers.h"
#include "components/user_data_importer/mojom/bookmark_html_parser.mojom-test-utils.h"


namespace user_data_importer::mojom {
ImportedBookmarkEntry::ImportedBookmarkEntry()
    : is_folder(),
      url(),
      path(),
      title(),
      creation_time(),
      last_visit_time(),
      in_toolbar() {}

ImportedBookmarkEntry::ImportedBookmarkEntry(
    bool is_folder_in,
    const ::GURL& url_in,
    std::vector<::std::u16string> path_in,
    const ::std::u16string& title_in,
    ::base::Time creation_time_in,
    std::optional<::base::Time> last_visit_time_in,
    bool in_toolbar_in)
    : is_folder(std::move(is_folder_in)),
      url(std::move(url_in)),
      path(std::move(path_in)),
      title(std::move(title_in)),
      creation_time(std::move(creation_time_in)),
      last_visit_time(std::move(last_visit_time_in)),
      in_toolbar(std::move(in_toolbar_in)) {}

ImportedBookmarkEntry::~ImportedBookmarkEntry() = default;

void ImportedBookmarkEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_folder"), this->is_folder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "creation_time"), this->creation_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_visit_time"), this->last_visit_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in_toolbar"), this->in_toolbar,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ImportedBookmarkEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SearchEngineInfo::SearchEngineInfo()
    : display_name(),
      keyword(),
      url() {}

SearchEngineInfo::SearchEngineInfo(
    const ::std::u16string& display_name_in,
    const ::std::u16string& keyword_in,
    const ::std::u16string& url_in)
    : display_name(std::move(display_name_in)),
      keyword(std::move(keyword_in)),
      url(std::move(url_in)) {}

SearchEngineInfo::~SearchEngineInfo() = default;

void SearchEngineInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keyword"), this->keyword,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SearchEngineInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FaviconUsageData::FaviconUsageData()
    : favicon_url(),
      png_data(),
      urls() {}

FaviconUsageData::FaviconUsageData(
    const ::GURL& favicon_url_in,
    std::vector<uint8_t> png_data_in,
    std::vector<::GURL> urls_in)
    : favicon_url(std::move(favicon_url_in)),
      png_data(std::move(png_data_in)),
      urls(std::move(urls_in)) {}

FaviconUsageData::~FaviconUsageData() = default;

void FaviconUsageData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicon_url"), this->favicon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "png_data"), this->png_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "urls"), this->urls,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FaviconUsageData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ParsedBookmarks::ParsedBookmarks()
    : bookmarks(),
      reading_list(),
      search_engines(),
      favicons() {}

ParsedBookmarks::ParsedBookmarks(
    std::vector<::user_data_importer::ImportedBookmarkEntry> bookmarks_in,
    std::vector<::user_data_importer::ImportedBookmarkEntry> reading_list_in,
    std::vector<::user_data_importer::SearchEngineInfo> search_engines_in,
    std::vector<::favicon_base::FaviconUsageData> favicons_in)
    : bookmarks(std::move(bookmarks_in)),
      reading_list(std::move(reading_list_in)),
      search_engines(std::move(search_engines_in)),
      favicons(std::move(favicons_in)) {}

ParsedBookmarks::~ParsedBookmarks() = default;

void ParsedBookmarks::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bookmarks"), this->bookmarks,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::user_data_importer::ImportedBookmarkEntry>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reading_list"), this->reading_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::user_data_importer::ImportedBookmarkEntry>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "search_engines"), this->search_engines,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::user_data_importer::SearchEngineInfo>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicons"), this->favicons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::favicon_base::FaviconUsageData>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ParsedBookmarks::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

BookmarkHtmlParser::IPCStableHashFunction BookmarkHtmlParser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BookmarkHtmlParser>(message.name())) {
    case messages::BookmarkHtmlParser::kParse: {
      return &BookmarkHtmlParser::Parse_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BookmarkHtmlParser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BookmarkHtmlParser>(message.name())) {
      case messages::BookmarkHtmlParser::kParse:
            return "Receive user_data_importer::mojom::BookmarkHtmlParser::Parse";
    }
  } else {
    switch (static_cast<messages::BookmarkHtmlParser>(message.name())) {
      case messages::BookmarkHtmlParser::kParse:
            return "Receive reply user_data_importer::mojom::BookmarkHtmlParser::Parse";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BookmarkHtmlParser::Parse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xabddaf59;  // IPCStableHash for user_data_importer::mojom::BookmarkHtmlParser::Parse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BookmarkHtmlParser_Parse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BookmarkHtmlParser_Parse_ForwardToCallback(
      BookmarkHtmlParser::ParseCallback callback
      ) : callback_(std::move(callback)) {
  }

  BookmarkHtmlParser_Parse_ForwardToCallback(const BookmarkHtmlParser_Parse_ForwardToCallback&) = delete;
  BookmarkHtmlParser_Parse_ForwardToCallback& operator=(const BookmarkHtmlParser_Parse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BookmarkHtmlParser::ParseCallback callback_;
};

BookmarkHtmlParserProxy::BookmarkHtmlParserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BookmarkHtmlParserProxy::Parse(
    const std::string& in_raw_html, ParseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send user_data_importer::mojom::BookmarkHtmlParser::Parse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("raw_html"), in_raw_html,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkHtmlParser::kParse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::user_data_importer::mojom::internal::BookmarkHtmlParser_Parse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->raw_html)::BaseType> raw_html_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_raw_html,
    raw_html_fragment);

  params->raw_html.Set(
      raw_html_fragment.is_null() ? nullptr : raw_html_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->raw_html.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null raw_html in BookmarkHtmlParser.Parse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkHtmlParser::Name_);
  message.set_method_name("Parse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BookmarkHtmlParser_Parse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BookmarkHtmlParser_Parse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BookmarkHtmlParser::ParseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BookmarkHtmlParser_Parse_ProxyToResponder> proxy(
        new BookmarkHtmlParser_Parse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BookmarkHtmlParser_Parse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BookmarkHtmlParser_Parse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BookmarkHtmlParser_Parse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BookmarkHtmlParser::ParseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::user_data_importer::BookmarkParser::ParsedBookmarks in_result);
};

bool BookmarkHtmlParser_Parse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BookmarkHtmlParser_Parse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BookmarkHtmlParser_Parse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BookmarkHtmlParser.0
  bool success = true;
  ::user_data_importer::BookmarkParser::ParsedBookmarks p_result{};
  BookmarkHtmlParser_Parse_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BookmarkHtmlParser::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void BookmarkHtmlParser_Parse_ProxyToResponder::Run(
    ::user_data_importer::BookmarkParser::ParsedBookmarks in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply user_data_importer::mojom::BookmarkHtmlParser::Parse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::user_data_importer::BookmarkParser::ParsedBookmarks>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkHtmlParser::kParse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::user_data_importer::mojom::internal::BookmarkHtmlParser_Parse_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::user_data_importer::mojom::ParsedBookmarksDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkHtmlParser::Name_);
  message.set_method_name("Parse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BookmarkHtmlParserStubDispatch::Accept(
    BookmarkHtmlParser* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BookmarkHtmlParser>(message->header()->name)) {
    case messages::BookmarkHtmlParser::kParse: {
      break;
    }
  }
  return false;
}

// static
bool BookmarkHtmlParserStubDispatch::AcceptWithResponder(
    BookmarkHtmlParser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BookmarkHtmlParser>(message->header()->name)) {
    case messages::BookmarkHtmlParser::kParse: {
      internal::BookmarkHtmlParser_Parse_Params_Data* params =
          reinterpret_cast<
              internal::BookmarkHtmlParser_Parse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BookmarkHtmlParser.0
      bool success = true;
      std::string p_raw_html{};
      BookmarkHtmlParser_Parse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRawHtml(&p_raw_html))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarkHtmlParser::Name_, 0, false);
        return false;
      }
      auto callback =
          BookmarkHtmlParser_Parse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Parse(        
        std::move(p_raw_html), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBookmarkHtmlParserValidationInfo[] = {
    { &internal::BookmarkHtmlParser_Parse_Params_Data::Validate,
     &internal::BookmarkHtmlParser_Parse_ResponseParams_Data::Validate},
};

bool BookmarkHtmlParserRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::user_data_importer::mojom::BookmarkHtmlParser::Name_,
    kBookmarkHtmlParserValidationInfo);
}

bool BookmarkHtmlParserResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::user_data_importer::mojom::BookmarkHtmlParser::Name_,
    kBookmarkHtmlParserValidationInfo);
}


}  // user_data_importer::mojom


namespace mojo {


// static
bool StructTraits<::user_data_importer::mojom::ImportedBookmarkEntry::DataView, ::user_data_importer::mojom::ImportedBookmarkEntryPtr>::Read(
    ::user_data_importer::mojom::ImportedBookmarkEntry::DataView input,
    ::user_data_importer::mojom::ImportedBookmarkEntryPtr* output) {
  bool success = true;
  ::user_data_importer::mojom::ImportedBookmarkEntryPtr result(::user_data_importer::mojom::ImportedBookmarkEntry::New());
  
      if (success)
        result->is_folder = input.is_folder();
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadCreationTime(&result->creation_time))
        success = false;
      if (success && !input.ReadLastVisitTime(&result->last_visit_time))
        success = false;
      if (success)
        result->in_toolbar = input.in_toolbar();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::user_data_importer::mojom::SearchEngineInfo::DataView, ::user_data_importer::mojom::SearchEngineInfoPtr>::Read(
    ::user_data_importer::mojom::SearchEngineInfo::DataView input,
    ::user_data_importer::mojom::SearchEngineInfoPtr* output) {
  bool success = true;
  ::user_data_importer::mojom::SearchEngineInfoPtr result(::user_data_importer::mojom::SearchEngineInfo::New());
  
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadKeyword(&result->keyword))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::user_data_importer::mojom::FaviconUsageData::DataView, ::user_data_importer::mojom::FaviconUsageDataPtr>::Read(
    ::user_data_importer::mojom::FaviconUsageData::DataView input,
    ::user_data_importer::mojom::FaviconUsageDataPtr* output) {
  bool success = true;
  ::user_data_importer::mojom::FaviconUsageDataPtr result(::user_data_importer::mojom::FaviconUsageData::New());
  
      if (success && !input.ReadFaviconUrl(&result->favicon_url))
        success = false;
      if (success && !input.ReadPngData(&result->png_data))
        success = false;
      if (success && !input.ReadUrls(&result->urls))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::user_data_importer::mojom::ParsedBookmarks::DataView, ::user_data_importer::mojom::ParsedBookmarksPtr>::Read(
    ::user_data_importer::mojom::ParsedBookmarks::DataView input,
    ::user_data_importer::mojom::ParsedBookmarksPtr* output) {
  bool success = true;
  ::user_data_importer::mojom::ParsedBookmarksPtr result(::user_data_importer::mojom::ParsedBookmarks::New());
  
      if (success && !input.ReadBookmarks(&result->bookmarks))
        success = false;
      if (success && !input.ReadReadingList(&result->reading_list))
        success = false;
      if (success && !input.ReadSearchEngines(&result->search_engines))
        success = false;
      if (success && !input.ReadFavicons(&result->favicons))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace user_data_importer::mojom {


void BookmarkHtmlParserInterceptorForTesting::Parse(const std::string& raw_html, ParseCallback callback) {
  GetForwardingInterface()->Parse(
    std::move(raw_html)
    , std::move(callback));
}
BookmarkHtmlParserAsyncWaiter::BookmarkHtmlParserAsyncWaiter(
    BookmarkHtmlParser* proxy) : proxy_(proxy) {}

BookmarkHtmlParserAsyncWaiter::~BookmarkHtmlParserAsyncWaiter() = default;


void BookmarkHtmlParserAsyncWaiter::Parse(
    const std::string& raw_html, ::user_data_importer::BookmarkParser::ParsedBookmarks* out_result) {
  base::RunLoop loop;
  proxy_->Parse(
      std::move(raw_html),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::user_data_importer::BookmarkParser::ParsedBookmarks* out_result
,
             ::user_data_importer::BookmarkParser::ParsedBookmarks result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::user_data_importer::BookmarkParser::ParsedBookmarks BookmarkHtmlParserAsyncWaiter::Parse(
    const std::string& raw_html) {
  ::user_data_importer::BookmarkParser::ParsedBookmarks async_wait_result;
  Parse(std::move(raw_html),&async_wait_result);
  return async_wait_result;
}






}  // user_data_importer::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif