// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{sendWithPromise}from"chrome://resources/js/cr.js";import{getRequiredElement}from"chrome://resources/js/util.js";const clearedSources=new Map;const cachedSources=new Map;const URL_EMPTY="(missing)";const EXPAND_ALL_BUTTON_TEXT="Expand All";const COLLAPSE_ALL_BUTTON_TEXT="Collapse All";function as64Bit(num){if(num.length!==2){return"0"}if(!num[0]){return num[1].toString()}else{const hi=(num[0]>>>0).toString(16).padStart(8,"0");const lo=(num[1]>>>0).toString(16).padStart(8,"0");return`0x${hi}${lo}`}}function setDisplayStyle(elements,displayValue){for(const el of elements){el.style.display=displayValue}}function removeChildren(parent){while(parent.firstChild){parent.removeChild(parent.firstChild)}}function createSourceRowsForTheSameUrl(sourcesForUrl,sourcesTable,displayStates){if(!sourcesForUrl||sourcesForUrl.length===0){return}for(const source of sourcesForUrl){const sourceHtmlRow=document.createElement("tr");sourceHtmlRow.classList.add("source_container");sourcesTable.appendChild(sourceHtmlRow);const urlElement=populateSourceHtmlRow(source,sourceHtmlRow);const displayState=displayStates.get(as64Bit(source.id));createEventMetricTablesForSource(source,urlElement,displayState)}sourcesTable.lastElementChild.classList.add("thin-border-bottom")}function populateSourceHtmlRow(sourceData,sourceHtmlRow){const urlElement=document.createElement("td");urlElement.classList.add("url");urlElement.innerText=sourceData.url||URL_EMPTY;const idElement=document.createElement("td");idElement.classList.add("sourceid");idElement.innerText=as64Bit(sourceData.id);const typeElement=document.createElement("td");typeElement.classList.add("sourcetype");typeElement.innerText=sourceData.type;sourceHtmlRow.appendChild(urlElement);sourceHtmlRow.appendChild(idElement);sourceHtmlRow.appendChild(typeElement);urlElement.addEventListener("click",(()=>{const eventsTables=urlElement.lastChild;eventsTables.style.display=eventsTables.style.display==="block"?"none":"block"}));return urlElement}function createEventMetricTablesForSource(sourceData,urlElement,displayState){const eventMetricsElement=document.createElement("div");eventMetricsElement.classList.add("events");urlElement.appendChild(eventMetricsElement);if(displayState){eventMetricsElement.style.display=displayState}else{const expandedAll=getRequiredElement("toggle_expand").textContent===COLLAPSE_ALL_BUTTON_TEXT;eventMetricsElement.style.display=expandedAll?"block":"none"}if(sourceData.events.length===0){eventMetricsElement.textContent="(no events)";return}const sortedEvents=sourceData.events.sort(((e1,e2)=>e1.name.localeCompare(e2.name)));for(const event of sortedEvents){createEventMetricsTable(event,eventMetricsElement)}}function createEventMetricsTable(event,urlElement){const eventTable=document.createElement("table");eventTable.classList.add("event-table");eventTable.setAttribute("value",event.name);urlElement.appendChild(eventTable);const firstRow=document.createElement("tr");eventTable.appendChild(firstRow);const eventName=document.createElement("td");eventName.classList.add("event-name");eventName.setAttribute("rowspan","0");eventName.textContent=event.name;firstRow.appendChild(eventName);const sortedMetrics=event.metrics.sort(((m1,m2)=>m1.name.localeCompare(m2.name)));for(const metric of sortedMetrics){const nextRow=document.createElement("tr");const metricName=document.createElement("td");metricName.classList.add("metric-name");metricName.textContent=metric.name;nextRow.appendChild(metricName);const metricValue=document.createElement("td");metricValue.classList.add("metric-value");metricValue.textContent=as64Bit(metric.value);nextRow.appendChild(metricValue);eventTable.appendChild(nextRow)}}function urlToSourcesMapping(sources){const unsorted=new Map;for(const source of sources){const key=source.url?source.url:as64Bit(source.id);if(!unsorted.has(key)){unsorted.set(key,[source])}else{unsorted.get(key).push(source)}}return new Map(Array.from(unsorted).sort(((s1,s2)=>s1[0].localeCompare(s2[0]))))}function addExpandAllToggleButton(){const toggleExpand=getRequiredElement("toggle_expand");toggleExpand.textContent=EXPAND_ALL_BUTTON_TEXT;toggleExpand.addEventListener("click",(()=>{if(toggleExpand.textContent===EXPAND_ALL_BUTTON_TEXT){toggleExpand.textContent=COLLAPSE_ALL_BUTTON_TEXT;setDisplayStyle(document.body.querySelectorAll(".events"),"block")}else{toggleExpand.textContent=EXPAND_ALL_BUTTON_TEXT;setDisplayStyle(document.body.querySelectorAll(".events"),"none")}}))}function addClearButton(){const clearButton=getRequiredElement("clear");clearButton.addEventListener("click",(()=>{sendWithPromise("requestUkmData").then((data=>{updateUkmCache(data);for(const source of cachedSources.values()){clearedSources.set(as64Bit(source.id),source.events.length)}}));getRequiredElement("toggle_expand").textContent=EXPAND_ALL_BUTTON_TEXT;updateUkmData()}))}function populateThreadIds(sources){const threadIdSelect=document.body.querySelector("#thread_ids");assert(threadIdSelect);const currentOptions=new Set(Array.from(threadIdSelect.options).map((o=>o.value)));const newIds=new Set(sources.map((e=>(e.id[0]>>>0).toString(16))));const options=["All",...Array.from(newIds).sort()];for(const id of options){if(!currentOptions.has(id)){const option=document.createElement("option");option.textContent=id;option.setAttribute("value",id);threadIdSelect.add(option)}}}function normalizeToString(event){event.metrics.sort(((m1,m2)=>m1.name.localeCompare(m2.name)));return JSON.stringify(event)}function updateUkmCache(data){for(const source of data.sources){const key=as64Bit(source.id);if(!cachedSources.has(key)){const mergedSource={id:source.id,type:source.type,events:source.events};if(source.url){mergedSource.url=source.url}cachedSources.set(key,mergedSource)}else{const existingEvents=new Set(cachedSources.get(key).events.map((event=>normalizeToString(event))));for(const event of source.events){if(!existingEvents.has(normalizeToString(event))){cachedSources.get(key).events.push(event)}}}}}function updateUkmData(){sendWithPromise("requestUkmData").then((data=>{updateUkmCache(data);if(document.body.querySelector("#include_cache").checked){data.sources=[...cachedSources.values()]}getRequiredElement("state").innerText=data.state?"ENABLED":"DISABLED";getRequiredElement("msbb_state").innerText=data.msbb_state?"ENABLED":"DISABLED";getRequiredElement("extension_state").innerText=data.extension_state?"ENABLED":"DISABLED";getRequiredElement("app_state").innerText=data.app_state?"ENABLED":"DISABLED";getRequiredElement("clientid").innerText="0x"+data.client_id;getRequiredElement("sessionid").innerText=data.session_id;getRequiredElement("is_sampling_enabled").innerText=data.is_sampling_enabled;const sourcesTable=getRequiredElement("sources");removeChildren(sourcesTable);const tableHead=document.createElement("thead");const headerRow=document.createElement("tr");const urlTitleElement=document.createElement("td");urlTitleElement.classList.add("url");urlTitleElement.textContent="URL";const sourceIdTitleElement=document.createElement("td");sourceIdTitleElement.classList.add("sourceid");sourceIdTitleElement.textContent="Source ID";const sourceTypeTitleElement=document.createElement("td");sourceTypeTitleElement.classList.add("sourcetype");sourceTypeTitleElement.textContent="Source Type";headerRow.appendChild(urlTitleElement);headerRow.appendChild(sourceIdTitleElement);headerRow.appendChild(sourceTypeTitleElement);tableHead.appendChild(headerRow);sourcesTable.appendChild(tableHead);const tableBody=document.createElement("tbody");tableBody.classList.add("url_card");sourcesTable.appendChild(tableBody);const currentDisplayStates=new Map;for(const el of document.getElementsByClassName("source_container")){currentDisplayStates.set(el.querySelector(".sourceid").textContent,el.querySelector(".events").style.display)}const urlToSources=urlToSourcesMapping(filterSourcesUsingFormOptions(data.sources));for(const url of urlToSources.keys()){const sourcesForUrl=urlToSources.get(url);createSourceRowsForTheSameUrl(sourcesForUrl,tableBody,currentDisplayStates)}populateThreadIds(data.sources)}))}function filterSourcesUsingFormOptions(sources){const newSources=sources.filter((source=>!clearedSources.has(as64Bit(source.id))||source.events.length>clearedSources.get(as64Bit(source.id))));const newSourcesWithEventsCleared=newSources.map((source=>{const eventNameFilterValue=document.body.querySelector("#events_select").value;if(eventNameFilterValue){const filterRe=new RegExp(eventNameFilterValue);source.events=source.events.filter((event=>filterRe.test(event.name)))}return source}));const filteredSources=newSourcesWithEventsCleared.filter((source=>{const noUrlCheckbox=document.body.querySelector("#hide_no_url");assert(noUrlCheckbox);const noMetricsCheckbox=document.body.querySelector("#hide_no_events");assert(noMetricsCheckbox);return(!noUrlCheckbox.checked||source.url)&&(!noMetricsCheckbox.checked||source.events.length)}));const threadIds=document.body.querySelector("#thread_ids");assert(threadIds);const threadsFilteredSource=filteredSources.filter((source=>{const selectedOption=threadIds.options[threadIds.selectedIndex];return!selectedOption||selectedOption.value==="All"||(source.id[0]>>>0).toString(16)===selectedOption.value}));const urlSelect=document.body.querySelector("#url_select");assert(urlSelect);return threadsFilteredSource.filter((source=>{const urlFilterValue=urlSelect.value;if(urlFilterValue){const urlRe=new RegExp(urlFilterValue);return!source.url||urlRe.test(source.url)}return true}))}function onLoad(){addExpandAllToggleButton();addClearButton();updateUkmData();getRequiredElement("refresh").addEventListener("click",updateUkmData);getRequiredElement("hide_no_events").addEventListener("click",updateUkmData);getRequiredElement("hide_no_url").addEventListener("click",updateUkmData);getRequiredElement("thread_ids").addEventListener("click",updateUkmData);getRequiredElement("include_cache").addEventListener("click",updateUkmData);getRequiredElement("events_select").addEventListener("keyup",(e=>{if(e.key==="Enter"){updateUkmData()}}));getRequiredElement("url_select").addEventListener("keyup",(e=>{if(e.key==="Enter"){updateUkmData()}}))}document.addEventListener("DOMContentLoaded",onLoad);setInterval(updateUkmData,2*60*1e3);