// components/translate/content/common/translate.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_DATA_VIEW_H_
#define COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/translate/content/common/translate.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace translate::mojom {
class LanguageDetectionDetailsDataView;



}  // translate::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::translate::mojom::LanguageDetectionDetailsDataView> {
  using Data = ::translate::mojom::internal::LanguageDetectionDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace translate::mojom {


enum class TranslateError : int32_t {
  
  NONE = 0,
  
  NETWORK = 1,
  
  INITIALIZATION_ERROR = 2,
  
  UNKNOWN_LANGUAGE = 3,
  
  UNSUPPORTED_LANGUAGE = 4,
  
  IDENTICAL_LANGUAGES = 5,
  
  TRANSLATION_ERROR = 6,
  
  TRANSLATION_TIMEOUT = 7,
  
  UNEXPECTED_SCRIPT_ERROR = 8,
  
  BAD_ORIGIN = 9,
  
  SCRIPT_LOAD_ERROR = 10,
  
  TRANSLATE_ERROR_MAX = 11,
  kMinValue = 0,
  kMaxValue = 11,
};

 std::ostream& operator<<(std::ostream& os, TranslateError value);
inline bool IsKnownEnumValue(TranslateError value) {
  return internal::TranslateError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class TranslateAgentInterfaceBase {};

using TranslateAgentPtrDataView =
    mojo::InterfacePtrDataView<TranslateAgentInterfaceBase>;
using TranslateAgentRequestDataView =
    mojo::InterfaceRequestDataView<TranslateAgentInterfaceBase>;
using TranslateAgentAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TranslateAgentInterfaceBase>;
using TranslateAgentAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TranslateAgentInterfaceBase>;
class ContentTranslateDriverInterfaceBase {};

using ContentTranslateDriverPtrDataView =
    mojo::InterfacePtrDataView<ContentTranslateDriverInterfaceBase>;
using ContentTranslateDriverRequestDataView =
    mojo::InterfaceRequestDataView<ContentTranslateDriverInterfaceBase>;
using ContentTranslateDriverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ContentTranslateDriverInterfaceBase>;
using ContentTranslateDriverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ContentTranslateDriverInterfaceBase>;


class LanguageDetectionDetailsDataView {
 public:
  LanguageDetectionDetailsDataView() = default;

  LanguageDetectionDetailsDataView(
      internal::LanguageDetectionDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetAdoptedLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdoptedLanguage(UserType* output) {
    
    auto* pointer = data_->adopted_language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool has_notranslate() const {
    return data_->has_notranslate;
  }
  bool has_run_lang_detection() const {
    return data_->has_run_lang_detection;
  }
  inline void GetTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTime(UserType* output) {
    
    auto* pointer = data_->time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetContentLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentLanguage(UserType* output) {
    
    auto* pointer = data_->content_language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetModelDetectedLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModelDetectedLanguage(UserType* output) {
    
    auto* pointer = data_->model_detected_language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_model_reliable() const {
    return data_->is_model_reliable;
  }
  inline void GetHtmlRootLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHtmlRootLanguage(UserType* output) {
    
    auto* pointer = data_->html_root_language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetContentsDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContents(UserType* output) {
    
    auto* pointer = data_->contents.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  float model_reliability_score() const {
    return data_->model_reliability_score;
  }
  inline void GetDetectionModelVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetectionModelVersion(UserType* output) {
    
    auto* pointer = data_->detection_model_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::LanguageDetectionDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // translate::mojom

#endif  // COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_DATA_VIEW_H_