// components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom-params-data.h"
namespace system_media_controls {
namespace mojom {

NOINLINE static const char* PlaybackStatusToStringHelper(PlaybackStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PlaybackStatus::kPlaying:
      return "kPlaying";
    case PlaybackStatus::kPaused:
      return "kPaused";
    case PlaybackStatus::kStopped:
      return "kStopped";
    default:
      return nullptr;
  }
}

std::string PlaybackStatusToString(PlaybackStatus value) {
  const char *str = PlaybackStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PlaybackStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PlaybackStatus value) {
  return os << PlaybackStatusToString(value);
}

namespace internal {


// static
bool SystemMediaControls_SetIsNextEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControls_SetIsNextEnabled_Params_Data* object =
      static_cast<const SystemMediaControls_SetIsNextEnabled_Params_Data*>(data);

  return true;
}

SystemMediaControls_SetIsNextEnabled_Params_Data::SystemMediaControls_SetIsNextEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControls_SetIsPreviousEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControls_SetIsPreviousEnabled_Params_Data* object =
      static_cast<const SystemMediaControls_SetIsPreviousEnabled_Params_Data*>(data);

  return true;
}

SystemMediaControls_SetIsPreviousEnabled_Params_Data::SystemMediaControls_SetIsPreviousEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControls_SetIsPlayPauseEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControls_SetIsPlayPauseEnabled_Params_Data* object =
      static_cast<const SystemMediaControls_SetIsPlayPauseEnabled_Params_Data*>(data);

  return true;
}

SystemMediaControls_SetIsPlayPauseEnabled_Params_Data::SystemMediaControls_SetIsPlayPauseEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControls_SetIsStopEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControls_SetIsStopEnabled_Params_Data* object =
      static_cast<const SystemMediaControls_SetIsStopEnabled_Params_Data*>(data);

  return true;
}

SystemMediaControls_SetIsStopEnabled_Params_Data::SystemMediaControls_SetIsStopEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControls_SetIsSeekToEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControls_SetIsSeekToEnabled_Params_Data* object =
      static_cast<const SystemMediaControls_SetIsSeekToEnabled_Params_Data*>(data);

  return true;
}

SystemMediaControls_SetIsSeekToEnabled_Params_Data::SystemMediaControls_SetIsSeekToEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControls_SetPlaybackStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControls_SetPlaybackStatus_Params_Data* object =
      static_cast<const SystemMediaControls_SetPlaybackStatus_Params_Data*>(data);


  if (!::system_media_controls::mojom::internal::PlaybackStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

SystemMediaControls_SetPlaybackStatus_Params_Data::SystemMediaControls_SetPlaybackStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControls_SetTitle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControls_SetTitle_Params_Data* object =
      static_cast<const SystemMediaControls_SetTitle_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  return true;
}

SystemMediaControls_SetTitle_Params_Data::SystemMediaControls_SetTitle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControls_SetArtist_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControls_SetArtist_Params_Data* object =
      static_cast<const SystemMediaControls_SetArtist_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->artist, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->artist, validation_context))
    return false;

  return true;
}

SystemMediaControls_SetArtist_Params_Data::SystemMediaControls_SetArtist_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControls_SetAlbum_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControls_SetAlbum_Params_Data* object =
      static_cast<const SystemMediaControls_SetAlbum_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->album, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->album, validation_context))
    return false;

  return true;
}

SystemMediaControls_SetAlbum_Params_Data::SystemMediaControls_SetAlbum_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControls_SetThumbnail_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControls_SetThumbnail_Params_Data* object =
      static_cast<const SystemMediaControls_SetThumbnail_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->thumbnail, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->thumbnail, validation_context))
    return false;

  return true;
}

SystemMediaControls_SetThumbnail_Params_Data::SystemMediaControls_SetThumbnail_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControls_SetPosition_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControls_SetPosition_Params_Data* object =
      static_cast<const SystemMediaControls_SetPosition_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->position, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

SystemMediaControls_SetPosition_Params_Data::SystemMediaControls_SetPosition_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControls_ClearMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControls_ClearMetadata_Params_Data* object =
      static_cast<const SystemMediaControls_ClearMetadata_Params_Data*>(data);

  return true;
}

SystemMediaControls_ClearMetadata_Params_Data::SystemMediaControls_ClearMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControlsObserver_OnNext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControlsObserver_OnNext_Params_Data* object =
      static_cast<const SystemMediaControlsObserver_OnNext_Params_Data*>(data);

  return true;
}

SystemMediaControlsObserver_OnNext_Params_Data::SystemMediaControlsObserver_OnNext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControlsObserver_OnPrevious_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControlsObserver_OnPrevious_Params_Data* object =
      static_cast<const SystemMediaControlsObserver_OnPrevious_Params_Data*>(data);

  return true;
}

SystemMediaControlsObserver_OnPrevious_Params_Data::SystemMediaControlsObserver_OnPrevious_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControlsObserver_OnPause_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControlsObserver_OnPause_Params_Data* object =
      static_cast<const SystemMediaControlsObserver_OnPause_Params_Data*>(data);

  return true;
}

SystemMediaControlsObserver_OnPause_Params_Data::SystemMediaControlsObserver_OnPause_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControlsObserver_OnPlayPause_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControlsObserver_OnPlayPause_Params_Data* object =
      static_cast<const SystemMediaControlsObserver_OnPlayPause_Params_Data*>(data);

  return true;
}

SystemMediaControlsObserver_OnPlayPause_Params_Data::SystemMediaControlsObserver_OnPlayPause_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControlsObserver_OnStop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControlsObserver_OnStop_Params_Data* object =
      static_cast<const SystemMediaControlsObserver_OnStop_Params_Data*>(data);

  return true;
}

SystemMediaControlsObserver_OnStop_Params_Data::SystemMediaControlsObserver_OnStop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControlsObserver_OnPlay_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControlsObserver_OnPlay_Params_Data* object =
      static_cast<const SystemMediaControlsObserver_OnPlay_Params_Data*>(data);

  return true;
}

SystemMediaControlsObserver_OnPlay_Params_Data::SystemMediaControlsObserver_OnPlay_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControlsObserver_OnSeekTo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControlsObserver_OnSeekTo_Params_Data* object =
      static_cast<const SystemMediaControlsObserver_OnSeekTo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seek_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seek_time, validation_context))
    return false;

  return true;
}

SystemMediaControlsObserver_OnSeekTo_Params_Data::SystemMediaControlsObserver_OnSeekTo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControlsObserver_OnBridgeCreatedForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControlsObserver_OnBridgeCreatedForTesting_Params_Data* object =
      static_cast<const SystemMediaControlsObserver_OnBridgeCreatedForTesting_Params_Data*>(data);

  return true;
}

SystemMediaControlsObserver_OnBridgeCreatedForTesting_Params_Data::SystemMediaControlsObserver_OnBridgeCreatedForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemMediaControlsObserver_OnMetadataClearedForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemMediaControlsObserver_OnMetadataClearedForTesting_Params_Data* object =
      static_cast<const SystemMediaControlsObserver_OnMetadataClearedForTesting_Params_Data*>(data);

  return true;
}

SystemMediaControlsObserver_OnMetadataClearedForTesting_Params_Data::SystemMediaControlsObserver_OnMetadataClearedForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace system_media_controls

namespace perfetto {

// static
void TraceFormatTraits<::system_media_controls::mojom::PlaybackStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::system_media_controls::mojom::PlaybackStatus value) {
  return std::move(context).WriteString(::system_media_controls::mojom::PlaybackStatusToString(value));
}

} // namespace perfetto