// components/subresource_filter/core/mojom/subresource_filter.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/subresource_filter/core/mojom/subresource_filter.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/subresource_filter/core/mojom/subresource_filter.mojom-params-data.h"
#include "components/subresource_filter/core/mojom/subresource_filter.mojom-shared-message-ids.h"

#include "components/subresource_filter/core/mojom/subresource_filter.mojom-import-headers.h"
#include "components/subresource_filter/core/mojom/subresource_filter.mojom-test-utils.h"


namespace subresource_filter::mojom {
ActivationState::ActivationState()
    : activation_level(ActivationLevel::kDisabled),
      filtering_disabled_for_document(false),
      generic_blocking_rules_disabled(false),
      measure_performance(false),
      enable_logging(false) {}

ActivationState::ActivationState(
    ActivationLevel activation_level_in,
    bool filtering_disabled_for_document_in,
    bool generic_blocking_rules_disabled_in,
    bool measure_performance_in,
    bool enable_logging_in)
    : activation_level(std::move(activation_level_in)),
      filtering_disabled_for_document(std::move(filtering_disabled_for_document_in)),
      generic_blocking_rules_disabled(std::move(generic_blocking_rules_disabled_in)),
      measure_performance(std::move(measure_performance_in)),
      enable_logging(std::move(enable_logging_in)) {}

ActivationState::~ActivationState() = default;
size_t ActivationState::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->activation_level);
  seed = mojo::internal::Hash(seed, this->filtering_disabled_for_document);
  seed = mojo::internal::Hash(seed, this->generic_blocking_rules_disabled);
  seed = mojo::internal::Hash(seed, this->measure_performance);
  seed = mojo::internal::Hash(seed, this->enable_logging);
  return seed;
}

void ActivationState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activation_level"), this->activation_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ActivationLevel>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filtering_disabled_for_document"), this->filtering_disabled_for_document,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "generic_blocking_rules_disabled"), this->generic_blocking_rules_disabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "measure_performance"), this->measure_performance,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_logging"), this->enable_logging,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ActivationState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DocumentLoadStatistics::DocumentLoadStatistics()
    : num_loads_total(0),
      num_loads_evaluated(0),
      num_loads_matching_rules(0),
      num_loads_disallowed(0),
      evaluation_total_wall_duration(),
      evaluation_total_cpu_duration() {}

DocumentLoadStatistics::DocumentLoadStatistics(
    int32_t num_loads_total_in,
    int32_t num_loads_evaluated_in,
    int32_t num_loads_matching_rules_in,
    int32_t num_loads_disallowed_in,
    ::base::TimeDelta evaluation_total_wall_duration_in,
    ::base::TimeDelta evaluation_total_cpu_duration_in)
    : num_loads_total(std::move(num_loads_total_in)),
      num_loads_evaluated(std::move(num_loads_evaluated_in)),
      num_loads_matching_rules(std::move(num_loads_matching_rules_in)),
      num_loads_disallowed(std::move(num_loads_disallowed_in)),
      evaluation_total_wall_duration(std::move(evaluation_total_wall_duration_in)),
      evaluation_total_cpu_duration(std::move(evaluation_total_cpu_duration_in)) {}

DocumentLoadStatistics::~DocumentLoadStatistics() = default;

void DocumentLoadStatistics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_loads_total"), this->num_loads_total,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_loads_evaluated"), this->num_loads_evaluated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_loads_matching_rules"), this->num_loads_matching_rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_loads_disallowed"), this->num_loads_disallowed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "evaluation_total_wall_duration"), this->evaluation_total_wall_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "evaluation_total_cpu_duration"), this->evaluation_total_cpu_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DocumentLoadStatistics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SubresourceFilterRulesetObserver::IPCStableHashFunction SubresourceFilterRulesetObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SubresourceFilterRulesetObserver>(message.name())) {
    case messages::SubresourceFilterRulesetObserver::kSetRulesetForProcess: {
      return &SubresourceFilterRulesetObserver::SetRulesetForProcess_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SubresourceFilterRulesetObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SubresourceFilterRulesetObserver>(message.name())) {
      case messages::SubresourceFilterRulesetObserver::kSetRulesetForProcess:
            return "Receive subresource_filter::mojom::SubresourceFilterRulesetObserver::SetRulesetForProcess";
    }
  } else {
    switch (static_cast<messages::SubresourceFilterRulesetObserver>(message.name())) {
      case messages::SubresourceFilterRulesetObserver::kSetRulesetForProcess:
            return "Receive reply subresource_filter::mojom::SubresourceFilterRulesetObserver::SetRulesetForProcess";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SubresourceFilterRulesetObserver::SetRulesetForProcess_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3c20b36;  // IPCStableHash for subresource_filter::mojom::SubresourceFilterRulesetObserver::SetRulesetForProcess
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SubresourceFilterRulesetObserverProxy::SubresourceFilterRulesetObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SubresourceFilterRulesetObserverProxy::SetRulesetForProcess(
    ::base::File in_ruleset_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send subresource_filter::mojom::SubresourceFilterRulesetObserver::SetRulesetForProcess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ruleset_file"), in_ruleset_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubresourceFilterRulesetObserver::kSetRulesetForProcess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::subresource_filter::mojom::internal::SubresourceFilterRulesetObserver_SetRulesetForProcess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ruleset_file)::BaseType> ruleset_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_ruleset_file,
    ruleset_file_fragment);

  params->ruleset_file.Set(
      ruleset_file_fragment.is_null() ? nullptr : ruleset_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ruleset_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ruleset_file in SubresourceFilterRulesetObserver.SetRulesetForProcess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubresourceFilterRulesetObserver::Name_);
  message.set_method_name("SetRulesetForProcess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SubresourceFilterRulesetObserverStubDispatch::Accept(
    SubresourceFilterRulesetObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SubresourceFilterRulesetObserver>(message->header()->name)) {
    case messages::SubresourceFilterRulesetObserver::kSetRulesetForProcess: {
      DCHECK(message->is_serialized());
      internal::SubresourceFilterRulesetObserver_SetRulesetForProcess_Params_Data* params =
          reinterpret_cast<internal::SubresourceFilterRulesetObserver_SetRulesetForProcess_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SubresourceFilterRulesetObserver.0
      bool success = true;
      ::base::File p_ruleset_file{};
      SubresourceFilterRulesetObserver_SetRulesetForProcess_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRulesetFile(&p_ruleset_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SubresourceFilterRulesetObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRulesetForProcess(        
        std::move(p_ruleset_file));
      return true;
    }
  }
  return false;
}

// static
bool SubresourceFilterRulesetObserverStubDispatch::AcceptWithResponder(
    SubresourceFilterRulesetObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SubresourceFilterRulesetObserver>(message->header()->name)) {
    case messages::SubresourceFilterRulesetObserver::kSetRulesetForProcess: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSubresourceFilterRulesetObserverValidationInfo[] = {
    { &internal::SubresourceFilterRulesetObserver_SetRulesetForProcess_Params_Data::Validate,
     nullptr /* no response */},
};

bool SubresourceFilterRulesetObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::subresource_filter::mojom::SubresourceFilterRulesetObserver::Name_,
    kSubresourceFilterRulesetObserverValidationInfo);
}



}  // subresource_filter::mojom


namespace mojo {


// static
bool StructTraits<::subresource_filter::mojom::ActivationState::DataView, ::subresource_filter::mojom::ActivationStatePtr>::Read(
    ::subresource_filter::mojom::ActivationState::DataView input,
    ::subresource_filter::mojom::ActivationStatePtr* output) {
  bool success = true;
  ::subresource_filter::mojom::ActivationStatePtr result(::subresource_filter::mojom::ActivationState::New());
  
      if (success && !input.ReadActivationLevel(&result->activation_level))
        success = false;
      if (success)
        result->filtering_disabled_for_document = input.filtering_disabled_for_document();
      if (success)
        result->generic_blocking_rules_disabled = input.generic_blocking_rules_disabled();
      if (success)
        result->measure_performance = input.measure_performance();
      if (success)
        result->enable_logging = input.enable_logging();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::subresource_filter::mojom::DocumentLoadStatistics::DataView, ::subresource_filter::mojom::DocumentLoadStatisticsPtr>::Read(
    ::subresource_filter::mojom::DocumentLoadStatistics::DataView input,
    ::subresource_filter::mojom::DocumentLoadStatisticsPtr* output) {
  bool success = true;
  ::subresource_filter::mojom::DocumentLoadStatisticsPtr result(::subresource_filter::mojom::DocumentLoadStatistics::New());
  
      if (success)
        result->num_loads_total = input.num_loads_total();
      if (success)
        result->num_loads_evaluated = input.num_loads_evaluated();
      if (success)
        result->num_loads_matching_rules = input.num_loads_matching_rules();
      if (success)
        result->num_loads_disallowed = input.num_loads_disallowed();
      if (success && !input.ReadEvaluationTotalWallDuration(&result->evaluation_total_wall_duration))
        success = false;
      if (success && !input.ReadEvaluationTotalCpuDuration(&result->evaluation_total_cpu_duration))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace subresource_filter::mojom {


void SubresourceFilterRulesetObserverInterceptorForTesting::SetRulesetForProcess(::base::File ruleset_file) {
  GetForwardingInterface()->SetRulesetForProcess(
    std::move(ruleset_file)
    );
}
SubresourceFilterRulesetObserverAsyncWaiter::SubresourceFilterRulesetObserverAsyncWaiter(
    SubresourceFilterRulesetObserver* proxy) : proxy_(proxy) {}

SubresourceFilterRulesetObserverAsyncWaiter::~SubresourceFilterRulesetObserverAsyncWaiter() = default;







}  // subresource_filter::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif