// components/spellcheck/common/spellcheck_panel.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/spellcheck/common/spellcheck_panel.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/spellcheck/common/spellcheck_panel.mojom-params-data.h"
#include "components/spellcheck/common/spellcheck_panel.mojom-shared-message-ids.h"

#include "components/spellcheck/common/spellcheck_panel.mojom-import-headers.h"
#include "components/spellcheck/common/spellcheck_panel.mojom-test-utils.h"


namespace spellcheck::mojom {
// The declaration includes the definition on other builds.

SpellCheckPanel::IPCStableHashFunction SpellCheckPanel::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpellCheckPanel>(message.name())) {
    case messages::SpellCheckPanel::kToggleSpellPanel: {
      return &SpellCheckPanel::ToggleSpellPanel_Sym::IPCStableHash;
    }
    case messages::SpellCheckPanel::kAdvanceToNextMisspelling: {
      return &SpellCheckPanel::AdvanceToNextMisspelling_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpellCheckPanel::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpellCheckPanel>(message.name())) {
      case messages::SpellCheckPanel::kToggleSpellPanel:
            return "Receive spellcheck::mojom::SpellCheckPanel::ToggleSpellPanel";
      case messages::SpellCheckPanel::kAdvanceToNextMisspelling:
            return "Receive spellcheck::mojom::SpellCheckPanel::AdvanceToNextMisspelling";
    }
  } else {
    switch (static_cast<messages::SpellCheckPanel>(message.name())) {
      case messages::SpellCheckPanel::kToggleSpellPanel:
            return "Receive reply spellcheck::mojom::SpellCheckPanel::ToggleSpellPanel";
      case messages::SpellCheckPanel::kAdvanceToNextMisspelling:
            return "Receive reply spellcheck::mojom::SpellCheckPanel::AdvanceToNextMisspelling";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpellCheckPanel::ToggleSpellPanel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f5c573a;  // IPCStableHash for spellcheck::mojom::SpellCheckPanel::ToggleSpellPanel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpellCheckPanel::AdvanceToNextMisspelling_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10b3aecb;  // IPCStableHash for spellcheck::mojom::SpellCheckPanel::AdvanceToNextMisspelling
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpellCheckPanelProxy::SpellCheckPanelProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpellCheckPanelProxy::ToggleSpellPanel(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send spellcheck::mojom::SpellCheckPanel::ToggleSpellPanel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpellCheckPanel::kToggleSpellPanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::spellcheck::mojom::internal::SpellCheckPanel_ToggleSpellPanel_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellCheckPanel::Name_);
  message.set_method_name("ToggleSpellPanel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpellCheckPanelProxy::AdvanceToNextMisspelling(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send spellcheck::mojom::SpellCheckPanel::AdvanceToNextMisspelling");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpellCheckPanel::kAdvanceToNextMisspelling), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::spellcheck::mojom::internal::SpellCheckPanel_AdvanceToNextMisspelling_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellCheckPanel::Name_);
  message.set_method_name("AdvanceToNextMisspelling");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpellCheckPanelStubDispatch::Accept(
    SpellCheckPanel* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpellCheckPanel>(message->header()->name)) {
    case messages::SpellCheckPanel::kToggleSpellPanel: {
      DCHECK(message->is_serialized());
      internal::SpellCheckPanel_ToggleSpellPanel_Params_Data* params =
          reinterpret_cast<internal::SpellCheckPanel_ToggleSpellPanel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpellCheckPanel.0
      bool success = true;
      bool p_visible{};
      SpellCheckPanel_ToggleSpellPanel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellCheckPanel::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ToggleSpellPanel(        
        std::move(p_visible));
      return true;
    }
    case messages::SpellCheckPanel::kAdvanceToNextMisspelling: {
      DCHECK(message->is_serialized());
      internal::SpellCheckPanel_AdvanceToNextMisspelling_Params_Data* params =
          reinterpret_cast<internal::SpellCheckPanel_AdvanceToNextMisspelling_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpellCheckPanel.1
      bool success = true;
      SpellCheckPanel_AdvanceToNextMisspelling_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellCheckPanel::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdvanceToNextMisspelling(        );
      return true;
    }
  }
  return false;
}

// static
bool SpellCheckPanelStubDispatch::AcceptWithResponder(
    SpellCheckPanel* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpellCheckPanel>(message->header()->name)) {
    case messages::SpellCheckPanel::kToggleSpellPanel: {
      break;
    }
    case messages::SpellCheckPanel::kAdvanceToNextMisspelling: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpellCheckPanelValidationInfo[] = {
    { &internal::SpellCheckPanel_ToggleSpellPanel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpellCheckPanel_AdvanceToNextMisspelling_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpellCheckPanelRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::spellcheck::mojom::SpellCheckPanel::Name_,
    kSpellCheckPanelValidationInfo);
}

// The declaration includes the definition on other builds.

SpellCheckPanelHost::IPCStableHashFunction SpellCheckPanelHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpellCheckPanelHost>(message.name())) {
    case messages::SpellCheckPanelHost::kShowSpellingPanel: {
      return &SpellCheckPanelHost::ShowSpellingPanel_Sym::IPCStableHash;
    }
    case messages::SpellCheckPanelHost::kUpdateSpellingPanelWithMisspelledWord: {
      return &SpellCheckPanelHost::UpdateSpellingPanelWithMisspelledWord_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpellCheckPanelHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpellCheckPanelHost>(message.name())) {
      case messages::SpellCheckPanelHost::kShowSpellingPanel:
            return "Receive spellcheck::mojom::SpellCheckPanelHost::ShowSpellingPanel";
      case messages::SpellCheckPanelHost::kUpdateSpellingPanelWithMisspelledWord:
            return "Receive spellcheck::mojom::SpellCheckPanelHost::UpdateSpellingPanelWithMisspelledWord";
    }
  } else {
    switch (static_cast<messages::SpellCheckPanelHost>(message.name())) {
      case messages::SpellCheckPanelHost::kShowSpellingPanel:
            return "Receive reply spellcheck::mojom::SpellCheckPanelHost::ShowSpellingPanel";
      case messages::SpellCheckPanelHost::kUpdateSpellingPanelWithMisspelledWord:
            return "Receive reply spellcheck::mojom::SpellCheckPanelHost::UpdateSpellingPanelWithMisspelledWord";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpellCheckPanelHost::ShowSpellingPanel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f8e5012;  // IPCStableHash for spellcheck::mojom::SpellCheckPanelHost::ShowSpellingPanel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpellCheckPanelHost::UpdateSpellingPanelWithMisspelledWord_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x30696148;  // IPCStableHash for spellcheck::mojom::SpellCheckPanelHost::UpdateSpellingPanelWithMisspelledWord
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpellCheckPanelHostProxy::SpellCheckPanelHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpellCheckPanelHostProxy::ShowSpellingPanel(
    bool in_show) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send spellcheck::mojom::SpellCheckPanelHost::ShowSpellingPanel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("show"), in_show,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpellCheckPanelHost::kShowSpellingPanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::spellcheck::mojom::internal::SpellCheckPanelHost_ShowSpellingPanel_Params_Data> params(
          message);
  params.Allocate();

  params->show = in_show;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellCheckPanelHost::Name_);
  message.set_method_name("ShowSpellingPanel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpellCheckPanelHostProxy::UpdateSpellingPanelWithMisspelledWord(
    const ::std::u16string& in_word) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send spellcheck::mojom::SpellCheckPanelHost::UpdateSpellingPanelWithMisspelledWord", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("word"), in_word,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpellCheckPanelHost::kUpdateSpellingPanelWithMisspelledWord), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::spellcheck::mojom::internal::SpellCheckPanelHost_UpdateSpellingPanelWithMisspelledWord_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->word)::BaseType> word_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_word,
    word_fragment);

  params->word.Set(
      word_fragment.is_null() ? nullptr : word_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->word.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null word in SpellCheckPanelHost.UpdateSpellingPanelWithMisspelledWord request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellCheckPanelHost::Name_);
  message.set_method_name("UpdateSpellingPanelWithMisspelledWord");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpellCheckPanelHostStubDispatch::Accept(
    SpellCheckPanelHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpellCheckPanelHost>(message->header()->name)) {
    case messages::SpellCheckPanelHost::kShowSpellingPanel: {
      DCHECK(message->is_serialized());
      internal::SpellCheckPanelHost_ShowSpellingPanel_Params_Data* params =
          reinterpret_cast<internal::SpellCheckPanelHost_ShowSpellingPanel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpellCheckPanelHost.0
      bool success = true;
      bool p_show{};
      SpellCheckPanelHost_ShowSpellingPanel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_show = input_data_view.show();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellCheckPanelHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowSpellingPanel(        
        std::move(p_show));
      return true;
    }
    case messages::SpellCheckPanelHost::kUpdateSpellingPanelWithMisspelledWord: {
      DCHECK(message->is_serialized());
      internal::SpellCheckPanelHost_UpdateSpellingPanelWithMisspelledWord_Params_Data* params =
          reinterpret_cast<internal::SpellCheckPanelHost_UpdateSpellingPanelWithMisspelledWord_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpellCheckPanelHost.1
      bool success = true;
      ::std::u16string p_word{};
      SpellCheckPanelHost_UpdateSpellingPanelWithMisspelledWord_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWord(&p_word))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellCheckPanelHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSpellingPanelWithMisspelledWord(        
        std::move(p_word));
      return true;
    }
  }
  return false;
}

// static
bool SpellCheckPanelHostStubDispatch::AcceptWithResponder(
    SpellCheckPanelHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpellCheckPanelHost>(message->header()->name)) {
    case messages::SpellCheckPanelHost::kShowSpellingPanel: {
      break;
    }
    case messages::SpellCheckPanelHost::kUpdateSpellingPanelWithMisspelledWord: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpellCheckPanelHostValidationInfo[] = {
    { &internal::SpellCheckPanelHost_ShowSpellingPanel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpellCheckPanelHost_UpdateSpellingPanelWithMisspelledWord_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpellCheckPanelHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::spellcheck::mojom::SpellCheckPanelHost::Name_,
    kSpellCheckPanelHostValidationInfo);
}



}  // spellcheck::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace spellcheck::mojom {


void SpellCheckPanelInterceptorForTesting::ToggleSpellPanel(bool visible) {
  GetForwardingInterface()->ToggleSpellPanel(
    std::move(visible)
    );
}
void SpellCheckPanelInterceptorForTesting::AdvanceToNextMisspelling() {
  GetForwardingInterface()->AdvanceToNextMisspelling();
}
SpellCheckPanelAsyncWaiter::SpellCheckPanelAsyncWaiter(
    SpellCheckPanel* proxy) : proxy_(proxy) {}

SpellCheckPanelAsyncWaiter::~SpellCheckPanelAsyncWaiter() = default;





void SpellCheckPanelHostInterceptorForTesting::ShowSpellingPanel(bool show) {
  GetForwardingInterface()->ShowSpellingPanel(
    std::move(show)
    );
}
void SpellCheckPanelHostInterceptorForTesting::UpdateSpellingPanelWithMisspelledWord(const ::std::u16string& word) {
  GetForwardingInterface()->UpdateSpellingPanelWithMisspelledWord(
    std::move(word)
    );
}
SpellCheckPanelHostAsyncWaiter::SpellCheckPanelHostAsyncWaiter(
    SpellCheckPanelHost* proxy) : proxy_(proxy) {}

SpellCheckPanelHostAsyncWaiter::~SpellCheckPanelHostAsyncWaiter() = default;







}  // spellcheck::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif