// components/site_engagement/core/mojom/site_engagement_details.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SITE_ENGAGEMENT_CORE_MOJOM_SITE_ENGAGEMENT_DETAILS_MOJOM_H_
#define COMPONENTS_SITE_ENGAGEMENT_CORE_MOJOM_SITE_ENGAGEMENT_DETAILS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/site_engagement/core/mojom/site_engagement_details.mojom-features.h"  // IWYU pragma: export
#include "components/site_engagement/core/mojom/site_engagement_details.mojom-shared.h"  // IWYU pragma: export
#include "components/site_engagement/core/mojom/site_engagement_details.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace site_engagement::mojom {

class SiteEngagementDetailsProviderProxy;

template <typename ImplRefTraits>
class SiteEngagementDetailsProviderStub;

class SiteEngagementDetailsProviderRequestValidator;
class SiteEngagementDetailsProviderResponseValidator;


class SiteEngagementDetailsProvider
    : public SiteEngagementDetailsProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "site_engagement.mojom.SiteEngagementDetailsProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SiteEngagementDetailsProviderInterfaceBase;
  using Proxy_ = SiteEngagementDetailsProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = SiteEngagementDetailsProviderStub<ImplRefTraits>;

  using RequestValidator_ = SiteEngagementDetailsProviderRequestValidator;
  using ResponseValidator_ = SiteEngagementDetailsProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetSiteEngagementDetailsMinVersion = 0,
    kSetSiteEngagementBaseScoreForUrlMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetSiteEngagementDetails_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSiteEngagementBaseScoreForUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SiteEngagementDetailsProvider() = default;

  using GetSiteEngagementDetailsCallback = base::OnceCallback<void(std::vector<SiteEngagementDetailsPtr>)>;
  using GetSiteEngagementDetailsMojoCallback = base::OnceCallback<void(std::vector<SiteEngagementDetailsPtr>)>;

  virtual void GetSiteEngagementDetails(GetSiteEngagementDetailsCallback callback) = 0;

  virtual void SetSiteEngagementBaseScoreForUrl(const ::GURL& url, double score) = 0;
};



class  SiteEngagementDetailsProviderProxy
    : public SiteEngagementDetailsProvider {
 public:
  using InterfaceType = SiteEngagementDetailsProvider;

  explicit SiteEngagementDetailsProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetSiteEngagementDetails(GetSiteEngagementDetailsCallback callback) final;
  
  void SetSiteEngagementBaseScoreForUrl(const ::GURL& url, double score) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SiteEngagementDetailsProviderStubDispatch {
 public:
  static bool Accept(SiteEngagementDetailsProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SiteEngagementDetailsProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SiteEngagementDetailsProvider>>
class SiteEngagementDetailsProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SiteEngagementDetailsProviderStub() = default;
  ~SiteEngagementDetailsProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SiteEngagementDetailsProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SiteEngagementDetailsProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SiteEngagementDetailsProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SiteEngagementDetailsProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  SiteEngagementDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SiteEngagementDetails, T>::value>;
  using DataView = SiteEngagementDetailsDataView;
  using Data_ = internal::SiteEngagementDetails_Data;

  template <typename... Args>
  static SiteEngagementDetailsPtr New(Args&&... args) {
    return SiteEngagementDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SiteEngagementDetailsPtr From(const U& u) {
    return mojo::TypeConverter<SiteEngagementDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SiteEngagementDetails>::Convert(*this);
  }


  SiteEngagementDetails();

  SiteEngagementDetails(
      const ::GURL& origin,
      double total_score,
      double base_score,
      double installed_bonus);


  ~SiteEngagementDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SiteEngagementDetailsPtr>
  SiteEngagementDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SiteEngagementDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SiteEngagementDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SiteEngagementDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteEngagementDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteEngagementDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SiteEngagementDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SiteEngagementDetails_UnserializedMessageContext<
            UserType, SiteEngagementDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SiteEngagementDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SiteEngagementDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SiteEngagementDetails_UnserializedMessageContext<
            UserType, SiteEngagementDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SiteEngagementDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL origin;
  
  double total_score;
  
  double base_score;
  
  double installed_bonus;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SiteEngagementDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SiteEngagementDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SiteEngagementDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SiteEngagementDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SiteEngagementDetailsPtr SiteEngagementDetails::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(total_score),
      mojo::Clone(base_score),
      mojo::Clone(installed_bonus)
  );
}

template <typename T, SiteEngagementDetails::EnableIfSame<T>*>
bool SiteEngagementDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->total_score, other_struct.total_score))
    return false;
  if (!mojo::Equals(this->base_score, other_struct.base_score))
    return false;
  if (!mojo::Equals(this->installed_bonus, other_struct.installed_bonus))
    return false;
  return true;
}

template <typename T, SiteEngagementDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.total_score < rhs.total_score)
    return true;
  if (rhs.total_score < lhs.total_score)
    return false;
  if (lhs.base_score < rhs.base_score)
    return true;
  if (rhs.base_score < lhs.base_score)
    return false;
  if (lhs.installed_bonus < rhs.installed_bonus)
    return true;
  if (rhs.installed_bonus < lhs.installed_bonus)
    return false;
  return false;
}


}  // site_engagement::mojom

namespace mojo {


template <>
struct  StructTraits<::site_engagement::mojom::SiteEngagementDetails::DataView,
                                         ::site_engagement::mojom::SiteEngagementDetailsPtr> {
  static bool IsNull(const ::site_engagement::mojom::SiteEngagementDetailsPtr& input) { return !input; }
  static void SetToNull(::site_engagement::mojom::SiteEngagementDetailsPtr* output) { output->reset(); }

  static const decltype(::site_engagement::mojom::SiteEngagementDetails::origin)& origin(
      const ::site_engagement::mojom::SiteEngagementDetailsPtr& input) {
    return input->origin;
  }

  static decltype(::site_engagement::mojom::SiteEngagementDetails::total_score) total_score(
      const ::site_engagement::mojom::SiteEngagementDetailsPtr& input) {
    return input->total_score;
  }

  static decltype(::site_engagement::mojom::SiteEngagementDetails::base_score) base_score(
      const ::site_engagement::mojom::SiteEngagementDetailsPtr& input) {
    return input->base_score;
  }

  static decltype(::site_engagement::mojom::SiteEngagementDetails::installed_bonus) installed_bonus(
      const ::site_engagement::mojom::SiteEngagementDetailsPtr& input) {
    return input->installed_bonus;
  }

  static bool Read(::site_engagement::mojom::SiteEngagementDetails::DataView input, ::site_engagement::mojom::SiteEngagementDetailsPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SITE_ENGAGEMENT_CORE_MOJOM_SITE_ENGAGEMENT_DETAILS_MOJOM_H_