// components/services/unzip/public/mojom/unzipper.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_H_
#define COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/unzip/public/mojom/unzipper.mojom-features.h"  // IWYU pragma: export
#include "components/services/unzip/public/mojom/unzipper.mojom-shared.h"  // IWYU pragma: export
#include "components/services/unzip/public/mojom/unzipper.mojom-forward.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/filesystem/directory.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace unzip::mojom {

class UnzipFilterProxy;

template <typename ImplRefTraits>
class UnzipFilterStub;

class UnzipFilterRequestValidator;
class UnzipFilterResponseValidator;


class UnzipFilter
    : public UnzipFilterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "unzip.mojom.UnzipFilter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UnzipFilterInterfaceBase;
  using Proxy_ = UnzipFilterProxy;

  template <typename ImplRefTraits>
  using Stub_ = UnzipFilterStub<ImplRefTraits>;

  using RequestValidator_ = UnzipFilterRequestValidator;
  using ResponseValidator_ = UnzipFilterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kShouldUnzipFileMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ShouldUnzipFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UnzipFilter() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ShouldUnzipFile(const ::base::FilePath& path, bool* out_result);
  using ShouldUnzipFileCallback = base::OnceCallback<void(bool)>;
  using ShouldUnzipFileMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ShouldUnzipFile(const ::base::FilePath& path, ShouldUnzipFileCallback callback) = 0;
};

class UnzipListenerProxy;

template <typename ImplRefTraits>
class UnzipListenerStub;

class UnzipListenerRequestValidator;


class UnzipListener
    : public UnzipListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "unzip.mojom.UnzipListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UnzipListenerInterfaceBase;
  using Proxy_ = UnzipListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = UnzipListenerStub<ImplRefTraits>;

  using RequestValidator_ = UnzipListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnProgressMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnProgress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UnzipListener() = default;

  virtual void OnProgress(uint64_t bytes) = 0;
};

class UnzipperProxy;

template <typename ImplRefTraits>
class UnzipperStub;

class UnzipperRequestValidator;
class UnzipperResponseValidator;


class Unzipper
    : public UnzipperInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "unzip.mojom.Unzipper";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kService;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UnzipperInterfaceBase;
  using Proxy_ = UnzipperProxy;

  template <typename ImplRefTraits>
  using Stub_ = UnzipperStub<ImplRefTraits>;

  using RequestValidator_ = UnzipperRequestValidator;
  using ResponseValidator_ = UnzipperResponseValidator;
  enum MethodMinVersions : uint32_t {
    kUnzipMinVersion = 0,
    kDetectEncodingMinVersion = 0,
    kGetExtractedInfoMinVersion = 0,
    kDecodeXzMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Unzip_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DetectEncoding_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetExtractedInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DecodeXz_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Unzipper() = default;

  using UnzipCallback = base::OnceCallback<void(bool)>;
  using UnzipMojoCallback = base::OnceCallback<void(bool)>;

  virtual void Unzip(::base::File zip_file, ::mojo::PendingRemote<::storage::mojom::Directory> output_dir, UnzipOptionsPtr options, ::mojo::PendingRemote<UnzipFilter> filter, ::mojo::PendingRemote<UnzipListener> listener, UnzipCallback callback) = 0;

  using DetectEncodingCallback = base::OnceCallback<void(int32_t)>;
  using DetectEncodingMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void DetectEncoding(::base::File zip_file, DetectEncodingCallback callback) = 0;

  using GetExtractedInfoCallback = base::OnceCallback<void(InfoPtr)>;
  using GetExtractedInfoMojoCallback = base::OnceCallback<void(InfoPtr)>;

  virtual void GetExtractedInfo(::base::File zip_file, GetExtractedInfoCallback callback) = 0;

  using DecodeXzCallback = base::OnceCallback<void(bool)>;
  using DecodeXzMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DecodeXz(::base::File in_file, ::base::File out_file, DecodeXzCallback callback) = 0;
};



class  UnzipFilterProxy
    : public UnzipFilter {
 public:
  using InterfaceType = UnzipFilter;

  explicit UnzipFilterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool ShouldUnzipFile(const ::base::FilePath& path, bool* out_result) final;
  
  void ShouldUnzipFile(const ::base::FilePath& path, ShouldUnzipFileCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  UnzipListenerProxy
    : public UnzipListener {
 public:
  using InterfaceType = UnzipListener;

  explicit UnzipListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnProgress(uint64_t bytes) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  UnzipperProxy
    : public Unzipper {
 public:
  using InterfaceType = Unzipper;

  explicit UnzipperProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Unzip(::base::File zip_file, ::mojo::PendingRemote<::storage::mojom::Directory> output_dir, UnzipOptionsPtr options, ::mojo::PendingRemote<UnzipFilter> filter, ::mojo::PendingRemote<UnzipListener> listener, UnzipCallback callback) final;
  
  void DetectEncoding(::base::File zip_file, DetectEncodingCallback callback) final;
  
  void GetExtractedInfo(::base::File zip_file, GetExtractedInfoCallback callback) final;
  
  void DecodeXz(::base::File in_file, ::base::File out_file, DecodeXzCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  UnzipFilterStubDispatch {
 public:
  static bool Accept(UnzipFilter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UnzipFilter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UnzipFilter>>
class UnzipFilterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UnzipFilterStub() = default;
  ~UnzipFilterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UnzipFilterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UnzipFilterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UnzipListenerStubDispatch {
 public:
  static bool Accept(UnzipListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UnzipListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UnzipListener>>
class UnzipListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UnzipListenerStub() = default;
  ~UnzipListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UnzipListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UnzipListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UnzipperStubDispatch {
 public:
  static bool Accept(Unzipper* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Unzipper* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Unzipper>>
class UnzipperStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UnzipperStub() = default;
  ~UnzipperStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UnzipperStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UnzipperStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UnzipFilterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UnzipListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UnzipperRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UnzipFilterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UnzipperResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  UnzipOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UnzipOptions, T>::value>;
  using DataView = UnzipOptionsDataView;
  using Data_ = internal::UnzipOptions_Data;

  template <typename... Args>
  static UnzipOptionsPtr New(Args&&... args) {
    return UnzipOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UnzipOptionsPtr From(const U& u) {
    return mojo::TypeConverter<UnzipOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UnzipOptions>::Convert(*this);
  }


  UnzipOptions();

  UnzipOptions(
      const std::string& encoding,
      const std::string& password);


  ~UnzipOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UnzipOptionsPtr>
  UnzipOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UnzipOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UnzipOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UnzipOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UnzipOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UnzipOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UnzipOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UnzipOptions_UnserializedMessageContext<
            UserType, UnzipOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UnzipOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UnzipOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UnzipOptions_UnserializedMessageContext<
            UserType, UnzipOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UnzipOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string encoding;
  
  std::string password;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UnzipOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UnzipOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UnzipOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UnzipOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Info {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Info, T>::value>;
  using DataView = InfoDataView;
  using Data_ = internal::Info_Data;

  template <typename... Args>
  static InfoPtr New(Args&&... args) {
    return InfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InfoPtr From(const U& u) {
    return mojo::TypeConverter<InfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Info>::Convert(*this);
  }


  Info();

  Info(
      bool size_is_valid,
      uint64_t size,
      bool is_encrypted,
      bool uses_aes_encryption);


  ~Info();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InfoPtr>
  InfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Info::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Info::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Info::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Info::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Info::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Info::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Info_UnserializedMessageContext<
            UserType, Info::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Info::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Info::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Info_UnserializedMessageContext<
            UserType, Info::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Info::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool size_is_valid;
  
  uint64_t size;
  
  bool is_encrypted;
  
  bool uses_aes_encryption;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Info::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Info::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Info::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Info::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





template <typename StructPtrType>
UnzipOptionsPtr UnzipOptions::Clone() const {
  return New(
      mojo::Clone(encoding),
      mojo::Clone(password)
  );
}

template <typename T, UnzipOptions::EnableIfSame<T>*>
bool UnzipOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->encoding, other_struct.encoding))
    return false;
  if (!mojo::Equals(this->password, other_struct.password))
    return false;
  return true;
}

template <typename T, UnzipOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.encoding < rhs.encoding)
    return true;
  if (rhs.encoding < lhs.encoding)
    return false;
  if (lhs.password < rhs.password)
    return true;
  if (rhs.password < lhs.password)
    return false;
  return false;
}
template <typename StructPtrType>
InfoPtr Info::Clone() const {
  return New(
      mojo::Clone(size_is_valid),
      mojo::Clone(size),
      mojo::Clone(is_encrypted),
      mojo::Clone(uses_aes_encryption)
  );
}

template <typename T, Info::EnableIfSame<T>*>
bool Info::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->size_is_valid, other_struct.size_is_valid))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->is_encrypted, other_struct.is_encrypted))
    return false;
  if (!mojo::Equals(this->uses_aes_encryption, other_struct.uses_aes_encryption))
    return false;
  return true;
}

template <typename T, Info::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.size_is_valid < rhs.size_is_valid)
    return true;
  if (rhs.size_is_valid < lhs.size_is_valid)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.is_encrypted < rhs.is_encrypted)
    return true;
  if (rhs.is_encrypted < lhs.is_encrypted)
    return false;
  if (lhs.uses_aes_encryption < rhs.uses_aes_encryption)
    return true;
  if (rhs.uses_aes_encryption < lhs.uses_aes_encryption)
    return false;
  return false;
}


}  // unzip::mojom

namespace mojo {


template <>
struct  StructTraits<::unzip::mojom::UnzipOptions::DataView,
                                         ::unzip::mojom::UnzipOptionsPtr> {
  static bool IsNull(const ::unzip::mojom::UnzipOptionsPtr& input) { return !input; }
  static void SetToNull(::unzip::mojom::UnzipOptionsPtr* output) { output->reset(); }

  static const decltype(::unzip::mojom::UnzipOptions::encoding)& encoding(
      const ::unzip::mojom::UnzipOptionsPtr& input) {
    return input->encoding;
  }

  static const decltype(::unzip::mojom::UnzipOptions::password)& password(
      const ::unzip::mojom::UnzipOptionsPtr& input) {
    return input->password;
  }

  static bool Read(::unzip::mojom::UnzipOptions::DataView input, ::unzip::mojom::UnzipOptionsPtr* output);
};


template <>
struct  StructTraits<::unzip::mojom::Info::DataView,
                                         ::unzip::mojom::InfoPtr> {
  static bool IsNull(const ::unzip::mojom::InfoPtr& input) { return !input; }
  static void SetToNull(::unzip::mojom::InfoPtr* output) { output->reset(); }

  static decltype(::unzip::mojom::Info::size_is_valid) size_is_valid(
      const ::unzip::mojom::InfoPtr& input) {
    return input->size_is_valid;
  }

  static decltype(::unzip::mojom::Info::size) size(
      const ::unzip::mojom::InfoPtr& input) {
    return input->size;
  }

  static decltype(::unzip::mojom::Info::is_encrypted) is_encrypted(
      const ::unzip::mojom::InfoPtr& input) {
    return input->is_encrypted;
  }

  static decltype(::unzip::mojom::Info::uses_aes_encryption) uses_aes_encryption(
      const ::unzip::mojom::InfoPtr& input) {
    return input->uses_aes_encryption;
  }

  static bool Read(::unzip::mojom::Info::DataView input, ::unzip::mojom::InfoPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_H_