// components/services/unzip/public/mojom/unzipper.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/unzip/public/mojom/unzipper.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/unzip/public/mojom/unzipper.mojom-params-data.h"
#include "components/services/unzip/public/mojom/unzipper.mojom-shared-message-ids.h"

#include "components/services/unzip/public/mojom/unzipper.mojom-import-headers.h"
#include "components/services/unzip/public/mojom/unzipper.mojom-test-utils.h"


namespace unzip::mojom {
UnzipOptions::UnzipOptions()
    : encoding(),
      password() {}

UnzipOptions::UnzipOptions(
    const std::string& encoding_in,
    const std::string& password_in)
    : encoding(std::move(encoding_in)),
      password(std::move(password_in)) {}

UnzipOptions::~UnzipOptions() = default;
size_t UnzipOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->encoding);
  seed = mojo::internal::Hash(seed, this->password);
  return seed;
}

void UnzipOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoding"), this->encoding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "password"), this->password,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UnzipOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Info::Info()
    : size_is_valid(),
      size(),
      is_encrypted(),
      uses_aes_encryption() {}

Info::Info(
    bool size_is_valid_in,
    uint64_t size_in,
    bool is_encrypted_in,
    bool uses_aes_encryption_in)
    : size_is_valid(std::move(size_is_valid_in)),
      size(std::move(size_in)),
      is_encrypted(std::move(is_encrypted_in)),
      uses_aes_encryption(std::move(uses_aes_encryption_in)) {}

Info::~Info() = default;
size_t Info::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->size_is_valid);
  seed = mojo::internal::Hash(seed, this->size);
  seed = mojo::internal::Hash(seed, this->is_encrypted);
  seed = mojo::internal::Hash(seed, this->uses_aes_encryption);
  return seed;
}

void Info::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_is_valid"), this->size_is_valid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_encrypted"), this->is_encrypted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uses_aes_encryption"), this->uses_aes_encryption,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Info::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

UnzipFilter::IPCStableHashFunction UnzipFilter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UnzipFilter>(message.name())) {
    case messages::UnzipFilter::kShouldUnzipFile: {
      return &UnzipFilter::ShouldUnzipFile_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UnzipFilter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UnzipFilter>(message.name())) {
      case messages::UnzipFilter::kShouldUnzipFile:
            return "Receive unzip::mojom::UnzipFilter::ShouldUnzipFile";
    }
  } else {
    switch (static_cast<messages::UnzipFilter>(message.name())) {
      case messages::UnzipFilter::kShouldUnzipFile:
            return "Receive reply unzip::mojom::UnzipFilter::ShouldUnzipFile";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UnzipFilter::ShouldUnzipFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf585b565;  // IPCStableHash for unzip::mojom::UnzipFilter::ShouldUnzipFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool UnzipFilter::ShouldUnzipFile(const ::base::FilePath& path, bool* out_result) {
  NOTREACHED();
}
class UnzipFilter_ShouldUnzipFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  UnzipFilter_ShouldUnzipFile_HandleSyncResponse(
      bool* result, bool* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  UnzipFilter_ShouldUnzipFile_HandleSyncResponse(const UnzipFilter_ShouldUnzipFile_HandleSyncResponse&) = delete;
  UnzipFilter_ShouldUnzipFile_HandleSyncResponse& operator=(const UnzipFilter_ShouldUnzipFile_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_result_;};

class UnzipFilter_ShouldUnzipFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UnzipFilter_ShouldUnzipFile_ForwardToCallback(
      UnzipFilter::ShouldUnzipFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  UnzipFilter_ShouldUnzipFile_ForwardToCallback(const UnzipFilter_ShouldUnzipFile_ForwardToCallback&) = delete;
  UnzipFilter_ShouldUnzipFile_ForwardToCallback& operator=(const UnzipFilter_ShouldUnzipFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UnzipFilter::ShouldUnzipFileCallback callback_;
};

UnzipFilterProxy::UnzipFilterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool UnzipFilterProxy::ShouldUnzipFile(
    const ::base::FilePath& param_path, bool* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call unzip::mojom::UnzipFilter::ShouldUnzipFile (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#else
  TRACE_EVENT0("mojom", "UnzipFilter::ShouldUnzipFile");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnzipFilter::kShouldUnzipFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::UnzipFilter_ShouldUnzipFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in UnzipFilter.ShouldUnzipFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnzipFilter::Name_);
  message.set_method_name("ShouldUnzipFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UnzipFilter_ShouldUnzipFile_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "UnzipFilter::ShouldUnzipFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type bool>");
   });
#endif
  return result;
}

void UnzipFilterProxy::ShouldUnzipFile(
    const ::base::FilePath& in_path, ShouldUnzipFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send unzip::mojom::UnzipFilter::ShouldUnzipFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnzipFilter::kShouldUnzipFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::UnzipFilter_ShouldUnzipFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in UnzipFilter.ShouldUnzipFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnzipFilter::Name_);
  message.set_method_name("ShouldUnzipFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UnzipFilter_ShouldUnzipFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class UnzipFilter_ShouldUnzipFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UnzipFilter::ShouldUnzipFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UnzipFilter_ShouldUnzipFile_ProxyToResponder> proxy(
        new UnzipFilter_ShouldUnzipFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UnzipFilter_ShouldUnzipFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UnzipFilter_ShouldUnzipFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UnzipFilter_ShouldUnzipFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UnzipFilter::ShouldUnzipFileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool UnzipFilter_ShouldUnzipFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UnzipFilter.0
  bool success = true;
  bool p_result{};
  UnzipFilter_ShouldUnzipFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UnzipFilter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void UnzipFilter_ShouldUnzipFile_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply unzip::mojom::UnzipFilter::ShouldUnzipFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnzipFilter::kShouldUnzipFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnzipFilter::Name_);
  message.set_method_name("ShouldUnzipFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool UnzipFilter_ShouldUnzipFile_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data* params =
      reinterpret_cast<internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for UnzipFilter.0
  bool success = true;
  bool p_result{};
  UnzipFilter_ShouldUnzipFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UnzipFilter::Name_, 0, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}

// static
bool UnzipFilterStubDispatch::Accept(
    UnzipFilter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UnzipFilter>(message->header()->name)) {
    case messages::UnzipFilter::kShouldUnzipFile: {
      break;
    }
  }
  return false;
}

// static
bool UnzipFilterStubDispatch::AcceptWithResponder(
    UnzipFilter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UnzipFilter>(message->header()->name)) {
    case messages::UnzipFilter::kShouldUnzipFile: {
      internal::UnzipFilter_ShouldUnzipFile_Params_Data* params =
          reinterpret_cast<
              internal::UnzipFilter_ShouldUnzipFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UnzipFilter.0
      bool success = true;
      ::base::FilePath p_path{};
      UnzipFilter_ShouldUnzipFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UnzipFilter::Name_, 0, false);
        return false;
      }
      auto callback =
          UnzipFilter_ShouldUnzipFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShouldUnzipFile(        
        std::move(p_path), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kUnzipFilterValidationInfo[] = {
    { &internal::UnzipFilter_ShouldUnzipFile_Params_Data::Validate,
     &internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data::Validate},
};

bool UnzipFilterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::unzip::mojom::UnzipFilter::Name_,
    kUnzipFilterValidationInfo);
}

bool UnzipFilterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::unzip::mojom::UnzipFilter::Name_,
    kUnzipFilterValidationInfo);
}
// The declaration includes the definition on other builds.

UnzipListener::IPCStableHashFunction UnzipListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UnzipListener>(message.name())) {
    case messages::UnzipListener::kOnProgress: {
      return &UnzipListener::OnProgress_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UnzipListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UnzipListener>(message.name())) {
      case messages::UnzipListener::kOnProgress:
            return "Receive unzip::mojom::UnzipListener::OnProgress";
    }
  } else {
    switch (static_cast<messages::UnzipListener>(message.name())) {
      case messages::UnzipListener::kOnProgress:
            return "Receive reply unzip::mojom::UnzipListener::OnProgress";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UnzipListener::OnProgress_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4e5f1e99;  // IPCStableHash for unzip::mojom::UnzipListener::OnProgress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

UnzipListenerProxy::UnzipListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UnzipListenerProxy::OnProgress(
    uint64_t in_bytes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send unzip::mojom::UnzipListener::OnProgress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes"), in_bytes,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnzipListener::kOnProgress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::UnzipListener_OnProgress_Params_Data> params(
          message);
  params.Allocate();

  params->bytes = in_bytes;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnzipListener::Name_);
  message.set_method_name("OnProgress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool UnzipListenerStubDispatch::Accept(
    UnzipListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UnzipListener>(message->header()->name)) {
    case messages::UnzipListener::kOnProgress: {
      DCHECK(message->is_serialized());
      internal::UnzipListener_OnProgress_Params_Data* params =
          reinterpret_cast<internal::UnzipListener_OnProgress_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UnzipListener.0
      bool success = true;
      uint64_t p_bytes{};
      UnzipListener_OnProgress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_bytes = input_data_view.bytes();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UnzipListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProgress(        
        std::move(p_bytes));
      return true;
    }
  }
  return false;
}

// static
bool UnzipListenerStubDispatch::AcceptWithResponder(
    UnzipListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UnzipListener>(message->header()->name)) {
    case messages::UnzipListener::kOnProgress: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kUnzipListenerValidationInfo[] = {
    { &internal::UnzipListener_OnProgress_Params_Data::Validate,
     nullptr /* no response */},
};

bool UnzipListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::unzip::mojom::UnzipListener::Name_,
    kUnzipListenerValidationInfo);
}

// The declaration includes the definition on other builds.

Unzipper::IPCStableHashFunction Unzipper::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Unzipper>(message.name())) {
    case messages::Unzipper::kUnzip: {
      return &Unzipper::Unzip_Sym::IPCStableHash;
    }
    case messages::Unzipper::kDetectEncoding: {
      return &Unzipper::DetectEncoding_Sym::IPCStableHash;
    }
    case messages::Unzipper::kGetExtractedInfo: {
      return &Unzipper::GetExtractedInfo_Sym::IPCStableHash;
    }
    case messages::Unzipper::kDecodeXz: {
      return &Unzipper::DecodeXz_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Unzipper::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Unzipper>(message.name())) {
      case messages::Unzipper::kUnzip:
            return "Receive unzip::mojom::Unzipper::Unzip";
      case messages::Unzipper::kDetectEncoding:
            return "Receive unzip::mojom::Unzipper::DetectEncoding";
      case messages::Unzipper::kGetExtractedInfo:
            return "Receive unzip::mojom::Unzipper::GetExtractedInfo";
      case messages::Unzipper::kDecodeXz:
            return "Receive unzip::mojom::Unzipper::DecodeXz";
    }
  } else {
    switch (static_cast<messages::Unzipper>(message.name())) {
      case messages::Unzipper::kUnzip:
            return "Receive reply unzip::mojom::Unzipper::Unzip";
      case messages::Unzipper::kDetectEncoding:
            return "Receive reply unzip::mojom::Unzipper::DetectEncoding";
      case messages::Unzipper::kGetExtractedInfo:
            return "Receive reply unzip::mojom::Unzipper::GetExtractedInfo";
      case messages::Unzipper::kDecodeXz:
            return "Receive reply unzip::mojom::Unzipper::DecodeXz";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Unzipper::Unzip_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x33b4706a;  // IPCStableHash for unzip::mojom::Unzipper::Unzip
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Unzipper::DetectEncoding_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4ebf089c;  // IPCStableHash for unzip::mojom::Unzipper::DetectEncoding
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Unzipper::GetExtractedInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2b617c42;  // IPCStableHash for unzip::mojom::Unzipper::GetExtractedInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Unzipper::DecodeXz_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde58556f;  // IPCStableHash for unzip::mojom::Unzipper::DecodeXz
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Unzipper_Unzip_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Unzipper_Unzip_ForwardToCallback(
      Unzipper::UnzipCallback callback
      ) : callback_(std::move(callback)) {
  }

  Unzipper_Unzip_ForwardToCallback(const Unzipper_Unzip_ForwardToCallback&) = delete;
  Unzipper_Unzip_ForwardToCallback& operator=(const Unzipper_Unzip_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Unzipper::UnzipCallback callback_;
};

class Unzipper_DetectEncoding_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Unzipper_DetectEncoding_ForwardToCallback(
      Unzipper::DetectEncodingCallback callback
      ) : callback_(std::move(callback)) {
  }

  Unzipper_DetectEncoding_ForwardToCallback(const Unzipper_DetectEncoding_ForwardToCallback&) = delete;
  Unzipper_DetectEncoding_ForwardToCallback& operator=(const Unzipper_DetectEncoding_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Unzipper::DetectEncodingCallback callback_;
};

class Unzipper_GetExtractedInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Unzipper_GetExtractedInfo_ForwardToCallback(
      Unzipper::GetExtractedInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  Unzipper_GetExtractedInfo_ForwardToCallback(const Unzipper_GetExtractedInfo_ForwardToCallback&) = delete;
  Unzipper_GetExtractedInfo_ForwardToCallback& operator=(const Unzipper_GetExtractedInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Unzipper::GetExtractedInfoCallback callback_;
};

class Unzipper_DecodeXz_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Unzipper_DecodeXz_ForwardToCallback(
      Unzipper::DecodeXzCallback callback
      ) : callback_(std::move(callback)) {
  }

  Unzipper_DecodeXz_ForwardToCallback(const Unzipper_DecodeXz_ForwardToCallback&) = delete;
  Unzipper_DecodeXz_ForwardToCallback& operator=(const Unzipper_DecodeXz_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Unzipper::DecodeXzCallback callback_;
};

UnzipperProxy::UnzipperProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UnzipperProxy::Unzip(
    ::base::File in_zip_file, ::mojo::PendingRemote<::storage::mojom::Directory> in_output_dir, UnzipOptionsPtr in_options, ::mojo::PendingRemote<UnzipFilter> in_filter, ::mojo::PendingRemote<UnzipListener> in_listener, UnzipCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send unzip::mojom::Unzipper::Unzip", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("zip_file"), in_zip_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_dir"), in_output_dir,
                        "<value of type ::mojo::PendingRemote<::storage::mojom::Directory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type UnzipOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::mojo::PendingRemote<UnzipFilter>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<UnzipListener>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Unzipper::kUnzip), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::Unzipper_Unzip_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->zip_file)::BaseType> zip_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_zip_file,
    zip_file_fragment);

  params->zip_file.Set(
      zip_file_fragment.is_null() ? nullptr : zip_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->zip_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null zip_file in Unzipper.Unzip request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::DirectoryInterfaceBase>>(
    in_output_dir,
    &params->output_dir,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->output_dir)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid output_dir in Unzipper.Unzip request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::unzip::mojom::UnzipOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in Unzipper.Unzip request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::unzip::mojom::UnzipFilterInterfaceBase>>(
    in_filter,
    &params->filter,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::unzip::mojom::UnzipListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Unzipper::Name_);
  message.set_method_name("Unzip");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Unzipper_Unzip_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UnzipperProxy::DetectEncoding(
    ::base::File in_zip_file, DetectEncodingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send unzip::mojom::Unzipper::DetectEncoding", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("zip_file"), in_zip_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Unzipper::kDetectEncoding), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::Unzipper_DetectEncoding_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->zip_file)::BaseType> zip_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_zip_file,
    zip_file_fragment);

  params->zip_file.Set(
      zip_file_fragment.is_null() ? nullptr : zip_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->zip_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null zip_file in Unzipper.DetectEncoding request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Unzipper::Name_);
  message.set_method_name("DetectEncoding");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Unzipper_DetectEncoding_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UnzipperProxy::GetExtractedInfo(
    ::base::File in_zip_file, GetExtractedInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send unzip::mojom::Unzipper::GetExtractedInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("zip_file"), in_zip_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Unzipper::kGetExtractedInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::Unzipper_GetExtractedInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->zip_file)::BaseType> zip_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_zip_file,
    zip_file_fragment);

  params->zip_file.Set(
      zip_file_fragment.is_null() ? nullptr : zip_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->zip_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null zip_file in Unzipper.GetExtractedInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Unzipper::Name_);
  message.set_method_name("GetExtractedInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Unzipper_GetExtractedInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UnzipperProxy::DecodeXz(
    ::base::File in_in_file, ::base::File in_out_file, DecodeXzCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send unzip::mojom::Unzipper::DecodeXz", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("in_file"), in_in_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("out_file"), in_out_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Unzipper::kDecodeXz), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::Unzipper_DecodeXz_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->in_file)::BaseType> in_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_in_file,
    in_file_fragment);

  params->in_file.Set(
      in_file_fragment.is_null() ? nullptr : in_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->in_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null in_file in Unzipper.DecodeXz request");
  mojo::internal::MessageFragment<
      typename decltype(params->out_file)::BaseType> out_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_out_file,
    out_file_fragment);

  params->out_file.Set(
      out_file_fragment.is_null() ? nullptr : out_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->out_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null out_file in Unzipper.DecodeXz request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Unzipper::Name_);
  message.set_method_name("DecodeXz");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Unzipper_DecodeXz_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Unzipper_Unzip_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Unzipper::UnzipCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Unzipper_Unzip_ProxyToResponder> proxy(
        new Unzipper_Unzip_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Unzipper_Unzip_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Unzipper_Unzip_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Unzipper_Unzip_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Unzipper::UnzipCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool Unzipper_Unzip_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Unzipper_Unzip_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Unzipper_Unzip_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Unzipper.0
  bool success = true;
  bool p_result{};
  Unzipper_Unzip_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Unzipper::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Unzipper_Unzip_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply unzip::mojom::Unzipper::Unzip", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Unzipper::kUnzip), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::Unzipper_Unzip_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Unzipper::Name_);
  message.set_method_name("Unzip");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Unzipper_DetectEncoding_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Unzipper::DetectEncodingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Unzipper_DetectEncoding_ProxyToResponder> proxy(
        new Unzipper_DetectEncoding_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Unzipper_DetectEncoding_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Unzipper_DetectEncoding_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Unzipper_DetectEncoding_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Unzipper::DetectEncodingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_encoding);
};

bool Unzipper_DetectEncoding_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Unzipper_DetectEncoding_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Unzipper_DetectEncoding_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Unzipper.1
  bool success = true;
  int32_t p_encoding{};
  Unzipper_DetectEncoding_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_encoding = input_data_view.encoding();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Unzipper::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_encoding));
  }
  return true;
}

void Unzipper_DetectEncoding_ProxyToResponder::Run(
    int32_t in_encoding) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply unzip::mojom::Unzipper::DetectEncoding", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encoding"), in_encoding,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Unzipper::kDetectEncoding), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::Unzipper_DetectEncoding_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->encoding = in_encoding;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Unzipper::Name_);
  message.set_method_name("DetectEncoding");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Unzipper_GetExtractedInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Unzipper::GetExtractedInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Unzipper_GetExtractedInfo_ProxyToResponder> proxy(
        new Unzipper_GetExtractedInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Unzipper_GetExtractedInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Unzipper_GetExtractedInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Unzipper_GetExtractedInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Unzipper::GetExtractedInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      InfoPtr in_info);
};

bool Unzipper_GetExtractedInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Unzipper_GetExtractedInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Unzipper_GetExtractedInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Unzipper.2
  bool success = true;
  InfoPtr p_info{};
  Unzipper_GetExtractedInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Unzipper::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void Unzipper_GetExtractedInfo_ProxyToResponder::Run(
    InfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply unzip::mojom::Unzipper::GetExtractedInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type InfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Unzipper::kGetExtractedInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::Unzipper_GetExtractedInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::unzip::mojom::InfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Unzipper::Name_);
  message.set_method_name("GetExtractedInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Unzipper_DecodeXz_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Unzipper::DecodeXzCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Unzipper_DecodeXz_ProxyToResponder> proxy(
        new Unzipper_DecodeXz_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Unzipper_DecodeXz_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Unzipper_DecodeXz_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Unzipper_DecodeXz_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Unzipper::DecodeXzCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool Unzipper_DecodeXz_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Unzipper_DecodeXz_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Unzipper_DecodeXz_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Unzipper.3
  bool success = true;
  bool p_result{};
  Unzipper_DecodeXz_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Unzipper::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Unzipper_DecodeXz_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply unzip::mojom::Unzipper::DecodeXz", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Unzipper::kDecodeXz), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::Unzipper_DecodeXz_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Unzipper::Name_);
  message.set_method_name("DecodeXz");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool UnzipperStubDispatch::Accept(
    Unzipper* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Unzipper>(message->header()->name)) {
    case messages::Unzipper::kUnzip: {
      break;
    }
    case messages::Unzipper::kDetectEncoding: {
      break;
    }
    case messages::Unzipper::kGetExtractedInfo: {
      break;
    }
    case messages::Unzipper::kDecodeXz: {
      break;
    }
  }
  return false;
}

// static
bool UnzipperStubDispatch::AcceptWithResponder(
    Unzipper* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Unzipper>(message->header()->name)) {
    case messages::Unzipper::kUnzip: {
      internal::Unzipper_Unzip_Params_Data* params =
          reinterpret_cast<
              internal::Unzipper_Unzip_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Unzipper.0
      bool success = true;
      ::base::File p_zip_file{};
      ::mojo::PendingRemote<::storage::mojom::Directory> p_output_dir{};
      UnzipOptionsPtr p_options{};
      ::mojo::PendingRemote<UnzipFilter> p_filter{};
      ::mojo::PendingRemote<UnzipListener> p_listener{};
      Unzipper_Unzip_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadZipFile(&p_zip_file))
        success = false;
      if (success) {
        p_output_dir =
            input_data_view.TakeOutputDir<decltype(p_output_dir)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success) {
        p_filter =
            input_data_view.TakeFilter<decltype(p_filter)>();
      }
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Unzipper::Name_, 0, false);
        return false;
      }
      auto callback =
          Unzipper_Unzip_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unzip(        
        std::move(p_zip_file), 
        std::move(p_output_dir), 
        std::move(p_options), 
        std::move(p_filter), 
        std::move(p_listener), std::move(callback));
      return true;
    }
    case messages::Unzipper::kDetectEncoding: {
      internal::Unzipper_DetectEncoding_Params_Data* params =
          reinterpret_cast<
              internal::Unzipper_DetectEncoding_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Unzipper.1
      bool success = true;
      ::base::File p_zip_file{};
      Unzipper_DetectEncoding_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadZipFile(&p_zip_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Unzipper::Name_, 1, false);
        return false;
      }
      auto callback =
          Unzipper_DetectEncoding_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DetectEncoding(        
        std::move(p_zip_file), std::move(callback));
      return true;
    }
    case messages::Unzipper::kGetExtractedInfo: {
      internal::Unzipper_GetExtractedInfo_Params_Data* params =
          reinterpret_cast<
              internal::Unzipper_GetExtractedInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Unzipper.2
      bool success = true;
      ::base::File p_zip_file{};
      Unzipper_GetExtractedInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadZipFile(&p_zip_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Unzipper::Name_, 2, false);
        return false;
      }
      auto callback =
          Unzipper_GetExtractedInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetExtractedInfo(        
        std::move(p_zip_file), std::move(callback));
      return true;
    }
    case messages::Unzipper::kDecodeXz: {
      internal::Unzipper_DecodeXz_Params_Data* params =
          reinterpret_cast<
              internal::Unzipper_DecodeXz_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Unzipper.3
      bool success = true;
      ::base::File p_in_file{};
      ::base::File p_out_file{};
      Unzipper_DecodeXz_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInFile(&p_in_file))
        success = false;
      if (success && !input_data_view.ReadOutFile(&p_out_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Unzipper::Name_, 3, false);
        return false;
      }
      auto callback =
          Unzipper_DecodeXz_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DecodeXz(        
        std::move(p_in_file), 
        std::move(p_out_file), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kUnzipperValidationInfo[] = {
    { &internal::Unzipper_Unzip_Params_Data::Validate,
     &internal::Unzipper_Unzip_ResponseParams_Data::Validate},
    { &internal::Unzipper_DetectEncoding_Params_Data::Validate,
     &internal::Unzipper_DetectEncoding_ResponseParams_Data::Validate},
    { &internal::Unzipper_GetExtractedInfo_Params_Data::Validate,
     &internal::Unzipper_GetExtractedInfo_ResponseParams_Data::Validate},
    { &internal::Unzipper_DecodeXz_Params_Data::Validate,
     &internal::Unzipper_DecodeXz_ResponseParams_Data::Validate},
};

bool UnzipperRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::unzip::mojom::Unzipper::Name_,
    kUnzipperValidationInfo);
}

bool UnzipperResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::unzip::mojom::Unzipper::Name_,
    kUnzipperValidationInfo);
}


}  // unzip::mojom


namespace mojo {


// static
bool StructTraits<::unzip::mojom::UnzipOptions::DataView, ::unzip::mojom::UnzipOptionsPtr>::Read(
    ::unzip::mojom::UnzipOptions::DataView input,
    ::unzip::mojom::UnzipOptionsPtr* output) {
  bool success = true;
  ::unzip::mojom::UnzipOptionsPtr result(::unzip::mojom::UnzipOptions::New());
  
      if (success && !input.ReadEncoding(&result->encoding))
        success = false;
      if (success && !input.ReadPassword(&result->password))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::unzip::mojom::Info::DataView, ::unzip::mojom::InfoPtr>::Read(
    ::unzip::mojom::Info::DataView input,
    ::unzip::mojom::InfoPtr* output) {
  bool success = true;
  ::unzip::mojom::InfoPtr result(::unzip::mojom::Info::New());
  
      if (success)
        result->size_is_valid = input.size_is_valid();
      if (success)
        result->size = input.size();
      if (success)
        result->is_encrypted = input.is_encrypted();
      if (success)
        result->uses_aes_encryption = input.uses_aes_encryption();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace unzip::mojom {


void UnzipFilterInterceptorForTesting::ShouldUnzipFile(const ::base::FilePath& path, ShouldUnzipFileCallback callback) {
  GetForwardingInterface()->ShouldUnzipFile(
    std::move(path)
    , std::move(callback));
}
UnzipFilterAsyncWaiter::UnzipFilterAsyncWaiter(
    UnzipFilter* proxy) : proxy_(proxy) {}

UnzipFilterAsyncWaiter::~UnzipFilterAsyncWaiter() = default;


void UnzipFilterAsyncWaiter::ShouldUnzipFile(
    const ::base::FilePath& path, bool* out_result) {
  base::RunLoop loop;
  proxy_->ShouldUnzipFile(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool UnzipFilterAsyncWaiter::ShouldUnzipFile(
    const ::base::FilePath& path) {
  bool async_wait_result;
  ShouldUnzipFile(std::move(path),&async_wait_result);
  return async_wait_result;
}




void UnzipListenerInterceptorForTesting::OnProgress(uint64_t bytes) {
  GetForwardingInterface()->OnProgress(
    std::move(bytes)
    );
}
UnzipListenerAsyncWaiter::UnzipListenerAsyncWaiter(
    UnzipListener* proxy) : proxy_(proxy) {}

UnzipListenerAsyncWaiter::~UnzipListenerAsyncWaiter() = default;





void UnzipperInterceptorForTesting::Unzip(::base::File zip_file, ::mojo::PendingRemote<::storage::mojom::Directory> output_dir, UnzipOptionsPtr options, ::mojo::PendingRemote<UnzipFilter> filter, ::mojo::PendingRemote<UnzipListener> listener, UnzipCallback callback) {
  GetForwardingInterface()->Unzip(
    std::move(zip_file)
    , 
    std::move(output_dir)
    , 
    std::move(options)
    , 
    std::move(filter)
    , 
    std::move(listener)
    , std::move(callback));
}
void UnzipperInterceptorForTesting::DetectEncoding(::base::File zip_file, DetectEncodingCallback callback) {
  GetForwardingInterface()->DetectEncoding(
    std::move(zip_file)
    , std::move(callback));
}
void UnzipperInterceptorForTesting::GetExtractedInfo(::base::File zip_file, GetExtractedInfoCallback callback) {
  GetForwardingInterface()->GetExtractedInfo(
    std::move(zip_file)
    , std::move(callback));
}
void UnzipperInterceptorForTesting::DecodeXz(::base::File in_file, ::base::File out_file, DecodeXzCallback callback) {
  GetForwardingInterface()->DecodeXz(
    std::move(in_file)
    , 
    std::move(out_file)
    , std::move(callback));
}
UnzipperAsyncWaiter::UnzipperAsyncWaiter(
    Unzipper* proxy) : proxy_(proxy) {}

UnzipperAsyncWaiter::~UnzipperAsyncWaiter() = default;


void UnzipperAsyncWaiter::Unzip(
    ::base::File zip_file, ::mojo::PendingRemote<::storage::mojom::Directory> output_dir, UnzipOptionsPtr options, ::mojo::PendingRemote<UnzipFilter> filter, ::mojo::PendingRemote<UnzipListener> listener, bool* out_result) {
  base::RunLoop loop;
  proxy_->Unzip(
      std::move(zip_file),
      std::move(output_dir),
      std::move(options),
      std::move(filter),
      std::move(listener),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool UnzipperAsyncWaiter::Unzip(
    ::base::File zip_file, ::mojo::PendingRemote<::storage::mojom::Directory> output_dir, UnzipOptionsPtr options, ::mojo::PendingRemote<UnzipFilter> filter, ::mojo::PendingRemote<UnzipListener> listener) {
  bool async_wait_result;
  Unzip(std::move(zip_file),std::move(output_dir),std::move(options),std::move(filter),std::move(listener),&async_wait_result);
  return async_wait_result;
}

void UnzipperAsyncWaiter::DetectEncoding(
    ::base::File zip_file, int32_t* out_encoding) {
  base::RunLoop loop;
  proxy_->DetectEncoding(
      std::move(zip_file),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_encoding
,
             int32_t encoding) {*out_encoding = std::move(encoding);
            loop->Quit();
          },
          &loop,
          out_encoding));
  loop.Run();
}

int32_t UnzipperAsyncWaiter::DetectEncoding(
    ::base::File zip_file) {
  int32_t async_wait_result;
  DetectEncoding(std::move(zip_file),&async_wait_result);
  return async_wait_result;
}

void UnzipperAsyncWaiter::GetExtractedInfo(
    ::base::File zip_file, InfoPtr* out_info) {
  base::RunLoop loop;
  proxy_->GetExtractedInfo(
      std::move(zip_file),
      base::BindOnce(
          [](base::RunLoop* loop,
             InfoPtr* out_info
,
             InfoPtr info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

InfoPtr UnzipperAsyncWaiter::GetExtractedInfo(
    ::base::File zip_file) {
  InfoPtr async_wait_result;
  GetExtractedInfo(std::move(zip_file),&async_wait_result);
  return async_wait_result;
}

void UnzipperAsyncWaiter::DecodeXz(
    ::base::File in_file, ::base::File out_file, bool* out_result) {
  base::RunLoop loop;
  proxy_->DecodeXz(
      std::move(in_file),
      std::move(out_file),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool UnzipperAsyncWaiter::DecodeXz(
    ::base::File in_file, ::base::File out_file) {
  bool async_wait_result;
  DecodeXz(std::move(in_file),std::move(out_file),&async_wait_result);
  return async_wait_result;
}






}  // unzip::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif