// components/services/storage/public/mojom/service_worker_storage_control.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-shared-internal.h"
#include "components/services/storage/public/mojom/service_worker_database.mojom-shared.h"
#include "components/services/storage/public/mojom/storage_policy_update.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-data-view.h"




namespace std {

template <>
struct hash<::storage::mojom::ServiceWorkerStorageStorageKeyState>
    : public mojo::internal::EnumHashImpl<::storage::mojom::ServiceWorkerStorageStorageKeyState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ServiceWorkerStorageStorageKeyState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::ServiceWorkerStorageStorageKeyState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::storage::mojom::ServiceWorkerStorageStorageKeyState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ServiceWorkerLiveVersionInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::ServiceWorkerLiveVersionInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::ServiceWorkerLiveVersionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::purgeable_resources(input)) in_purgeable_resources = Traits::purgeable_resources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->purgeable_resources)::BaseType>
        purgeable_resources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& purgeable_resources_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
      in_purgeable_resources,
      purgeable_resources_fragment,
      &purgeable_resources_validate_params);

    fragment->purgeable_resources.Set(
        purgeable_resources_fragment.is_null() ? nullptr : purgeable_resources_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->purgeable_resources.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null purgeable_resources in ServiceWorkerLiveVersionInfo struct");

    decltype(Traits::reference(input)) in_reference = Traits::reference(input);

    
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::ServiceWorkerLiveVersionRefInterfaceBase>>(
      in_reference,
      &fragment->reference,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->reference)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid reference in ServiceWorkerLiveVersionInfo struct");
  }

  static bool Deserialize(::storage::mojom::internal::ServiceWorkerLiveVersionInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::ServiceWorkerLiveVersionInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ServiceWorkerFindRegistrationResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::ServiceWorkerFindRegistrationResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::ServiceWorkerFindRegistrationResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::version_reference(input)) in_version_reference = Traits::version_reference(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::ServiceWorkerLiveVersionRefInterfaceBase>>(
      in_version_reference,
      &fragment->version_reference,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->version_reference)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid version_reference in ServiceWorkerFindRegistrationResult struct");

    decltype(Traits::registration(input)) in_registration = Traits::registration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->registration)::BaseType> registration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::storage::mojom::ServiceWorkerRegistrationDataDataView>(
      in_registration,
      registration_fragment);

    fragment->registration.Set(
        registration_fragment.is_null() ? nullptr : registration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->registration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registration in ServiceWorkerFindRegistrationResult struct");

    decltype(Traits::resources(input)) in_resources = Traits::resources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->resources)::BaseType>
        resources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerResourceRecordDataView>>(
      in_resources,
      resources_fragment,
      &resources_validate_params);

    fragment->resources.Set(
        resources_fragment.is_null() ? nullptr : resources_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->resources.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in ServiceWorkerFindRegistrationResult struct");
  }

  static bool Deserialize(::storage::mojom::internal::ServiceWorkerFindRegistrationResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::ServiceWorkerFindRegistrationResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ServiceWorkerUserDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::ServiceWorkerUserDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::ServiceWorkerUserData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->registration_id = Traits::registration_id(input);

    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_key,
      key_fragment);

    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in ServiceWorkerUserData struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in ServiceWorkerUserData struct");
  }

  static bool Deserialize(::storage::mojom::internal::ServiceWorkerUserData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::ServiceWorkerUserDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage::mojom {

inline void ServiceWorkerLiveVersionInfoDataView::GetPurgeableResourcesDataView(
    mojo::ArrayDataView<int64_t>* output) {
  auto pointer = data_->purgeable_resources.Get();
  *output = mojo::ArrayDataView<int64_t>(pointer, message_);
}


inline void ServiceWorkerFindRegistrationResultDataView::GetRegistrationDataView(
    ::storage::mojom::ServiceWorkerRegistrationDataDataView* output) {
  auto pointer = data_->registration.Get();
  *output = ::storage::mojom::ServiceWorkerRegistrationDataDataView(pointer, message_);
}
inline void ServiceWorkerFindRegistrationResultDataView::GetResourcesDataView(
    mojo::ArrayDataView<::storage::mojom::ServiceWorkerResourceRecordDataView>* output) {
  auto pointer = data_->resources.Get();
  *output = mojo::ArrayDataView<::storage::mojom::ServiceWorkerResourceRecordDataView>(pointer, message_);
}


inline void ServiceWorkerUserDataDataView::GetKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ServiceWorkerUserDataDataView::GetValueDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}



}  // storage::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::storage::mojom::ServiceWorkerStorageStorageKeyState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::storage::mojom::ServiceWorkerStorageStorageKeyState value);
};

} // namespace perfetto

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_SHARED_H_