// components/services/storage/public/mojom/filesystem/directory.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_TEST_UTILS_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_TEST_UTILS_H_

#include "components/services/storage/public/mojom/filesystem/directory.mojom.h"
#include "base/component_export.h"


namespace storage::mojom {


class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) FileLockInterceptorForTesting : public FileLock {
  virtual FileLock* GetForwardingInterface() = 0;
  void Release(ReleaseCallback callback) override;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) FileLockAsyncWaiter {
 public:
  explicit FileLockAsyncWaiter(FileLock* proxy);

  FileLockAsyncWaiter(const FileLockAsyncWaiter&) = delete;
  FileLockAsyncWaiter& operator=(const FileLockAsyncWaiter&) = delete;

  ~FileLockAsyncWaiter();
  void Release(
      ::base::File::Error* out_error);
  ::base::File::Error Release();

 private:
  FileLock* const proxy_;
};


class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) DirectoryInterceptorForTesting : public Directory {
  virtual Directory* GetForwardingInterface() = 0;
  void Clone(::mojo::PendingReceiver<Directory> receiver) override;
  void PathExists(const ::base::FilePath& path, PathExistsCallback callback) override;
  void GetEntries(const ::base::FilePath& path, GetEntriesMode mode, GetEntriesCallback callback) override;
  void OpenFile(const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, OpenFileCallback callback) override;
  void CreateDirectory(const ::base::FilePath& path, CreateDirectoryCallback callback) override;
  void DeleteFile(const ::base::FilePath& path, DeleteFileCallback callback) override;
  void GetFileInfo(const ::base::FilePath& path, GetFileInfoCallback callback) override;
  void GetPathAccess(const ::base::FilePath& path, GetPathAccessCallback callback) override;
  void RenameFile(const ::base::FilePath& old_path, const ::base::FilePath& new_path, RenameFileCallback callback) override;
  void LockFile(const ::base::FilePath& path, LockFileCallback callback) override;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) DirectoryAsyncWaiter {
 public:
  explicit DirectoryAsyncWaiter(Directory* proxy);

  DirectoryAsyncWaiter(const DirectoryAsyncWaiter&) = delete;
  DirectoryAsyncWaiter& operator=(const DirectoryAsyncWaiter&) = delete;

  ~DirectoryAsyncWaiter();
  void PathExists(
      const ::base::FilePath& path, bool* out_exists);
  bool PathExists(const ::base::FilePath& path);
  void GetEntries(
      const ::base::FilePath& path, GetEntriesMode mode, ::base::File::Error* out_error, std::vector<::base::FilePath>* out_entries);
  
  void OpenFile(
      const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, ::base::File::Error* out_error, ::base::File* out_file);
  
  void CreateDirectory(
      const ::base::FilePath& path, ::base::File::Error* out_error);
  ::base::File::Error CreateDirectory(const ::base::FilePath& path);
  void DeleteFile(
      const ::base::FilePath& path, bool* out_success);
  bool DeleteFile(const ::base::FilePath& path);
  void GetFileInfo(
      const ::base::FilePath& path, std::optional<::base::File::Info>* out_info);
  std::optional<::base::File::Info> GetFileInfo(const ::base::FilePath& path);
  void GetPathAccess(
      const ::base::FilePath& path, PathAccessInfoPtr* out_info);
  PathAccessInfoPtr GetPathAccess(const ::base::FilePath& path);
  void RenameFile(
      const ::base::FilePath& old_path, const ::base::FilePath& new_path, ::base::File::Error* out_error);
  ::base::File::Error RenameFile(const ::base::FilePath& old_path, const ::base::FilePath& new_path);
  void LockFile(
      const ::base::FilePath& path, ::base::File::Error* out_error, ::mojo::PendingRemote<FileLock>* out_lock);
  

 private:
  Directory* const proxy_;
};




}  // storage::mojom

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_TEST_UTILS_H_