// components/services/storage/public/mojom/blob_storage_context.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/services/storage/public/mojom/blob_storage_context.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"


namespace storage::mojom {
class BlobDataItemDataView;



}  // storage::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::BlobDataItemDataView> {
  using Data = ::storage::mojom::internal::BlobDataItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage::mojom {


enum class BlobDataItemType : int32_t {
  
  kUnknown = 0,
  
  kCacheStorage = 1,
  
  kIndexedDB = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, BlobDataItemType value);
inline bool IsKnownEnumValue(BlobDataItemType value) {
  return internal::BlobDataItemType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WriteBlobToFileResult : int32_t {
  
  kError = 0,
  
  kBadPath = 1,
  
  kInvalidBlob = 2,
  
  kIOError = 3,
  
  kTimestampError = 4,
  
  kSuccess = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, WriteBlobToFileResult value);
inline bool IsKnownEnumValue(WriteBlobToFileResult value) {
  return internal::WriteBlobToFileResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class BlobDataItemReaderInterfaceBase {};

using BlobDataItemReaderPtrDataView =
    mojo::InterfacePtrDataView<BlobDataItemReaderInterfaceBase>;
using BlobDataItemReaderRequestDataView =
    mojo::InterfaceRequestDataView<BlobDataItemReaderInterfaceBase>;
using BlobDataItemReaderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BlobDataItemReaderInterfaceBase>;
using BlobDataItemReaderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BlobDataItemReaderInterfaceBase>;
class BlobStorageContextInterfaceBase {};

using BlobStorageContextPtrDataView =
    mojo::InterfacePtrDataView<BlobStorageContextInterfaceBase>;
using BlobStorageContextRequestDataView =
    mojo::InterfaceRequestDataView<BlobStorageContextInterfaceBase>;
using BlobStorageContextAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BlobStorageContextInterfaceBase>;
using BlobStorageContextAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BlobStorageContextInterfaceBase>;


class BlobDataItemDataView {
 public:
  BlobDataItemDataView() = default;

  BlobDataItemDataView(
      internal::BlobDataItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::storage::mojom::BlobDataItemType>(
        data_value, output);
  }
  BlobDataItemType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::storage::mojom::BlobDataItemType>(data_->type));
  }
  uint64_t size() const {
    return data_->size;
  }
  uint64_t side_data_size() const {
    return data_->side_data_size;
  }
  inline void GetContentTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentType(UserType* output) {
    
    auto* pointer = data_->content_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeReader() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::storage::mojom::BlobDataItemReaderInterfaceBase>>(
            &data_->reader, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::BlobDataItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // storage::mojom

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_DATA_VIEW_H_