// components/services/storage/privileged/mojom/indexed_db_control_test.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_CONTROL_TEST_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_CONTROL_TEST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/privileged/mojom/indexed_db_control_test.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/privileged/mojom/indexed_db_control_test.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/privileged/mojom/indexed_db_control_test.mojom-forward.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/buckets/bucket_locator.mojom.h"
#include "mojo/public/mojom/base/byte_string.mojom-forward.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace storage::mojom {

class MockFailureInjectorProxy;

template <typename ImplRefTraits>
class MockFailureInjectorStub;

class MockFailureInjectorRequestValidator;


class MockFailureInjector
    : public MockFailureInjectorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.MockFailureInjector";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MockFailureInjectorInterfaceBase;
  using Proxy_ = MockFailureInjectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = MockFailureInjectorStub<ImplRefTraits>;

  using RequestValidator_ = MockFailureInjectorRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kFailOperationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct FailOperation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MockFailureInjector() = default;

  virtual void FailOperation(FailClass failure_class, FailMethod failure_method, int32_t instance_num, int32_t call_num) = 0;
};

class IndexedDBControlTestProxy;

template <typename ImplRefTraits>
class IndexedDBControlTestStub;

class IndexedDBControlTestRequestValidator;
class IndexedDBControlTestResponseValidator;


class IndexedDBControlTest
    : public IndexedDBControlTestInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.IndexedDBControlTest";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = IndexedDBControlTestInterfaceBase;
  using Proxy_ = IndexedDBControlTestProxy;

  template <typename ImplRefTraits>
  using Stub_ = IndexedDBControlTestStub<ImplRefTraits>;

  using RequestValidator_ = IndexedDBControlTestRequestValidator;
  using ResponseValidator_ = IndexedDBControlTestResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetBaseDataPathForTestingMinVersion = 0,
    kGetFilePathForTestingMinVersion = 0,
    kResetCachesForTestingMinVersion = 0,
    kGetPathForBlobForTestingMinVersion = 0,
    kFlushBackingStoreForTestingMinVersion = 0,
    kGetUsageForTestingMinVersion = 0,
    kBindMockFailureSingletonForTestingMinVersion = 0,
    kForceInitializeFromFilesForTestingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetBaseDataPathForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFilePathForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetCachesForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPathForBlobForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FlushBackingStoreForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUsageForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindMockFailureSingletonForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForceInitializeFromFilesForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~IndexedDBControlTest() = default;

  using GetBaseDataPathForTestingCallback = base::OnceCallback<void(const ::base::FilePath&)>;
  using GetBaseDataPathForTestingMojoCallback = base::OnceCallback<void(const ::base::FilePath&)>;

  virtual void GetBaseDataPathForTesting(GetBaseDataPathForTestingCallback callback) = 0;

  using GetFilePathForTestingCallback = base::OnceCallback<void(const ::base::FilePath&)>;
  using GetFilePathForTestingMojoCallback = base::OnceCallback<void(const ::base::FilePath&)>;

  virtual void GetFilePathForTesting(const ::storage::BucketLocator& bucket_locator, GetFilePathForTestingCallback callback) = 0;

  using ResetCachesForTestingCallback = base::OnceCallback<void()>;
  using ResetCachesForTestingMojoCallback = base::OnceCallback<void()>;

  virtual void ResetCachesForTesting(ResetCachesForTestingCallback callback) = 0;

  using GetPathForBlobForTestingCallback = base::OnceCallback<void(const ::base::FilePath&)>;
  using GetPathForBlobForTestingMojoCallback = base::OnceCallback<void(const ::base::FilePath&)>;

  virtual void GetPathForBlobForTesting(const ::storage::BucketLocator& bucket_locator, int64_t database_id, int64_t blob_number, GetPathForBlobForTestingCallback callback) = 0;

  using FlushBackingStoreForTestingCallback = base::OnceCallback<void()>;
  using FlushBackingStoreForTestingMojoCallback = base::OnceCallback<void()>;

  virtual void FlushBackingStoreForTesting(const ::storage::BucketLocator& bucket_locator, FlushBackingStoreForTestingCallback callback) = 0;

  using GetUsageForTestingCallback = base::OnceCallback<void(int64_t)>;
  using GetUsageForTestingMojoCallback = base::OnceCallback<void(int64_t)>;

  virtual void GetUsageForTesting(GetUsageForTestingCallback callback) = 0;

  virtual void BindMockFailureSingletonForTesting(::mojo::PendingReceiver<MockFailureInjector> receiver) = 0;

  using ForceInitializeFromFilesForTestingCallback = base::OnceCallback<void()>;
  using ForceInitializeFromFilesForTestingMojoCallback = base::OnceCallback<void()>;

  virtual void ForceInitializeFromFilesForTesting(ForceInitializeFromFilesForTestingCallback callback) = 0;
};



class  MockFailureInjectorProxy
    : public MockFailureInjector {
 public:
  using InterfaceType = MockFailureInjector;

  explicit MockFailureInjectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FailOperation(FailClass failure_class, FailMethod failure_method, int32_t instance_num, int32_t call_num) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  IndexedDBControlTestProxy
    : public IndexedDBControlTest {
 public:
  using InterfaceType = IndexedDBControlTest;

  explicit IndexedDBControlTestProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetBaseDataPathForTesting(GetBaseDataPathForTestingCallback callback) final;
  
  void GetFilePathForTesting(const ::storage::BucketLocator& bucket_locator, GetFilePathForTestingCallback callback) final;
  
  void ResetCachesForTesting(ResetCachesForTestingCallback callback) final;
  
  void GetPathForBlobForTesting(const ::storage::BucketLocator& bucket_locator, int64_t database_id, int64_t blob_number, GetPathForBlobForTestingCallback callback) final;
  
  void FlushBackingStoreForTesting(const ::storage::BucketLocator& bucket_locator, FlushBackingStoreForTestingCallback callback) final;
  
  void GetUsageForTesting(GetUsageForTestingCallback callback) final;
  
  void BindMockFailureSingletonForTesting(::mojo::PendingReceiver<MockFailureInjector> receiver) final;
  
  void ForceInitializeFromFilesForTesting(ForceInitializeFromFilesForTestingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MockFailureInjectorStubDispatch {
 public:
  static bool Accept(MockFailureInjector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MockFailureInjector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MockFailureInjector>>
class MockFailureInjectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MockFailureInjectorStub() = default;
  ~MockFailureInjectorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MockFailureInjectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MockFailureInjectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  IndexedDBControlTestStubDispatch {
 public:
  static bool Accept(IndexedDBControlTest* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IndexedDBControlTest* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IndexedDBControlTest>>
class IndexedDBControlTestStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IndexedDBControlTestStub() = default;
  ~IndexedDBControlTestStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IndexedDBControlTestStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IndexedDBControlTestStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MockFailureInjectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  IndexedDBControlTestRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  IndexedDBControlTestResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // storage::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_CONTROL_TEST_MOJOM_H_