// components/services/print_compositor/public/mojom/print_compositor.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_PRINT_COMPOSITOR_PUBLIC_MOJOM_PRINT_COMPOSITOR_MOJOM_H_
#define COMPONENTS_SERVICES_PRINT_COMPOSITOR_PUBLIC_MOJOM_PRINT_COMPOSITOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/print_compositor/public/mojom/print_compositor.mojom-features.h"  // IWYU pragma: export
#include "components/services/print_compositor/public/mojom/print_compositor.mojom-shared.h"  // IWYU pragma: export
#include "components/services/print_compositor/public/mojom/print_compositor.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "printing/mojom/print.mojom-forward.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"
#include "url/mojom/url.mojom.h"
#include "components/enterprise/watermarking/mojom/watermark.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace printing::mojom {

class PrintCompositorProxy;

template <typename ImplRefTraits>
class PrintCompositorStub;

class PrintCompositorRequestValidator;
class PrintCompositorResponseValidator;


class PrintCompositor
    : public PrintCompositorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "printing.mojom.PrintCompositor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kPrintCompositor;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PrintCompositorInterfaceBase;
  using Proxy_ = PrintCompositorProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrintCompositorStub<ImplRefTraits>;

  using RequestValidator_ = PrintCompositorRequestValidator;
  using ResponseValidator_ = PrintCompositorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kNotifyUnavailableSubframeMinVersion = 0,
    kAddSubframeContentMinVersion = 0,
    kSetAccessibilityTreeMinVersion = 0,
    kCompositePageMinVersion = 0,
    kCompositeDocumentMinVersion = 0,
    kPrepareToCompositeDocumentMinVersion = 0,
    kFinishDocumentCompositionMinVersion = 0,
    kSetWebContentsURLMinVersion = 0,
    kSetUserAgentMinVersion = 0,
    kSetGenerateDocumentOutlineMinVersion = 0,
    kSetTitleMinVersion = 0,
    kSetWatermarkBlockMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NotifyUnavailableSubframe_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddSubframeContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAccessibilityTree_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CompositePage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CompositeDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrepareToCompositeDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FinishDocumentComposition_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWebContentsURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUserAgent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetGenerateDocumentOutline_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTitle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWatermarkBlock_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using Status = PrintCompositor_Status;
  
  using DocumentType = PrintCompositor_DocumentType;
  virtual ~PrintCompositor() = default;

  virtual void NotifyUnavailableSubframe(uint64_t frame_guid) = 0;

  virtual void AddSubframeContent(uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion serialized_content, const base::flat_map<uint32_t, uint64_t>& subframe_content_info) = 0;

  virtual void SetAccessibilityTree(const ::ui::AXTreeUpdate& accessibility_tree) = 0;

  using CompositePageCallback = base::OnceCallback<void(PrintCompositor::Status, ::base::ReadOnlySharedMemoryRegion)>;
  using CompositePageMojoCallback = base::OnceCallback<void(PrintCompositor::Status, ::base::ReadOnlySharedMemoryRegion)>;

  virtual void CompositePage(uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion sk_region, const base::flat_map<uint32_t, uint64_t>& subframe_content_info, CompositePageCallback callback) = 0;

  using CompositeDocumentCallback = base::OnceCallback<void(PrintCompositor::Status, ::base::ReadOnlySharedMemoryRegion)>;
  using CompositeDocumentMojoCallback = base::OnceCallback<void(PrintCompositor::Status, ::base::ReadOnlySharedMemoryRegion)>;

  virtual void CompositeDocument(uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion sk_region, const base::flat_map<uint32_t, uint64_t>& subframe_content_info, PrintCompositor::DocumentType document_type, CompositeDocumentCallback callback) = 0;

  using PrepareToCompositeDocumentCallback = base::OnceCallback<void(PrintCompositor::Status)>;
  using PrepareToCompositeDocumentMojoCallback = base::OnceCallback<void(PrintCompositor::Status)>;

  virtual void PrepareToCompositeDocument(PrintCompositor::DocumentType document_type, PrepareToCompositeDocumentCallback callback) = 0;

  using FinishDocumentCompositionCallback = base::OnceCallback<void(PrintCompositor::Status, ::base::ReadOnlySharedMemoryRegion)>;
  using FinishDocumentCompositionMojoCallback = base::OnceCallback<void(PrintCompositor::Status, ::base::ReadOnlySharedMemoryRegion)>;

  virtual void FinishDocumentComposition(uint32_t pages_count, FinishDocumentCompositionCallback callback) = 0;

  virtual void SetWebContentsURL(const ::GURL& url) = 0;

  virtual void SetUserAgent(const std::string& user_agent) = 0;

  virtual void SetGenerateDocumentOutline(::printing::mojom::GenerateDocumentOutline generate_document_outline) = 0;

  virtual void SetTitle(const std::string& title) = 0;

  virtual void SetWatermarkBlock(::watermark::mojom::WatermarkBlockPtr watermark_block) = 0;
};



class  PrintCompositorProxy
    : public PrintCompositor {
 public:
  using InterfaceType = PrintCompositor;

  explicit PrintCompositorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NotifyUnavailableSubframe(uint64_t frame_guid) final;
  
  void AddSubframeContent(uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion serialized_content, const base::flat_map<uint32_t, uint64_t>& subframe_content_info) final;
  
  void SetAccessibilityTree(const ::ui::AXTreeUpdate& accessibility_tree) final;
  
  void CompositePage(uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion sk_region, const base::flat_map<uint32_t, uint64_t>& subframe_content_info, CompositePageCallback callback) final;
  
  void CompositeDocument(uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion sk_region, const base::flat_map<uint32_t, uint64_t>& subframe_content_info, PrintCompositor::DocumentType document_type, CompositeDocumentCallback callback) final;
  
  void PrepareToCompositeDocument(PrintCompositor::DocumentType document_type, PrepareToCompositeDocumentCallback callback) final;
  
  void FinishDocumentComposition(uint32_t pages_count, FinishDocumentCompositionCallback callback) final;
  
  void SetWebContentsURL(const ::GURL& url) final;
  
  void SetUserAgent(const std::string& user_agent) final;
  
  void SetGenerateDocumentOutline(::printing::mojom::GenerateDocumentOutline generate_document_outline) final;
  
  void SetTitle(const std::string& title) final;
  
  void SetWatermarkBlock(::watermark::mojom::WatermarkBlockPtr watermark_block) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PrintCompositorStubDispatch {
 public:
  static bool Accept(PrintCompositor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrintCompositor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrintCompositor>>
class PrintCompositorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrintCompositorStub() = default;
  ~PrintCompositorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintCompositorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintCompositorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PrintCompositorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrintCompositorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // printing::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_PRINT_COMPOSITOR_PUBLIC_MOJOM_PRINT_COMPOSITOR_MOJOM_H_