// components/services/print_compositor/public/mojom/print_compositor.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/print_compositor/public/mojom/print_compositor.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/print_compositor/public/mojom/print_compositor.mojom-params-data.h"
#include "components/services/print_compositor/public/mojom/print_compositor.mojom-shared-message-ids.h"

#include "components/services/print_compositor/public/mojom/print_compositor.mojom-import-headers.h"
#include "components/services/print_compositor/public/mojom/print_compositor.mojom-test-utils.h"


namespace printing::mojom {
// The declaration includes the definition on other builds.

PrintCompositor::IPCStableHashFunction PrintCompositor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PrintCompositor>(message.name())) {
    case messages::PrintCompositor::kNotifyUnavailableSubframe: {
      return &PrintCompositor::NotifyUnavailableSubframe_Sym::IPCStableHash;
    }
    case messages::PrintCompositor::kAddSubframeContent: {
      return &PrintCompositor::AddSubframeContent_Sym::IPCStableHash;
    }
    case messages::PrintCompositor::kSetAccessibilityTree: {
      return &PrintCompositor::SetAccessibilityTree_Sym::IPCStableHash;
    }
    case messages::PrintCompositor::kCompositePage: {
      return &PrintCompositor::CompositePage_Sym::IPCStableHash;
    }
    case messages::PrintCompositor::kCompositeDocument: {
      return &PrintCompositor::CompositeDocument_Sym::IPCStableHash;
    }
    case messages::PrintCompositor::kPrepareToCompositeDocument: {
      return &PrintCompositor::PrepareToCompositeDocument_Sym::IPCStableHash;
    }
    case messages::PrintCompositor::kFinishDocumentComposition: {
      return &PrintCompositor::FinishDocumentComposition_Sym::IPCStableHash;
    }
    case messages::PrintCompositor::kSetWebContentsURL: {
      return &PrintCompositor::SetWebContentsURL_Sym::IPCStableHash;
    }
    case messages::PrintCompositor::kSetUserAgent: {
      return &PrintCompositor::SetUserAgent_Sym::IPCStableHash;
    }
    case messages::PrintCompositor::kSetGenerateDocumentOutline: {
      return &PrintCompositor::SetGenerateDocumentOutline_Sym::IPCStableHash;
    }
    case messages::PrintCompositor::kSetTitle: {
      return &PrintCompositor::SetTitle_Sym::IPCStableHash;
    }
    case messages::PrintCompositor::kSetWatermarkBlock: {
      return &PrintCompositor::SetWatermarkBlock_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PrintCompositor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PrintCompositor>(message.name())) {
      case messages::PrintCompositor::kNotifyUnavailableSubframe:
            return "Receive printing::mojom::PrintCompositor::NotifyUnavailableSubframe";
      case messages::PrintCompositor::kAddSubframeContent:
            return "Receive printing::mojom::PrintCompositor::AddSubframeContent";
      case messages::PrintCompositor::kSetAccessibilityTree:
            return "Receive printing::mojom::PrintCompositor::SetAccessibilityTree";
      case messages::PrintCompositor::kCompositePage:
            return "Receive printing::mojom::PrintCompositor::CompositePage";
      case messages::PrintCompositor::kCompositeDocument:
            return "Receive printing::mojom::PrintCompositor::CompositeDocument";
      case messages::PrintCompositor::kPrepareToCompositeDocument:
            return "Receive printing::mojom::PrintCompositor::PrepareToCompositeDocument";
      case messages::PrintCompositor::kFinishDocumentComposition:
            return "Receive printing::mojom::PrintCompositor::FinishDocumentComposition";
      case messages::PrintCompositor::kSetWebContentsURL:
            return "Receive printing::mojom::PrintCompositor::SetWebContentsURL";
      case messages::PrintCompositor::kSetUserAgent:
            return "Receive printing::mojom::PrintCompositor::SetUserAgent";
      case messages::PrintCompositor::kSetGenerateDocumentOutline:
            return "Receive printing::mojom::PrintCompositor::SetGenerateDocumentOutline";
      case messages::PrintCompositor::kSetTitle:
            return "Receive printing::mojom::PrintCompositor::SetTitle";
      case messages::PrintCompositor::kSetWatermarkBlock:
            return "Receive printing::mojom::PrintCompositor::SetWatermarkBlock";
    }
  } else {
    switch (static_cast<messages::PrintCompositor>(message.name())) {
      case messages::PrintCompositor::kNotifyUnavailableSubframe:
            return "Receive reply printing::mojom::PrintCompositor::NotifyUnavailableSubframe";
      case messages::PrintCompositor::kAddSubframeContent:
            return "Receive reply printing::mojom::PrintCompositor::AddSubframeContent";
      case messages::PrintCompositor::kSetAccessibilityTree:
            return "Receive reply printing::mojom::PrintCompositor::SetAccessibilityTree";
      case messages::PrintCompositor::kCompositePage:
            return "Receive reply printing::mojom::PrintCompositor::CompositePage";
      case messages::PrintCompositor::kCompositeDocument:
            return "Receive reply printing::mojom::PrintCompositor::CompositeDocument";
      case messages::PrintCompositor::kPrepareToCompositeDocument:
            return "Receive reply printing::mojom::PrintCompositor::PrepareToCompositeDocument";
      case messages::PrintCompositor::kFinishDocumentComposition:
            return "Receive reply printing::mojom::PrintCompositor::FinishDocumentComposition";
      case messages::PrintCompositor::kSetWebContentsURL:
            return "Receive reply printing::mojom::PrintCompositor::SetWebContentsURL";
      case messages::PrintCompositor::kSetUserAgent:
            return "Receive reply printing::mojom::PrintCompositor::SetUserAgent";
      case messages::PrintCompositor::kSetGenerateDocumentOutline:
            return "Receive reply printing::mojom::PrintCompositor::SetGenerateDocumentOutline";
      case messages::PrintCompositor::kSetTitle:
            return "Receive reply printing::mojom::PrintCompositor::SetTitle";
      case messages::PrintCompositor::kSetWatermarkBlock:
            return "Receive reply printing::mojom::PrintCompositor::SetWatermarkBlock";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PrintCompositor::NotifyUnavailableSubframe_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x87a8cb37;  // IPCStableHash for printing::mojom::PrintCompositor::NotifyUnavailableSubframe
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintCompositor::AddSubframeContent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdaf37e02;  // IPCStableHash for printing::mojom::PrintCompositor::AddSubframeContent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintCompositor::SetAccessibilityTree_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a5e3b19;  // IPCStableHash for printing::mojom::PrintCompositor::SetAccessibilityTree
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintCompositor::CompositePage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaf7b8a15;  // IPCStableHash for printing::mojom::PrintCompositor::CompositePage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintCompositor::CompositeDocument_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8162d3c;  // IPCStableHash for printing::mojom::PrintCompositor::CompositeDocument
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintCompositor::PrepareToCompositeDocument_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6eb823f8;  // IPCStableHash for printing::mojom::PrintCompositor::PrepareToCompositeDocument
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintCompositor::FinishDocumentComposition_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x398da836;  // IPCStableHash for printing::mojom::PrintCompositor::FinishDocumentComposition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintCompositor::SetWebContentsURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x691fb7ee;  // IPCStableHash for printing::mojom::PrintCompositor::SetWebContentsURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintCompositor::SetUserAgent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f0ba9f3;  // IPCStableHash for printing::mojom::PrintCompositor::SetUserAgent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintCompositor::SetGenerateDocumentOutline_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x36e1b258;  // IPCStableHash for printing::mojom::PrintCompositor::SetGenerateDocumentOutline
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintCompositor::SetTitle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe39d51c3;  // IPCStableHash for printing::mojom::PrintCompositor::SetTitle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintCompositor::SetWatermarkBlock_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x34f5ee38;  // IPCStableHash for printing::mojom::PrintCompositor::SetWatermarkBlock
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PrintCompositor_CompositePage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintCompositor_CompositePage_ForwardToCallback(
      PrintCompositor::CompositePageCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintCompositor_CompositePage_ForwardToCallback(const PrintCompositor_CompositePage_ForwardToCallback&) = delete;
  PrintCompositor_CompositePage_ForwardToCallback& operator=(const PrintCompositor_CompositePage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintCompositor::CompositePageCallback callback_;
};

class PrintCompositor_CompositeDocument_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintCompositor_CompositeDocument_ForwardToCallback(
      PrintCompositor::CompositeDocumentCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintCompositor_CompositeDocument_ForwardToCallback(const PrintCompositor_CompositeDocument_ForwardToCallback&) = delete;
  PrintCompositor_CompositeDocument_ForwardToCallback& operator=(const PrintCompositor_CompositeDocument_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintCompositor::CompositeDocumentCallback callback_;
};

class PrintCompositor_PrepareToCompositeDocument_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintCompositor_PrepareToCompositeDocument_ForwardToCallback(
      PrintCompositor::PrepareToCompositeDocumentCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintCompositor_PrepareToCompositeDocument_ForwardToCallback(const PrintCompositor_PrepareToCompositeDocument_ForwardToCallback&) = delete;
  PrintCompositor_PrepareToCompositeDocument_ForwardToCallback& operator=(const PrintCompositor_PrepareToCompositeDocument_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintCompositor::PrepareToCompositeDocumentCallback callback_;
};

class PrintCompositor_FinishDocumentComposition_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintCompositor_FinishDocumentComposition_ForwardToCallback(
      PrintCompositor::FinishDocumentCompositionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintCompositor_FinishDocumentComposition_ForwardToCallback(const PrintCompositor_FinishDocumentComposition_ForwardToCallback&) = delete;
  PrintCompositor_FinishDocumentComposition_ForwardToCallback& operator=(const PrintCompositor_FinishDocumentComposition_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintCompositor::FinishDocumentCompositionCallback callback_;
};

PrintCompositorProxy::PrintCompositorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrintCompositorProxy::NotifyUnavailableSubframe(
    uint64_t in_frame_guid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintCompositor::NotifyUnavailableSubframe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_guid"), in_frame_guid,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kNotifyUnavailableSubframe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_NotifyUnavailableSubframe_Params_Data> params(
          message);
  params.Allocate();

  params->frame_guid = in_frame_guid;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("NotifyUnavailableSubframe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintCompositorProxy::AddSubframeContent(
    uint64_t in_frame_guid, ::base::ReadOnlySharedMemoryRegion in_serialized_content, const base::flat_map<uint32_t, uint64_t>& in_subframe_content_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintCompositor::AddSubframeContent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_guid"), in_frame_guid,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("serialized_content"), in_serialized_content,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subframe_content_info"), in_subframe_content_info,
                        "<value of type const base::flat_map<uint32_t, uint64_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kAddSubframeContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_AddSubframeContent_Params_Data> params(
          message);
  params.Allocate();

  params->frame_guid = in_frame_guid;
  mojo::internal::MessageFragment<
      typename decltype(params->serialized_content)::BaseType> serialized_content_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_serialized_content,
    serialized_content_fragment);

  params->serialized_content.Set(
      serialized_content_fragment.is_null() ? nullptr : serialized_content_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->serialized_content.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null serialized_content in PrintCompositor.AddSubframeContent request");
  mojo::internal::MessageFragment<
      typename decltype(params->subframe_content_info)::BaseType>
      subframe_content_info_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& subframe_content_info_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<uint32_t, uint64_t>>(
    in_subframe_content_info,
    subframe_content_info_fragment,
    &subframe_content_info_validate_params);

  params->subframe_content_info.Set(
      subframe_content_info_fragment.is_null() ? nullptr : subframe_content_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subframe_content_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subframe_content_info in PrintCompositor.AddSubframeContent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("AddSubframeContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintCompositorProxy::SetAccessibilityTree(
    const ::ui::AXTreeUpdate& in_accessibility_tree) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintCompositor::SetAccessibilityTree", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("accessibility_tree"), in_accessibility_tree,
                        "<value of type const ::ui::AXTreeUpdate&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kSetAccessibilityTree), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_SetAccessibilityTree_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->accessibility_tree)::BaseType> accessibility_tree_fragment(
          params.message());
  
  mojo::internal::Serialize<::ax::mojom::AXTreeUpdateDataView>(
    in_accessibility_tree,
    accessibility_tree_fragment);

  params->accessibility_tree.Set(
      accessibility_tree_fragment.is_null() ? nullptr : accessibility_tree_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->accessibility_tree.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null accessibility_tree in PrintCompositor.SetAccessibilityTree request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("SetAccessibilityTree");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintCompositorProxy::CompositePage(
    uint64_t in_frame_guid, ::base::ReadOnlySharedMemoryRegion in_sk_region, const base::flat_map<uint32_t, uint64_t>& in_subframe_content_info, CompositePageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintCompositor::CompositePage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_guid"), in_frame_guid,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sk_region"), in_sk_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subframe_content_info"), in_subframe_content_info,
                        "<value of type const base::flat_map<uint32_t, uint64_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kCompositePage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_CompositePage_Params_Data> params(
          message);
  params.Allocate();

  params->frame_guid = in_frame_guid;
  mojo::internal::MessageFragment<
      typename decltype(params->sk_region)::BaseType> sk_region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_sk_region,
    sk_region_fragment);

  params->sk_region.Set(
      sk_region_fragment.is_null() ? nullptr : sk_region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sk_region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sk_region in PrintCompositor.CompositePage request");
  mojo::internal::MessageFragment<
      typename decltype(params->subframe_content_info)::BaseType>
      subframe_content_info_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& subframe_content_info_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<uint32_t, uint64_t>>(
    in_subframe_content_info,
    subframe_content_info_fragment,
    &subframe_content_info_validate_params);

  params->subframe_content_info.Set(
      subframe_content_info_fragment.is_null() ? nullptr : subframe_content_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subframe_content_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subframe_content_info in PrintCompositor.CompositePage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("CompositePage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintCompositor_CompositePage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintCompositorProxy::CompositeDocument(
    uint64_t in_frame_guid, ::base::ReadOnlySharedMemoryRegion in_sk_region, const base::flat_map<uint32_t, uint64_t>& in_subframe_content_info, PrintCompositor::DocumentType in_document_type, CompositeDocumentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintCompositor::CompositeDocument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_guid"), in_frame_guid,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sk_region"), in_sk_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subframe_content_info"), in_subframe_content_info,
                        "<value of type const base::flat_map<uint32_t, uint64_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_type"), in_document_type,
                        "<value of type PrintCompositor::DocumentType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kCompositeDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_CompositeDocument_Params_Data> params(
          message);
  params.Allocate();

  params->frame_guid = in_frame_guid;
  mojo::internal::MessageFragment<
      typename decltype(params->sk_region)::BaseType> sk_region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_sk_region,
    sk_region_fragment);

  params->sk_region.Set(
      sk_region_fragment.is_null() ? nullptr : sk_region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sk_region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sk_region in PrintCompositor.CompositeDocument request");
  mojo::internal::MessageFragment<
      typename decltype(params->subframe_content_info)::BaseType>
      subframe_content_info_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& subframe_content_info_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<uint32_t, uint64_t>>(
    in_subframe_content_info,
    subframe_content_info_fragment,
    &subframe_content_info_validate_params);

  params->subframe_content_info.Set(
      subframe_content_info_fragment.is_null() ? nullptr : subframe_content_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subframe_content_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subframe_content_info in PrintCompositor.CompositeDocument request");

  
  mojo::internal::Serialize<::printing::mojom::PrintCompositor_DocumentType>(
    in_document_type,
    &params->document_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("CompositeDocument");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintCompositor_CompositeDocument_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintCompositorProxy::PrepareToCompositeDocument(
    PrintCompositor::DocumentType in_document_type, PrepareToCompositeDocumentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintCompositor::PrepareToCompositeDocument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_type"), in_document_type,
                        "<value of type PrintCompositor::DocumentType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kPrepareToCompositeDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_PrepareToCompositeDocument_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::printing::mojom::PrintCompositor_DocumentType>(
    in_document_type,
    &params->document_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("PrepareToCompositeDocument");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintCompositor_PrepareToCompositeDocument_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintCompositorProxy::FinishDocumentComposition(
    uint32_t in_pages_count, FinishDocumentCompositionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintCompositor::FinishDocumentComposition", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pages_count"), in_pages_count,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kFinishDocumentComposition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_FinishDocumentComposition_Params_Data> params(
          message);
  params.Allocate();

  params->pages_count = in_pages_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("FinishDocumentComposition");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintCompositor_FinishDocumentComposition_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintCompositorProxy::SetWebContentsURL(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintCompositor::SetWebContentsURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kSetWebContentsURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_SetWebContentsURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PrintCompositor.SetWebContentsURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("SetWebContentsURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintCompositorProxy::SetUserAgent(
    const std::string& in_user_agent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintCompositor::SetUserAgent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_agent"), in_user_agent,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kSetUserAgent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_SetUserAgent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->user_agent)::BaseType> user_agent_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_user_agent,
    user_agent_fragment);

  params->user_agent.Set(
      user_agent_fragment.is_null() ? nullptr : user_agent_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->user_agent.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null user_agent in PrintCompositor.SetUserAgent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("SetUserAgent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintCompositorProxy::SetGenerateDocumentOutline(
    ::printing::mojom::GenerateDocumentOutline in_generate_document_outline) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintCompositor::SetGenerateDocumentOutline", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("generate_document_outline"), in_generate_document_outline,
                        "<value of type ::printing::mojom::GenerateDocumentOutline>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kSetGenerateDocumentOutline), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_SetGenerateDocumentOutline_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::printing::mojom::GenerateDocumentOutline>(
    in_generate_document_outline,
    &params->generate_document_outline);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("SetGenerateDocumentOutline");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintCompositorProxy::SetTitle(
    const std::string& in_title) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintCompositor::SetTitle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kSetTitle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_SetTitle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in PrintCompositor.SetTitle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("SetTitle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintCompositorProxy::SetWatermarkBlock(
    ::watermark::mojom::WatermarkBlockPtr in_watermark_block) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintCompositor::SetWatermarkBlock", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("watermark_block"), in_watermark_block,
                        "<value of type ::watermark::mojom::WatermarkBlockPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kSetWatermarkBlock), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_SetWatermarkBlock_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->watermark_block)::BaseType> watermark_block_fragment(
          params.message());
  
  mojo::internal::Serialize<::watermark::mojom::WatermarkBlockDataView>(
    in_watermark_block,
    watermark_block_fragment);

  params->watermark_block.Set(
      watermark_block_fragment.is_null() ? nullptr : watermark_block_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("SetWatermarkBlock");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PrintCompositor_CompositePage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintCompositor::CompositePageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintCompositor_CompositePage_ProxyToResponder> proxy(
        new PrintCompositor_CompositePage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintCompositor_CompositePage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintCompositor_CompositePage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintCompositor_CompositePage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrintCompositor::CompositePageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintCompositor::Status in_status, ::base::ReadOnlySharedMemoryRegion in_document_region);
};

bool PrintCompositor_CompositePage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintCompositor_CompositePage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintCompositor_CompositePage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrintCompositor.3
  bool success = true;
  PrintCompositor::Status p_status{};
  ::base::ReadOnlySharedMemoryRegion p_document_region{};
  PrintCompositor_CompositePage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadDocumentRegion(&p_document_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintCompositor::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_document_region));
  }
  return true;
}

void PrintCompositor_CompositePage_ProxyToResponder::Run(
    PrintCompositor::Status in_status, ::base::ReadOnlySharedMemoryRegion in_document_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintCompositor::CompositePage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PrintCompositor::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_region"), in_document_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kCompositePage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_CompositePage_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::printing::mojom::PrintCompositor_Status>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->document_region)::BaseType> document_region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_document_region,
    document_region_fragment);

  params->document_region.Set(
      document_region_fragment.is_null() ? nullptr : document_region_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("CompositePage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintCompositor_CompositeDocument_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintCompositor::CompositeDocumentCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintCompositor_CompositeDocument_ProxyToResponder> proxy(
        new PrintCompositor_CompositeDocument_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintCompositor_CompositeDocument_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintCompositor_CompositeDocument_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintCompositor_CompositeDocument_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrintCompositor::CompositeDocumentCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintCompositor::Status in_status, ::base::ReadOnlySharedMemoryRegion in_document_region);
};

bool PrintCompositor_CompositeDocument_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintCompositor_CompositeDocument_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintCompositor_CompositeDocument_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrintCompositor.4
  bool success = true;
  PrintCompositor::Status p_status{};
  ::base::ReadOnlySharedMemoryRegion p_document_region{};
  PrintCompositor_CompositeDocument_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadDocumentRegion(&p_document_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintCompositor::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_document_region));
  }
  return true;
}

void PrintCompositor_CompositeDocument_ProxyToResponder::Run(
    PrintCompositor::Status in_status, ::base::ReadOnlySharedMemoryRegion in_document_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintCompositor::CompositeDocument", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PrintCompositor::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_region"), in_document_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kCompositeDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_CompositeDocument_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::printing::mojom::PrintCompositor_Status>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->document_region)::BaseType> document_region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_document_region,
    document_region_fragment);

  params->document_region.Set(
      document_region_fragment.is_null() ? nullptr : document_region_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("CompositeDocument");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintCompositor_PrepareToCompositeDocument_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintCompositor::PrepareToCompositeDocumentCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintCompositor_PrepareToCompositeDocument_ProxyToResponder> proxy(
        new PrintCompositor_PrepareToCompositeDocument_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintCompositor_PrepareToCompositeDocument_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintCompositor_PrepareToCompositeDocument_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintCompositor_PrepareToCompositeDocument_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrintCompositor::PrepareToCompositeDocumentCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintCompositor::Status in_status);
};

bool PrintCompositor_PrepareToCompositeDocument_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintCompositor_PrepareToCompositeDocument_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintCompositor_PrepareToCompositeDocument_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrintCompositor.5
  bool success = true;
  PrintCompositor::Status p_status{};
  PrintCompositor_PrepareToCompositeDocument_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintCompositor::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void PrintCompositor_PrepareToCompositeDocument_ProxyToResponder::Run(
    PrintCompositor::Status in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintCompositor::PrepareToCompositeDocument", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PrintCompositor::Status>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kPrepareToCompositeDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_PrepareToCompositeDocument_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::printing::mojom::PrintCompositor_Status>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("PrepareToCompositeDocument");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintCompositor_FinishDocumentComposition_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintCompositor::FinishDocumentCompositionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintCompositor_FinishDocumentComposition_ProxyToResponder> proxy(
        new PrintCompositor_FinishDocumentComposition_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintCompositor_FinishDocumentComposition_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintCompositor_FinishDocumentComposition_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintCompositor_FinishDocumentComposition_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrintCompositor::FinishDocumentCompositionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintCompositor::Status in_status, ::base::ReadOnlySharedMemoryRegion in_document_region);
};

bool PrintCompositor_FinishDocumentComposition_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintCompositor_FinishDocumentComposition_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintCompositor_FinishDocumentComposition_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrintCompositor.6
  bool success = true;
  PrintCompositor::Status p_status{};
  ::base::ReadOnlySharedMemoryRegion p_document_region{};
  PrintCompositor_FinishDocumentComposition_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadDocumentRegion(&p_document_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintCompositor::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_document_region));
  }
  return true;
}

void PrintCompositor_FinishDocumentComposition_ProxyToResponder::Run(
    PrintCompositor::Status in_status, ::base::ReadOnlySharedMemoryRegion in_document_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintCompositor::FinishDocumentComposition", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PrintCompositor::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_region"), in_document_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintCompositor::kFinishDocumentComposition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_FinishDocumentComposition_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::printing::mojom::PrintCompositor_Status>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->document_region)::BaseType> document_region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_document_region,
    document_region_fragment);

  params->document_region.Set(
      document_region_fragment.is_null() ? nullptr : document_region_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("FinishDocumentComposition");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PrintCompositorStubDispatch::Accept(
    PrintCompositor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PrintCompositor>(message->header()->name)) {
    case messages::PrintCompositor::kNotifyUnavailableSubframe: {
      DCHECK(message->is_serialized());
      internal::PrintCompositor_NotifyUnavailableSubframe_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_NotifyUnavailableSubframe_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrintCompositor.0
      bool success = true;
      uint64_t p_frame_guid{};
      PrintCompositor_NotifyUnavailableSubframe_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_guid = input_data_view.frame_guid();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyUnavailableSubframe(        
        std::move(p_frame_guid));
      return true;
    }
    case messages::PrintCompositor::kAddSubframeContent: {
      DCHECK(message->is_serialized());
      internal::PrintCompositor_AddSubframeContent_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_AddSubframeContent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrintCompositor.1
      bool success = true;
      uint64_t p_frame_guid{};
      ::base::ReadOnlySharedMemoryRegion p_serialized_content{};
      base::flat_map<uint32_t, uint64_t> p_subframe_content_info{};
      PrintCompositor_AddSubframeContent_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_guid = input_data_view.frame_guid();
      if (success && !input_data_view.ReadSerializedContent(&p_serialized_content))
        success = false;
      if (success && !input_data_view.ReadSubframeContentInfo(&p_subframe_content_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddSubframeContent(        
        std::move(p_frame_guid), 
        std::move(p_serialized_content), 
        std::move(p_subframe_content_info));
      return true;
    }
    case messages::PrintCompositor::kSetAccessibilityTree: {
      DCHECK(message->is_serialized());
      internal::PrintCompositor_SetAccessibilityTree_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_SetAccessibilityTree_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrintCompositor.2
      bool success = true;
      ::ui::AXTreeUpdate p_accessibility_tree{};
      PrintCompositor_SetAccessibilityTree_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAccessibilityTree(&p_accessibility_tree))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAccessibilityTree(        
        std::move(p_accessibility_tree));
      return true;
    }
    case messages::PrintCompositor::kCompositePage: {
      break;
    }
    case messages::PrintCompositor::kCompositeDocument: {
      break;
    }
    case messages::PrintCompositor::kPrepareToCompositeDocument: {
      break;
    }
    case messages::PrintCompositor::kFinishDocumentComposition: {
      break;
    }
    case messages::PrintCompositor::kSetWebContentsURL: {
      DCHECK(message->is_serialized());
      internal::PrintCompositor_SetWebContentsURL_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_SetWebContentsURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrintCompositor.7
      bool success = true;
      ::GURL p_url{};
      PrintCompositor_SetWebContentsURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWebContentsURL(        
        std::move(p_url));
      return true;
    }
    case messages::PrintCompositor::kSetUserAgent: {
      DCHECK(message->is_serialized());
      internal::PrintCompositor_SetUserAgent_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_SetUserAgent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrintCompositor.8
      bool success = true;
      std::string p_user_agent{};
      PrintCompositor_SetUserAgent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUserAgent(&p_user_agent))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserAgent(        
        std::move(p_user_agent));
      return true;
    }
    case messages::PrintCompositor::kSetGenerateDocumentOutline: {
      DCHECK(message->is_serialized());
      internal::PrintCompositor_SetGenerateDocumentOutline_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_SetGenerateDocumentOutline_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrintCompositor.9
      bool success = true;
      ::printing::mojom::GenerateDocumentOutline p_generate_document_outline{};
      PrintCompositor_SetGenerateDocumentOutline_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGenerateDocumentOutline(&p_generate_document_outline))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetGenerateDocumentOutline(        
        std::move(p_generate_document_outline));
      return true;
    }
    case messages::PrintCompositor::kSetTitle: {
      DCHECK(message->is_serialized());
      internal::PrintCompositor_SetTitle_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_SetTitle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrintCompositor.10
      bool success = true;
      std::string p_title{};
      PrintCompositor_SetTitle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTitle(        
        std::move(p_title));
      return true;
    }
    case messages::PrintCompositor::kSetWatermarkBlock: {
      DCHECK(message->is_serialized());
      internal::PrintCompositor_SetWatermarkBlock_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_SetWatermarkBlock_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrintCompositor.11
      bool success = true;
      ::watermark::mojom::WatermarkBlockPtr p_watermark_block{};
      PrintCompositor_SetWatermarkBlock_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWatermarkBlock(&p_watermark_block))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWatermarkBlock(        
        std::move(p_watermark_block));
      return true;
    }
  }
  return false;
}

// static
bool PrintCompositorStubDispatch::AcceptWithResponder(
    PrintCompositor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PrintCompositor>(message->header()->name)) {
    case messages::PrintCompositor::kNotifyUnavailableSubframe: {
      break;
    }
    case messages::PrintCompositor::kAddSubframeContent: {
      break;
    }
    case messages::PrintCompositor::kSetAccessibilityTree: {
      break;
    }
    case messages::PrintCompositor::kCompositePage: {
      internal::PrintCompositor_CompositePage_Params_Data* params =
          reinterpret_cast<
              internal::PrintCompositor_CompositePage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrintCompositor.3
      bool success = true;
      uint64_t p_frame_guid{};
      ::base::ReadOnlySharedMemoryRegion p_sk_region{};
      base::flat_map<uint32_t, uint64_t> p_subframe_content_info{};
      PrintCompositor_CompositePage_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_guid = input_data_view.frame_guid();
      if (success && !input_data_view.ReadSkRegion(&p_sk_region))
        success = false;
      if (success && !input_data_view.ReadSubframeContentInfo(&p_subframe_content_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 3, false);
        return false;
      }
      auto callback =
          PrintCompositor_CompositePage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CompositePage(        
        std::move(p_frame_guid), 
        std::move(p_sk_region), 
        std::move(p_subframe_content_info), std::move(callback));
      return true;
    }
    case messages::PrintCompositor::kCompositeDocument: {
      internal::PrintCompositor_CompositeDocument_Params_Data* params =
          reinterpret_cast<
              internal::PrintCompositor_CompositeDocument_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrintCompositor.4
      bool success = true;
      uint64_t p_frame_guid{};
      ::base::ReadOnlySharedMemoryRegion p_sk_region{};
      base::flat_map<uint32_t, uint64_t> p_subframe_content_info{};
      PrintCompositor::DocumentType p_document_type{};
      PrintCompositor_CompositeDocument_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_guid = input_data_view.frame_guid();
      if (success && !input_data_view.ReadSkRegion(&p_sk_region))
        success = false;
      if (success && !input_data_view.ReadSubframeContentInfo(&p_subframe_content_info))
        success = false;
      if (success && !input_data_view.ReadDocumentType(&p_document_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 4, false);
        return false;
      }
      auto callback =
          PrintCompositor_CompositeDocument_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CompositeDocument(        
        std::move(p_frame_guid), 
        std::move(p_sk_region), 
        std::move(p_subframe_content_info), 
        std::move(p_document_type), std::move(callback));
      return true;
    }
    case messages::PrintCompositor::kPrepareToCompositeDocument: {
      internal::PrintCompositor_PrepareToCompositeDocument_Params_Data* params =
          reinterpret_cast<
              internal::PrintCompositor_PrepareToCompositeDocument_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrintCompositor.5
      bool success = true;
      PrintCompositor::DocumentType p_document_type{};
      PrintCompositor_PrepareToCompositeDocument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDocumentType(&p_document_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 5, false);
        return false;
      }
      auto callback =
          PrintCompositor_PrepareToCompositeDocument_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrepareToCompositeDocument(        
        std::move(p_document_type), std::move(callback));
      return true;
    }
    case messages::PrintCompositor::kFinishDocumentComposition: {
      internal::PrintCompositor_FinishDocumentComposition_Params_Data* params =
          reinterpret_cast<
              internal::PrintCompositor_FinishDocumentComposition_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrintCompositor.6
      bool success = true;
      uint32_t p_pages_count{};
      PrintCompositor_FinishDocumentComposition_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_pages_count = input_data_view.pages_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 6, false);
        return false;
      }
      auto callback =
          PrintCompositor_FinishDocumentComposition_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FinishDocumentComposition(        
        std::move(p_pages_count), std::move(callback));
      return true;
    }
    case messages::PrintCompositor::kSetWebContentsURL: {
      break;
    }
    case messages::PrintCompositor::kSetUserAgent: {
      break;
    }
    case messages::PrintCompositor::kSetGenerateDocumentOutline: {
      break;
    }
    case messages::PrintCompositor::kSetTitle: {
      break;
    }
    case messages::PrintCompositor::kSetWatermarkBlock: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPrintCompositorValidationInfo[] = {
    { &internal::PrintCompositor_NotifyUnavailableSubframe_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PrintCompositor_AddSubframeContent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PrintCompositor_SetAccessibilityTree_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PrintCompositor_CompositePage_Params_Data::Validate,
     &internal::PrintCompositor_CompositePage_ResponseParams_Data::Validate},
    { &internal::PrintCompositor_CompositeDocument_Params_Data::Validate,
     &internal::PrintCompositor_CompositeDocument_ResponseParams_Data::Validate},
    { &internal::PrintCompositor_PrepareToCompositeDocument_Params_Data::Validate,
     &internal::PrintCompositor_PrepareToCompositeDocument_ResponseParams_Data::Validate},
    { &internal::PrintCompositor_FinishDocumentComposition_Params_Data::Validate,
     &internal::PrintCompositor_FinishDocumentComposition_ResponseParams_Data::Validate},
    { &internal::PrintCompositor_SetWebContentsURL_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PrintCompositor_SetUserAgent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PrintCompositor_SetGenerateDocumentOutline_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PrintCompositor_SetTitle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PrintCompositor_SetWatermarkBlock_Params_Data::Validate,
     nullptr /* no response */},
};

bool PrintCompositorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::printing::mojom::PrintCompositor::Name_,
    kPrintCompositorValidationInfo);
}

bool PrintCompositorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::printing::mojom::PrintCompositor::Name_,
    kPrintCompositorValidationInfo);
}


}  // printing::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace printing::mojom {


void PrintCompositorInterceptorForTesting::NotifyUnavailableSubframe(uint64_t frame_guid) {
  GetForwardingInterface()->NotifyUnavailableSubframe(
    std::move(frame_guid)
    );
}
void PrintCompositorInterceptorForTesting::AddSubframeContent(uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion serialized_content, const base::flat_map<uint32_t, uint64_t>& subframe_content_info) {
  GetForwardingInterface()->AddSubframeContent(
    std::move(frame_guid)
    , 
    std::move(serialized_content)
    , 
    std::move(subframe_content_info)
    );
}
void PrintCompositorInterceptorForTesting::SetAccessibilityTree(const ::ui::AXTreeUpdate& accessibility_tree) {
  GetForwardingInterface()->SetAccessibilityTree(
    std::move(accessibility_tree)
    );
}
void PrintCompositorInterceptorForTesting::CompositePage(uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion sk_region, const base::flat_map<uint32_t, uint64_t>& subframe_content_info, CompositePageCallback callback) {
  GetForwardingInterface()->CompositePage(
    std::move(frame_guid)
    , 
    std::move(sk_region)
    , 
    std::move(subframe_content_info)
    , std::move(callback));
}
void PrintCompositorInterceptorForTesting::CompositeDocument(uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion sk_region, const base::flat_map<uint32_t, uint64_t>& subframe_content_info, PrintCompositor::DocumentType document_type, CompositeDocumentCallback callback) {
  GetForwardingInterface()->CompositeDocument(
    std::move(frame_guid)
    , 
    std::move(sk_region)
    , 
    std::move(subframe_content_info)
    , 
    std::move(document_type)
    , std::move(callback));
}
void PrintCompositorInterceptorForTesting::PrepareToCompositeDocument(PrintCompositor::DocumentType document_type, PrepareToCompositeDocumentCallback callback) {
  GetForwardingInterface()->PrepareToCompositeDocument(
    std::move(document_type)
    , std::move(callback));
}
void PrintCompositorInterceptorForTesting::FinishDocumentComposition(uint32_t pages_count, FinishDocumentCompositionCallback callback) {
  GetForwardingInterface()->FinishDocumentComposition(
    std::move(pages_count)
    , std::move(callback));
}
void PrintCompositorInterceptorForTesting::SetWebContentsURL(const ::GURL& url) {
  GetForwardingInterface()->SetWebContentsURL(
    std::move(url)
    );
}
void PrintCompositorInterceptorForTesting::SetUserAgent(const std::string& user_agent) {
  GetForwardingInterface()->SetUserAgent(
    std::move(user_agent)
    );
}
void PrintCompositorInterceptorForTesting::SetGenerateDocumentOutline(::printing::mojom::GenerateDocumentOutline generate_document_outline) {
  GetForwardingInterface()->SetGenerateDocumentOutline(
    std::move(generate_document_outline)
    );
}
void PrintCompositorInterceptorForTesting::SetTitle(const std::string& title) {
  GetForwardingInterface()->SetTitle(
    std::move(title)
    );
}
void PrintCompositorInterceptorForTesting::SetWatermarkBlock(::watermark::mojom::WatermarkBlockPtr watermark_block) {
  GetForwardingInterface()->SetWatermarkBlock(
    std::move(watermark_block)
    );
}
PrintCompositorAsyncWaiter::PrintCompositorAsyncWaiter(
    PrintCompositor* proxy) : proxy_(proxy) {}

PrintCompositorAsyncWaiter::~PrintCompositorAsyncWaiter() = default;


void PrintCompositorAsyncWaiter::CompositePage(
    uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion sk_region, const base::flat_map<uint32_t, uint64_t>& subframe_content_info, PrintCompositor::Status* out_status, ::base::ReadOnlySharedMemoryRegion* out_document_region) {
  base::RunLoop loop;
  proxy_->CompositePage(
      std::move(frame_guid),
      std::move(sk_region),
      std::move(subframe_content_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintCompositor::Status* out_status
,
             ::base::ReadOnlySharedMemoryRegion* out_document_region
,
             PrintCompositor::Status status,
             ::base::ReadOnlySharedMemoryRegion document_region) {*out_status = std::move(status);*out_document_region = std::move(document_region);
            loop->Quit();
          },
          &loop,
          out_status,
          out_document_region));
  loop.Run();
}



void PrintCompositorAsyncWaiter::CompositeDocument(
    uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion sk_region, const base::flat_map<uint32_t, uint64_t>& subframe_content_info, PrintCompositor::DocumentType document_type, PrintCompositor::Status* out_status, ::base::ReadOnlySharedMemoryRegion* out_document_region) {
  base::RunLoop loop;
  proxy_->CompositeDocument(
      std::move(frame_guid),
      std::move(sk_region),
      std::move(subframe_content_info),
      std::move(document_type),
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintCompositor::Status* out_status
,
             ::base::ReadOnlySharedMemoryRegion* out_document_region
,
             PrintCompositor::Status status,
             ::base::ReadOnlySharedMemoryRegion document_region) {*out_status = std::move(status);*out_document_region = std::move(document_region);
            loop->Quit();
          },
          &loop,
          out_status,
          out_document_region));
  loop.Run();
}



void PrintCompositorAsyncWaiter::PrepareToCompositeDocument(
    PrintCompositor::DocumentType document_type, PrintCompositor::Status* out_status) {
  base::RunLoop loop;
  proxy_->PrepareToCompositeDocument(
      std::move(document_type),
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintCompositor::Status* out_status
,
             PrintCompositor::Status status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

PrintCompositor::Status PrintCompositorAsyncWaiter::PrepareToCompositeDocument(
    PrintCompositor::DocumentType document_type) {
  PrintCompositor::Status async_wait_result;
  PrepareToCompositeDocument(std::move(document_type),&async_wait_result);
  return async_wait_result;
}

void PrintCompositorAsyncWaiter::FinishDocumentComposition(
    uint32_t pages_count, PrintCompositor::Status* out_status, ::base::ReadOnlySharedMemoryRegion* out_document_region) {
  base::RunLoop loop;
  proxy_->FinishDocumentComposition(
      std::move(pages_count),
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintCompositor::Status* out_status
,
             ::base::ReadOnlySharedMemoryRegion* out_document_region
,
             PrintCompositor::Status status,
             ::base::ReadOnlySharedMemoryRegion document_region) {*out_status = std::move(status);*out_document_region = std::move(document_region);
            loop->Quit();
          },
          &loop,
          out_status,
          out_document_region));
  loop.Run();
}








}  // printing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif