// components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom-params-data.h"
#include "components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom-shared-message-ids.h"

#include "components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom-import-headers.h"
#include "components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom-test-utils.h"


namespace paint_preview::mojom {
PaintPreviewBeginCompositeRequest::PaintPreviewBeginCompositeRequest()
    : preview(mojo::internal::DefaultConstructTag()),
      recording_map() {}

PaintPreviewBeginCompositeRequest::PaintPreviewBeginCompositeRequest(
    ::mojo_base::ProtoWrapper preview_in,
    base::flat_map<::base::UnguessableToken, ::paint_preview::SerializedRecording> recording_map_in)
    : preview(std::move(preview_in)),
      recording_map(std::move(recording_map_in)) {}

PaintPreviewBeginCompositeRequest::~PaintPreviewBeginCompositeRequest() = default;

void PaintPreviewBeginCompositeRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preview"), this->preview,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::ProtoWrapper>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recording_map"), this->recording_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<::base::UnguessableToken, ::paint_preview::SerializedRecording>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaintPreviewBeginCompositeRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SubframeClipRect::SubframeClipRect()
    : frame_guid(),
      clip_rect() {}

SubframeClipRect::SubframeClipRect(
    const ::base::UnguessableToken& frame_guid_in,
    const ::gfx::RectF& clip_rect_in)
    : frame_guid(std::move(frame_guid_in)),
      clip_rect(std::move(clip_rect_in)) {}

SubframeClipRect::~SubframeClipRect() = default;

void SubframeClipRect::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_guid"), this->frame_guid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip_rect"), this->clip_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SubframeClipRect::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FrameData::FrameData()
    : scroll_extents(),
      scroll_offsets(),
      subframes() {}

FrameData::FrameData(
    const ::gfx::Size& scroll_extents_in,
    const ::gfx::Size& scroll_offsets_in,
    std::vector<SubframeClipRectPtr> subframes_in)
    : scroll_extents(std::move(scroll_extents_in)),
      scroll_offsets(std::move(scroll_offsets_in)),
      subframes(std::move(subframes_in)) {}

FrameData::~FrameData() = default;

void FrameData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_extents"), this->scroll_extents,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_offsets"), this->scroll_offsets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subframes"), this->subframes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SubframeClipRectPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaintPreviewBeginCompositeResponse::PaintPreviewBeginCompositeResponse()
    : root_frame_guid(),
      frames() {}

PaintPreviewBeginCompositeResponse::PaintPreviewBeginCompositeResponse(
    const ::base::UnguessableToken& root_frame_guid_in,
    base::flat_map<::base::UnguessableToken, FrameDataPtr> frames_in)
    : root_frame_guid(std::move(root_frame_guid_in)),
      frames(std::move(frames_in)) {}

PaintPreviewBeginCompositeResponse::~PaintPreviewBeginCompositeResponse() = default;

void PaintPreviewBeginCompositeResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_frame_guid"), this->root_frame_guid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames"), this->frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<::base::UnguessableToken, FrameDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaintPreviewBeginCompositeResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PaintPreviewCompositor::IPCStableHashFunction PaintPreviewCompositor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PaintPreviewCompositor>(message.name())) {
    case messages::PaintPreviewCompositor::kBeginSeparatedFrameComposite: {
      return &PaintPreviewCompositor::BeginSeparatedFrameComposite_Sym::IPCStableHash;
    }
    case messages::PaintPreviewCompositor::kBitmapForSeparatedFrame: {
      return &PaintPreviewCompositor::BitmapForSeparatedFrame_Sym::IPCStableHash;
    }
    case messages::PaintPreviewCompositor::kBeginMainFrameComposite: {
      return &PaintPreviewCompositor::BeginMainFrameComposite_Sym::IPCStableHash;
    }
    case messages::PaintPreviewCompositor::kBitmapForMainFrame: {
      return &PaintPreviewCompositor::BitmapForMainFrame_Sym::IPCStableHash;
    }
    case messages::PaintPreviewCompositor::kSetRootFrameUrl: {
      return &PaintPreviewCompositor::SetRootFrameUrl_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PaintPreviewCompositor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PaintPreviewCompositor>(message.name())) {
      case messages::PaintPreviewCompositor::kBeginSeparatedFrameComposite:
            return "Receive paint_preview::mojom::PaintPreviewCompositor::BeginSeparatedFrameComposite";
      case messages::PaintPreviewCompositor::kBitmapForSeparatedFrame:
            return "Receive paint_preview::mojom::PaintPreviewCompositor::BitmapForSeparatedFrame";
      case messages::PaintPreviewCompositor::kBeginMainFrameComposite:
            return "Receive paint_preview::mojom::PaintPreviewCompositor::BeginMainFrameComposite";
      case messages::PaintPreviewCompositor::kBitmapForMainFrame:
            return "Receive paint_preview::mojom::PaintPreviewCompositor::BitmapForMainFrame";
      case messages::PaintPreviewCompositor::kSetRootFrameUrl:
            return "Receive paint_preview::mojom::PaintPreviewCompositor::SetRootFrameUrl";
    }
  } else {
    switch (static_cast<messages::PaintPreviewCompositor>(message.name())) {
      case messages::PaintPreviewCompositor::kBeginSeparatedFrameComposite:
            return "Receive reply paint_preview::mojom::PaintPreviewCompositor::BeginSeparatedFrameComposite";
      case messages::PaintPreviewCompositor::kBitmapForSeparatedFrame:
            return "Receive reply paint_preview::mojom::PaintPreviewCompositor::BitmapForSeparatedFrame";
      case messages::PaintPreviewCompositor::kBeginMainFrameComposite:
            return "Receive reply paint_preview::mojom::PaintPreviewCompositor::BeginMainFrameComposite";
      case messages::PaintPreviewCompositor::kBitmapForMainFrame:
            return "Receive reply paint_preview::mojom::PaintPreviewCompositor::BitmapForMainFrame";
      case messages::PaintPreviewCompositor::kSetRootFrameUrl:
            return "Receive reply paint_preview::mojom::PaintPreviewCompositor::SetRootFrameUrl";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PaintPreviewCompositor::BeginSeparatedFrameComposite_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49d2d038;  // IPCStableHash for paint_preview::mojom::PaintPreviewCompositor::BeginSeparatedFrameComposite
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaintPreviewCompositor::BitmapForSeparatedFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x779e0dc1;  // IPCStableHash for paint_preview::mojom::PaintPreviewCompositor::BitmapForSeparatedFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaintPreviewCompositor::BeginMainFrameComposite_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf6a29933;  // IPCStableHash for paint_preview::mojom::PaintPreviewCompositor::BeginMainFrameComposite
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaintPreviewCompositor::BitmapForMainFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe93336e9;  // IPCStableHash for paint_preview::mojom::PaintPreviewCompositor::BitmapForMainFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaintPreviewCompositor::SetRootFrameUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5fce5997;  // IPCStableHash for paint_preview::mojom::PaintPreviewCompositor::SetRootFrameUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PaintPreviewCompositor_BeginSeparatedFrameComposite_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaintPreviewCompositor_BeginSeparatedFrameComposite_ForwardToCallback(
      PaintPreviewCompositor::BeginSeparatedFrameCompositeCallback callback
      ) : callback_(std::move(callback)) {
  }

  PaintPreviewCompositor_BeginSeparatedFrameComposite_ForwardToCallback(const PaintPreviewCompositor_BeginSeparatedFrameComposite_ForwardToCallback&) = delete;
  PaintPreviewCompositor_BeginSeparatedFrameComposite_ForwardToCallback& operator=(const PaintPreviewCompositor_BeginSeparatedFrameComposite_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PaintPreviewCompositor::BeginSeparatedFrameCompositeCallback callback_;
};

class PaintPreviewCompositor_BitmapForSeparatedFrame_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaintPreviewCompositor_BitmapForSeparatedFrame_ForwardToCallback(
      PaintPreviewCompositor::BitmapForSeparatedFrameCallback callback
      ) : callback_(std::move(callback)) {
  }

  PaintPreviewCompositor_BitmapForSeparatedFrame_ForwardToCallback(const PaintPreviewCompositor_BitmapForSeparatedFrame_ForwardToCallback&) = delete;
  PaintPreviewCompositor_BitmapForSeparatedFrame_ForwardToCallback& operator=(const PaintPreviewCompositor_BitmapForSeparatedFrame_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PaintPreviewCompositor::BitmapForSeparatedFrameCallback callback_;
};

class PaintPreviewCompositor_BeginMainFrameComposite_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaintPreviewCompositor_BeginMainFrameComposite_ForwardToCallback(
      PaintPreviewCompositor::BeginMainFrameCompositeCallback callback
      ) : callback_(std::move(callback)) {
  }

  PaintPreviewCompositor_BeginMainFrameComposite_ForwardToCallback(const PaintPreviewCompositor_BeginMainFrameComposite_ForwardToCallback&) = delete;
  PaintPreviewCompositor_BeginMainFrameComposite_ForwardToCallback& operator=(const PaintPreviewCompositor_BeginMainFrameComposite_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PaintPreviewCompositor::BeginMainFrameCompositeCallback callback_;
};

class PaintPreviewCompositor_BitmapForMainFrame_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaintPreviewCompositor_BitmapForMainFrame_ForwardToCallback(
      PaintPreviewCompositor::BitmapForMainFrameCallback callback
      ) : callback_(std::move(callback)) {
  }

  PaintPreviewCompositor_BitmapForMainFrame_ForwardToCallback(const PaintPreviewCompositor_BitmapForMainFrame_ForwardToCallback&) = delete;
  PaintPreviewCompositor_BitmapForMainFrame_ForwardToCallback& operator=(const PaintPreviewCompositor_BitmapForMainFrame_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PaintPreviewCompositor::BitmapForMainFrameCallback callback_;
};

PaintPreviewCompositorProxy::PaintPreviewCompositorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaintPreviewCompositorProxy::BeginSeparatedFrameComposite(
    PaintPreviewBeginCompositeRequestPtr in_request, BeginSeparatedFrameCompositeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send paint_preview::mojom::PaintPreviewCompositor::BeginSeparatedFrameComposite", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type PaintPreviewBeginCompositeRequestPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositor::kBeginSeparatedFrameComposite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositor_BeginSeparatedFrameComposite_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewBeginCompositeRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in PaintPreviewCompositor.BeginSeparatedFrameComposite request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositor::Name_);
  message.set_method_name("BeginSeparatedFrameComposite");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaintPreviewCompositor_BeginSeparatedFrameComposite_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PaintPreviewCompositorProxy::BitmapForSeparatedFrame(
    const ::base::UnguessableToken& in_frame_guid, const ::gfx::Rect& in_clip_rect, float in_scale_factor, BitmapForSeparatedFrameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send paint_preview::mojom::PaintPreviewCompositor::BitmapForSeparatedFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_guid"), in_frame_guid,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clip_rect"), in_clip_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scale_factor"), in_scale_factor,
                        "<value of type float>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositor::kBitmapForSeparatedFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositor_BitmapForSeparatedFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_guid)::BaseType> frame_guid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_frame_guid,
    frame_guid_fragment);

  params->frame_guid.Set(
      frame_guid_fragment.is_null() ? nullptr : frame_guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_guid in PaintPreviewCompositor.BitmapForSeparatedFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->clip_rect)::BaseType> clip_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_clip_rect,
    clip_rect_fragment);

  params->clip_rect.Set(
      clip_rect_fragment.is_null() ? nullptr : clip_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->clip_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null clip_rect in PaintPreviewCompositor.BitmapForSeparatedFrame request");

  params->scale_factor = in_scale_factor;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositor::Name_);
  message.set_method_name("BitmapForSeparatedFrame");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaintPreviewCompositor_BitmapForSeparatedFrame_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PaintPreviewCompositorProxy::BeginMainFrameComposite(
    PaintPreviewBeginCompositeRequestPtr in_request, BeginMainFrameCompositeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send paint_preview::mojom::PaintPreviewCompositor::BeginMainFrameComposite", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type PaintPreviewBeginCompositeRequestPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositor::kBeginMainFrameComposite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositor_BeginMainFrameComposite_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewBeginCompositeRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in PaintPreviewCompositor.BeginMainFrameComposite request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositor::Name_);
  message.set_method_name("BeginMainFrameComposite");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaintPreviewCompositor_BeginMainFrameComposite_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PaintPreviewCompositorProxy::BitmapForMainFrame(
    const ::gfx::Rect& in_clip_rect, float in_scale_factor, BitmapForMainFrameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send paint_preview::mojom::PaintPreviewCompositor::BitmapForMainFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clip_rect"), in_clip_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scale_factor"), in_scale_factor,
                        "<value of type float>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositor::kBitmapForMainFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositor_BitmapForMainFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->clip_rect)::BaseType> clip_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_clip_rect,
    clip_rect_fragment);

  params->clip_rect.Set(
      clip_rect_fragment.is_null() ? nullptr : clip_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->clip_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null clip_rect in PaintPreviewCompositor.BitmapForMainFrame request");

  params->scale_factor = in_scale_factor;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositor::Name_);
  message.set_method_name("BitmapForMainFrame");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaintPreviewCompositor_BitmapForMainFrame_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PaintPreviewCompositorProxy::SetRootFrameUrl(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send paint_preview::mojom::PaintPreviewCompositor::SetRootFrameUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositor::kSetRootFrameUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositor_SetRootFrameUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PaintPreviewCompositor.SetRootFrameUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositor::Name_);
  message.set_method_name("SetRootFrameUrl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PaintPreviewCompositor_BeginSeparatedFrameComposite_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PaintPreviewCompositor::BeginSeparatedFrameCompositeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PaintPreviewCompositor_BeginSeparatedFrameComposite_ProxyToResponder> proxy(
        new PaintPreviewCompositor_BeginSeparatedFrameComposite_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PaintPreviewCompositor_BeginSeparatedFrameComposite_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaintPreviewCompositor_BeginSeparatedFrameComposite_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PaintPreviewCompositor_BeginSeparatedFrameComposite_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PaintPreviewCompositor::BeginSeparatedFrameCompositeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaintPreviewCompositor::BeginCompositeStatus in_status, PaintPreviewBeginCompositeResponsePtr in_response);
};

bool PaintPreviewCompositor_BeginSeparatedFrameComposite_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PaintPreviewCompositor_BeginSeparatedFrameComposite_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaintPreviewCompositor_BeginSeparatedFrameComposite_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PaintPreviewCompositor.0
  bool success = true;
  PaintPreviewCompositor::BeginCompositeStatus p_status{};
  PaintPreviewBeginCompositeResponsePtr p_response{};
  PaintPreviewCompositor_BeginSeparatedFrameComposite_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaintPreviewCompositor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_response));
  }
  return true;
}

void PaintPreviewCompositor_BeginSeparatedFrameComposite_ProxyToResponder::Run(
    PaintPreviewCompositor::BeginCompositeStatus in_status, PaintPreviewBeginCompositeResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply paint_preview::mojom::PaintPreviewCompositor::BeginSeparatedFrameComposite", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaintPreviewCompositor::BeginCompositeStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type PaintPreviewBeginCompositeResponsePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositor::kBeginSeparatedFrameComposite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositor_BeginSeparatedFrameComposite_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewCompositor_BeginCompositeStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewBeginCompositeResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositor::Name_);
  message.set_method_name("BeginSeparatedFrameComposite");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaintPreviewCompositor_BitmapForSeparatedFrame_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PaintPreviewCompositor::BitmapForSeparatedFrameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PaintPreviewCompositor_BitmapForSeparatedFrame_ProxyToResponder> proxy(
        new PaintPreviewCompositor_BitmapForSeparatedFrame_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PaintPreviewCompositor_BitmapForSeparatedFrame_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaintPreviewCompositor_BitmapForSeparatedFrame_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PaintPreviewCompositor_BitmapForSeparatedFrame_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PaintPreviewCompositor::BitmapForSeparatedFrameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaintPreviewCompositor::BitmapStatus in_status, const ::SkBitmap& in_bitmap);
};

bool PaintPreviewCompositor_BitmapForSeparatedFrame_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PaintPreviewCompositor_BitmapForSeparatedFrame_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaintPreviewCompositor_BitmapForSeparatedFrame_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PaintPreviewCompositor.1
  bool success = true;
  PaintPreviewCompositor::BitmapStatus p_status{};
  ::SkBitmap p_bitmap{};
  PaintPreviewCompositor_BitmapForSeparatedFrame_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadBitmap(&p_bitmap))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaintPreviewCompositor::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_bitmap));
  }
  return true;
}

void PaintPreviewCompositor_BitmapForSeparatedFrame_ProxyToResponder::Run(
    PaintPreviewCompositor::BitmapStatus in_status, const ::SkBitmap& in_bitmap) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply paint_preview::mojom::PaintPreviewCompositor::BitmapForSeparatedFrame", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaintPreviewCompositor::BitmapStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitmap"), in_bitmap,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositor::kBitmapForSeparatedFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositor_BitmapForSeparatedFrame_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewCompositor_BitmapStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->bitmap)::BaseType> bitmap_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
    in_bitmap,
    bitmap_fragment);

  params->bitmap.Set(
      bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositor::Name_);
  message.set_method_name("BitmapForSeparatedFrame");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaintPreviewCompositor_BeginMainFrameComposite_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PaintPreviewCompositor::BeginMainFrameCompositeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PaintPreviewCompositor_BeginMainFrameComposite_ProxyToResponder> proxy(
        new PaintPreviewCompositor_BeginMainFrameComposite_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PaintPreviewCompositor_BeginMainFrameComposite_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaintPreviewCompositor_BeginMainFrameComposite_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PaintPreviewCompositor_BeginMainFrameComposite_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PaintPreviewCompositor::BeginMainFrameCompositeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaintPreviewCompositor::BeginCompositeStatus in_status, PaintPreviewBeginCompositeResponsePtr in_response);
};

bool PaintPreviewCompositor_BeginMainFrameComposite_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PaintPreviewCompositor_BeginMainFrameComposite_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaintPreviewCompositor_BeginMainFrameComposite_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PaintPreviewCompositor.2
  bool success = true;
  PaintPreviewCompositor::BeginCompositeStatus p_status{};
  PaintPreviewBeginCompositeResponsePtr p_response{};
  PaintPreviewCompositor_BeginMainFrameComposite_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaintPreviewCompositor::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_response));
  }
  return true;
}

void PaintPreviewCompositor_BeginMainFrameComposite_ProxyToResponder::Run(
    PaintPreviewCompositor::BeginCompositeStatus in_status, PaintPreviewBeginCompositeResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply paint_preview::mojom::PaintPreviewCompositor::BeginMainFrameComposite", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaintPreviewCompositor::BeginCompositeStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type PaintPreviewBeginCompositeResponsePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositor::kBeginMainFrameComposite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositor_BeginMainFrameComposite_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewCompositor_BeginCompositeStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewBeginCompositeResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositor::Name_);
  message.set_method_name("BeginMainFrameComposite");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaintPreviewCompositor_BitmapForMainFrame_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PaintPreviewCompositor::BitmapForMainFrameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PaintPreviewCompositor_BitmapForMainFrame_ProxyToResponder> proxy(
        new PaintPreviewCompositor_BitmapForMainFrame_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PaintPreviewCompositor_BitmapForMainFrame_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaintPreviewCompositor_BitmapForMainFrame_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PaintPreviewCompositor_BitmapForMainFrame_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PaintPreviewCompositor::BitmapForMainFrameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaintPreviewCompositor::BitmapStatus in_status, const ::SkBitmap& in_bitmap);
};

bool PaintPreviewCompositor_BitmapForMainFrame_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PaintPreviewCompositor_BitmapForMainFrame_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaintPreviewCompositor_BitmapForMainFrame_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PaintPreviewCompositor.3
  bool success = true;
  PaintPreviewCompositor::BitmapStatus p_status{};
  ::SkBitmap p_bitmap{};
  PaintPreviewCompositor_BitmapForMainFrame_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadBitmap(&p_bitmap))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaintPreviewCompositor::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_bitmap));
  }
  return true;
}

void PaintPreviewCompositor_BitmapForMainFrame_ProxyToResponder::Run(
    PaintPreviewCompositor::BitmapStatus in_status, const ::SkBitmap& in_bitmap) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply paint_preview::mojom::PaintPreviewCompositor::BitmapForMainFrame", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaintPreviewCompositor::BitmapStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitmap"), in_bitmap,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositor::kBitmapForMainFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositor_BitmapForMainFrame_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewCompositor_BitmapStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->bitmap)::BaseType> bitmap_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
    in_bitmap,
    bitmap_fragment);

  params->bitmap.Set(
      bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositor::Name_);
  message.set_method_name("BitmapForMainFrame");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PaintPreviewCompositorStubDispatch::Accept(
    PaintPreviewCompositor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PaintPreviewCompositor>(message->header()->name)) {
    case messages::PaintPreviewCompositor::kBeginSeparatedFrameComposite: {
      break;
    }
    case messages::PaintPreviewCompositor::kBitmapForSeparatedFrame: {
      break;
    }
    case messages::PaintPreviewCompositor::kBeginMainFrameComposite: {
      break;
    }
    case messages::PaintPreviewCompositor::kBitmapForMainFrame: {
      break;
    }
    case messages::PaintPreviewCompositor::kSetRootFrameUrl: {
      DCHECK(message->is_serialized());
      internal::PaintPreviewCompositor_SetRootFrameUrl_Params_Data* params =
          reinterpret_cast<internal::PaintPreviewCompositor_SetRootFrameUrl_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PaintPreviewCompositor.4
      bool success = true;
      ::GURL p_url{};
      PaintPreviewCompositor_SetRootFrameUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaintPreviewCompositor::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRootFrameUrl(        
        std::move(p_url));
      return true;
    }
  }
  return false;
}

// static
bool PaintPreviewCompositorStubDispatch::AcceptWithResponder(
    PaintPreviewCompositor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PaintPreviewCompositor>(message->header()->name)) {
    case messages::PaintPreviewCompositor::kBeginSeparatedFrameComposite: {
      internal::PaintPreviewCompositor_BeginSeparatedFrameComposite_Params_Data* params =
          reinterpret_cast<
              internal::PaintPreviewCompositor_BeginSeparatedFrameComposite_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PaintPreviewCompositor.0
      bool success = true;
      PaintPreviewBeginCompositeRequestPtr p_request{};
      PaintPreviewCompositor_BeginSeparatedFrameComposite_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaintPreviewCompositor::Name_, 0, false);
        return false;
      }
      auto callback =
          PaintPreviewCompositor_BeginSeparatedFrameComposite_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginSeparatedFrameComposite(        
        std::move(p_request), std::move(callback));
      return true;
    }
    case messages::PaintPreviewCompositor::kBitmapForSeparatedFrame: {
      internal::PaintPreviewCompositor_BitmapForSeparatedFrame_Params_Data* params =
          reinterpret_cast<
              internal::PaintPreviewCompositor_BitmapForSeparatedFrame_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PaintPreviewCompositor.1
      bool success = true;
      ::base::UnguessableToken p_frame_guid{};
      ::gfx::Rect p_clip_rect{};
      float p_scale_factor{};
      PaintPreviewCompositor_BitmapForSeparatedFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameGuid(&p_frame_guid))
        success = false;
      if (success && !input_data_view.ReadClipRect(&p_clip_rect))
        success = false;
      if (success)
        p_scale_factor = input_data_view.scale_factor();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaintPreviewCompositor::Name_, 1, false);
        return false;
      }
      auto callback =
          PaintPreviewCompositor_BitmapForSeparatedFrame_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BitmapForSeparatedFrame(        
        std::move(p_frame_guid), 
        std::move(p_clip_rect), 
        std::move(p_scale_factor), std::move(callback));
      return true;
    }
    case messages::PaintPreviewCompositor::kBeginMainFrameComposite: {
      internal::PaintPreviewCompositor_BeginMainFrameComposite_Params_Data* params =
          reinterpret_cast<
              internal::PaintPreviewCompositor_BeginMainFrameComposite_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PaintPreviewCompositor.2
      bool success = true;
      PaintPreviewBeginCompositeRequestPtr p_request{};
      PaintPreviewCompositor_BeginMainFrameComposite_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaintPreviewCompositor::Name_, 2, false);
        return false;
      }
      auto callback =
          PaintPreviewCompositor_BeginMainFrameComposite_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginMainFrameComposite(        
        std::move(p_request), std::move(callback));
      return true;
    }
    case messages::PaintPreviewCompositor::kBitmapForMainFrame: {
      internal::PaintPreviewCompositor_BitmapForMainFrame_Params_Data* params =
          reinterpret_cast<
              internal::PaintPreviewCompositor_BitmapForMainFrame_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PaintPreviewCompositor.3
      bool success = true;
      ::gfx::Rect p_clip_rect{};
      float p_scale_factor{};
      PaintPreviewCompositor_BitmapForMainFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClipRect(&p_clip_rect))
        success = false;
      if (success)
        p_scale_factor = input_data_view.scale_factor();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaintPreviewCompositor::Name_, 3, false);
        return false;
      }
      auto callback =
          PaintPreviewCompositor_BitmapForMainFrame_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BitmapForMainFrame(        
        std::move(p_clip_rect), 
        std::move(p_scale_factor), std::move(callback));
      return true;
    }
    case messages::PaintPreviewCompositor::kSetRootFrameUrl: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPaintPreviewCompositorValidationInfo[] = {
    { &internal::PaintPreviewCompositor_BeginSeparatedFrameComposite_Params_Data::Validate,
     &internal::PaintPreviewCompositor_BeginSeparatedFrameComposite_ResponseParams_Data::Validate},
    { &internal::PaintPreviewCompositor_BitmapForSeparatedFrame_Params_Data::Validate,
     &internal::PaintPreviewCompositor_BitmapForSeparatedFrame_ResponseParams_Data::Validate},
    { &internal::PaintPreviewCompositor_BeginMainFrameComposite_Params_Data::Validate,
     &internal::PaintPreviewCompositor_BeginMainFrameComposite_ResponseParams_Data::Validate},
    { &internal::PaintPreviewCompositor_BitmapForMainFrame_Params_Data::Validate,
     &internal::PaintPreviewCompositor_BitmapForMainFrame_ResponseParams_Data::Validate},
    { &internal::PaintPreviewCompositor_SetRootFrameUrl_Params_Data::Validate,
     nullptr /* no response */},
};

bool PaintPreviewCompositorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::paint_preview::mojom::PaintPreviewCompositor::Name_,
    kPaintPreviewCompositorValidationInfo);
}

bool PaintPreviewCompositorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::paint_preview::mojom::PaintPreviewCompositor::Name_,
    kPaintPreviewCompositorValidationInfo);
}
// The declaration includes the definition on other builds.

PaintPreviewCompositorCollection::IPCStableHashFunction PaintPreviewCompositorCollection::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PaintPreviewCompositorCollection>(message.name())) {
    case messages::PaintPreviewCompositorCollection::kSetDiscardableSharedMemoryManager: {
      return &PaintPreviewCompositorCollection::SetDiscardableSharedMemoryManager_Sym::IPCStableHash;
    }
    case messages::PaintPreviewCompositorCollection::kCreateCompositor: {
      return &PaintPreviewCompositorCollection::CreateCompositor_Sym::IPCStableHash;
    }
    case messages::PaintPreviewCompositorCollection::kOnMemoryPressure: {
      return &PaintPreviewCompositorCollection::OnMemoryPressure_Sym::IPCStableHash;
    }
    case messages::PaintPreviewCompositorCollection::kListCompositors: {
      return &PaintPreviewCompositorCollection::ListCompositors_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PaintPreviewCompositorCollection::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PaintPreviewCompositorCollection>(message.name())) {
      case messages::PaintPreviewCompositorCollection::kSetDiscardableSharedMemoryManager:
            return "Receive paint_preview::mojom::PaintPreviewCompositorCollection::SetDiscardableSharedMemoryManager";
      case messages::PaintPreviewCompositorCollection::kCreateCompositor:
            return "Receive paint_preview::mojom::PaintPreviewCompositorCollection::CreateCompositor";
      case messages::PaintPreviewCompositorCollection::kOnMemoryPressure:
            return "Receive paint_preview::mojom::PaintPreviewCompositorCollection::OnMemoryPressure";
      case messages::PaintPreviewCompositorCollection::kListCompositors:
            return "Receive paint_preview::mojom::PaintPreviewCompositorCollection::ListCompositors";
    }
  } else {
    switch (static_cast<messages::PaintPreviewCompositorCollection>(message.name())) {
      case messages::PaintPreviewCompositorCollection::kSetDiscardableSharedMemoryManager:
            return "Receive reply paint_preview::mojom::PaintPreviewCompositorCollection::SetDiscardableSharedMemoryManager";
      case messages::PaintPreviewCompositorCollection::kCreateCompositor:
            return "Receive reply paint_preview::mojom::PaintPreviewCompositorCollection::CreateCompositor";
      case messages::PaintPreviewCompositorCollection::kOnMemoryPressure:
            return "Receive reply paint_preview::mojom::PaintPreviewCompositorCollection::OnMemoryPressure";
      case messages::PaintPreviewCompositorCollection::kListCompositors:
            return "Receive reply paint_preview::mojom::PaintPreviewCompositorCollection::ListCompositors";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PaintPreviewCompositorCollection::SetDiscardableSharedMemoryManager_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd8adf218;  // IPCStableHash for paint_preview::mojom::PaintPreviewCompositorCollection::SetDiscardableSharedMemoryManager
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaintPreviewCompositorCollection::CreateCompositor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd343be03;  // IPCStableHash for paint_preview::mojom::PaintPreviewCompositorCollection::CreateCompositor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaintPreviewCompositorCollection::OnMemoryPressure_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8cfb848e;  // IPCStableHash for paint_preview::mojom::PaintPreviewCompositorCollection::OnMemoryPressure
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaintPreviewCompositorCollection::ListCompositors_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4793e607;  // IPCStableHash for paint_preview::mojom::PaintPreviewCompositorCollection::ListCompositors
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PaintPreviewCompositorCollection_CreateCompositor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaintPreviewCompositorCollection_CreateCompositor_ForwardToCallback(
      PaintPreviewCompositorCollection::CreateCompositorCallback callback
      ) : callback_(std::move(callback)) {
  }

  PaintPreviewCompositorCollection_CreateCompositor_ForwardToCallback(const PaintPreviewCompositorCollection_CreateCompositor_ForwardToCallback&) = delete;
  PaintPreviewCompositorCollection_CreateCompositor_ForwardToCallback& operator=(const PaintPreviewCompositorCollection_CreateCompositor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PaintPreviewCompositorCollection::CreateCompositorCallback callback_;
};

class PaintPreviewCompositorCollection_ListCompositors_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaintPreviewCompositorCollection_ListCompositors_ForwardToCallback(
      PaintPreviewCompositorCollection::ListCompositorsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PaintPreviewCompositorCollection_ListCompositors_ForwardToCallback(const PaintPreviewCompositorCollection_ListCompositors_ForwardToCallback&) = delete;
  PaintPreviewCompositorCollection_ListCompositors_ForwardToCallback& operator=(const PaintPreviewCompositorCollection_ListCompositors_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PaintPreviewCompositorCollection::ListCompositorsCallback callback_;
};

PaintPreviewCompositorCollectionProxy::PaintPreviewCompositorCollectionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaintPreviewCompositorCollectionProxy::SetDiscardableSharedMemoryManager(
    ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> in_manager) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send paint_preview::mojom::PaintPreviewCompositorCollection::SetDiscardableSharedMemoryManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("manager"), in_manager,
                        "<value of type ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositorCollection::kSetDiscardableSharedMemoryManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositorCollection_SetDiscardableSharedMemoryManager_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::discardable_memory::mojom::DiscardableSharedMemoryManagerInterfaceBase>>(
    in_manager,
    &params->manager,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->manager)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid manager in PaintPreviewCompositorCollection.SetDiscardableSharedMemoryManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositorCollection::Name_);
  message.set_method_name("SetDiscardableSharedMemoryManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaintPreviewCompositorCollectionProxy::CreateCompositor(
    ::mojo::PendingReceiver<PaintPreviewCompositor> in_compositor, CreateCompositorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send paint_preview::mojom::PaintPreviewCompositorCollection::CreateCompositor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compositor"), in_compositor,
                        "<value of type ::mojo::PendingReceiver<PaintPreviewCompositor>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositorCollection::kCreateCompositor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositorCollection_CreateCompositor_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::paint_preview::mojom::PaintPreviewCompositorInterfaceBase>>(
    in_compositor,
    &params->compositor,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->compositor)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid compositor in PaintPreviewCompositorCollection.CreateCompositor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositorCollection::Name_);
  message.set_method_name("CreateCompositor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaintPreviewCompositorCollection_CreateCompositor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PaintPreviewCompositorCollectionProxy::OnMemoryPressure(
    ::base::MemoryPressureListener::MemoryPressureLevel in_memory_pressure_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send paint_preview::mojom::PaintPreviewCompositorCollection::OnMemoryPressure", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_pressure_level"), in_memory_pressure_level,
                        "<value of type ::base::MemoryPressureListener::MemoryPressureLevel>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositorCollection::kOnMemoryPressure), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositorCollection_OnMemoryPressure_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::MemoryPressureLevel>(
    in_memory_pressure_level,
    &params->memory_pressure_level);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositorCollection::Name_);
  message.set_method_name("OnMemoryPressure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaintPreviewCompositorCollectionProxy::ListCompositors(
    ListCompositorsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send paint_preview::mojom::PaintPreviewCompositorCollection::ListCompositors");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositorCollection::kListCompositors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositorCollection_ListCompositors_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositorCollection::Name_);
  message.set_method_name("ListCompositors");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaintPreviewCompositorCollection_ListCompositors_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PaintPreviewCompositorCollection_CreateCompositor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PaintPreviewCompositorCollection::CreateCompositorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PaintPreviewCompositorCollection_CreateCompositor_ProxyToResponder> proxy(
        new PaintPreviewCompositorCollection_CreateCompositor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PaintPreviewCompositorCollection_CreateCompositor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaintPreviewCompositorCollection_CreateCompositor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PaintPreviewCompositorCollection_CreateCompositor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PaintPreviewCompositorCollection::CreateCompositorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_compositor_id);
};

bool PaintPreviewCompositorCollection_CreateCompositor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PaintPreviewCompositorCollection_CreateCompositor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaintPreviewCompositorCollection_CreateCompositor_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PaintPreviewCompositorCollection.1
  bool success = true;
  ::base::UnguessableToken p_compositor_id{};
  PaintPreviewCompositorCollection_CreateCompositor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCompositorId(&p_compositor_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaintPreviewCompositorCollection::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_compositor_id));
  }
  return true;
}

void PaintPreviewCompositorCollection_CreateCompositor_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_compositor_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply paint_preview::mojom::PaintPreviewCompositorCollection::CreateCompositor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compositor_id"), in_compositor_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositorCollection::kCreateCompositor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositorCollection_CreateCompositor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->compositor_id)::BaseType> compositor_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_compositor_id,
    compositor_id_fragment);

  params->compositor_id.Set(
      compositor_id_fragment.is_null() ? nullptr : compositor_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->compositor_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null compositor_id in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositorCollection::Name_);
  message.set_method_name("CreateCompositor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaintPreviewCompositorCollection_ListCompositors_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PaintPreviewCompositorCollection::ListCompositorsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PaintPreviewCompositorCollection_ListCompositors_ProxyToResponder> proxy(
        new PaintPreviewCompositorCollection_ListCompositors_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PaintPreviewCompositorCollection_ListCompositors_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaintPreviewCompositorCollection_ListCompositors_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PaintPreviewCompositorCollection_ListCompositors_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PaintPreviewCompositorCollection::ListCompositorsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::base::UnguessableToken>& in_compositor_ids);
};

bool PaintPreviewCompositorCollection_ListCompositors_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PaintPreviewCompositorCollection_ListCompositors_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaintPreviewCompositorCollection_ListCompositors_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PaintPreviewCompositorCollection.3
  bool success = true;
  std::vector<::base::UnguessableToken> p_compositor_ids{};
  PaintPreviewCompositorCollection_ListCompositors_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCompositorIds(&p_compositor_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaintPreviewCompositorCollection::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_compositor_ids));
  }
  return true;
}

void PaintPreviewCompositorCollection_ListCompositors_ProxyToResponder::Run(
    const std::vector<::base::UnguessableToken>& in_compositor_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply paint_preview::mojom::PaintPreviewCompositorCollection::ListCompositors", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compositor_ids"), in_compositor_ids,
                        "<value of type const std::vector<::base::UnguessableToken>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewCompositorCollection::kListCompositors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewCompositorCollection_ListCompositors_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->compositor_ids)::BaseType>
      compositor_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& compositor_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::UnguessableTokenDataView>>(
    in_compositor_ids,
    compositor_ids_fragment,
    &compositor_ids_validate_params);

  params->compositor_ids.Set(
      compositor_ids_fragment.is_null() ? nullptr : compositor_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->compositor_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null compositor_ids in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewCompositorCollection::Name_);
  message.set_method_name("ListCompositors");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PaintPreviewCompositorCollectionStubDispatch::Accept(
    PaintPreviewCompositorCollection* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PaintPreviewCompositorCollection>(message->header()->name)) {
    case messages::PaintPreviewCompositorCollection::kSetDiscardableSharedMemoryManager: {
      DCHECK(message->is_serialized());
      internal::PaintPreviewCompositorCollection_SetDiscardableSharedMemoryManager_Params_Data* params =
          reinterpret_cast<internal::PaintPreviewCompositorCollection_SetDiscardableSharedMemoryManager_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PaintPreviewCompositorCollection.0
      bool success = true;
      ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> p_manager{};
      PaintPreviewCompositorCollection_SetDiscardableSharedMemoryManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_manager =
            input_data_view.TakeManager<decltype(p_manager)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaintPreviewCompositorCollection::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDiscardableSharedMemoryManager(        
        std::move(p_manager));
      return true;
    }
    case messages::PaintPreviewCompositorCollection::kCreateCompositor: {
      break;
    }
    case messages::PaintPreviewCompositorCollection::kOnMemoryPressure: {
      DCHECK(message->is_serialized());
      internal::PaintPreviewCompositorCollection_OnMemoryPressure_Params_Data* params =
          reinterpret_cast<internal::PaintPreviewCompositorCollection_OnMemoryPressure_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PaintPreviewCompositorCollection.2
      bool success = true;
      ::base::MemoryPressureListener::MemoryPressureLevel p_memory_pressure_level{};
      PaintPreviewCompositorCollection_OnMemoryPressure_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMemoryPressureLevel(&p_memory_pressure_level))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaintPreviewCompositorCollection::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMemoryPressure(        
        std::move(p_memory_pressure_level));
      return true;
    }
    case messages::PaintPreviewCompositorCollection::kListCompositors: {
      break;
    }
  }
  return false;
}

// static
bool PaintPreviewCompositorCollectionStubDispatch::AcceptWithResponder(
    PaintPreviewCompositorCollection* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PaintPreviewCompositorCollection>(message->header()->name)) {
    case messages::PaintPreviewCompositorCollection::kSetDiscardableSharedMemoryManager: {
      break;
    }
    case messages::PaintPreviewCompositorCollection::kCreateCompositor: {
      internal::PaintPreviewCompositorCollection_CreateCompositor_Params_Data* params =
          reinterpret_cast<
              internal::PaintPreviewCompositorCollection_CreateCompositor_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PaintPreviewCompositorCollection.1
      bool success = true;
      ::mojo::PendingReceiver<PaintPreviewCompositor> p_compositor{};
      PaintPreviewCompositorCollection_CreateCompositor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_compositor =
            input_data_view.TakeCompositor<decltype(p_compositor)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaintPreviewCompositorCollection::Name_, 1, false);
        return false;
      }
      auto callback =
          PaintPreviewCompositorCollection_CreateCompositor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCompositor(        
        std::move(p_compositor), std::move(callback));
      return true;
    }
    case messages::PaintPreviewCompositorCollection::kOnMemoryPressure: {
      break;
    }
    case messages::PaintPreviewCompositorCollection::kListCompositors: {
      internal::PaintPreviewCompositorCollection_ListCompositors_Params_Data* params =
          reinterpret_cast<
              internal::PaintPreviewCompositorCollection_ListCompositors_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PaintPreviewCompositorCollection.3
      bool success = true;
      PaintPreviewCompositorCollection_ListCompositors_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaintPreviewCompositorCollection::Name_, 3, false);
        return false;
      }
      auto callback =
          PaintPreviewCompositorCollection_ListCompositors_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListCompositors(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPaintPreviewCompositorCollectionValidationInfo[] = {
    { &internal::PaintPreviewCompositorCollection_SetDiscardableSharedMemoryManager_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaintPreviewCompositorCollection_CreateCompositor_Params_Data::Validate,
     &internal::PaintPreviewCompositorCollection_CreateCompositor_ResponseParams_Data::Validate},
    { &internal::PaintPreviewCompositorCollection_OnMemoryPressure_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaintPreviewCompositorCollection_ListCompositors_Params_Data::Validate,
     &internal::PaintPreviewCompositorCollection_ListCompositors_ResponseParams_Data::Validate},
};

bool PaintPreviewCompositorCollectionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::paint_preview::mojom::PaintPreviewCompositorCollection::Name_,
    kPaintPreviewCompositorCollectionValidationInfo);
}

bool PaintPreviewCompositorCollectionResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::paint_preview::mojom::PaintPreviewCompositorCollection::Name_,
    kPaintPreviewCompositorCollectionValidationInfo);
}


}  // paint_preview::mojom


namespace mojo {


// static
bool StructTraits<::paint_preview::mojom::PaintPreviewBeginCompositeRequest::DataView, ::paint_preview::mojom::PaintPreviewBeginCompositeRequestPtr>::Read(
    ::paint_preview::mojom::PaintPreviewBeginCompositeRequest::DataView input,
    ::paint_preview::mojom::PaintPreviewBeginCompositeRequestPtr* output) {
  bool success = true;
  ::paint_preview::mojom::PaintPreviewBeginCompositeRequestPtr result(::paint_preview::mojom::PaintPreviewBeginCompositeRequest::New());
  
      if (success && !input.ReadPreview(&result->preview))
        success = false;
      if (success && !input.ReadRecordingMap(&result->recording_map))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::paint_preview::mojom::SubframeClipRect::DataView, ::paint_preview::mojom::SubframeClipRectPtr>::Read(
    ::paint_preview::mojom::SubframeClipRect::DataView input,
    ::paint_preview::mojom::SubframeClipRectPtr* output) {
  bool success = true;
  ::paint_preview::mojom::SubframeClipRectPtr result(::paint_preview::mojom::SubframeClipRect::New());
  
      if (success && !input.ReadFrameGuid(&result->frame_guid))
        success = false;
      if (success && !input.ReadClipRect(&result->clip_rect))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::paint_preview::mojom::FrameData::DataView, ::paint_preview::mojom::FrameDataPtr>::Read(
    ::paint_preview::mojom::FrameData::DataView input,
    ::paint_preview::mojom::FrameDataPtr* output) {
  bool success = true;
  ::paint_preview::mojom::FrameDataPtr result(::paint_preview::mojom::FrameData::New());
  
      if (success && !input.ReadScrollExtents(&result->scroll_extents))
        success = false;
      if (success && !input.ReadScrollOffsets(&result->scroll_offsets))
        success = false;
      if (success && !input.ReadSubframes(&result->subframes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::paint_preview::mojom::PaintPreviewBeginCompositeResponse::DataView, ::paint_preview::mojom::PaintPreviewBeginCompositeResponsePtr>::Read(
    ::paint_preview::mojom::PaintPreviewBeginCompositeResponse::DataView input,
    ::paint_preview::mojom::PaintPreviewBeginCompositeResponsePtr* output) {
  bool success = true;
  ::paint_preview::mojom::PaintPreviewBeginCompositeResponsePtr result(::paint_preview::mojom::PaintPreviewBeginCompositeResponse::New());
  
      if (success && !input.ReadRootFrameGuid(&result->root_frame_guid))
        success = false;
      if (success && !input.ReadFrames(&result->frames))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace paint_preview::mojom {


void PaintPreviewCompositorInterceptorForTesting::BeginSeparatedFrameComposite(PaintPreviewBeginCompositeRequestPtr request, BeginSeparatedFrameCompositeCallback callback) {
  GetForwardingInterface()->BeginSeparatedFrameComposite(
    std::move(request)
    , std::move(callback));
}
void PaintPreviewCompositorInterceptorForTesting::BitmapForSeparatedFrame(const ::base::UnguessableToken& frame_guid, const ::gfx::Rect& clip_rect, float scale_factor, BitmapForSeparatedFrameCallback callback) {
  GetForwardingInterface()->BitmapForSeparatedFrame(
    std::move(frame_guid)
    , 
    std::move(clip_rect)
    , 
    std::move(scale_factor)
    , std::move(callback));
}
void PaintPreviewCompositorInterceptorForTesting::BeginMainFrameComposite(PaintPreviewBeginCompositeRequestPtr request, BeginMainFrameCompositeCallback callback) {
  GetForwardingInterface()->BeginMainFrameComposite(
    std::move(request)
    , std::move(callback));
}
void PaintPreviewCompositorInterceptorForTesting::BitmapForMainFrame(const ::gfx::Rect& clip_rect, float scale_factor, BitmapForMainFrameCallback callback) {
  GetForwardingInterface()->BitmapForMainFrame(
    std::move(clip_rect)
    , 
    std::move(scale_factor)
    , std::move(callback));
}
void PaintPreviewCompositorInterceptorForTesting::SetRootFrameUrl(const ::GURL& url) {
  GetForwardingInterface()->SetRootFrameUrl(
    std::move(url)
    );
}
PaintPreviewCompositorAsyncWaiter::PaintPreviewCompositorAsyncWaiter(
    PaintPreviewCompositor* proxy) : proxy_(proxy) {}

PaintPreviewCompositorAsyncWaiter::~PaintPreviewCompositorAsyncWaiter() = default;


void PaintPreviewCompositorAsyncWaiter::BeginSeparatedFrameComposite(
    PaintPreviewBeginCompositeRequestPtr request, PaintPreviewCompositor::BeginCompositeStatus* out_status, PaintPreviewBeginCompositeResponsePtr* out_response) {
  base::RunLoop loop;
  proxy_->BeginSeparatedFrameComposite(
      std::move(request),
      base::BindOnce(
          [](base::RunLoop* loop,
             PaintPreviewCompositor::BeginCompositeStatus* out_status
,
             PaintPreviewBeginCompositeResponsePtr* out_response
,
             PaintPreviewCompositor::BeginCompositeStatus status,
             PaintPreviewBeginCompositeResponsePtr response) {*out_status = std::move(status);*out_response = std::move(response);
            loop->Quit();
          },
          &loop,
          out_status,
          out_response));
  loop.Run();
}



void PaintPreviewCompositorAsyncWaiter::BitmapForSeparatedFrame(
    const ::base::UnguessableToken& frame_guid, const ::gfx::Rect& clip_rect, float scale_factor, PaintPreviewCompositor::BitmapStatus* out_status, ::SkBitmap* out_bitmap) {
  base::RunLoop loop;
  proxy_->BitmapForSeparatedFrame(
      std::move(frame_guid),
      std::move(clip_rect),
      std::move(scale_factor),
      base::BindOnce(
          [](base::RunLoop* loop,
             PaintPreviewCompositor::BitmapStatus* out_status
,
             ::SkBitmap* out_bitmap
,
             PaintPreviewCompositor::BitmapStatus status,
             const ::SkBitmap& bitmap) {*out_status = std::move(status);*out_bitmap = std::move(bitmap);
            loop->Quit();
          },
          &loop,
          out_status,
          out_bitmap));
  loop.Run();
}



void PaintPreviewCompositorAsyncWaiter::BeginMainFrameComposite(
    PaintPreviewBeginCompositeRequestPtr request, PaintPreviewCompositor::BeginCompositeStatus* out_status, PaintPreviewBeginCompositeResponsePtr* out_response) {
  base::RunLoop loop;
  proxy_->BeginMainFrameComposite(
      std::move(request),
      base::BindOnce(
          [](base::RunLoop* loop,
             PaintPreviewCompositor::BeginCompositeStatus* out_status
,
             PaintPreviewBeginCompositeResponsePtr* out_response
,
             PaintPreviewCompositor::BeginCompositeStatus status,
             PaintPreviewBeginCompositeResponsePtr response) {*out_status = std::move(status);*out_response = std::move(response);
            loop->Quit();
          },
          &loop,
          out_status,
          out_response));
  loop.Run();
}



void PaintPreviewCompositorAsyncWaiter::BitmapForMainFrame(
    const ::gfx::Rect& clip_rect, float scale_factor, PaintPreviewCompositor::BitmapStatus* out_status, ::SkBitmap* out_bitmap) {
  base::RunLoop loop;
  proxy_->BitmapForMainFrame(
      std::move(clip_rect),
      std::move(scale_factor),
      base::BindOnce(
          [](base::RunLoop* loop,
             PaintPreviewCompositor::BitmapStatus* out_status
,
             ::SkBitmap* out_bitmap
,
             PaintPreviewCompositor::BitmapStatus status,
             const ::SkBitmap& bitmap) {*out_status = std::move(status);*out_bitmap = std::move(bitmap);
            loop->Quit();
          },
          &loop,
          out_status,
          out_bitmap));
  loop.Run();
}






void PaintPreviewCompositorCollectionInterceptorForTesting::SetDiscardableSharedMemoryManager(::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> manager) {
  GetForwardingInterface()->SetDiscardableSharedMemoryManager(
    std::move(manager)
    );
}
void PaintPreviewCompositorCollectionInterceptorForTesting::CreateCompositor(::mojo::PendingReceiver<PaintPreviewCompositor> compositor, CreateCompositorCallback callback) {
  GetForwardingInterface()->CreateCompositor(
    std::move(compositor)
    , std::move(callback));
}
void PaintPreviewCompositorCollectionInterceptorForTesting::OnMemoryPressure(::base::MemoryPressureListener::MemoryPressureLevel memory_pressure_level) {
  GetForwardingInterface()->OnMemoryPressure(
    std::move(memory_pressure_level)
    );
}
void PaintPreviewCompositorCollectionInterceptorForTesting::ListCompositors(ListCompositorsCallback callback) {
  GetForwardingInterface()->ListCompositors(std::move(callback));
}
PaintPreviewCompositorCollectionAsyncWaiter::PaintPreviewCompositorCollectionAsyncWaiter(
    PaintPreviewCompositorCollection* proxy) : proxy_(proxy) {}

PaintPreviewCompositorCollectionAsyncWaiter::~PaintPreviewCompositorCollectionAsyncWaiter() = default;


void PaintPreviewCompositorCollectionAsyncWaiter::CreateCompositor(
    ::mojo::PendingReceiver<PaintPreviewCompositor> compositor, ::base::UnguessableToken* out_compositor_id) {
  base::RunLoop loop;
  proxy_->CreateCompositor(
      std::move(compositor),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::UnguessableToken* out_compositor_id
,
             const ::base::UnguessableToken& compositor_id) {*out_compositor_id = std::move(compositor_id);
            loop->Quit();
          },
          &loop,
          out_compositor_id));
  loop.Run();
}

::base::UnguessableToken PaintPreviewCompositorCollectionAsyncWaiter::CreateCompositor(
    ::mojo::PendingReceiver<PaintPreviewCompositor> compositor) {
  ::base::UnguessableToken async_wait_result;
  CreateCompositor(std::move(compositor),&async_wait_result);
  return async_wait_result;
}

void PaintPreviewCompositorCollectionAsyncWaiter::ListCompositors(
    std::vector<::base::UnguessableToken>* out_compositor_ids) {
  base::RunLoop loop;
  proxy_->ListCompositors(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::base::UnguessableToken>* out_compositor_ids
,
             const std::vector<::base::UnguessableToken>& compositor_ids) {*out_compositor_ids = std::move(compositor_ids);
            loop->Quit();
          },
          &loop,
          out_compositor_ids));
  loop.Run();
}

std::vector<::base::UnguessableToken> PaintPreviewCompositorCollectionAsyncWaiter::ListCompositors(
    ) {
  std::vector<::base::UnguessableToken> async_wait_result;
  ListCompositors(&async_wait_result);
  return async_wait_result;
}






}  // paint_preview::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif