// components/services/on_device_translation/public/mojom/translator.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/on_device_translation/public/mojom/translator.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/on_device_translation/public/mojom/translator.mojom-params-data.h"
#include "components/services/on_device_translation/public/mojom/translator.mojom-shared-message-ids.h"

#include "components/services/on_device_translation/public/mojom/translator.mojom-import-headers.h"
#include "components/services/on_device_translation/public/mojom/translator.mojom-test-utils.h"


namespace on_device_translation::mojom {
// The declaration includes the definition on other builds.

Translator::IPCStableHashFunction Translator::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Translator>(message.name())) {
    case messages::Translator::kTranslate: {
      return &Translator::Translate_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Translator::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Translator>(message.name())) {
      case messages::Translator::kTranslate:
            return "Receive on_device_translation::mojom::Translator::Translate";
    }
  } else {
    switch (static_cast<messages::Translator>(message.name())) {
      case messages::Translator::kTranslate:
            return "Receive reply on_device_translation::mojom::Translator::Translate";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Translator::Translate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff2fe845;  // IPCStableHash for on_device_translation::mojom::Translator::Translate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Translator_Translate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Translator_Translate_ForwardToCallback(
      Translator::TranslateCallback callback
      ) : callback_(std::move(callback)) {
  }

  Translator_Translate_ForwardToCallback(const Translator_Translate_ForwardToCallback&) = delete;
  Translator_Translate_ForwardToCallback& operator=(const Translator_Translate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Translator::TranslateCallback callback_;
};

TranslatorProxy::TranslatorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TranslatorProxy::Translate(
    const std::string& in_input, TranslateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_translation::mojom::Translator::Translate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Translator::kTranslate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_translation::mojom::internal::Translator_Translate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType> input_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input,
    input_fragment);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in Translator.Translate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Translator::Name_);
  message.set_method_name("Translate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Translator_Translate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Translator_Translate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Translator::TranslateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Translator_Translate_ProxyToResponder> proxy(
        new Translator_Translate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Translator_Translate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Translator_Translate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Translator_Translate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Translator::TranslateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_output);
};

bool Translator_Translate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Translator_Translate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Translator_Translate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Translator.0
  bool success = true;
  std::optional<std::string> p_output{};
  Translator_Translate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadOutput(&p_output))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Translator::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_output));
  }
  return true;
}

void Translator_Translate_ProxyToResponder::Run(
    const std::optional<std::string>& in_output) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_translation::mojom::Translator::Translate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output"), in_output,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Translator::kTranslate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_translation::mojom::internal::Translator_Translate_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->output)::BaseType> output_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_output,
    output_fragment);

  params->output.Set(
      output_fragment.is_null() ? nullptr : output_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Translator::Name_);
  message.set_method_name("Translate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TranslatorStubDispatch::Accept(
    Translator* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Translator>(message->header()->name)) {
    case messages::Translator::kTranslate: {
      break;
    }
  }
  return false;
}

// static
bool TranslatorStubDispatch::AcceptWithResponder(
    Translator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Translator>(message->header()->name)) {
    case messages::Translator::kTranslate: {
      internal::Translator_Translate_Params_Data* params =
          reinterpret_cast<
              internal::Translator_Translate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Translator.0
      bool success = true;
      std::string p_input{};
      Translator_Translate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Translator::Name_, 0, false);
        return false;
      }
      auto callback =
          Translator_Translate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Translate(        
        std::move(p_input), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTranslatorValidationInfo[] = {
    { &internal::Translator_Translate_Params_Data::Validate,
     &internal::Translator_Translate_ResponseParams_Data::Validate},
};

bool TranslatorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_translation::mojom::Translator::Name_,
    kTranslatorValidationInfo);
}

bool TranslatorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::on_device_translation::mojom::Translator::Name_,
    kTranslatorValidationInfo);
}


}  // on_device_translation::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace on_device_translation::mojom {


void TranslatorInterceptorForTesting::Translate(const std::string& input, TranslateCallback callback) {
  GetForwardingInterface()->Translate(
    std::move(input)
    , std::move(callback));
}
TranslatorAsyncWaiter::TranslatorAsyncWaiter(
    Translator* proxy) : proxy_(proxy) {}

TranslatorAsyncWaiter::~TranslatorAsyncWaiter() = default;


void TranslatorAsyncWaiter::Translate(
    const std::string& input, std::optional<std::string>* out_output) {
  base::RunLoop loop;
  proxy_->Translate(
      std::move(input),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_output
,
             const std::optional<std::string>& output) {*out_output = std::move(output);
            loop->Quit();
          },
          &loop,
          out_output));
  loop.Run();
}

std::optional<std::string> TranslatorAsyncWaiter::Translate(
    const std::string& input) {
  std::optional<std::string> async_wait_result;
  Translate(std::move(input),&async_wait_result);
  return async_wait_result;
}






}  // on_device_translation::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif