// components/services/heap_profiling/public/mojom/heap_profiling_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_SERVICE_MOJOM_H_
#define COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/heap_profiling/public/mojom/heap_profiling_service.mojom-features.h"  // IWYU pragma: export
#include "components/services/heap_profiling/public/mojom/heap_profiling_service.mojom-shared.h"  // IWYU pragma: export
#include "components/services/heap_profiling/public/mojom/heap_profiling_service.mojom-forward.h"  // IWYU pragma: export
#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-forward.h"
#include "mojo/public/mojom/base/process_id.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace heap_profiling::mojom {

class ProfilingServiceProxy;

template <typename ImplRefTraits>
class ProfilingServiceStub;

class ProfilingServiceRequestValidator;
class ProfilingServiceResponseValidator;


class ProfilingService
    : public ProfilingServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "heap_profiling.mojom.ProfilingService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProfilingServiceInterfaceBase;
  using Proxy_ = ProfilingServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProfilingServiceStub<ImplRefTraits>;

  using RequestValidator_ = ProfilingServiceRequestValidator;
  using ResponseValidator_ = ProfilingServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAddProfilingClientMinVersion = 0,
    kGetProfiledPidsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddProfilingClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetProfiledPids_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProfilingService() = default;

  using AddProfilingClientCallback = base::OnceCallback<void(bool)>;
  using AddProfilingClientMojoCallback = base::OnceCallback<void(bool)>;

  virtual void AddProfilingClient(::base::ProcessId pid, ::mojo::PendingRemote<::heap_profiling::mojom::ProfilingClient> client, ProcessType process_type, ::heap_profiling::mojom::ProfilingParamsPtr params, AddProfilingClientCallback callback) = 0;

  using GetProfiledPidsCallback = base::OnceCallback<void(const std::vector<::base::ProcessId>&)>;
  using GetProfiledPidsMojoCallback = base::OnceCallback<void(const std::vector<::base::ProcessId>&)>;

  virtual void GetProfiledPids(GetProfiledPidsCallback callback) = 0;
};



class  ProfilingServiceProxy
    : public ProfilingService {
 public:
  using InterfaceType = ProfilingService;

  explicit ProfilingServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddProfilingClient(::base::ProcessId pid, ::mojo::PendingRemote<::heap_profiling::mojom::ProfilingClient> client, ProcessType process_type, ::heap_profiling::mojom::ProfilingParamsPtr params, AddProfilingClientCallback callback) final;
  
  void GetProfiledPids(GetProfiledPidsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ProfilingServiceStubDispatch {
 public:
  static bool Accept(ProfilingService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProfilingService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProfilingService>>
class ProfilingServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProfilingServiceStub() = default;
  ~ProfilingServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfilingServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfilingServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProfilingServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProfilingServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // heap_profiling::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_SERVICE_MOJOM_H_