// components/services/heap_profiling/public/mojom/heap_profiling_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/heap_profiling/public/mojom/heap_profiling_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/heap_profiling/public/mojom/heap_profiling_service.mojom-params-data.h"
#include "components/services/heap_profiling/public/mojom/heap_profiling_service.mojom-shared-message-ids.h"

#include "components/services/heap_profiling/public/mojom/heap_profiling_service.mojom-import-headers.h"
#include "components/services/heap_profiling/public/mojom/heap_profiling_service.mojom-test-utils.h"


namespace heap_profiling::mojom {
// The declaration includes the definition on other builds.

ProfilingService::IPCStableHashFunction ProfilingService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProfilingService>(message.name())) {
    case messages::ProfilingService::kAddProfilingClient: {
      return &ProfilingService::AddProfilingClient_Sym::IPCStableHash;
    }
    case messages::ProfilingService::kGetProfiledPids: {
      return &ProfilingService::GetProfiledPids_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProfilingService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProfilingService>(message.name())) {
      case messages::ProfilingService::kAddProfilingClient:
            return "Receive heap_profiling::mojom::ProfilingService::AddProfilingClient";
      case messages::ProfilingService::kGetProfiledPids:
            return "Receive heap_profiling::mojom::ProfilingService::GetProfiledPids";
    }
  } else {
    switch (static_cast<messages::ProfilingService>(message.name())) {
      case messages::ProfilingService::kAddProfilingClient:
            return "Receive reply heap_profiling::mojom::ProfilingService::AddProfilingClient";
      case messages::ProfilingService::kGetProfiledPids:
            return "Receive reply heap_profiling::mojom::ProfilingService::GetProfiledPids";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProfilingService::AddProfilingClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeed1d772;  // IPCStableHash for heap_profiling::mojom::ProfilingService::AddProfilingClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfilingService::GetProfiledPids_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf813f1e6;  // IPCStableHash for heap_profiling::mojom::ProfilingService::GetProfiledPids
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ProfilingService_AddProfilingClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProfilingService_AddProfilingClient_ForwardToCallback(
      ProfilingService::AddProfilingClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProfilingService_AddProfilingClient_ForwardToCallback(const ProfilingService_AddProfilingClient_ForwardToCallback&) = delete;
  ProfilingService_AddProfilingClient_ForwardToCallback& operator=(const ProfilingService_AddProfilingClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProfilingService::AddProfilingClientCallback callback_;
};

class ProfilingService_GetProfiledPids_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProfilingService_GetProfiledPids_ForwardToCallback(
      ProfilingService::GetProfiledPidsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProfilingService_GetProfiledPids_ForwardToCallback(const ProfilingService_GetProfiledPids_ForwardToCallback&) = delete;
  ProfilingService_GetProfiledPids_ForwardToCallback& operator=(const ProfilingService_GetProfiledPids_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProfilingService::GetProfiledPidsCallback callback_;
};

ProfilingServiceProxy::ProfilingServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProfilingServiceProxy::AddProfilingClient(
    ::base::ProcessId in_pid, ::mojo::PendingRemote<::heap_profiling::mojom::ProfilingClient> in_client, ProcessType in_process_type, ::heap_profiling::mojom::ProfilingParamsPtr in_params, AddProfilingClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send heap_profiling::mojom::ProfilingService::AddProfilingClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pid"), in_pid,
                        "<value of type ::base::ProcessId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::heap_profiling::mojom::ProfilingClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_type"), in_process_type,
                        "<value of type ProcessType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::heap_profiling::mojom::ProfilingParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfilingService::kAddProfilingClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::heap_profiling::mojom::internal::ProfilingService_AddProfilingClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pid)::BaseType> pid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
    in_pid,
    pid_fragment);

  params->pid.Set(
      pid_fragment.is_null() ? nullptr : pid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pid in ProfilingService.AddProfilingClient request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::heap_profiling::mojom::ProfilingClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in ProfilingService.AddProfilingClient request");

  
  mojo::internal::Serialize<::heap_profiling::mojom::ProcessType>(
    in_process_type,
    &params->process_type);
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::heap_profiling::mojom::ProfilingParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in ProfilingService.AddProfilingClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfilingService::Name_);
  message.set_method_name("AddProfilingClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProfilingService_AddProfilingClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfilingServiceProxy::GetProfiledPids(
    GetProfiledPidsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send heap_profiling::mojom::ProfilingService::GetProfiledPids");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfilingService::kGetProfiledPids), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::heap_profiling::mojom::internal::ProfilingService_GetProfiledPids_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfilingService::Name_);
  message.set_method_name("GetProfiledPids");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProfilingService_GetProfiledPids_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ProfilingService_AddProfilingClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProfilingService::AddProfilingClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProfilingService_AddProfilingClient_ProxyToResponder> proxy(
        new ProfilingService_AddProfilingClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProfilingService_AddProfilingClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProfilingService_AddProfilingClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProfilingService_AddProfilingClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ProfilingService::AddProfilingClientCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool ProfilingService_AddProfilingClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProfilingService_AddProfilingClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProfilingService_AddProfilingClient_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProfilingService.0
  bool success = true;
  bool p_success{};
  ProfilingService_AddProfilingClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProfilingService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void ProfilingService_AddProfilingClient_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply heap_profiling::mojom::ProfilingService::AddProfilingClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfilingService::kAddProfilingClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::heap_profiling::mojom::internal::ProfilingService_AddProfilingClient_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfilingService::Name_);
  message.set_method_name("AddProfilingClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProfilingService_GetProfiledPids_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProfilingService::GetProfiledPidsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProfilingService_GetProfiledPids_ProxyToResponder> proxy(
        new ProfilingService_GetProfiledPids_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProfilingService_GetProfiledPids_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProfilingService_GetProfiledPids_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProfilingService_GetProfiledPids_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ProfilingService::GetProfiledPidsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::base::ProcessId>& in_pids);
};

bool ProfilingService_GetProfiledPids_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProfilingService_GetProfiledPids_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProfilingService_GetProfiledPids_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProfilingService.1
  bool success = true;
  std::vector<::base::ProcessId> p_pids{};
  ProfilingService_GetProfiledPids_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPids(&p_pids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProfilingService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_pids));
  }
  return true;
}

void ProfilingService_GetProfiledPids_ProxyToResponder::Run(
    const std::vector<::base::ProcessId>& in_pids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply heap_profiling::mojom::ProfilingService::GetProfiledPids", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pids"), in_pids,
                        "<value of type const std::vector<::base::ProcessId>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfilingService::kGetProfiledPids), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::heap_profiling::mojom::internal::ProfilingService_GetProfiledPids_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pids)::BaseType>
      pids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& pids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ProcessIdDataView>>(
    in_pids,
    pids_fragment,
    &pids_validate_params);

  params->pids.Set(
      pids_fragment.is_null() ? nullptr : pids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pids in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfilingService::Name_);
  message.set_method_name("GetProfiledPids");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProfilingServiceStubDispatch::Accept(
    ProfilingService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProfilingService>(message->header()->name)) {
    case messages::ProfilingService::kAddProfilingClient: {
      break;
    }
    case messages::ProfilingService::kGetProfiledPids: {
      break;
    }
  }
  return false;
}

// static
bool ProfilingServiceStubDispatch::AcceptWithResponder(
    ProfilingService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProfilingService>(message->header()->name)) {
    case messages::ProfilingService::kAddProfilingClient: {
      internal::ProfilingService_AddProfilingClient_Params_Data* params =
          reinterpret_cast<
              internal::ProfilingService_AddProfilingClient_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProfilingService.0
      bool success = true;
      ::base::ProcessId p_pid{};
      ::mojo::PendingRemote<::heap_profiling::mojom::ProfilingClient> p_client{};
      ProcessType p_process_type{};
      ::heap_profiling::mojom::ProfilingParamsPtr p_params{};
      ProfilingService_AddProfilingClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPid(&p_pid))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadProcessType(&p_process_type))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfilingService::Name_, 0, false);
        return false;
      }
      auto callback =
          ProfilingService_AddProfilingClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddProfilingClient(        
        std::move(p_pid), 
        std::move(p_client), 
        std::move(p_process_type), 
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::ProfilingService::kGetProfiledPids: {
      internal::ProfilingService_GetProfiledPids_Params_Data* params =
          reinterpret_cast<
              internal::ProfilingService_GetProfiledPids_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProfilingService.1
      bool success = true;
      ProfilingService_GetProfiledPids_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfilingService::Name_, 1, false);
        return false;
      }
      auto callback =
          ProfilingService_GetProfiledPids_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProfiledPids(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProfilingServiceValidationInfo[] = {
    { &internal::ProfilingService_AddProfilingClient_Params_Data::Validate,
     &internal::ProfilingService_AddProfilingClient_ResponseParams_Data::Validate},
    { &internal::ProfilingService_GetProfiledPids_Params_Data::Validate,
     &internal::ProfilingService_GetProfiledPids_ResponseParams_Data::Validate},
};

bool ProfilingServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::heap_profiling::mojom::ProfilingService::Name_,
    kProfilingServiceValidationInfo);
}

bool ProfilingServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::heap_profiling::mojom::ProfilingService::Name_,
    kProfilingServiceValidationInfo);
}


}  // heap_profiling::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace heap_profiling::mojom {


void ProfilingServiceInterceptorForTesting::AddProfilingClient(::base::ProcessId pid, ::mojo::PendingRemote<::heap_profiling::mojom::ProfilingClient> client, ProcessType process_type, ::heap_profiling::mojom::ProfilingParamsPtr params, AddProfilingClientCallback callback) {
  GetForwardingInterface()->AddProfilingClient(
    std::move(pid)
    , 
    std::move(client)
    , 
    std::move(process_type)
    , 
    std::move(params)
    , std::move(callback));
}
void ProfilingServiceInterceptorForTesting::GetProfiledPids(GetProfiledPidsCallback callback) {
  GetForwardingInterface()->GetProfiledPids(std::move(callback));
}
ProfilingServiceAsyncWaiter::ProfilingServiceAsyncWaiter(
    ProfilingService* proxy) : proxy_(proxy) {}

ProfilingServiceAsyncWaiter::~ProfilingServiceAsyncWaiter() = default;


void ProfilingServiceAsyncWaiter::AddProfilingClient(
    ::base::ProcessId pid, ::mojo::PendingRemote<::heap_profiling::mojom::ProfilingClient> client, ProcessType process_type, ::heap_profiling::mojom::ProfilingParamsPtr params, bool* out_success) {
  base::RunLoop loop;
  proxy_->AddProfilingClient(
      std::move(pid),
      std::move(client),
      std::move(process_type),
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool ProfilingServiceAsyncWaiter::AddProfilingClient(
    ::base::ProcessId pid, ::mojo::PendingRemote<::heap_profiling::mojom::ProfilingClient> client, ProcessType process_type, ::heap_profiling::mojom::ProfilingParamsPtr params) {
  bool async_wait_result;
  AddProfilingClient(std::move(pid),std::move(client),std::move(process_type),std::move(params),&async_wait_result);
  return async_wait_result;
}

void ProfilingServiceAsyncWaiter::GetProfiledPids(
    std::vector<::base::ProcessId>* out_pids) {
  base::RunLoop loop;
  proxy_->GetProfiledPids(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::base::ProcessId>* out_pids
,
             const std::vector<::base::ProcessId>& pids) {*out_pids = std::move(pids);
            loop->Quit();
          },
          &loop,
          out_pids));
  loop.Run();
}

std::vector<::base::ProcessId> ProfilingServiceAsyncWaiter::GetProfiledPids(
    ) {
  std::vector<::base::ProcessId> async_wait_result;
  GetProfiledPids(&async_wait_result);
  return async_wait_result;
}






}  // heap_profiling::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif