// components/services/heap_profiling/public/mojom/heap_profiling_client.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_CLIENT_MOJOM_H_
#define COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_CLIENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-features.h"  // IWYU pragma: export
#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-shared.h"  // IWYU pragma: export
#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace heap_profiling::mojom {

class ProfilingClientProxy;

template <typename ImplRefTraits>
class ProfilingClientStub;

class ProfilingClientRequestValidator;
class ProfilingClientResponseValidator;


class ProfilingClient
    : public ProfilingClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "heap_profiling.mojom.ProfilingClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProfilingClientInterfaceBase;
  using Proxy_ = ProfilingClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProfilingClientStub<ImplRefTraits>;

  using RequestValidator_ = ProfilingClientRequestValidator;
  using ResponseValidator_ = ProfilingClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStartProfilingMinVersion = 0,
    kRetrieveHeapProfileMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartProfiling_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RetrieveHeapProfile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProfilingClient() = default;

  using StartProfilingCallback = base::OnceCallback<void()>;
  using StartProfilingMojoCallback = base::OnceCallback<void()>;

  virtual void StartProfiling(ProfilingParamsPtr params, StartProfilingCallback callback) = 0;

  using RetrieveHeapProfileCallback = base::OnceCallback<void(HeapProfilePtr)>;
  using RetrieveHeapProfileMojoCallback = base::OnceCallback<void(HeapProfilePtr)>;

  virtual void RetrieveHeapProfile(RetrieveHeapProfileCallback callback) = 0;
};



class  ProfilingClientProxy
    : public ProfilingClient {
 public:
  using InterfaceType = ProfilingClient;

  explicit ProfilingClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartProfiling(ProfilingParamsPtr params, StartProfilingCallback callback) final;
  
  void RetrieveHeapProfile(RetrieveHeapProfileCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ProfilingClientStubDispatch {
 public:
  static bool Accept(ProfilingClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProfilingClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProfilingClient>>
class ProfilingClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProfilingClientStub() = default;
  ~ProfilingClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfilingClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfilingClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProfilingClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProfilingClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  ProfilingParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProfilingParams, T>::value>;
  using DataView = ProfilingParamsDataView;
  using Data_ = internal::ProfilingParams_Data;

  template <typename... Args>
  static ProfilingParamsPtr New(Args&&... args) {
    return ProfilingParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProfilingParamsPtr From(const U& u) {
    return mojo::TypeConverter<ProfilingParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProfilingParams>::Convert(*this);
  }


  ProfilingParams();

  ProfilingParams(
      StackMode stack_mode,
      uint32_t sampling_rate);


  ~ProfilingParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProfilingParamsPtr>
  ProfilingParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProfilingParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProfilingParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProfilingParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProfilingParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProfilingParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProfilingParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProfilingParams_UnserializedMessageContext<
            UserType, ProfilingParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProfilingParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProfilingParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProfilingParams_UnserializedMessageContext<
            UserType, ProfilingParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProfilingParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  StackMode stack_mode;
  
  uint32_t sampling_rate;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProfilingParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProfilingParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProfilingParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProfilingParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  HeapProfileSample {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HeapProfileSample, T>::value>;
  using DataView = HeapProfileSampleDataView;
  using Data_ = internal::HeapProfileSample_Data;

  template <typename... Args>
  static HeapProfileSamplePtr New(Args&&... args) {
    return HeapProfileSamplePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HeapProfileSamplePtr From(const U& u) {
    return mojo::TypeConverter<HeapProfileSamplePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HeapProfileSample>::Convert(*this);
  }


  HeapProfileSample();

  HeapProfileSample(
      AllocatorType allocator,
      uint64_t size,
      uint64_t total,
      uint64_t context_id,
      std::vector<uint64_t> stack);


  ~HeapProfileSample();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HeapProfileSamplePtr>
  HeapProfileSamplePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HeapProfileSample::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HeapProfileSample::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HeapProfileSample::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HeapProfileSample::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HeapProfileSample::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HeapProfileSample::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HeapProfileSample_UnserializedMessageContext<
            UserType, HeapProfileSample::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HeapProfileSample::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HeapProfileSample::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HeapProfileSample_UnserializedMessageContext<
            UserType, HeapProfileSample::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HeapProfileSample::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AllocatorType allocator;
  
  uint64_t size;
  
  uint64_t total;
  
  uint64_t context_id;
  
  std::vector<uint64_t> stack;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HeapProfileSample::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HeapProfileSample::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HeapProfileSample::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HeapProfileSample::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  HeapProfile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HeapProfile, T>::value>;
  using DataView = HeapProfileDataView;
  using Data_ = internal::HeapProfile_Data;

  template <typename... Args>
  static HeapProfilePtr New(Args&&... args) {
    return HeapProfilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HeapProfilePtr From(const U& u) {
    return mojo::TypeConverter<HeapProfilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HeapProfile>::Convert(*this);
  }


  HeapProfile();

  HeapProfile(
      std::vector<HeapProfileSamplePtr> samples,
      const base::flat_map<uint64_t, std::string>& strings);

HeapProfile(const HeapProfile&) = delete;
HeapProfile& operator=(const HeapProfile&) = delete;

  ~HeapProfile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HeapProfilePtr>
  HeapProfilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HeapProfile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HeapProfile::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HeapProfile::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HeapProfile::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HeapProfile::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HeapProfile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HeapProfile_UnserializedMessageContext<
            UserType, HeapProfile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HeapProfile::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HeapProfile::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HeapProfile_UnserializedMessageContext<
            UserType, HeapProfile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HeapProfile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<HeapProfileSamplePtr> samples;
  
  base::flat_map<uint64_t, std::string> strings;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HeapProfile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HeapProfile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HeapProfile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HeapProfile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ProfilingParamsPtr ProfilingParams::Clone() const {
  return New(
      mojo::Clone(stack_mode),
      mojo::Clone(sampling_rate)
  );
}

template <typename T, ProfilingParams::EnableIfSame<T>*>
bool ProfilingParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stack_mode, other_struct.stack_mode))
    return false;
  if (!mojo::Equals(this->sampling_rate, other_struct.sampling_rate))
    return false;
  return true;
}

template <typename T, ProfilingParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.stack_mode < rhs.stack_mode)
    return true;
  if (rhs.stack_mode < lhs.stack_mode)
    return false;
  if (lhs.sampling_rate < rhs.sampling_rate)
    return true;
  if (rhs.sampling_rate < lhs.sampling_rate)
    return false;
  return false;
}
template <typename StructPtrType>
HeapProfileSamplePtr HeapProfileSample::Clone() const {
  return New(
      mojo::Clone(allocator),
      mojo::Clone(size),
      mojo::Clone(total),
      mojo::Clone(context_id),
      mojo::Clone(stack)
  );
}

template <typename T, HeapProfileSample::EnableIfSame<T>*>
bool HeapProfileSample::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allocator, other_struct.allocator))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->total, other_struct.total))
    return false;
  if (!mojo::Equals(this->context_id, other_struct.context_id))
    return false;
  if (!mojo::Equals(this->stack, other_struct.stack))
    return false;
  return true;
}

template <typename T, HeapProfileSample::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allocator < rhs.allocator)
    return true;
  if (rhs.allocator < lhs.allocator)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.total < rhs.total)
    return true;
  if (rhs.total < lhs.total)
    return false;
  if (lhs.context_id < rhs.context_id)
    return true;
  if (rhs.context_id < lhs.context_id)
    return false;
  if (lhs.stack < rhs.stack)
    return true;
  if (rhs.stack < lhs.stack)
    return false;
  return false;
}
template <typename StructPtrType>
HeapProfilePtr HeapProfile::Clone() const {
  return New(
      mojo::Clone(samples),
      mojo::Clone(strings)
  );
}

template <typename T, HeapProfile::EnableIfSame<T>*>
bool HeapProfile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->samples, other_struct.samples))
    return false;
  if (!mojo::Equals(this->strings, other_struct.strings))
    return false;
  return true;
}

template <typename T, HeapProfile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.samples < rhs.samples)
    return true;
  if (rhs.samples < lhs.samples)
    return false;
  if (lhs.strings < rhs.strings)
    return true;
  if (rhs.strings < lhs.strings)
    return false;
  return false;
}


}  // heap_profiling::mojom

namespace mojo {


template <>
struct  StructTraits<::heap_profiling::mojom::ProfilingParams::DataView,
                                         ::heap_profiling::mojom::ProfilingParamsPtr> {
  static bool IsNull(const ::heap_profiling::mojom::ProfilingParamsPtr& input) { return !input; }
  static void SetToNull(::heap_profiling::mojom::ProfilingParamsPtr* output) { output->reset(); }

  static decltype(::heap_profiling::mojom::ProfilingParams::stack_mode) stack_mode(
      const ::heap_profiling::mojom::ProfilingParamsPtr& input) {
    return input->stack_mode;
  }

  static decltype(::heap_profiling::mojom::ProfilingParams::sampling_rate) sampling_rate(
      const ::heap_profiling::mojom::ProfilingParamsPtr& input) {
    return input->sampling_rate;
  }

  static bool Read(::heap_profiling::mojom::ProfilingParams::DataView input, ::heap_profiling::mojom::ProfilingParamsPtr* output);
};


template <>
struct  StructTraits<::heap_profiling::mojom::HeapProfileSample::DataView,
                                         ::heap_profiling::mojom::HeapProfileSamplePtr> {
  static bool IsNull(const ::heap_profiling::mojom::HeapProfileSamplePtr& input) { return !input; }
  static void SetToNull(::heap_profiling::mojom::HeapProfileSamplePtr* output) { output->reset(); }

  static decltype(::heap_profiling::mojom::HeapProfileSample::allocator) allocator(
      const ::heap_profiling::mojom::HeapProfileSamplePtr& input) {
    return input->allocator;
  }

  static decltype(::heap_profiling::mojom::HeapProfileSample::size) size(
      const ::heap_profiling::mojom::HeapProfileSamplePtr& input) {
    return input->size;
  }

  static decltype(::heap_profiling::mojom::HeapProfileSample::total) total(
      const ::heap_profiling::mojom::HeapProfileSamplePtr& input) {
    return input->total;
  }

  static decltype(::heap_profiling::mojom::HeapProfileSample::context_id) context_id(
      const ::heap_profiling::mojom::HeapProfileSamplePtr& input) {
    return input->context_id;
  }

  static const decltype(::heap_profiling::mojom::HeapProfileSample::stack)& stack(
      const ::heap_profiling::mojom::HeapProfileSamplePtr& input) {
    return input->stack;
  }

  static bool Read(::heap_profiling::mojom::HeapProfileSample::DataView input, ::heap_profiling::mojom::HeapProfileSamplePtr* output);
};


template <>
struct  StructTraits<::heap_profiling::mojom::HeapProfile::DataView,
                                         ::heap_profiling::mojom::HeapProfilePtr> {
  static bool IsNull(const ::heap_profiling::mojom::HeapProfilePtr& input) { return !input; }
  static void SetToNull(::heap_profiling::mojom::HeapProfilePtr* output) { output->reset(); }

  static const decltype(::heap_profiling::mojom::HeapProfile::samples)& samples(
      const ::heap_profiling::mojom::HeapProfilePtr& input) {
    return input->samples;
  }

  static const decltype(::heap_profiling::mojom::HeapProfile::strings)& strings(
      const ::heap_profiling::mojom::HeapProfilePtr& input) {
    return input->strings;
  }

  static bool Read(::heap_profiling::mojom::HeapProfile::DataView input, ::heap_profiling::mojom::HeapProfilePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_CLIENT_MOJOM_H_