// components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-params-data.h"
namespace heap_profiling {
namespace mojom {

NOINLINE static const char* StackModeToStringHelper(StackMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case StackMode::NATIVE_WITH_THREAD_NAMES:
      return "NATIVE_WITH_THREAD_NAMES";
    case StackMode::NATIVE_WITHOUT_THREAD_NAMES:
      return "NATIVE_WITHOUT_THREAD_NAMES";
    default:
      return nullptr;
  }
}

std::string StackModeToString(StackMode value) {
  const char *str = StackModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown StackMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, StackMode value) {
  return os << StackModeToString(value);
}

NOINLINE static const char* AllocatorTypeToStringHelper(AllocatorType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AllocatorType::kMalloc:
      return "kMalloc";
    case AllocatorType::kPartitionAlloc:
      return "kPartitionAlloc";
    default:
      return nullptr;
  }
}

std::string AllocatorTypeToString(AllocatorType value) {
  const char *str = AllocatorTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AllocatorType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AllocatorType value) {
  return os << AllocatorTypeToString(value);
}

namespace internal {


// static
bool ProfilingParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfilingParams_Data* object =
      static_cast<const ProfilingParams_Data*>(data);


  if (!::heap_profiling::mojom::internal::StackMode_Data
        ::Validate(object->stack_mode, validation_context))
    return false;

  return true;
}

ProfilingParams_Data::ProfilingParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HeapProfileSample_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HeapProfileSample_Data* object =
      static_cast<const HeapProfileSample_Data*>(data);


  if (!::heap_profiling::mojom::internal::AllocatorType_Data
        ::Validate(object->allocator, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stack, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& stack_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->stack, validation_context,
                                         &stack_validate_params)) {
    return false;
  }

  return true;
}

HeapProfileSample_Data::HeapProfileSample_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HeapProfile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HeapProfile_Data* object =
      static_cast<const HeapProfile_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->samples, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& samples_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->samples, validation_context,
                                         &samples_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->strings, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& strings_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->strings, validation_context,
                                         &strings_validate_params)) {
    return false;
  }

  return true;
}

HeapProfile_Data::HeapProfile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfilingClient_StartProfiling_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfilingClient_StartProfiling_Params_Data* object =
      static_cast<const ProfilingClient_StartProfiling_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

ProfilingClient_StartProfiling_Params_Data::ProfilingClient_StartProfiling_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfilingClient_StartProfiling_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfilingClient_StartProfiling_ResponseParams_Data* object =
      static_cast<const ProfilingClient_StartProfiling_ResponseParams_Data*>(data);

  return true;
}

ProfilingClient_StartProfiling_ResponseParams_Data::ProfilingClient_StartProfiling_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfilingClient_RetrieveHeapProfile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfilingClient_RetrieveHeapProfile_Params_Data* object =
      static_cast<const ProfilingClient_RetrieveHeapProfile_Params_Data*>(data);

  return true;
}

ProfilingClient_RetrieveHeapProfile_Params_Data::ProfilingClient_RetrieveHeapProfile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfilingClient_RetrieveHeapProfile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfilingClient_RetrieveHeapProfile_ResponseParams_Data* object =
      static_cast<const ProfilingClient_RetrieveHeapProfile_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profile, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->profile, validation_context))
    return false;

  return true;
}

ProfilingClient_RetrieveHeapProfile_ResponseParams_Data::ProfilingClient_RetrieveHeapProfile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace heap_profiling

namespace perfetto {

// static
void TraceFormatTraits<::heap_profiling::mojom::StackMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::heap_profiling::mojom::StackMode value) {
  return std::move(context).WriteString(::heap_profiling::mojom::StackModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::heap_profiling::mojom::AllocatorType>::WriteIntoTrace(
   perfetto::TracedValue context, ::heap_profiling::mojom::AllocatorType value) {
  return std::move(context).WriteString(::heap_profiling::mojom::AllocatorTypeToString(value));
}

} // namespace perfetto