// components/services/font_data/public/mojom/font_data_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/font_data/public/mojom/font_data_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/font_data/public/mojom/font_data_service.mojom-params-data.h"
#include "components/services/font_data/public/mojom/font_data_service.mojom-shared-message-ids.h"

#include "components/services/font_data/public/mojom/font_data_service.mojom-import-headers.h"
#include "components/services/font_data/public/mojom/font_data_service.mojom-test-utils.h"


namespace font_data_service::mojom {
TypefaceStyle::TypefaceStyle()
    : weight(),
      width(),
      slant() {}

TypefaceStyle::TypefaceStyle(
    uint16_t weight_in,
    uint8_t width_in,
    TypefaceSlant slant_in)
    : weight(std::move(weight_in)),
      width(std::move(width_in)),
      slant(std::move(slant_in)) {}

TypefaceStyle::~TypefaceStyle() = default;
size_t TypefaceStyle::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->weight);
  seed = mojo::internal::Hash(seed, this->width);
  seed = mojo::internal::Hash(seed, this->slant);
  return seed;
}

void TypefaceStyle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weight"), this->weight,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "slant"), this->slant,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TypefaceSlant>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TypefaceStyle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Coordinate::Coordinate()
    : axis(),
      value() {}

Coordinate::Coordinate(
    uint32_t axis_in,
    float value_in)
    : axis(std::move(axis_in)),
      value(std::move(value_in)) {}

Coordinate::~Coordinate() = default;
size_t Coordinate::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->axis);
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void Coordinate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis"), this->axis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Coordinate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VariationPosition::VariationPosition()
    : coordinates(),
      coordinateCount() {}

VariationPosition::VariationPosition(
    std::vector<CoordinatePtr> coordinates_in,
    uint16_t coordinateCount_in)
    : coordinates(std::move(coordinates_in)),
      coordinateCount(std::move(coordinateCount_in)) {}

VariationPosition::~VariationPosition() = default;

void VariationPosition::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coordinates"), this->coordinates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<CoordinatePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coordinateCount"), this->coordinateCount,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VariationPosition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MatchFamilyNameResult::MatchFamilyNameResult()
    : typeface_data(),
      ttc_index(),
      variation_position() {}

MatchFamilyNameResult::MatchFamilyNameResult(
    TypefaceDataPtr typeface_data_in,
    int32_t ttc_index_in,
    VariationPositionPtr variation_position_in)
    : typeface_data(std::move(typeface_data_in)),
      ttc_index(std::move(ttc_index_in)),
      variation_position(std::move(variation_position_in)) {}

MatchFamilyNameResult::~MatchFamilyNameResult() = default;

void MatchFamilyNameResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "typeface_data"), this->typeface_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TypefaceDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ttc_index"), this->ttc_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "variation_position"), this->variation_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VariationPositionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MatchFamilyNameResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TypefaceDataPtr
TypefaceData::NewRegion(
    ::base::ReadOnlySharedMemoryRegion value) {
  return TypefaceDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRegion)>,
      std::move(value));
}

TypefaceDataPtr
TypefaceData::NewFontFile(
    ::base::File value) {
  return TypefaceDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFontFile)>,
      std::move(value));
}

TypefaceData::TypefaceData(
    std::in_place_index_t<static_cast<size_t>(Tag::kRegion)>,
    ::base::ReadOnlySharedMemoryRegion value)
    : tag_(Tag::kRegion),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRegion)>,
            std::move(value)) {}

TypefaceData::TypefaceData(
    std::in_place_index_t<static_cast<size_t>(Tag::kFontFile)>,
    ::base::File value)
    : tag_(Tag::kFontFile),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFontFile)>,
            std::move(value)) {}
TypefaceData::~TypefaceData() {
  DestroyActive();
}

void TypefaceData::set_region(::base::ReadOnlySharedMemoryRegion region) {
  if (tag_ == Tag::kRegion) {
    data_.region = std::move(region);
  } else {
    DestroyActive();
    tag_ = Tag::kRegion;
    new (&data_.region) ::base::ReadOnlySharedMemoryRegion(
        std::move(region));
  }
}

void TypefaceData::set_font_file(::base::File font_file) {
  if (tag_ == Tag::kFontFile) {
    data_.font_file = std::move(font_file);
  } else {
    DestroyActive();
    tag_ = Tag::kFontFile;
    new (&data_.font_file) ::base::File(
        std::move(font_file));
  }
}


TypefaceData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRegion)>,
    ::base::ReadOnlySharedMemoryRegion value)
    : region(std::move(value)) {}

TypefaceData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFontFile)>,
    ::base::File value)
    : font_file(std::move(value)) {}

void TypefaceData::DestroyActive() {
  switch (tag_) {

    case Tag::kRegion:
      std::destroy_at(&data_.region);
      break;
    case Tag::kFontFile:
      std::destroy_at(&data_.font_file);
      break;
  }
}

bool TypefaceData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

FontDataService::IPCStableHashFunction FontDataService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FontDataService>(message.name())) {
    case messages::FontDataService::kMatchFamilyName: {
      return &FontDataService::MatchFamilyName_Sym::IPCStableHash;
    }
    case messages::FontDataService::kMatchFamilyNameCharacter: {
      return &FontDataService::MatchFamilyNameCharacter_Sym::IPCStableHash;
    }
    case messages::FontDataService::kGetAllFamilyNames: {
      return &FontDataService::GetAllFamilyNames_Sym::IPCStableHash;
    }
    case messages::FontDataService::kLegacyMakeTypeface: {
      return &FontDataService::LegacyMakeTypeface_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FontDataService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FontDataService>(message.name())) {
      case messages::FontDataService::kMatchFamilyName:
            return "Receive font_data_service::mojom::FontDataService::MatchFamilyName";
      case messages::FontDataService::kMatchFamilyNameCharacter:
            return "Receive font_data_service::mojom::FontDataService::MatchFamilyNameCharacter";
      case messages::FontDataService::kGetAllFamilyNames:
            return "Receive font_data_service::mojom::FontDataService::GetAllFamilyNames";
      case messages::FontDataService::kLegacyMakeTypeface:
            return "Receive font_data_service::mojom::FontDataService::LegacyMakeTypeface";
    }
  } else {
    switch (static_cast<messages::FontDataService>(message.name())) {
      case messages::FontDataService::kMatchFamilyName:
            return "Receive reply font_data_service::mojom::FontDataService::MatchFamilyName";
      case messages::FontDataService::kMatchFamilyNameCharacter:
            return "Receive reply font_data_service::mojom::FontDataService::MatchFamilyNameCharacter";
      case messages::FontDataService::kGetAllFamilyNames:
            return "Receive reply font_data_service::mojom::FontDataService::GetAllFamilyNames";
      case messages::FontDataService::kLegacyMakeTypeface:
            return "Receive reply font_data_service::mojom::FontDataService::LegacyMakeTypeface";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FontDataService::MatchFamilyName_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4710ccd2;  // IPCStableHash for font_data_service::mojom::FontDataService::MatchFamilyName
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FontDataService::MatchFamilyNameCharacter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b9d50f1;  // IPCStableHash for font_data_service::mojom::FontDataService::MatchFamilyNameCharacter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FontDataService::GetAllFamilyNames_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x767a1213;  // IPCStableHash for font_data_service::mojom::FontDataService::GetAllFamilyNames
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FontDataService::LegacyMakeTypeface_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xba043d50;  // IPCStableHash for font_data_service::mojom::FontDataService::LegacyMakeTypeface
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool FontDataService::MatchFamilyName(const std::string& family_name, TypefaceStylePtr style, MatchFamilyNameResultPtr* out_result) {
  NOTREACHED();
}
bool FontDataService::MatchFamilyNameCharacter(const std::string& family_name, TypefaceStylePtr style, const std::vector<std::string>& bcp47s, int32_t character, MatchFamilyNameResultPtr* out_result) {
  NOTREACHED();
}
bool FontDataService::GetAllFamilyNames(std::vector<std::string>* out_result) {
  NOTREACHED();
}
bool FontDataService::LegacyMakeTypeface(const std::optional<std::string>& family_name, TypefaceStylePtr style, MatchFamilyNameResultPtr* out_result) {
  NOTREACHED();
}
class FontDataService_MatchFamilyName_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FontDataService_MatchFamilyName_HandleSyncResponse(
      bool* result, MatchFamilyNameResultPtr* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  FontDataService_MatchFamilyName_HandleSyncResponse(const FontDataService_MatchFamilyName_HandleSyncResponse&) = delete;
  FontDataService_MatchFamilyName_HandleSyncResponse& operator=(const FontDataService_MatchFamilyName_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  MatchFamilyNameResultPtr* out_result_;};

class FontDataService_MatchFamilyName_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FontDataService_MatchFamilyName_ForwardToCallback(
      FontDataService::MatchFamilyNameCallback callback
      ) : callback_(std::move(callback)) {
  }

  FontDataService_MatchFamilyName_ForwardToCallback(const FontDataService_MatchFamilyName_ForwardToCallback&) = delete;
  FontDataService_MatchFamilyName_ForwardToCallback& operator=(const FontDataService_MatchFamilyName_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FontDataService::MatchFamilyNameCallback callback_;
};
class FontDataService_MatchFamilyNameCharacter_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FontDataService_MatchFamilyNameCharacter_HandleSyncResponse(
      bool* result, MatchFamilyNameResultPtr* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  FontDataService_MatchFamilyNameCharacter_HandleSyncResponse(const FontDataService_MatchFamilyNameCharacter_HandleSyncResponse&) = delete;
  FontDataService_MatchFamilyNameCharacter_HandleSyncResponse& operator=(const FontDataService_MatchFamilyNameCharacter_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  MatchFamilyNameResultPtr* out_result_;};

class FontDataService_MatchFamilyNameCharacter_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FontDataService_MatchFamilyNameCharacter_ForwardToCallback(
      FontDataService::MatchFamilyNameCharacterCallback callback
      ) : callback_(std::move(callback)) {
  }

  FontDataService_MatchFamilyNameCharacter_ForwardToCallback(const FontDataService_MatchFamilyNameCharacter_ForwardToCallback&) = delete;
  FontDataService_MatchFamilyNameCharacter_ForwardToCallback& operator=(const FontDataService_MatchFamilyNameCharacter_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FontDataService::MatchFamilyNameCharacterCallback callback_;
};
class FontDataService_GetAllFamilyNames_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FontDataService_GetAllFamilyNames_HandleSyncResponse(
      bool* result, std::vector<std::string>* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  FontDataService_GetAllFamilyNames_HandleSyncResponse(const FontDataService_GetAllFamilyNames_HandleSyncResponse&) = delete;
  FontDataService_GetAllFamilyNames_HandleSyncResponse& operator=(const FontDataService_GetAllFamilyNames_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::vector<std::string>* out_result_;};

class FontDataService_GetAllFamilyNames_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FontDataService_GetAllFamilyNames_ForwardToCallback(
      FontDataService::GetAllFamilyNamesCallback callback
      ) : callback_(std::move(callback)) {
  }

  FontDataService_GetAllFamilyNames_ForwardToCallback(const FontDataService_GetAllFamilyNames_ForwardToCallback&) = delete;
  FontDataService_GetAllFamilyNames_ForwardToCallback& operator=(const FontDataService_GetAllFamilyNames_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FontDataService::GetAllFamilyNamesCallback callback_;
};
class FontDataService_LegacyMakeTypeface_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FontDataService_LegacyMakeTypeface_HandleSyncResponse(
      bool* result, MatchFamilyNameResultPtr* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  FontDataService_LegacyMakeTypeface_HandleSyncResponse(const FontDataService_LegacyMakeTypeface_HandleSyncResponse&) = delete;
  FontDataService_LegacyMakeTypeface_HandleSyncResponse& operator=(const FontDataService_LegacyMakeTypeface_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  MatchFamilyNameResultPtr* out_result_;};

class FontDataService_LegacyMakeTypeface_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FontDataService_LegacyMakeTypeface_ForwardToCallback(
      FontDataService::LegacyMakeTypefaceCallback callback
      ) : callback_(std::move(callback)) {
  }

  FontDataService_LegacyMakeTypeface_ForwardToCallback(const FontDataService_LegacyMakeTypeface_ForwardToCallback&) = delete;
  FontDataService_LegacyMakeTypeface_ForwardToCallback& operator=(const FontDataService_LegacyMakeTypeface_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FontDataService::LegacyMakeTypefaceCallback callback_;
};

FontDataServiceProxy::FontDataServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool FontDataServiceProxy::MatchFamilyName(
    const std::string& param_family_name, TypefaceStylePtr param_style, MatchFamilyNameResultPtr* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call font_data_service::mojom::FontDataService::MatchFamilyName (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("family_name"), param_family_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("style"), param_style,
                        "<value of type TypefaceStylePtr>");
   });
#else
  TRACE_EVENT0("mojom", "FontDataService::MatchFamilyName");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontDataService::kMatchFamilyName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::font_data_service::mojom::internal::FontDataService_MatchFamilyName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->family_name)::BaseType> family_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_family_name,
    family_name_fragment);

  params->family_name.Set(
      family_name_fragment.is_null() ? nullptr : family_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->family_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null family_name in FontDataService.MatchFamilyName request");
  mojo::internal::MessageFragment<
      typename decltype(params->style)::BaseType> style_fragment(
          params.message());
  
  mojo::internal::Serialize<::font_data_service::mojom::TypefaceStyleDataView>(
    param_style,
    style_fragment);

  params->style.Set(
      style_fragment.is_null() ? nullptr : style_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->style.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null style in FontDataService.MatchFamilyName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontDataService::Name_);
  message.set_method_name("MatchFamilyName");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FontDataService_MatchFamilyName_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FontDataService::MatchFamilyName", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type MatchFamilyNameResultPtr>");
   });
#endif
  return result;
}

void FontDataServiceProxy::MatchFamilyName(
    const std::string& in_family_name, TypefaceStylePtr in_style, MatchFamilyNameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send font_data_service::mojom::FontDataService::MatchFamilyName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("family_name"), in_family_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("style"), in_style,
                        "<value of type TypefaceStylePtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontDataService::kMatchFamilyName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::font_data_service::mojom::internal::FontDataService_MatchFamilyName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->family_name)::BaseType> family_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_family_name,
    family_name_fragment);

  params->family_name.Set(
      family_name_fragment.is_null() ? nullptr : family_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->family_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null family_name in FontDataService.MatchFamilyName request");
  mojo::internal::MessageFragment<
      typename decltype(params->style)::BaseType> style_fragment(
          params.message());
  
  mojo::internal::Serialize<::font_data_service::mojom::TypefaceStyleDataView>(
    in_style,
    style_fragment);

  params->style.Set(
      style_fragment.is_null() ? nullptr : style_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->style.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null style in FontDataService.MatchFamilyName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontDataService::Name_);
  message.set_method_name("MatchFamilyName");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FontDataService_MatchFamilyName_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FontDataServiceProxy::MatchFamilyNameCharacter(
    const std::string& param_family_name, TypefaceStylePtr param_style, const std::vector<std::string>& param_bcp47s, int32_t param_character, MatchFamilyNameResultPtr* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call font_data_service::mojom::FontDataService::MatchFamilyNameCharacter (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("family_name"), param_family_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("style"), param_style,
                        "<value of type TypefaceStylePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bcp47s"), param_bcp47s,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("character"), param_character,
                        "<value of type int32_t>");
   });
#else
  TRACE_EVENT0("mojom", "FontDataService::MatchFamilyNameCharacter");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontDataService::kMatchFamilyNameCharacter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::font_data_service::mojom::internal::FontDataService_MatchFamilyNameCharacter_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->family_name)::BaseType> family_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_family_name,
    family_name_fragment);

  params->family_name.Set(
      family_name_fragment.is_null() ? nullptr : family_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->family_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null family_name in FontDataService.MatchFamilyNameCharacter request");
  mojo::internal::MessageFragment<
      typename decltype(params->style)::BaseType> style_fragment(
          params.message());
  
  mojo::internal::Serialize<::font_data_service::mojom::TypefaceStyleDataView>(
    param_style,
    style_fragment);

  params->style.Set(
      style_fragment.is_null() ? nullptr : style_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->style.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null style in FontDataService.MatchFamilyNameCharacter request");
  mojo::internal::MessageFragment<
      typename decltype(params->bcp47s)::BaseType>
      bcp47s_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bcp47s_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    param_bcp47s,
    bcp47s_fragment,
    &bcp47s_validate_params);

  params->bcp47s.Set(
      bcp47s_fragment.is_null() ? nullptr : bcp47s_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bcp47s.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bcp47s in FontDataService.MatchFamilyNameCharacter request");

  params->character = param_character;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontDataService::Name_);
  message.set_method_name("MatchFamilyNameCharacter");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FontDataService_MatchFamilyNameCharacter_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FontDataService::MatchFamilyNameCharacter", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type MatchFamilyNameResultPtr>");
   });
#endif
  return result;
}

void FontDataServiceProxy::MatchFamilyNameCharacter(
    const std::string& in_family_name, TypefaceStylePtr in_style, const std::vector<std::string>& in_bcp47s, int32_t in_character, MatchFamilyNameCharacterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send font_data_service::mojom::FontDataService::MatchFamilyNameCharacter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("family_name"), in_family_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("style"), in_style,
                        "<value of type TypefaceStylePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bcp47s"), in_bcp47s,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("character"), in_character,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontDataService::kMatchFamilyNameCharacter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::font_data_service::mojom::internal::FontDataService_MatchFamilyNameCharacter_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->family_name)::BaseType> family_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_family_name,
    family_name_fragment);

  params->family_name.Set(
      family_name_fragment.is_null() ? nullptr : family_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->family_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null family_name in FontDataService.MatchFamilyNameCharacter request");
  mojo::internal::MessageFragment<
      typename decltype(params->style)::BaseType> style_fragment(
          params.message());
  
  mojo::internal::Serialize<::font_data_service::mojom::TypefaceStyleDataView>(
    in_style,
    style_fragment);

  params->style.Set(
      style_fragment.is_null() ? nullptr : style_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->style.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null style in FontDataService.MatchFamilyNameCharacter request");
  mojo::internal::MessageFragment<
      typename decltype(params->bcp47s)::BaseType>
      bcp47s_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bcp47s_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_bcp47s,
    bcp47s_fragment,
    &bcp47s_validate_params);

  params->bcp47s.Set(
      bcp47s_fragment.is_null() ? nullptr : bcp47s_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bcp47s.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bcp47s in FontDataService.MatchFamilyNameCharacter request");

  params->character = in_character;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontDataService::Name_);
  message.set_method_name("MatchFamilyNameCharacter");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FontDataService_MatchFamilyNameCharacter_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FontDataServiceProxy::GetAllFamilyNames(
    std::vector<std::string>* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call font_data_service::mojom::FontDataService::GetAllFamilyNames (sync)");
#else
  TRACE_EVENT0("mojom", "FontDataService::GetAllFamilyNames");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontDataService::kGetAllFamilyNames), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::font_data_service::mojom::internal::FontDataService_GetAllFamilyNames_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontDataService::Name_);
  message.set_method_name("GetAllFamilyNames");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FontDataService_GetAllFamilyNames_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FontDataService::GetAllFamilyNames", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  return result;
}

void FontDataServiceProxy::GetAllFamilyNames(
    GetAllFamilyNamesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send font_data_service::mojom::FontDataService::GetAllFamilyNames");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontDataService::kGetAllFamilyNames), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::font_data_service::mojom::internal::FontDataService_GetAllFamilyNames_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontDataService::Name_);
  message.set_method_name("GetAllFamilyNames");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FontDataService_GetAllFamilyNames_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FontDataServiceProxy::LegacyMakeTypeface(
    const std::optional<std::string>& param_family_name, TypefaceStylePtr param_style, MatchFamilyNameResultPtr* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call font_data_service::mojom::FontDataService::LegacyMakeTypeface (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("family_name"), param_family_name,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("style"), param_style,
                        "<value of type TypefaceStylePtr>");
   });
#else
  TRACE_EVENT0("mojom", "FontDataService::LegacyMakeTypeface");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontDataService::kLegacyMakeTypeface), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::font_data_service::mojom::internal::FontDataService_LegacyMakeTypeface_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->family_name)::BaseType> family_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_family_name,
    family_name_fragment);

  params->family_name.Set(
      family_name_fragment.is_null() ? nullptr : family_name_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->style)::BaseType> style_fragment(
          params.message());
  
  mojo::internal::Serialize<::font_data_service::mojom::TypefaceStyleDataView>(
    param_style,
    style_fragment);

  params->style.Set(
      style_fragment.is_null() ? nullptr : style_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->style.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null style in FontDataService.LegacyMakeTypeface request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontDataService::Name_);
  message.set_method_name("LegacyMakeTypeface");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FontDataService_LegacyMakeTypeface_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FontDataService::LegacyMakeTypeface", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type MatchFamilyNameResultPtr>");
   });
#endif
  return result;
}

void FontDataServiceProxy::LegacyMakeTypeface(
    const std::optional<std::string>& in_family_name, TypefaceStylePtr in_style, LegacyMakeTypefaceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send font_data_service::mojom::FontDataService::LegacyMakeTypeface", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("family_name"), in_family_name,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("style"), in_style,
                        "<value of type TypefaceStylePtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontDataService::kLegacyMakeTypeface), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::font_data_service::mojom::internal::FontDataService_LegacyMakeTypeface_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->family_name)::BaseType> family_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_family_name,
    family_name_fragment);

  params->family_name.Set(
      family_name_fragment.is_null() ? nullptr : family_name_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->style)::BaseType> style_fragment(
          params.message());
  
  mojo::internal::Serialize<::font_data_service::mojom::TypefaceStyleDataView>(
    in_style,
    style_fragment);

  params->style.Set(
      style_fragment.is_null() ? nullptr : style_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->style.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null style in FontDataService.LegacyMakeTypeface request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontDataService::Name_);
  message.set_method_name("LegacyMakeTypeface");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FontDataService_LegacyMakeTypeface_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FontDataService_MatchFamilyName_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FontDataService::MatchFamilyNameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FontDataService_MatchFamilyName_ProxyToResponder> proxy(
        new FontDataService_MatchFamilyName_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FontDataService_MatchFamilyName_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FontDataService_MatchFamilyName_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FontDataService_MatchFamilyName_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FontDataService::MatchFamilyNameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      MatchFamilyNameResultPtr in_result);
};

bool FontDataService_MatchFamilyName_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FontDataService_MatchFamilyName_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FontDataService_MatchFamilyName_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FontDataService.0
  bool success = true;
  MatchFamilyNameResultPtr p_result{};
  FontDataService_MatchFamilyName_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FontDataService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FontDataService_MatchFamilyName_ProxyToResponder::Run(
    MatchFamilyNameResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply font_data_service::mojom::FontDataService::MatchFamilyName", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type MatchFamilyNameResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontDataService::kMatchFamilyName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::font_data_service::mojom::internal::FontDataService_MatchFamilyName_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::font_data_service::mojom::MatchFamilyNameResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontDataService::Name_);
  message.set_method_name("MatchFamilyName");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FontDataService_MatchFamilyName_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FontDataService_MatchFamilyName_ResponseParams_Data* params =
      reinterpret_cast<internal::FontDataService_MatchFamilyName_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FontDataService.0
  bool success = true;
  MatchFamilyNameResultPtr p_result{};
  FontDataService_MatchFamilyName_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FontDataService::Name_, 0, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class FontDataService_MatchFamilyNameCharacter_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FontDataService::MatchFamilyNameCharacterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FontDataService_MatchFamilyNameCharacter_ProxyToResponder> proxy(
        new FontDataService_MatchFamilyNameCharacter_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FontDataService_MatchFamilyNameCharacter_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FontDataService_MatchFamilyNameCharacter_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FontDataService_MatchFamilyNameCharacter_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FontDataService::MatchFamilyNameCharacterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      MatchFamilyNameResultPtr in_result);
};

bool FontDataService_MatchFamilyNameCharacter_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FontDataService_MatchFamilyNameCharacter_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FontDataService_MatchFamilyNameCharacter_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FontDataService.1
  bool success = true;
  MatchFamilyNameResultPtr p_result{};
  FontDataService_MatchFamilyNameCharacter_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FontDataService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FontDataService_MatchFamilyNameCharacter_ProxyToResponder::Run(
    MatchFamilyNameResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply font_data_service::mojom::FontDataService::MatchFamilyNameCharacter", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type MatchFamilyNameResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontDataService::kMatchFamilyNameCharacter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::font_data_service::mojom::internal::FontDataService_MatchFamilyNameCharacter_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::font_data_service::mojom::MatchFamilyNameResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontDataService::Name_);
  message.set_method_name("MatchFamilyNameCharacter");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FontDataService_MatchFamilyNameCharacter_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FontDataService_MatchFamilyNameCharacter_ResponseParams_Data* params =
      reinterpret_cast<internal::FontDataService_MatchFamilyNameCharacter_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FontDataService.1
  bool success = true;
  MatchFamilyNameResultPtr p_result{};
  FontDataService_MatchFamilyNameCharacter_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FontDataService::Name_, 1, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class FontDataService_GetAllFamilyNames_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FontDataService::GetAllFamilyNamesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FontDataService_GetAllFamilyNames_ProxyToResponder> proxy(
        new FontDataService_GetAllFamilyNames_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FontDataService_GetAllFamilyNames_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FontDataService_GetAllFamilyNames_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FontDataService_GetAllFamilyNames_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FontDataService::GetAllFamilyNamesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_result);
};

bool FontDataService_GetAllFamilyNames_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FontDataService_GetAllFamilyNames_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FontDataService_GetAllFamilyNames_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FontDataService.2
  bool success = true;
  std::vector<std::string> p_result{};
  FontDataService_GetAllFamilyNames_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FontDataService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FontDataService_GetAllFamilyNames_ProxyToResponder::Run(
    const std::vector<std::string>& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply font_data_service::mojom::FontDataService::GetAllFamilyNames", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontDataService::kGetAllFamilyNames), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::font_data_service::mojom::internal::FontDataService_GetAllFamilyNames_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType>
      result_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_result,
    result_fragment,
    &result_validate_params);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontDataService::Name_);
  message.set_method_name("GetAllFamilyNames");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FontDataService_GetAllFamilyNames_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FontDataService_GetAllFamilyNames_ResponseParams_Data* params =
      reinterpret_cast<internal::FontDataService_GetAllFamilyNames_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FontDataService.2
  bool success = true;
  std::vector<std::string> p_result{};
  FontDataService_GetAllFamilyNames_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FontDataService::Name_, 2, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class FontDataService_LegacyMakeTypeface_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FontDataService::LegacyMakeTypefaceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FontDataService_LegacyMakeTypeface_ProxyToResponder> proxy(
        new FontDataService_LegacyMakeTypeface_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FontDataService_LegacyMakeTypeface_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FontDataService_LegacyMakeTypeface_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FontDataService_LegacyMakeTypeface_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FontDataService::LegacyMakeTypefaceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      MatchFamilyNameResultPtr in_result);
};

bool FontDataService_LegacyMakeTypeface_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FontDataService_LegacyMakeTypeface_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FontDataService_LegacyMakeTypeface_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FontDataService.3
  bool success = true;
  MatchFamilyNameResultPtr p_result{};
  FontDataService_LegacyMakeTypeface_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FontDataService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FontDataService_LegacyMakeTypeface_ProxyToResponder::Run(
    MatchFamilyNameResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply font_data_service::mojom::FontDataService::LegacyMakeTypeface", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type MatchFamilyNameResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontDataService::kLegacyMakeTypeface), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::font_data_service::mojom::internal::FontDataService_LegacyMakeTypeface_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::font_data_service::mojom::MatchFamilyNameResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontDataService::Name_);
  message.set_method_name("LegacyMakeTypeface");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FontDataService_LegacyMakeTypeface_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FontDataService_LegacyMakeTypeface_ResponseParams_Data* params =
      reinterpret_cast<internal::FontDataService_LegacyMakeTypeface_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FontDataService.3
  bool success = true;
  MatchFamilyNameResultPtr p_result{};
  FontDataService_LegacyMakeTypeface_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FontDataService::Name_, 3, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}

// static
bool FontDataServiceStubDispatch::Accept(
    FontDataService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FontDataService>(message->header()->name)) {
    case messages::FontDataService::kMatchFamilyName: {
      break;
    }
    case messages::FontDataService::kMatchFamilyNameCharacter: {
      break;
    }
    case messages::FontDataService::kGetAllFamilyNames: {
      break;
    }
    case messages::FontDataService::kLegacyMakeTypeface: {
      break;
    }
  }
  return false;
}

// static
bool FontDataServiceStubDispatch::AcceptWithResponder(
    FontDataService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FontDataService>(message->header()->name)) {
    case messages::FontDataService::kMatchFamilyName: {
      internal::FontDataService_MatchFamilyName_Params_Data* params =
          reinterpret_cast<
              internal::FontDataService_MatchFamilyName_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FontDataService.0
      bool success = true;
      std::string p_family_name{};
      TypefaceStylePtr p_style{};
      FontDataService_MatchFamilyName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFamilyName(&p_family_name))
        success = false;
      if (success && !input_data_view.ReadStyle(&p_style))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FontDataService::Name_, 0, false);
        return false;
      }
      auto callback =
          FontDataService_MatchFamilyName_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MatchFamilyName(        
        std::move(p_family_name), 
        std::move(p_style), std::move(callback));
      return true;
    }
    case messages::FontDataService::kMatchFamilyNameCharacter: {
      internal::FontDataService_MatchFamilyNameCharacter_Params_Data* params =
          reinterpret_cast<
              internal::FontDataService_MatchFamilyNameCharacter_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FontDataService.1
      bool success = true;
      std::string p_family_name{};
      TypefaceStylePtr p_style{};
      std::vector<std::string> p_bcp47s{};
      int32_t p_character{};
      FontDataService_MatchFamilyNameCharacter_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFamilyName(&p_family_name))
        success = false;
      if (success && !input_data_view.ReadStyle(&p_style))
        success = false;
      if (success && !input_data_view.ReadBcp47s(&p_bcp47s))
        success = false;
      if (success)
        p_character = input_data_view.character();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FontDataService::Name_, 1, false);
        return false;
      }
      auto callback =
          FontDataService_MatchFamilyNameCharacter_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MatchFamilyNameCharacter(        
        std::move(p_family_name), 
        std::move(p_style), 
        std::move(p_bcp47s), 
        std::move(p_character), std::move(callback));
      return true;
    }
    case messages::FontDataService::kGetAllFamilyNames: {
      internal::FontDataService_GetAllFamilyNames_Params_Data* params =
          reinterpret_cast<
              internal::FontDataService_GetAllFamilyNames_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FontDataService.2
      bool success = true;
      FontDataService_GetAllFamilyNames_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FontDataService::Name_, 2, false);
        return false;
      }
      auto callback =
          FontDataService_GetAllFamilyNames_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllFamilyNames(std::move(callback));
      return true;
    }
    case messages::FontDataService::kLegacyMakeTypeface: {
      internal::FontDataService_LegacyMakeTypeface_Params_Data* params =
          reinterpret_cast<
              internal::FontDataService_LegacyMakeTypeface_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FontDataService.3
      bool success = true;
      std::optional<std::string> p_family_name{};
      TypefaceStylePtr p_style{};
      FontDataService_LegacyMakeTypeface_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFamilyName(&p_family_name))
        success = false;
      if (success && !input_data_view.ReadStyle(&p_style))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FontDataService::Name_, 3, false);
        return false;
      }
      auto callback =
          FontDataService_LegacyMakeTypeface_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LegacyMakeTypeface(        
        std::move(p_family_name), 
        std::move(p_style), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFontDataServiceValidationInfo[] = {
    { &internal::FontDataService_MatchFamilyName_Params_Data::Validate,
     &internal::FontDataService_MatchFamilyName_ResponseParams_Data::Validate},
    { &internal::FontDataService_MatchFamilyNameCharacter_Params_Data::Validate,
     &internal::FontDataService_MatchFamilyNameCharacter_ResponseParams_Data::Validate},
    { &internal::FontDataService_GetAllFamilyNames_Params_Data::Validate,
     &internal::FontDataService_GetAllFamilyNames_ResponseParams_Data::Validate},
    { &internal::FontDataService_LegacyMakeTypeface_Params_Data::Validate,
     &internal::FontDataService_LegacyMakeTypeface_ResponseParams_Data::Validate},
};

bool FontDataServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::font_data_service::mojom::FontDataService::Name_,
    kFontDataServiceValidationInfo);
}

bool FontDataServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::font_data_service::mojom::FontDataService::Name_,
    kFontDataServiceValidationInfo);
}


}  // font_data_service::mojom


namespace mojo {


// static
bool StructTraits<::font_data_service::mojom::TypefaceStyle::DataView, ::font_data_service::mojom::TypefaceStylePtr>::Read(
    ::font_data_service::mojom::TypefaceStyle::DataView input,
    ::font_data_service::mojom::TypefaceStylePtr* output) {
  bool success = true;
  ::font_data_service::mojom::TypefaceStylePtr result(::font_data_service::mojom::TypefaceStyle::New());
  
      if (success)
        result->weight = input.weight();
      if (success)
        result->width = input.width();
      if (success && !input.ReadSlant(&result->slant))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::font_data_service::mojom::Coordinate::DataView, ::font_data_service::mojom::CoordinatePtr>::Read(
    ::font_data_service::mojom::Coordinate::DataView input,
    ::font_data_service::mojom::CoordinatePtr* output) {
  bool success = true;
  ::font_data_service::mojom::CoordinatePtr result(::font_data_service::mojom::Coordinate::New());
  
      if (success)
        result->axis = input.axis();
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::font_data_service::mojom::VariationPosition::DataView, ::font_data_service::mojom::VariationPositionPtr>::Read(
    ::font_data_service::mojom::VariationPosition::DataView input,
    ::font_data_service::mojom::VariationPositionPtr* output) {
  bool success = true;
  ::font_data_service::mojom::VariationPositionPtr result(::font_data_service::mojom::VariationPosition::New());
  
      if (success && !input.ReadCoordinates(&result->coordinates))
        success = false;
      if (success)
        result->coordinateCount = input.coordinateCount();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::font_data_service::mojom::MatchFamilyNameResult::DataView, ::font_data_service::mojom::MatchFamilyNameResultPtr>::Read(
    ::font_data_service::mojom::MatchFamilyNameResult::DataView input,
    ::font_data_service::mojom::MatchFamilyNameResultPtr* output) {
  bool success = true;
  ::font_data_service::mojom::MatchFamilyNameResultPtr result(::font_data_service::mojom::MatchFamilyNameResult::New());
  
      if (success && !input.ReadTypefaceData(&result->typeface_data))
        success = false;
      if (success)
        result->ttc_index = input.ttc_index();
      if (success && !input.ReadVariationPosition(&result->variation_position))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::font_data_service::mojom::TypefaceData::DataView, ::font_data_service::mojom::TypefaceDataPtr>::Read(
    ::font_data_service::mojom::TypefaceData::DataView input,
    ::font_data_service::mojom::TypefaceDataPtr* output) {
  using UnionType = ::font_data_service::mojom::TypefaceData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kRegion: {
      ::base::ReadOnlySharedMemoryRegion result_region{};
      if (!input.ReadRegion(&result_region))
        return false;

      *output = UnionType::NewRegion(
          std::move(result_region));
      break;
    }
    case Tag::kFontFile: {
      ::base::File result_font_file{};
      if (!input.ReadFontFile(&result_font_file))
        return false;

      *output = UnionType::NewFontFile(
          std::move(result_font_file));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace font_data_service::mojom {


void FontDataServiceInterceptorForTesting::MatchFamilyName(const std::string& family_name, TypefaceStylePtr style, MatchFamilyNameCallback callback) {
  GetForwardingInterface()->MatchFamilyName(
    std::move(family_name)
    , 
    std::move(style)
    , std::move(callback));
}
void FontDataServiceInterceptorForTesting::MatchFamilyNameCharacter(const std::string& family_name, TypefaceStylePtr style, const std::vector<std::string>& bcp47s, int32_t character, MatchFamilyNameCharacterCallback callback) {
  GetForwardingInterface()->MatchFamilyNameCharacter(
    std::move(family_name)
    , 
    std::move(style)
    , 
    std::move(bcp47s)
    , 
    std::move(character)
    , std::move(callback));
}
void FontDataServiceInterceptorForTesting::GetAllFamilyNames(GetAllFamilyNamesCallback callback) {
  GetForwardingInterface()->GetAllFamilyNames(std::move(callback));
}
void FontDataServiceInterceptorForTesting::LegacyMakeTypeface(const std::optional<std::string>& family_name, TypefaceStylePtr style, LegacyMakeTypefaceCallback callback) {
  GetForwardingInterface()->LegacyMakeTypeface(
    std::move(family_name)
    , 
    std::move(style)
    , std::move(callback));
}
FontDataServiceAsyncWaiter::FontDataServiceAsyncWaiter(
    FontDataService* proxy) : proxy_(proxy) {}

FontDataServiceAsyncWaiter::~FontDataServiceAsyncWaiter() = default;


void FontDataServiceAsyncWaiter::MatchFamilyName(
    const std::string& family_name, TypefaceStylePtr style, MatchFamilyNameResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->MatchFamilyName(
      std::move(family_name),
      std::move(style),
      base::BindOnce(
          [](base::RunLoop* loop,
             MatchFamilyNameResultPtr* out_result
,
             MatchFamilyNameResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

MatchFamilyNameResultPtr FontDataServiceAsyncWaiter::MatchFamilyName(
    const std::string& family_name, TypefaceStylePtr style) {
  MatchFamilyNameResultPtr async_wait_result;
  MatchFamilyName(std::move(family_name),std::move(style),&async_wait_result);
  return async_wait_result;
}

void FontDataServiceAsyncWaiter::MatchFamilyNameCharacter(
    const std::string& family_name, TypefaceStylePtr style, const std::vector<std::string>& bcp47s, int32_t character, MatchFamilyNameResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->MatchFamilyNameCharacter(
      std::move(family_name),
      std::move(style),
      std::move(bcp47s),
      std::move(character),
      base::BindOnce(
          [](base::RunLoop* loop,
             MatchFamilyNameResultPtr* out_result
,
             MatchFamilyNameResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

MatchFamilyNameResultPtr FontDataServiceAsyncWaiter::MatchFamilyNameCharacter(
    const std::string& family_name, TypefaceStylePtr style, const std::vector<std::string>& bcp47s, int32_t character) {
  MatchFamilyNameResultPtr async_wait_result;
  MatchFamilyNameCharacter(std::move(family_name),std::move(style),std::move(bcp47s),std::move(character),&async_wait_result);
  return async_wait_result;
}

void FontDataServiceAsyncWaiter::GetAllFamilyNames(
    std::vector<std::string>* out_result) {
  base::RunLoop loop;
  proxy_->GetAllFamilyNames(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_result
,
             const std::vector<std::string>& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

std::vector<std::string> FontDataServiceAsyncWaiter::GetAllFamilyNames(
    ) {
  std::vector<std::string> async_wait_result;
  GetAllFamilyNames(&async_wait_result);
  return async_wait_result;
}

void FontDataServiceAsyncWaiter::LegacyMakeTypeface(
    const std::optional<std::string>& family_name, TypefaceStylePtr style, MatchFamilyNameResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->LegacyMakeTypeface(
      std::move(family_name),
      std::move(style),
      base::BindOnce(
          [](base::RunLoop* loop,
             MatchFamilyNameResultPtr* out_result
,
             MatchFamilyNameResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

MatchFamilyNameResultPtr FontDataServiceAsyncWaiter::LegacyMakeTypeface(
    const std::optional<std::string>& family_name, TypefaceStylePtr style) {
  MatchFamilyNameResultPtr async_wait_result;
  LegacyMakeTypeface(std::move(family_name),std::move(style),&async_wait_result);
  return async_wait_result;
}






}  // font_data_service::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif