// components/services/font_data/public/mojom/font_data_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FONT_DATA_PUBLIC_MOJOM_FONT_DATA_SERVICE_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_FONT_DATA_PUBLIC_MOJOM_FONT_DATA_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/font_data/public/mojom/font_data_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/services/font_data/public/mojom/font_data_service.mojom-data-view.h"




namespace std {

template <>
struct hash<::font_data_service::mojom::TypefaceSlant>
    : public mojo::internal::EnumHashImpl<::font_data_service::mojom::TypefaceSlant> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::font_data_service::mojom::TypefaceSlant, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::font_data_service::mojom::TypefaceSlant, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::font_data_service::mojom::TypefaceSlant>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::font_data_service::mojom::TypefaceStyleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::font_data_service::mojom::TypefaceStyleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::font_data_service::mojom::internal::TypefaceStyle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->weight = Traits::weight(input);

    fragment->width = Traits::width(input);

    
    mojo::internal::Serialize<::font_data_service::mojom::TypefaceSlant>(
      Traits::slant(input),
      &fragment->slant);
  }

  static bool Deserialize(::font_data_service::mojom::internal::TypefaceStyle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::font_data_service::mojom::TypefaceStyleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::font_data_service::mojom::CoordinateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::font_data_service::mojom::CoordinateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::font_data_service::mojom::internal::Coordinate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->axis = Traits::axis(input);

    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::font_data_service::mojom::internal::Coordinate_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::font_data_service::mojom::CoordinateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::font_data_service::mojom::VariationPositionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::font_data_service::mojom::VariationPositionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::font_data_service::mojom::internal::VariationPosition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::coordinates(input)) in_coordinates = Traits::coordinates(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coordinates)::BaseType>
        coordinates_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& coordinates_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::font_data_service::mojom::CoordinateDataView>>(
      in_coordinates,
      coordinates_fragment,
      &coordinates_validate_params);

    fragment->coordinates.Set(
        coordinates_fragment.is_null() ? nullptr : coordinates_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->coordinates.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null coordinates in VariationPosition struct");

    fragment->coordinateCount = Traits::coordinateCount(input);
  }

  static bool Deserialize(::font_data_service::mojom::internal::VariationPosition_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::font_data_service::mojom::VariationPositionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::font_data_service::mojom::MatchFamilyNameResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::font_data_service::mojom::MatchFamilyNameResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::font_data_service::mojom::internal::MatchFamilyNameResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::typeface_data(input)) in_typeface_data = Traits::typeface_data(input);
    mojo::internal::MessageFragment<decltype(fragment->typeface_data)>
        typeface_data_fragment(fragment.message());
    typeface_data_fragment.Claim(&fragment->typeface_data);
    
    mojo::internal::Serialize<::font_data_service::mojom::TypefaceDataDataView>(
      in_typeface_data,
      typeface_data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->typeface_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null typeface_data in MatchFamilyNameResult struct");

    fragment->ttc_index = Traits::ttc_index(input);

    decltype(Traits::variation_position(input)) in_variation_position = Traits::variation_position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->variation_position)::BaseType> variation_position_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::font_data_service::mojom::VariationPositionDataView>(
      in_variation_position,
      variation_position_fragment);

    fragment->variation_position.Set(
        variation_position_fragment.is_null() ? nullptr : variation_position_fragment.data());
  }

  static bool Deserialize(::font_data_service::mojom::internal::MatchFamilyNameResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::font_data_service::mojom::MatchFamilyNameResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::font_data_service::mojom::TypefaceDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::font_data_service::mojom::TypefaceDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::font_data_service::mojom::internal::TypefaceData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::font_data_service::mojom::TypefaceDataDataView::Tag::kRegion: {
    decltype(Traits::region(input))
    in_region = Traits::region(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_region)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
  in_region,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null region in TypefaceData union");
    fragment->data.f_region.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::font_data_service::mojom::TypefaceDataDataView::Tag::kFontFile: {
    decltype(Traits::font_file(input))
    in_font_file = Traits::font_file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_font_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
  in_font_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null font_file in TypefaceData union");
    fragment->data.f_font_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::font_data_service::mojom::internal::TypefaceData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::font_data_service::mojom::TypefaceDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace font_data_service::mojom {





inline void VariationPositionDataView::GetCoordinatesDataView(
    mojo::ArrayDataView<CoordinateDataView>* output) {
  auto pointer = data_->coordinates.Get();
  *output = mojo::ArrayDataView<CoordinateDataView>(pointer, message_);
}


inline void MatchFamilyNameResultDataView::GetTypefaceDataDataView(
    TypefaceDataDataView* output) {
  auto pointer = &data_->typeface_data;
  *output = TypefaceDataDataView(pointer, message_);
}
inline void MatchFamilyNameResultDataView::GetVariationPositionDataView(
    VariationPositionDataView* output) {
  auto pointer = data_->variation_position.Get();
  *output = VariationPositionDataView(pointer, message_);
}


inline void TypefaceDataDataView::GetRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) const {
  CHECK(is_region());
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(data_->data.f_region.Get(), message_);
}
inline void TypefaceDataDataView::GetFontFileDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) const {
  CHECK(is_font_file());
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(data_->data.f_font_file.Get(), message_);
}


}  // font_data_service::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::font_data_service::mojom::TypefaceSlant> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::font_data_service::mojom::TypefaceSlant value);
};

} // namespace perfetto

#endif  // COMPONENTS_SERVICES_FONT_DATA_PUBLIC_MOJOM_FONT_DATA_SERVICE_MOJOM_SHARED_H_