// components/schema_org/common/improved_metadata.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SCHEMA_ORG_COMMON_IMPROVED_METADATA_MOJOM_H_
#define COMPONENTS_SCHEMA_ORG_COMMON_IMPROVED_METADATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/schema_org/common/improved_metadata.mojom-features.h"  // IWYU pragma: export
#include "components/schema_org/common/improved_metadata.mojom-shared.h"  // IWYU pragma: export
#include "components/schema_org/common/improved_metadata.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>








namespace schema_org::improved::mojom {










class  Values {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Values, T>::value>;
  using DataView = ValuesDataView;
  using Data_ = internal::Values_Data;

  template <typename... Args>
  static ValuesPtr New(Args&&... args) {
    return ValuesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ValuesPtr From(const U& u) {
    return mojo::TypeConverter<ValuesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Values>::Convert(*this);
  }


  Values();

  Values(
      std::vector<bool> bool_values,
      std::vector<int64_t> long_values,
      std::vector<std::string> string_values,
      std::vector<double> double_values,
      std::vector<::base::Time> date_time_values,
      std::vector<::base::TimeDelta> time_values,
      std::vector<::GURL> url_values,
      std::vector<EntityPtr> entity_values);

Values(const Values&) = delete;
Values& operator=(const Values&) = delete;

  ~Values();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ValuesPtr>
  ValuesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Values::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Values::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Values::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Values::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Values::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Values::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Values_UnserializedMessageContext<
            UserType, Values::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Values::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Values::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Values_UnserializedMessageContext<
            UserType, Values::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Values::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<bool> bool_values;
  
  std::vector<int64_t> long_values;
  
  std::vector<std::string> string_values;
  
  std::vector<double> double_values;
  
  std::vector<::base::Time> date_time_values;
  
  std::vector<::base::TimeDelta> time_values;
  
  std::vector<::GURL> url_values;
  
  std::vector<EntityPtr> entity_values;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Values::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Values::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Values::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Values::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Property {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Property, T>::value>;
  using DataView = PropertyDataView;
  using Data_ = internal::Property_Data;

  template <typename... Args>
  static PropertyPtr New(Args&&... args) {
    return PropertyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PropertyPtr From(const U& u) {
    return mojo::TypeConverter<PropertyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Property>::Convert(*this);
  }


  Property();

  Property(
      const std::string& name,
      ValuesPtr values);

Property(const Property&) = delete;
Property& operator=(const Property&) = delete;

  ~Property();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PropertyPtr>
  PropertyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Property::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Property::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Property::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Property::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Property::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Property::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Property_UnserializedMessageContext<
            UserType, Property::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Property::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Property::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Property_UnserializedMessageContext<
            UserType, Property::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Property::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  ValuesPtr values;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Property::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Property::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Property::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Property::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Entity {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Entity, T>::value>;
  using DataView = EntityDataView;
  using Data_ = internal::Entity_Data;

  template <typename... Args>
  static EntityPtr New(Args&&... args) {
    return EntityPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EntityPtr From(const U& u) {
    return mojo::TypeConverter<EntityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Entity>::Convert(*this);
  }


  Entity();

  Entity(
      const std::string& type,
      const std::string& id,
      std::vector<PropertyPtr> properties);

Entity(const Entity&) = delete;
Entity& operator=(const Entity&) = delete;

  ~Entity();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EntityPtr>
  EntityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Entity::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Entity::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Entity::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Entity::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Entity::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Entity::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Entity_UnserializedMessageContext<
            UserType, Entity::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Entity::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Entity::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Entity_UnserializedMessageContext<
            UserType, Entity::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Entity::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string type;
  
  std::string id;
  
  std::vector<PropertyPtr> properties;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Entity::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Entity::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Entity::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Entity::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ValuesPtr Values::Clone() const {
  return New(
      mojo::Clone(bool_values),
      mojo::Clone(long_values),
      mojo::Clone(string_values),
      mojo::Clone(double_values),
      mojo::Clone(date_time_values),
      mojo::Clone(time_values),
      mojo::Clone(url_values),
      mojo::Clone(entity_values)
  );
}

template <typename T, Values::EnableIfSame<T>*>
bool Values::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bool_values, other_struct.bool_values))
    return false;
  if (!mojo::Equals(this->long_values, other_struct.long_values))
    return false;
  if (!mojo::Equals(this->string_values, other_struct.string_values))
    return false;
  if (!mojo::Equals(this->double_values, other_struct.double_values))
    return false;
  if (!mojo::Equals(this->date_time_values, other_struct.date_time_values))
    return false;
  if (!mojo::Equals(this->time_values, other_struct.time_values))
    return false;
  if (!mojo::Equals(this->url_values, other_struct.url_values))
    return false;
  if (!mojo::Equals(this->entity_values, other_struct.entity_values))
    return false;
  return true;
}

template <typename T, Values::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bool_values < rhs.bool_values)
    return true;
  if (rhs.bool_values < lhs.bool_values)
    return false;
  if (lhs.long_values < rhs.long_values)
    return true;
  if (rhs.long_values < lhs.long_values)
    return false;
  if (lhs.string_values < rhs.string_values)
    return true;
  if (rhs.string_values < lhs.string_values)
    return false;
  if (lhs.double_values < rhs.double_values)
    return true;
  if (rhs.double_values < lhs.double_values)
    return false;
  if (lhs.date_time_values < rhs.date_time_values)
    return true;
  if (rhs.date_time_values < lhs.date_time_values)
    return false;
  if (lhs.time_values < rhs.time_values)
    return true;
  if (rhs.time_values < lhs.time_values)
    return false;
  if (lhs.url_values < rhs.url_values)
    return true;
  if (rhs.url_values < lhs.url_values)
    return false;
  if (lhs.entity_values < rhs.entity_values)
    return true;
  if (rhs.entity_values < lhs.entity_values)
    return false;
  return false;
}
template <typename StructPtrType>
PropertyPtr Property::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(values)
  );
}

template <typename T, Property::EnableIfSame<T>*>
bool Property::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->values, other_struct.values))
    return false;
  return true;
}

template <typename T, Property::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.values < rhs.values)
    return true;
  if (rhs.values < lhs.values)
    return false;
  return false;
}
template <typename StructPtrType>
EntityPtr Entity::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(id),
      mojo::Clone(properties)
  );
}

template <typename T, Entity::EnableIfSame<T>*>
bool Entity::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->properties, other_struct.properties))
    return false;
  return true;
}

template <typename T, Entity::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.properties < rhs.properties)
    return true;
  if (rhs.properties < lhs.properties)
    return false;
  return false;
}


}  // schema_org::improved::mojom

namespace mojo {


template <>
struct  StructTraits<::schema_org::improved::mojom::Values::DataView,
                                         ::schema_org::improved::mojom::ValuesPtr> {
  static bool IsNull(const ::schema_org::improved::mojom::ValuesPtr& input) { return !input; }
  static void SetToNull(::schema_org::improved::mojom::ValuesPtr* output) { output->reset(); }

  static const decltype(::schema_org::improved::mojom::Values::bool_values)& bool_values(
      const ::schema_org::improved::mojom::ValuesPtr& input) {
    return input->bool_values;
  }

  static const decltype(::schema_org::improved::mojom::Values::long_values)& long_values(
      const ::schema_org::improved::mojom::ValuesPtr& input) {
    return input->long_values;
  }

  static const decltype(::schema_org::improved::mojom::Values::string_values)& string_values(
      const ::schema_org::improved::mojom::ValuesPtr& input) {
    return input->string_values;
  }

  static const decltype(::schema_org::improved::mojom::Values::double_values)& double_values(
      const ::schema_org::improved::mojom::ValuesPtr& input) {
    return input->double_values;
  }

  static const decltype(::schema_org::improved::mojom::Values::date_time_values)& date_time_values(
      const ::schema_org::improved::mojom::ValuesPtr& input) {
    return input->date_time_values;
  }

  static const decltype(::schema_org::improved::mojom::Values::time_values)& time_values(
      const ::schema_org::improved::mojom::ValuesPtr& input) {
    return input->time_values;
  }

  static const decltype(::schema_org::improved::mojom::Values::url_values)& url_values(
      const ::schema_org::improved::mojom::ValuesPtr& input) {
    return input->url_values;
  }

  static const decltype(::schema_org::improved::mojom::Values::entity_values)& entity_values(
      const ::schema_org::improved::mojom::ValuesPtr& input) {
    return input->entity_values;
  }

  static bool Read(::schema_org::improved::mojom::Values::DataView input, ::schema_org::improved::mojom::ValuesPtr* output);
};


template <>
struct  StructTraits<::schema_org::improved::mojom::Property::DataView,
                                         ::schema_org::improved::mojom::PropertyPtr> {
  static bool IsNull(const ::schema_org::improved::mojom::PropertyPtr& input) { return !input; }
  static void SetToNull(::schema_org::improved::mojom::PropertyPtr* output) { output->reset(); }

  static const decltype(::schema_org::improved::mojom::Property::name)& name(
      const ::schema_org::improved::mojom::PropertyPtr& input) {
    return input->name;
  }

  static const decltype(::schema_org::improved::mojom::Property::values)& values(
      const ::schema_org::improved::mojom::PropertyPtr& input) {
    return input->values;
  }

  static bool Read(::schema_org::improved::mojom::Property::DataView input, ::schema_org::improved::mojom::PropertyPtr* output);
};


template <>
struct  StructTraits<::schema_org::improved::mojom::Entity::DataView,
                                         ::schema_org::improved::mojom::EntityPtr> {
  static bool IsNull(const ::schema_org::improved::mojom::EntityPtr& input) { return !input; }
  static void SetToNull(::schema_org::improved::mojom::EntityPtr* output) { output->reset(); }

  static const decltype(::schema_org::improved::mojom::Entity::type)& type(
      const ::schema_org::improved::mojom::EntityPtr& input) {
    return input->type;
  }

  static const decltype(::schema_org::improved::mojom::Entity::id)& id(
      const ::schema_org::improved::mojom::EntityPtr& input) {
    return input->id;
  }

  static const decltype(::schema_org::improved::mojom::Entity::properties)& properties(
      const ::schema_org::improved::mojom::EntityPtr& input) {
    return input->properties;
  }

  static bool Read(::schema_org::improved::mojom::Entity::DataView input, ::schema_org::improved::mojom::EntityPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SCHEMA_ORG_COMMON_IMPROVED_METADATA_MOJOM_H_