// components/remote_cocoa/common/text_input_host.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_TEXT_INPUT_HOST_MOJOM_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_TEXT_INPUT_HOST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/remote_cocoa/common/text_input_host.mojom-features.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/text_input_host.mojom-shared.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/text_input_host.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "ui/base/ime/mojom/text_edit_commands.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/range/mojom/range.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace remote_cocoa::mojom {

class TextInputHostProxy;

template <typename ImplRefTraits>
class TextInputHostStub;

class TextInputHostRequestValidator;
class TextInputHostResponseValidator;


class TextInputHost
    : public TextInputHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "remote_cocoa.mojom.TextInputHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1, 
    2, 
    3, 
    4, 
    9, 
    10, 
    11, 
    12, 
    13
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TextInputHostInterfaceBase;
  using Proxy_ = TextInputHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = TextInputHostStub<ImplRefTraits>;

  using RequestValidator_ = TextInputHostRequestValidator;
  using ResponseValidator_ = TextInputHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kHasClientMinVersion = 0,
    kHasInputContextMinVersion = 0,
    kIsRTLMinVersion = 0,
    kGetSelectionRangeMinVersion = 0,
    kGetSelectionTextMinVersion = 0,
    kInsertTextMinVersion = 0,
    kDeleteRangeMinVersion = 0,
    kSetCompositionTextMinVersion = 0,
    kConfirmCompositionTextMinVersion = 0,
    kHasCompositionTextMinVersion = 0,
    kGetCompositionTextRangeMinVersion = 0,
    kGetAttributedSubstringForRangeMinVersion = 0,
    kGetFirstRectForRangeMinVersion = 0,
    kIsTextEditCommandEnabledMinVersion = 0,
    kSetTextEditCommandForNextKeyEventMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct HasClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HasInputContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsRTL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSelectionRange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSelectionText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InsertText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteRange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCompositionText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConfirmCompositionText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HasCompositionText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCompositionTextRange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAttributedSubstringForRange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFirstRectForRange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsTextEditCommandEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTextEditCommandForNextKeyEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TextInputHost() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool HasClient(bool* out_has_client);
  using HasClientCallback = base::OnceCallback<void(bool)>;
  using HasClientMojoCallback = base::OnceCallback<void(bool)>;

  virtual void HasClient(HasClientCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool HasInputContext(bool* out_has_input_context);
  using HasInputContextCallback = base::OnceCallback<void(bool)>;
  using HasInputContextMojoCallback = base::OnceCallback<void(bool)>;

  virtual void HasInputContext(HasInputContextCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool IsRTL(bool* out_is_rtl);
  using IsRTLCallback = base::OnceCallback<void(bool)>;
  using IsRTLMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsRTL(IsRTLCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetSelectionRange(::gfx::Range* out_range);
  using GetSelectionRangeCallback = base::OnceCallback<void(const ::gfx::Range&)>;
  using GetSelectionRangeMojoCallback = base::OnceCallback<void(const ::gfx::Range&)>;

  virtual void GetSelectionRange(GetSelectionRangeCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetSelectionText(bool* out_result, ::std::u16string* out_text);
  using GetSelectionTextCallback = base::OnceCallback<void(bool, const ::std::u16string&)>;
  using GetSelectionTextMojoCallback = base::OnceCallback<void(bool, const ::std::u16string&)>;

  virtual void GetSelectionText(GetSelectionTextCallback callback) = 0;

  virtual void InsertText(const ::std::u16string& text, bool as_character) = 0;

  virtual void DeleteRange(const ::gfx::Range& range) = 0;

  virtual void SetCompositionText(const ::std::u16string& text, const ::gfx::Range& selected_range, const ::gfx::Range& replacement_range) = 0;

  virtual void ConfirmCompositionText() = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool HasCompositionText(bool* out_has_composition_text);
  using HasCompositionTextCallback = base::OnceCallback<void(bool)>;
  using HasCompositionTextMojoCallback = base::OnceCallback<void(bool)>;

  virtual void HasCompositionText(HasCompositionTextCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetCompositionTextRange(::gfx::Range* out_composition_range);
  using GetCompositionTextRangeCallback = base::OnceCallback<void(const ::gfx::Range&)>;
  using GetCompositionTextRangeMojoCallback = base::OnceCallback<void(const ::gfx::Range&)>;

  virtual void GetCompositionTextRange(GetCompositionTextRangeCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetAttributedSubstringForRange(const ::gfx::Range& requested_range, ::std::u16string* out_text, ::gfx::Range* out_actual_range);
  using GetAttributedSubstringForRangeCallback = base::OnceCallback<void(const ::std::u16string&, const ::gfx::Range&)>;
  using GetAttributedSubstringForRangeMojoCallback = base::OnceCallback<void(const ::std::u16string&, const ::gfx::Range&)>;

  virtual void GetAttributedSubstringForRange(const ::gfx::Range& requested_range, GetAttributedSubstringForRangeCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetFirstRectForRange(const ::gfx::Range& requested_range, ::gfx::Rect* out_rect, ::gfx::Range* out_actual_range);
  using GetFirstRectForRangeCallback = base::OnceCallback<void(const ::gfx::Rect&, const ::gfx::Range&)>;
  using GetFirstRectForRangeMojoCallback = base::OnceCallback<void(const ::gfx::Rect&, const ::gfx::Range&)>;

  virtual void GetFirstRectForRange(const ::gfx::Range& requested_range, GetFirstRectForRangeCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool IsTextEditCommandEnabled(::ui::TextEditCommand command, bool* out_enabled);
  using IsTextEditCommandEnabledCallback = base::OnceCallback<void(bool)>;
  using IsTextEditCommandEnabledMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsTextEditCommandEnabled(::ui::TextEditCommand command, IsTextEditCommandEnabledCallback callback) = 0;

  virtual void SetTextEditCommandForNextKeyEvent(::ui::TextEditCommand command) = 0;
};



class  TextInputHostProxy
    : public TextInputHost {
 public:
  using InterfaceType = TextInputHost;

  explicit TextInputHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool HasClient(bool* out_has_client) final;
  
  void HasClient(HasClientCallback callback) final;
  
  bool HasInputContext(bool* out_has_input_context) final;
  
  void HasInputContext(HasInputContextCallback callback) final;
  
  bool IsRTL(bool* out_is_rtl) final;
  
  void IsRTL(IsRTLCallback callback) final;
  
  bool GetSelectionRange(::gfx::Range* out_range) final;
  
  void GetSelectionRange(GetSelectionRangeCallback callback) final;
  
  bool GetSelectionText(bool* out_result, ::std::u16string* out_text) final;
  
  void GetSelectionText(GetSelectionTextCallback callback) final;
  
  void InsertText(const ::std::u16string& text, bool as_character) final;
  
  void DeleteRange(const ::gfx::Range& range) final;
  
  void SetCompositionText(const ::std::u16string& text, const ::gfx::Range& selected_range, const ::gfx::Range& replacement_range) final;
  
  void ConfirmCompositionText() final;
  
  bool HasCompositionText(bool* out_has_composition_text) final;
  
  void HasCompositionText(HasCompositionTextCallback callback) final;
  
  bool GetCompositionTextRange(::gfx::Range* out_composition_range) final;
  
  void GetCompositionTextRange(GetCompositionTextRangeCallback callback) final;
  
  bool GetAttributedSubstringForRange(const ::gfx::Range& requested_range, ::std::u16string* out_text, ::gfx::Range* out_actual_range) final;
  
  void GetAttributedSubstringForRange(const ::gfx::Range& requested_range, GetAttributedSubstringForRangeCallback callback) final;
  
  bool GetFirstRectForRange(const ::gfx::Range& requested_range, ::gfx::Rect* out_rect, ::gfx::Range* out_actual_range) final;
  
  void GetFirstRectForRange(const ::gfx::Range& requested_range, GetFirstRectForRangeCallback callback) final;
  
  bool IsTextEditCommandEnabled(::ui::TextEditCommand command, bool* out_enabled) final;
  
  void IsTextEditCommandEnabled(::ui::TextEditCommand command, IsTextEditCommandEnabledCallback callback) final;
  
  void SetTextEditCommandForNextKeyEvent(::ui::TextEditCommand command) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  TextInputHostStubDispatch {
 public:
  static bool Accept(TextInputHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TextInputHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TextInputHost>>
class TextInputHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TextInputHostStub() = default;
  ~TextInputHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TextInputHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TextInputHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TextInputHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TextInputHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // remote_cocoa::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_TEXT_INPUT_HOST_MOJOM_H_