// components/remote_cocoa/common/text_input_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/remote_cocoa/common/text_input_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/remote_cocoa/common/text_input_host.mojom-params-data.h"
#include "components/remote_cocoa/common/text_input_host.mojom-shared-message-ids.h"

#include "components/remote_cocoa/common/text_input_host.mojom-import-headers.h"
#include "components/remote_cocoa/common/text_input_host.mojom-test-utils.h"


namespace remote_cocoa::mojom {
// The declaration includes the definition on other builds.

TextInputHost::IPCStableHashFunction TextInputHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TextInputHost>(message.name())) {
    case messages::TextInputHost::kHasClient: {
      return &TextInputHost::HasClient_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kHasInputContext: {
      return &TextInputHost::HasInputContext_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kIsRTL: {
      return &TextInputHost::IsRTL_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kGetSelectionRange: {
      return &TextInputHost::GetSelectionRange_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kGetSelectionText: {
      return &TextInputHost::GetSelectionText_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kInsertText: {
      return &TextInputHost::InsertText_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kDeleteRange: {
      return &TextInputHost::DeleteRange_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kSetCompositionText: {
      return &TextInputHost::SetCompositionText_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kConfirmCompositionText: {
      return &TextInputHost::ConfirmCompositionText_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kHasCompositionText: {
      return &TextInputHost::HasCompositionText_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kGetCompositionTextRange: {
      return &TextInputHost::GetCompositionTextRange_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kGetAttributedSubstringForRange: {
      return &TextInputHost::GetAttributedSubstringForRange_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kGetFirstRectForRange: {
      return &TextInputHost::GetFirstRectForRange_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kIsTextEditCommandEnabled: {
      return &TextInputHost::IsTextEditCommandEnabled_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kSetTextEditCommandForNextKeyEvent: {
      return &TextInputHost::SetTextEditCommandForNextKeyEvent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TextInputHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TextInputHost>(message.name())) {
      case messages::TextInputHost::kHasClient:
            return "Receive remote_cocoa::mojom::TextInputHost::HasClient";
      case messages::TextInputHost::kHasInputContext:
            return "Receive remote_cocoa::mojom::TextInputHost::HasInputContext";
      case messages::TextInputHost::kIsRTL:
            return "Receive remote_cocoa::mojom::TextInputHost::IsRTL";
      case messages::TextInputHost::kGetSelectionRange:
            return "Receive remote_cocoa::mojom::TextInputHost::GetSelectionRange";
      case messages::TextInputHost::kGetSelectionText:
            return "Receive remote_cocoa::mojom::TextInputHost::GetSelectionText";
      case messages::TextInputHost::kInsertText:
            return "Receive remote_cocoa::mojom::TextInputHost::InsertText";
      case messages::TextInputHost::kDeleteRange:
            return "Receive remote_cocoa::mojom::TextInputHost::DeleteRange";
      case messages::TextInputHost::kSetCompositionText:
            return "Receive remote_cocoa::mojom::TextInputHost::SetCompositionText";
      case messages::TextInputHost::kConfirmCompositionText:
            return "Receive remote_cocoa::mojom::TextInputHost::ConfirmCompositionText";
      case messages::TextInputHost::kHasCompositionText:
            return "Receive remote_cocoa::mojom::TextInputHost::HasCompositionText";
      case messages::TextInputHost::kGetCompositionTextRange:
            return "Receive remote_cocoa::mojom::TextInputHost::GetCompositionTextRange";
      case messages::TextInputHost::kGetAttributedSubstringForRange:
            return "Receive remote_cocoa::mojom::TextInputHost::GetAttributedSubstringForRange";
      case messages::TextInputHost::kGetFirstRectForRange:
            return "Receive remote_cocoa::mojom::TextInputHost::GetFirstRectForRange";
      case messages::TextInputHost::kIsTextEditCommandEnabled:
            return "Receive remote_cocoa::mojom::TextInputHost::IsTextEditCommandEnabled";
      case messages::TextInputHost::kSetTextEditCommandForNextKeyEvent:
            return "Receive remote_cocoa::mojom::TextInputHost::SetTextEditCommandForNextKeyEvent";
    }
  } else {
    switch (static_cast<messages::TextInputHost>(message.name())) {
      case messages::TextInputHost::kHasClient:
            return "Receive reply remote_cocoa::mojom::TextInputHost::HasClient";
      case messages::TextInputHost::kHasInputContext:
            return "Receive reply remote_cocoa::mojom::TextInputHost::HasInputContext";
      case messages::TextInputHost::kIsRTL:
            return "Receive reply remote_cocoa::mojom::TextInputHost::IsRTL";
      case messages::TextInputHost::kGetSelectionRange:
            return "Receive reply remote_cocoa::mojom::TextInputHost::GetSelectionRange";
      case messages::TextInputHost::kGetSelectionText:
            return "Receive reply remote_cocoa::mojom::TextInputHost::GetSelectionText";
      case messages::TextInputHost::kInsertText:
            return "Receive reply remote_cocoa::mojom::TextInputHost::InsertText";
      case messages::TextInputHost::kDeleteRange:
            return "Receive reply remote_cocoa::mojom::TextInputHost::DeleteRange";
      case messages::TextInputHost::kSetCompositionText:
            return "Receive reply remote_cocoa::mojom::TextInputHost::SetCompositionText";
      case messages::TextInputHost::kConfirmCompositionText:
            return "Receive reply remote_cocoa::mojom::TextInputHost::ConfirmCompositionText";
      case messages::TextInputHost::kHasCompositionText:
            return "Receive reply remote_cocoa::mojom::TextInputHost::HasCompositionText";
      case messages::TextInputHost::kGetCompositionTextRange:
            return "Receive reply remote_cocoa::mojom::TextInputHost::GetCompositionTextRange";
      case messages::TextInputHost::kGetAttributedSubstringForRange:
            return "Receive reply remote_cocoa::mojom::TextInputHost::GetAttributedSubstringForRange";
      case messages::TextInputHost::kGetFirstRectForRange:
            return "Receive reply remote_cocoa::mojom::TextInputHost::GetFirstRectForRange";
      case messages::TextInputHost::kIsTextEditCommandEnabled:
            return "Receive reply remote_cocoa::mojom::TextInputHost::IsTextEditCommandEnabled";
      case messages::TextInputHost::kSetTextEditCommandForNextKeyEvent:
            return "Receive reply remote_cocoa::mojom::TextInputHost::SetTextEditCommandForNextKeyEvent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TextInputHost::HasClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd38990ee;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::HasClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::HasInputContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x77540219;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::HasInputContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::IsRTL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x28dcb762;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::IsRTL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::GetSelectionRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x73554f9e;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::GetSelectionRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::GetSelectionText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd23247eb;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::GetSelectionText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::InsertText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdd782a5d;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::InsertText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::DeleteRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2fed626d;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::DeleteRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::SetCompositionText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x081468c8;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::SetCompositionText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::ConfirmCompositionText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x90347a8c;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::ConfirmCompositionText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::HasCompositionText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x75559687;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::HasCompositionText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::GetCompositionTextRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x809b2ca0;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::GetCompositionTextRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::GetAttributedSubstringForRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8fa11006;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::GetAttributedSubstringForRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::GetFirstRectForRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8f2415f0;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::GetFirstRectForRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::IsTextEditCommandEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb4b7c1c;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::IsTextEditCommandEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::SetTextEditCommandForNextKeyEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8a53c889;  // IPCStableHash for remote_cocoa::mojom::TextInputHost::SetTextEditCommandForNextKeyEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool TextInputHost::HasClient(bool* out_has_client) {
  NOTREACHED();
}
bool TextInputHost::HasInputContext(bool* out_has_input_context) {
  NOTREACHED();
}
bool TextInputHost::IsRTL(bool* out_is_rtl) {
  NOTREACHED();
}
bool TextInputHost::GetSelectionRange(::gfx::Range* out_range) {
  NOTREACHED();
}
bool TextInputHost::GetSelectionText(bool* out_result, ::std::u16string* out_text) {
  NOTREACHED();
}
bool TextInputHost::HasCompositionText(bool* out_has_composition_text) {
  NOTREACHED();
}
bool TextInputHost::GetCompositionTextRange(::gfx::Range* out_composition_range) {
  NOTREACHED();
}
bool TextInputHost::GetAttributedSubstringForRange(const ::gfx::Range& requested_range, ::std::u16string* out_text, ::gfx::Range* out_actual_range) {
  NOTREACHED();
}
bool TextInputHost::GetFirstRectForRange(const ::gfx::Range& requested_range, ::gfx::Rect* out_rect, ::gfx::Range* out_actual_range) {
  NOTREACHED();
}
bool TextInputHost::IsTextEditCommandEnabled(::ui::TextEditCommand command, bool* out_enabled) {
  NOTREACHED();
}
class TextInputHost_HasClient_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  TextInputHost_HasClient_HandleSyncResponse(
      bool* result, bool* out_has_client)
      : result_(result), out_has_client_(out_has_client) {
    DCHECK(!*result_);
  }

  TextInputHost_HasClient_HandleSyncResponse(const TextInputHost_HasClient_HandleSyncResponse&) = delete;
  TextInputHost_HasClient_HandleSyncResponse& operator=(const TextInputHost_HasClient_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_has_client_;};

class TextInputHost_HasClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextInputHost_HasClient_ForwardToCallback(
      TextInputHost::HasClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextInputHost_HasClient_ForwardToCallback(const TextInputHost_HasClient_ForwardToCallback&) = delete;
  TextInputHost_HasClient_ForwardToCallback& operator=(const TextInputHost_HasClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextInputHost::HasClientCallback callback_;
};
class TextInputHost_HasInputContext_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  TextInputHost_HasInputContext_HandleSyncResponse(
      bool* result, bool* out_has_input_context)
      : result_(result), out_has_input_context_(out_has_input_context) {
    DCHECK(!*result_);
  }

  TextInputHost_HasInputContext_HandleSyncResponse(const TextInputHost_HasInputContext_HandleSyncResponse&) = delete;
  TextInputHost_HasInputContext_HandleSyncResponse& operator=(const TextInputHost_HasInputContext_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_has_input_context_;};

class TextInputHost_HasInputContext_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextInputHost_HasInputContext_ForwardToCallback(
      TextInputHost::HasInputContextCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextInputHost_HasInputContext_ForwardToCallback(const TextInputHost_HasInputContext_ForwardToCallback&) = delete;
  TextInputHost_HasInputContext_ForwardToCallback& operator=(const TextInputHost_HasInputContext_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextInputHost::HasInputContextCallback callback_;
};
class TextInputHost_IsRTL_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  TextInputHost_IsRTL_HandleSyncResponse(
      bool* result, bool* out_is_rtl)
      : result_(result), out_is_rtl_(out_is_rtl) {
    DCHECK(!*result_);
  }

  TextInputHost_IsRTL_HandleSyncResponse(const TextInputHost_IsRTL_HandleSyncResponse&) = delete;
  TextInputHost_IsRTL_HandleSyncResponse& operator=(const TextInputHost_IsRTL_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_is_rtl_;};

class TextInputHost_IsRTL_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextInputHost_IsRTL_ForwardToCallback(
      TextInputHost::IsRTLCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextInputHost_IsRTL_ForwardToCallback(const TextInputHost_IsRTL_ForwardToCallback&) = delete;
  TextInputHost_IsRTL_ForwardToCallback& operator=(const TextInputHost_IsRTL_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextInputHost::IsRTLCallback callback_;
};
class TextInputHost_GetSelectionRange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  TextInputHost_GetSelectionRange_HandleSyncResponse(
      bool* result, ::gfx::Range* out_range)
      : result_(result), out_range_(out_range) {
    DCHECK(!*result_);
  }

  TextInputHost_GetSelectionRange_HandleSyncResponse(const TextInputHost_GetSelectionRange_HandleSyncResponse&) = delete;
  TextInputHost_GetSelectionRange_HandleSyncResponse& operator=(const TextInputHost_GetSelectionRange_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::gfx::Range* out_range_;};

class TextInputHost_GetSelectionRange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextInputHost_GetSelectionRange_ForwardToCallback(
      TextInputHost::GetSelectionRangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextInputHost_GetSelectionRange_ForwardToCallback(const TextInputHost_GetSelectionRange_ForwardToCallback&) = delete;
  TextInputHost_GetSelectionRange_ForwardToCallback& operator=(const TextInputHost_GetSelectionRange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextInputHost::GetSelectionRangeCallback callback_;
};
class TextInputHost_GetSelectionText_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  TextInputHost_GetSelectionText_HandleSyncResponse(
      bool* result, bool* out_result, ::std::u16string* out_text)
      : result_(result), out_result_(out_result), out_text_(out_text) {
    DCHECK(!*result_);
  }

  TextInputHost_GetSelectionText_HandleSyncResponse(const TextInputHost_GetSelectionText_HandleSyncResponse&) = delete;
  TextInputHost_GetSelectionText_HandleSyncResponse& operator=(const TextInputHost_GetSelectionText_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_result_;
  ::std::u16string* out_text_;};

class TextInputHost_GetSelectionText_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextInputHost_GetSelectionText_ForwardToCallback(
      TextInputHost::GetSelectionTextCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextInputHost_GetSelectionText_ForwardToCallback(const TextInputHost_GetSelectionText_ForwardToCallback&) = delete;
  TextInputHost_GetSelectionText_ForwardToCallback& operator=(const TextInputHost_GetSelectionText_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextInputHost::GetSelectionTextCallback callback_;
};
class TextInputHost_HasCompositionText_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  TextInputHost_HasCompositionText_HandleSyncResponse(
      bool* result, bool* out_has_composition_text)
      : result_(result), out_has_composition_text_(out_has_composition_text) {
    DCHECK(!*result_);
  }

  TextInputHost_HasCompositionText_HandleSyncResponse(const TextInputHost_HasCompositionText_HandleSyncResponse&) = delete;
  TextInputHost_HasCompositionText_HandleSyncResponse& operator=(const TextInputHost_HasCompositionText_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_has_composition_text_;};

class TextInputHost_HasCompositionText_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextInputHost_HasCompositionText_ForwardToCallback(
      TextInputHost::HasCompositionTextCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextInputHost_HasCompositionText_ForwardToCallback(const TextInputHost_HasCompositionText_ForwardToCallback&) = delete;
  TextInputHost_HasCompositionText_ForwardToCallback& operator=(const TextInputHost_HasCompositionText_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextInputHost::HasCompositionTextCallback callback_;
};
class TextInputHost_GetCompositionTextRange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  TextInputHost_GetCompositionTextRange_HandleSyncResponse(
      bool* result, ::gfx::Range* out_composition_range)
      : result_(result), out_composition_range_(out_composition_range) {
    DCHECK(!*result_);
  }

  TextInputHost_GetCompositionTextRange_HandleSyncResponse(const TextInputHost_GetCompositionTextRange_HandleSyncResponse&) = delete;
  TextInputHost_GetCompositionTextRange_HandleSyncResponse& operator=(const TextInputHost_GetCompositionTextRange_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::gfx::Range* out_composition_range_;};

class TextInputHost_GetCompositionTextRange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextInputHost_GetCompositionTextRange_ForwardToCallback(
      TextInputHost::GetCompositionTextRangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextInputHost_GetCompositionTextRange_ForwardToCallback(const TextInputHost_GetCompositionTextRange_ForwardToCallback&) = delete;
  TextInputHost_GetCompositionTextRange_ForwardToCallback& operator=(const TextInputHost_GetCompositionTextRange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextInputHost::GetCompositionTextRangeCallback callback_;
};
class TextInputHost_GetAttributedSubstringForRange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  TextInputHost_GetAttributedSubstringForRange_HandleSyncResponse(
      bool* result, ::std::u16string* out_text, ::gfx::Range* out_actual_range)
      : result_(result), out_text_(out_text), out_actual_range_(out_actual_range) {
    DCHECK(!*result_);
  }

  TextInputHost_GetAttributedSubstringForRange_HandleSyncResponse(const TextInputHost_GetAttributedSubstringForRange_HandleSyncResponse&) = delete;
  TextInputHost_GetAttributedSubstringForRange_HandleSyncResponse& operator=(const TextInputHost_GetAttributedSubstringForRange_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::std::u16string* out_text_;
  ::gfx::Range* out_actual_range_;};

class TextInputHost_GetAttributedSubstringForRange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextInputHost_GetAttributedSubstringForRange_ForwardToCallback(
      TextInputHost::GetAttributedSubstringForRangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextInputHost_GetAttributedSubstringForRange_ForwardToCallback(const TextInputHost_GetAttributedSubstringForRange_ForwardToCallback&) = delete;
  TextInputHost_GetAttributedSubstringForRange_ForwardToCallback& operator=(const TextInputHost_GetAttributedSubstringForRange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextInputHost::GetAttributedSubstringForRangeCallback callback_;
};
class TextInputHost_GetFirstRectForRange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  TextInputHost_GetFirstRectForRange_HandleSyncResponse(
      bool* result, ::gfx::Rect* out_rect, ::gfx::Range* out_actual_range)
      : result_(result), out_rect_(out_rect), out_actual_range_(out_actual_range) {
    DCHECK(!*result_);
  }

  TextInputHost_GetFirstRectForRange_HandleSyncResponse(const TextInputHost_GetFirstRectForRange_HandleSyncResponse&) = delete;
  TextInputHost_GetFirstRectForRange_HandleSyncResponse& operator=(const TextInputHost_GetFirstRectForRange_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::gfx::Rect* out_rect_;
  ::gfx::Range* out_actual_range_;};

class TextInputHost_GetFirstRectForRange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextInputHost_GetFirstRectForRange_ForwardToCallback(
      TextInputHost::GetFirstRectForRangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextInputHost_GetFirstRectForRange_ForwardToCallback(const TextInputHost_GetFirstRectForRange_ForwardToCallback&) = delete;
  TextInputHost_GetFirstRectForRange_ForwardToCallback& operator=(const TextInputHost_GetFirstRectForRange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextInputHost::GetFirstRectForRangeCallback callback_;
};
class TextInputHost_IsTextEditCommandEnabled_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  TextInputHost_IsTextEditCommandEnabled_HandleSyncResponse(
      bool* result, bool* out_enabled)
      : result_(result), out_enabled_(out_enabled) {
    DCHECK(!*result_);
  }

  TextInputHost_IsTextEditCommandEnabled_HandleSyncResponse(const TextInputHost_IsTextEditCommandEnabled_HandleSyncResponse&) = delete;
  TextInputHost_IsTextEditCommandEnabled_HandleSyncResponse& operator=(const TextInputHost_IsTextEditCommandEnabled_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_enabled_;};

class TextInputHost_IsTextEditCommandEnabled_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextInputHost_IsTextEditCommandEnabled_ForwardToCallback(
      TextInputHost::IsTextEditCommandEnabledCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextInputHost_IsTextEditCommandEnabled_ForwardToCallback(const TextInputHost_IsTextEditCommandEnabled_ForwardToCallback&) = delete;
  TextInputHost_IsTextEditCommandEnabled_ForwardToCallback& operator=(const TextInputHost_IsTextEditCommandEnabled_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextInputHost::IsTextEditCommandEnabledCallback callback_;
};

TextInputHostProxy::TextInputHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool TextInputHostProxy::HasClient(
    bool* out_param_has_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call remote_cocoa::mojom::TextInputHost::HasClient (sync)");
#else
  TRACE_EVENT0("mojom", "TextInputHost::HasClient");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kHasClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_HasClient_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("HasClient");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_HasClient_HandleSyncResponse(
          &result, out_param_has_client));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "TextInputHost::HasClient", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_client"), out_param_has_client,
                        "<value of type bool>");
   });
#endif
  return result;
}

void TextInputHostProxy::HasClient(
    HasClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::TextInputHost::HasClient");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kHasClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_HasClient_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("HasClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_HasClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool TextInputHostProxy::HasInputContext(
    bool* out_param_has_input_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call remote_cocoa::mojom::TextInputHost::HasInputContext (sync)");
#else
  TRACE_EVENT0("mojom", "TextInputHost::HasInputContext");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kHasInputContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_HasInputContext_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("HasInputContext");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_HasInputContext_HandleSyncResponse(
          &result, out_param_has_input_context));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "TextInputHost::HasInputContext", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_input_context"), out_param_has_input_context,
                        "<value of type bool>");
   });
#endif
  return result;
}

void TextInputHostProxy::HasInputContext(
    HasInputContextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::TextInputHost::HasInputContext");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kHasInputContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_HasInputContext_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("HasInputContext");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_HasInputContext_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool TextInputHostProxy::IsRTL(
    bool* out_param_is_rtl) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call remote_cocoa::mojom::TextInputHost::IsRTL (sync)");
#else
  TRACE_EVENT0("mojom", "TextInputHost::IsRTL");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kIsRTL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_IsRTL_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("IsRTL");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_IsRTL_HandleSyncResponse(
          &result, out_param_is_rtl));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "TextInputHost::IsRTL", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_rtl"), out_param_is_rtl,
                        "<value of type bool>");
   });
#endif
  return result;
}

void TextInputHostProxy::IsRTL(
    IsRTLCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::TextInputHost::IsRTL");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kIsRTL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_IsRTL_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("IsRTL");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_IsRTL_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool TextInputHostProxy::GetSelectionRange(
    ::gfx::Range* out_param_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call remote_cocoa::mojom::TextInputHost::GetSelectionRange (sync)");
#else
  TRACE_EVENT0("mojom", "TextInputHost::GetSelectionRange");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetSelectionRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetSelectionRange_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetSelectionRange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_GetSelectionRange_HandleSyncResponse(
          &result, out_param_range));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "TextInputHost::GetSelectionRange", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), out_param_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif
  return result;
}

void TextInputHostProxy::GetSelectionRange(
    GetSelectionRangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::TextInputHost::GetSelectionRange");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetSelectionRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetSelectionRange_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetSelectionRange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_GetSelectionRange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool TextInputHostProxy::GetSelectionText(
    bool* out_param_result, ::std::u16string* out_param_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call remote_cocoa::mojom::TextInputHost::GetSelectionText (sync)");
#else
  TRACE_EVENT0("mojom", "TextInputHost::GetSelectionText");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetSelectionText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetSelectionText_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetSelectionText");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_GetSelectionText_HandleSyncResponse(
          &result, out_param_result, out_param_text));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "TextInputHost::GetSelectionText", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), out_param_text,
                        "<value of type const ::std::u16string&>");
   });
#endif
  return result;
}

void TextInputHostProxy::GetSelectionText(
    GetSelectionTextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::TextInputHost::GetSelectionText");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetSelectionText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetSelectionText_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetSelectionText");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_GetSelectionText_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TextInputHostProxy::InsertText(
    const ::std::u16string& in_text, bool in_as_character) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::TextInputHost::InsertText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("as_character"), in_as_character,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kInsertText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_InsertText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in TextInputHost.InsertText request");

  params->as_character = in_as_character;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("InsertText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextInputHostProxy::DeleteRange(
    const ::gfx::Range& in_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::TextInputHost::DeleteRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kDeleteRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_DeleteRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in TextInputHost.DeleteRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("DeleteRange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextInputHostProxy::SetCompositionText(
    const ::std::u16string& in_text, const ::gfx::Range& in_selected_range, const ::gfx::Range& in_replacement_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::TextInputHost::SetCompositionText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selected_range"), in_selected_range,
                        "<value of type const ::gfx::Range&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replacement_range"), in_replacement_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kSetCompositionText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_SetCompositionText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in TextInputHost.SetCompositionText request");
  mojo::internal::MessageFragment<
      typename decltype(params->selected_range)::BaseType> selected_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_selected_range,
    selected_range_fragment);

  params->selected_range.Set(
      selected_range_fragment.is_null() ? nullptr : selected_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->selected_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null selected_range in TextInputHost.SetCompositionText request");
  mojo::internal::MessageFragment<
      typename decltype(params->replacement_range)::BaseType> replacement_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_replacement_range,
    replacement_range_fragment);

  params->replacement_range.Set(
      replacement_range_fragment.is_null() ? nullptr : replacement_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->replacement_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null replacement_range in TextInputHost.SetCompositionText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("SetCompositionText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextInputHostProxy::ConfirmCompositionText(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::TextInputHost::ConfirmCompositionText");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kConfirmCompositionText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_ConfirmCompositionText_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("ConfirmCompositionText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool TextInputHostProxy::HasCompositionText(
    bool* out_param_has_composition_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call remote_cocoa::mojom::TextInputHost::HasCompositionText (sync)");
#else
  TRACE_EVENT0("mojom", "TextInputHost::HasCompositionText");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kHasCompositionText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_HasCompositionText_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("HasCompositionText");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_HasCompositionText_HandleSyncResponse(
          &result, out_param_has_composition_text));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "TextInputHost::HasCompositionText", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_composition_text"), out_param_has_composition_text,
                        "<value of type bool>");
   });
#endif
  return result;
}

void TextInputHostProxy::HasCompositionText(
    HasCompositionTextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::TextInputHost::HasCompositionText");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kHasCompositionText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_HasCompositionText_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("HasCompositionText");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_HasCompositionText_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool TextInputHostProxy::GetCompositionTextRange(
    ::gfx::Range* out_param_composition_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call remote_cocoa::mojom::TextInputHost::GetCompositionTextRange (sync)");
#else
  TRACE_EVENT0("mojom", "TextInputHost::GetCompositionTextRange");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetCompositionTextRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetCompositionTextRange_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetCompositionTextRange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_GetCompositionTextRange_HandleSyncResponse(
          &result, out_param_composition_range));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "TextInputHost::GetCompositionTextRange", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("composition_range"), out_param_composition_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif
  return result;
}

void TextInputHostProxy::GetCompositionTextRange(
    GetCompositionTextRangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::TextInputHost::GetCompositionTextRange");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetCompositionTextRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetCompositionTextRange_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetCompositionTextRange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_GetCompositionTextRange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool TextInputHostProxy::GetAttributedSubstringForRange(
    const ::gfx::Range& param_requested_range, ::std::u16string* out_param_text, ::gfx::Range* out_param_actual_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call remote_cocoa::mojom::TextInputHost::GetAttributedSubstringForRange (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_range"), param_requested_range,
                        "<value of type const ::gfx::Range&>");
   });
#else
  TRACE_EVENT0("mojom", "TextInputHost::GetAttributedSubstringForRange");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetAttributedSubstringForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetAttributedSubstringForRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requested_range)::BaseType> requested_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    param_requested_range,
    requested_range_fragment);

  params->requested_range.Set(
      requested_range_fragment.is_null() ? nullptr : requested_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requested_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requested_range in TextInputHost.GetAttributedSubstringForRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetAttributedSubstringForRange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_GetAttributedSubstringForRange_HandleSyncResponse(
          &result, out_param_text, out_param_actual_range));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "TextInputHost::GetAttributedSubstringForRange", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), out_param_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("actual_range"), out_param_actual_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif
  return result;
}

void TextInputHostProxy::GetAttributedSubstringForRange(
    const ::gfx::Range& in_requested_range, GetAttributedSubstringForRangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::TextInputHost::GetAttributedSubstringForRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_range"), in_requested_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetAttributedSubstringForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetAttributedSubstringForRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requested_range)::BaseType> requested_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_requested_range,
    requested_range_fragment);

  params->requested_range.Set(
      requested_range_fragment.is_null() ? nullptr : requested_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requested_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requested_range in TextInputHost.GetAttributedSubstringForRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetAttributedSubstringForRange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_GetAttributedSubstringForRange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool TextInputHostProxy::GetFirstRectForRange(
    const ::gfx::Range& param_requested_range, ::gfx::Rect* out_param_rect, ::gfx::Range* out_param_actual_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call remote_cocoa::mojom::TextInputHost::GetFirstRectForRange (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_range"), param_requested_range,
                        "<value of type const ::gfx::Range&>");
   });
#else
  TRACE_EVENT0("mojom", "TextInputHost::GetFirstRectForRange");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetFirstRectForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetFirstRectForRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requested_range)::BaseType> requested_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    param_requested_range,
    requested_range_fragment);

  params->requested_range.Set(
      requested_range_fragment.is_null() ? nullptr : requested_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requested_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requested_range in TextInputHost.GetFirstRectForRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetFirstRectForRange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_GetFirstRectForRange_HandleSyncResponse(
          &result, out_param_rect, out_param_actual_range));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "TextInputHost::GetFirstRectForRange", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect"), out_param_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("actual_range"), out_param_actual_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif
  return result;
}

void TextInputHostProxy::GetFirstRectForRange(
    const ::gfx::Range& in_requested_range, GetFirstRectForRangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::TextInputHost::GetFirstRectForRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_range"), in_requested_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetFirstRectForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetFirstRectForRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requested_range)::BaseType> requested_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_requested_range,
    requested_range_fragment);

  params->requested_range.Set(
      requested_range_fragment.is_null() ? nullptr : requested_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requested_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requested_range in TextInputHost.GetFirstRectForRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetFirstRectForRange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_GetFirstRectForRange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool TextInputHostProxy::IsTextEditCommandEnabled(
    ::ui::TextEditCommand param_command, bool* out_param_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call remote_cocoa::mojom::TextInputHost::IsTextEditCommandEnabled (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command"), param_command,
                        "<value of type ::ui::TextEditCommand>");
   });
#else
  TRACE_EVENT0("mojom", "TextInputHost::IsTextEditCommandEnabled");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kIsTextEditCommandEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_IsTextEditCommandEnabled_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ui::mojom::TextEditCommand>(
    param_command,
    &params->command);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("IsTextEditCommandEnabled");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_IsTextEditCommandEnabled_HandleSyncResponse(
          &result, out_param_enabled));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "TextInputHost::IsTextEditCommandEnabled", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), out_param_enabled,
                        "<value of type bool>");
   });
#endif
  return result;
}

void TextInputHostProxy::IsTextEditCommandEnabled(
    ::ui::TextEditCommand in_command, IsTextEditCommandEnabledCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::TextInputHost::IsTextEditCommandEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command"), in_command,
                        "<value of type ::ui::TextEditCommand>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kIsTextEditCommandEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_IsTextEditCommandEnabled_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ui::mojom::TextEditCommand>(
    in_command,
    &params->command);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("IsTextEditCommandEnabled");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextInputHost_IsTextEditCommandEnabled_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TextInputHostProxy::SetTextEditCommandForNextKeyEvent(
    ::ui::TextEditCommand in_command) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::TextInputHost::SetTextEditCommandForNextKeyEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command"), in_command,
                        "<value of type ::ui::TextEditCommand>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kSetTextEditCommandForNextKeyEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_SetTextEditCommandForNextKeyEvent_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ui::mojom::TextEditCommand>(
    in_command,
    &params->command);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("SetTextEditCommandForNextKeyEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class TextInputHost_HasClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextInputHost::HasClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextInputHost_HasClient_ProxyToResponder> proxy(
        new TextInputHost_HasClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextInputHost_HasClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextInputHost_HasClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextInputHost_HasClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextInputHost::HasClientCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_has_client);
};

bool TextInputHost_HasClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_HasClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextInputHost_HasClient_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextInputHost.0
  bool success = true;
  bool p_has_client{};
  TextInputHost_HasClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_client = input_data_view.has_client();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_has_client));
  }
  return true;
}

void TextInputHost_HasClient_ProxyToResponder::Run(
    bool in_has_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::TextInputHost::HasClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_client"), in_has_client,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kHasClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_HasClient_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->has_client = in_has_client;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("HasClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool TextInputHost_HasClient_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_HasClient_ResponseParams_Data* params =
      reinterpret_cast<internal::TextInputHost_HasClient_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for TextInputHost.0
  bool success = true;
  bool p_has_client{};
  TextInputHost_HasClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_client = input_data_view.has_client();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 0, true);
    return false;
  }
  *out_has_client_ = std::move(p_has_client);
  *result_ = true;
  return true;
}
class TextInputHost_HasInputContext_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextInputHost::HasInputContextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextInputHost_HasInputContext_ProxyToResponder> proxy(
        new TextInputHost_HasInputContext_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextInputHost_HasInputContext_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextInputHost_HasInputContext_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextInputHost_HasInputContext_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextInputHost::HasInputContextCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_has_input_context);
};

bool TextInputHost_HasInputContext_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_HasInputContext_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextInputHost_HasInputContext_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextInputHost.1
  bool success = true;
  bool p_has_input_context{};
  TextInputHost_HasInputContext_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_input_context = input_data_view.has_input_context();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_has_input_context));
  }
  return true;
}

void TextInputHost_HasInputContext_ProxyToResponder::Run(
    bool in_has_input_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::TextInputHost::HasInputContext", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_input_context"), in_has_input_context,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kHasInputContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_HasInputContext_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->has_input_context = in_has_input_context;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("HasInputContext");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool TextInputHost_HasInputContext_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_HasInputContext_ResponseParams_Data* params =
      reinterpret_cast<internal::TextInputHost_HasInputContext_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for TextInputHost.1
  bool success = true;
  bool p_has_input_context{};
  TextInputHost_HasInputContext_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_input_context = input_data_view.has_input_context();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 1, true);
    return false;
  }
  *out_has_input_context_ = std::move(p_has_input_context);
  *result_ = true;
  return true;
}
class TextInputHost_IsRTL_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextInputHost::IsRTLCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextInputHost_IsRTL_ProxyToResponder> proxy(
        new TextInputHost_IsRTL_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextInputHost_IsRTL_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextInputHost_IsRTL_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextInputHost_IsRTL_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextInputHost::IsRTLCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_rtl);
};

bool TextInputHost_IsRTL_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_IsRTL_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextInputHost_IsRTL_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextInputHost.2
  bool success = true;
  bool p_is_rtl{};
  TextInputHost_IsRTL_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_rtl = input_data_view.is_rtl();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_rtl));
  }
  return true;
}

void TextInputHost_IsRTL_ProxyToResponder::Run(
    bool in_is_rtl) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::TextInputHost::IsRTL", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_rtl"), in_is_rtl,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kIsRTL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_IsRTL_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_rtl = in_is_rtl;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("IsRTL");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool TextInputHost_IsRTL_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_IsRTL_ResponseParams_Data* params =
      reinterpret_cast<internal::TextInputHost_IsRTL_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for TextInputHost.2
  bool success = true;
  bool p_is_rtl{};
  TextInputHost_IsRTL_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_rtl = input_data_view.is_rtl();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 2, true);
    return false;
  }
  *out_is_rtl_ = std::move(p_is_rtl);
  *result_ = true;
  return true;
}
class TextInputHost_GetSelectionRange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextInputHost::GetSelectionRangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextInputHost_GetSelectionRange_ProxyToResponder> proxy(
        new TextInputHost_GetSelectionRange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextInputHost_GetSelectionRange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextInputHost_GetSelectionRange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextInputHost_GetSelectionRange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextInputHost::GetSelectionRangeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gfx::Range& in_range);
};

bool TextInputHost_GetSelectionRange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_GetSelectionRange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextInputHost_GetSelectionRange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextInputHost.3
  bool success = true;
  ::gfx::Range p_range{};
  TextInputHost_GetSelectionRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRange(&p_range))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_range));
  }
  return true;
}

void TextInputHost_GetSelectionRange_ProxyToResponder::Run(
    const ::gfx::Range& in_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::TextInputHost::GetSelectionRange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetSelectionRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetSelectionRange_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetSelectionRange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool TextInputHost_GetSelectionRange_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_GetSelectionRange_ResponseParams_Data* params =
      reinterpret_cast<internal::TextInputHost_GetSelectionRange_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for TextInputHost.3
  bool success = true;
  ::gfx::Range p_range{};
  TextInputHost_GetSelectionRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRange(&p_range))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 3, true);
    return false;
  }
  *out_range_ = std::move(p_range);
  *result_ = true;
  return true;
}
class TextInputHost_GetSelectionText_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextInputHost::GetSelectionTextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextInputHost_GetSelectionText_ProxyToResponder> proxy(
        new TextInputHost_GetSelectionText_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextInputHost_GetSelectionText_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextInputHost_GetSelectionText_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextInputHost_GetSelectionText_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextInputHost::GetSelectionTextCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result, const ::std::u16string& in_text);
};

bool TextInputHost_GetSelectionText_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_GetSelectionText_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextInputHost_GetSelectionText_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextInputHost.4
  bool success = true;
  bool p_result{};
  ::std::u16string p_text{};
  TextInputHost_GetSelectionText_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadText(&p_text))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_text));
  }
  return true;
}

void TextInputHost_GetSelectionText_ProxyToResponder::Run(
    bool in_result, const ::std::u16string& in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::TextInputHost::GetSelectionText", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetSelectionText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetSelectionText_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetSelectionText");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool TextInputHost_GetSelectionText_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_GetSelectionText_ResponseParams_Data* params =
      reinterpret_cast<internal::TextInputHost_GetSelectionText_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for TextInputHost.4
  bool success = true;
  bool p_result{};
  ::std::u16string p_text{};
  TextInputHost_GetSelectionText_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadText(&p_text))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 4, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *out_text_ = std::move(p_text);
  *result_ = true;
  return true;
}
class TextInputHost_HasCompositionText_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextInputHost::HasCompositionTextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextInputHost_HasCompositionText_ProxyToResponder> proxy(
        new TextInputHost_HasCompositionText_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextInputHost_HasCompositionText_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextInputHost_HasCompositionText_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextInputHost_HasCompositionText_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextInputHost::HasCompositionTextCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_has_composition_text);
};

bool TextInputHost_HasCompositionText_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_HasCompositionText_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextInputHost_HasCompositionText_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextInputHost.9
  bool success = true;
  bool p_has_composition_text{};
  TextInputHost_HasCompositionText_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_composition_text = input_data_view.has_composition_text();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_has_composition_text));
  }
  return true;
}

void TextInputHost_HasCompositionText_ProxyToResponder::Run(
    bool in_has_composition_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::TextInputHost::HasCompositionText", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_composition_text"), in_has_composition_text,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kHasCompositionText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_HasCompositionText_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->has_composition_text = in_has_composition_text;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("HasCompositionText");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool TextInputHost_HasCompositionText_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_HasCompositionText_ResponseParams_Data* params =
      reinterpret_cast<internal::TextInputHost_HasCompositionText_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for TextInputHost.9
  bool success = true;
  bool p_has_composition_text{};
  TextInputHost_HasCompositionText_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_composition_text = input_data_view.has_composition_text();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 9, true);
    return false;
  }
  *out_has_composition_text_ = std::move(p_has_composition_text);
  *result_ = true;
  return true;
}
class TextInputHost_GetCompositionTextRange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextInputHost::GetCompositionTextRangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextInputHost_GetCompositionTextRange_ProxyToResponder> proxy(
        new TextInputHost_GetCompositionTextRange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextInputHost_GetCompositionTextRange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextInputHost_GetCompositionTextRange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextInputHost_GetCompositionTextRange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextInputHost::GetCompositionTextRangeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gfx::Range& in_composition_range);
};

bool TextInputHost_GetCompositionTextRange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_GetCompositionTextRange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextInputHost_GetCompositionTextRange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextInputHost.10
  bool success = true;
  ::gfx::Range p_composition_range{};
  TextInputHost_GetCompositionTextRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCompositionRange(&p_composition_range))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_composition_range));
  }
  return true;
}

void TextInputHost_GetCompositionTextRange_ProxyToResponder::Run(
    const ::gfx::Range& in_composition_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::TextInputHost::GetCompositionTextRange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("composition_range"), in_composition_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetCompositionTextRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetCompositionTextRange_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->composition_range)::BaseType> composition_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_composition_range,
    composition_range_fragment);

  params->composition_range.Set(
      composition_range_fragment.is_null() ? nullptr : composition_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->composition_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null composition_range in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetCompositionTextRange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool TextInputHost_GetCompositionTextRange_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_GetCompositionTextRange_ResponseParams_Data* params =
      reinterpret_cast<internal::TextInputHost_GetCompositionTextRange_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for TextInputHost.10
  bool success = true;
  ::gfx::Range p_composition_range{};
  TextInputHost_GetCompositionTextRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCompositionRange(&p_composition_range))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 10, true);
    return false;
  }
  *out_composition_range_ = std::move(p_composition_range);
  *result_ = true;
  return true;
}
class TextInputHost_GetAttributedSubstringForRange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextInputHost::GetAttributedSubstringForRangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextInputHost_GetAttributedSubstringForRange_ProxyToResponder> proxy(
        new TextInputHost_GetAttributedSubstringForRange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextInputHost_GetAttributedSubstringForRange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextInputHost_GetAttributedSubstringForRange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextInputHost_GetAttributedSubstringForRange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextInputHost::GetAttributedSubstringForRangeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::std::u16string& in_text, const ::gfx::Range& in_actual_range);
};

bool TextInputHost_GetAttributedSubstringForRange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_GetAttributedSubstringForRange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextInputHost_GetAttributedSubstringForRange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextInputHost.11
  bool success = true;
  ::std::u16string p_text{};
  ::gfx::Range p_actual_range{};
  TextInputHost_GetAttributedSubstringForRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadText(&p_text))
    success = false;
  if (success && !input_data_view.ReadActualRange(&p_actual_range))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_text), 
std::move(p_actual_range));
  }
  return true;
}

void TextInputHost_GetAttributedSubstringForRange_ProxyToResponder::Run(
    const ::std::u16string& in_text, const ::gfx::Range& in_actual_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::TextInputHost::GetAttributedSubstringForRange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("actual_range"), in_actual_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetAttributedSubstringForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetAttributedSubstringForRange_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in ");
  mojo::internal::MessageFragment<
      typename decltype(params->actual_range)::BaseType> actual_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_actual_range,
    actual_range_fragment);

  params->actual_range.Set(
      actual_range_fragment.is_null() ? nullptr : actual_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->actual_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null actual_range in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetAttributedSubstringForRange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool TextInputHost_GetAttributedSubstringForRange_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_GetAttributedSubstringForRange_ResponseParams_Data* params =
      reinterpret_cast<internal::TextInputHost_GetAttributedSubstringForRange_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for TextInputHost.11
  bool success = true;
  ::std::u16string p_text{};
  ::gfx::Range p_actual_range{};
  TextInputHost_GetAttributedSubstringForRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadText(&p_text))
    success = false;
  if (success && !input_data_view.ReadActualRange(&p_actual_range))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 11, true);
    return false;
  }
  *out_text_ = std::move(p_text);
  *out_actual_range_ = std::move(p_actual_range);
  *result_ = true;
  return true;
}
class TextInputHost_GetFirstRectForRange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextInputHost::GetFirstRectForRangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextInputHost_GetFirstRectForRange_ProxyToResponder> proxy(
        new TextInputHost_GetFirstRectForRange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextInputHost_GetFirstRectForRange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextInputHost_GetFirstRectForRange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextInputHost_GetFirstRectForRange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextInputHost::GetFirstRectForRangeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gfx::Rect& in_rect, const ::gfx::Range& in_actual_range);
};

bool TextInputHost_GetFirstRectForRange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_GetFirstRectForRange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextInputHost_GetFirstRectForRange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextInputHost.12
  bool success = true;
  ::gfx::Rect p_rect{};
  ::gfx::Range p_actual_range{};
  TextInputHost_GetFirstRectForRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRect(&p_rect))
    success = false;
  if (success && !input_data_view.ReadActualRange(&p_actual_range))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_rect), 
std::move(p_actual_range));
  }
  return true;
}

void TextInputHost_GetFirstRectForRange_ProxyToResponder::Run(
    const ::gfx::Rect& in_rect, const ::gfx::Range& in_actual_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::TextInputHost::GetFirstRectForRange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect"), in_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("actual_range"), in_actual_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGetFirstRectForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_GetFirstRectForRange_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rect)::BaseType> rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_rect,
    rect_fragment);

  params->rect.Set(
      rect_fragment.is_null() ? nullptr : rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rect in ");
  mojo::internal::MessageFragment<
      typename decltype(params->actual_range)::BaseType> actual_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_actual_range,
    actual_range_fragment);

  params->actual_range.Set(
      actual_range_fragment.is_null() ? nullptr : actual_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->actual_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null actual_range in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GetFirstRectForRange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool TextInputHost_GetFirstRectForRange_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_GetFirstRectForRange_ResponseParams_Data* params =
      reinterpret_cast<internal::TextInputHost_GetFirstRectForRange_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for TextInputHost.12
  bool success = true;
  ::gfx::Rect p_rect{};
  ::gfx::Range p_actual_range{};
  TextInputHost_GetFirstRectForRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRect(&p_rect))
    success = false;
  if (success && !input_data_view.ReadActualRange(&p_actual_range))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 12, true);
    return false;
  }
  *out_rect_ = std::move(p_rect);
  *out_actual_range_ = std::move(p_actual_range);
  *result_ = true;
  return true;
}
class TextInputHost_IsTextEditCommandEnabled_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextInputHost::IsTextEditCommandEnabledCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextInputHost_IsTextEditCommandEnabled_ProxyToResponder> proxy(
        new TextInputHost_IsTextEditCommandEnabled_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextInputHost_IsTextEditCommandEnabled_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextInputHost_IsTextEditCommandEnabled_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextInputHost_IsTextEditCommandEnabled_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextInputHost::IsTextEditCommandEnabledCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_enabled);
};

bool TextInputHost_IsTextEditCommandEnabled_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_IsTextEditCommandEnabled_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextInputHost_IsTextEditCommandEnabled_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextInputHost.13
  bool success = true;
  bool p_enabled{};
  TextInputHost_IsTextEditCommandEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_enabled = input_data_view.enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_enabled));
  }
  return true;
}

void TextInputHost_IsTextEditCommandEnabled_ProxyToResponder::Run(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::TextInputHost::IsTextEditCommandEnabled", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kIsTextEditCommandEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::TextInputHost_IsTextEditCommandEnabled_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("IsTextEditCommandEnabled");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool TextInputHost_IsTextEditCommandEnabled_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextInputHost_IsTextEditCommandEnabled_ResponseParams_Data* params =
      reinterpret_cast<internal::TextInputHost_IsTextEditCommandEnabled_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for TextInputHost.13
  bool success = true;
  bool p_enabled{};
  TextInputHost_IsTextEditCommandEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_enabled = input_data_view.enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextInputHost::Name_, 13, true);
    return false;
  }
  *out_enabled_ = std::move(p_enabled);
  *result_ = true;
  return true;
}

// static
bool TextInputHostStubDispatch::Accept(
    TextInputHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TextInputHost>(message->header()->name)) {
    case messages::TextInputHost::kHasClient: {
      break;
    }
    case messages::TextInputHost::kHasInputContext: {
      break;
    }
    case messages::TextInputHost::kIsRTL: {
      break;
    }
    case messages::TextInputHost::kGetSelectionRange: {
      break;
    }
    case messages::TextInputHost::kGetSelectionText: {
      break;
    }
    case messages::TextInputHost::kInsertText: {
      DCHECK(message->is_serialized());
      internal::TextInputHost_InsertText_Params_Data* params =
          reinterpret_cast<internal::TextInputHost_InsertText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextInputHost.5
      bool success = true;
      ::std::u16string p_text{};
      bool p_as_character{};
      TextInputHost_InsertText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success)
        p_as_character = input_data_view.as_character();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InsertText(        
        std::move(p_text), 
        std::move(p_as_character));
      return true;
    }
    case messages::TextInputHost::kDeleteRange: {
      DCHECK(message->is_serialized());
      internal::TextInputHost_DeleteRange_Params_Data* params =
          reinterpret_cast<internal::TextInputHost_DeleteRange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextInputHost.6
      bool success = true;
      ::gfx::Range p_range{};
      TextInputHost_DeleteRange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteRange(        
        std::move(p_range));
      return true;
    }
    case messages::TextInputHost::kSetCompositionText: {
      DCHECK(message->is_serialized());
      internal::TextInputHost_SetCompositionText_Params_Data* params =
          reinterpret_cast<internal::TextInputHost_SetCompositionText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextInputHost.7
      bool success = true;
      ::std::u16string p_text{};
      ::gfx::Range p_selected_range{};
      ::gfx::Range p_replacement_range{};
      TextInputHost_SetCompositionText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadSelectedRange(&p_selected_range))
        success = false;
      if (success && !input_data_view.ReadReplacementRange(&p_replacement_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCompositionText(        
        std::move(p_text), 
        std::move(p_selected_range), 
        std::move(p_replacement_range));
      return true;
    }
    case messages::TextInputHost::kConfirmCompositionText: {
      DCHECK(message->is_serialized());
      internal::TextInputHost_ConfirmCompositionText_Params_Data* params =
          reinterpret_cast<internal::TextInputHost_ConfirmCompositionText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextInputHost.8
      bool success = true;
      TextInputHost_ConfirmCompositionText_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConfirmCompositionText(        );
      return true;
    }
    case messages::TextInputHost::kHasCompositionText: {
      break;
    }
    case messages::TextInputHost::kGetCompositionTextRange: {
      break;
    }
    case messages::TextInputHost::kGetAttributedSubstringForRange: {
      break;
    }
    case messages::TextInputHost::kGetFirstRectForRange: {
      break;
    }
    case messages::TextInputHost::kIsTextEditCommandEnabled: {
      break;
    }
    case messages::TextInputHost::kSetTextEditCommandForNextKeyEvent: {
      DCHECK(message->is_serialized());
      internal::TextInputHost_SetTextEditCommandForNextKeyEvent_Params_Data* params =
          reinterpret_cast<internal::TextInputHost_SetTextEditCommandForNextKeyEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextInputHost.14
      bool success = true;
      ::ui::TextEditCommand p_command{};
      TextInputHost_SetTextEditCommandForNextKeyEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommand(&p_command))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTextEditCommandForNextKeyEvent(        
        std::move(p_command));
      return true;
    }
  }
  return false;
}

// static
bool TextInputHostStubDispatch::AcceptWithResponder(
    TextInputHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TextInputHost>(message->header()->name)) {
    case messages::TextInputHost::kHasClient: {
      internal::TextInputHost_HasClient_Params_Data* params =
          reinterpret_cast<
              internal::TextInputHost_HasClient_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextInputHost.0
      bool success = true;
      TextInputHost_HasClient_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 0, false);
        return false;
      }
      auto callback =
          TextInputHost_HasClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasClient(std::move(callback));
      return true;
    }
    case messages::TextInputHost::kHasInputContext: {
      internal::TextInputHost_HasInputContext_Params_Data* params =
          reinterpret_cast<
              internal::TextInputHost_HasInputContext_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextInputHost.1
      bool success = true;
      TextInputHost_HasInputContext_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 1, false);
        return false;
      }
      auto callback =
          TextInputHost_HasInputContext_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasInputContext(std::move(callback));
      return true;
    }
    case messages::TextInputHost::kIsRTL: {
      internal::TextInputHost_IsRTL_Params_Data* params =
          reinterpret_cast<
              internal::TextInputHost_IsRTL_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextInputHost.2
      bool success = true;
      TextInputHost_IsRTL_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 2, false);
        return false;
      }
      auto callback =
          TextInputHost_IsRTL_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsRTL(std::move(callback));
      return true;
    }
    case messages::TextInputHost::kGetSelectionRange: {
      internal::TextInputHost_GetSelectionRange_Params_Data* params =
          reinterpret_cast<
              internal::TextInputHost_GetSelectionRange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextInputHost.3
      bool success = true;
      TextInputHost_GetSelectionRange_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 3, false);
        return false;
      }
      auto callback =
          TextInputHost_GetSelectionRange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSelectionRange(std::move(callback));
      return true;
    }
    case messages::TextInputHost::kGetSelectionText: {
      internal::TextInputHost_GetSelectionText_Params_Data* params =
          reinterpret_cast<
              internal::TextInputHost_GetSelectionText_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextInputHost.4
      bool success = true;
      TextInputHost_GetSelectionText_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 4, false);
        return false;
      }
      auto callback =
          TextInputHost_GetSelectionText_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSelectionText(std::move(callback));
      return true;
    }
    case messages::TextInputHost::kInsertText: {
      break;
    }
    case messages::TextInputHost::kDeleteRange: {
      break;
    }
    case messages::TextInputHost::kSetCompositionText: {
      break;
    }
    case messages::TextInputHost::kConfirmCompositionText: {
      break;
    }
    case messages::TextInputHost::kHasCompositionText: {
      internal::TextInputHost_HasCompositionText_Params_Data* params =
          reinterpret_cast<
              internal::TextInputHost_HasCompositionText_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextInputHost.9
      bool success = true;
      TextInputHost_HasCompositionText_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 9, false);
        return false;
      }
      auto callback =
          TextInputHost_HasCompositionText_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasCompositionText(std::move(callback));
      return true;
    }
    case messages::TextInputHost::kGetCompositionTextRange: {
      internal::TextInputHost_GetCompositionTextRange_Params_Data* params =
          reinterpret_cast<
              internal::TextInputHost_GetCompositionTextRange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextInputHost.10
      bool success = true;
      TextInputHost_GetCompositionTextRange_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 10, false);
        return false;
      }
      auto callback =
          TextInputHost_GetCompositionTextRange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCompositionTextRange(std::move(callback));
      return true;
    }
    case messages::TextInputHost::kGetAttributedSubstringForRange: {
      internal::TextInputHost_GetAttributedSubstringForRange_Params_Data* params =
          reinterpret_cast<
              internal::TextInputHost_GetAttributedSubstringForRange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextInputHost.11
      bool success = true;
      ::gfx::Range p_requested_range{};
      TextInputHost_GetAttributedSubstringForRange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestedRange(&p_requested_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 11, false);
        return false;
      }
      auto callback =
          TextInputHost_GetAttributedSubstringForRange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAttributedSubstringForRange(        
        std::move(p_requested_range), std::move(callback));
      return true;
    }
    case messages::TextInputHost::kGetFirstRectForRange: {
      internal::TextInputHost_GetFirstRectForRange_Params_Data* params =
          reinterpret_cast<
              internal::TextInputHost_GetFirstRectForRange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextInputHost.12
      bool success = true;
      ::gfx::Range p_requested_range{};
      TextInputHost_GetFirstRectForRange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestedRange(&p_requested_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 12, false);
        return false;
      }
      auto callback =
          TextInputHost_GetFirstRectForRange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFirstRectForRange(        
        std::move(p_requested_range), std::move(callback));
      return true;
    }
    case messages::TextInputHost::kIsTextEditCommandEnabled: {
      internal::TextInputHost_IsTextEditCommandEnabled_Params_Data* params =
          reinterpret_cast<
              internal::TextInputHost_IsTextEditCommandEnabled_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextInputHost.13
      bool success = true;
      ::ui::TextEditCommand p_command{};
      TextInputHost_IsTextEditCommandEnabled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommand(&p_command))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 13, false);
        return false;
      }
      auto callback =
          TextInputHost_IsTextEditCommandEnabled_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsTextEditCommandEnabled(        
        std::move(p_command), std::move(callback));
      return true;
    }
    case messages::TextInputHost::kSetTextEditCommandForNextKeyEvent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTextInputHostValidationInfo[] = {
    { &internal::TextInputHost_HasClient_Params_Data::Validate,
     &internal::TextInputHost_HasClient_ResponseParams_Data::Validate},
    { &internal::TextInputHost_HasInputContext_Params_Data::Validate,
     &internal::TextInputHost_HasInputContext_ResponseParams_Data::Validate},
    { &internal::TextInputHost_IsRTL_Params_Data::Validate,
     &internal::TextInputHost_IsRTL_ResponseParams_Data::Validate},
    { &internal::TextInputHost_GetSelectionRange_Params_Data::Validate,
     &internal::TextInputHost_GetSelectionRange_ResponseParams_Data::Validate},
    { &internal::TextInputHost_GetSelectionText_Params_Data::Validate,
     &internal::TextInputHost_GetSelectionText_ResponseParams_Data::Validate},
    { &internal::TextInputHost_InsertText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextInputHost_DeleteRange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextInputHost_SetCompositionText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextInputHost_ConfirmCompositionText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextInputHost_HasCompositionText_Params_Data::Validate,
     &internal::TextInputHost_HasCompositionText_ResponseParams_Data::Validate},
    { &internal::TextInputHost_GetCompositionTextRange_Params_Data::Validate,
     &internal::TextInputHost_GetCompositionTextRange_ResponseParams_Data::Validate},
    { &internal::TextInputHost_GetAttributedSubstringForRange_Params_Data::Validate,
     &internal::TextInputHost_GetAttributedSubstringForRange_ResponseParams_Data::Validate},
    { &internal::TextInputHost_GetFirstRectForRange_Params_Data::Validate,
     &internal::TextInputHost_GetFirstRectForRange_ResponseParams_Data::Validate},
    { &internal::TextInputHost_IsTextEditCommandEnabled_Params_Data::Validate,
     &internal::TextInputHost_IsTextEditCommandEnabled_ResponseParams_Data::Validate},
    { &internal::TextInputHost_SetTextEditCommandForNextKeyEvent_Params_Data::Validate,
     nullptr /* no response */},
};

bool TextInputHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::remote_cocoa::mojom::TextInputHost::Name_,
    kTextInputHostValidationInfo);
}

bool TextInputHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::remote_cocoa::mojom::TextInputHost::Name_,
    kTextInputHostValidationInfo);
}


}  // remote_cocoa::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace remote_cocoa::mojom {


void TextInputHostInterceptorForTesting::HasClient(HasClientCallback callback) {
  GetForwardingInterface()->HasClient(std::move(callback));
}
void TextInputHostInterceptorForTesting::HasInputContext(HasInputContextCallback callback) {
  GetForwardingInterface()->HasInputContext(std::move(callback));
}
void TextInputHostInterceptorForTesting::IsRTL(IsRTLCallback callback) {
  GetForwardingInterface()->IsRTL(std::move(callback));
}
void TextInputHostInterceptorForTesting::GetSelectionRange(GetSelectionRangeCallback callback) {
  GetForwardingInterface()->GetSelectionRange(std::move(callback));
}
void TextInputHostInterceptorForTesting::GetSelectionText(GetSelectionTextCallback callback) {
  GetForwardingInterface()->GetSelectionText(std::move(callback));
}
void TextInputHostInterceptorForTesting::InsertText(const ::std::u16string& text, bool as_character) {
  GetForwardingInterface()->InsertText(
    std::move(text)
    , 
    std::move(as_character)
    );
}
void TextInputHostInterceptorForTesting::DeleteRange(const ::gfx::Range& range) {
  GetForwardingInterface()->DeleteRange(
    std::move(range)
    );
}
void TextInputHostInterceptorForTesting::SetCompositionText(const ::std::u16string& text, const ::gfx::Range& selected_range, const ::gfx::Range& replacement_range) {
  GetForwardingInterface()->SetCompositionText(
    std::move(text)
    , 
    std::move(selected_range)
    , 
    std::move(replacement_range)
    );
}
void TextInputHostInterceptorForTesting::ConfirmCompositionText() {
  GetForwardingInterface()->ConfirmCompositionText();
}
void TextInputHostInterceptorForTesting::HasCompositionText(HasCompositionTextCallback callback) {
  GetForwardingInterface()->HasCompositionText(std::move(callback));
}
void TextInputHostInterceptorForTesting::GetCompositionTextRange(GetCompositionTextRangeCallback callback) {
  GetForwardingInterface()->GetCompositionTextRange(std::move(callback));
}
void TextInputHostInterceptorForTesting::GetAttributedSubstringForRange(const ::gfx::Range& requested_range, GetAttributedSubstringForRangeCallback callback) {
  GetForwardingInterface()->GetAttributedSubstringForRange(
    std::move(requested_range)
    , std::move(callback));
}
void TextInputHostInterceptorForTesting::GetFirstRectForRange(const ::gfx::Range& requested_range, GetFirstRectForRangeCallback callback) {
  GetForwardingInterface()->GetFirstRectForRange(
    std::move(requested_range)
    , std::move(callback));
}
void TextInputHostInterceptorForTesting::IsTextEditCommandEnabled(::ui::TextEditCommand command, IsTextEditCommandEnabledCallback callback) {
  GetForwardingInterface()->IsTextEditCommandEnabled(
    std::move(command)
    , std::move(callback));
}
void TextInputHostInterceptorForTesting::SetTextEditCommandForNextKeyEvent(::ui::TextEditCommand command) {
  GetForwardingInterface()->SetTextEditCommandForNextKeyEvent(
    std::move(command)
    );
}
TextInputHostAsyncWaiter::TextInputHostAsyncWaiter(
    TextInputHost* proxy) : proxy_(proxy) {}

TextInputHostAsyncWaiter::~TextInputHostAsyncWaiter() = default;


void TextInputHostAsyncWaiter::HasClient(
    bool* out_has_client) {
  base::RunLoop loop;
  proxy_->HasClient(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_client
,
             bool has_client) {*out_has_client = std::move(has_client);
            loop->Quit();
          },
          &loop,
          out_has_client));
  loop.Run();
}

bool TextInputHostAsyncWaiter::HasClient(
    ) {
  bool async_wait_result;
  HasClient(&async_wait_result);
  return async_wait_result;
}

void TextInputHostAsyncWaiter::HasInputContext(
    bool* out_has_input_context) {
  base::RunLoop loop;
  proxy_->HasInputContext(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_input_context
,
             bool has_input_context) {*out_has_input_context = std::move(has_input_context);
            loop->Quit();
          },
          &loop,
          out_has_input_context));
  loop.Run();
}

bool TextInputHostAsyncWaiter::HasInputContext(
    ) {
  bool async_wait_result;
  HasInputContext(&async_wait_result);
  return async_wait_result;
}

void TextInputHostAsyncWaiter::IsRTL(
    bool* out_is_rtl) {
  base::RunLoop loop;
  proxy_->IsRTL(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_rtl
,
             bool is_rtl) {*out_is_rtl = std::move(is_rtl);
            loop->Quit();
          },
          &loop,
          out_is_rtl));
  loop.Run();
}

bool TextInputHostAsyncWaiter::IsRTL(
    ) {
  bool async_wait_result;
  IsRTL(&async_wait_result);
  return async_wait_result;
}

void TextInputHostAsyncWaiter::GetSelectionRange(
    ::gfx::Range* out_range) {
  base::RunLoop loop;
  proxy_->GetSelectionRange(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gfx::Range* out_range
,
             const ::gfx::Range& range) {*out_range = std::move(range);
            loop->Quit();
          },
          &loop,
          out_range));
  loop.Run();
}

::gfx::Range TextInputHostAsyncWaiter::GetSelectionRange(
    ) {
  ::gfx::Range async_wait_result;
  GetSelectionRange(&async_wait_result);
  return async_wait_result;
}

void TextInputHostAsyncWaiter::GetSelectionText(
    bool* out_result, ::std::u16string* out_text) {
  base::RunLoop loop;
  proxy_->GetSelectionText(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             ::std::u16string* out_text
,
             bool result,
             const ::std::u16string& text) {*out_result = std::move(result);*out_text = std::move(text);
            loop->Quit();
          },
          &loop,
          out_result,
          out_text));
  loop.Run();
}



void TextInputHostAsyncWaiter::HasCompositionText(
    bool* out_has_composition_text) {
  base::RunLoop loop;
  proxy_->HasCompositionText(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_composition_text
,
             bool has_composition_text) {*out_has_composition_text = std::move(has_composition_text);
            loop->Quit();
          },
          &loop,
          out_has_composition_text));
  loop.Run();
}

bool TextInputHostAsyncWaiter::HasCompositionText(
    ) {
  bool async_wait_result;
  HasCompositionText(&async_wait_result);
  return async_wait_result;
}

void TextInputHostAsyncWaiter::GetCompositionTextRange(
    ::gfx::Range* out_composition_range) {
  base::RunLoop loop;
  proxy_->GetCompositionTextRange(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gfx::Range* out_composition_range
,
             const ::gfx::Range& composition_range) {*out_composition_range = std::move(composition_range);
            loop->Quit();
          },
          &loop,
          out_composition_range));
  loop.Run();
}

::gfx::Range TextInputHostAsyncWaiter::GetCompositionTextRange(
    ) {
  ::gfx::Range async_wait_result;
  GetCompositionTextRange(&async_wait_result);
  return async_wait_result;
}

void TextInputHostAsyncWaiter::GetAttributedSubstringForRange(
    const ::gfx::Range& requested_range, ::std::u16string* out_text, ::gfx::Range* out_actual_range) {
  base::RunLoop loop;
  proxy_->GetAttributedSubstringForRange(
      std::move(requested_range),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::std::u16string* out_text
,
             ::gfx::Range* out_actual_range
,
             const ::std::u16string& text,
             const ::gfx::Range& actual_range) {*out_text = std::move(text);*out_actual_range = std::move(actual_range);
            loop->Quit();
          },
          &loop,
          out_text,
          out_actual_range));
  loop.Run();
}



void TextInputHostAsyncWaiter::GetFirstRectForRange(
    const ::gfx::Range& requested_range, ::gfx::Rect* out_rect, ::gfx::Range* out_actual_range) {
  base::RunLoop loop;
  proxy_->GetFirstRectForRange(
      std::move(requested_range),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gfx::Rect* out_rect
,
             ::gfx::Range* out_actual_range
,
             const ::gfx::Rect& rect,
             const ::gfx::Range& actual_range) {*out_rect = std::move(rect);*out_actual_range = std::move(actual_range);
            loop->Quit();
          },
          &loop,
          out_rect,
          out_actual_range));
  loop.Run();
}



void TextInputHostAsyncWaiter::IsTextEditCommandEnabled(
    ::ui::TextEditCommand command, bool* out_enabled) {
  base::RunLoop loop;
  proxy_->IsTextEditCommandEnabled(
      std::move(command),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_enabled
,
             bool enabled) {*out_enabled = std::move(enabled);
            loop->Quit();
          },
          &loop,
          out_enabled));
  loop.Run();
}

bool TextInputHostAsyncWaiter::IsTextEditCommandEnabled(
    ::ui::TextEditCommand command) {
  bool async_wait_result;
  IsTextEditCommandEnabled(std::move(command),&async_wait_result);
  return async_wait_result;
}






}  // remote_cocoa::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif