// components/remote_cocoa/common/select_file_dialog.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/remote_cocoa/common/select_file_dialog.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/remote_cocoa/common/select_file_dialog.mojom-params-data.h"
#include "components/remote_cocoa/common/select_file_dialog.mojom-shared-message-ids.h"

#include "components/remote_cocoa/common/select_file_dialog.mojom-import-headers.h"
#include "components/remote_cocoa/common/select_file_dialog.mojom-test-utils.h"


namespace remote_cocoa::mojom {
SelectFileTypeInfo::SelectFileTypeInfo()
    : extensions(),
      extension_description_overrides(),
      include_all_files(),
      keep_extension_visible() {}

SelectFileTypeInfo::SelectFileTypeInfo(
    std::vector<std::vector<std::string>> extensions_in,
    std::vector<::std::u16string> extension_description_overrides_in,
    bool include_all_files_in,
    bool keep_extension_visible_in)
    : extensions(std::move(extensions_in)),
      extension_description_overrides(std::move(extension_description_overrides_in)),
      include_all_files(std::move(include_all_files_in)),
      keep_extension_visible(std::move(keep_extension_visible_in)) {}

SelectFileTypeInfo::~SelectFileTypeInfo() = default;

void SelectFileTypeInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extensions"), this->extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extension_description_overrides"), this->extension_description_overrides,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_all_files"), this->include_all_files,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keep_extension_visible"), this->keep_extension_visible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectFileTypeInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SelectFileDialog::IPCStableHashFunction SelectFileDialog::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SelectFileDialog>(message.name())) {
    case messages::SelectFileDialog::kShow: {
      return &SelectFileDialog::Show_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SelectFileDialog::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SelectFileDialog>(message.name())) {
      case messages::SelectFileDialog::kShow:
            return "Receive remote_cocoa::mojom::SelectFileDialog::Show";
    }
  } else {
    switch (static_cast<messages::SelectFileDialog>(message.name())) {
      case messages::SelectFileDialog::kShow:
            return "Receive reply remote_cocoa::mojom::SelectFileDialog::Show";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SelectFileDialog::Show_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6e429cea;  // IPCStableHash for remote_cocoa::mojom::SelectFileDialog::Show
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SelectFileDialog_Show_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SelectFileDialog_Show_ForwardToCallback(
      SelectFileDialog::ShowCallback callback
      ) : callback_(std::move(callback)) {
  }

  SelectFileDialog_Show_ForwardToCallback(const SelectFileDialog_Show_ForwardToCallback&) = delete;
  SelectFileDialog_Show_ForwardToCallback& operator=(const SelectFileDialog_Show_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SelectFileDialog::ShowCallback callback_;
};

SelectFileDialogProxy::SelectFileDialogProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SelectFileDialogProxy::Show(
    SelectFileDialogType in_type, const ::std::u16string& in_title, const ::base::FilePath& in_file_path, SelectFileTypeInfoPtr in_file_types, int32_t in_file_type_index, const std::string& in_default_extension, ShowCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::SelectFileDialog::Show", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type SelectFileDialogType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), in_file_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_types"), in_file_types,
                        "<value of type SelectFileTypeInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_type_index"), in_file_type_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_extension"), in_default_extension,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SelectFileDialog::kShow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::SelectFileDialog_Show_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::remote_cocoa::mojom::SelectFileDialogType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in SelectFileDialog.Show request");
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in SelectFileDialog.Show request");
  mojo::internal::MessageFragment<
      typename decltype(params->file_types)::BaseType> file_types_fragment(
          params.message());
  
  mojo::internal::Serialize<::remote_cocoa::mojom::SelectFileTypeInfoDataView>(
    in_file_types,
    file_types_fragment);

  params->file_types.Set(
      file_types_fragment.is_null() ? nullptr : file_types_fragment.data());

  params->file_type_index = in_file_type_index;
  mojo::internal::MessageFragment<
      typename decltype(params->default_extension)::BaseType> default_extension_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_default_extension,
    default_extension_fragment);

  params->default_extension.Set(
      default_extension_fragment.is_null() ? nullptr : default_extension_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->default_extension.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null default_extension in SelectFileDialog.Show request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SelectFileDialog::Name_);
  message.set_method_name("Show");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SelectFileDialog_Show_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SelectFileDialog_Show_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SelectFileDialog::ShowCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SelectFileDialog_Show_ProxyToResponder> proxy(
        new SelectFileDialog_Show_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SelectFileDialog_Show_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SelectFileDialog_Show_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SelectFileDialog_Show_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SelectFileDialog::ShowCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_was_cancelled, const std::vector<::base::FilePath>& in_files, int32_t in_index, const std::vector<std::string>& in_file_tags);
};

bool SelectFileDialog_Show_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SelectFileDialog_Show_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SelectFileDialog_Show_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SelectFileDialog.0
  bool success = true;
  bool p_was_cancelled{};
  std::vector<::base::FilePath> p_files{};
  int32_t p_index{};
  std::vector<std::string> p_file_tags{};
  SelectFileDialog_Show_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_was_cancelled = input_data_view.was_cancelled();
  if (success && !input_data_view.ReadFiles(&p_files))
    success = false;
  if (success)
    p_index = input_data_view.index();
  if (success && !input_data_view.ReadFileTags(&p_file_tags))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SelectFileDialog::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_was_cancelled), 
std::move(p_files), 
std::move(p_index), 
std::move(p_file_tags));
  }
  return true;
}

void SelectFileDialog_Show_ProxyToResponder::Run(
    bool in_was_cancelled, const std::vector<::base::FilePath>& in_files, int32_t in_index, const std::vector<std::string>& in_file_tags) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::SelectFileDialog::Show", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("was_cancelled"), in_was_cancelled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("files"), in_files,
                        "<value of type const std::vector<::base::FilePath>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_tags"), in_file_tags,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SelectFileDialog::kShow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::SelectFileDialog_Show_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->was_cancelled = in_was_cancelled;
  mojo::internal::MessageFragment<
      typename decltype(params->files)::BaseType>
      files_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
    in_files,
    files_fragment,
    &files_validate_params);

  params->files.Set(
      files_fragment.is_null() ? nullptr : files_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->files.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null files in ");

  params->index = in_index;
  mojo::internal::MessageFragment<
      typename decltype(params->file_tags)::BaseType>
      file_tags_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& file_tags_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_file_tags,
    file_tags_fragment,
    &file_tags_validate_params);

  params->file_tags.Set(
      file_tags_fragment.is_null() ? nullptr : file_tags_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_tags.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_tags in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SelectFileDialog::Name_);
  message.set_method_name("Show");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SelectFileDialogStubDispatch::Accept(
    SelectFileDialog* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SelectFileDialog>(message->header()->name)) {
    case messages::SelectFileDialog::kShow: {
      break;
    }
  }
  return false;
}

// static
bool SelectFileDialogStubDispatch::AcceptWithResponder(
    SelectFileDialog* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SelectFileDialog>(message->header()->name)) {
    case messages::SelectFileDialog::kShow: {
      internal::SelectFileDialog_Show_Params_Data* params =
          reinterpret_cast<
              internal::SelectFileDialog_Show_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SelectFileDialog.0
      bool success = true;
      SelectFileDialogType p_type{};
      ::std::u16string p_title{};
      ::base::FilePath p_file_path{};
      SelectFileTypeInfoPtr p_file_types{};
      int32_t p_file_type_index{};
      std::string p_default_extension{};
      SelectFileDialog_Show_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success && !input_data_view.ReadFilePath(&p_file_path))
        success = false;
      if (success && !input_data_view.ReadFileTypes(&p_file_types))
        success = false;
      if (success)
        p_file_type_index = input_data_view.file_type_index();
      if (success && !input_data_view.ReadDefaultExtension(&p_default_extension))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SelectFileDialog::Name_, 0, false);
        return false;
      }
      auto callback =
          SelectFileDialog_Show_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Show(        
        std::move(p_type), 
        std::move(p_title), 
        std::move(p_file_path), 
        std::move(p_file_types), 
        std::move(p_file_type_index), 
        std::move(p_default_extension), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSelectFileDialogValidationInfo[] = {
    { &internal::SelectFileDialog_Show_Params_Data::Validate,
     &internal::SelectFileDialog_Show_ResponseParams_Data::Validate},
};

bool SelectFileDialogRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::remote_cocoa::mojom::SelectFileDialog::Name_,
    kSelectFileDialogValidationInfo);
}

bool SelectFileDialogResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::remote_cocoa::mojom::SelectFileDialog::Name_,
    kSelectFileDialogValidationInfo);
}


}  // remote_cocoa::mojom


namespace mojo {


// static
bool StructTraits<::remote_cocoa::mojom::SelectFileTypeInfo::DataView, ::remote_cocoa::mojom::SelectFileTypeInfoPtr>::Read(
    ::remote_cocoa::mojom::SelectFileTypeInfo::DataView input,
    ::remote_cocoa::mojom::SelectFileTypeInfoPtr* output) {
  bool success = true;
  ::remote_cocoa::mojom::SelectFileTypeInfoPtr result(::remote_cocoa::mojom::SelectFileTypeInfo::New());
  
      if (success && !input.ReadExtensions(&result->extensions))
        success = false;
      if (success && !input.ReadExtensionDescriptionOverrides(&result->extension_description_overrides))
        success = false;
      if (success)
        result->include_all_files = input.include_all_files();
      if (success)
        result->keep_extension_visible = input.keep_extension_visible();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace remote_cocoa::mojom {


void SelectFileDialogInterceptorForTesting::Show(SelectFileDialogType type, const ::std::u16string& title, const ::base::FilePath& file_path, SelectFileTypeInfoPtr file_types, int32_t file_type_index, const std::string& default_extension, ShowCallback callback) {
  GetForwardingInterface()->Show(
    std::move(type)
    , 
    std::move(title)
    , 
    std::move(file_path)
    , 
    std::move(file_types)
    , 
    std::move(file_type_index)
    , 
    std::move(default_extension)
    , std::move(callback));
}
SelectFileDialogAsyncWaiter::SelectFileDialogAsyncWaiter(
    SelectFileDialog* proxy) : proxy_(proxy) {}

SelectFileDialogAsyncWaiter::~SelectFileDialogAsyncWaiter() = default;


void SelectFileDialogAsyncWaiter::Show(
    SelectFileDialogType type, const ::std::u16string& title, const ::base::FilePath& file_path, SelectFileTypeInfoPtr file_types, int32_t file_type_index, const std::string& default_extension, bool* out_was_cancelled, std::vector<::base::FilePath>* out_files, int32_t* out_index, std::vector<std::string>* out_file_tags) {
  base::RunLoop loop;
  proxy_->Show(
      std::move(type),
      std::move(title),
      std::move(file_path),
      std::move(file_types),
      std::move(file_type_index),
      std::move(default_extension),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_was_cancelled
,
             std::vector<::base::FilePath>* out_files
,
             int32_t* out_index
,
             std::vector<std::string>* out_file_tags
,
             bool was_cancelled,
             const std::vector<::base::FilePath>& files,
             int32_t index,
             const std::vector<std::string>& file_tags) {*out_was_cancelled = std::move(was_cancelled);*out_files = std::move(files);*out_index = std::move(index);*out_file_tags = std::move(file_tags);
            loop->Quit();
          },
          &loop,
          out_was_cancelled,
          out_files,
          out_index,
          out_file_tags));
  loop.Run();
}








}  // remote_cocoa::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif