// components/remote_cocoa/common/native_widget_ns_window.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_NATIVE_WIDGET_NS_WINDOW_MOJOM_SHARED_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_NATIVE_WIDGET_NS_WINDOW_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/remote_cocoa/common/native_widget_ns_window.mojom-shared-internal.h"
#include "components/remote_cocoa/common/select_file_dialog.mojom-shared.h"
#include "components/remote_cocoa/common/menu.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "ui/base/cursor/mojom/cursor.mojom-shared.h"
#include "ui/base/mojom/color_mode.mojom-shared.h"
#include "ui/base/mojom/ui_base_types.mojom-shared.h"
#include "ui/events/mojom/event_constants.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/ca_layer_params.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/remote_cocoa/common/native_widget_ns_window.mojom-data-view.h"




namespace std {

template <>
struct hash<::remote_cocoa::mojom::WindowClass>
    : public mojo::internal::EnumHashImpl<::remote_cocoa::mojom::WindowClass> {};

template <>
struct hash<::remote_cocoa::mojom::WindowVisibilityState>
    : public mojo::internal::EnumHashImpl<::remote_cocoa::mojom::WindowVisibilityState> {};

template <>
struct hash<::remote_cocoa::mojom::VisibilityTransition>
    : public mojo::internal::EnumHashImpl<::remote_cocoa::mojom::VisibilityTransition> {};

template <>
struct hash<::remote_cocoa::mojom::ToolbarVisibilityStyle>
    : public mojo::internal::EnumHashImpl<::remote_cocoa::mojom::ToolbarVisibilityStyle> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::remote_cocoa::mojom::WindowClass, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::remote_cocoa::mojom::WindowClass, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::remote_cocoa::mojom::WindowClass>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::remote_cocoa::mojom::WindowVisibilityState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::remote_cocoa::mojom::WindowVisibilityState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::remote_cocoa::mojom::WindowVisibilityState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::remote_cocoa::mojom::VisibilityTransition, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::remote_cocoa::mojom::VisibilityTransition, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::remote_cocoa::mojom::VisibilityTransition>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::remote_cocoa::mojom::ToolbarVisibilityStyle, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::remote_cocoa::mojom::ToolbarVisibilityStyle, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::remote_cocoa::mojom::ToolbarVisibilityStyle>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::remote_cocoa::mojom::CreateWindowParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::remote_cocoa::mojom::CreateWindowParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::remote_cocoa::mojom::internal::CreateWindowParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::remote_cocoa::mojom::WindowClass>(
      Traits::window_class(input),
      &fragment->window_class);

    fragment->style_mask = Traits::style_mask(input);

    fragment->titlebar_appears_transparent = Traits::titlebar_appears_transparent(input);

    fragment->window_title_hidden = Traits::window_title_hidden(input);

    fragment->animation_enabled = Traits::animation_enabled(input);
  }

  static bool Deserialize(::remote_cocoa::mojom::internal::CreateWindowParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::remote_cocoa::mojom::CreateWindowParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::remote_cocoa::mojom::internal::NativeWidgetNSWindowInitParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::ui::mojom::ModalType>(
      Traits::modal_type(input),
      &fragment->modal_type);

    fragment->is_translucent = Traits::is_translucent(input);

    fragment->has_window_server_shadow = Traits::has_window_server_shadow(input);

    fragment->force_into_collection_cycle = Traits::force_into_collection_cycle(input);

    decltype(Traits::state_restoration_data(input)) in_state_restoration_data = Traits::state_restoration_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->state_restoration_data)::BaseType>
        state_restoration_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& state_restoration_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_state_restoration_data,
      state_restoration_data_fragment,
      &state_restoration_data_validate_params);

    fragment->state_restoration_data.Set(
        state_restoration_data_fragment.is_null() ? nullptr : state_restoration_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->state_restoration_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state_restoration_data in NativeWidgetNSWindowInitParams struct");

    fragment->is_tooltip = Traits::is_tooltip(input);
  }

  static bool Deserialize(::remote_cocoa::mojom::internal::NativeWidgetNSWindowInitParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace remote_cocoa::mojom {



inline void NativeWidgetNSWindowInitParamsDataView::GetStateRestorationDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->state_restoration_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}



}  // remote_cocoa::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::remote_cocoa::mojom::WindowClass> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::remote_cocoa::mojom::WindowClass value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::remote_cocoa::mojom::WindowVisibilityState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::remote_cocoa::mojom::WindowVisibilityState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::remote_cocoa::mojom::VisibilityTransition> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::remote_cocoa::mojom::VisibilityTransition value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::remote_cocoa::mojom::ToolbarVisibilityStyle> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::remote_cocoa::mojom::ToolbarVisibilityStyle value);
};

} // namespace perfetto

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_NATIVE_WIDGET_NS_WINDOW_MOJOM_SHARED_H_